/*
 * Copyright 2000-2008 Sun Microsystems, Inc.  All Rights Reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Sun Microsystems, Inc., 4150 Network Circle, Santa Clara,
 * CA 95054 USA or visit www.sun.com if you need additional information or
 * have any questions.
 *
 */


package com.sun.java.swing.ui;

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JDialog;
import javax.swing.JPanel;

// Referenced classes of package com.sun.java.swing.ui:
//            OkCancelButtonPanel, CommonUI

public class OkCancelDialog extends JDialog
    implements ActionListener
{

    public OkCancelDialog(String title, JPanel panel)
    {
        this(title, panel, true);
    }

    public OkCancelDialog(String title, JPanel panel, boolean modal)
    {
        setTitle(title);
        setModal(modal);
        Container pane = getContentPane();
        pane.setLayout(new BorderLayout());
        pane.add(panel, "Center");
        pane.add(new OkCancelButtonPanel(this), "South");
        pack();
        CommonUI.centerComponent(this);
    }

    public boolean isOk()
    {
        return okPressed;
    }

    public void actionPerformed(ActionEvent evt)
    {
        String command = evt.getActionCommand();
        if(command.equals("ok-command"))
        {
            okPressed = true;
            setVisible(false);
            dispose();
        } else
        if(command.equals("cancel-command"))
        {
            okPressed = false;
            setVisible(false);
            dispose();
        }
    }

    private boolean okPressed;
}
