/*
 * Copyright (C) 2012 Canonical, Ltd.
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License
 * version 3.0 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3.0 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see
 * <http://www.gnu.org/licenses/>.
 *
 * Authored by Didier Roche <didrocks@ubuntu.com>
 *
 */

using Gee;

namespace Unity {

  /**
   * A singleton class that caches different gsettings settings.
   *
   */
  public class PreferencesManager : GLib.Object
  {
    private static PreferencesManager singleton = null;

    private Settings gp_settings;
    private const string REMOTE_CONTENT_KEY = "remote-content-search";

    public enum RemoteContent
    {
      ALL,
      NONE,
    }
    
    private PreferencesManager ()
    {
      Object();
    }

    construct
    {
      gp_settings = new Settings ("com.canonical.Unity.Lenses");
      gp_settings.bind (REMOTE_CONTENT_KEY, this, "remote_content_search", SettingsBindFlags.GET);
    }

    public RemoteContent remote_content_search { get; set; default = RemoteContent.ALL; }
    
    /**
     * Get a ref to the singleton PreferencesManager
     */
    public static PreferencesManager get_default ()
    {
      if (PreferencesManager.singleton == null)
        PreferencesManager.singleton = new PreferencesManager();
      
      return PreferencesManager.singleton;
    }
    
  } /* class PreferencesManager */

} /* namespace */
