/* unity-appinfo-manager.c generated by valac 0.14.2, the Vala compiler
 * generated from unity-appinfo-manager.vala, do not modify */

/*
 * Copyright (C) 2010 Canonical, Ltd.
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License
 * version 3.0 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3.0 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see
 * <http://www.gnu.org/licenses/>.
 *
 * Authored by Mikkel Kamstrup Erlandsen <mikkel.kamstrup@canonical.com>
 *
 */
/*
 * IMPLEMENTATION NOTE:
 * We want the generatedd C API to be nice and not too Vala-ish. We must
 * anticipate that place daemons consuming libunity will be written in
 * both Vala and C.
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include "unity.h"
#include <gio/gio.h>
#include <unity-trace.h>
#include <gio/gdesktopappinfo.h>
#include <gobject/gvaluecollector.h>


#define UNITY_TYPE_STRING_ARRAY_WRAPPER (unity_string_array_wrapper_get_type ())
#define UNITY_STRING_ARRAY_WRAPPER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_TYPE_STRING_ARRAY_WRAPPER, UnityStringArrayWrapper))
#define UNITY_STRING_ARRAY_WRAPPER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_TYPE_STRING_ARRAY_WRAPPER, UnityStringArrayWrapperClass))
#define UNITY_IS_STRING_ARRAY_WRAPPER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_TYPE_STRING_ARRAY_WRAPPER))
#define UNITY_IS_STRING_ARRAY_WRAPPER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_TYPE_STRING_ARRAY_WRAPPER))
#define UNITY_STRING_ARRAY_WRAPPER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_TYPE_STRING_ARRAY_WRAPPER, UnityStringArrayWrapperClass))

typedef struct _UnityStringArrayWrapper UnityStringArrayWrapper;
typedef struct _UnityStringArrayWrapperClass UnityStringArrayWrapperClass;
typedef struct _UnityStringArrayWrapperPrivate UnityStringArrayWrapperPrivate;
typedef struct _UnityParamSpecStringArrayWrapper UnityParamSpecStringArrayWrapper;
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_key_file_free0(var) ((var == NULL) ? NULL : (var = (g_key_file_free (var), NULL)))
#define _unity_string_array_wrapper_unref0(var) ((var == NULL) ? NULL : (var = (unity_string_array_wrapper_unref (var), NULL)))
typedef struct _UnityAppInfoManagerLookupAsyncData UnityAppInfoManagerLookupAsyncData;

struct _UnityStringArrayWrapper {
	GTypeInstance parent_instance;
	volatile int ref_count;
	UnityStringArrayWrapperPrivate * priv;
	gchar** strings;
	gint strings_length1;
	gint _strings_size_;
};

struct _UnityStringArrayWrapperClass {
	GTypeClass parent_class;
	void (*finalize) (UnityStringArrayWrapper *self);
};

struct _UnityParamSpecStringArrayWrapper {
	GParamSpec parent_instance;
};

struct _UnityAppInfoManagerPrivate {
	GHashTable* appinfo_by_id;
	GHashTable* monitors;
	GHashTable* categories_by_id;
	GHashTable* keywords_by_id;
	GHashTable* paths_by_id;
};

struct _UnityAppInfoManagerLookupAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	UnityAppInfoManager* self;
	gchar* id;
	GAppInfo* result;
	GHashTable* _tmp0_;
	const gchar* _tmp1_;
	gboolean _tmp2_;
	GHashTable* _tmp3_;
	const gchar* _tmp4_;
	gconstpointer _tmp5_;
	GAppInfo* _tmp6_;
	gsize data_size;
	guint8* data;
	gint data_length1;
	gint _data_size_;
	GFileInputStream* input;
	const gchar* _tmp7_;
	gboolean _tmp8_;
	const gchar* _tmp9_;
	GFile* _tmp10_;
	GFile* f;
	GFile* _tmp11_;
	GFileInputStream* _tmp12_;
	GFileInputStream* _tmp13_;
	GFile* _tmp14_;
	GFile* _tmp15_;
	GFile* dir;
	GFile* _tmp16_;
	gchar* _tmp17_;
	gchar* dir_uri;
	GHashTable* _tmp18_;
	const gchar* _tmp19_;
	gconstpointer _tmp20_;
	GFile* _tmp21_;
	GFileMonitor* _tmp22_;
	GFileMonitor* monitor;
	GFileMonitor* _tmp23_;
	GHashTable* _tmp24_;
	const gchar* _tmp25_;
	gchar* _tmp26_;
	GFileMonitor* _tmp27_;
	GFileMonitor* _tmp28_;
	const gchar* _tmp29_;
	GError* ioe;
	const gchar* _tmp30_;
	GError* _tmp31_;
	const gchar* _tmp32_;
	const gchar* _tmp33_;
	gchar* _tmp34_;
	gchar* path;
	const gchar* _tmp35_;
	GFileInputStream* _tmp36_;
	GFileInputStream* _tmp37_;
	GFileInputStream* _tmp38_;
	GHashTable* _tmp39_;
	const gchar* _tmp40_;
	gchar* _tmp41_;
	GFileInputStream* _tmp42_;
	guint8* _tmp43_;
	gint _tmp44_;
	gsize _tmp45_;
	GError* e;
	const gchar* _tmp46_;
	GError* _tmp47_;
	const gchar* _tmp48_;
	GKeyFile* _tmp49_;
	GKeyFile* keyfile;
	GKeyFile* _tmp50_;
	guint8* _tmp51_;
	gint _tmp51__length1;
	gsize _tmp52_;
	GError* ee;
	const gchar* _tmp53_;
	GError* _tmp54_;
	const gchar* _tmp55_;
	GKeyFile* _tmp56_;
	GDesktopAppInfo* _tmp57_;
	GDesktopAppInfo* appinfo;
	GHashTable* _tmp58_;
	const gchar* _tmp59_;
	gchar* _tmp60_;
	GDesktopAppInfo* _tmp61_;
	GAppInfo* _tmp62_;
	const gchar* _tmp63_;
	GKeyFile* _tmp64_;
	const gchar* _tmp65_;
	GKeyFile* _tmp66_;
	GError * _inner_error_;
};


static gpointer unity_string_array_wrapper_parent_class = NULL;
static gpointer unity_app_info_manager_parent_class = NULL;
static UnityAppInfoManager* unity_app_info_manager_singleton;
static UnityAppInfoManager* unity_app_info_manager_singleton = NULL;

gpointer unity_string_array_wrapper_ref (gpointer instance);
void unity_string_array_wrapper_unref (gpointer instance);
GParamSpec* unity_param_spec_string_array_wrapper (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void unity_value_set_string_array_wrapper (GValue* value, gpointer v_object);
void unity_value_take_string_array_wrapper (GValue* value, gpointer v_object);
gpointer unity_value_get_string_array_wrapper (const GValue* value);
GType unity_string_array_wrapper_get_type (void) G_GNUC_CONST;
enum  {
	UNITY_STRING_ARRAY_WRAPPER_DUMMY_PROPERTY
};
void unity_string_array_wrapper_take_strings (UnityStringArrayWrapper* self, gchar** str_arr, int str_arr_length1);
UnityStringArrayWrapper* unity_string_array_wrapper_new (void);
UnityStringArrayWrapper* unity_string_array_wrapper_construct (GType object_type);
static void unity_string_array_wrapper_finalize (UnityStringArrayWrapper* obj);
#define UNITY_APP_INFO_MANAGER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), UNITY_TYPE_APP_INFO_MANAGER, UnityAppInfoManagerPrivate))
enum  {
	UNITY_APP_INFO_MANAGER_DUMMY_PROPERTY
};
static UnityAppInfoManager* unity_app_info_manager_new (void);
static UnityAppInfoManager* unity_app_info_manager_construct (GType object_type);
static void _g_free0_ (gpointer var);
static void _g_object_unref0_ (gpointer var);
static void _unity_string_array_wrapper_unref0_ (gpointer var);
static void unity_app_info_manager_on_dir_changed (UnityAppInfoManager* self, GFileMonitor* mon, GFile* file, GFile* other_file, GFileMonitorEvent e);
static void _unity_app_info_manager_on_dir_changed_g_file_monitor_changed (GFileMonitor* _sender, GFile* file, GFile* other_file, GFileMonitorEvent event_type, gpointer self);
static void unity_app_info_manager_register_categories (UnityAppInfoManager* self, const gchar* id, GKeyFile* keyfile);
static void unity_app_info_manager_register_keywords (UnityAppInfoManager* self, const gchar* id, GKeyFile* keyfile);
static void unity_app_info_manager_lookup_async_data_free (gpointer _data);
static gboolean unity_app_info_manager_lookup_async_co (UnityAppInfoManagerLookupAsyncData* _data_);
static void unity_app_info_manager_lookup_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void g_cclosure_user_marshal_VOID__STRING_OBJECT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void unity_app_info_manager_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


void unity_string_array_wrapper_take_strings (UnityStringArrayWrapper* self, gchar** str_arr, int str_arr_length1) {
	gchar** _tmp0_;
	gint _tmp0__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = str_arr;
	_tmp0__length1 = str_arr_length1;
	str_arr = NULL;
	self->strings = (_vala_array_free (self->strings, self->strings_length1, (GDestroyNotify) g_free), NULL);
	self->strings = _tmp0_;
	self->strings_length1 = _tmp0__length1;
	self->_strings_size_ = self->strings_length1;
	str_arr = (_vala_array_free (str_arr, str_arr_length1, (GDestroyNotify) g_free), NULL);
}


UnityStringArrayWrapper* unity_string_array_wrapper_construct (GType object_type) {
	UnityStringArrayWrapper* self = NULL;
	self = (UnityStringArrayWrapper*) g_type_create_instance (object_type);
	return self;
}


UnityStringArrayWrapper* unity_string_array_wrapper_new (void) {
	return unity_string_array_wrapper_construct (UNITY_TYPE_STRING_ARRAY_WRAPPER);
}


static void unity_value_string_array_wrapper_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void unity_value_string_array_wrapper_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		unity_string_array_wrapper_unref (value->data[0].v_pointer);
	}
}


static void unity_value_string_array_wrapper_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = unity_string_array_wrapper_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer unity_value_string_array_wrapper_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* unity_value_string_array_wrapper_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		UnityStringArrayWrapper* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = unity_string_array_wrapper_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* unity_value_string_array_wrapper_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	UnityStringArrayWrapper** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = unity_string_array_wrapper_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* unity_param_spec_string_array_wrapper (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	UnityParamSpecStringArrayWrapper* spec;
	g_return_val_if_fail (g_type_is_a (object_type, UNITY_TYPE_STRING_ARRAY_WRAPPER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer unity_value_get_string_array_wrapper (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, UNITY_TYPE_STRING_ARRAY_WRAPPER), NULL);
	return value->data[0].v_pointer;
}


void unity_value_set_string_array_wrapper (GValue* value, gpointer v_object) {
	UnityStringArrayWrapper* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, UNITY_TYPE_STRING_ARRAY_WRAPPER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, UNITY_TYPE_STRING_ARRAY_WRAPPER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		unity_string_array_wrapper_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		unity_string_array_wrapper_unref (old);
	}
}


void unity_value_take_string_array_wrapper (GValue* value, gpointer v_object) {
	UnityStringArrayWrapper* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, UNITY_TYPE_STRING_ARRAY_WRAPPER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, UNITY_TYPE_STRING_ARRAY_WRAPPER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		unity_string_array_wrapper_unref (old);
	}
}


static void unity_string_array_wrapper_class_init (UnityStringArrayWrapperClass * klass) {
	unity_string_array_wrapper_parent_class = g_type_class_peek_parent (klass);
	UNITY_STRING_ARRAY_WRAPPER_CLASS (klass)->finalize = unity_string_array_wrapper_finalize;
}


static void unity_string_array_wrapper_instance_init (UnityStringArrayWrapper * self) {
	self->ref_count = 1;
}


static void unity_string_array_wrapper_finalize (UnityStringArrayWrapper* obj) {
	UnityStringArrayWrapper * self;
	self = UNITY_STRING_ARRAY_WRAPPER (obj);
	self->strings = (_vala_array_free (self->strings, self->strings_length1, (GDestroyNotify) g_free), NULL);
}


GType unity_string_array_wrapper_get_type (void) {
	static volatile gsize unity_string_array_wrapper_type_id__volatile = 0;
	if (g_once_init_enter (&unity_string_array_wrapper_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { unity_value_string_array_wrapper_init, unity_value_string_array_wrapper_free_value, unity_value_string_array_wrapper_copy_value, unity_value_string_array_wrapper_peek_pointer, "p", unity_value_string_array_wrapper_collect_value, "p", unity_value_string_array_wrapper_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (UnityStringArrayWrapperClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) unity_string_array_wrapper_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UnityStringArrayWrapper), 0, (GInstanceInitFunc) unity_string_array_wrapper_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType unity_string_array_wrapper_type_id;
		unity_string_array_wrapper_type_id = g_type_register_fundamental (g_type_fundamental_next (), "UnityStringArrayWrapper", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&unity_string_array_wrapper_type_id__volatile, unity_string_array_wrapper_type_id);
	}
	return unity_string_array_wrapper_type_id__volatile;
}


gpointer unity_string_array_wrapper_ref (gpointer instance) {
	UnityStringArrayWrapper* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void unity_string_array_wrapper_unref (gpointer instance) {
	UnityStringArrayWrapper* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		UNITY_STRING_ARRAY_WRAPPER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _unity_string_array_wrapper_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (unity_string_array_wrapper_unref (var), NULL));
}


static void _unity_app_info_manager_on_dir_changed_g_file_monitor_changed (GFileMonitor* _sender, GFile* file, GFile* other_file, GFileMonitorEvent event_type, gpointer self) {
	unity_app_info_manager_on_dir_changed (self, _sender, file, other_file, event_type);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static UnityAppInfoManager* unity_app_info_manager_construct (GType object_type) {
	UnityAppInfoManager * self = NULL;
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	GHashFunc _tmp3_;
	GEqualFunc _tmp4_;
	GHashTable* _tmp5_;
	GHashFunc _tmp6_;
	GEqualFunc _tmp7_;
	GHashTable* _tmp8_;
	GHashFunc _tmp9_;
	GEqualFunc _tmp10_;
	GHashTable* _tmp11_;
	GHashFunc _tmp12_;
	GEqualFunc _tmp13_;
	GHashTable* _tmp14_;
	gint _tmp15_ = 0;
	gchar** _tmp16_ = NULL;
	GError * _inner_error_ = NULL;
	self = (UnityAppInfoManager*) g_object_new (object_type, NULL);
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, _g_free0_, _g_object_unref0_);
	_g_hash_table_unref0 (self->priv->appinfo_by_id);
	self->priv->appinfo_by_id = _tmp2_;
	_tmp3_ = g_str_hash;
	_tmp4_ = g_str_equal;
	_tmp5_ = g_hash_table_new_full (_tmp3_, _tmp4_, _g_free0_, _unity_string_array_wrapper_unref0_);
	_g_hash_table_unref0 (self->priv->categories_by_id);
	self->priv->categories_by_id = _tmp5_;
	_tmp6_ = g_str_hash;
	_tmp7_ = g_str_equal;
	_tmp8_ = g_hash_table_new_full (_tmp6_, _tmp7_, _g_free0_, _unity_string_array_wrapper_unref0_);
	_g_hash_table_unref0 (self->priv->keywords_by_id);
	self->priv->keywords_by_id = _tmp8_;
	_tmp9_ = g_str_hash;
	_tmp10_ = g_str_equal;
	_tmp11_ = g_hash_table_new_full (_tmp9_, _tmp10_, _g_free0_, _g_free0_);
	_g_hash_table_unref0 (self->priv->paths_by_id);
	self->priv->paths_by_id = _tmp11_;
	_tmp12_ = g_str_hash;
	_tmp13_ = g_str_equal;
	_tmp14_ = g_hash_table_new_full (_tmp12_, _tmp13_, _g_free0_, _g_object_unref0_);
	_g_hash_table_unref0 (self->priv->monitors);
	self->priv->monitors = _tmp14_;
	_tmp16_ = unity_io_get_system_data_dirs (&_tmp15_);
	{
		gchar** path_collection = NULL;
		gint path_collection_length1 = 0;
		gint _path_collection_size_ = 0;
		gint path_it = 0;
		path_collection = _tmp16_;
		path_collection_length1 = _tmp15_;
		for (path_it = 0; path_it < _tmp15_; path_it = path_it + 1) {
			gchar* _tmp17_;
			gchar* path = NULL;
			_tmp17_ = g_strdup (path_collection[path_it]);
			path = _tmp17_;
			{
				const gchar* _tmp18_;
				gchar* _tmp19_ = NULL;
				gchar* _tmp20_;
				GFile* _tmp21_ = NULL;
				GFile* _tmp22_;
				GFile* dir;
				_tmp18_ = path;
				_tmp19_ = g_build_filename (_tmp18_, "applications", NULL);
				_tmp20_ = _tmp19_;
				_tmp21_ = g_file_new_for_path (_tmp20_);
				_tmp22_ = _tmp21_;
				_g_free0 (_tmp20_);
				dir = _tmp22_;
				{
					GFile* _tmp23_;
					GFileMonitor* _tmp24_ = NULL;
					GFileMonitor* monitor;
					GFileMonitor* _tmp25_;
					GHashTable* _tmp26_;
					GFile* _tmp27_;
					gchar* _tmp28_ = NULL;
					GFileMonitor* _tmp29_;
					GFileMonitor* _tmp30_;
					_tmp23_ = dir;
					_tmp24_ = g_file_monitor_directory (_tmp23_, G_FILE_MONITOR_NONE, NULL, &_inner_error_);
					monitor = _tmp24_;
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == G_IO_ERROR) {
							goto __catch0_g_io_error;
						}
						_g_object_unref0 (dir);
						_g_free0 (path);
						path_collection = (_vala_array_free (path_collection, path_collection_length1, (GDestroyNotify) g_free), NULL);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
					_tmp25_ = monitor;
					g_signal_connect_object (_tmp25_, "changed", (GCallback) _unity_app_info_manager_on_dir_changed_g_file_monitor_changed, self, 0);
					_tmp26_ = self->priv->monitors;
					_tmp27_ = dir;
					_tmp28_ = g_file_get_uri (_tmp27_);
					_tmp29_ = monitor;
					_tmp30_ = _g_object_ref0 (_tmp29_);
					g_hash_table_insert (_tmp26_, _tmp28_, _tmp30_);
					_g_object_unref0 (monitor);
				}
				goto __finally0;
				__catch0_g_io_error:
				{
					GError* e = NULL;
					GFile* _tmp31_;
					gchar* _tmp32_ = NULL;
					gchar* _tmp33_;
					GError* _tmp34_;
					const gchar* _tmp35_;
					e = _inner_error_;
					_inner_error_ = NULL;
					_tmp31_ = dir;
					_tmp32_ = g_file_get_uri (_tmp31_);
					_tmp33_ = _tmp32_;
					_tmp34_ = e;
					_tmp35_ = _tmp34_->message;
					g_warning ("unity-appinfo-manager.vala:83: Error setting up directory monitor on '" \
"%s': %s", _tmp33_, _tmp35_);
					_g_free0 (_tmp33_);
					_g_error_free0 (e);
				}
				__finally0:
				if (_inner_error_ != NULL) {
					_g_object_unref0 (dir);
					_g_free0 (path);
					path_collection = (_vala_array_free (path_collection, path_collection_length1, (GDestroyNotify) g_free), NULL);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
				_g_object_unref0 (dir);
				_g_free0 (path);
			}
		}
		path_collection = (_vala_array_free (path_collection, path_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	return self;
}


static UnityAppInfoManager* unity_app_info_manager_new (void) {
	return unity_app_info_manager_construct (UNITY_TYPE_APP_INFO_MANAGER);
}


UnityAppInfoManager* unity_app_info_manager_get_instance (void) {
	UnityAppInfoManager* result = NULL;
	UnityAppInfoManager* _tmp0_ = NULL;
	_tmp0_ = unity_app_info_manager_get_default ();
	result = _tmp0_;
	return result;
}


/**
     * Get a ref to the singleton AppInfoManager
     */
UnityAppInfoManager* unity_app_info_manager_get_default (void) {
	UnityAppInfoManager* result = NULL;
	UnityAppInfoManager* _tmp0_;
	UnityAppInfoManager* _tmp2_;
	UnityAppInfoManager* _tmp3_;
	_tmp0_ = unity_app_info_manager_singleton;
	if (_tmp0_ == NULL) {
		UnityAppInfoManager* _tmp1_;
		_tmp1_ = unity_app_info_manager_new ();
		_g_object_unref0 (unity_app_info_manager_singleton);
		unity_app_info_manager_singleton = _tmp1_;
	}
	_tmp2_ = unity_app_info_manager_singleton;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	result = _tmp3_;
	return result;
}


static void unity_app_info_manager_on_dir_changed (UnityAppInfoManager* self, GFileMonitor* mon, GFile* file, GFile* other_file, GFileMonitorEvent e) {
	GFile* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* desktop_id;
	GFile* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* path;
	GAppInfo* appinfo = NULL;
	GHashTable* _tmp4_;
	const gchar* _tmp5_;
	gboolean _tmp6_ = FALSE;
	GHashTable* _tmp11_;
	const gchar* _tmp12_;
	gboolean _tmp13_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (mon != NULL);
	g_return_if_fail (file != NULL);
	_tmp0_ = file;
	_tmp1_ = g_file_get_basename (_tmp0_);
	desktop_id = _tmp1_;
	_tmp2_ = file;
	_tmp3_ = g_file_get_path (_tmp2_);
	path = _tmp3_;
	_tmp4_ = self->priv->appinfo_by_id;
	_tmp5_ = desktop_id;
	_tmp6_ = g_hash_table_remove (_tmp4_, _tmp5_);
	if (_tmp6_) {
		const gchar* _tmp7_;
		GAppInfo* _tmp8_ = NULL;
		const gchar* _tmp9_;
		GAppInfo* _tmp10_;
		_tmp7_ = desktop_id;
		_tmp8_ = unity_app_info_manager_lookup (self, _tmp7_);
		_g_object_unref0 (appinfo);
		appinfo = _tmp8_;
		_tmp9_ = desktop_id;
		_tmp10_ = appinfo;
		g_signal_emit_by_name (self, "changed", _tmp9_, _tmp10_);
	}
	_tmp11_ = self->priv->appinfo_by_id;
	_tmp12_ = path;
	_tmp13_ = g_hash_table_remove (_tmp11_, _tmp12_);
	if (_tmp13_) {
		const gchar* _tmp14_;
		GAppInfo* _tmp15_ = NULL;
		const gchar* _tmp16_;
		GAppInfo* _tmp17_;
		_tmp14_ = path;
		_tmp15_ = unity_app_info_manager_lookup (self, _tmp14_);
		_g_object_unref0 (appinfo);
		appinfo = _tmp15_;
		_tmp16_ = path;
		_tmp17_ = appinfo;
		g_signal_emit_by_name (self, "changed", _tmp16_, _tmp17_);
	}
	_g_object_unref0 (appinfo);
	_g_free0 (path);
	_g_free0 (desktop_id);
}


/**
     * Look up an AppInfo given its desktop id or absolute path. The desktop id
     * is the base filename of the .desktop file for the application including
     * the .desktop extension.
     *
     * If the AppInfo is not already cached this method will do synchronous
     * IO to look it up.
     */
GAppInfo* unity_app_info_manager_lookup (UnityAppInfoManager* self, const gchar* id) {
	GAppInfo* result = NULL;
	GHashTable* _tmp0_;
	const gchar* _tmp1_;
	gboolean _tmp2_ = FALSE;
	GAppInfo* appinfo = NULL;
	GKeyFile* _tmp7_;
	GKeyFile* keyfile;
	const gchar* _tmp8_;
	gboolean _tmp9_ = FALSE;
	GKeyFile* _tmp74_;
	GHashTable* _tmp81_;
	const gchar* _tmp82_;
	gchar* _tmp83_;
	GAppInfo* _tmp84_;
	GAppInfo* _tmp85_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (id != NULL, NULL);
	_tmp0_ = self->priv->appinfo_by_id;
	_tmp1_ = id;
	_tmp2_ = g_hash_table_lookup_extended (_tmp0_, _tmp1_, NULL, NULL);
	if (_tmp2_) {
		GHashTable* _tmp3_;
		const gchar* _tmp4_;
		gconstpointer _tmp5_ = NULL;
		GAppInfo* _tmp6_;
		_tmp3_ = self->priv->appinfo_by_id;
		_tmp4_ = id;
		_tmp5_ = g_hash_table_lookup (_tmp3_, _tmp4_);
		_tmp6_ = _g_object_ref0 ((GAppInfo*) _tmp5_);
		result = _tmp6_;
		return result;
	}
	_tmp7_ = g_key_file_new ();
	keyfile = _tmp7_;
	_tmp8_ = id;
	_tmp9_ = g_str_has_prefix (_tmp8_, "/");
	if (_tmp9_) {
		GHashTable* _tmp10_;
		const gchar* _tmp11_;
		gchar* _tmp12_;
		const gchar* _tmp13_;
		gchar* _tmp14_;
		const gchar* _tmp24_;
		GFile* _tmp25_ = NULL;
		GFile* _tmp26_;
		GFile* _tmp27_ = NULL;
		GFile* _tmp28_;
		GFile* dir;
		GFile* _tmp29_;
		gchar* _tmp30_ = NULL;
		gchar* dir_uri;
		GHashTable* _tmp31_;
		const gchar* _tmp32_;
		gconstpointer _tmp33_ = NULL;
		_tmp10_ = self->priv->paths_by_id;
		_tmp11_ = id;
		_tmp12_ = g_strdup (_tmp11_);
		_tmp13_ = id;
		_tmp14_ = g_strdup (_tmp13_);
		g_hash_table_insert (_tmp10_, _tmp12_, _tmp14_);
		{
			GKeyFile* _tmp15_;
			const gchar* _tmp16_;
			_tmp15_ = keyfile;
			_tmp16_ = id;
			g_key_file_load_from_file (_tmp15_, _tmp16_, G_KEY_FILE_NONE, &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch1_g_error;
			}
		}
		goto __finally1;
		__catch1_g_error:
		{
			GError* e = NULL;
			gboolean _tmp17_ = FALSE;
			GError* _tmp18_;
			gboolean _tmp20_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_g_key_file_free0 (keyfile);
			keyfile = NULL;
			_tmp18_ = e;
			if (g_error_matches (_tmp18_, G_IO_ERROR, G_IO_ERROR_NOT_FOUND)) {
				_tmp17_ = TRUE;
			} else {
				GError* _tmp19_;
				_tmp19_ = e;
				_tmp17_ = g_error_matches (_tmp19_, G_KEY_FILE_ERROR, G_KEY_FILE_ERROR_NOT_FOUND);
			}
			_tmp20_ = _tmp17_;
			if (!_tmp20_) {
				const gchar* _tmp21_;
				GError* _tmp22_;
				const gchar* _tmp23_;
				_tmp21_ = id;
				_tmp22_ = e;
				_tmp23_ = _tmp22_->message;
				g_warning ("unity-appinfo-manager.vala:159: Error loading '%s': %s", _tmp21_, _tmp23_);
			}
			_g_error_free0 (e);
		}
		__finally1:
		if (_inner_error_ != NULL) {
			_g_key_file_free0 (keyfile);
			_g_object_unref0 (appinfo);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp24_ = id;
		_tmp25_ = g_file_new_for_path (_tmp24_);
		_tmp26_ = _tmp25_;
		_tmp27_ = g_file_get_parent (_tmp26_);
		_tmp28_ = _tmp27_;
		_g_object_unref0 (_tmp26_);
		dir = _tmp28_;
		_tmp29_ = dir;
		_tmp30_ = g_file_get_uri (_tmp29_);
		dir_uri = _tmp30_;
		_tmp31_ = self->priv->monitors;
		_tmp32_ = dir_uri;
		_tmp33_ = g_hash_table_lookup (_tmp31_, _tmp32_);
		if (((GFileMonitor*) _tmp33_) == NULL) {
			{
				GFile* _tmp34_;
				GFileMonitor* _tmp35_ = NULL;
				GFileMonitor* monitor;
				GFileMonitor* _tmp36_;
				GHashTable* _tmp37_;
				const gchar* _tmp38_;
				gchar* _tmp39_;
				GFileMonitor* _tmp40_;
				GFileMonitor* _tmp41_;
				const gchar* _tmp42_;
				_tmp34_ = dir;
				_tmp35_ = g_file_monitor_directory (_tmp34_, G_FILE_MONITOR_NONE, NULL, &_inner_error_);
				monitor = _tmp35_;
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == G_IO_ERROR) {
						goto __catch2_g_io_error;
					}
					_g_free0 (dir_uri);
					_g_object_unref0 (dir);
					_g_key_file_free0 (keyfile);
					_g_object_unref0 (appinfo);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
				_tmp36_ = monitor;
				g_signal_connect_object (_tmp36_, "changed", (GCallback) _unity_app_info_manager_on_dir_changed_g_file_monitor_changed, self, 0);
				_tmp37_ = self->priv->monitors;
				_tmp38_ = dir_uri;
				_tmp39_ = g_strdup (_tmp38_);
				_tmp40_ = monitor;
				_tmp41_ = _g_object_ref0 (_tmp40_);
				g_hash_table_insert (_tmp37_, _tmp39_, _tmp41_);
				_tmp42_ = dir_uri;
				unity_trace_log_object ((GObject*) self, "Monitoring extra app directory: %s", _tmp42_);
				_g_object_unref0 (monitor);
			}
			goto __finally2;
			__catch2_g_io_error:
			{
				GError* ioe = NULL;
				const gchar* _tmp43_;
				GError* _tmp44_;
				const gchar* _tmp45_;
				ioe = _inner_error_;
				_inner_error_ = NULL;
				_tmp43_ = dir_uri;
				_tmp44_ = ioe;
				_tmp45_ = _tmp44_->message;
				g_warning ("unity-appinfo-manager.vala:171: Error setting up extra app directory m" \
"onitor on '%s': %s", _tmp43_, _tmp45_);
				_g_error_free0 (ioe);
			}
			__finally2:
			if (_inner_error_ != NULL) {
				_g_free0 (dir_uri);
				_g_object_unref0 (dir);
				_g_key_file_free0 (keyfile);
				_g_object_unref0 (appinfo);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		_g_free0 (dir_uri);
		_g_object_unref0 (dir);
	} else {
		const gchar* _tmp46_;
		gchar* _tmp47_ = NULL;
		gchar* path;
		gchar* full_path;
		const gchar* _tmp58_;
		_tmp46_ = id;
		_tmp47_ = g_build_filename ("applications", _tmp46_, NULL, NULL);
		path = _tmp47_;
		full_path = NULL;
		{
			GKeyFile* _tmp48_;
			const gchar* _tmp49_;
			gchar* _tmp50_ = NULL;
			_tmp48_ = keyfile;
			_tmp49_ = path;
			g_key_file_load_from_data_dirs (_tmp48_, _tmp49_, &_tmp50_, G_KEY_FILE_NONE, &_inner_error_);
			_g_free0 (full_path);
			full_path = _tmp50_;
			if (_inner_error_ != NULL) {
				goto __catch3_g_error;
			}
		}
		goto __finally3;
		__catch3_g_error:
		{
			GError* e = NULL;
			gboolean _tmp51_ = FALSE;
			GError* _tmp52_;
			gboolean _tmp54_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_g_key_file_free0 (keyfile);
			keyfile = NULL;
			_tmp52_ = e;
			if (g_error_matches (_tmp52_, G_IO_ERROR, G_IO_ERROR_NOT_FOUND)) {
				_tmp51_ = TRUE;
			} else {
				GError* _tmp53_;
				_tmp53_ = e;
				_tmp51_ = g_error_matches (_tmp53_, G_KEY_FILE_ERROR, G_KEY_FILE_ERROR_NOT_FOUND);
			}
			_tmp54_ = _tmp51_;
			if (!_tmp54_) {
				const gchar* _tmp55_;
				GError* _tmp56_;
				const gchar* _tmp57_;
				_tmp55_ = id;
				_tmp56_ = e;
				_tmp57_ = _tmp56_->message;
				g_warning ("unity-appinfo-manager.vala:185: Error loading '%s': %s", _tmp55_, _tmp57_);
			}
			_g_error_free0 (e);
		}
		__finally3:
		if (_inner_error_ != NULL) {
			_g_free0 (full_path);
			_g_free0 (path);
			_g_key_file_free0 (keyfile);
			_g_object_unref0 (appinfo);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp58_ = full_path;
		if (_tmp58_ != NULL) {
			const gchar* _tmp59_;
			GFile* _tmp60_ = NULL;
			GFile* file;
			GFile* _tmp61_;
			GFile* _tmp62_;
			gchar* _tmp63_ = NULL;
			gchar* _tmp64_;
			GFile* _tmp65_ = NULL;
			GHashTable* _tmp66_;
			const gchar* _tmp67_;
			gchar* _tmp68_;
			GFile* _tmp69_;
			gchar* _tmp70_ = NULL;
			_tmp59_ = full_path;
			_tmp60_ = g_file_new_for_path (_tmp59_);
			file = _tmp60_;
			_tmp61_ = file;
			_tmp62_ = file;
			_tmp63_ = g_file_get_path (_tmp62_);
			_tmp64_ = _tmp63_;
			_tmp65_ = g_file_resolve_relative_path (_tmp61_, _tmp64_);
			_g_object_unref0 (file);
			file = _tmp65_;
			_g_free0 (_tmp64_);
			_tmp66_ = self->priv->paths_by_id;
			_tmp67_ = id;
			_tmp68_ = g_strdup (_tmp67_);
			_tmp69_ = file;
			_tmp70_ = g_file_get_path (_tmp69_);
			g_hash_table_insert (_tmp66_, _tmp68_, _tmp70_);
			_g_object_unref0 (file);
		} else {
			GHashTable* _tmp71_;
			const gchar* _tmp72_;
			gchar* _tmp73_;
			_tmp71_ = self->priv->paths_by_id;
			_tmp72_ = id;
			_tmp73_ = g_strdup (_tmp72_);
			g_hash_table_insert (_tmp71_, _tmp73_, NULL);
		}
		_g_free0 (full_path);
		_g_free0 (path);
	}
	_tmp74_ = keyfile;
	if (_tmp74_ != NULL) {
		GKeyFile* _tmp75_;
		GDesktopAppInfo* _tmp76_;
		const gchar* _tmp77_;
		GKeyFile* _tmp78_;
		const gchar* _tmp79_;
		GKeyFile* _tmp80_;
		_tmp75_ = keyfile;
		_tmp76_ = g_desktop_app_info_new_from_keyfile (_tmp75_);
		_g_object_unref0 (appinfo);
		appinfo = (GAppInfo*) _tmp76_;
		_tmp77_ = id;
		_tmp78_ = keyfile;
		unity_app_info_manager_register_categories (self, _tmp77_, _tmp78_);
		_tmp79_ = id;
		_tmp80_ = keyfile;
		unity_app_info_manager_register_keywords (self, _tmp79_, _tmp80_);
	} else {
		_g_object_unref0 (appinfo);
		appinfo = NULL;
	}
	_tmp81_ = self->priv->appinfo_by_id;
	_tmp82_ = id;
	_tmp83_ = g_strdup (_tmp82_);
	_tmp84_ = appinfo;
	_tmp85_ = _g_object_ref0 (_tmp84_);
	g_hash_table_insert (_tmp81_, _tmp83_, _tmp85_);
	result = appinfo;
	_g_key_file_free0 (keyfile);
	return result;
}


/**
     * Look up XDG categories for for desktop id or file path @id.
     * Returns null if id is not found.
     * This method will do sync IO if the desktop file for @id is not
     * already cached. So if you are living in an async world you must first
     * do an async call to lookup_async(id) before calling this method, in which
     * case no sync io will be done.
     */
static gpointer _unity_string_array_wrapper_ref0 (gpointer self) {
	return self ? unity_string_array_wrapper_ref (self) : NULL;
}


gchar** unity_app_info_manager_get_categories (UnityAppInfoManager* self, const gchar* id, int* result_length1) {
	gchar** result = NULL;
	const gchar* _tmp0_;
	GAppInfo* _tmp1_ = NULL;
	GAppInfo* appinfo;
	GAppInfo* _tmp2_;
	GHashTable* _tmp4_;
	const gchar* _tmp5_;
	gconstpointer _tmp6_ = NULL;
	UnityStringArrayWrapper* _tmp7_;
	UnityStringArrayWrapper* _result_;
	gchar** _tmp8_ = NULL;
	gint _tmp8__length1 = 0;
	gint __tmp8__size_ = 0;
	UnityStringArrayWrapper* _tmp9_;
	gchar** _tmp12_;
	gint _tmp12__length1;
	gchar** _tmp13_;
	gint _tmp13__length1;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (id != NULL, NULL);
	_tmp0_ = id;
	_tmp1_ = unity_app_info_manager_lookup (self, _tmp0_);
	appinfo = _tmp1_;
	_tmp2_ = appinfo;
	if (_tmp2_ == NULL) {
		gchar** _tmp3_;
		gint _tmp3__length1;
		_tmp3_ = NULL;
		_tmp3__length1 = 0;
		if (result_length1) {
			*result_length1 = _tmp3__length1;
		}
		result = _tmp3_;
		_g_object_unref0 (appinfo);
		return result;
	}
	_tmp4_ = self->priv->categories_by_id;
	_tmp5_ = id;
	_tmp6_ = g_hash_table_lookup (_tmp4_, _tmp5_);
	_tmp7_ = _unity_string_array_wrapper_ref0 ((UnityStringArrayWrapper*) _tmp6_);
	_result_ = _tmp7_;
	_tmp9_ = _result_;
	if (_tmp9_ != NULL) {
		UnityStringArrayWrapper* _tmp10_;
		gchar** _tmp11_;
		gint _tmp11__length1;
		_tmp10_ = _result_;
		_tmp11_ = _tmp10_->strings;
		_tmp11__length1 = _tmp10_->strings_length1;
		_tmp8_ = _tmp11_;
		_tmp8__length1 = _tmp11__length1;
		__tmp8__size_ = _tmp8__length1;
	} else {
		_tmp8_ = NULL;
		_tmp8__length1 = 0;
		__tmp8__size_ = _tmp8__length1;
	}
	_tmp12_ = _tmp8_;
	_tmp12__length1 = _tmp8__length1;
	_tmp13_ = _tmp12_;
	_tmp13__length1 = _tmp12__length1;
	if (result_length1) {
		*result_length1 = _tmp13__length1;
	}
	result = _tmp13_;
	_unity_string_array_wrapper_unref0 (_result_);
	_g_object_unref0 (appinfo);
	return result;
}


/**
     * Look up keywords for for desktop id or file path @id. The keywords will
     * be an amalgamation of the X-GNOME-Keywords and X-AppInstall-Keywords
     * fields from the .desktopfile.
     * Returns null if id is not found.
     * This method will do sync IO if the desktop file for @id is not
     * already cached. So if you are living in an async world you must first
     * do an async call to lookup_async(id) before calling this method, in which
     * case no sync io will be done.
     */
gchar** unity_app_info_manager_get_keywords (UnityAppInfoManager* self, const gchar* id, int* result_length1) {
	gchar** result = NULL;
	const gchar* _tmp0_;
	GAppInfo* _tmp1_ = NULL;
	GAppInfo* appinfo;
	GAppInfo* _tmp2_;
	GHashTable* _tmp4_;
	const gchar* _tmp5_;
	gconstpointer _tmp6_ = NULL;
	UnityStringArrayWrapper* _tmp7_;
	UnityStringArrayWrapper* _result_;
	gchar** _tmp8_ = NULL;
	gint _tmp8__length1 = 0;
	gint __tmp8__size_ = 0;
	UnityStringArrayWrapper* _tmp9_;
	gchar** _tmp12_;
	gint _tmp12__length1;
	gchar** _tmp13_;
	gint _tmp13__length1;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (id != NULL, NULL);
	_tmp0_ = id;
	_tmp1_ = unity_app_info_manager_lookup (self, _tmp0_);
	appinfo = _tmp1_;
	_tmp2_ = appinfo;
	if (_tmp2_ == NULL) {
		gchar** _tmp3_;
		gint _tmp3__length1;
		_tmp3_ = NULL;
		_tmp3__length1 = 0;
		if (result_length1) {
			*result_length1 = _tmp3__length1;
		}
		result = _tmp3_;
		_g_object_unref0 (appinfo);
		return result;
	}
	_tmp4_ = self->priv->keywords_by_id;
	_tmp5_ = id;
	_tmp6_ = g_hash_table_lookup (_tmp4_, _tmp5_);
	_tmp7_ = _unity_string_array_wrapper_ref0 ((UnityStringArrayWrapper*) _tmp6_);
	_result_ = _tmp7_;
	_tmp9_ = _result_;
	if (_tmp9_ != NULL) {
		UnityStringArrayWrapper* _tmp10_;
		gchar** _tmp11_;
		gint _tmp11__length1;
		_tmp10_ = _result_;
		_tmp11_ = _tmp10_->strings;
		_tmp11__length1 = _tmp10_->strings_length1;
		_tmp8_ = _tmp11_;
		_tmp8__length1 = _tmp11__length1;
		__tmp8__size_ = _tmp8__length1;
	} else {
		_tmp8_ = NULL;
		_tmp8__length1 = 0;
		__tmp8__size_ = _tmp8__length1;
	}
	_tmp12_ = _tmp8_;
	_tmp12__length1 = _tmp8__length1;
	_tmp13_ = _tmp12_;
	_tmp13__length1 = _tmp12__length1;
	if (result_length1) {
		*result_length1 = _tmp13__length1;
	}
	result = _tmp13_;
	_unity_string_array_wrapper_unref0 (_result_);
	_g_object_unref0 (appinfo);
	return result;
}


/**
     * Look up the full path to the desktop file for desktop id @id.
     * Returns null if @id is not found.
     * This method will do sync IO if the desktop file for @id is not
     * already cached. So if you are living in an async world you must
     * first do an async call to lookup_async(id) before calling this 
     * method, in which case no sync io will be done.
     */
gchar* unity_app_info_manager_get_path (UnityAppInfoManager* self, const gchar* id) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	GAppInfo* _tmp1_ = NULL;
	GAppInfo* appinfo;
	GAppInfo* _tmp2_;
	GHashTable* _tmp3_;
	const gchar* _tmp4_;
	gconstpointer _tmp5_ = NULL;
	gchar* _tmp6_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (id != NULL, NULL);
	_tmp0_ = id;
	_tmp1_ = unity_app_info_manager_lookup (self, _tmp0_);
	appinfo = _tmp1_;
	_tmp2_ = appinfo;
	if (_tmp2_ == NULL) {
		result = NULL;
		_g_object_unref0 (appinfo);
		return result;
	}
	_tmp3_ = self->priv->paths_by_id;
	_tmp4_ = id;
	_tmp5_ = g_hash_table_lookup (_tmp3_, _tmp4_);
	_tmp6_ = g_strdup ((const gchar*) _tmp5_);
	result = _tmp6_;
	_g_object_unref0 (appinfo);
	return result;
}


static void unity_app_info_manager_lookup_async_data_free (gpointer _data) {
	UnityAppInfoManagerLookupAsyncData* _data_;
	_data_ = _data;
	_g_free0 (_data_->id);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (UnityAppInfoManagerLookupAsyncData, _data_);
}


void unity_app_info_manager_lookup_async (UnityAppInfoManager* self, const gchar* id, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	UnityAppInfoManagerLookupAsyncData* _data_;
	UnityAppInfoManager* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	_data_ = g_slice_new0 (UnityAppInfoManagerLookupAsyncData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, unity_app_info_manager_lookup_async);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, unity_app_info_manager_lookup_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = id;
	_tmp2_ = g_strdup (_tmp1_);
	_data_->id = _tmp2_;
	unity_app_info_manager_lookup_async_co (_data_);
}


GAppInfo* unity_app_info_manager_lookup_finish (UnityAppInfoManager* self, GAsyncResult* _res_, GError** error) {
	GAppInfo* result;
	UnityAppInfoManagerLookupAsyncData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


/**
     * Look up an AppInfo given its desktop id or absolute path.
     * The desktop id is the base filename of the .desktop file for the
     * application including the .desktop extension.
     *
     * If the AppInfo is not already cached this method will do asynchronous
     * IO to look it up.
     */
static void unity_app_info_manager_lookup_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	UnityAppInfoManagerLookupAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	unity_app_info_manager_lookup_async_co (_data_);
}


static gboolean unity_app_info_manager_lookup_async_co (UnityAppInfoManagerLookupAsyncData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->appinfo_by_id;
	_data_->_tmp1_ = _data_->id;
	_data_->_tmp2_ = FALSE;
	_data_->_tmp2_ = g_hash_table_lookup_extended (_data_->_tmp0_, _data_->_tmp1_, NULL, NULL);
	if (_data_->_tmp2_) {
		_data_->_tmp3_ = _data_->self->priv->appinfo_by_id;
		_data_->_tmp4_ = _data_->id;
		_data_->_tmp5_ = NULL;
		_data_->_tmp5_ = g_hash_table_lookup (_data_->_tmp3_, _data_->_tmp4_);
		_data_->_tmp6_ = _g_object_ref0 ((GAppInfo*) _data_->_tmp5_);
		_data_->result = _data_->_tmp6_;
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->data_length1 = 0;
	_data_->_data_size_ = 0;
	_data_->_tmp7_ = _data_->id;
	_data_->_tmp8_ = FALSE;
	_data_->_tmp8_ = g_str_has_prefix (_data_->_tmp7_, "/");
	if (_data_->_tmp8_) {
		_data_->_tmp9_ = _data_->id;
		_data_->_tmp10_ = NULL;
		_data_->_tmp10_ = g_file_new_for_path (_data_->_tmp9_);
		_data_->f = _data_->_tmp10_;
		_data_->_tmp11_ = _data_->f;
		_data_->_state_ = 1;
		g_file_read_async (_data_->_tmp11_, G_PRIORITY_DEFAULT, NULL, unity_app_info_manager_lookup_async_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp12_ = NULL;
		_data_->_tmp12_ = g_file_read_finish (_data_->_tmp11_, _data_->_res_, &_data_->_inner_error_);
		_data_->_tmp13_ = _data_->_tmp12_;
		if (_data_->_inner_error_ != NULL) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			_g_object_unref0 (_data_->f);
			_g_object_unref0 (_data_->input);
			_data_->data = (g_free (_data_->data), NULL);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_g_object_unref0 (_data_->input);
		_data_->input = _data_->_tmp13_;
		_data_->_tmp14_ = _data_->f;
		_data_->_tmp15_ = NULL;
		_data_->_tmp15_ = g_file_get_parent (_data_->_tmp14_);
		_data_->dir = _data_->_tmp15_;
		_data_->_tmp16_ = _data_->dir;
		_data_->_tmp17_ = NULL;
		_data_->_tmp17_ = g_file_get_uri (_data_->_tmp16_);
		_data_->dir_uri = _data_->_tmp17_;
		_data_->_tmp18_ = _data_->self->priv->monitors;
		_data_->_tmp19_ = _data_->dir_uri;
		_data_->_tmp20_ = NULL;
		_data_->_tmp20_ = g_hash_table_lookup (_data_->_tmp18_, _data_->_tmp19_);
		if (((GFileMonitor*) _data_->_tmp20_) == NULL) {
			{
				_data_->_tmp21_ = _data_->dir;
				_data_->_tmp22_ = NULL;
				_data_->_tmp22_ = g_file_monitor_directory (_data_->_tmp21_, G_FILE_MONITOR_NONE, NULL, &_data_->_inner_error_);
				_data_->monitor = _data_->_tmp22_;
				if (_data_->_inner_error_ != NULL) {
					if (_data_->_inner_error_->domain == G_IO_ERROR) {
						goto __catch4_g_io_error;
					}
					_g_free0 (_data_->dir_uri);
					_g_object_unref0 (_data_->dir);
					_g_object_unref0 (_data_->f);
					_g_object_unref0 (_data_->input);
					_data_->data = (g_free (_data_->data), NULL);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
					g_clear_error (&_data_->_inner_error_);
					return FALSE;
				}
				_data_->_tmp23_ = _data_->monitor;
				g_signal_connect_object (_data_->_tmp23_, "changed", (GCallback) _unity_app_info_manager_on_dir_changed_g_file_monitor_changed, _data_->self, 0);
				_data_->_tmp24_ = _data_->self->priv->monitors;
				_data_->_tmp25_ = _data_->dir_uri;
				_data_->_tmp26_ = g_strdup (_data_->_tmp25_);
				_data_->_tmp27_ = _data_->monitor;
				_data_->_tmp28_ = _g_object_ref0 (_data_->_tmp27_);
				g_hash_table_insert (_data_->_tmp24_, _data_->_tmp26_, _data_->_tmp28_);
				_data_->_tmp29_ = _data_->dir_uri;
				unity_trace_log_object ((GObject*) _data_->self, "Monitoring extra app directory: %s", _data_->_tmp29_);
				_g_object_unref0 (_data_->monitor);
			}
			goto __finally4;
			__catch4_g_io_error:
			{
				_data_->ioe = _data_->_inner_error_;
				_data_->_inner_error_ = NULL;
				_data_->_tmp30_ = _data_->dir_uri;
				_data_->_tmp31_ = _data_->ioe;
				_data_->_tmp32_ = _data_->_tmp31_->message;
				g_warning ("unity-appinfo-manager.vala:312: Error setting up extra app directory m" \
"onitor on '%s': %s", _data_->_tmp30_, _data_->_tmp32_);
				_g_error_free0 (_data_->ioe);
			}
			__finally4:
			if (_data_->_inner_error_ != NULL) {
				g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
				g_error_free (_data_->_inner_error_);
				_g_free0 (_data_->dir_uri);
				_g_object_unref0 (_data_->dir);
				_g_object_unref0 (_data_->f);
				_g_object_unref0 (_data_->input);
				_data_->data = (g_free (_data_->data), NULL);
				if (_data_->_state_ == 0) {
					g_simple_async_result_complete_in_idle (_data_->_async_result);
				} else {
					g_simple_async_result_complete (_data_->_async_result);
				}
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
		}
		_g_free0 (_data_->dir_uri);
		_g_object_unref0 (_data_->dir);
		_g_object_unref0 (_data_->f);
	} else {
		_data_->_tmp33_ = _data_->id;
		_data_->_tmp34_ = NULL;
		_data_->_tmp34_ = g_build_filename ("applications", _data_->_tmp33_, NULL, NULL);
		_data_->path = _data_->_tmp34_;
		_data_->_tmp35_ = _data_->path;
		_data_->_state_ = 2;
		unity_io_open_from_data_dirs (_data_->_tmp35_, unity_app_info_manager_lookup_async_ready, _data_);
		return FALSE;
		_state_2:
		_data_->_tmp36_ = NULL;
		_data_->_tmp36_ = unity_io_open_from_data_dirs_finish (_data_->_res_, &_data_->_inner_error_);
		_data_->_tmp37_ = _data_->_tmp36_;
		if (_data_->_inner_error_ != NULL) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			_g_free0 (_data_->path);
			_g_object_unref0 (_data_->input);
			_data_->data = (g_free (_data_->data), NULL);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_g_object_unref0 (_data_->input);
		_data_->input = _data_->_tmp37_;
		_g_free0 (_data_->path);
	}
	_data_->_tmp38_ = _data_->input;
	if (_data_->_tmp38_ == NULL) {
		_data_->_tmp39_ = _data_->self->priv->appinfo_by_id;
		_data_->_tmp40_ = _data_->id;
		_data_->_tmp41_ = g_strdup (_data_->_tmp40_);
		g_hash_table_insert (_data_->_tmp39_, _data_->_tmp41_, NULL);
		_data_->result = NULL;
		_g_object_unref0 (_data_->input);
		_data_->data = (g_free (_data_->data), NULL);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	{
		_data_->_tmp42_ = _data_->input;
		_data_->_tmp43_ = NULL;
		_data_->_tmp44_ = 0;
		_data_->_tmp45_ = 0UL;
		_data_->_state_ = 3;
		unity_io_read_stream_async ((GInputStream*) _data_->_tmp42_, G_PRIORITY_LOW, NULL, unity_app_info_manager_lookup_async_ready, _data_);
		return FALSE;
		_state_3:
		unity_io_read_stream_finish (_data_->_res_, &_data_->_tmp43_, &_data_->_tmp44_, &_data_->_tmp45_, &_data_->_inner_error_);
		_data_->data = (g_free (_data_->data), NULL);
		_data_->data = _data_->_tmp43_;
		_data_->data_length1 = _data_->_tmp44_;
		_data_->_data_size_ = _data_->data_length1;
		_data_->data_size = _data_->_tmp45_;
		if (_data_->_inner_error_ != NULL) {
			goto __catch5_g_error;
		}
	}
	goto __finally5;
	__catch5_g_error:
	{
		_data_->e = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp46_ = _data_->id;
		_data_->_tmp47_ = _data_->e;
		_data_->_tmp48_ = _data_->_tmp47_->message;
		g_warning ("unity-appinfo-manager.vala:340: Error reading '%s': %s", _data_->_tmp46_, _data_->_tmp48_);
		_data_->result = NULL;
		_g_error_free0 (_data_->e);
		_g_object_unref0 (_data_->input);
		_data_->data = (g_free (_data_->data), NULL);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally5:
	if (_data_->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		_g_object_unref0 (_data_->input);
		_data_->data = (g_free (_data_->data), NULL);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp49_ = g_key_file_new ();
	_data_->keyfile = _data_->_tmp49_;
	{
		_data_->_tmp50_ = _data_->keyfile;
		_data_->_tmp51_ = _data_->data;
		_data_->_tmp51__length1 = _data_->data_length1;
		_data_->_tmp52_ = _data_->data_size;
		g_key_file_load_from_data (_data_->_tmp50_, (const gchar*) _data_->_tmp51_, _data_->_tmp52_, G_KEY_FILE_NONE, &_data_->_inner_error_);
		if (_data_->_inner_error_ != NULL) {
			goto __catch6_g_error;
		}
	}
	goto __finally6;
	__catch6_g_error:
	{
		_data_->ee = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp53_ = _data_->id;
		_data_->_tmp54_ = _data_->ee;
		_data_->_tmp55_ = _data_->_tmp54_->message;
		g_warning ("unity-appinfo-manager.vala:351: Error parsing '%s': %s", _data_->_tmp53_, _data_->_tmp55_);
		_data_->result = NULL;
		_g_error_free0 (_data_->ee);
		_g_key_file_free0 (_data_->keyfile);
		_g_object_unref0 (_data_->input);
		_data_->data = (g_free (_data_->data), NULL);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally6:
	if (_data_->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		_g_key_file_free0 (_data_->keyfile);
		_g_object_unref0 (_data_->input);
		_data_->data = (g_free (_data_->data), NULL);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp56_ = _data_->keyfile;
	_data_->_tmp57_ = g_desktop_app_info_new_from_keyfile (_data_->_tmp56_);
	_data_->appinfo = _data_->_tmp57_;
	_data_->_tmp58_ = _data_->self->priv->appinfo_by_id;
	_data_->_tmp59_ = _data_->id;
	_data_->_tmp60_ = g_strdup (_data_->_tmp59_);
	_data_->_tmp61_ = _data_->appinfo;
	_data_->_tmp62_ = _g_object_ref0 ((GAppInfo*) _data_->_tmp61_);
	g_hash_table_insert (_data_->_tmp58_, _data_->_tmp60_, _data_->_tmp62_);
	_data_->_tmp63_ = _data_->id;
	_data_->_tmp64_ = _data_->keyfile;
	unity_app_info_manager_register_categories (_data_->self, _data_->_tmp63_, _data_->_tmp64_);
	_data_->_tmp65_ = _data_->id;
	_data_->_tmp66_ = _data_->keyfile;
	unity_app_info_manager_register_keywords (_data_->self, _data_->_tmp65_, _data_->_tmp66_);
	_data_->result = (GAppInfo*) _data_->appinfo;
	_g_key_file_free0 (_data_->keyfile);
	_g_object_unref0 (_data_->input);
	_data_->data = (g_free (_data_->data), NULL);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	_g_object_unref0 (_data_->appinfo);
	_g_key_file_free0 (_data_->keyfile);
	_g_object_unref0 (_data_->input);
	_data_->data = (g_free (_data_->data), NULL);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


void unity_app_info_manager_clear (UnityAppInfoManager* self) {
	GHashTable* _tmp0_;
	GHashTable* _tmp1_;
	GHashTable* _tmp2_;
	GHashTable* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->appinfo_by_id;
	g_hash_table_remove_all (_tmp0_);
	_tmp1_ = self->priv->categories_by_id;
	g_hash_table_remove_all (_tmp1_);
	_tmp2_ = self->priv->keywords_by_id;
	g_hash_table_remove_all (_tmp2_);
	_tmp3_ = self->priv->paths_by_id;
	g_hash_table_remove_all (_tmp3_);
}


static void unity_app_info_manager_register_categories (UnityAppInfoManager* self, const gchar* id, GKeyFile* keyfile) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (id != NULL);
	g_return_if_fail (keyfile != NULL);
	{
		GKeyFile* _tmp0_;
		gsize _tmp1_;
		gchar** _tmp2_ = NULL;
		gchar** categories;
		gint categories_length1;
		gint _categories_size_;
		UnityStringArrayWrapper* _tmp3_;
		UnityStringArrayWrapper* wrapper;
		UnityStringArrayWrapper* _tmp4_;
		gchar** _tmp5_;
		gint _tmp5__length1;
		GHashTable* _tmp6_;
		const gchar* _tmp7_;
		gchar* _tmp8_;
		UnityStringArrayWrapper* _tmp9_;
		UnityStringArrayWrapper* _tmp10_;
		_tmp0_ = keyfile;
		_tmp2_ = g_key_file_get_string_list (_tmp0_, "Desktop Entry", "Categories", &_tmp1_, &_inner_error_);
		categories = _tmp2_;
		categories_length1 = _tmp1_;
		_categories_size_ = categories_length1;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
				goto __catch7_g_key_file_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp3_ = unity_string_array_wrapper_new ();
		wrapper = _tmp3_;
		_tmp4_ = wrapper;
		_tmp5_ = categories;
		_tmp5__length1 = categories_length1;
		categories = NULL;
		unity_string_array_wrapper_take_strings (_tmp4_, _tmp5_, _tmp5__length1);
		_tmp6_ = self->priv->categories_by_id;
		_tmp7_ = id;
		_tmp8_ = g_strdup (_tmp7_);
		_tmp9_ = wrapper;
		_tmp10_ = _unity_string_array_wrapper_ref0 (_tmp9_);
		g_hash_table_insert (_tmp6_, _tmp8_, _tmp10_);
		_unity_string_array_wrapper_unref0 (wrapper);
		categories = (_vala_array_free (categories, categories_length1, (GDestroyNotify) g_free), NULL);
	}
	goto __finally7;
	__catch7_g_key_file_error:
	{
		GError* eee = NULL;
		eee = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (eee);
	}
	__finally7:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void unity_app_info_manager_register_keywords (UnityAppInfoManager* self, const gchar* id, GKeyFile* keyfile) {
	gchar** gkeywords = NULL;
	gint gkeywords_length1 = 0;
	gint _gkeywords_size_ = 0;
	gchar** akeywords = NULL;
	gint akeywords_length1 = 0;
	gint _akeywords_size_ = 0;
	gchar** xdgkeywords = NULL;
	gint xdgkeywords_length1 = 0;
	gint _xdgkeywords_size_ = 0;
	gchar** _tmp15_;
	gint _tmp15__length1;
	gchar** _tmp16_;
	gint _tmp16__length1;
	gchar** _tmp17_;
	gint _tmp17__length1;
	gchar** _tmp18_ = NULL;
	gchar** keywords;
	gint keywords_length1;
	gint _keywords_size_;
	UnityStringArrayWrapper* _tmp58_;
	UnityStringArrayWrapper* wrapper;
	gchar** _tmp59_;
	gint _tmp59__length1;
	GHashTable* _tmp60_;
	const gchar* _tmp61_;
	gchar* _tmp62_;
	UnityStringArrayWrapper* _tmp63_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (id != NULL);
	g_return_if_fail (keyfile != NULL);
	{
		GKeyFile* _tmp0_;
		gsize _tmp1_;
		gchar** _tmp2_ = NULL;
		gchar** _tmp3_;
		gint _tmp3__length1;
		gint __tmp3__size_;
		_tmp0_ = keyfile;
		_tmp2_ = g_key_file_get_locale_string_list (_tmp0_, "Desktop Entry", "X-GNOME-Keywords", NULL, &_tmp1_, &_inner_error_);
		_tmp3_ = _tmp2_;
		_tmp3__length1 = _tmp1_;
		__tmp3__size_ = _tmp3__length1;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
				goto __catch8_g_key_file_error;
			}
			xdgkeywords = (_vala_array_free (xdgkeywords, xdgkeywords_length1, (GDestroyNotify) g_free), NULL);
			akeywords = (_vala_array_free (akeywords, akeywords_length1, (GDestroyNotify) g_free), NULL);
			gkeywords = (_vala_array_free (gkeywords, gkeywords_length1, (GDestroyNotify) g_free), NULL);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		gkeywords = (_vala_array_free (gkeywords, gkeywords_length1, (GDestroyNotify) g_free), NULL);
		gkeywords = _tmp3_;
		gkeywords_length1 = _tmp3__length1;
		_gkeywords_size_ = gkeywords_length1;
	}
	goto __finally8;
	__catch8_g_key_file_error:
	{
		GError* e = NULL;
		gchar** _tmp4_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp4_ = g_new0 (gchar*, 0 + 1);
		gkeywords = (_vala_array_free (gkeywords, gkeywords_length1, (GDestroyNotify) g_free), NULL);
		gkeywords = _tmp4_;
		gkeywords_length1 = 0;
		_gkeywords_size_ = gkeywords_length1;
		_g_error_free0 (e);
	}
	__finally8:
	if (_inner_error_ != NULL) {
		xdgkeywords = (_vala_array_free (xdgkeywords, xdgkeywords_length1, (GDestroyNotify) g_free), NULL);
		akeywords = (_vala_array_free (akeywords, akeywords_length1, (GDestroyNotify) g_free), NULL);
		gkeywords = (_vala_array_free (gkeywords, gkeywords_length1, (GDestroyNotify) g_free), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	{
		GKeyFile* _tmp5_;
		gsize _tmp6_;
		gchar** _tmp7_ = NULL;
		gchar** _tmp8_;
		gint _tmp8__length1;
		gint __tmp8__size_;
		_tmp5_ = keyfile;
		_tmp7_ = g_key_file_get_locale_string_list (_tmp5_, "Desktop Entry", "X-AppInstall-Keywords", NULL, &_tmp6_, &_inner_error_);
		_tmp8_ = _tmp7_;
		_tmp8__length1 = _tmp6_;
		__tmp8__size_ = _tmp8__length1;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
				goto __catch9_g_key_file_error;
			}
			xdgkeywords = (_vala_array_free (xdgkeywords, xdgkeywords_length1, (GDestroyNotify) g_free), NULL);
			akeywords = (_vala_array_free (akeywords, akeywords_length1, (GDestroyNotify) g_free), NULL);
			gkeywords = (_vala_array_free (gkeywords, gkeywords_length1, (GDestroyNotify) g_free), NULL);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		akeywords = (_vala_array_free (akeywords, akeywords_length1, (GDestroyNotify) g_free), NULL);
		akeywords = _tmp8_;
		akeywords_length1 = _tmp8__length1;
		_akeywords_size_ = akeywords_length1;
	}
	goto __finally9;
	__catch9_g_key_file_error:
	{
		GError* e = NULL;
		gchar** _tmp9_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp9_ = g_new0 (gchar*, 0 + 1);
		akeywords = (_vala_array_free (akeywords, akeywords_length1, (GDestroyNotify) g_free), NULL);
		akeywords = _tmp9_;
		akeywords_length1 = 0;
		_akeywords_size_ = akeywords_length1;
		_g_error_free0 (e);
	}
	__finally9:
	if (_inner_error_ != NULL) {
		xdgkeywords = (_vala_array_free (xdgkeywords, xdgkeywords_length1, (GDestroyNotify) g_free), NULL);
		akeywords = (_vala_array_free (akeywords, akeywords_length1, (GDestroyNotify) g_free), NULL);
		gkeywords = (_vala_array_free (gkeywords, gkeywords_length1, (GDestroyNotify) g_free), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	{
		GKeyFile* _tmp10_;
		gsize _tmp11_;
		gchar** _tmp12_ = NULL;
		gchar** _tmp13_;
		gint _tmp13__length1;
		gint __tmp13__size_;
		_tmp10_ = keyfile;
		_tmp12_ = g_key_file_get_locale_string_list (_tmp10_, "Desktop Entry", "Keywords", NULL, &_tmp11_, &_inner_error_);
		_tmp13_ = _tmp12_;
		_tmp13__length1 = _tmp11_;
		__tmp13__size_ = _tmp13__length1;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
				goto __catch10_g_key_file_error;
			}
			xdgkeywords = (_vala_array_free (xdgkeywords, xdgkeywords_length1, (GDestroyNotify) g_free), NULL);
			akeywords = (_vala_array_free (akeywords, akeywords_length1, (GDestroyNotify) g_free), NULL);
			gkeywords = (_vala_array_free (gkeywords, gkeywords_length1, (GDestroyNotify) g_free), NULL);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		xdgkeywords = (_vala_array_free (xdgkeywords, xdgkeywords_length1, (GDestroyNotify) g_free), NULL);
		xdgkeywords = _tmp13_;
		xdgkeywords_length1 = _tmp13__length1;
		_xdgkeywords_size_ = xdgkeywords_length1;
	}
	goto __finally10;
	__catch10_g_key_file_error:
	{
		GError* e = NULL;
		gchar** _tmp14_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp14_ = g_new0 (gchar*, 0 + 1);
		xdgkeywords = (_vala_array_free (xdgkeywords, xdgkeywords_length1, (GDestroyNotify) g_free), NULL);
		xdgkeywords = _tmp14_;
		xdgkeywords_length1 = 0;
		_xdgkeywords_size_ = xdgkeywords_length1;
		_g_error_free0 (e);
	}
	__finally10:
	if (_inner_error_ != NULL) {
		xdgkeywords = (_vala_array_free (xdgkeywords, xdgkeywords_length1, (GDestroyNotify) g_free), NULL);
		akeywords = (_vala_array_free (akeywords, akeywords_length1, (GDestroyNotify) g_free), NULL);
		gkeywords = (_vala_array_free (gkeywords, gkeywords_length1, (GDestroyNotify) g_free), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp15_ = gkeywords;
	_tmp15__length1 = gkeywords_length1;
	_tmp16_ = akeywords;
	_tmp16__length1 = akeywords_length1;
	_tmp17_ = xdgkeywords;
	_tmp17__length1 = xdgkeywords_length1;
	_tmp18_ = g_new0 (gchar*, ((_tmp15__length1 + _tmp16__length1) + _tmp17__length1) + 1);
	keywords = _tmp18_;
	keywords_length1 = (_tmp15__length1 + _tmp16__length1) + _tmp17__length1;
	_keywords_size_ = keywords_length1;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp19_;
			_tmp19_ = TRUE;
			while (TRUE) {
				gboolean _tmp20_;
				gint _tmp22_;
				gchar** _tmp23_;
				gint _tmp23__length1;
				gchar** _tmp24_;
				gint _tmp24__length1;
				gint _tmp25_;
				gchar** _tmp26_;
				gint _tmp26__length1;
				gint _tmp27_;
				const gchar* _tmp28_;
				gchar* _tmp29_;
				gchar* _tmp30_;
				_tmp20_ = _tmp19_;
				if (!_tmp20_) {
					gint _tmp21_;
					_tmp21_ = i;
					i = _tmp21_ + 1;
				}
				_tmp19_ = FALSE;
				_tmp22_ = i;
				_tmp23_ = gkeywords;
				_tmp23__length1 = gkeywords_length1;
				if (!(_tmp22_ < _tmp23__length1)) {
					break;
				}
				_tmp24_ = keywords;
				_tmp24__length1 = keywords_length1;
				_tmp25_ = i;
				_tmp26_ = gkeywords;
				_tmp26__length1 = gkeywords_length1;
				_tmp27_ = i;
				_tmp28_ = _tmp26_[_tmp27_];
				_tmp29_ = g_strdup (_tmp28_);
				_g_free0 (_tmp24_[_tmp25_]);
				_tmp24_[_tmp25_] = _tmp29_;
				_tmp30_ = _tmp24_[_tmp25_];
			}
		}
	}
	{
		gint i;
		i = 0;
		{
			gboolean _tmp31_;
			_tmp31_ = TRUE;
			while (TRUE) {
				gboolean _tmp32_;
				gint _tmp34_;
				gchar** _tmp35_;
				gint _tmp35__length1;
				gchar** _tmp36_;
				gint _tmp36__length1;
				gchar** _tmp37_;
				gint _tmp37__length1;
				gint _tmp38_;
				gchar** _tmp39_;
				gint _tmp39__length1;
				gint _tmp40_;
				const gchar* _tmp41_;
				gchar* _tmp42_;
				gchar* _tmp43_;
				_tmp32_ = _tmp31_;
				if (!_tmp32_) {
					gint _tmp33_;
					_tmp33_ = i;
					i = _tmp33_ + 1;
				}
				_tmp31_ = FALSE;
				_tmp34_ = i;
				_tmp35_ = akeywords;
				_tmp35__length1 = akeywords_length1;
				if (!(_tmp34_ < _tmp35__length1)) {
					break;
				}
				_tmp36_ = keywords;
				_tmp36__length1 = keywords_length1;
				_tmp37_ = gkeywords;
				_tmp37__length1 = gkeywords_length1;
				_tmp38_ = i;
				_tmp39_ = akeywords;
				_tmp39__length1 = akeywords_length1;
				_tmp40_ = i;
				_tmp41_ = _tmp39_[_tmp40_];
				_tmp42_ = g_strdup (_tmp41_);
				_g_free0 (_tmp36_[_tmp37__length1 + _tmp38_]);
				_tmp36_[_tmp37__length1 + _tmp38_] = _tmp42_;
				_tmp43_ = _tmp36_[_tmp37__length1 + _tmp38_];
			}
		}
	}
	{
		gint i;
		i = 0;
		{
			gboolean _tmp44_;
			_tmp44_ = TRUE;
			while (TRUE) {
				gboolean _tmp45_;
				gint _tmp47_;
				gchar** _tmp48_;
				gint _tmp48__length1;
				gchar** _tmp49_;
				gint _tmp49__length1;
				gchar** _tmp50_;
				gint _tmp50__length1;
				gchar** _tmp51_;
				gint _tmp51__length1;
				gint _tmp52_;
				gchar** _tmp53_;
				gint _tmp53__length1;
				gint _tmp54_;
				const gchar* _tmp55_;
				gchar* _tmp56_;
				gchar* _tmp57_;
				_tmp45_ = _tmp44_;
				if (!_tmp45_) {
					gint _tmp46_;
					_tmp46_ = i;
					i = _tmp46_ + 1;
				}
				_tmp44_ = FALSE;
				_tmp47_ = i;
				_tmp48_ = xdgkeywords;
				_tmp48__length1 = xdgkeywords_length1;
				if (!(_tmp47_ < _tmp48__length1)) {
					break;
				}
				_tmp49_ = keywords;
				_tmp49__length1 = keywords_length1;
				_tmp50_ = gkeywords;
				_tmp50__length1 = gkeywords_length1;
				_tmp51_ = akeywords;
				_tmp51__length1 = akeywords_length1;
				_tmp52_ = i;
				_tmp53_ = xdgkeywords;
				_tmp53__length1 = xdgkeywords_length1;
				_tmp54_ = i;
				_tmp55_ = _tmp53_[_tmp54_];
				_tmp56_ = g_strdup (_tmp55_);
				_g_free0 (_tmp49_[(_tmp50__length1 + _tmp51__length1) + _tmp52_]);
				_tmp49_[(_tmp50__length1 + _tmp51__length1) + _tmp52_] = _tmp56_;
				_tmp57_ = _tmp49_[(_tmp50__length1 + _tmp51__length1) + _tmp52_];
			}
		}
	}
	_tmp58_ = unity_string_array_wrapper_new ();
	wrapper = _tmp58_;
	_tmp59_ = keywords;
	_tmp59__length1 = keywords_length1;
	keywords = NULL;
	unity_string_array_wrapper_take_strings (wrapper, _tmp59_, _tmp59__length1);
	_tmp60_ = self->priv->keywords_by_id;
	_tmp61_ = id;
	_tmp62_ = g_strdup (_tmp61_);
	_tmp63_ = _unity_string_array_wrapper_ref0 (wrapper);
	g_hash_table_insert (_tmp60_, _tmp62_, _tmp63_);
	_unity_string_array_wrapper_unref0 (wrapper);
	keywords = (_vala_array_free (keywords, keywords_length1, (GDestroyNotify) g_free), NULL);
	xdgkeywords = (_vala_array_free (xdgkeywords, xdgkeywords_length1, (GDestroyNotify) g_free), NULL);
	akeywords = (_vala_array_free (akeywords, akeywords_length1, (GDestroyNotify) g_free), NULL);
	gkeywords = (_vala_array_free (gkeywords, gkeywords_length1, (GDestroyNotify) g_free), NULL);
}


static void g_cclosure_user_marshal_VOID__STRING_OBJECT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__STRING_OBJECT) (gpointer data1, const char* arg_1, gpointer arg_2, gpointer data2);
	register GMarshalFunc_VOID__STRING_OBJECT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__STRING_OBJECT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_string (param_values + 1), g_value_get_object (param_values + 2), data2);
}


static void unity_app_info_manager_class_init (UnityAppInfoManagerClass * klass) {
	unity_app_info_manager_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (UnityAppInfoManagerPrivate));
	G_OBJECT_CLASS (klass)->finalize = unity_app_info_manager_finalize;
	/**
	     * Emitted whenever an AppInfo in any of the monitored paths change.
	     * Note that @new_appinfo may be null in case it has been removed.
	     */
	g_signal_new ("changed", UNITY_TYPE_APP_INFO_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_OBJECT, G_TYPE_NONE, 2, G_TYPE_STRING, G_TYPE_APP_INFO);
}


static void unity_app_info_manager_instance_init (UnityAppInfoManager * self) {
	self->priv = UNITY_APP_INFO_MANAGER_GET_PRIVATE (self);
}


static void unity_app_info_manager_finalize (GObject* obj) {
	UnityAppInfoManager * self;
	self = UNITY_APP_INFO_MANAGER (obj);
	_g_hash_table_unref0 (self->priv->appinfo_by_id);
	_g_hash_table_unref0 (self->priv->monitors);
	_g_hash_table_unref0 (self->priv->categories_by_id);
	_g_hash_table_unref0 (self->priv->keywords_by_id);
	_g_hash_table_unref0 (self->priv->paths_by_id);
	G_OBJECT_CLASS (unity_app_info_manager_parent_class)->finalize (obj);
}


/**
   * A singleton class that caches GLib.AppInfo objects.
   * Singletons are evil, yes, but this on slightly less
   * so because the exposed API is immutable.
   *
   * To detect when any of the managed AppInfo objects changes, appears,
   * or goes away listen for the 'changed' signal.
   */
GType unity_app_info_manager_get_type (void) {
	static volatile gsize unity_app_info_manager_type_id__volatile = 0;
	if (g_once_init_enter (&unity_app_info_manager_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (UnityAppInfoManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) unity_app_info_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UnityAppInfoManager), 0, (GInstanceInitFunc) unity_app_info_manager_instance_init, NULL };
		GType unity_app_info_manager_type_id;
		unity_app_info_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "UnityAppInfoManager", &g_define_type_info, 0);
		g_once_init_leave (&unity_app_info_manager_type_id__volatile, unity_app_info_manager_type_id);
	}
	return unity_app_info_manager_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



