/* stream-view.c generated by valac 0.11.6, the Vala compiler
 * generated from stream-view.vala, do not modify */

/*
 * Copyright (C) 2010 Neil Jagdish Patel
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License
 * version 3.0 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3.0 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see
 * <http://www.gnu.org/licenses/>.
 *
 * Authored by Neil Jagdish Patel <njpatel@gmail.com>
 */

#include <glib.h>
#include <glib-object.h>
#include "gwibber-gtk.h"
#include <gtk/gtk.h>
#include <dee.h>
#include <gdk/gdk.h>
#include <float.h>
#include <math.h>

#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __g_slist_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_slist_free__g_object_unref0_ (var), NULL)))

struct _GwibberGtkStreamViewPrivate {
	GtkAdjustment* adjustment;
	GtkVScrollbar* scrollbar;
	GtkLayout* layout;
	GtkVBox* view_box;
	DeeModel* _model;
	guint _position;
	GSList* tiles;
	gint last_width;
	gint last_height;
};


static gpointer gwibber_gtk_stream_view_parent_class = NULL;

#define GWIBBER_GTK_STREAM_VIEW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GWIBBER_GTK_TYPE_STREAM_VIEW, GwibberGtkStreamViewPrivate))
enum  {
	GWIBBER_GTK_STREAM_VIEW_DUMMY_PROPERTY,
	GWIBBER_GTK_STREAM_VIEW_MODEL,
	GWIBBER_GTK_STREAM_VIEW_POSITION
};
static void _g_object_unref0_ (gpointer var);
static void _g_slist_free__g_object_unref0_ (GSList* self);
static void gwibber_gtk_stream_view_refresh (GwibberGtkStreamView* self);
static gboolean _lambda8_ (GwibberGtkStreamView* self);
static void gwibber_gtk_stream_view_fill_up_remaining_space (GwibberGtkStreamView* self);
static gboolean __lambda8__gsource_func (gpointer self);
static gboolean gwibber_gtk_stream_view_on_layout_exposed (GwibberGtkStreamView* self, GdkEventExpose* event);
static void gwibber_gtk_stream_view_on_row_added (GwibberGtkStreamView* self);
static void gwibber_gtk_stream_view_on_row_removed (GwibberGtkStreamView* self);
static void gwibber_gtk_stream_view_on_row_changed (GwibberGtkStreamView* self);
static void _gwibber_gtk_stream_view_on_row_added_dee_model_row_added (DeeModel* _sender, DeeModelIter* iter, gpointer self);
static void _gwibber_gtk_stream_view_on_row_removed_dee_model_row_removed (DeeModel* _sender, DeeModelIter* iter, gpointer self);
static void _gwibber_gtk_stream_view_on_row_changed_dee_model_row_changed (DeeModel* _sender, DeeModelIter* iter, gpointer self);
static GObject * gwibber_gtk_stream_view_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void _lambda9_ (GwibberGtkStreamView* self);
static void __lambda9__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static gboolean _gwibber_gtk_stream_view_on_layout_exposed_gtk_widget_expose_event (GtkWidget* _sender, GdkEventExpose* event, gpointer self);
static void _lambda10_ (GdkRectangle* a, GwibberGtkStreamView* self);
static void __lambda10__gtk_widget_size_allocate (GtkWidget* _sender, GdkRectangle* allocation, gpointer self);
static void gwibber_gtk_stream_view_finalize (GObject* obj);
static void _vala_gwibber_gtk_stream_view_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_gwibber_gtk_stream_view_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_slist_free__g_object_unref0_ (GSList* self) {
	g_slist_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_slist_free (self);
}


GwibberGtkStreamView* gwibber_gtk_stream_view_construct (GType object_type) {
	GwibberGtkStreamView * self = NULL;
	self = (GwibberGtkStreamView*) g_object_new (object_type, "homogeneous", FALSE, "spacing", 6, NULL);
	return self;
}


GwibberGtkStreamView* gwibber_gtk_stream_view_new (void) {
	return gwibber_gtk_stream_view_construct (GWIBBER_GTK_TYPE_STREAM_VIEW);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gboolean _lambda8_ (GwibberGtkStreamView* self) {
	gboolean result = FALSE;
	gtk_widget_queue_draw ((GtkWidget*) self);
	gwibber_gtk_stream_view_fill_up_remaining_space (self);
	result = FALSE;
	return result;
}


static gboolean __lambda8__gsource_func (gpointer self) {
	gboolean result;
	result = _lambda8_ (self);
	return result;
}


static void gwibber_gtk_stream_view_refresh (GwibberGtkStreamView* self) {
	guint i;
	guint _tmp0_;
	guint n_rows;
	DeeModelIter* iter = NULL;
	DeeModelIter* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	i = (guint) 0;
	_tmp0_ = dee_model_get_n_rows (self->priv->_model);
	n_rows = _tmp0_;
	if (!DEE_IS_MODEL (self->priv->_model)) {
		{
			GSList* tile_collection;
			GSList* tile_it;
			tile_collection = self->priv->tiles;
			for (tile_it = tile_collection; tile_it != NULL; tile_it = tile_it->next) {
				GwibberGtkStreamViewTile* _tmp1_;
				GwibberGtkStreamViewTile* tile;
				_tmp1_ = _g_object_ref0 ((GwibberGtkStreamViewTile*) tile_it->data);
				tile = _tmp1_;
				{
					gwibber_gtk_stream_view_tile_reset (tile);
					_g_object_unref0 (tile);
				}
			}
		}
		return;
	}
	_tmp2_ = dee_model_get_iter_at_row (self->priv->_model, self->priv->_position);
	iter = _tmp2_;
	{
		GSList* tile_collection;
		GSList* tile_it;
		tile_collection = self->priv->tiles;
		for (tile_it = tile_collection; tile_it != NULL; tile_it = tile_it->next) {
			GwibberGtkStreamViewTile* _tmp3_;
			GwibberGtkStreamViewTile* tile;
			_tmp3_ = _g_object_ref0 ((GwibberGtkStreamViewTile*) tile_it->data);
			tile = _tmp3_;
			{
				gboolean _tmp4_ = FALSE;
				guint _tmp12_;
				if (iter != NULL) {
					guint _tmp5_;
					_tmp5_ = gwibber_gtk_stream_view_get_position (self);
					_tmp4_ = (_tmp5_ + i) < n_rows;
				} else {
					_tmp4_ = FALSE;
				}
				if (_tmp4_) {
					const gchar* _tmp6_ = NULL;
					const gchar* _tmp7_ = NULL;
					guint32 _tmp8_;
					const gchar* _tmp9_ = NULL;
					const gchar* _tmp10_ = NULL;
					const gchar* _tmp11_ = NULL;
					_tmp6_ = dee_model_get_string (self->priv->_model, iter, (guint) GWIBBER_GTK_STREAM_MODEL_COLUMN_SERVICE);
					_tmp7_ = dee_model_get_string (self->priv->_model, iter, (guint) GWIBBER_GTK_STREAM_MODEL_COLUMN_NAME);
					_tmp8_ = dee_model_get_uint32 (self->priv->_model, iter, (guint) GWIBBER_GTK_STREAM_MODEL_COLUMN_TIMESTAMP);
					_tmp9_ = dee_model_get_string (self->priv->_model, iter, (guint) GWIBBER_GTK_STREAM_MODEL_COLUMN_MESSAGE);
					_tmp10_ = dee_model_get_string (self->priv->_model, iter, (guint) GWIBBER_GTK_STREAM_MODEL_COLUMN_ICON_URI);
					_tmp11_ = dee_model_get_string (self->priv->_model, iter, (guint) GWIBBER_GTK_STREAM_MODEL_COLUMN_COLOR);
					gwibber_gtk_stream_view_tile_set_details (tile, self->priv->_position + i, _tmp6_, _tmp7_, (guint) _tmp8_, _tmp9_, _tmp10_, _tmp11_);
				} else {
					gwibber_gtk_stream_view_tile_reset (tile);
				}
				i++;
				_tmp12_ = gwibber_gtk_stream_view_get_position (self);
				if ((_tmp12_ + i) > n_rows) {
					iter = NULL;
				} else {
					DeeModelIter* _tmp13_ = NULL;
					_tmp13_ = dee_model_get_iter_at_row (self->priv->_model, self->priv->_position + i);
					iter = _tmp13_;
				}
				_g_object_unref0 (tile);
			}
		}
	}
	g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 0, __lambda8__gsource_func, g_object_ref (self), g_object_unref);
}


static void gwibber_gtk_stream_view_fill_up_remaining_space (GwibberGtkStreamView* self) {
	GtkAllocation alloc = {0};
	gint overall_height;
	gboolean one_was_hidden;
	GtkAllocation _tmp0_ = {0};
	gboolean _tmp4_ = FALSE;
	g_return_if_fail (self != NULL);
	overall_height = 0;
	one_was_hidden = FALSE;
	gtk_widget_get_allocation ((GtkWidget*) self->priv->layout, &_tmp0_);
	alloc = _tmp0_;
	{
		GSList* tile_collection;
		GSList* tile_it;
		tile_collection = self->priv->tiles;
		for (tile_it = tile_collection; tile_it != NULL; tile_it = tile_it->next) {
			GwibberGtkStreamViewTile* _tmp1_;
			GwibberGtkStreamViewTile* tile;
			_tmp1_ = _g_object_ref0 ((GwibberGtkStreamViewTile*) tile_it->data);
			tile = _tmp1_;
			{
				GtkAllocation a = {0};
				gboolean _tmp2_;
				_tmp2_ = gtk_widget_get_visible ((GtkWidget*) tile);
				if (_tmp2_) {
					GtkAllocation _tmp3_ = {0};
					gtk_widget_get_allocation ((GtkWidget*) tile, &_tmp3_);
					a = _tmp3_;
					overall_height = overall_height + (a.height + 8);
				} else {
					one_was_hidden = TRUE;
				}
				_g_object_unref0 (tile);
			}
		}
	}
	if (alloc.height > overall_height) {
		_tmp4_ = !one_was_hidden;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		GwibberGtkStreamViewTile* _tmp5_ = NULL;
		GwibberGtkStreamViewTile* tile;
		GwibberGtkStreamViewTile* _tmp6_;
		_tmp5_ = gwibber_gtk_stream_view_tile_new ();
		tile = g_object_ref_sink (_tmp5_);
		gtk_widget_show_all ((GtkWidget*) tile);
		gtk_box_pack_start ((GtkBox*) self->priv->view_box, (GtkWidget*) tile, FALSE, FALSE, (guint) 0);
		_tmp6_ = _g_object_ref0 (tile);
		self->priv->tiles = g_slist_append (self->priv->tiles, _tmp6_);
		gwibber_gtk_stream_view_refresh (self);
		_g_object_unref0 (tile);
	}
}


static gboolean gwibber_gtk_stream_view_on_layout_exposed (GwibberGtkStreamView* self, GdkEventExpose* event) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	result = FALSE;
	return result;
}


static void gwibber_gtk_stream_view_on_row_added (GwibberGtkStreamView* self) {
	g_return_if_fail (self != NULL);
	gwibber_gtk_stream_view_refresh (self);
}


static void gwibber_gtk_stream_view_on_row_removed (GwibberGtkStreamView* self) {
	g_return_if_fail (self != NULL);
	gwibber_gtk_stream_view_refresh (self);
}


static void gwibber_gtk_stream_view_on_row_changed (GwibberGtkStreamView* self) {
	g_return_if_fail (self != NULL);
	gwibber_gtk_stream_view_refresh (self);
}


DeeModel* gwibber_gtk_stream_view_get_model (GwibberGtkStreamView* self) {
	DeeModel* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_model;
	return result;
}


static void _gwibber_gtk_stream_view_on_row_added_dee_model_row_added (DeeModel* _sender, DeeModelIter* iter, gpointer self) {
	gwibber_gtk_stream_view_on_row_added (self);
}


static void _gwibber_gtk_stream_view_on_row_removed_dee_model_row_removed (DeeModel* _sender, DeeModelIter* iter, gpointer self) {
	gwibber_gtk_stream_view_on_row_removed (self);
}


static void _gwibber_gtk_stream_view_on_row_changed_dee_model_row_changed (DeeModel* _sender, DeeModelIter* iter, gpointer self) {
	gwibber_gtk_stream_view_on_row_changed (self);
}


void gwibber_gtk_stream_view_set_model (GwibberGtkStreamView* self, DeeModel* value) {
	DeeModel* _tmp3_;
	DeeModel* _tmp4_;
	guint _tmp5_;
	g_return_if_fail (self != NULL);
	if (DEE_IS_MODEL (self->priv->_model)) {
		guint _tmp0_;
		guint _tmp1_;
		guint _tmp2_;
		g_signal_parse_name ("row-added", DEE_TYPE_MODEL, &_tmp0_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (self->priv->_model, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp0_, 0, NULL, (GCallback) _gwibber_gtk_stream_view_on_row_added_dee_model_row_added, self);
		g_signal_parse_name ("row-removed", DEE_TYPE_MODEL, &_tmp1_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (self->priv->_model, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _gwibber_gtk_stream_view_on_row_removed_dee_model_row_removed, self);
		g_signal_parse_name ("row-changed", DEE_TYPE_MODEL, &_tmp2_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (self->priv->_model, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp2_, 0, NULL, (GCallback) _gwibber_gtk_stream_view_on_row_changed_dee_model_row_changed, self);
	}
	_tmp3_ = _g_object_ref0 (value);
	_tmp4_ = _tmp3_;
	_g_object_unref0 (self->priv->_model);
	self->priv->_model = _tmp4_;
	g_signal_connect_object (self->priv->_model, "row-added", (GCallback) _gwibber_gtk_stream_view_on_row_added_dee_model_row_added, self, 0);
	g_signal_connect_object (self->priv->_model, "row-removed", (GCallback) _gwibber_gtk_stream_view_on_row_removed_dee_model_row_removed, self, 0);
	g_signal_connect_object (self->priv->_model, "row-changed", (GCallback) _gwibber_gtk_stream_view_on_row_changed_dee_model_row_changed, self, 0);
	_tmp5_ = dee_model_get_n_rows (self->priv->_model);
	gtk_adjustment_set_upper (self->priv->adjustment, (gdouble) _tmp5_);
	gwibber_gtk_stream_view_refresh (self);
	g_object_notify ((GObject *) self, "model");
}


guint gwibber_gtk_stream_view_get_position (GwibberGtkStreamView* self) {
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_position;
	return result;
}


void gwibber_gtk_stream_view_set_position (GwibberGtkStreamView* self, guint value) {
	g_return_if_fail (self != NULL);
	if (self->priv->_position != value) {
		guint _tmp0_;
		guint _tmp1_;
		self->priv->_position = value;
		_tmp0_ = dee_model_get_n_rows (self->priv->_model);
		_tmp1_ = CLAMP (value, (guint) 0, _tmp0_);
		value = _tmp1_;
		gtk_adjustment_set_value (self->priv->adjustment, (gdouble) value);
		gwibber_gtk_stream_view_refresh (self);
	}
	g_object_notify ((GObject *) self, "position");
}


static void _lambda9_ (GwibberGtkStreamView* self) {
	gdouble _tmp0_;
	_tmp0_ = gtk_adjustment_get_value (self->priv->adjustment);
	self->priv->_position = (guint) ((gint) _tmp0_);
	gwibber_gtk_stream_view_refresh (self);
}


static void __lambda9__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_lambda9_ (self);
}


static gboolean _gwibber_gtk_stream_view_on_layout_exposed_gtk_widget_expose_event (GtkWidget* _sender, GdkEventExpose* event, gpointer self) {
	gboolean result;
	result = gwibber_gtk_stream_view_on_layout_exposed (self, event);
	return result;
}


static void _lambda10_ (GdkRectangle* a, GwibberGtkStreamView* self) {
	gboolean _tmp0_ = FALSE;
	if (self->priv->last_width != (*a).width) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = self->priv->last_height != (*a).height;
	}
	if (_tmp0_) {
		self->priv->last_width = (*a).width;
		self->priv->last_height = (*a).height;
		gtk_widget_set_size_request ((GtkWidget*) self->priv->view_box, self->priv->last_width, -1);
		gwibber_gtk_stream_view_refresh (self);
	}
}


static void __lambda10__gtk_widget_size_allocate (GtkWidget* _sender, GdkRectangle* allocation, gpointer self) {
	_lambda10_ (allocation, self);
}


static GObject * gwibber_gtk_stream_view_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	GwibberGtkStreamView * self;
	GtkAdjustment* _tmp0_ = NULL;
	GtkAdjustment* _tmp1_;
	GtkLayout* _tmp2_ = NULL;
	GtkLayout* _tmp3_;
	GtkVBox* _tmp4_ = NULL;
	GtkVBox* _tmp5_;
	GtkVScrollbar* _tmp6_ = NULL;
	GtkVScrollbar* _tmp7_;
	parent_class = G_OBJECT_CLASS (gwibber_gtk_stream_view_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = GWIBBER_GTK_STREAM_VIEW (obj);
	_tmp0_ = (GtkAdjustment*) gtk_adjustment_new ((gdouble) 0, (gdouble) 0, (gdouble) 1, (gdouble) 1, (gdouble) 1, (gdouble) 1);
	_tmp1_ = g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->adjustment);
	self->priv->adjustment = _tmp1_;
	g_signal_connect_object ((GObject*) self->priv->adjustment, "notify::value", (GCallback) __lambda9__g_object_notify, self, 0);
	_tmp2_ = (GtkLayout*) gtk_layout_new (NULL, NULL);
	_tmp3_ = g_object_ref_sink (_tmp2_);
	_g_object_unref0 (self->priv->layout);
	self->priv->layout = _tmp3_;
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) self->priv->layout, TRUE, TRUE, (guint) 0);
	g_signal_connect_object ((GtkWidget*) self->priv->layout, "expose-event", (GCallback) _gwibber_gtk_stream_view_on_layout_exposed_gtk_widget_expose_event, self, 0);
	_tmp4_ = (GtkVBox*) gtk_vbox_new (FALSE, 8);
	_tmp5_ = g_object_ref_sink (_tmp4_);
	_g_object_unref0 (self->priv->view_box);
	self->priv->view_box = _tmp5_;
	gtk_layout_put (self->priv->layout, (GtkWidget*) self->priv->view_box, 0, 0);
	_tmp6_ = (GtkVScrollbar*) gtk_vscrollbar_new (self->priv->adjustment);
	_tmp7_ = g_object_ref_sink (_tmp6_);
	_g_object_unref0 (self->priv->scrollbar);
	self->priv->scrollbar = _tmp7_;
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) self->priv->scrollbar, FALSE, FALSE, (guint) 0);
	{
		gint i;
		i = 0;
		{
			gboolean _tmp8_;
			_tmp8_ = TRUE;
			while (TRUE) {
				GwibberGtkStreamViewTile* _tmp9_ = NULL;
				GwibberGtkStreamViewTile* tile;
				GwibberGtkStreamViewTile* _tmp10_;
				if (!_tmp8_) {
					i++;
				}
				_tmp8_ = FALSE;
				if (!(i < 3)) {
					break;
				}
				_tmp9_ = gwibber_gtk_stream_view_tile_new ();
				tile = g_object_ref_sink (_tmp9_);
				gtk_widget_show_all ((GtkWidget*) tile);
				gtk_box_pack_start ((GtkBox*) self->priv->view_box, (GtkWidget*) tile, FALSE, FALSE, (guint) 0);
				_tmp10_ = _g_object_ref0 (tile);
				self->priv->tiles = g_slist_append (self->priv->tiles, _tmp10_);
				_g_object_unref0 (tile);
			}
		}
	}
	g_signal_connect_object ((GtkWidget*) self->priv->layout, "size-allocate", (GCallback) __lambda10__gtk_widget_size_allocate, self, G_CONNECT_AFTER);
	return obj;
}


static void gwibber_gtk_stream_view_class_init (GwibberGtkStreamViewClass * klass) {
	gwibber_gtk_stream_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GwibberGtkStreamViewPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_gwibber_gtk_stream_view_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gwibber_gtk_stream_view_set_property;
	G_OBJECT_CLASS (klass)->constructor = gwibber_gtk_stream_view_constructor;
	G_OBJECT_CLASS (klass)->finalize = gwibber_gtk_stream_view_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GWIBBER_GTK_STREAM_VIEW_MODEL, g_param_spec_object ("model", "model", "model", DEE_TYPE_MODEL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GWIBBER_GTK_STREAM_VIEW_POSITION, g_param_spec_uint ("position", "position", "position", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void gwibber_gtk_stream_view_instance_init (GwibberGtkStreamView * self) {
	self->priv = GWIBBER_GTK_STREAM_VIEW_GET_PRIVATE (self);
	self->priv->_model = NULL;
	self->priv->_position = (guint) 0;
	self->priv->last_width = 0;
	self->priv->last_height = 0;
}


static void gwibber_gtk_stream_view_finalize (GObject* obj) {
	GwibberGtkStreamView * self;
	self = GWIBBER_GTK_STREAM_VIEW (obj);
	_g_object_unref0 (self->priv->adjustment);
	_g_object_unref0 (self->priv->scrollbar);
	_g_object_unref0 (self->priv->layout);
	_g_object_unref0 (self->priv->view_box);
	_g_object_unref0 (self->priv->_model);
	__g_slist_free__g_object_unref0_0 (self->priv->tiles);
	G_OBJECT_CLASS (gwibber_gtk_stream_view_parent_class)->finalize (obj);
}


GType gwibber_gtk_stream_view_get_type (void) {
	static volatile gsize gwibber_gtk_stream_view_type_id__volatile = 0;
	if (g_once_init_enter (&gwibber_gtk_stream_view_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GwibberGtkStreamViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gwibber_gtk_stream_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GwibberGtkStreamView), 0, (GInstanceInitFunc) gwibber_gtk_stream_view_instance_init, NULL };
		GType gwibber_gtk_stream_view_type_id;
		gwibber_gtk_stream_view_type_id = g_type_register_static (GTK_TYPE_HBOX, "GwibberGtkStreamView", &g_define_type_info, 0);
		g_once_init_leave (&gwibber_gtk_stream_view_type_id__volatile, gwibber_gtk_stream_view_type_id);
	}
	return gwibber_gtk_stream_view_type_id__volatile;
}


static void _vala_gwibber_gtk_stream_view_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GwibberGtkStreamView * self;
	self = GWIBBER_GTK_STREAM_VIEW (object);
	switch (property_id) {
		case GWIBBER_GTK_STREAM_VIEW_MODEL:
		g_value_set_object (value, gwibber_gtk_stream_view_get_model (self));
		break;
		case GWIBBER_GTK_STREAM_VIEW_POSITION:
		g_value_set_uint (value, gwibber_gtk_stream_view_get_position (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_gwibber_gtk_stream_view_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GwibberGtkStreamView * self;
	self = GWIBBER_GTK_STREAM_VIEW (object);
	switch (property_id) {
		case GWIBBER_GTK_STREAM_VIEW_MODEL:
		gwibber_gtk_stream_view_set_model (self, g_value_get_object (value));
		break;
		case GWIBBER_GTK_STREAM_VIEW_POSITION:
		gwibber_gtk_stream_view_set_position (self, g_value_get_uint (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



