/* abstractmultimap.c generated by valac, the Vala compiler
 * generated from abstractmultimap.vala, do not modify */

/* abstractmultimap.vala
 *
 * Copyright (C) 2009  Ali Sabil
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Ali Sabil <ali.sabil@gmail.com>
 * 	Didier 'Ptitjes Villevalois <ptitjes@free.fr>
 */

#include <glib.h>
#include <glib-object.h>


#define GEE_TYPE_MULTI_MAP (gee_multi_map_get_type ())
#define GEE_MULTI_MAP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_MULTI_MAP, GeeMultiMap))
#define GEE_IS_MULTI_MAP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_MULTI_MAP))
#define GEE_MULTI_MAP_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_MULTI_MAP, GeeMultiMapIface))

typedef struct _GeeMultiMap GeeMultiMap;
typedef struct _GeeMultiMapIface GeeMultiMapIface;

#define GEE_TYPE_ITERABLE (gee_iterable_get_type ())
#define GEE_ITERABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ITERABLE, GeeIterable))
#define GEE_IS_ITERABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ITERABLE))
#define GEE_ITERABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_ITERABLE, GeeIterableIface))

typedef struct _GeeIterable GeeIterable;
typedef struct _GeeIterableIface GeeIterableIface;

#define GEE_TYPE_ITERATOR (gee_iterator_get_type ())
#define GEE_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ITERATOR, GeeIterator))
#define GEE_IS_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ITERATOR))
#define GEE_ITERATOR_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_ITERATOR, GeeIteratorIface))

typedef struct _GeeIterator GeeIterator;
typedef struct _GeeIteratorIface GeeIteratorIface;

#define GEE_TYPE_COLLECTION (gee_collection_get_type ())
#define GEE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_COLLECTION, GeeCollection))
#define GEE_IS_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_COLLECTION))
#define GEE_COLLECTION_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_COLLECTION, GeeCollectionIface))

typedef struct _GeeCollection GeeCollection;
typedef struct _GeeCollectionIface GeeCollectionIface;

#define GEE_TYPE_SET (gee_set_get_type ())
#define GEE_SET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_SET, GeeSet))
#define GEE_IS_SET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_SET))
#define GEE_SET_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_SET, GeeSetIface))

typedef struct _GeeSet GeeSet;
typedef struct _GeeSetIface GeeSetIface;

#define GEE_TYPE_MULTI_SET (gee_multi_set_get_type ())
#define GEE_MULTI_SET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_MULTI_SET, GeeMultiSet))
#define GEE_IS_MULTI_SET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_MULTI_SET))
#define GEE_MULTI_SET_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_MULTI_SET, GeeMultiSetIface))

typedef struct _GeeMultiSet GeeMultiSet;
typedef struct _GeeMultiSetIface GeeMultiSetIface;

#define GEE_TYPE_ABSTRACT_MULTI_MAP (gee_abstract_multi_map_get_type ())
#define GEE_ABSTRACT_MULTI_MAP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ABSTRACT_MULTI_MAP, GeeAbstractMultiMap))
#define GEE_ABSTRACT_MULTI_MAP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_ABSTRACT_MULTI_MAP, GeeAbstractMultiMapClass))
#define GEE_IS_ABSTRACT_MULTI_MAP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ABSTRACT_MULTI_MAP))
#define GEE_IS_ABSTRACT_MULTI_MAP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_ABSTRACT_MULTI_MAP))
#define GEE_ABSTRACT_MULTI_MAP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_ABSTRACT_MULTI_MAP, GeeAbstractMultiMapClass))

typedef struct _GeeAbstractMultiMap GeeAbstractMultiMap;
typedef struct _GeeAbstractMultiMapClass GeeAbstractMultiMapClass;
typedef struct _GeeAbstractMultiMapPrivate GeeAbstractMultiMapPrivate;

#define GEE_TYPE_MAP (gee_map_get_type ())
#define GEE_MAP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_MAP, GeeMap))
#define GEE_IS_MAP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_MAP))
#define GEE_MAP_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_MAP, GeeMapIface))

typedef struct _GeeMap GeeMap;
typedef struct _GeeMapIface GeeMapIface;

#define GEE_TYPE_MAP_ITERATOR (gee_map_iterator_get_type ())
#define GEE_MAP_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_MAP_ITERATOR, GeeMapIterator))
#define GEE_IS_MAP_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_MAP_ITERATOR))
#define GEE_MAP_ITERATOR_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_MAP_ITERATOR, GeeMapIteratorIface))

typedef struct _GeeMapIterator GeeMapIterator;
typedef struct _GeeMapIteratorIface GeeMapIteratorIface;

#define GEE_MAP_TYPE_ENTRY (gee_map_entry_get_type ())
#define GEE_MAP_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_MAP_TYPE_ENTRY, GeeMapEntry))
#define GEE_MAP_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_MAP_TYPE_ENTRY, GeeMapEntryClass))
#define GEE_MAP_IS_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_MAP_TYPE_ENTRY))
#define GEE_MAP_IS_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_MAP_TYPE_ENTRY))
#define GEE_MAP_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_MAP_TYPE_ENTRY, GeeMapEntryClass))

typedef struct _GeeMapEntry GeeMapEntry;
typedef struct _GeeMapEntryClass GeeMapEntryClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define GEE_TYPE_ABSTRACT_COLLECTION (gee_abstract_collection_get_type ())
#define GEE_ABSTRACT_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection))
#define GEE_ABSTRACT_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollectionClass))
#define GEE_IS_ABSTRACT_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ABSTRACT_COLLECTION))
#define GEE_IS_ABSTRACT_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_ABSTRACT_COLLECTION))
#define GEE_ABSTRACT_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollectionClass))

typedef struct _GeeAbstractCollection GeeAbstractCollection;
typedef struct _GeeAbstractCollectionClass GeeAbstractCollectionClass;

#define GEE_TYPE_ABSTRACT_LIST (gee_abstract_list_get_type ())
#define GEE_ABSTRACT_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ABSTRACT_LIST, GeeAbstractList))
#define GEE_ABSTRACT_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_ABSTRACT_LIST, GeeAbstractListClass))
#define GEE_IS_ABSTRACT_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ABSTRACT_LIST))
#define GEE_IS_ABSTRACT_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_ABSTRACT_LIST))
#define GEE_ABSTRACT_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_ABSTRACT_LIST, GeeAbstractListClass))

typedef struct _GeeAbstractList GeeAbstractList;
typedef struct _GeeAbstractListClass GeeAbstractListClass;

#define GEE_TYPE_ARRAY_LIST (gee_array_list_get_type ())
#define GEE_ARRAY_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ARRAY_LIST, GeeArrayList))
#define GEE_ARRAY_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_ARRAY_LIST, GeeArrayListClass))
#define GEE_IS_ARRAY_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ARRAY_LIST))
#define GEE_IS_ARRAY_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_ARRAY_LIST))
#define GEE_ARRAY_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_ARRAY_LIST, GeeArrayListClass))

typedef struct _GeeArrayList GeeArrayList;
typedef struct _GeeArrayListClass GeeArrayListClass;

struct _GeeIteratorIface {
	GTypeInterface parent_iface;
	gboolean (*next) (GeeIterator* self);
	gboolean (*has_next) (GeeIterator* self);
	gboolean (*first) (GeeIterator* self);
	gpointer (*get) (GeeIterator* self);
	void (*remove) (GeeIterator* self);
};

struct _GeeIterableIface {
	GTypeInterface parent_iface;
	GeeIterator* (*iterator) (GeeIterable* self);
	GType (*get_element_type) (GeeIterable* self);
};

struct _GeeCollectionIface {
	GTypeInterface parent_iface;
	gboolean (*contains) (GeeCollection* self, gconstpointer item);
	gboolean (*add) (GeeCollection* self, gconstpointer item);
	gboolean (*remove) (GeeCollection* self, gconstpointer item);
	void (*clear) (GeeCollection* self);
	gboolean (*add_all) (GeeCollection* self, GeeCollection* collection);
	gboolean (*contains_all) (GeeCollection* self, GeeCollection* collection);
	gboolean (*remove_all) (GeeCollection* self, GeeCollection* collection);
	gboolean (*retain_all) (GeeCollection* self, GeeCollection* collection);
	gpointer* (*to_array) (GeeCollection* self, int* result_length1);
	gint (*get_size) (GeeCollection* self);
	gboolean (*get_is_empty) (GeeCollection* self);
	GeeCollection* (*get_read_only_view) (GeeCollection* self);
};

struct _GeeSetIface {
	GTypeInterface parent_iface;
	GeeSet* (*get_read_only_view) (GeeSet* self);
};

struct _GeeMultiSetIface {
	GTypeInterface parent_iface;
	gint (*count) (GeeMultiSet* self, gconstpointer item);
};

struct _GeeMultiMapIface {
	GTypeInterface parent_iface;
	GeeSet* (*get_keys) (GeeMultiMap* self);
	GeeMultiSet* (*get_all_keys) (GeeMultiMap* self);
	GeeCollection* (*get_values) (GeeMultiMap* self);
	gboolean (*contains) (GeeMultiMap* self, gconstpointer key);
	GeeCollection* (*get) (GeeMultiMap* self, gconstpointer key);
	void (*set) (GeeMultiMap* self, gconstpointer key, gconstpointer value);
	gboolean (*remove) (GeeMultiMap* self, gconstpointer key, gconstpointer value);
	gboolean (*remove_all) (GeeMultiMap* self, gconstpointer key);
	void (*clear) (GeeMultiMap* self);
	gint (*get_size) (GeeMultiMap* self);
};

struct _GeeMapIteratorIface {
	GTypeInterface parent_iface;
	gboolean (*next) (GeeMapIterator* self);
	gboolean (*has_next) (GeeMapIterator* self);
	gboolean (*first) (GeeMapIterator* self);
	gpointer (*get_key) (GeeMapIterator* self);
	gpointer (*get_value) (GeeMapIterator* self);
	void (*set_value) (GeeMapIterator* self, gconstpointer value);
	void (*unset) (GeeMapIterator* self);
};

struct _GeeMapIface {
	GTypeInterface parent_iface;
	gboolean (*has_key) (GeeMap* self, gconstpointer key);
	gboolean (*contains) (GeeMap* self, gconstpointer key);
	gboolean (*has) (GeeMap* self, gconstpointer key, gconstpointer value);
	gpointer (*get) (GeeMap* self, gconstpointer key);
	void (*set) (GeeMap* self, gconstpointer key, gconstpointer value);
	gboolean (*unset) (GeeMap* self, gconstpointer key, gpointer* value);
	gboolean (*remove) (GeeMap* self, gconstpointer key, gpointer* value);
	void (*clear) (GeeMap* self);
	GeeMapIterator* (*map_iterator) (GeeMap* self);
	void (*set_all) (GeeMap* self, GeeMap* map);
	gboolean (*unset_all) (GeeMap* self, GeeMap* map);
	gboolean (*remove_all) (GeeMap* self, GeeMap* map);
	gboolean (*has_all) (GeeMap* self, GeeMap* map);
	gboolean (*contains_all) (GeeMap* self, GeeMap* map);
	gint (*get_size) (GeeMap* self);
	gboolean (*get_is_empty) (GeeMap* self);
	GeeSet* (*get_keys) (GeeMap* self);
	GeeCollection* (*get_values) (GeeMap* self);
	GeeSet* (*get_entries) (GeeMap* self);
	GeeMap* (*get_read_only_view) (GeeMap* self);
	GType (*get_key_type) (GeeMap* self);
	GType (*get_value_type) (GeeMap* self);
};

struct _GeeAbstractMultiMap {
	GObject parent_instance;
	GeeAbstractMultiMapPrivate * priv;
	GeeMap* _storage_map;
};

struct _GeeAbstractMultiMapClass {
	GObjectClass parent_class;
	GeeCollection* (*create_value_storage) (GeeAbstractMultiMap* self);
	GeeMultiSet* (*create_multi_key_set) (GeeAbstractMultiMap* self);
	GEqualFunc (*get_value_equal_func) (GeeAbstractMultiMap* self);
};

struct _GeeAbstractMultiMapPrivate {
	GType k_type;
	GBoxedCopyFunc k_dup_func;
	GDestroyNotify k_destroy_func;
	GType v_type;
	GBoxedCopyFunc v_dup_func;
	GDestroyNotify v_destroy_func;
	gint _nitems;
	GeeSet* _empty_value_set;
};


static gpointer gee_abstract_multi_map_parent_class = NULL;
static GeeMultiMapIface* gee_abstract_multi_map_gee_multi_map_parent_iface = NULL;

GType gee_iterator_get_type (void);
GType gee_iterable_get_type (void);
GType gee_collection_get_type (void);
GType gee_set_get_type (void);
GType gee_multi_set_get_type (void);
GType gee_multi_map_get_type (void);
GType gee_abstract_multi_map_get_type (void);
GType gee_map_iterator_get_type (void);
GType gee_map_entry_get_type (void);
GType gee_map_get_type (void);
#define GEE_ABSTRACT_MULTI_MAP_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GEE_TYPE_ABSTRACT_MULTI_MAP, GeeAbstractMultiMapPrivate))
enum  {
	GEE_ABSTRACT_MULTI_MAP_DUMMY_PROPERTY,
	GEE_ABSTRACT_MULTI_MAP_SIZE,
	GEE_ABSTRACT_MULTI_MAP_K_TYPE,
	GEE_ABSTRACT_MULTI_MAP_K_DUP_FUNC,
	GEE_ABSTRACT_MULTI_MAP_K_DESTROY_FUNC,
	GEE_ABSTRACT_MULTI_MAP_V_TYPE,
	GEE_ABSTRACT_MULTI_MAP_V_DUP_FUNC,
	GEE_ABSTRACT_MULTI_MAP_V_DESTROY_FUNC
};
GeeSet* gee_set_empty (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func);
GeeAbstractMultiMap* gee_abstract_multi_map_construct (GType object_type, GType k_type, GBoxedCopyFunc k_dup_func, GDestroyNotify k_destroy_func, GType v_type, GBoxedCopyFunc v_dup_func, GDestroyNotify v_destroy_func, GeeMap* storage_map);
GeeCollection* gee_abstract_multi_map_create_value_storage (GeeAbstractMultiMap* self);
static GeeCollection* gee_abstract_multi_map_real_create_value_storage (GeeAbstractMultiMap* self);
GeeMultiSet* gee_abstract_multi_map_create_multi_key_set (GeeAbstractMultiMap* self);
static GeeMultiSet* gee_abstract_multi_map_real_create_multi_key_set (GeeAbstractMultiMap* self);
GEqualFunc gee_abstract_multi_map_get_value_equal_func (GeeAbstractMultiMap* self);
static GEqualFunc gee_abstract_multi_map_real_get_value_equal_func (GeeAbstractMultiMap* self);
GeeSet* gee_map_get_keys (GeeMap* self);
static GeeSet* gee_abstract_multi_map_real_get_keys (GeeMultiMap* base);
GeeSet* gee_map_get_entries (GeeMap* self);
GeeIterator* gee_iterable_iterator (GeeIterable* self);
gboolean gee_iterator_next (GeeIterator* self);
gpointer gee_iterator_get (GeeIterator* self);
gconstpointer gee_map_entry_get_value (GeeMapEntry* self);
gint gee_collection_get_size (GeeCollection* self);
gboolean gee_collection_add (GeeCollection* self, gconstpointer item);
gconstpointer gee_map_entry_get_key (GeeMapEntry* self);
static GeeMultiSet* gee_abstract_multi_map_real_get_all_keys (GeeMultiMap* base);
GeeArrayList* gee_array_list_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GEqualFunc equal_func);
GeeArrayList* gee_array_list_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GEqualFunc equal_func);
GType gee_abstract_collection_get_type (void);
GType gee_abstract_list_get_type (void);
GType gee_array_list_get_type (void);
gboolean gee_abstract_collection_add (GeeAbstractCollection* self, gconstpointer item);
static GeeCollection* gee_abstract_multi_map_real_get_values (GeeMultiMap* base);
gboolean gee_map_contains (GeeMap* self, gconstpointer key);
static gboolean gee_abstract_multi_map_real_contains (GeeMultiMap* base, gconstpointer key);
gpointer gee_map_get (GeeMap* self, gconstpointer key);
GeeCollection* gee_collection_get_read_only_view (GeeCollection* self);
static GeeCollection* gee_abstract_multi_map_real_get (GeeMultiMap* base, gconstpointer key);
void gee_map_set (GeeMap* self, gconstpointer key, gconstpointer value);
static void gee_abstract_multi_map_real_set (GeeMultiMap* base, gconstpointer key, gconstpointer value);
gboolean gee_collection_contains (GeeCollection* self, gconstpointer item);
gboolean gee_collection_remove (GeeCollection* self, gconstpointer item);
gboolean gee_map_remove (GeeMap* self, gconstpointer key, gpointer* value);
static gboolean gee_abstract_multi_map_real_remove (GeeMultiMap* base, gconstpointer key, gconstpointer value);
static gboolean gee_abstract_multi_map_real_remove_all (GeeMultiMap* base, gconstpointer key);
void gee_map_clear (GeeMap* self);
static void gee_abstract_multi_map_real_clear (GeeMultiMap* base);
static void gee_abstract_multi_map_finalize (GObject* obj);
gint gee_multi_map_get_size (GeeMultiMap* self);
static void gee_abstract_multi_map_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void gee_abstract_multi_map_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);



static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


#line 39 "abstractmultimap.vala"
GeeAbstractMultiMap* gee_abstract_multi_map_construct (GType object_type, GType k_type, GBoxedCopyFunc k_dup_func, GDestroyNotify k_destroy_func, GType v_type, GBoxedCopyFunc v_dup_func, GDestroyNotify v_destroy_func, GeeMap* storage_map) {
#line 343 "abstractmultimap.c"
	GeeAbstractMultiMap * self;
	GeeMap* _tmp0_;
	GeeSet* _tmp1_;
#line 39 "abstractmultimap.vala"
	g_return_val_if_fail (storage_map != NULL, NULL);
#line 39 "abstractmultimap.vala"
	self = (GeeAbstractMultiMap*) g_object_new (object_type, NULL);
#line 39 "abstractmultimap.vala"
	self->priv->k_type = k_type;
#line 39 "abstractmultimap.vala"
	self->priv->k_dup_func = k_dup_func;
#line 39 "abstractmultimap.vala"
	self->priv->k_destroy_func = k_destroy_func;
#line 39 "abstractmultimap.vala"
	self->priv->v_type = v_type;
#line 39 "abstractmultimap.vala"
	self->priv->v_dup_func = v_dup_func;
#line 39 "abstractmultimap.vala"
	self->priv->v_destroy_func = v_destroy_func;
#line 40 "abstractmultimap.vala"
	self->_storage_map = (_tmp0_ = _g_object_ref0 (storage_map), _g_object_unref0 (self->_storage_map), _tmp0_);
#line 41 "abstractmultimap.vala"
	self->priv->_empty_value_set = (_tmp1_ = gee_set_empty (v_type, (GBoxedCopyFunc) v_dup_func, v_destroy_func), _g_object_unref0 (self->priv->_empty_value_set), _tmp1_);
#line 367 "abstractmultimap.c"
	return self;
}


#line 44 "abstractmultimap.vala"
static GeeCollection* gee_abstract_multi_map_real_create_value_storage (GeeAbstractMultiMap* self) {
#line 374 "abstractmultimap.c"
	g_return_val_if_fail (self != NULL, NULL);
	g_critical ("Type `%s' does not implement abstract method `gee_abstract_multi_map_create_value_storage'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}


#line 44 "abstractmultimap.vala"
GeeCollection* gee_abstract_multi_map_create_value_storage (GeeAbstractMultiMap* self) {
#line 44 "abstractmultimap.vala"
	return GEE_ABSTRACT_MULTI_MAP_GET_CLASS (self)->create_value_storage (self);
#line 385 "abstractmultimap.c"
}


#line 46 "abstractmultimap.vala"
static GeeMultiSet* gee_abstract_multi_map_real_create_multi_key_set (GeeAbstractMultiMap* self) {
#line 391 "abstractmultimap.c"
	g_return_val_if_fail (self != NULL, NULL);
	g_critical ("Type `%s' does not implement abstract method `gee_abstract_multi_map_create_multi_key_set'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}


#line 46 "abstractmultimap.vala"
GeeMultiSet* gee_abstract_multi_map_create_multi_key_set (GeeAbstractMultiMap* self) {
#line 46 "abstractmultimap.vala"
	return GEE_ABSTRACT_MULTI_MAP_GET_CLASS (self)->create_multi_key_set (self);
#line 402 "abstractmultimap.c"
}


#line 48 "abstractmultimap.vala"
static GEqualFunc gee_abstract_multi_map_real_get_value_equal_func (GeeAbstractMultiMap* self) {
#line 408 "abstractmultimap.c"
	g_return_val_if_fail (self != NULL, NULL);
	g_critical ("Type `%s' does not implement abstract method `gee_abstract_multi_map_get_value_equal_func'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}


#line 48 "abstractmultimap.vala"
GEqualFunc gee_abstract_multi_map_get_value_equal_func (GeeAbstractMultiMap* self) {
#line 48 "abstractmultimap.vala"
	return GEE_ABSTRACT_MULTI_MAP_GET_CLASS (self)->get_value_equal_func (self);
#line 419 "abstractmultimap.c"
}


#line 50 "abstractmultimap.vala"
static GeeSet* gee_abstract_multi_map_real_get_keys (GeeMultiMap* base) {
#line 425 "abstractmultimap.c"
	GeeAbstractMultiMap * self;
	GeeSet* result;
	self = (GeeAbstractMultiMap*) base;
	result = gee_map_get_keys (self->_storage_map);
#line 51 "abstractmultimap.vala"
	return result;
#line 432 "abstractmultimap.c"
}


#line 54 "abstractmultimap.vala"
static GeeMultiSet* gee_abstract_multi_map_real_get_all_keys (GeeMultiMap* base) {
#line 438 "abstractmultimap.c"
	GeeAbstractMultiMap * self;
	GeeMultiSet* result;
	GeeMultiSet* _result_;
	self = (GeeAbstractMultiMap*) base;
#line 55 "abstractmultimap.vala"
	_result_ = gee_abstract_multi_map_create_multi_key_set (self);
#line 445 "abstractmultimap.c"
	{
		GeeSet* _tmp0_;
		GeeIterator* _tmp1_;
		GeeIterator* _entry_it;
		_entry_it = (_tmp1_ = gee_iterable_iterator ((GeeIterable*) (_tmp0_ = gee_map_get_entries (self->_storage_map))), _g_object_unref0 (_tmp0_), _tmp1_);
#line 56 "abstractmultimap.vala"
		while (TRUE) {
#line 453 "abstractmultimap.c"
			GeeMapEntry* entry;
#line 56 "abstractmultimap.vala"
			if (!gee_iterator_next (_entry_it)) {
#line 56 "abstractmultimap.vala"
				break;
#line 459 "abstractmultimap.c"
			}
#line 56 "abstractmultimap.vala"
			entry = (GeeMapEntry*) gee_iterator_get (_entry_it);
#line 463 "abstractmultimap.c"
			{
				gint i;
#line 57 "abstractmultimap.vala"
				i = 0;
#line 468 "abstractmultimap.c"
				{
					gboolean _tmp2_;
#line 57 "abstractmultimap.vala"
					_tmp2_ = TRUE;
#line 57 "abstractmultimap.vala"
					while (TRUE) {
#line 57 "abstractmultimap.vala"
						if (!_tmp2_) {
#line 57 "abstractmultimap.vala"
							i++;
#line 479 "abstractmultimap.c"
						}
#line 57 "abstractmultimap.vala"
						_tmp2_ = FALSE;
#line 57 "abstractmultimap.vala"
						if (!(i < gee_collection_get_size ((GeeCollection*) gee_map_entry_get_value (entry)))) {
#line 57 "abstractmultimap.vala"
							break;
#line 487 "abstractmultimap.c"
						}
#line 58 "abstractmultimap.vala"
						gee_collection_add ((GeeCollection*) _result_, gee_map_entry_get_key (entry));
#line 491 "abstractmultimap.c"
					}
				}
			}
			_g_object_unref0 (entry);
		}
		_g_object_unref0 (_entry_it);
	}
	result = _result_;
#line 61 "abstractmultimap.vala"
	return result;
#line 502 "abstractmultimap.c"
}


#line 64 "abstractmultimap.vala"
static GeeCollection* gee_abstract_multi_map_real_get_values (GeeMultiMap* base) {
#line 508 "abstractmultimap.c"
	GeeAbstractMultiMap * self;
	GeeCollection* result;
	GeeArrayList* _result_;
	self = (GeeAbstractMultiMap*) base;
#line 65 "abstractmultimap.vala"
	_result_ = gee_array_list_new (self->priv->v_type, (GBoxedCopyFunc) self->priv->v_dup_func, self->priv->v_destroy_func, gee_abstract_multi_map_get_value_equal_func (self));
#line 515 "abstractmultimap.c"
	{
		GeeSet* _tmp0_;
		GeeIterator* _tmp1_;
		GeeIterator* _entry_it;
		_entry_it = (_tmp1_ = gee_iterable_iterator ((GeeIterable*) (_tmp0_ = gee_map_get_entries (self->_storage_map))), _g_object_unref0 (_tmp0_), _tmp1_);
#line 66 "abstractmultimap.vala"
		while (TRUE) {
#line 523 "abstractmultimap.c"
			GeeMapEntry* entry;
#line 66 "abstractmultimap.vala"
			if (!gee_iterator_next (_entry_it)) {
#line 66 "abstractmultimap.vala"
				break;
#line 529 "abstractmultimap.c"
			}
#line 66 "abstractmultimap.vala"
			entry = (GeeMapEntry*) gee_iterator_get (_entry_it);
#line 533 "abstractmultimap.c"
			{
				GeeIterator* _value_it;
				_value_it = gee_iterable_iterator ((GeeIterable*) ((GeeCollection*) gee_map_entry_get_value (entry)));
#line 67 "abstractmultimap.vala"
				while (TRUE) {
#line 539 "abstractmultimap.c"
					gpointer value;
#line 67 "abstractmultimap.vala"
					if (!gee_iterator_next (_value_it)) {
#line 67 "abstractmultimap.vala"
						break;
#line 545 "abstractmultimap.c"
					}
#line 67 "abstractmultimap.vala"
					value = gee_iterator_get (_value_it);
#line 68 "abstractmultimap.vala"
					gee_abstract_collection_add ((GeeAbstractCollection*) _result_, value);
#line 551 "abstractmultimap.c"
					((value == NULL) || (self->priv->v_destroy_func == NULL)) ? NULL : (value = (self->priv->v_destroy_func (value), NULL));
				}
				_g_object_unref0 (_value_it);
			}
			_g_object_unref0 (entry);
		}
		_g_object_unref0 (_entry_it);
	}
	result = (GeeCollection*) _result_;
#line 71 "abstractmultimap.vala"
	return result;
#line 563 "abstractmultimap.c"
}


#line 74 "abstractmultimap.vala"
static gboolean gee_abstract_multi_map_real_contains (GeeMultiMap* base, gconstpointer key) {
#line 569 "abstractmultimap.c"
	GeeAbstractMultiMap * self;
	gboolean result;
	self = (GeeAbstractMultiMap*) base;
	result = gee_map_contains (self->_storage_map, key);
#line 75 "abstractmultimap.vala"
	return result;
#line 576 "abstractmultimap.c"
}


#line 78 "abstractmultimap.vala"
static GeeCollection* gee_abstract_multi_map_real_get (GeeMultiMap* base, gconstpointer key) {
#line 582 "abstractmultimap.c"
	GeeAbstractMultiMap * self;
	GeeCollection* result;
	self = (GeeAbstractMultiMap*) base;
#line 79 "abstractmultimap.vala"
	if (gee_map_contains (self->_storage_map, key)) {
#line 588 "abstractmultimap.c"
		GeeCollection* _tmp0_;
		GeeCollection* _tmp1_;
		result = (_tmp1_ = gee_collection_get_read_only_view (_tmp0_ = (GeeCollection*) gee_map_get (self->_storage_map, key)), _g_object_unref0 (_tmp0_), _tmp1_);
#line 80 "abstractmultimap.vala"
		return result;
#line 594 "abstractmultimap.c"
	} else {
		result = _g_object_ref0 ((GeeCollection*) self->priv->_empty_value_set);
#line 82 "abstractmultimap.vala"
		return result;
#line 599 "abstractmultimap.c"
	}
}


#line 86 "abstractmultimap.vala"
static void gee_abstract_multi_map_real_set (GeeMultiMap* base, gconstpointer key, gconstpointer value) {
#line 606 "abstractmultimap.c"
	GeeAbstractMultiMap * self;
	self = (GeeAbstractMultiMap*) base;
#line 87 "abstractmultimap.vala"
	if (gee_map_contains (self->_storage_map, key)) {
#line 611 "abstractmultimap.c"
		GeeCollection* _tmp0_;
		gboolean _tmp1_;
#line 88 "abstractmultimap.vala"
		if ((_tmp1_ = gee_collection_add (_tmp0_ = (GeeCollection*) gee_map_get (self->_storage_map, key), value), _g_object_unref0 (_tmp0_), _tmp1_)) {
#line 89 "abstractmultimap.vala"
			self->priv->_nitems++;
#line 618 "abstractmultimap.c"
		}
	} else {
		GeeCollection* s;
#line 92 "abstractmultimap.vala"
		s = gee_abstract_multi_map_create_value_storage (self);
#line 93 "abstractmultimap.vala"
		gee_collection_add (s, value);
#line 94 "abstractmultimap.vala"
		gee_map_set (self->_storage_map, key, s);
#line 95 "abstractmultimap.vala"
		self->priv->_nitems++;
#line 630 "abstractmultimap.c"
		_g_object_unref0 (s);
	}
}


#line 99 "abstractmultimap.vala"
static gboolean gee_abstract_multi_map_real_remove (GeeMultiMap* base, gconstpointer key, gconstpointer value) {
#line 638 "abstractmultimap.c"
	GeeAbstractMultiMap * self;
	gboolean result;
	self = (GeeAbstractMultiMap*) base;
#line 100 "abstractmultimap.vala"
	if (gee_map_contains (self->_storage_map, key)) {
#line 644 "abstractmultimap.c"
		GeeCollection* values;
#line 101 "abstractmultimap.vala"
		values = (GeeCollection*) gee_map_get (self->_storage_map, key);
#line 102 "abstractmultimap.vala"
		if (gee_collection_contains (values, value)) {
#line 103 "abstractmultimap.vala"
			gee_collection_remove (values, value);
#line 104 "abstractmultimap.vala"
			self->priv->_nitems--;
#line 105 "abstractmultimap.vala"
			if (gee_collection_get_size (values) == 0) {
#line 106 "abstractmultimap.vala"
				gee_map_remove (self->_storage_map, key, NULL);
#line 658 "abstractmultimap.c"
			}
			result = TRUE;
			_g_object_unref0 (values);
#line 108 "abstractmultimap.vala"
			return result;
#line 664 "abstractmultimap.c"
		}
		_g_object_unref0 (values);
	}
	result = FALSE;
#line 111 "abstractmultimap.vala"
	return result;
#line 671 "abstractmultimap.c"
}


#line 114 "abstractmultimap.vala"
static gboolean gee_abstract_multi_map_real_remove_all (GeeMultiMap* base, gconstpointer key) {
#line 677 "abstractmultimap.c"
	GeeAbstractMultiMap * self;
	gboolean result;
	self = (GeeAbstractMultiMap*) base;
#line 115 "abstractmultimap.vala"
	if (gee_map_contains (self->_storage_map, key)) {
#line 683 "abstractmultimap.c"
		GeeCollection* _tmp0_;
		gint _tmp1_;
		gint size;
#line 116 "abstractmultimap.vala"
		size = (_tmp1_ = gee_collection_get_size (_tmp0_ = (GeeCollection*) gee_map_get (self->_storage_map, key)), _g_object_unref0 (_tmp0_), _tmp1_);
#line 117 "abstractmultimap.vala"
		if (gee_map_remove (self->_storage_map, key, NULL)) {
#line 118 "abstractmultimap.vala"
			self->priv->_nitems = self->priv->_nitems - size;
#line 693 "abstractmultimap.c"
			result = TRUE;
#line 119 "abstractmultimap.vala"
			return result;
#line 697 "abstractmultimap.c"
		}
	}
	result = FALSE;
#line 122 "abstractmultimap.vala"
	return result;
#line 703 "abstractmultimap.c"
}


#line 125 "abstractmultimap.vala"
static void gee_abstract_multi_map_real_clear (GeeMultiMap* base) {
#line 709 "abstractmultimap.c"
	GeeAbstractMultiMap * self;
	self = (GeeAbstractMultiMap*) base;
#line 126 "abstractmultimap.vala"
	gee_map_clear (self->_storage_map);
#line 127 "abstractmultimap.vala"
	self->priv->_nitems = 0;
#line 716 "abstractmultimap.c"
}


static gint gee_abstract_multi_map_real_get_size (GeeMultiMap* base) {
	gint result;
	GeeAbstractMultiMap* self;
	self = (GeeAbstractMultiMap*) base;
	result = self->priv->_nitems;
#line 32 "abstractmultimap.vala"
	return result;
#line 727 "abstractmultimap.c"
}


static void gee_abstract_multi_map_class_init (GeeAbstractMultiMapClass * klass) {
	gee_abstract_multi_map_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GeeAbstractMultiMapPrivate));
	GEE_ABSTRACT_MULTI_MAP_CLASS (klass)->create_value_storage = gee_abstract_multi_map_real_create_value_storage;
	GEE_ABSTRACT_MULTI_MAP_CLASS (klass)->create_multi_key_set = gee_abstract_multi_map_real_create_multi_key_set;
	GEE_ABSTRACT_MULTI_MAP_CLASS (klass)->get_value_equal_func = gee_abstract_multi_map_real_get_value_equal_func;
	G_OBJECT_CLASS (klass)->get_property = gee_abstract_multi_map_get_property;
	G_OBJECT_CLASS (klass)->set_property = gee_abstract_multi_map_set_property;
	G_OBJECT_CLASS (klass)->finalize = gee_abstract_multi_map_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_ABSTRACT_MULTI_MAP_K_TYPE, g_param_spec_gtype ("k-type", "type", "type", G_TYPE_NONE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_ABSTRACT_MULTI_MAP_K_DUP_FUNC, g_param_spec_pointer ("k-dup-func", "dup func", "dup func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_ABSTRACT_MULTI_MAP_K_DESTROY_FUNC, g_param_spec_pointer ("k-destroy-func", "destroy func", "destroy func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_ABSTRACT_MULTI_MAP_V_TYPE, g_param_spec_gtype ("v-type", "type", "type", G_TYPE_NONE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_ABSTRACT_MULTI_MAP_V_DUP_FUNC, g_param_spec_pointer ("v-dup-func", "dup func", "dup func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_ABSTRACT_MULTI_MAP_V_DESTROY_FUNC, g_param_spec_pointer ("v-destroy-func", "destroy func", "destroy func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_override_property (G_OBJECT_CLASS (klass), GEE_ABSTRACT_MULTI_MAP_SIZE, "size");
}


static void gee_abstract_multi_map_gee_multi_map_interface_init (GeeMultiMapIface * iface) {
	gee_abstract_multi_map_gee_multi_map_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_keys = gee_abstract_multi_map_real_get_keys;
	iface->get_all_keys = gee_abstract_multi_map_real_get_all_keys;
	iface->get_values = gee_abstract_multi_map_real_get_values;
	iface->contains = gee_abstract_multi_map_real_contains;
	iface->get = gee_abstract_multi_map_real_get;
	iface->set = gee_abstract_multi_map_real_set;
	iface->remove = gee_abstract_multi_map_real_remove;
	iface->remove_all = gee_abstract_multi_map_real_remove_all;
	iface->clear = gee_abstract_multi_map_real_clear;
	iface->get_size = gee_abstract_multi_map_real_get_size;
}


static void gee_abstract_multi_map_instance_init (GeeAbstractMultiMap * self) {
	self->priv = GEE_ABSTRACT_MULTI_MAP_GET_PRIVATE (self);
	self->priv->_nitems = 0;
}


static void gee_abstract_multi_map_finalize (GObject* obj) {
	GeeAbstractMultiMap * self;
	self = GEE_ABSTRACT_MULTI_MAP (obj);
	_g_object_unref0 (self->_storage_map);
	_g_object_unref0 (self->priv->_empty_value_set);
	G_OBJECT_CLASS (gee_abstract_multi_map_parent_class)->finalize (obj);
}


GType gee_abstract_multi_map_get_type (void) {
	static GType gee_abstract_multi_map_type_id = 0;
	if (gee_abstract_multi_map_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (GeeAbstractMultiMapClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gee_abstract_multi_map_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GeeAbstractMultiMap), 0, (GInstanceInitFunc) gee_abstract_multi_map_instance_init, NULL };
		static const GInterfaceInfo gee_multi_map_info = { (GInterfaceInitFunc) gee_abstract_multi_map_gee_multi_map_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		gee_abstract_multi_map_type_id = g_type_register_static (G_TYPE_OBJECT, "GeeAbstractMultiMap", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_type_add_interface_static (gee_abstract_multi_map_type_id, GEE_TYPE_MULTI_MAP, &gee_multi_map_info);
	}
	return gee_abstract_multi_map_type_id;
}


static void gee_abstract_multi_map_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GeeAbstractMultiMap * self;
	self = GEE_ABSTRACT_MULTI_MAP (object);
	switch (property_id) {
		case GEE_ABSTRACT_MULTI_MAP_SIZE:
		g_value_set_int (value, gee_multi_map_get_size ((GeeMultiMap*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void gee_abstract_multi_map_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GeeAbstractMultiMap * self;
	self = GEE_ABSTRACT_MULTI_MAP (object);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
		case GEE_ABSTRACT_MULTI_MAP_K_TYPE:
		self->priv->k_type = g_value_get_gtype (value);
		break;
		case GEE_ABSTRACT_MULTI_MAP_K_DUP_FUNC:
		self->priv->k_dup_func = g_value_get_pointer (value);
		break;
		case GEE_ABSTRACT_MULTI_MAP_K_DESTROY_FUNC:
		self->priv->k_destroy_func = g_value_get_pointer (value);
		break;
		case GEE_ABSTRACT_MULTI_MAP_V_TYPE:
		self->priv->v_type = g_value_get_gtype (value);
		break;
		case GEE_ABSTRACT_MULTI_MAP_V_DUP_FUNC:
		self->priv->v_dup_func = g_value_get_pointer (value);
		break;
		case GEE_ABSTRACT_MULTI_MAP_V_DESTROY_FUNC:
		self->priv->v_destroy_func = g_value_get_pointer (value);
		break;
	}
}




