#include "librpc/gen_ndr/ndr_netlogon.h"
#ifndef __CLI_NETLOGON__
#define __CLI_NETLOGON__
NTSTATUS rpccli_netr_LogonUasLogon(struct rpc_pipe_client *cli,
				   TALLOC_CTX *mem_ctx,
				   const char *server_name,
				   const char *account_name,
				   const char *workstation,
				   struct netr_UasInfo *info,
				   WERROR *werror);
NTSTATUS rpccli_netr_LogonUasLogoff(struct rpc_pipe_client *cli,
				    TALLOC_CTX *mem_ctx,
				    const char *server_name,
				    const char *account_name,
				    const char *workstation,
				    struct netr_UasLogoffInfo *info,
				    WERROR *werror);
NTSTATUS rpccli_netr_LogonSamLogon(struct rpc_pipe_client *cli,
				   TALLOC_CTX *mem_ctx,
				   const char *server_name,
				   const char *computer_name,
				   struct netr_Authenticator *credential,
				   struct netr_Authenticator *return_authenticator,
				   uint16_t logon_level,
				   union netr_LogonLevel logon,
				   uint16_t validation_level,
				   union netr_Validation *validation,
				   uint8_t *authoritative);
NTSTATUS rpccli_netr_LogonSamLogoff(struct rpc_pipe_client *cli,
				    TALLOC_CTX *mem_ctx,
				    const char *server_name,
				    const char *computer_name,
				    struct netr_Authenticator *credential,
				    struct netr_Authenticator *return_authenticator,
				    uint16_t logon_level,
				    union netr_LogonLevel logon);
NTSTATUS rpccli_netr_ServerReqChallenge(struct rpc_pipe_client *cli,
					TALLOC_CTX *mem_ctx,
					const char *server_name,
					const char *computer_name,
					struct netr_Credential *credentials);
NTSTATUS rpccli_netr_ServerAuthenticate(struct rpc_pipe_client *cli,
					TALLOC_CTX *mem_ctx,
					const char *server_name,
					const char *account_name,
					enum netr_SchannelType secure_channel_type,
					const char *computer_name,
					struct netr_Credential *credentials);
NTSTATUS rpccli_netr_ServerPasswordSet(struct rpc_pipe_client *cli,
				       TALLOC_CTX *mem_ctx,
				       const char *server_name,
				       const char *account_name,
				       enum netr_SchannelType secure_channel_type,
				       const char *computer_name,
				       struct netr_Authenticator credential,
				       struct samr_Password new_password,
				       struct netr_Authenticator *return_authenticator);
NTSTATUS rpccli_netr_DatabaseDeltas(struct rpc_pipe_client *cli,
				    TALLOC_CTX *mem_ctx,
				    const char *logon_server,
				    const char *computername,
				    struct netr_Authenticator credential,
				    struct netr_Authenticator *return_authenticator,
				    enum netr_SamDatabaseID database_id,
				    uint64_t *sequence_num,
				    uint32_t preferredmaximumlength,
				    struct netr_DELTA_ENUM_ARRAY *delta_enum_array);
NTSTATUS rpccli_netr_DatabaseSync(struct rpc_pipe_client *cli,
				  TALLOC_CTX *mem_ctx,
				  const char *logon_server,
				  const char *computername,
				  struct netr_Authenticator credential,
				  struct netr_Authenticator *return_authenticator,
				  enum netr_SamDatabaseID database_id,
				  uint32_t *sync_context,
				  uint32_t preferredmaximumlength,
				  struct netr_DELTA_ENUM_ARRAY *delta_enum_array);
NTSTATUS rpccli_netr_AccountDeltas(struct rpc_pipe_client *cli,
				   TALLOC_CTX *mem_ctx,
				   const char *logon_server,
				   const char *computername,
				   struct netr_Authenticator credential,
				   struct netr_Authenticator *return_authenticator,
				   struct netr_UAS_INFO_0 uas,
				   uint32_t count,
				   uint32_t level,
				   uint32_t buffersize,
				   struct netr_AccountBuffer *buffer,
				   uint32_t *count_returned,
				   uint32_t *total_entries,
				   struct netr_UAS_INFO_0 *recordid);
NTSTATUS rpccli_netr_AccountSync(struct rpc_pipe_client *cli,
				 TALLOC_CTX *mem_ctx,
				 const char *logon_server,
				 const char *computername,
				 struct netr_Authenticator credential,
				 struct netr_Authenticator *return_authenticator,
				 uint32_t reference,
				 uint32_t level,
				 uint32_t buffersize,
				 struct netr_AccountBuffer *buffer,
				 uint32_t *count_returned,
				 uint32_t *total_entries,
				 uint32_t *next_reference,
				 struct netr_UAS_INFO_0 *recordid);
NTSTATUS rpccli_netr_GetDcName(struct rpc_pipe_client *cli,
			       TALLOC_CTX *mem_ctx,
			       const char *logon_server,
			       const char *domainname,
			       const char **dcname,
			       WERROR *werror);
NTSTATUS rpccli_netr_LogonControl(struct rpc_pipe_client *cli,
				  TALLOC_CTX *mem_ctx,
				  const char *logon_server,
				  enum netr_LogonControlCode function_code,
				  uint32_t level,
				  union netr_CONTROL_QUERY_INFORMATION *info,
				  WERROR *werror);
NTSTATUS rpccli_netr_GetAnyDCName(struct rpc_pipe_client *cli,
				  TALLOC_CTX *mem_ctx,
				  const char *logon_server,
				  const char *domainname,
				  const char **dcname,
				  WERROR *werror);
NTSTATUS rpccli_netr_LogonControl2(struct rpc_pipe_client *cli,
				   TALLOC_CTX *mem_ctx,
				   const char *logon_server,
				   uint32_t function_code,
				   uint32_t level,
				   union netr_CONTROL_DATA_INFORMATION data,
				   union netr_CONTROL_QUERY_INFORMATION *query,
				   WERROR *werror);
NTSTATUS rpccli_netr_ServerAuthenticate2(struct rpc_pipe_client *cli,
					 TALLOC_CTX *mem_ctx,
					 const char *server_name,
					 const char *account_name,
					 enum netr_SchannelType secure_channel_type,
					 const char *computer_name,
					 struct netr_Credential *credentials,
					 uint32_t *negotiate_flags);
NTSTATUS rpccli_netr_DatabaseSync2(struct rpc_pipe_client *cli,
				   TALLOC_CTX *mem_ctx,
				   const char *logon_server,
				   const char *computername,
				   struct netr_Authenticator credential,
				   struct netr_Authenticator *return_authenticator,
				   enum netr_SamDatabaseID database_id,
				   uint16_t restart_state,
				   uint32_t *sync_context,
				   uint32_t preferredmaximumlength,
				   struct netr_DELTA_ENUM_ARRAY *delta_enum_array);
NTSTATUS rpccli_netr_DatabaseRedo(struct rpc_pipe_client *cli,
				  TALLOC_CTX *mem_ctx,
				  const char *logon_server,
				  const char *computername,
				  struct netr_Authenticator credential,
				  struct netr_Authenticator *return_authenticator,
				  uint8_t *change_log_entry,
				  uint32_t change_log_entry_size,
				  struct netr_DELTA_ENUM_ARRAY *delta_enum_array);
NTSTATUS rpccli_netr_LogonControl2Ex(struct rpc_pipe_client *cli,
				     TALLOC_CTX *mem_ctx,
				     const char *logon_server,
				     uint32_t function_code,
				     uint32_t level,
				     union netr_CONTROL_DATA_INFORMATION data,
				     union netr_CONTROL_QUERY_INFORMATION *query,
				     WERROR *werror);
NTSTATUS rpccli_netr_NetrEnumerateTrustedDomains(struct rpc_pipe_client *cli,
						 TALLOC_CTX *mem_ctx,
						 const char *server_name,
						 struct netr_Blob *trusted_domains_blob,
						 WERROR *werror);
NTSTATUS rpccli_netr_DsRGetDCName(struct rpc_pipe_client *cli,
				  TALLOC_CTX *mem_ctx,
				  const char *server_unc,
				  const char *domain_name,
				  struct GUID *domain_guid,
				  struct GUID *site_guid,
				  uint32_t flags,
				  struct netr_DsRGetDCNameInfo *info,
				  WERROR *werror);
NTSTATUS rpccli_netr_NETRLOGONDUMMYROUTINE1(struct rpc_pipe_client *cli,
					    TALLOC_CTX *mem_ctx,
					    WERROR *werror);
NTSTATUS rpccli_netr_NETRLOGONSETSERVICEBITS(struct rpc_pipe_client *cli,
					     TALLOC_CTX *mem_ctx,
					     WERROR *werror);
NTSTATUS rpccli_netr_LogonGetTrustRid(struct rpc_pipe_client *cli,
				      TALLOC_CTX *mem_ctx,
				      const char *server_name,
				      const char *domain_name,
				      uint32_t *rid,
				      WERROR *werror);
NTSTATUS rpccli_netr_NETRLOGONCOMPUTESERVERDIGEST(struct rpc_pipe_client *cli,
						  TALLOC_CTX *mem_ctx,
						  WERROR *werror);
NTSTATUS rpccli_netr_NETRLOGONCOMPUTECLIENTDIGEST(struct rpc_pipe_client *cli,
						  TALLOC_CTX *mem_ctx,
						  WERROR *werror);
NTSTATUS rpccli_netr_ServerAuthenticate3(struct rpc_pipe_client *cli,
					 TALLOC_CTX *mem_ctx,
					 const char *server_name,
					 const char *account_name,
					 enum netr_SchannelType secure_channel_type,
					 const char *computer_name,
					 struct netr_Credential *credentials,
					 uint32_t *negotiate_flags,
					 uint32_t *rid);
NTSTATUS rpccli_netr_DsRGetDCNameEx(struct rpc_pipe_client *cli,
				    TALLOC_CTX *mem_ctx,
				    const char *server_unc,
				    const char *domain_name,
				    struct GUID *domain_guid,
				    const char *site_name,
				    uint32_t flags,
				    struct netr_DsRGetDCNameInfo **info,
				    WERROR *werror);
NTSTATUS rpccli_netr_DsRGetSiteName(struct rpc_pipe_client *cli,
				    TALLOC_CTX *mem_ctx,
				    const char *computer_name,
				    const char **site,
				    WERROR *werror);
NTSTATUS rpccli_netr_LogonGetDomainInfo(struct rpc_pipe_client *cli,
					TALLOC_CTX *mem_ctx,
					const char *server_name,
					const char *computer_name,
					struct netr_Authenticator *credential,
					struct netr_Authenticator *return_authenticator,
					uint32_t level,
					union netr_DomainQuery query,
					union netr_DomainInfo *info);
NTSTATUS rpccli_netr_ServerPasswordSet2(struct rpc_pipe_client *cli,
					TALLOC_CTX *mem_ctx,
					const char *server_name,
					const char *account_name,
					enum netr_SchannelType secure_channel_type,
					const char *computer_name,
					struct netr_Authenticator credential,
					struct netr_CryptPassword new_password,
					struct netr_Authenticator *return_authenticator);
NTSTATUS rpccli_netr_ServerPasswordGet(struct rpc_pipe_client *cli,
				       TALLOC_CTX *mem_ctx,
				       const char *server_name,
				       const char *account_name,
				       enum netr_SchannelType secure_channel_type,
				       const char *computer_name,
				       struct netr_Authenticator *credential,
				       struct netr_Authenticator *return_authenticator,
				       struct samr_Password *password,
				       WERROR *werror);
NTSTATUS rpccli_netr_NETRLOGONSENDTOSAM(struct rpc_pipe_client *cli,
					TALLOC_CTX *mem_ctx,
					WERROR *werror);
NTSTATUS rpccli_netr_DsRAddressToSitenamesW(struct rpc_pipe_client *cli,
					    TALLOC_CTX *mem_ctx,
					    const char *server_name,
					    uint32_t count,
					    struct netr_DsRAddress *addresses,
					    struct netr_DsRAddressToSitenamesWCtr **ctr,
					    WERROR *werror);
NTSTATUS rpccli_netr_DsRGetDCNameEx2(struct rpc_pipe_client *cli,
				     TALLOC_CTX *mem_ctx,
				     const char *server_unc,
				     const char *client_account,
				     uint32_t mask,
				     const char *domain_name,
				     struct GUID *domain_guid,
				     const char *site_name,
				     uint32_t flags,
				     struct netr_DsRGetDCNameInfo **info,
				     WERROR *werror);
NTSTATUS rpccli_netr_NETRLOGONGETTIMESERVICEPARENTDOMAIN(struct rpc_pipe_client *cli,
							 TALLOC_CTX *mem_ctx,
							 WERROR *werror);
NTSTATUS rpccli_netr_NetrEnumerateTrustedDomainsEx(struct rpc_pipe_client *cli,
						   TALLOC_CTX *mem_ctx,
						   const char *server_name,
						   struct netr_DomainTrustList *dom_trust_list,
						   WERROR *werror);
NTSTATUS rpccli_netr_DsRAddressToSitenamesExW(struct rpc_pipe_client *cli,
					      TALLOC_CTX *mem_ctx,
					      const char *server_name,
					      uint32_t count,
					      struct netr_DsRAddress *addresses,
					      struct netr_DsRAddressToSitenamesExWCtr **ctr,
					      WERROR *werror);
NTSTATUS rpccli_netr_DsrGetDcSiteCoverageW(struct rpc_pipe_client *cli,
					   TALLOC_CTX *mem_ctx,
					   const char *server_name,
					   struct DcSitesCtr *ctr,
					   WERROR *werror);
NTSTATUS rpccli_netr_LogonSamLogonEx(struct rpc_pipe_client *cli,
				     TALLOC_CTX *mem_ctx,
				     const char *server_name,
				     const char *computer_name,
				     uint16_t logon_level,
				     union netr_LogonLevel logon,
				     uint16_t validation_level,
				     union netr_Validation *validation,
				     uint8_t *authoritative,
				     uint32_t *flags);
NTSTATUS rpccli_netr_DsrEnumerateDomainTrusts(struct rpc_pipe_client *cli,
					      TALLOC_CTX *mem_ctx,
					      const char *server_name,
					      uint32_t trust_flags,
					      struct netr_DomainTrustList *trusts,
					      WERROR *werror);
NTSTATUS rpccli_netr_DsrDeregisterDNSHostRecords(struct rpc_pipe_client *cli,
						 TALLOC_CTX *mem_ctx,
						 const char *server_name,
						 const char *domain,
						 struct GUID *domain_guid,
						 struct GUID *dsa_guid,
						 const char *dns_host,
						 WERROR *werror);
NTSTATUS rpccli_netr_ServerTrustPasswordsGet(struct rpc_pipe_client *cli,
					     TALLOC_CTX *mem_ctx,
					     const char *server_name,
					     const char *account_name,
					     enum netr_SchannelType secure_channel_type,
					     const char *computer_name,
					     struct netr_Authenticator *credential,
					     struct netr_Authenticator *return_authenticator,
					     struct samr_Password *password,
					     struct samr_Password *password2);
NTSTATUS rpccli_netr_DsRGetForestTrustInformation(struct rpc_pipe_client *cli,
						  TALLOC_CTX *mem_ctx,
						  const char *server_name,
						  const char *trusted_domain_name,
						  uint32_t flags,
						  struct lsa_ForestTrustInformation **forest_trust_info,
						  WERROR *werror);
NTSTATUS rpccli_netr_GetForestTrustInformation(struct rpc_pipe_client *cli,
					       TALLOC_CTX *mem_ctx,
					       const char *server_name,
					       const char *trusted_domain_name,
					       struct netr_Authenticator *credential,
					       struct netr_Authenticator *return_authenticator,
					       uint32_t flags,
					       struct lsa_ForestTrustInformation **forest_trust_info,
					       WERROR *werror);
NTSTATUS rpccli_netr_LogonSamLogonWithFlags(struct rpc_pipe_client *cli,
					    TALLOC_CTX *mem_ctx,
					    const char *server_name,
					    const char *computer_name,
					    struct netr_Authenticator *credential,
					    struct netr_Authenticator *return_authenticator,
					    uint16_t logon_level,
					    union netr_LogonLevel logon,
					    uint16_t validation_level,
					    union netr_Validation *validation,
					    uint8_t *authoritative,
					    uint32_t *flags);
NTSTATUS rpccli_netr_NETRSERVERGETTRUSTINFO(struct rpc_pipe_client *cli,
					    TALLOC_CTX *mem_ctx,
					    WERROR *werror);
#endif /* __CLI_NETLOGON__ */
