/*

Logic to send messages via gwibber

Copyright 2010 Canonical Ltd.

Authors:
    David Barth <david.barth@canonical.com>

This program is free software: you can redistribute it and/or modify it 
under the terms of the GNU General Public License version 3, as published 
by the Free Software Foundation.

This program is distributed in the hope that it will be useful, but 
WITHOUT ANY WARRANTY; without even the implied warranties of 
MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along 
with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef __ME_GWIBBER_SERVICE_H__
#define __ME_GWIBBER_SERVICE_H__

#include <glib.h>
#include <glib-object.h>

#include <gwibber.h>

G_BEGIN_DECLS

#define ME_GWIBBER_SERVICE_TYPE            (me_gwibber_service_get_type ())
#define ME_GWIBBER_SERVICE(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), ME_GWIBBER_SERVICE_TYPE, MeGwibberService))
#define ME_GWIBBER_SERVICE_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), ME_GWIBBER_SERVICE_TYPE, MeGwibberServiceClass))
#define IS_ME_GWIBBER_SERVICE(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ME_GWIBBER_SERVICE_TYPE))
#define IS_ME_GWIBBER_SERVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ME_GWIBBER_SERVICE_TYPE))
#define ME_GWIBBER_SERVICE_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), ME_GWIBBER_SERVICE_TYPE, MeGwibberServiceClass))

typedef enum
{
	ME_GWIBBER_SERVICE_STATUS_NOT_RUNNING,
	/* ME_GWIBBER_SERVICE_STATUS_LOADING_STARTED,
	ME_GWIBBER_SERVICE_STATUS_LOADING_COMPLETE, */
	ME_GWIBBER_SERVICE_STATUS_RUNNING,
	ME_GWIBBER_SERVICE_STATUS_LAST
}
MeGwibberServiceStatus;

#define ME_GWIBBER_SERVICE_SIGNAL_STATUS_CHANGED     "status-changed"
#define ME_GWIBBER_SERVICE_SIGNAL_STATUS_CHANGED_ID  (g_signal_lookup(ME_GWIBBER_SERVICE_SIGNAL_STATUS_CHANGED, ME_GWIBBER_SERVICE_TYPE))

typedef struct _MeGwibberServiceClass MeGwibberServiceClass;
struct _MeGwibberServiceClass {
	GObjectClass parent_class;

	/* Signals */
	void (*status_changed) (MeGwibberServiceStatus newstatus);
};

typedef struct _MeGwibberService      MeGwibberService;
struct _MeGwibberService {
	GObject parent;
};

GType me_gwibber_service_get_type (void) G_GNUC_CONST;
MeGwibberService * me_gwibber_service_new (void);
MeGwibberService * me_gwibber_service_get (void);
void me_gwibber_service_send (MeGwibberService *self, gchar *msg);
gboolean me_gwibber_service_has_configured_accounts (MeGwibberService *self);
const gchar * me_gwibber_service_get_accounts_string (MeGwibberService *self);

G_END_DECLS

#endif /* __ME_GWIBBER_SERVICE_H__ */

