/* streams.c generated by valac 0.12.1, the Vala compiler
 * generated from streams.vala, do not modify */

/*
 * Copyright(C) 2010 Neil Jagdish Patel
 * Copyright(C) 2010 Canonical Ltd.
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License
 * version 3.0 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3.0 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see
 * <http://www.gnu.org/licenses/>.
 *
 * Authored by Neil Jagdish Patel <neil.patel@canonical.com>
 * Authored by Ken VaDine <ken.vandine@canonical.com>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include "gwibber.h"
#include <dee.h>
#include <gee.h>
#include <json-glib/json-glib.h>
#include <float.h>
#include <math.h>


#define TYPE_STREAMS_INTERFACE (streams_interface_get_type ())
#define STREAMS_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_STREAMS_INTERFACE, StreamsInterface))
#define IS_STREAMS_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_STREAMS_INTERFACE))
#define STREAMS_INTERFACE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_STREAMS_INTERFACE, StreamsInterfaceIface))

typedef struct _StreamsInterface StreamsInterface;
typedef struct _StreamsInterfaceIface StreamsInterfaceIface;

#define TYPE_STREAMS_INTERFACE_PROXY (streams_interface_proxy_get_type ())
typedef GDBusProxy StreamsInterfaceProxy;
typedef GDBusProxyClass StreamsInterfaceProxyClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block1Data Block1Data;
typedef struct _Block2Data Block2Data;
#define _json_object_unref0(var) ((var == NULL) ? NULL : (var = (json_object_unref (var), NULL)))
#define __g_list_free__g_free0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_free0_ (var), NULL)))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
#define _json_array_unref0(var) ((var == NULL) ? NULL : (var = (json_array_unref (var), NULL)))
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
#define _g_variant_type_free0(var) ((var == NULL) ? NULL : (var = (g_variant_type_free (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _json_node_free0(var) ((var == NULL) ? NULL : (var = (json_node_free (var), NULL)))
#define _g_variant_builder_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_builder_unref (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define __vala_GValue_free0(var) ((var == NULL) ? NULL : (var = (_vala_GValue_free (var), NULL)))

struct _StreamsInterfaceIface {
	GTypeInterface parent_iface;
	gchar* (*Messages) (StreamsInterface* self, const gchar* stream, const gchar* account, gint time, const gchar* transient, const gchar* recipient, const gchar* orderby, const gchar* order, gint limit, GError** error);
	gchar* (*Get) (StreamsInterface* self, const gchar* id, GError** error);
	gchar* (*List) (StreamsInterface* self, GError** error);
	gchar* (*Create) (StreamsInterface* self, const gchar* query, GError** error);
	void (*Delete) (StreamsInterface* self, const gchar* id, GError** error);
};

struct _GwibberStreamsPrivate {
	StreamsInterface* streams_service;
	GwibberService* service;
	GwibberUtils* utils;
	GwibberMessages* messages_service;
	GwibberSearches* searches_service;
	DeeModel* _stream_model;
	DeeModel* _transient_model;
	DeeResourceManager* resources;
	GeeHashMap* seen;
	gboolean _service_loading;
};

struct _Block1Data {
	int _ref_count_;
	GwibberStreams * self;
	DeeSequenceModel* model;
};

struct _Block2Data {
	int _ref_count_;
	GwibberStreams * self;
	DeeSequenceModel* model;
};


static gpointer gwibber_streams_parent_class = NULL;

GType streams_interface_proxy_get_type (void) G_GNUC_CONST;
guint streams_interface_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType streams_interface_get_type (void) G_GNUC_CONST;
gchar* streams_interface_Messages (StreamsInterface* self, const gchar* stream, const gchar* account, gint time, const gchar* transient, const gchar* recipient, const gchar* orderby, const gchar* order, gint limit, GError** error);
gchar* streams_interface_Get (StreamsInterface* self, const gchar* id, GError** error);
gchar* streams_interface_List (StreamsInterface* self, GError** error);
gchar* streams_interface_Create (StreamsInterface* self, const gchar* query, GError** error);
void streams_interface_Delete (StreamsInterface* self, const gchar* id, GError** error);
static void streams_interface_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters);
static void _dbus_handle_streams_interface_updated (StreamsInterface* self, GVariant* parameters);
static void _dbus_handle_streams_interface_created (StreamsInterface* self, GVariant* parameters);
static void _dbus_handle_streams_interface_deleted (StreamsInterface* self, GVariant* parameters);
static gchar* streams_interface_proxy_Messages (StreamsInterface* self, const gchar* stream, const gchar* account, gint time, const gchar* transient, const gchar* recipient, const gchar* orderby, const gchar* order, gint limit, GError** error);
static gchar* streams_interface_proxy_Get (StreamsInterface* self, const gchar* id, GError** error);
static gchar* streams_interface_proxy_List (StreamsInterface* self, GError** error);
static gchar* streams_interface_proxy_Create (StreamsInterface* self, const gchar* query, GError** error);
static void streams_interface_proxy_Delete (StreamsInterface* self, const gchar* id, GError** error);
static void streams_interface_proxy_streams_interface_interface_init (StreamsInterfaceIface* iface);
static void _dbus_streams_interface_Messages (StreamsInterface* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_streams_interface_Get (StreamsInterface* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_streams_interface_List (StreamsInterface* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_streams_interface_Create (StreamsInterface* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_streams_interface_Delete (StreamsInterface* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void streams_interface_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data);
static GVariant* streams_interface_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data);
static gboolean streams_interface_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data);
static void _dbus_streams_interface_updated (GObject* _sender, const gchar* id, gpointer* _data);
static void _dbus_streams_interface_created (GObject* _sender, const gchar* id, gpointer* _data);
static void _dbus_streams_interface_deleted (GObject* _sender, const gchar* id, gpointer* _data);
static void _streams_interface_unregister_object (gpointer user_data);
#define GWIBBER_STREAMS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GWIBBER_TYPE_STREAMS, GwibberStreamsPrivate))
enum  {
	GWIBBER_STREAMS_DUMMY_PROPERTY,
	GWIBBER_STREAMS_STREAM_MODEL,
	GWIBBER_STREAMS_TRANSIENT_MODEL
};
#define GWIBBER_STREAMS_streams_name "com.Gwibber.Streams"
#define GWIBBER_STREAMS_streams_path "/com/gwibber/Streams"
void gwibber_utils_setup (GwibberUtils* self, const gchar* name, GError** error);
static void _gwibber_streams_streams_available_gwibber_utils_available (GwibberUtils* _sender, gboolean up, gpointer self);
static void _lambda8_ (const gchar* source, GwibberStreams* self);
static void __lambda8__streams_interface_updated (StreamsInterface* _sender, const gchar* id, gpointer self);
static void _lambda9_ (const gchar* source, GwibberStreams* self);
static void __lambda9__streams_interface_created (StreamsInterface* _sender, const gchar* id, gpointer self);
static void _lambda10_ (const gchar* source, GwibberStreams* self);
static void __lambda10__streams_interface_deleted (StreamsInterface* _sender, const gchar* id, gpointer self);
static DeeSequenceModel* gwibber_streams_create_model (GwibberStreams* self);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (Block1Data* _data1_);
static gboolean _lambda11_ (Block1Data* _data1_);
static void gwibber_streams_refresh_model (GwibberStreams* self);
static gboolean __lambda11__gsource_func (gpointer self);
static void _lambda12_ (const gchar* change, const gchar* data, GwibberStreams* self);
static void gwibber_streams_on_refresh (GwibberStreams* self, const gchar* change, const gchar* data);
static void __lambda12__gwibber_messages_message (GwibberMessages* _sender, const gchar* change, const gchar* data, gpointer self);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (Block2Data* _data2_);
static gboolean _lambda13_ (Block2Data* _data2_);
static void gwibber_streams_refresh_transient_model (GwibberStreams* self);
static gboolean __lambda13__gsource_func (gpointer self);
static void gwibber_streams_parse_message (GwibberStreams* self, JsonObject* obj, const gchar* change);
static void gwibber_streams_parse_messages (GwibberStreams* self, const gchar* data);
static void _g_free0_ (gpointer var);
static void _g_list_free__g_free0_ (GList* self);
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
static gchar** _variant_get1 (GVariant* value, int* result_length1);
static gboolean _vala_string_array_contains (gchar** stack, int stack_length, gchar* needle);
static GVariant* _variant_new2 (const gchar* value);
static GVariant* _variant_new3 (const gchar* value);
static GVariant* _variant_new4 (const gchar* value);
static GVariant* _variant_new5 (gdouble value);
static GValue* _g_value_dup (GValue* self);
static void _vala_GValue_free (GValue* self);
static void gwibber_streams_real_updated (GwibberStreams* self, const gchar* id);
static void gwibber_streams_finalize (GObject* obj);
static void _vala_gwibber_streams_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_gwibber_streams_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static const GDBusArgInfo _streams_interface_dbus_arg_info_Messages_stream = {-1, "stream", "s"};
static const GDBusArgInfo _streams_interface_dbus_arg_info_Messages_account = {-1, "account", "s"};
static const GDBusArgInfo _streams_interface_dbus_arg_info_Messages_time = {-1, "time", "i"};
static const GDBusArgInfo _streams_interface_dbus_arg_info_Messages_transient = {-1, "transient", "s"};
static const GDBusArgInfo _streams_interface_dbus_arg_info_Messages_recipient = {-1, "recipient", "s"};
static const GDBusArgInfo _streams_interface_dbus_arg_info_Messages_orderby = {-1, "orderby", "s"};
static const GDBusArgInfo _streams_interface_dbus_arg_info_Messages_order = {-1, "order", "s"};
static const GDBusArgInfo _streams_interface_dbus_arg_info_Messages_limit = {-1, "limit", "i"};
static const GDBusArgInfo _streams_interface_dbus_arg_info_Messages_result = {-1, "result", "s"};
static const GDBusArgInfo * const _streams_interface_dbus_arg_info_Messages_in[] = {&_streams_interface_dbus_arg_info_Messages_stream, &_streams_interface_dbus_arg_info_Messages_account, &_streams_interface_dbus_arg_info_Messages_time, &_streams_interface_dbus_arg_info_Messages_transient, &_streams_interface_dbus_arg_info_Messages_recipient, &_streams_interface_dbus_arg_info_Messages_orderby, &_streams_interface_dbus_arg_info_Messages_order, &_streams_interface_dbus_arg_info_Messages_limit, NULL};
static const GDBusArgInfo * const _streams_interface_dbus_arg_info_Messages_out[] = {&_streams_interface_dbus_arg_info_Messages_result, NULL};
static const GDBusMethodInfo _streams_interface_dbus_method_info_Messages = {-1, "Messages", (GDBusArgInfo **) (&_streams_interface_dbus_arg_info_Messages_in), (GDBusArgInfo **) (&_streams_interface_dbus_arg_info_Messages_out)};
static const GDBusArgInfo _streams_interface_dbus_arg_info_Get_id = {-1, "id", "s"};
static const GDBusArgInfo _streams_interface_dbus_arg_info_Get_result = {-1, "result", "s"};
static const GDBusArgInfo * const _streams_interface_dbus_arg_info_Get_in[] = {&_streams_interface_dbus_arg_info_Get_id, NULL};
static const GDBusArgInfo * const _streams_interface_dbus_arg_info_Get_out[] = {&_streams_interface_dbus_arg_info_Get_result, NULL};
static const GDBusMethodInfo _streams_interface_dbus_method_info_Get = {-1, "Get", (GDBusArgInfo **) (&_streams_interface_dbus_arg_info_Get_in), (GDBusArgInfo **) (&_streams_interface_dbus_arg_info_Get_out)};
static const GDBusArgInfo _streams_interface_dbus_arg_info_List_result = {-1, "result", "s"};
static const GDBusArgInfo * const _streams_interface_dbus_arg_info_List_in[] = {NULL};
static const GDBusArgInfo * const _streams_interface_dbus_arg_info_List_out[] = {&_streams_interface_dbus_arg_info_List_result, NULL};
static const GDBusMethodInfo _streams_interface_dbus_method_info_List = {-1, "List", (GDBusArgInfo **) (&_streams_interface_dbus_arg_info_List_in), (GDBusArgInfo **) (&_streams_interface_dbus_arg_info_List_out)};
static const GDBusArgInfo _streams_interface_dbus_arg_info_Create_query = {-1, "query", "s"};
static const GDBusArgInfo _streams_interface_dbus_arg_info_Create_result = {-1, "result", "s"};
static const GDBusArgInfo * const _streams_interface_dbus_arg_info_Create_in[] = {&_streams_interface_dbus_arg_info_Create_query, NULL};
static const GDBusArgInfo * const _streams_interface_dbus_arg_info_Create_out[] = {&_streams_interface_dbus_arg_info_Create_result, NULL};
static const GDBusMethodInfo _streams_interface_dbus_method_info_Create = {-1, "Create", (GDBusArgInfo **) (&_streams_interface_dbus_arg_info_Create_in), (GDBusArgInfo **) (&_streams_interface_dbus_arg_info_Create_out)};
static const GDBusArgInfo _streams_interface_dbus_arg_info_Delete_id = {-1, "id", "s"};
static const GDBusArgInfo * const _streams_interface_dbus_arg_info_Delete_in[] = {&_streams_interface_dbus_arg_info_Delete_id, NULL};
static const GDBusArgInfo * const _streams_interface_dbus_arg_info_Delete_out[] = {NULL};
static const GDBusMethodInfo _streams_interface_dbus_method_info_Delete = {-1, "Delete", (GDBusArgInfo **) (&_streams_interface_dbus_arg_info_Delete_in), (GDBusArgInfo **) (&_streams_interface_dbus_arg_info_Delete_out)};
static const GDBusMethodInfo * const _streams_interface_dbus_method_info[] = {&_streams_interface_dbus_method_info_Messages, &_streams_interface_dbus_method_info_Get, &_streams_interface_dbus_method_info_List, &_streams_interface_dbus_method_info_Create, &_streams_interface_dbus_method_info_Delete, NULL};
static const GDBusArgInfo _streams_interface_dbus_arg_info_updated_id = {-1, "id", "s"};
static const GDBusArgInfo * const _streams_interface_dbus_arg_info_updated[] = {&_streams_interface_dbus_arg_info_updated_id, NULL};
static const GDBusSignalInfo _streams_interface_dbus_signal_info_updated = {-1, "Updated", (GDBusArgInfo **) (&_streams_interface_dbus_arg_info_updated)};
static const GDBusArgInfo _streams_interface_dbus_arg_info_created_id = {-1, "id", "s"};
static const GDBusArgInfo * const _streams_interface_dbus_arg_info_created[] = {&_streams_interface_dbus_arg_info_created_id, NULL};
static const GDBusSignalInfo _streams_interface_dbus_signal_info_created = {-1, "Created", (GDBusArgInfo **) (&_streams_interface_dbus_arg_info_created)};
static const GDBusArgInfo _streams_interface_dbus_arg_info_deleted_id = {-1, "id", "s"};
static const GDBusArgInfo * const _streams_interface_dbus_arg_info_deleted[] = {&_streams_interface_dbus_arg_info_deleted_id, NULL};
static const GDBusSignalInfo _streams_interface_dbus_signal_info_deleted = {-1, "Deleted", (GDBusArgInfo **) (&_streams_interface_dbus_arg_info_deleted)};
static const GDBusSignalInfo * const _streams_interface_dbus_signal_info[] = {&_streams_interface_dbus_signal_info_updated, &_streams_interface_dbus_signal_info_created, &_streams_interface_dbus_signal_info_deleted, NULL};
static const GDBusPropertyInfo * const _streams_interface_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _streams_interface_dbus_interface_info = {-1, "com.Gwibber.Streams", (GDBusMethodInfo **) (&_streams_interface_dbus_method_info), (GDBusSignalInfo **) (&_streams_interface_dbus_signal_info), (GDBusPropertyInfo **) (&_streams_interface_dbus_property_info)};
static const GDBusInterfaceVTable _streams_interface_dbus_interface_vtable = {streams_interface_dbus_interface_method_call, streams_interface_dbus_interface_get_property, streams_interface_dbus_interface_set_property};

gchar* streams_interface_Messages (StreamsInterface* self, const gchar* stream, const gchar* account, gint time, const gchar* transient, const gchar* recipient, const gchar* orderby, const gchar* order, gint limit, GError** error) {
	return STREAMS_INTERFACE_GET_INTERFACE (self)->Messages (self, stream, account, time, transient, recipient, orderby, order, limit, error);
}


gchar* streams_interface_Get (StreamsInterface* self, const gchar* id, GError** error) {
	return STREAMS_INTERFACE_GET_INTERFACE (self)->Get (self, id, error);
}


gchar* streams_interface_List (StreamsInterface* self, GError** error) {
	return STREAMS_INTERFACE_GET_INTERFACE (self)->List (self, error);
}


gchar* streams_interface_Create (StreamsInterface* self, const gchar* query, GError** error) {
	return STREAMS_INTERFACE_GET_INTERFACE (self)->Create (self, query, error);
}


void streams_interface_Delete (StreamsInterface* self, const gchar* id, GError** error) {
	STREAMS_INTERFACE_GET_INTERFACE (self)->Delete (self, id, error);
}


static void streams_interface_base_init (StreamsInterfaceIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		g_signal_new ("updated", TYPE_STREAMS_INTERFACE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
		g_signal_new ("created", TYPE_STREAMS_INTERFACE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
		g_signal_new ("deleted", TYPE_STREAMS_INTERFACE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
	}
}


GType streams_interface_get_type (void) {
	static volatile gsize streams_interface_type_id__volatile = 0;
	if (g_once_init_enter (&streams_interface_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (StreamsInterfaceIface), (GBaseInitFunc) streams_interface_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType streams_interface_type_id;
		streams_interface_type_id = g_type_register_static (G_TYPE_INTERFACE, "StreamsInterface", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (streams_interface_type_id, G_TYPE_OBJECT);
		g_type_set_qdata (streams_interface_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) streams_interface_proxy_get_type);
		g_type_set_qdata (streams_interface_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "com.Gwibber.Streams");
		g_type_set_qdata (streams_interface_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) streams_interface_register_object);
		g_once_init_leave (&streams_interface_type_id__volatile, streams_interface_type_id);
	}
	return streams_interface_type_id__volatile;
}


G_DEFINE_TYPE_EXTENDED (StreamsInterfaceProxy, streams_interface_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (TYPE_STREAMS_INTERFACE, streams_interface_proxy_streams_interface_interface_init) )
static void streams_interface_proxy_class_init (StreamsInterfaceProxyClass* klass) {
	G_DBUS_PROXY_CLASS (klass)->g_signal = streams_interface_proxy_g_signal;
}


static void _dbus_handle_streams_interface_updated (StreamsInterface* self, GVariant* parameters) {
	GVariantIter _arguments_iter;
	gchar* id = NULL;
	GVariant* _tmp31_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp31_ = g_variant_iter_next_value (&_arguments_iter);
	id = g_variant_dup_string (_tmp31_, NULL);
	g_variant_unref (_tmp31_);
	g_signal_emit_by_name (self, "updated", id);
	_g_free0 (id);
}


static void _dbus_handle_streams_interface_created (StreamsInterface* self, GVariant* parameters) {
	GVariantIter _arguments_iter;
	gchar* id = NULL;
	GVariant* _tmp32_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp32_ = g_variant_iter_next_value (&_arguments_iter);
	id = g_variant_dup_string (_tmp32_, NULL);
	g_variant_unref (_tmp32_);
	g_signal_emit_by_name (self, "created", id);
	_g_free0 (id);
}


static void _dbus_handle_streams_interface_deleted (StreamsInterface* self, GVariant* parameters) {
	GVariantIter _arguments_iter;
	gchar* id = NULL;
	GVariant* _tmp33_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp33_ = g_variant_iter_next_value (&_arguments_iter);
	id = g_variant_dup_string (_tmp33_, NULL);
	g_variant_unref (_tmp33_);
	g_signal_emit_by_name (self, "deleted", id);
	_g_free0 (id);
}


static void streams_interface_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters) {
	if (strcmp (signal_name, "Updated") == 0) {
		_dbus_handle_streams_interface_updated ((StreamsInterface*) proxy, parameters);
	} else if (strcmp (signal_name, "Created") == 0) {
		_dbus_handle_streams_interface_created ((StreamsInterface*) proxy, parameters);
	} else if (strcmp (signal_name, "Deleted") == 0) {
		_dbus_handle_streams_interface_deleted ((StreamsInterface*) proxy, parameters);
	}
}


static void streams_interface_proxy_init (StreamsInterfaceProxy* self) {
}


static gchar* streams_interface_proxy_Messages (StreamsInterface* self, const gchar* stream, const gchar* account, gint time, const gchar* transient, const gchar* recipient, const gchar* orderby, const gchar* order, gint limit, GError** error) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	gchar* _result;
	GVariant* _tmp34_;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "com.Gwibber.Streams", "Messages");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (stream));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (account));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_int32 (time));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (transient));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (recipient));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (orderby));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (order));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_int32 (limit));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return NULL;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return NULL;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_tmp34_ = g_variant_iter_next_value (&_reply_iter);
	_result = g_variant_dup_string (_tmp34_, NULL);
	g_variant_unref (_tmp34_);
	g_object_unref (_reply_message);
	return _result;
}


static gchar* streams_interface_proxy_Get (StreamsInterface* self, const gchar* id, GError** error) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	gchar* _result;
	GVariant* _tmp35_;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "com.Gwibber.Streams", "Get");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (id));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return NULL;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return NULL;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_tmp35_ = g_variant_iter_next_value (&_reply_iter);
	_result = g_variant_dup_string (_tmp35_, NULL);
	g_variant_unref (_tmp35_);
	g_object_unref (_reply_message);
	return _result;
}


static gchar* streams_interface_proxy_List (StreamsInterface* self, GError** error) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	gchar* _result;
	GVariant* _tmp36_;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "com.Gwibber.Streams", "List");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return NULL;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return NULL;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_tmp36_ = g_variant_iter_next_value (&_reply_iter);
	_result = g_variant_dup_string (_tmp36_, NULL);
	g_variant_unref (_tmp36_);
	g_object_unref (_reply_message);
	return _result;
}


static gchar* streams_interface_proxy_Create (StreamsInterface* self, const gchar* query, GError** error) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	gchar* _result;
	GVariant* _tmp37_;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "com.Gwibber.Streams", "Create");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (query));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return NULL;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return NULL;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_tmp37_ = g_variant_iter_next_value (&_reply_iter);
	_result = g_variant_dup_string (_tmp37_, NULL);
	g_variant_unref (_tmp37_);
	g_object_unref (_reply_message);
	return _result;
}


static void streams_interface_proxy_Delete (StreamsInterface* self, const gchar* id, GError** error) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "com.Gwibber.Streams", "Delete");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (id));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}


static void streams_interface_proxy_streams_interface_interface_init (StreamsInterfaceIface* iface) {
	iface->Messages = streams_interface_proxy_Messages;
	iface->Get = streams_interface_proxy_Get;
	iface->List = streams_interface_proxy_List;
	iface->Create = streams_interface_proxy_Create;
	iface->Delete = streams_interface_proxy_Delete;
}


static void _dbus_streams_interface_Messages (StreamsInterface* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar* stream = NULL;
	GVariant* _tmp38_;
	gchar* account = NULL;
	GVariant* _tmp39_;
	gint time = 0;
	GVariant* _tmp40_;
	gchar* transient = NULL;
	GVariant* _tmp41_;
	gchar* recipient = NULL;
	GVariant* _tmp42_;
	gchar* orderby = NULL;
	GVariant* _tmp43_;
	gchar* order = NULL;
	GVariant* _tmp44_;
	gint limit = 0;
	GVariant* _tmp45_;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gchar* result;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp38_ = g_variant_iter_next_value (&_arguments_iter);
	stream = g_variant_dup_string (_tmp38_, NULL);
	g_variant_unref (_tmp38_);
	_tmp39_ = g_variant_iter_next_value (&_arguments_iter);
	account = g_variant_dup_string (_tmp39_, NULL);
	g_variant_unref (_tmp39_);
	_tmp40_ = g_variant_iter_next_value (&_arguments_iter);
	time = g_variant_get_int32 (_tmp40_);
	g_variant_unref (_tmp40_);
	_tmp41_ = g_variant_iter_next_value (&_arguments_iter);
	transient = g_variant_dup_string (_tmp41_, NULL);
	g_variant_unref (_tmp41_);
	_tmp42_ = g_variant_iter_next_value (&_arguments_iter);
	recipient = g_variant_dup_string (_tmp42_, NULL);
	g_variant_unref (_tmp42_);
	_tmp43_ = g_variant_iter_next_value (&_arguments_iter);
	orderby = g_variant_dup_string (_tmp43_, NULL);
	g_variant_unref (_tmp43_);
	_tmp44_ = g_variant_iter_next_value (&_arguments_iter);
	order = g_variant_dup_string (_tmp44_, NULL);
	g_variant_unref (_tmp44_);
	_tmp45_ = g_variant_iter_next_value (&_arguments_iter);
	limit = g_variant_get_int32 (_tmp45_);
	g_variant_unref (_tmp45_);
	result = streams_interface_Messages (self, stream, account, time, transient, recipient, orderby, order, limit, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_string (result));
	_g_free0 ( result);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	_g_free0 (stream);
	_g_free0 (account);
	_g_free0 (transient);
	_g_free0 (recipient);
	_g_free0 (orderby);
	_g_free0 (order);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_streams_interface_Get (StreamsInterface* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar* id = NULL;
	GVariant* _tmp46_;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gchar* result;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp46_ = g_variant_iter_next_value (&_arguments_iter);
	id = g_variant_dup_string (_tmp46_, NULL);
	g_variant_unref (_tmp46_);
	result = streams_interface_Get (self, id, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_string (result));
	_g_free0 ( result);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	_g_free0 (id);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_streams_interface_List (StreamsInterface* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gchar* result;
	g_variant_iter_init (&_arguments_iter, parameters);
	result = streams_interface_List (self, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_string (result));
	_g_free0 ( result);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_streams_interface_Create (StreamsInterface* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar* query = NULL;
	GVariant* _tmp47_;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gchar* result;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp47_ = g_variant_iter_next_value (&_arguments_iter);
	query = g_variant_dup_string (_tmp47_, NULL);
	g_variant_unref (_tmp47_);
	result = streams_interface_Create (self, query, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_string (result));
	_g_free0 ( result);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	_g_free0 (query);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_streams_interface_Delete (StreamsInterface* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar* id = NULL;
	GVariant* _tmp48_;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp48_ = g_variant_iter_next_value (&_arguments_iter);
	id = g_variant_dup_string (_tmp48_, NULL);
	g_variant_unref (_tmp48_);
	streams_interface_Delete (self, id, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	_g_free0 (id);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void streams_interface_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "Messages") == 0) {
		_dbus_streams_interface_Messages (object, parameters, invocation);
	} else if (strcmp (method_name, "Get") == 0) {
		_dbus_streams_interface_Get (object, parameters, invocation);
	} else if (strcmp (method_name, "List") == 0) {
		_dbus_streams_interface_List (object, parameters, invocation);
	} else if (strcmp (method_name, "Create") == 0) {
		_dbus_streams_interface_Create (object, parameters, invocation);
	} else if (strcmp (method_name, "Delete") == 0) {
		_dbus_streams_interface_Delete (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}


static GVariant* streams_interface_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}


static gboolean streams_interface_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}


static void _dbus_streams_interface_updated (GObject* _sender, const gchar* id, gpointer* _data) {
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (id));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "com.Gwibber.Streams", "Updated", _arguments, NULL);
}


static void _dbus_streams_interface_created (GObject* _sender, const gchar* id, gpointer* _data) {
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (id));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "com.Gwibber.Streams", "Created", _arguments, NULL);
}


static void _dbus_streams_interface_deleted (GObject* _sender, const gchar* id, gpointer* _data) {
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (id));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "com.Gwibber.Streams", "Deleted", _arguments, NULL);
}


guint streams_interface_register_object (gpointer object, GDBusConnection* connection, const gchar* path, GError** error) {
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_streams_interface_dbus_interface_info), &_streams_interface_dbus_interface_vtable, data, _streams_interface_unregister_object, error);
	if (!result) {
		return 0;
	}
	g_signal_connect (object, "updated", (GCallback) _dbus_streams_interface_updated, data);
	g_signal_connect (object, "created", (GCallback) _dbus_streams_interface_created, data);
	g_signal_connect (object, "deleted", (GCallback) _dbus_streams_interface_deleted, data);
	return result;
}


static void _streams_interface_unregister_object (gpointer user_data) {
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}


static void _gwibber_streams_streams_available_gwibber_utils_available (GwibberUtils* _sender, gboolean up, gpointer self) {
	gwibber_streams_streams_available (self, up);
}


static void _lambda8_ (const gchar* source, GwibberStreams* self) {
	g_return_if_fail (source != NULL);
	gwibber_streams_stream_updated (self, source);
}


static void __lambda8__streams_interface_updated (StreamsInterface* _sender, const gchar* id, gpointer self) {
	_lambda8_ (id, self);
}


static void _lambda9_ (const gchar* source, GwibberStreams* self) {
	g_return_if_fail (source != NULL);
	gwibber_streams_stream_created (self, source);
}


static void __lambda9__streams_interface_created (StreamsInterface* _sender, const gchar* id, gpointer self) {
	_lambda9_ (id, self);
}


static void _lambda10_ (const gchar* source, GwibberStreams* self) {
	g_return_if_fail (source != NULL);
	gwibber_streams_stream_deleted (self, source);
}


static void __lambda10__streams_interface_deleted (StreamsInterface* _sender, const gchar* id, gpointer self) {
	_lambda10_ (id, self);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


GwibberStreams* gwibber_streams_construct (GType object_type) {
	GwibberStreams * self = NULL;
	StreamsInterface* _tmp0_ = NULL;
	StreamsInterface* _tmp1_;
	GwibberUtils* _tmp2_ = NULL;
	GwibberMessages* _tmp3_ = NULL;
	GwibberSearches* _tmp4_ = NULL;
	GwibberService* _tmp5_ = NULL;
	DeeResourceManager* _tmp8_ = NULL;
	GeeHashMap* _tmp9_ = NULL;
	GObject* _tmp10_ = NULL;
	GObject* _tmp11_;
	GObject* _tmp12_;
	DeeSequenceModel* _tmp13_;
	DeeSequenceModel* _m;
	GError * _inner_error_ = NULL;
	self = (GwibberStreams*) g_object_new (object_type, NULL);
	_tmp0_ = g_initable_new (TYPE_STREAMS_INTERFACE_PROXY, NULL, &_inner_error_, "g-flags", 0, "g-name", GWIBBER_STREAMS_streams_name, "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", GWIBBER_STREAMS_streams_path, "g-interface-name", "com.Gwibber.Streams", NULL);
	_tmp1_ = (StreamsInterface*) _tmp0_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_IO_ERROR) {
			goto __catch39_g_io_error;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_g_object_unref0 (self->priv->streams_service);
	self->priv->streams_service = _tmp1_;
	_tmp2_ = gwibber_utils_new ();
	_g_object_unref0 (self->priv->utils);
	self->priv->utils = _tmp2_;
	gwibber_utils_setup (self->priv->utils, GWIBBER_STREAMS_streams_name, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_IO_ERROR) {
			goto __catch39_g_io_error;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	g_signal_connect_object (self->priv->utils, "available", (GCallback) _gwibber_streams_streams_available_gwibber_utils_available, self, 0);
	_tmp3_ = gwibber_messages_new ();
	_g_object_unref0 (self->priv->messages_service);
	self->priv->messages_service = _tmp3_;
	_tmp4_ = gwibber_searches_new ();
	_g_object_unref0 (self->priv->searches_service);
	self->priv->searches_service = _tmp4_;
	_tmp5_ = gwibber_service_new ();
	_g_object_unref0 (self->priv->service);
	self->priv->service = _tmp5_;
	g_signal_connect_object (self->priv->streams_service, "updated", (GCallback) __lambda8__streams_interface_updated, self, 0);
	g_signal_connect_object (self->priv->streams_service, "created", (GCallback) __lambda9__streams_interface_created, self, 0);
	g_signal_connect_object (self->priv->streams_service, "deleted", (GCallback) __lambda10__streams_interface_deleted, self, 0);
	goto __finally39;
	__catch39_g_io_error:
	{
		GError * e;
		gchar* _tmp6_;
		gchar* _tmp7_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp6_ = g_strconcat ("Unable to get Gwibber Streams: ", e->message, NULL);
		_tmp7_ = _tmp6_;
		g_warning ("streams.vala:126: %s", _tmp7_);
		_g_free0 (_tmp7_);
		_g_error_free0 (e);
	}
	__finally39:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp8_ = dee_resource_manager_get_default ();
	self->priv->resources = _tmp8_;
	_tmp9_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_POINTER, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->seen);
	self->priv->seen = _tmp9_;
	_tmp10_ = dee_resource_manager_load (self->priv->resources, "gwibber.startup", &_inner_error_);
	_tmp11_ = _tmp10_;
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp12_ = _tmp11_;
	_tmp13_ = _g_object_ref0 (DEE_IS_SEQUENCE_MODEL (_tmp12_) ? ((DeeSequenceModel*) _tmp12_) : NULL);
	_m = _tmp13_;
	if (!DEE_IS_SEQUENCE_MODEL (_m)) {
		DeeSequenceModel* _tmp14_ = NULL;
		_tmp14_ = (DeeSequenceModel*) dee_sequence_model_new ();
		_g_object_unref0 (_m);
		_m = _tmp14_;
		dee_model_set_schema ((DeeModel*) _m, "s", NULL);
		dee_model_append ((DeeModel*) _m, "start", NULL);
		dee_resource_manager_store (self->priv->resources, (DeeSerializable*) _m, "gwibber.startup", &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (_m);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_g_object_unref0 (_m);
	return self;
}


GwibberStreams* gwibber_streams_new (void) {
	return gwibber_streams_construct (GWIBBER_TYPE_STREAMS);
}


/**
         * com.Gwibber.Streams
         **/
gchar* gwibber_streams_messages (GwibberStreams* self, const gchar* stream, const gchar* account, gint time, const gchar* transient) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (stream != NULL, NULL);
	g_return_val_if_fail (account != NULL, NULL);
	if (transient == NULL) {
		transient = "0";
	}
	_tmp0_ = streams_interface_Messages (self->priv->streams_service, stream, account, time, transient, "0", "time", "DESC", 1000, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_IO_ERROR) {
			goto __catch40_g_io_error;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	result = _tmp1_;
	return result;
	goto __finally40;
	__catch40_g_io_error:
	{
		GError * e;
		gchar* _tmp2_;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("streams.vala:155: %s", e->message);
		_tmp2_ = g_strdup ("");
		result = _tmp2_;
		_g_error_free0 (e);
		return result;
	}
	__finally40:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
	g_clear_error (&_inner_error_);
	return NULL;
}


DeeModel* gwibber_streams_stream_filter_model (GwibberStreams* self, DeeModel* model, const gchar* stream) {
	DeeModel* result = NULL;
	DeeFilter* stream_filter = NULL;
	DeeFilterModel* _tmp2_ = NULL;
	DeeFilterModel* filtered_model;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (model != NULL, NULL);
	g_return_val_if_fail (stream != NULL, NULL);
	if (g_strcmp0 (stream, "home") == 0) {
		DeeModel* _tmp0_;
		_tmp0_ = _g_object_ref0 (model);
		result = _tmp0_;
		_g_free0 (stream_filter);
		return result;
	} else {
		DeeFilter* _tmp1_ = NULL;
		_tmp1_ = dee_filter_new_for_key_column ((guint) GWIBBER_STREAM_MODEL_COLUMN_STREAM, stream);
		_g_free0 (stream_filter);
		stream_filter = _tmp1_;
	}
	_tmp2_ = (DeeFilterModel*) dee_filter_model_new (stream_filter, model);
	filtered_model = _tmp2_;
	result = (DeeModel*) filtered_model;
	_g_free0 (stream_filter);
	return result;
}


DeeModel* gwibber_streams_transient_filter_model (GwibberStreams* self, DeeModel* model, const gchar* transient) {
	DeeModel* result = NULL;
	DeeFilter* transient_filter = NULL;
	DeeFilter* _tmp0_ = NULL;
	DeeFilterModel* _tmp1_ = NULL;
	DeeFilterModel* filtered_model;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (model != NULL, NULL);
	g_return_val_if_fail (transient != NULL, NULL);
	_tmp0_ = dee_filter_new_for_key_column ((guint) GWIBBER_STREAM_MODEL_COLUMN_TRANSIENT, transient);
	_g_free0 (transient_filter);
	transient_filter = _tmp0_;
	_tmp1_ = (DeeFilterModel*) dee_filter_model_new (transient_filter, model);
	filtered_model = _tmp1_;
	result = (DeeModel*) filtered_model;
	_g_free0 (transient_filter);
	return result;
}


static DeeSequenceModel* gwibber_streams_create_model (GwibberStreams* self) {
	DeeSequenceModel* result = NULL;
	DeeSequenceModel* _tmp0_ = NULL;
	DeeSequenceModel* m;
	guint _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = (DeeSequenceModel*) dee_sequence_model_new ();
	m = _tmp0_;
	dee_model_set_schema ((DeeModel*) m, "as", "s", "s", "s", "s", "b", "s", "s", "s", "s", "s", "s", "s", "s", "s", "s", "d", "s", "s", "s", "s", "s", "s", "s", "s", "s", "s", "s", "s", "s", "s", "s", "s", "s", "s", NULL);
	_tmp1_ = dee_model_get_n_columns ((DeeModel*) m);
	g_debug ("streams.vala:186: SCHEMA has %u rows", _tmp1_);
	result = m;
	return result;
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (Block1Data* _data1_) {
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		_g_object_unref0 (_data1_->self);
		_g_object_unref0 (_data1_->model);
		g_slice_free (Block1Data, _data1_);
	}
}


static gboolean _lambda11_ (Block1Data* _data1_) {
	GwibberStreams * self;
	gboolean result = FALSE;
	self = _data1_->self;
	dee_model_clear ((DeeModel*) _data1_->model);
	gwibber_streams_refresh_model (self);
	result = FALSE;
	return result;
}


static gboolean __lambda11__gsource_func (gpointer self) {
	gboolean result;
	result = _lambda11_ (self);
	return result;
}


static void _lambda12_ (const gchar* change, const gchar* data, GwibberStreams* self) {
	g_return_if_fail (change != NULL);
	g_return_if_fail (data != NULL);
	gwibber_streams_on_refresh (self, change, data);
}


static void __lambda12__gwibber_messages_message (GwibberMessages* _sender, const gchar* change, const gchar* data, gpointer self) {
	_lambda12_ (change, data, self);
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}


static void block2_data_unref (Block2Data* _data2_) {
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		_g_object_unref0 (_data2_->self);
		_g_object_unref0 (_data2_->model);
		g_slice_free (Block2Data, _data2_);
	}
}


static gboolean _lambda13_ (Block2Data* _data2_) {
	GwibberStreams * self;
	gboolean result = FALSE;
	self = _data2_->self;
	dee_model_clear ((DeeModel*) _data2_->model);
	gwibber_streams_refresh_transient_model (self);
	result = FALSE;
	return result;
}


static gboolean __lambda13__gsource_func (gpointer self) {
	gboolean result;
	result = _lambda13_ (self);
	return result;
}


DeeModel* gwibber_streams_streams_model (GwibberStreams* self, gboolean transients) {
	DeeModel* result = NULL;
	guint schema_length;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	schema_length = (guint) 35;
	if (!transients) {
		Block1Data* _data1_;
		GObject* _tmp0_ = NULL;
		GObject* _tmp1_;
		GObject* _tmp2_;
		DeeSequenceModel* _tmp3_;
		guint _tmp4_;
		guint _tmp6_;
		guint cols;
		guint _tmp7_;
		DeeModel* _tmp9_;
		_data1_ = g_slice_new0 (Block1Data);
		_data1_->_ref_count_ = 1;
		_data1_->self = g_object_ref (self);
		g_debug ("streams.vala:196: Getting non-transient model");
		_tmp0_ = dee_resource_manager_load (self->priv->resources, "gwibber.stream_model", &_inner_error_);
		_tmp1_ = _tmp0_;
		if (_inner_error_ != NULL) {
			block1_data_unref (_data1_);
			_data1_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp2_ = _tmp1_;
		_tmp3_ = _g_object_ref0 (DEE_IS_SEQUENCE_MODEL (_tmp2_) ? ((DeeSequenceModel*) _tmp2_) : NULL);
		_data1_->model = _tmp3_;
		_tmp4_ = dee_model_get_n_rows ((DeeModel*) _data1_->model);
		g_debug ("streams.vala:198: stream_model from resources has %u rows", _tmp4_);
		if (!DEE_IS_SEQUENCE_MODEL (_data1_->model)) {
			DeeSequenceModel* _tmp5_ = NULL;
			g_debug ("streams.vala:201: Didn't get model from resource manager, creating a n" \
"ew one");
			_tmp5_ = gwibber_streams_create_model (self);
			_g_object_unref0 (_data1_->model);
			_data1_->model = _tmp5_;
		}
		_tmp6_ = dee_model_get_n_columns ((DeeModel*) _data1_->model);
		cols = _tmp6_;
		g_debug ("streams.vala:205: COLS: %u", cols);
		_tmp7_ = dee_model_get_n_columns ((DeeModel*) _data1_->model);
		if (_tmp7_ != schema_length) {
			DeeSequenceModel* _tmp8_ = NULL;
			g_debug ("streams.vala:208: SCHEMA isn't current, recreating");
			_g_object_unref0 (_data1_->model);
			_data1_->model = NULL;
			_tmp8_ = gwibber_streams_create_model (self);
			_g_object_unref0 (_data1_->model);
			_data1_->model = _tmp8_;
		}
		g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 5, __lambda11__gsource_func, block1_data_ref (_data1_), block1_data_unref);
		g_signal_connect_object (self->priv->messages_service, "message", (GCallback) __lambda12__gwibber_messages_message, self, 0);
		_tmp9_ = _g_object_ref0 ((DeeModel*) _data1_->model);
		result = _tmp9_;
		block1_data_unref (_data1_);
		_data1_ = NULL;
		return result;
	} else {
		Block2Data* _data2_;
		GObject* _tmp10_ = NULL;
		GObject* _tmp11_;
		GObject* _tmp12_;
		DeeSequenceModel* _tmp13_;
		guint _tmp14_;
		guint _tmp16_;
		guint cols;
		guint _tmp17_;
		DeeModel* _tmp19_;
		_data2_ = g_slice_new0 (Block2Data);
		_data2_->_ref_count_ = 1;
		_data2_->self = g_object_ref (self);
		g_debug ("streams.vala:225: Getting transient model");
		_tmp10_ = dee_resource_manager_load (self->priv->resources, "gwibber.transient_model", &_inner_error_);
		_tmp11_ = _tmp10_;
		if (_inner_error_ != NULL) {
			block2_data_unref (_data2_);
			_data2_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp12_ = _tmp11_;
		_tmp13_ = _g_object_ref0 (DEE_IS_SEQUENCE_MODEL (_tmp12_) ? ((DeeSequenceModel*) _tmp12_) : NULL);
		_data2_->model = _tmp13_;
		_tmp14_ = dee_model_get_n_rows ((DeeModel*) _data2_->model);
		g_debug ("streams.vala:227: transient_model from resources has %u rows", _tmp14_);
		if (!DEE_IS_SEQUENCE_MODEL (_data2_->model)) {
			DeeSequenceModel* _tmp15_ = NULL;
			g_debug ("streams.vala:230: Didn't get the transient model from resource manager" \
", creating a new one");
			_tmp15_ = gwibber_streams_create_model (self);
			_g_object_unref0 (_data2_->model);
			_data2_->model = _tmp15_;
		}
		_tmp16_ = dee_model_get_n_columns ((DeeModel*) _data2_->model);
		cols = _tmp16_;
		g_debug ("streams.vala:234: COLS: %u", cols);
		_tmp17_ = dee_model_get_n_columns ((DeeModel*) _data2_->model);
		if (_tmp17_ != schema_length) {
			DeeSequenceModel* _tmp18_ = NULL;
			g_debug ("streams.vala:237: SCHEMA isn't current, recreating");
			_g_object_unref0 (_data2_->model);
			_data2_->model = NULL;
			_tmp18_ = gwibber_streams_create_model (self);
			_g_object_unref0 (_data2_->model);
			_data2_->model = _tmp18_;
		}
		g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 5, __lambda13__gsource_func, block2_data_ref (_data2_), block2_data_unref);
		_tmp19_ = _g_object_ref0 ((DeeModel*) _data2_->model);
		result = _tmp19_;
		block2_data_unref (_data2_);
		_data2_ = NULL;
		return result;
	}
}


static gpointer _json_object_ref0 (gpointer self) {
	return self ? json_object_ref (self) : NULL;
}


static void gwibber_streams_on_refresh (GwibberStreams* self, const gchar* change, const gchar* data) {
	JsonParser* _tmp0_ = NULL;
	JsonParser* parser;
	JsonNode* _tmp1_ = NULL;
	JsonNode* node;
	JsonObject* _tmp2_ = NULL;
	JsonObject* _tmp3_;
	JsonObject* obj;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (change != NULL);
	g_return_if_fail (data != NULL);
	_tmp0_ = json_parser_new ();
	parser = _tmp0_;
	json_parser_load_from_data (parser, data, (gssize) (-1), &_inner_error_);
	if (_inner_error_ != NULL) {
		_g_object_unref0 (parser);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp1_ = json_parser_get_root (parser);
	node = _tmp1_;
	_tmp2_ = json_node_get_object (node);
	_tmp3_ = _json_object_ref0 (_tmp2_);
	obj = _tmp3_;
	if (obj != NULL) {
		gwibber_streams_parse_message (self, obj, change);
	}
	_json_object_unref0 (obj);
	_g_object_unref0 (parser);
}


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _g_list_free__g_free0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_free0_, NULL);
	g_list_free (self);
}


static void gwibber_streams_refresh_model (GwibberStreams* self) {
	GList* streams;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	DeeModel* _tmp9_ = NULL;
	DeeModel* _tmp10_ = NULL;
	guint _tmp11_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_debug ("streams.vala:263: refresh_model");
	streams = NULL;
	_tmp0_ = g_strdup ("replies");
	streams = g_list_append (streams, _tmp0_);
	_tmp1_ = g_strdup ("private");
	streams = g_list_append (streams, _tmp1_);
	_tmp2_ = g_strdup ("public");
	streams = g_list_append (streams, _tmp2_);
	_tmp3_ = g_strdup ("images");
	streams = g_list_append (streams, _tmp3_);
	_tmp4_ = g_strdup ("links");
	streams = g_list_append (streams, _tmp4_);
	_tmp5_ = g_strdup ("videos");
	streams = g_list_append (streams, _tmp5_);
	_tmp6_ = g_strdup ("messages");
	streams = g_list_append (streams, _tmp6_);
	{
		GList* stream_collection;
		GList* stream_it;
		stream_collection = streams;
		for (stream_it = stream_collection; stream_it != NULL; stream_it = stream_it->next) {
			gchar* _tmp7_;
			gchar* stream;
			_tmp7_ = g_strdup ((const gchar*) stream_it->data);
			stream = _tmp7_;
			{
				gchar* _tmp8_ = NULL;
				gchar* msgs;
				_tmp8_ = gwibber_streams_messages (self, stream, "all", 0, NULL);
				msgs = _tmp8_;
				gwibber_streams_parse_messages (self, msgs);
				_g_free0 (msgs);
				_g_free0 (stream);
			}
		}
	}
	g_debug ("streams.vala:277: Storing gwibber.stream_model");
	_tmp9_ = gwibber_streams_get_stream_model (self);
	dee_resource_manager_store (self->priv->resources, (DeeSerializable*) DEE_SEQUENCE_MODEL (_tmp9_), "gwibber.stream_model", &_inner_error_);
	if (_inner_error_ != NULL) {
		__g_list_free__g_free0_0 (streams);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp10_ = gwibber_streams_get_stream_model (self);
	_tmp11_ = dee_model_get_n_rows (_tmp10_);
	g_debug ("streams.vala:279: stream_model has %u rows", _tmp11_);
	__g_list_free__g_free0_0 (streams);
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


static void gwibber_streams_refresh_transient_model (GwibberStreams* self) {
	GList* _tmp0_ = NULL;
	GList* searches;
	GList* _tmp6_ = NULL;
	GList* streams_list;
	DeeModel* _tmp14_ = NULL;
	DeeModel* _tmp15_ = NULL;
	guint _tmp16_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_debug ("streams.vala:284: refresh_transient_model");
	_tmp0_ = gwibber_searches_list (self->priv->searches_service);
	searches = _tmp0_;
	{
		GList* x_collection;
		GList* x_it;
		x_collection = searches;
		for (x_it = x_collection; x_it != NULL; x_it = x_it->next) {
			GeeHashMap* _tmp1_;
			GeeHashMap* x;
			_tmp1_ = _g_object_ref0 ((GeeHashMap*) x_it->data);
			x = _tmp1_;
			{
				gpointer _tmp2_ = NULL;
				gchar* _tmp3_;
				gchar* _tmp4_ = NULL;
				gchar* _tmp5_;
				gchar* msgs;
				_tmp2_ = gee_abstract_map_get ((GeeAbstractMap*) x, "id");
				_tmp3_ = (gchar*) _tmp2_;
				_tmp4_ = gwibber_streams_messages (self, "all", "all", 0, _tmp3_);
				_tmp5_ = _tmp4_;
				_g_free0 (_tmp3_);
				msgs = _tmp5_;
				gwibber_streams_parse_messages (self, msgs);
				_g_free0 (msgs);
				_g_object_unref0 (x);
			}
		}
	}
	_tmp6_ = gwibber_streams_list (self);
	streams_list = _tmp6_;
	{
		GList* x_collection;
		GList* x_it;
		x_collection = streams_list;
		for (x_it = x_collection; x_it != NULL; x_it = x_it->next) {
			GeeHashMap* _tmp7_;
			GeeHashMap* x;
			_tmp7_ = _g_object_ref0 ((GeeHashMap*) x_it->data);
			x = _tmp7_;
			{
				gpointer _tmp8_ = NULL;
				gchar* _tmp9_;
				gpointer _tmp10_ = NULL;
				gchar* _tmp11_;
				gchar* _tmp12_ = NULL;
				gchar* _tmp13_;
				gchar* msgs;
				_tmp8_ = gee_abstract_map_get ((GeeAbstractMap*) x, "account");
				_tmp9_ = (gchar*) _tmp8_;
				_tmp10_ = gee_abstract_map_get ((GeeAbstractMap*) x, "id");
				_tmp11_ = (gchar*) _tmp10_;
				_tmp12_ = gwibber_streams_messages (self, "all", _tmp9_, 0, _tmp11_);
				_tmp13_ = _tmp12_;
				_g_free0 (_tmp11_);
				_g_free0 (_tmp9_);
				msgs = _tmp13_;
				gwibber_streams_parse_messages (self, msgs);
				_g_free0 (msgs);
				_g_object_unref0 (x);
			}
		}
	}
	g_debug ("streams.vala:297: Storing gwibber.transient_model");
	_tmp14_ = gwibber_streams_get_transient_model (self);
	dee_resource_manager_store (self->priv->resources, (DeeSerializable*) DEE_SEQUENCE_MODEL (_tmp14_), "gwibber.transient_model", &_inner_error_);
	if (_inner_error_ != NULL) {
		__g_list_free__g_object_unref0_0 (streams_list);
		__g_list_free__g_object_unref0_0 (searches);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp15_ = gwibber_streams_get_transient_model (self);
	_tmp16_ = dee_model_get_n_rows (_tmp15_);
	g_debug ("streams.vala:299: transient_model has %u rows", _tmp16_);
	__g_list_free__g_object_unref0_0 (streams_list);
	__g_list_free__g_object_unref0_0 (searches);
}


static gpointer _json_array_ref0 (gpointer self) {
	return self ? json_array_ref (self) : NULL;
}


static void gwibber_streams_parse_messages (GwibberStreams* self, const gchar* data) {
	JsonParser* _tmp0_ = NULL;
	JsonParser* parser;
	JsonNode* _tmp1_ = NULL;
	JsonArray* _tmp2_ = NULL;
	JsonArray* _tmp3_;
	JsonArray* nodeArray;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (data != NULL);
	_tmp0_ = json_parser_new ();
	parser = _tmp0_;
	json_parser_load_from_data (parser, data, (gssize) (-1), &_inner_error_);
	if (_inner_error_ != NULL) {
		_g_object_unref0 (parser);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp1_ = json_parser_get_root (parser);
	_tmp2_ = json_node_get_array (_tmp1_);
	_tmp3_ = _json_array_ref0 (_tmp2_);
	nodeArray = _tmp3_;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp4_;
			_tmp4_ = TRUE;
			while (TRUE) {
				guint _tmp5_;
				JsonNode* _tmp6_ = NULL;
				JsonObject* _tmp7_ = NULL;
				JsonObject* _tmp8_;
				JsonObject* obj;
				if (!_tmp4_) {
					i++;
				}
				_tmp4_ = FALSE;
				_tmp5_ = json_array_get_length (nodeArray);
				if (!(i < _tmp5_)) {
					break;
				}
				_tmp6_ = json_array_get_element (nodeArray, (guint) i);
				_tmp7_ = json_node_get_object (_tmp6_);
				_tmp8_ = _json_object_ref0 (_tmp7_);
				obj = _tmp8_;
				if (obj != NULL) {
					gwibber_streams_parse_message (self, obj, "new");
				}
				_json_object_unref0 (obj);
			}
		}
	}
	_json_array_unref0 (nodeArray);
	_g_object_unref0 (parser);
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	GRegex* _tmp2_ = NULL;
	GRegex* _tmp3_;
	GRegex* regex;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	_tmp0_ = g_regex_escape_string (old, -1);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_regex_new (_tmp1_, 0, 0, &_inner_error_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	regex = _tmp3_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_REGEX_ERROR) {
			goto __catch41_g_regex_error;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp4_ = g_regex_replace_literal (regex, self, (gssize) (-1), 0, replacement, 0, &_inner_error_);
	_tmp5_ = _tmp4_;
	if (_inner_error_ != NULL) {
		_g_regex_unref0 (regex);
		if (_inner_error_->domain == G_REGEX_ERROR) {
			goto __catch41_g_regex_error;
		}
		_g_regex_unref0 (regex);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	result = _tmp5_;
	_g_regex_unref0 (regex);
	return result;
	_g_regex_unref0 (regex);
	goto __finally41;
	__catch41_g_regex_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally41:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _result_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}


static gchar** _variant_get1 (GVariant* value, int* result_length1) {
	gchar** _tmp209_;
	int _tmp209__length;
	int _tmp209__size;
	int _tmp209__length1;
	GVariantIter _tmp210_;
	GVariant* _tmp211_;
	_tmp209_ = g_new (gchar*, 5);
	_tmp209__length = 0;
	_tmp209__size = 4;
	_tmp209__length1 = 0;
	g_variant_iter_init (&_tmp210_, value);
	for (; (_tmp211_ = g_variant_iter_next_value (&_tmp210_)) != NULL; _tmp209__length1++) {
		if (_tmp209__size == _tmp209__length) {
			_tmp209__size = 2 * _tmp209__size;
			_tmp209_ = g_renew (gchar*, _tmp209_, _tmp209__size + 1);
		}
		_tmp209_[_tmp209__length++] = g_variant_dup_string (_tmp211_, NULL);
		g_variant_unref (_tmp211_);
	}
	*result_length1 = _tmp209__length1;
	_tmp209_[_tmp209__length] = NULL;
	return _tmp209_;
}


static gboolean _vala_string_array_contains (gchar** stack, int stack_length, gchar* needle) {
	int i;
	for (i = 0; i < stack_length; i++) {
		if (g_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}


static GVariant* _variant_new2 (const gchar* value) {
	return g_variant_ref_sink (g_variant_new_string (value));
}


static GVariant* _variant_new3 (const gchar* value) {
	return g_variant_ref_sink (g_variant_new_string (value));
}


static GVariant* _variant_new4 (const gchar* value) {
	return g_variant_ref_sink (g_variant_new_string (value));
}


static GVariant* _variant_new5 (gdouble value) {
	return g_variant_ref_sink (g_variant_new_double (value));
}


static void gwibber_streams_parse_message (GwibberStreams* self, JsonObject* obj, const gchar* change) {
	gchar* _account;
	gchar* _stream;
	gchar* _service;
	gchar* _operation;
	gchar* _mid;
	gchar* _source;
	gchar* _reply_nick;
	gchar* _reply_name;
	gchar* _reply_url;
	gdouble _likes;
	gchar* _retweeted_by_nick;
	gchar* _retweeted_by_name;
	gchar* _retweeted_by_id;
	gchar* _link_picture;
	gchar* _link_name;
	gchar* _link_url;
	gchar* _link_description;
	gchar* _link_caption;
	gchar* _link_icon;
	gchar* _image_url;
	gchar* _image_src;
	gchar* _image_thumb;
	gchar* _image_name;
	gchar* _video_picture;
	gchar* _video_src;
	gchar* _video_url;
	gchar* _video_name;
	gboolean _from_me;
	guint _time;
	gchar* _html;
	gchar* _text;
	gchar* _icon;
	gchar* _url;
	gchar* _comments;
	gchar* transient;
	DeeModelIter* iter;
	GList* _tmp0_ = NULL;
	GList* members;
	gboolean _tmp1_;
	DeeModel* _tmp5_ = NULL;
	DeeModel* _tmp6_;
	DeeModel* _model;
	gint _tmp7_;
	gboolean _tmp10_ = FALSE;
	gint _tmp11_;
	gboolean _tmp12_;
	gboolean _tmp15_;
	gboolean _tmp20_;
	gboolean _tmp23_;
	gboolean _tmp26_;
	gchar* _tmp29_;
	gchar* _tmp30_;
	gchar* _tmp31_;
	gchar* _tmp32_;
	gchar* _tmp33_;
	gchar* _tmp34_;
	gchar* _tmp35_;
	gchar* _tmp36_;
	gchar* _acct;
	GVariantType* _tmp37_ = NULL;
	GVariantType* _tmp38_;
	GVariantBuilder* _tmp39_ = NULL;
	GVariantBuilder* _tmp40_;
	GVariantBuilder* builder;
	JsonObject* _sender_obj;
	gchar* _tmp41_;
	gchar* _sender;
	gchar* _tmp42_;
	gchar* _sender_nick;
	gboolean _tmp43_;
	gboolean _tmp52_;
	gboolean _tmp54_;
	gboolean _tmp56_ = FALSE;
	gboolean _tmp59_;
	gboolean _tmp62_;
	gchar* _tmp65_;
	gchar* _textid;
	gchar* _tmp66_ = NULL;
	gchar* _tmp67_;
	gchar** _tmp68_;
	gchar** _tmp69_ = NULL;
	gchar** _tmp70_;
	gchar* _tmp84_ = NULL;
	gboolean _tmp85_;
	gboolean _tmp88_;
	gchar* _tmp199_ = NULL;
	gchar* _tmp200_ = NULL;
	gchar* _tmp201_ = NULL;
	gchar* _tmp202_ = NULL;
	gchar* _tmp203_ = NULL;
	gchar* _t;
	gboolean _tmp204_ = FALSE;
	gboolean _tmp205_;
	GVariant* _tmp214_ = NULL;
	GVariant* _accounts;
	gchar* _tmp215_ = NULL;
	gchar* _tmp216_;
	DeeModelIter* _tmp217_ = NULL;
	gboolean _tmp218_ = FALSE;
	gint _tmp219_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (obj != NULL);
	g_return_if_fail (change != NULL);
	_account = NULL;
	_stream = NULL;
	_service = NULL;
	_operation = NULL;
	_mid = NULL;
	_source = NULL;
	_reply_nick = NULL;
	_reply_name = NULL;
	_reply_url = NULL;
	_likes = (gdouble) 0;
	_retweeted_by_nick = NULL;
	_retweeted_by_name = NULL;
	_retweeted_by_id = NULL;
	_link_picture = NULL;
	_link_name = NULL;
	_link_url = NULL;
	_link_description = NULL;
	_link_caption = NULL;
	_link_icon = NULL;
	_image_url = NULL;
	_image_src = NULL;
	_image_thumb = NULL;
	_image_name = NULL;
	_video_picture = NULL;
	_video_src = NULL;
	_video_url = NULL;
	_video_name = NULL;
	_from_me = FALSE;
	_time = (guint) 0;
	_html = NULL;
	_text = NULL;
	_icon = NULL;
	_url = NULL;
	_comments = NULL;
	transient = NULL;
	iter = NULL;
	_tmp0_ = json_object_get_members (obj);
	members = _tmp0_;
	_tmp1_ = json_object_has_member (obj, "transient");
	if (_tmp1_) {
		const gchar* _tmp2_ = NULL;
		gchar* _tmp3_;
		_tmp2_ = json_object_get_string_member (obj, "transient");
		_tmp3_ = g_strdup (_tmp2_);
		_g_free0 (transient);
		transient = _tmp3_;
	}
	if (transient == NULL) {
		gchar* _tmp4_;
		_tmp4_ = g_strdup ("0");
		_g_free0 (transient);
		transient = _tmp4_;
	}
	_tmp5_ = gwibber_streams_get_stream_model (self);
	_tmp6_ = _g_object_ref0 (_tmp5_);
	_model = _tmp6_;
	_tmp7_ = strlen (transient);
	if (_tmp7_ > 1) {
		DeeModel* _tmp8_ = NULL;
		DeeModel* _tmp9_;
		_tmp8_ = gwibber_streams_get_transient_model (self);
		_tmp9_ = _g_object_ref0 (_tmp8_);
		_g_object_unref0 (_model);
		_model = _tmp9_;
	}
	if (!DEE_IS_MODEL (_model)) {
		g_debug ("streams.vala:366: ERROR: Not a valid model, transient is %s", transient);
		_g_object_unref0 (_model);
		_g_list_free0 (members);
		_g_free0 (transient);
		_g_free0 (_comments);
		_g_free0 (_url);
		_g_free0 (_icon);
		_g_free0 (_text);
		_g_free0 (_html);
		_g_free0 (_video_name);
		_g_free0 (_video_url);
		_g_free0 (_video_src);
		_g_free0 (_video_picture);
		_g_free0 (_image_name);
		_g_free0 (_image_thumb);
		_g_free0 (_image_src);
		_g_free0 (_image_url);
		_g_free0 (_link_icon);
		_g_free0 (_link_caption);
		_g_free0 (_link_description);
		_g_free0 (_link_url);
		_g_free0 (_link_name);
		_g_free0 (_link_picture);
		_g_free0 (_retweeted_by_id);
		_g_free0 (_retweeted_by_name);
		_g_free0 (_retweeted_by_nick);
		_g_free0 (_reply_url);
		_g_free0 (_reply_name);
		_g_free0 (_reply_nick);
		_g_free0 (_source);
		_g_free0 (_mid);
		_g_free0 (_operation);
		_g_free0 (_service);
		_g_free0 (_stream);
		_g_free0 (_account);
		return;
	}
	_tmp11_ = strlen (transient);
	if (_tmp11_ > 1) {
		_tmp10_ = g_strcmp0 (change, "new") != 0;
	} else {
		_tmp10_ = FALSE;
	}
	if (_tmp10_) {
		_g_object_unref0 (_model);
		_g_list_free0 (members);
		_g_free0 (transient);
		_g_free0 (_comments);
		_g_free0 (_url);
		_g_free0 (_icon);
		_g_free0 (_text);
		_g_free0 (_html);
		_g_free0 (_video_name);
		_g_free0 (_video_url);
		_g_free0 (_video_src);
		_g_free0 (_video_picture);
		_g_free0 (_image_name);
		_g_free0 (_image_thumb);
		_g_free0 (_image_src);
		_g_free0 (_image_url);
		_g_free0 (_link_icon);
		_g_free0 (_link_caption);
		_g_free0 (_link_description);
		_g_free0 (_link_url);
		_g_free0 (_link_name);
		_g_free0 (_link_picture);
		_g_free0 (_retweeted_by_id);
		_g_free0 (_retweeted_by_name);
		_g_free0 (_retweeted_by_nick);
		_g_free0 (_reply_url);
		_g_free0 (_reply_name);
		_g_free0 (_reply_nick);
		_g_free0 (_source);
		_g_free0 (_mid);
		_g_free0 (_operation);
		_g_free0 (_service);
		_g_free0 (_stream);
		_g_free0 (_account);
		return;
	}
	_tmp12_ = json_object_has_member (obj, "account");
	if (_tmp12_) {
		const gchar* _tmp13_ = NULL;
		gchar* _tmp14_;
		_tmp13_ = json_object_get_string_member (obj, "account");
		_tmp14_ = g_strdup (_tmp13_);
		_g_free0 (_account);
		_account = _tmp14_;
	}
	_tmp15_ = json_object_has_member (obj, "stream");
	if (_tmp15_) {
		const gchar* _tmp16_ = NULL;
		gchar* _tmp17_;
		_tmp16_ = json_object_get_string_member (obj, "stream");
		_tmp17_ = g_strdup (_tmp16_);
		_g_free0 (_stream);
		_stream = _tmp17_;
	}
	if (g_strcmp0 (_stream, "send_private") == 0) {
		gchar* _tmp18_;
		_tmp18_ = g_strdup ("private");
		_g_free0 (_stream);
		_stream = _tmp18_;
	}
	if (g_strcmp0 (_stream, "send_thread") == 0) {
		gchar* _tmp19_;
		_tmp19_ = g_strdup ("replies");
		_g_free0 (_stream);
		_stream = _tmp19_;
	}
	_tmp20_ = json_object_has_member (obj, "service");
	if (_tmp20_) {
		const gchar* _tmp21_ = NULL;
		gchar* _tmp22_;
		_tmp21_ = json_object_get_string_member (obj, "service");
		_tmp22_ = g_strdup (_tmp21_);
		_g_free0 (_service);
		_service = _tmp22_;
	}
	_tmp23_ = json_object_has_member (obj, "operation");
	if (_tmp23_) {
		const gchar* _tmp24_ = NULL;
		gchar* _tmp25_;
		_tmp24_ = json_object_get_string_member (obj, "operation");
		_tmp25_ = g_strdup (_tmp24_);
		_g_free0 (_operation);
		_operation = _tmp25_;
	}
	_tmp26_ = json_object_has_member (obj, "mid");
	if (_tmp26_) {
		const gchar* _tmp27_ = NULL;
		gchar* _tmp28_;
		_tmp27_ = json_object_get_string_member (obj, "id");
		_tmp28_ = g_strdup (_tmp27_);
		_g_free0 (_mid);
		_mid = _tmp28_;
	}
	_tmp29_ = g_strconcat (_account, ":", NULL);
	_tmp30_ = _tmp29_;
	_tmp31_ = g_strconcat (_tmp30_, _service, NULL);
	_tmp32_ = _tmp31_;
	_tmp33_ = g_strconcat (_tmp32_, ":", NULL);
	_tmp34_ = _tmp33_;
	_tmp35_ = g_strconcat (_tmp34_, _mid, NULL);
	_tmp36_ = _tmp35_;
	_g_free0 (_tmp34_);
	_g_free0 (_tmp32_);
	_g_free0 (_tmp30_);
	_acct = _tmp36_;
	_tmp37_ = g_variant_type_new ("as");
	_tmp38_ = _tmp37_;
	_tmp39_ = g_variant_builder_new (_tmp38_);
	_tmp40_ = _tmp39_;
	_g_variant_type_free0 (_tmp38_);
	builder = _tmp40_;
	g_variant_builder_add (builder, "s", _acct, NULL);
	_sender_obj = NULL;
	_tmp41_ = g_strdup ("");
	_sender = _tmp41_;
	_tmp42_ = g_strdup ("");
	_sender_nick = _tmp42_;
	_tmp43_ = json_object_has_member (obj, "sender");
	if (_tmp43_) {
		JsonObject* _tmp44_ = NULL;
		JsonObject* _tmp45_;
		_tmp44_ = json_object_get_object_member (obj, "sender");
		_tmp45_ = _json_object_ref0 (_tmp44_);
		_json_object_unref0 (_sender_obj);
		_sender_obj = _tmp45_;
		if (_sender_obj != NULL) {
			gboolean _tmp46_;
			gboolean _tmp49_;
			_tmp46_ = json_object_has_member (_sender_obj, "name");
			if (_tmp46_) {
				const gchar* _tmp47_ = NULL;
				gchar* _tmp48_;
				_tmp47_ = json_object_get_string_member (_sender_obj, "name");
				_tmp48_ = g_strdup (_tmp47_);
				_g_free0 (_sender);
				_sender = _tmp48_;
			}
			_tmp49_ = json_object_has_member (_sender_obj, "nick");
			if (_tmp49_) {
				const gchar* _tmp50_ = NULL;
				gchar* _tmp51_;
				_tmp50_ = json_object_get_string_member (_sender_obj, "nick");
				_tmp51_ = g_strdup (_tmp50_);
				_g_free0 (_sender_nick);
				_sender_nick = _tmp51_;
			}
		}
	}
	_tmp52_ = json_object_has_member (_sender_obj, "is_me");
	if (_tmp52_) {
		gboolean _tmp53_;
		_tmp53_ = json_object_get_boolean_member (_sender_obj, "is_me");
		_from_me = _tmp53_;
	}
	_tmp54_ = json_object_has_member (obj, "time");
	if (_tmp54_) {
		gdouble _tmp55_;
		_tmp55_ = json_object_get_double_member (obj, "time");
		_time = (guint) _tmp55_;
	}
	if (_time < 1) {
		gboolean _tmp57_;
		_tmp57_ = json_object_has_member (obj, "time");
		_tmp56_ = _tmp57_;
	} else {
		_tmp56_ = FALSE;
	}
	if (_tmp56_) {
		gint64 _tmp58_;
		_tmp58_ = json_object_get_int_member (obj, "time");
		_time = (guint) _tmp58_;
	}
	_tmp59_ = json_object_has_member (obj, "content");
	if (_tmp59_) {
		const gchar* _tmp60_ = NULL;
		gchar* _tmp61_;
		_tmp60_ = json_object_get_string_member (obj, "content");
		_tmp61_ = g_strdup (_tmp60_);
		_g_free0 (_html);
		_html = _tmp61_;
	}
	_tmp62_ = json_object_has_member (obj, "text");
	if (_tmp62_) {
		const gchar* _tmp63_ = NULL;
		gchar* _tmp64_;
		_tmp63_ = json_object_get_string_member (obj, "text");
		_tmp64_ = g_strdup (_tmp63_);
		_g_free0 (_text);
		_text = _tmp64_;
	}
	_tmp65_ = g_strdup ("");
	_textid = _tmp65_;
	_tmp66_ = string_replace (_text, ".", "");
	_tmp67_ = _tmp66_;
	_tmp69_ = _tmp68_ = g_strsplit (_tmp67_, " ", 0);
	_tmp70_ = _tmp69_;
	_g_free0 (_tmp67_);
	{
		gchar** x_collection;
		int x_collection_length1;
		int x_it;
		x_collection = _tmp70_;
		x_collection_length1 = _vala_array_length (_tmp68_);
		for (x_it = 0; x_it < _vala_array_length (_tmp68_); x_it = x_it + 1) {
			gchar* _tmp71_;
			gchar* x;
			_tmp71_ = g_strdup (x_collection[x_it]);
			x = _tmp71_;
			{
				gboolean _tmp72_ = FALSE;
				gboolean _tmp73_ = FALSE;
				gboolean _tmp74_ = FALSE;
				gboolean _tmp75_ = FALSE;
				gboolean _tmp76_;
				_tmp76_ = g_str_has_prefix (x, "http://");
				if (!_tmp76_) {
					gboolean _tmp77_;
					_tmp77_ = g_str_has_prefix (x, "https://");
					_tmp75_ = !_tmp77_;
				} else {
					_tmp75_ = FALSE;
				}
				if (_tmp75_) {
					gboolean _tmp78_;
					_tmp78_ = g_str_has_prefix (x, "gwibber:/");
					_tmp74_ = !_tmp78_;
				} else {
					_tmp74_ = FALSE;
				}
				if (_tmp74_) {
					gboolean _tmp79_;
					_tmp79_ = g_str_has_prefix (x, "#");
					_tmp73_ = !_tmp79_;
				} else {
					_tmp73_ = FALSE;
				}
				if (_tmp73_) {
					gboolean _tmp80_;
					_tmp80_ = g_str_has_prefix (x, "!");
					_tmp72_ = !_tmp80_;
				} else {
					_tmp72_ = FALSE;
				}
				if (_tmp72_) {
					gchar* _tmp81_;
					gchar* _tmp82_;
					gchar* _tmp83_;
					_tmp81_ = g_strconcat (x, " ", NULL);
					_tmp82_ = _tmp81_;
					_tmp83_ = g_strconcat (_textid, _tmp82_, NULL);
					_g_free0 (_textid);
					_textid = _tmp83_;
					_g_free0 (_tmp82_);
				}
				_g_free0 (x);
			}
		}
		x_collection = (_vala_array_free (x_collection, x_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	_tmp84_ = string_strip (_textid);
	_g_free0 (_textid);
	_textid = _tmp84_;
	_tmp85_ = json_object_has_member (_sender_obj, "image");
	if (_tmp85_) {
		const gchar* _tmp86_ = NULL;
		gchar* _tmp87_;
		_tmp86_ = json_object_get_string_member (_sender_obj, "image");
		_tmp87_ = g_strdup (_tmp86_);
		_g_free0 (_icon);
		_icon = _tmp87_;
	}
	_tmp88_ = json_object_has_member (obj, "url");
	if (_tmp88_) {
		const gchar* _tmp89_ = NULL;
		gchar* _tmp90_;
		_tmp89_ = json_object_get_string_member (obj, "url");
		_tmp90_ = g_strdup (_tmp89_);
		_g_free0 (_url);
		_url = _tmp90_;
	}
	{
		GList* member_collection;
		GList* member_it;
		member_collection = members;
		for (member_it = member_collection; member_it != NULL; member_it = member_it->next) {
			gchar* _tmp91_;
			gchar* member;
			_tmp91_ = g_strdup ((const gchar*) member_it->data);
			member = _tmp91_;
			{
				if (g_strcmp0 (member, "retweeted_by") == 0) {
					JsonObject* _tmp92_ = NULL;
					JsonObject* _tmp93_;
					JsonObject* _retweet_obj;
					_tmp92_ = json_object_get_object_member (obj, member);
					_tmp93_ = _json_object_ref0 (_tmp92_);
					_retweet_obj = _tmp93_;
					if (_retweet_obj != NULL) {
						gboolean _tmp94_;
						gboolean _tmp97_;
						gboolean _tmp100_;
						_tmp94_ = json_object_has_member (_retweet_obj, "nick");
						if (_tmp94_) {
							const gchar* _tmp95_ = NULL;
							gchar* _tmp96_;
							_tmp95_ = json_object_get_string_member (_retweet_obj, "nick");
							_tmp96_ = g_strdup (_tmp95_);
							_g_free0 (_retweeted_by_nick);
							_retweeted_by_nick = _tmp96_;
						}
						_tmp97_ = json_object_has_member (_retweet_obj, "name");
						if (_tmp97_) {
							const gchar* _tmp98_ = NULL;
							gchar* _tmp99_;
							_tmp98_ = json_object_get_string_member (_retweet_obj, "name");
							_tmp99_ = g_strdup (_tmp98_);
							_g_free0 (_retweeted_by_name);
							_retweeted_by_name = _tmp99_;
						}
						_tmp100_ = json_object_has_member (_retweet_obj, "id");
						if (_tmp100_) {
							gint64 _tmp101_;
							gchar* _tmp102_ = NULL;
							_tmp101_ = json_object_get_int_member (_retweet_obj, "id");
							_tmp102_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp101_);
							_g_free0 (_retweeted_by_id);
							_retweeted_by_id = _tmp102_;
						}
					}
					_json_object_unref0 (_retweet_obj);
				}
				if (g_strcmp0 (member, "source") == 0) {
					const gchar* _tmp103_ = NULL;
					gchar* _tmp104_;
					_tmp103_ = json_object_get_string_member (obj, "source");
					_tmp104_ = g_strdup (_tmp103_);
					_g_free0 (_source);
					_source = _tmp104_;
					if (_source != NULL) {
						gchar* _tmp105_ = NULL;
						_tmp105_ = string_replace (_source, "rel=\"nofollow\"", "");
						_g_free0 (_source);
						_source = _tmp105_;
					}
				}
				if (g_strcmp0 (member, "reply") == 0) {
					JsonObject* _tmp106_ = NULL;
					JsonObject* _tmp107_;
					JsonObject* _reply_obj;
					_tmp106_ = json_object_get_object_member (obj, "reply");
					_tmp107_ = _json_object_ref0 (_tmp106_);
					_reply_obj = _tmp107_;
					if (_reply_obj != NULL) {
						gboolean _tmp108_;
						gboolean _tmp111_;
						gboolean _tmp114_;
						_tmp108_ = json_object_has_member (_reply_obj, "nick");
						if (_tmp108_) {
							const gchar* _tmp109_ = NULL;
							gchar* _tmp110_;
							_tmp109_ = json_object_get_string_member (_reply_obj, "nick");
							_tmp110_ = g_strdup (_tmp109_);
							_g_free0 (_reply_nick);
							_reply_nick = _tmp110_;
						}
						_tmp111_ = json_object_has_member (_reply_obj, "name");
						if (_tmp111_) {
							const gchar* _tmp112_ = NULL;
							gchar* _tmp113_;
							_tmp112_ = json_object_get_string_member (_reply_obj, "name");
							_tmp113_ = g_strdup (_tmp112_);
							_g_free0 (_reply_name);
							_reply_name = _tmp113_;
						}
						_tmp114_ = json_object_has_member (_reply_obj, "url");
						if (_tmp114_) {
							const gchar* _tmp115_ = NULL;
							gchar* _tmp116_;
							_tmp115_ = json_object_get_string_member (_reply_obj, "url");
							_tmp116_ = g_strdup (_tmp115_);
							_g_free0 (_reply_url);
							_reply_url = _tmp116_;
							if (_reply_url != NULL) {
								gchar* _tmp117_ = NULL;
								_tmp117_ = g_markup_escape_text (_reply_url, (gssize) (-1));
								_g_free0 (_reply_url);
								_reply_url = _tmp117_;
							}
						}
					}
					_json_object_unref0 (_reply_obj);
				}
				if (g_strcmp0 (member, "likes") == 0) {
					JsonObject* _tmp118_ = NULL;
					JsonObject* _tmp119_;
					JsonObject* _likes_obj;
					_tmp118_ = json_object_get_object_member (obj, "likes");
					_tmp119_ = _json_object_ref0 (_tmp118_);
					_likes_obj = _tmp119_;
					if (_likes_obj != NULL) {
						gboolean _tmp120_;
						_tmp120_ = json_object_has_member (_likes_obj, "count");
						if (_tmp120_) {
							gint64 _tmp121_;
							_tmp121_ = json_object_get_int_member (_likes_obj, "count");
							_likes = (gdouble) _tmp121_;
						}
					}
					_json_object_unref0 (_likes_obj);
				}
				if (g_strcmp0 (member, "favorited") == 0) {
					gboolean _tmp122_;
					_tmp122_ = json_object_get_boolean_member (obj, "favorited");
					if (_tmp122_) {
						_likes = (gdouble) (-1);
					}
				}
				if (g_strcmp0 (member, "link") == 0) {
					JsonObject* _tmp123_ = NULL;
					JsonObject* _tmp124_;
					JsonObject* _link_obj;
					_tmp123_ = json_object_get_object_member (obj, member);
					_tmp124_ = _json_object_ref0 (_tmp123_);
					_link_obj = _tmp124_;
					if (_link_obj != NULL) {
						gboolean _tmp125_;
						gboolean _tmp128_;
						gboolean _tmp131_;
						gboolean _tmp135_;
						gboolean _tmp138_;
						gboolean _tmp141_;
						_tmp125_ = json_object_has_member (_link_obj, "picture");
						if (_tmp125_) {
							const gchar* _tmp126_ = NULL;
							gchar* _tmp127_;
							_tmp126_ = json_object_get_string_member (_link_obj, "picture");
							_tmp127_ = g_strdup (_tmp126_);
							_g_free0 (_link_picture);
							_link_picture = _tmp127_;
						}
						_tmp128_ = json_object_has_member (_link_obj, "name");
						if (_tmp128_) {
							const gchar* _tmp129_ = NULL;
							gchar* _tmp130_;
							_tmp129_ = json_object_get_string_member (_link_obj, "name");
							_tmp130_ = g_strdup (_tmp129_);
							_g_free0 (_link_name);
							_link_name = _tmp130_;
						}
						_tmp131_ = json_object_has_member (_link_obj, "url");
						if (_tmp131_) {
							const gchar* _tmp132_ = NULL;
							gchar* _tmp133_;
							_tmp132_ = json_object_get_string_member (_link_obj, "url");
							_tmp133_ = g_strdup (_tmp132_);
							_g_free0 (_link_url);
							_link_url = _tmp133_;
							if (_link_url != NULL) {
								gchar* _tmp134_ = NULL;
								_tmp134_ = g_markup_escape_text (_link_url, (gssize) (-1));
								_g_free0 (_link_url);
								_link_url = _tmp134_;
							}
						}
						_tmp135_ = json_object_has_member (_link_obj, "description");
						if (_tmp135_) {
							const gchar* _tmp136_ = NULL;
							gchar* _tmp137_;
							_tmp136_ = json_object_get_string_member (_link_obj, "description");
							_tmp137_ = g_strdup (_tmp136_);
							_g_free0 (_link_description);
							_link_description = _tmp137_;
						}
						_tmp138_ = json_object_has_member (_link_obj, "caption");
						if (_tmp138_) {
							const gchar* _tmp139_ = NULL;
							gchar* _tmp140_;
							_tmp139_ = json_object_get_string_member (_link_obj, "caption");
							_tmp140_ = g_strdup (_tmp139_);
							_g_free0 (_link_caption);
							_link_caption = _tmp140_;
						}
						_tmp141_ = json_object_has_member (_link_obj, "icon");
						if (_tmp141_) {
							const gchar* _tmp142_ = NULL;
							gchar* _tmp143_;
							_tmp142_ = json_object_get_string_member (_link_obj, "icon");
							_tmp143_ = g_strdup (_tmp142_);
							_g_free0 (_link_icon);
							_link_icon = _tmp143_;
						}
					}
					_json_object_unref0 (_link_obj);
				}
				if (g_strcmp0 (member, "photo") == 0) {
					JsonObject* _tmp144_ = NULL;
					JsonObject* _tmp145_;
					JsonObject* _photo_obj;
					_tmp144_ = json_object_get_object_member (obj, member);
					_tmp145_ = _json_object_ref0 (_tmp144_);
					_photo_obj = _tmp145_;
					if (_photo_obj != NULL) {
						gboolean _tmp146_;
						gboolean _tmp150_;
						gboolean _tmp153_;
						_tmp146_ = json_object_has_member (_photo_obj, "url");
						if (_tmp146_) {
							const gchar* _tmp147_ = NULL;
							gchar* _tmp148_;
							_tmp147_ = json_object_get_string_member (_photo_obj, "url");
							_tmp148_ = g_strdup (_tmp147_);
							_g_free0 (_image_url);
							_image_url = _tmp148_;
							if (_image_url != NULL) {
								gchar* _tmp149_ = NULL;
								_tmp149_ = g_markup_escape_text (_image_url, (gssize) (-1));
								_g_free0 (_image_url);
								_image_url = _tmp149_;
							}
						}
						_tmp150_ = json_object_has_member (_photo_obj, "picture");
						if (_tmp150_) {
							const gchar* _tmp151_ = NULL;
							gchar* _tmp152_;
							_tmp151_ = json_object_get_string_member (_photo_obj, "picture");
							_tmp152_ = g_strdup (_tmp151_);
							_g_free0 (_image_src);
							_image_src = _tmp152_;
						}
						_tmp153_ = json_object_has_member (_photo_obj, "name");
						if (_tmp153_) {
							const gchar* _tmp154_ = NULL;
							gchar* _tmp155_;
							_tmp154_ = json_object_get_string_member (_photo_obj, "name");
							_tmp155_ = g_strdup (_tmp154_);
							_g_free0 (_image_name);
							_image_name = _tmp155_;
						}
					}
					_json_object_unref0 (_photo_obj);
				}
				if (g_strcmp0 (member, "video") == 0) {
					JsonObject* _tmp156_ = NULL;
					JsonObject* _tmp157_;
					JsonObject* _video_obj;
					_tmp156_ = json_object_get_object_member (obj, member);
					_tmp157_ = _json_object_ref0 (_tmp156_);
					_video_obj = _tmp157_;
					if (_video_obj != NULL) {
						gboolean _tmp158_;
						gboolean _tmp161_;
						gboolean _tmp164_;
						gboolean _tmp168_;
						_tmp158_ = json_object_has_member (_video_obj, "name");
						if (_tmp158_) {
							const gchar* _tmp159_ = NULL;
							gchar* _tmp160_;
							_tmp159_ = json_object_get_string_member (_video_obj, "name");
							_tmp160_ = g_strdup (_tmp159_);
							_g_free0 (_video_name);
							_video_name = _tmp160_;
						}
						_tmp161_ = json_object_has_member (_video_obj, "picture");
						if (_tmp161_) {
							const gchar* _tmp162_ = NULL;
							gchar* _tmp163_;
							_tmp162_ = json_object_get_string_member (_video_obj, "picture");
							_tmp163_ = g_strdup (_tmp162_);
							_g_free0 (_video_picture);
							_video_picture = _tmp163_;
						}
						_tmp164_ = json_object_has_member (_video_obj, "url");
						if (_tmp164_) {
							const gchar* _tmp165_ = NULL;
							gchar* _tmp166_;
							_tmp165_ = json_object_get_string_member (_video_obj, "url");
							_tmp166_ = g_strdup (_tmp165_);
							_g_free0 (_video_url);
							_video_url = _tmp166_;
							if (_video_url != NULL) {
								gchar* _tmp167_ = NULL;
								_tmp167_ = g_markup_escape_text (_video_url, (gssize) (-1));
								_g_free0 (_video_url);
								_video_url = _tmp167_;
							}
						}
						_tmp168_ = json_object_has_member (_video_obj, "source");
						if (_tmp168_) {
							const gchar* _tmp169_ = NULL;
							gchar* _tmp170_;
							_tmp169_ = json_object_get_string_member (_video_obj, "source");
							_tmp170_ = g_strdup (_tmp169_);
							_g_free0 (_video_src);
							_video_src = _tmp170_;
						}
					}
					_json_object_unref0 (_video_obj);
				}
				if (g_strcmp0 (member, "images") == 0) {
					JsonArray* _tmp171_ = NULL;
					JsonArray* _tmp172_;
					JsonArray* _images_array;
					_tmp171_ = json_object_get_array_member (obj, member);
					_tmp172_ = _json_array_ref0 (_tmp171_);
					_images_array = _tmp172_;
					if (_images_array != NULL) {
						JsonNode* _tmp173_ = NULL;
						JsonObject* _tmp174_ = NULL;
						JsonObject* _tmp175_;
						JsonObject* _image_obj;
						_tmp173_ = json_array_get_element (_images_array, (guint) 0);
						_tmp174_ = json_node_get_object (_tmp173_);
						_tmp175_ = _json_object_ref0 (_tmp174_);
						_image_obj = _tmp175_;
						if (_image_obj != NULL) {
							gboolean _tmp176_;
							gboolean _tmp180_;
							gboolean _tmp184_;
							gboolean _tmp188_;
							_tmp176_ = json_object_has_member (_image_obj, "url");
							if (_tmp176_) {
								const gchar* _tmp177_ = NULL;
								gchar* _tmp178_;
								_tmp177_ = json_object_get_string_member (_image_obj, "url");
								_tmp178_ = g_strdup (_tmp177_);
								_g_free0 (_image_url);
								_image_url = _tmp178_;
								if (_image_url != NULL) {
									gchar* _tmp179_ = NULL;
									_tmp179_ = g_markup_escape_text (_image_url, (gssize) (-1));
									_g_free0 (_image_url);
									_image_url = _tmp179_;
								}
							}
							_tmp180_ = json_object_has_member (_image_obj, "src");
							if (_tmp180_) {
								const gchar* _tmp181_ = NULL;
								gchar* _tmp182_;
								_tmp181_ = json_object_get_string_member (_image_obj, "src");
								_tmp182_ = g_strdup (_tmp181_);
								_g_free0 (_image_src);
								_image_src = _tmp182_;
								if (_image_src != NULL) {
									gchar* _tmp183_ = NULL;
									_tmp183_ = g_markup_escape_text (_image_src, (gssize) (-1));
									_g_free0 (_image_src);
									_image_src = _tmp183_;
								}
							}
							_tmp184_ = json_object_has_member (_image_obj, "thumb");
							if (_tmp184_) {
								const gchar* _tmp185_ = NULL;
								gchar* _tmp186_;
								_tmp185_ = json_object_get_string_member (_image_obj, "thumb");
								_tmp186_ = g_strdup (_tmp185_);
								_g_free0 (_image_thumb);
								_image_thumb = _tmp186_;
								if (_image_thumb != NULL) {
									gchar* _tmp187_ = NULL;
									_tmp187_ = g_markup_escape_text (_image_thumb, (gssize) (-1));
									_g_free0 (_image_thumb);
									_image_thumb = _tmp187_;
								}
							}
							_tmp188_ = json_object_has_member (_image_obj, "name");
							if (_tmp188_) {
								const gchar* _tmp189_ = NULL;
								gchar* _tmp190_;
								_tmp189_ = json_object_get_string_member (_image_obj, "name");
								_tmp190_ = g_strdup (_tmp189_);
								_g_free0 (_image_name);
								_image_name = _tmp190_;
							}
						}
						_json_object_unref0 (_image_obj);
					}
					_json_array_unref0 (_images_array);
				}
				if (g_strcmp0 (member, "comments") == 0) {
					gsize length = 0UL;
					JsonArray* _tmp191_ = NULL;
					JsonArray* _tmp192_;
					JsonArray* _comments_array;
					JsonGenerator* _tmp193_ = NULL;
					JsonGenerator* comment_gen;
					JsonNode* _tmp194_ = NULL;
					JsonNode* root;
					JsonObject* _tmp195_ = NULL;
					JsonObject* object;
					JsonArray* _tmp196_;
					gsize _tmp197_;
					gchar* _tmp198_ = NULL;
					_tmp191_ = json_object_get_array_member (obj, member);
					_tmp192_ = _json_array_ref0 (_tmp191_);
					_comments_array = _tmp192_;
					_tmp193_ = json_generator_new ();
					comment_gen = _tmp193_;
					_tmp194_ = json_node_new (JSON_NODE_OBJECT);
					root = _tmp194_;
					_tmp195_ = json_object_new ();
					object = _tmp195_;
					json_node_set_object (root, object);
					_tmp196_ = _json_array_ref0 (_comments_array);
					json_object_set_array_member (object, "comments", _tmp196_);
					json_generator_set_root (comment_gen, root);
					_tmp198_ = json_generator_to_data (comment_gen, &_tmp197_);
					length = _tmp197_;
					_g_free0 (_comments);
					_comments = _tmp198_;
					_json_object_unref0 (object);
					_json_node_free0 (root);
					_g_object_unref0 (comment_gen);
					_json_array_unref0 (_comments_array);
				}
				_g_free0 (member);
			}
		}
	}
	_tmp199_ = string_replace (_html, "&query", "&amp;query");
	_g_free0 (_html);
	_html = _tmp199_;
	_tmp200_ = string_replace (_html, "&name", "&amp;name");
	_g_free0 (_html);
	_html = _tmp200_;
	_tmp201_ = string_replace (_html, "class=\"nick\"", "");
	_g_free0 (_html);
	_html = _tmp201_;
	_tmp202_ = string_replace (_html, "class=\"hash\"", "");
	_g_free0 (_html);
	_html = _tmp202_;
	_tmp203_ = gwibber_utils_generate_time_string (self->priv->utils, _time);
	_t = _tmp203_;
	_tmp205_ = gee_abstract_map_has_key ((GeeAbstractMap*) self->priv->seen, _textid);
	if (_tmp205_) {
		_tmp204_ = g_strcmp0 (transient, "0") == 0;
	} else {
		_tmp204_ = FALSE;
	}
	if (_tmp204_) {
		gpointer _tmp206_ = NULL;
		GVariant* _tmp207_ = NULL;
		gint _tmp208_;
		gchar** _accounts_array;
		gint _accounts_array_length1;
		gint __accounts_array_size_;
		_tmp206_ = gee_abstract_map_get ((GeeAbstractMap*) self->priv->seen, _textid);
		iter = (DeeModelIter*) _tmp206_;
		if (iter == NULL) {
			_g_free0 (_t);
			_g_free0 (_textid);
			_g_free0 (_sender_nick);
			_g_free0 (_sender);
			_json_object_unref0 (_sender_obj);
			_g_variant_builder_unref0 (builder);
			_g_free0 (_acct);
			_g_object_unref0 (_model);
			_g_list_free0 (members);
			_g_free0 (transient);
			_g_free0 (_comments);
			_g_free0 (_url);
			_g_free0 (_icon);
			_g_free0 (_text);
			_g_free0 (_html);
			_g_free0 (_video_name);
			_g_free0 (_video_url);
			_g_free0 (_video_src);
			_g_free0 (_video_picture);
			_g_free0 (_image_name);
			_g_free0 (_image_thumb);
			_g_free0 (_image_src);
			_g_free0 (_image_url);
			_g_free0 (_link_icon);
			_g_free0 (_link_caption);
			_g_free0 (_link_description);
			_g_free0 (_link_url);
			_g_free0 (_link_name);
			_g_free0 (_link_picture);
			_g_free0 (_retweeted_by_id);
			_g_free0 (_retweeted_by_name);
			_g_free0 (_retweeted_by_nick);
			_g_free0 (_reply_url);
			_g_free0 (_reply_name);
			_g_free0 (_reply_nick);
			_g_free0 (_source);
			_g_free0 (_mid);
			_g_free0 (_operation);
			_g_free0 (_service);
			_g_free0 (_stream);
			_g_free0 (_account);
			return;
		}
		_tmp207_ = dee_model_get_value (_model, iter, (guint) GWIBBER_STREAM_MODEL_COLUMN_ACCOUNTS);
		_accounts_array = _variant_get1 (_tmp207_, &_tmp208_);
		_accounts_array_length1 = _tmp208_;
		__accounts_array_size_ = _tmp208_;
		if (!_vala_string_array_contains (_accounts_array, _accounts_array_length1, _acct)) {
			GVariant* _tmp213_ = NULL;
			GVariant* _accounts;
			{
				gchar** a_collection;
				int a_collection_length1;
				int a_it;
				a_collection = _accounts_array;
				a_collection_length1 = _accounts_array_length1;
				for (a_it = 0; a_it < _accounts_array_length1; a_it = a_it + 1) {
					gchar* _tmp212_;
					gchar* a;
					_tmp212_ = g_strdup (a_collection[a_it]);
					a = _tmp212_;
					{
						g_variant_builder_add (builder, "s", a, NULL);
						_g_free0 (a);
					}
				}
			}
			_tmp213_ = g_variant_new ("as", builder, NULL);
			_accounts = g_variant_ref_sink (_tmp213_);
			dee_model_set_value (_model, iter, (guint) GWIBBER_STREAM_MODEL_COLUMN_ACCOUNTS, _accounts);
			_g_variant_unref0 (_accounts);
		}
		dee_model_set_value (_model, iter, (guint) GWIBBER_STREAM_MODEL_COLUMN_MESSAGE, _variant_new2 (_text));
		dee_model_set_value (_model, iter, (guint) GWIBBER_STREAM_MODEL_COLUMN_HTML, _variant_new3 (_html));
		dee_model_set_value (_model, iter, (guint) GWIBBER_STREAM_MODEL_COLUMN_TIMESTRING, _variant_new4 (_t));
		dee_model_set_value (_model, iter, (guint) GWIBBER_STREAM_MODEL_COLUMN_LIKES, _variant_new5 (_likes));
		iter = NULL;
		_accounts_array = (_vala_array_free (_accounts_array, _accounts_array_length1, (GDestroyNotify) g_free), NULL);
		goto __finally42;
		__catch42_g_error:
		{
			g_clear_error (&_inner_error_);
			_inner_error_ = NULL;
			g_debug ("streams.vala:638: Failed to update record for mid: %s", _mid);
		}
		__finally42:
		if (_inner_error_ != NULL) {
			_g_free0 (_t);
			_g_free0 (_textid);
			_g_free0 (_sender_nick);
			_g_free0 (_sender);
			_json_object_unref0 (_sender_obj);
			_g_variant_builder_unref0 (builder);
			_g_free0 (_acct);
			_g_object_unref0 (_model);
			_g_list_free0 (members);
			_g_free0 (transient);
			_g_free0 (_comments);
			_g_free0 (_url);
			_g_free0 (_icon);
			_g_free0 (_text);
			_g_free0 (_html);
			_g_free0 (_video_name);
			_g_free0 (_video_url);
			_g_free0 (_video_src);
			_g_free0 (_video_picture);
			_g_free0 (_image_name);
			_g_free0 (_image_thumb);
			_g_free0 (_image_src);
			_g_free0 (_image_url);
			_g_free0 (_link_icon);
			_g_free0 (_link_caption);
			_g_free0 (_link_description);
			_g_free0 (_link_url);
			_g_free0 (_link_name);
			_g_free0 (_link_picture);
			_g_free0 (_retweeted_by_id);
			_g_free0 (_retweeted_by_name);
			_g_free0 (_retweeted_by_nick);
			_g_free0 (_reply_url);
			_g_free0 (_reply_name);
			_g_free0 (_reply_nick);
			_g_free0 (_source);
			_g_free0 (_mid);
			_g_free0 (_operation);
			_g_free0 (_service);
			_g_free0 (_stream);
			_g_free0 (_account);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_g_free0 (_t);
		_g_free0 (_textid);
		_g_free0 (_sender_nick);
		_g_free0 (_sender);
		_json_object_unref0 (_sender_obj);
		_g_variant_builder_unref0 (builder);
		_g_free0 (_acct);
		_g_object_unref0 (_model);
		_g_list_free0 (members);
		_g_free0 (transient);
		_g_free0 (_comments);
		_g_free0 (_url);
		_g_free0 (_icon);
		_g_free0 (_text);
		_g_free0 (_html);
		_g_free0 (_video_name);
		_g_free0 (_video_url);
		_g_free0 (_video_src);
		_g_free0 (_video_picture);
		_g_free0 (_image_name);
		_g_free0 (_image_thumb);
		_g_free0 (_image_src);
		_g_free0 (_image_url);
		_g_free0 (_link_icon);
		_g_free0 (_link_caption);
		_g_free0 (_link_description);
		_g_free0 (_link_url);
		_g_free0 (_link_name);
		_g_free0 (_link_picture);
		_g_free0 (_retweeted_by_id);
		_g_free0 (_retweeted_by_name);
		_g_free0 (_retweeted_by_nick);
		_g_free0 (_reply_url);
		_g_free0 (_reply_name);
		_g_free0 (_reply_nick);
		_g_free0 (_source);
		_g_free0 (_mid);
		_g_free0 (_operation);
		_g_free0 (_service);
		_g_free0 (_stream);
		_g_free0 (_account);
		return;
	}
	_tmp214_ = g_variant_new ("as", builder, NULL);
	_accounts = g_variant_ref_sink (_tmp214_);
	_tmp215_ = g_strdup_printf ("%u", _time);
	_tmp216_ = _tmp215_;
	_tmp217_ = dee_model_append (_model, _accounts, _stream, transient, _sender, _sender_nick, _from_me, _tmp216_, _text, _html, _icon, _url, _source, _t, _reply_nick, _reply_name, _reply_url, _likes, _retweeted_by_nick, _retweeted_by_name, _retweeted_by_id, _link_picture, _link_name, _link_url, _link_description, _link_caption, _link_icon, _image_url, _image_src, _image_thumb, _image_name, _video_picture, _video_src, _video_url, _video_name, _comments, NULL);
	iter = _tmp217_;
	_g_free0 (_tmp216_);
	goto __finally43;
	__catch43_g_error:
	{
		g_clear_error (&_inner_error_);
		_inner_error_ = NULL;
		iter = NULL;
	}
	__finally43:
	if (_inner_error_ != NULL) {
		_g_variant_unref0 (_accounts);
		_g_free0 (_t);
		_g_free0 (_textid);
		_g_free0 (_sender_nick);
		_g_free0 (_sender);
		_json_object_unref0 (_sender_obj);
		_g_variant_builder_unref0 (builder);
		_g_free0 (_acct);
		_g_object_unref0 (_model);
		_g_list_free0 (members);
		_g_free0 (transient);
		_g_free0 (_comments);
		_g_free0 (_url);
		_g_free0 (_icon);
		_g_free0 (_text);
		_g_free0 (_html);
		_g_free0 (_video_name);
		_g_free0 (_video_url);
		_g_free0 (_video_src);
		_g_free0 (_video_picture);
		_g_free0 (_image_name);
		_g_free0 (_image_thumb);
		_g_free0 (_image_src);
		_g_free0 (_image_url);
		_g_free0 (_link_icon);
		_g_free0 (_link_caption);
		_g_free0 (_link_description);
		_g_free0 (_link_url);
		_g_free0 (_link_name);
		_g_free0 (_link_picture);
		_g_free0 (_retweeted_by_id);
		_g_free0 (_retweeted_by_name);
		_g_free0 (_retweeted_by_nick);
		_g_free0 (_reply_url);
		_g_free0 (_reply_name);
		_g_free0 (_reply_nick);
		_g_free0 (_source);
		_g_free0 (_mid);
		_g_free0 (_operation);
		_g_free0 (_service);
		_g_free0 (_stream);
		_g_free0 (_account);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp219_ = strlen (_textid);
	if (_tmp219_ > 1) {
		_tmp218_ = iter != NULL;
	} else {
		_tmp218_ = FALSE;
	}
	if (_tmp218_) {
		gee_abstract_map_set ((GeeAbstractMap*) self->priv->seen, _textid, iter);
	}
	iter = NULL;
	_g_variant_unref0 (_accounts);
	_g_free0 (_t);
	_g_free0 (_textid);
	_g_free0 (_sender_nick);
	_g_free0 (_sender);
	_json_object_unref0 (_sender_obj);
	_g_variant_builder_unref0 (builder);
	_g_free0 (_acct);
	_g_object_unref0 (_model);
	_g_list_free0 (members);
	_g_free0 (transient);
	_g_free0 (_comments);
	_g_free0 (_url);
	_g_free0 (_icon);
	_g_free0 (_text);
	_g_free0 (_html);
	_g_free0 (_video_name);
	_g_free0 (_video_url);
	_g_free0 (_video_src);
	_g_free0 (_video_picture);
	_g_free0 (_image_name);
	_g_free0 (_image_thumb);
	_g_free0 (_image_src);
	_g_free0 (_image_url);
	_g_free0 (_link_icon);
	_g_free0 (_link_caption);
	_g_free0 (_link_description);
	_g_free0 (_link_url);
	_g_free0 (_link_name);
	_g_free0 (_link_picture);
	_g_free0 (_retweeted_by_id);
	_g_free0 (_retweeted_by_name);
	_g_free0 (_retweeted_by_nick);
	_g_free0 (_reply_url);
	_g_free0 (_reply_name);
	_g_free0 (_reply_nick);
	_g_free0 (_source);
	_g_free0 (_mid);
	_g_free0 (_operation);
	_g_free0 (_service);
	_g_free0 (_stream);
	_g_free0 (_account);
}


/**
         * com.Gwibber.Streams
         **/
GeeHashMap* gwibber_streams_lookup (GwibberStreams* self, const gchar* id) {
	GeeHashMap* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _result_;
	JsonParser* _tmp1_ = NULL;
	JsonParser* parser;
	JsonNode* _tmp2_ = NULL;
	JsonObject* _tmp3_ = NULL;
	JsonObject* _tmp4_;
	JsonObject* obj;
	GList* _tmp5_ = NULL;
	GList* members;
	GeeHashMap* _tmp6_ = NULL;
	GeeHashMap* stream_map;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (id != NULL, NULL);
	_tmp0_ = streams_interface_Get (self->priv->streams_service, id, &_inner_error_);
	_result_ = _tmp0_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_IO_ERROR) {
			goto __catch44_g_io_error;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp1_ = json_parser_new ();
	parser = _tmp1_;
	json_parser_load_from_data (parser, _result_, (gssize) (-1), &_inner_error_);
	if (_inner_error_ != NULL) {
		_g_object_unref0 (parser);
		_g_free0 (_result_);
		if (_inner_error_->domain == G_IO_ERROR) {
			goto __catch44_g_io_error;
		}
		goto __finally44;
	}
	_tmp2_ = json_parser_get_root (parser);
	_tmp3_ = json_node_get_object (_tmp2_);
	_tmp4_ = _json_object_ref0 (_tmp3_);
	obj = _tmp4_;
	_tmp5_ = json_object_get_members (obj);
	members = _tmp5_;
	_tmp6_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL);
	stream_map = _tmp6_;
	{
		GList* member_collection;
		GList* member_it;
		member_collection = members;
		for (member_it = member_collection; member_it != NULL; member_it = member_it->next) {
			gchar* _tmp7_;
			gchar* member;
			_tmp7_ = g_strdup ((const gchar*) member_it->data);
			member = _tmp7_;
			{
				const gchar* _tmp8_ = NULL;
				_tmp8_ = json_object_get_string_member (obj, member);
				gee_abstract_map_set ((GeeAbstractMap*) stream_map, member, _tmp8_);
				_g_free0 (member);
			}
		}
	}
	result = stream_map;
	_g_list_free0 (members);
	_json_object_unref0 (obj);
	_g_object_unref0 (parser);
	_g_free0 (_result_);
	return result;
	_g_object_unref0 (stream_map);
	_g_list_free0 (members);
	_json_object_unref0 (obj);
	_g_object_unref0 (parser);
	_g_free0 (_result_);
	goto __finally44;
	__catch44_g_io_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("streams.vala:715: %s", e->message);
		result = NULL;
		_g_error_free0 (e);
		return result;
	}
	__finally44:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
	g_clear_error (&_inner_error_);
	return NULL;
}


/**
         * com.Gwibber.Streams
         **/
void gwibber_streams_delete (GwibberStreams* self, const gchar* id) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (id != NULL);
	streams_interface_Delete (self->priv->streams_service, id, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_IO_ERROR) {
			goto __catch45_g_io_error;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	goto __finally45;
	__catch45_g_io_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("streams.vala:733: %s", e->message);
		_g_error_free0 (e);
	}
	__finally45:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	return;
}


/**
         * com.Gwibber.Streams
         **/
gchar* gwibber_streams_create (GwibberStreams* self, const gchar* account, const gchar* name, const gchar* operation) {
	gchar* result = NULL;
	gchar* _tmp0_;
	gchar* parameters;
	GList* _tmp1_ = NULL;
	GList* streams_list;
	gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	gchar* _tmp27_;
	gchar* _tmp28_;
	gchar* _tmp29_;
	gchar* _tmp30_;
	gchar* _tmp31_;
	gchar* _tmp32_;
	gchar* _tmp33_;
	gchar* _tmp34_ = NULL;
	gchar* _tmp35_;
	gchar* _tmp36_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (account != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (operation != NULL, NULL);
	_tmp0_ = g_strdup ("");
	parameters = _tmp0_;
	_tmp1_ = gwibber_streams_list (self);
	streams_list = _tmp1_;
	{
		GList* s_collection;
		GList* s_it;
		s_collection = streams_list;
		for (s_it = s_collection; s_it != NULL; s_it = s_it->next) {
			GeeHashMap* _tmp2_;
			GeeHashMap* s;
			_tmp2_ = _g_object_ref0 ((GeeHashMap*) s_it->data);
			s = _tmp2_;
			{
				gboolean _tmp3_ = FALSE;
				gboolean _tmp4_ = FALSE;
				gpointer _tmp5_ = NULL;
				gchar* _tmp6_;
				gboolean _tmp7_;
				_tmp5_ = gee_abstract_map_get ((GeeAbstractMap*) s, "name");
				_tmp6_ = (gchar*) _tmp5_;
				_tmp7_ = g_strcmp0 (_tmp6_, name) == 0;
				_g_free0 (_tmp6_);
				if (_tmp7_) {
					gpointer _tmp8_ = NULL;
					gchar* _tmp9_;
					_tmp8_ = gee_abstract_map_get ((GeeAbstractMap*) s, "operation");
					_tmp9_ = (gchar*) _tmp8_;
					_tmp4_ = g_strcmp0 (_tmp9_, operation) == 0;
					_g_free0 (_tmp9_);
				} else {
					_tmp4_ = FALSE;
				}
				if (_tmp4_) {
					gpointer _tmp10_ = NULL;
					gchar* _tmp11_;
					_tmp10_ = gee_abstract_map_get ((GeeAbstractMap*) s, "account");
					_tmp11_ = (gchar*) _tmp10_;
					_tmp3_ = g_strcmp0 (_tmp11_, account) == 0;
					_g_free0 (_tmp11_);
				} else {
					_tmp3_ = FALSE;
				}
				if (_tmp3_) {
					gpointer _tmp12_ = NULL;
					gchar* _tmp13_;
					gpointer _tmp14_ = NULL;
					g_debug ("streams.vala:752: user stream exists, updating");
					_tmp12_ = gee_abstract_map_get ((GeeAbstractMap*) s, "id");
					_tmp13_ = (gchar*) _tmp12_;
					g_signal_emit_by_name (self, "updated", _tmp13_);
					_g_free0 (_tmp13_);
					_tmp14_ = gee_abstract_map_get ((GeeAbstractMap*) s, "id");
					result = (gchar*) _tmp14_;
					_g_object_unref0 (s);
					__g_list_free__g_object_unref0_0 (streams_list);
					_g_free0 (parameters);
					return result;
				}
				_g_object_unref0 (s);
			}
		}
	}
	if (g_strcmp0 (operation, "user_messages") == 0) {
		gchar* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		_tmp15_ = g_strconcat ("{\"count\": 50, \"id\": \"", name, NULL);
		_tmp16_ = _tmp15_;
		_tmp17_ = g_strconcat (_tmp16_, "\"}", NULL);
		_g_free0 (parameters);
		parameters = _tmp17_;
		_g_free0 (_tmp16_);
	}
	_tmp18_ = g_strconcat ("{\"account\": \"", account, NULL);
	_tmp19_ = _tmp18_;
	_tmp20_ = g_strconcat (_tmp19_, "\", \"parameters\": ", NULL);
	_tmp21_ = _tmp20_;
	_tmp22_ = g_strconcat (_tmp21_, parameters, NULL);
	_tmp23_ = _tmp22_;
	_tmp24_ = g_strconcat (_tmp23_, ", \"name\": \"", NULL);
	_tmp25_ = _tmp24_;
	_tmp26_ = g_strconcat (_tmp25_, name, NULL);
	_tmp27_ = _tmp26_;
	_tmp28_ = g_strconcat (_tmp27_, "\", \"operation\": \"", NULL);
	_tmp29_ = _tmp28_;
	_tmp30_ = g_strconcat (_tmp29_, operation, NULL);
	_tmp31_ = _tmp30_;
	_tmp32_ = g_strconcat (_tmp31_, "\"}", NULL);
	_tmp33_ = _tmp32_;
	_tmp34_ = streams_interface_Create (self->priv->streams_service, _tmp33_, &_inner_error_);
	_tmp35_ = _tmp34_;
	_g_free0 (_tmp33_);
	_g_free0 (_tmp31_);
	_g_free0 (_tmp29_);
	_g_free0 (_tmp27_);
	_g_free0 (_tmp25_);
	_g_free0 (_tmp23_);
	_g_free0 (_tmp21_);
	_g_free0 (_tmp19_);
	_tmp36_ = _tmp35_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_IO_ERROR) {
			goto __catch46_g_io_error;
		}
		__g_list_free__g_object_unref0_0 (streams_list);
		_g_free0 (parameters);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	result = _tmp36_;
	__g_list_free__g_object_unref0_0 (streams_list);
	_g_free0 (parameters);
	return result;
	goto __finally46;
	__catch46_g_io_error:
	{
		GError * e;
		gchar* _tmp37_;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("streams.vala:767: %s", e->message);
		_tmp37_ = g_strdup ("");
		result = _tmp37_;
		_g_error_free0 (e);
		__g_list_free__g_object_unref0_0 (streams_list);
		_g_free0 (parameters);
		return result;
	}
	__finally46:
	__g_list_free__g_object_unref0_0 (streams_list);
	_g_free0 (parameters);
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
	g_clear_error (&_inner_error_);
	return NULL;
}


/**
         * com.Gwibber.Streams
         **/
GList* gwibber_streams_list (GwibberStreams* self) {
	GList* result = NULL;
	GList* streams_list;
	gchar* _tmp0_ = NULL;
	gchar* _result_;
	JsonParser* _tmp1_ = NULL;
	JsonParser* parser;
	JsonNode* _tmp2_ = NULL;
	JsonArray* _tmp3_ = NULL;
	JsonArray* _tmp4_;
	JsonArray* nodeArray;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	streams_list = NULL;
	_tmp0_ = streams_interface_List (self->priv->streams_service, &_inner_error_);
	_result_ = _tmp0_;
	if (_inner_error_ != NULL) {
		__g_list_free__g_object_unref0_0 (streams_list);
		if (_inner_error_->domain == G_IO_ERROR) {
			goto __catch47_g_io_error;
		}
		__g_list_free__g_object_unref0_0 (streams_list);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp1_ = json_parser_new ();
	parser = _tmp1_;
	json_parser_load_from_data (parser, _result_, (gssize) (-1), &_inner_error_);
	if (_inner_error_ != NULL) {
		_g_object_unref0 (parser);
		_g_free0 (_result_);
		__g_list_free__g_object_unref0_0 (streams_list);
		if (_inner_error_->domain == G_IO_ERROR) {
			goto __catch47_g_io_error;
		}
		goto __finally47;
	}
	_tmp2_ = json_parser_get_root (parser);
	_tmp3_ = json_node_get_array (_tmp2_);
	_tmp4_ = _json_array_ref0 (_tmp3_);
	nodeArray = _tmp4_;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp5_;
			_tmp5_ = TRUE;
			while (TRUE) {
				guint _tmp6_;
				GeeHashMap* _tmp7_ = NULL;
				GeeHashMap* stream_map;
				JsonNode* _tmp8_ = NULL;
				JsonObject* _tmp9_ = NULL;
				JsonObject* _tmp10_;
				JsonObject* obj;
				GeeHashMap* _tmp14_;
				if (!_tmp5_) {
					i++;
				}
				_tmp5_ = FALSE;
				_tmp6_ = json_array_get_length (nodeArray);
				if (!(i < _tmp6_)) {
					break;
				}
				_tmp7_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL);
				stream_map = _tmp7_;
				_tmp8_ = json_array_get_element (nodeArray, (guint) i);
				_tmp9_ = json_node_get_object (_tmp8_);
				_tmp10_ = _json_object_ref0 (_tmp9_);
				obj = _tmp10_;
				if (obj != NULL) {
					GList* _tmp11_ = NULL;
					GList* members;
					_tmp11_ = json_object_get_members (obj);
					members = _tmp11_;
					{
						GList* member_collection;
						GList* member_it;
						member_collection = members;
						for (member_it = member_collection; member_it != NULL; member_it = member_it->next) {
							gchar* _tmp12_;
							gchar* member;
							_tmp12_ = g_strdup ((const gchar*) member_it->data);
							member = _tmp12_;
							{
								if (g_strcmp0 (member, "parameters") != 0) {
									const gchar* _tmp13_ = NULL;
									_tmp13_ = json_object_get_string_member (obj, member);
									gee_abstract_map_set ((GeeAbstractMap*) stream_map, member, _tmp13_);
								}
								_g_free0 (member);
							}
						}
					}
					_g_list_free0 (members);
				}
				_tmp14_ = _g_object_ref0 (stream_map);
				streams_list = g_list_append (streams_list, _tmp14_);
				_json_object_unref0 (obj);
				_g_object_unref0 (stream_map);
			}
		}
	}
	result = streams_list;
	_json_array_unref0 (nodeArray);
	_g_object_unref0 (parser);
	_g_free0 (_result_);
	return result;
	_json_array_unref0 (nodeArray);
	_g_object_unref0 (parser);
	_g_free0 (_result_);
	__g_list_free__g_object_unref0_0 (streams_list);
	goto __finally47;
	__catch47_g_io_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("streams.vala:803: %s", e->message);
		result = NULL;
		_g_error_free0 (e);
		return result;
	}
	__finally47:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
	g_clear_error (&_inner_error_);
	return NULL;
}


void gwibber_streams_stream_deleted (GwibberStreams* self, const gchar* data) {
	JsonParser* _tmp0_ = NULL;
	JsonParser* parser;
	JsonNode* _tmp1_ = NULL;
	JsonObject* _tmp2_ = NULL;
	JsonObject* _tmp3_;
	JsonObject* root_object;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	gchar* id;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (data != NULL);
	_tmp0_ = json_parser_new ();
	parser = _tmp0_;
	json_parser_load_from_data (parser, data, (gssize) (-1), &_inner_error_);
	if (_inner_error_ != NULL) {
		_g_object_unref0 (parser);
		goto __catch48_g_error;
	}
	_tmp1_ = json_parser_get_root (parser);
	_tmp2_ = json_node_get_object (_tmp1_);
	_tmp3_ = _json_object_ref0 (_tmp2_);
	root_object = _tmp3_;
	_tmp4_ = json_object_get_string_member (root_object, "id");
	_tmp5_ = g_strdup (_tmp4_);
	id = _tmp5_;
	g_signal_emit_by_name (self, "deleted", id);
	_g_free0 (id);
	_json_object_unref0 (root_object);
	_g_object_unref0 (parser);
	goto __finally48;
	__catch48_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("streams.vala:818: %s", e->message);
		_g_error_free0 (e);
	}
	__finally48:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


void gwibber_streams_stream_created (GwibberStreams* self, const gchar* data) {
	JsonParser* _tmp0_ = NULL;
	JsonParser* parser;
	JsonNode* _tmp1_ = NULL;
	JsonObject* _tmp2_ = NULL;
	JsonObject* _tmp3_;
	JsonObject* root_object;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	gchar* id;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (data != NULL);
	_tmp0_ = json_parser_new ();
	parser = _tmp0_;
	json_parser_load_from_data (parser, data, (gssize) (-1), &_inner_error_);
	if (_inner_error_ != NULL) {
		_g_object_unref0 (parser);
		goto __catch49_g_error;
	}
	_tmp1_ = json_parser_get_root (parser);
	_tmp2_ = json_node_get_object (_tmp1_);
	_tmp3_ = _json_object_ref0 (_tmp2_);
	root_object = _tmp3_;
	_tmp4_ = json_object_get_string_member (root_object, "id");
	_tmp5_ = g_strdup (_tmp4_);
	id = _tmp5_;
	g_signal_emit_by_name (self, "created", id);
	_g_free0 (id);
	_json_object_unref0 (root_object);
	_g_object_unref0 (parser);
	goto __finally49;
	__catch49_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("streams.vala:831: %s", e->message);
		_g_error_free0 (e);
	}
	__finally49:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


void gwibber_streams_stream_updated (GwibberStreams* self, const gchar* data) {
	JsonParser* _tmp0_ = NULL;
	JsonParser* parser;
	JsonNode* _tmp1_ = NULL;
	JsonObject* _tmp2_ = NULL;
	JsonObject* _tmp3_;
	JsonObject* root_object;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	gchar* id;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (data != NULL);
	g_debug ("streams.vala:837: stream_updated");
	_tmp0_ = json_parser_new ();
	parser = _tmp0_;
	json_parser_load_from_data (parser, data, (gssize) (-1), &_inner_error_);
	if (_inner_error_ != NULL) {
		_g_object_unref0 (parser);
		goto __catch50_g_error;
	}
	_tmp1_ = json_parser_get_root (parser);
	_tmp2_ = json_node_get_object (_tmp1_);
	_tmp3_ = _json_object_ref0 (_tmp2_);
	root_object = _tmp3_;
	_tmp4_ = json_object_get_string_member (root_object, "id");
	_tmp5_ = g_strdup (_tmp4_);
	id = _tmp5_;
	g_signal_emit_by_name (self, "updated", id);
	_g_free0 (id);
	_json_object_unref0 (root_object);
	_g_object_unref0 (parser);
	goto __finally50;
	__catch50_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("streams.vala:845: %s", e->message);
		_g_error_free0 (e);
	}
	__finally50:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static GValue* _g_value_dup (GValue* self) {
	return g_boxed_copy (G_TYPE_VALUE, self);
}


static void _vala_GValue_free (GValue* self) {
	g_value_unset (self);
	g_free (self);
}


GeeHashMap* gwibber_streams_user_profile (GwibberStreams* self, const gchar* id) {
	GeeHashMap* result = NULL;
	GeeHashMap* _tmp0_ = NULL;
	GeeHashMap* profile;
	gchar* _tmp1_;
	gchar* name;
	gchar* _tmp2_;
	gchar* nick;
	gchar* _tmp3_;
	gchar* account;
	gchar* _tmp4_;
	gchar* service;
	gchar* _tmp5_;
	gchar* description;
	gchar* _tmp6_;
	gchar* image;
	gchar* _tmp7_;
	gchar* url;
	gint followers;
	gint friends;
	gint statuses;
	gboolean following;
	gboolean protected;
	gchar* _tmp8_ = NULL;
	gchar* _result_;
	JsonParser* _tmp9_ = NULL;
	JsonParser* parser;
	JsonNode* _tmp10_ = NULL;
	JsonArray* _tmp11_ = NULL;
	JsonArray* _tmp12_;
	JsonArray* nodeArray;
	JsonNode* _tmp13_ = NULL;
	JsonObject* _tmp14_ = NULL;
	JsonObject* _tmp15_;
	JsonObject* obj;
	const gchar* _tmp16_ = NULL;
	gchar* _tmp17_;
	const gchar* _tmp18_ = NULL;
	gchar* _tmp19_;
	const gchar* _tmp20_ = NULL;
	gchar* _tmp21_;
	const gchar* _tmp22_ = NULL;
	gchar* _tmp23_;
	gboolean _tmp24_;
	const gchar* _tmp27_ = NULL;
	gchar* _tmp28_;
	gboolean _tmp29_;
	gint64 _tmp32_;
	gint64 _tmp33_;
	gint64 _tmp34_;
	gboolean _tmp35_;
	gboolean _tmp36_;
	GValue* _tmp37_ = NULL;
	GValue* _tmp38_ = NULL;
	GValue* _tmp39_ = NULL;
	GValue* _tmp40_ = NULL;
	GValue* _tmp41_ = NULL;
	GValue* _tmp42_ = NULL;
	GValue* _tmp43_ = NULL;
	GValue* _tmp44_ = NULL;
	GValue* _tmp45_ = NULL;
	GValue* _tmp46_ = NULL;
	GValue* _tmp47_ = NULL;
	GValue* _tmp48_ = NULL;
	GValue* _tmp49_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (id != NULL, NULL);
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_VALUE, (GBoxedCopyFunc) _g_value_dup, _vala_GValue_free, NULL, NULL, NULL);
	profile = _tmp0_;
	_tmp1_ = g_strdup ("");
	name = _tmp1_;
	_tmp2_ = g_strdup ("");
	nick = _tmp2_;
	_tmp3_ = g_strdup ("");
	account = _tmp3_;
	_tmp4_ = g_strdup ("");
	service = _tmp4_;
	_tmp5_ = g_strdup ("");
	description = _tmp5_;
	_tmp6_ = g_strdup ("");
	image = _tmp6_;
	_tmp7_ = g_strdup ("");
	url = _tmp7_;
	followers = 0;
	friends = 0;
	statuses = 0;
	following = FALSE;
	protected = FALSE;
	_tmp8_ = streams_interface_Messages (self->priv->streams_service, "profile", "all", 0, id, "0", "time", "DESC", 1, &_inner_error_);
	_result_ = _tmp8_;
	if (_inner_error_ != NULL) {
		_g_free0 (url);
		_g_free0 (image);
		_g_free0 (description);
		_g_free0 (service);
		_g_free0 (account);
		_g_free0 (nick);
		_g_free0 (name);
		_g_object_unref0 (profile);
		if (_inner_error_->domain == G_IO_ERROR) {
			goto __catch51_g_io_error;
		}
		_g_free0 (url);
		_g_free0 (image);
		_g_free0 (description);
		_g_free0 (service);
		_g_free0 (account);
		_g_free0 (nick);
		_g_free0 (name);
		_g_object_unref0 (profile);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp9_ = json_parser_new ();
	parser = _tmp9_;
	json_parser_load_from_data (parser, _result_, (gssize) (-1), &_inner_error_);
	if (_inner_error_ != NULL) {
		_g_object_unref0 (parser);
		_g_free0 (_result_);
		_g_free0 (url);
		_g_free0 (image);
		_g_free0 (description);
		_g_free0 (service);
		_g_free0 (account);
		_g_free0 (nick);
		_g_free0 (name);
		_g_object_unref0 (profile);
		if (_inner_error_->domain == G_IO_ERROR) {
			goto __catch51_g_io_error;
		}
		goto __finally51;
	}
	_tmp10_ = json_parser_get_root (parser);
	_tmp11_ = json_node_get_array (_tmp10_);
	_tmp12_ = _json_array_ref0 (_tmp11_);
	nodeArray = _tmp12_;
	_tmp13_ = json_array_get_element (nodeArray, (guint) 0);
	_tmp14_ = json_node_get_object (_tmp13_);
	_tmp15_ = _json_object_ref0 (_tmp14_);
	obj = _tmp15_;
	_tmp16_ = json_object_get_string_member (obj, "name");
	_tmp17_ = g_strdup (_tmp16_);
	_g_free0 (name);
	name = _tmp17_;
	_tmp18_ = json_object_get_string_member (obj, "nick");
	_tmp19_ = g_strdup (_tmp18_);
	_g_free0 (nick);
	nick = _tmp19_;
	_tmp20_ = json_object_get_string_member (obj, "account");
	_tmp21_ = g_strdup (_tmp20_);
	_g_free0 (account);
	account = _tmp21_;
	_tmp22_ = json_object_get_string_member (obj, "service");
	_tmp23_ = g_strdup (_tmp22_);
	_g_free0 (service);
	service = _tmp23_;
	_tmp24_ = json_object_has_member (obj, "text");
	if (_tmp24_) {
		const gchar* _tmp25_ = NULL;
		gchar* _tmp26_;
		_tmp25_ = json_object_get_string_member (obj, "text");
		_tmp26_ = g_strdup (_tmp25_);
		_g_free0 (description);
		description = _tmp26_;
	}
	_tmp27_ = json_object_get_string_member (obj, "image");
	_tmp28_ = g_strdup (_tmp27_);
	_g_free0 (image);
	image = _tmp28_;
	_tmp29_ = json_object_has_member (obj, "url");
	if (_tmp29_) {
		const gchar* _tmp30_ = NULL;
		gchar* _tmp31_;
		_tmp30_ = json_object_get_string_member (obj, "url");
		_tmp31_ = g_strdup (_tmp30_);
		_g_free0 (url);
		url = _tmp31_;
	}
	_tmp32_ = json_object_get_int_member (obj, "followers");
	followers = (gint) _tmp32_;
	_tmp33_ = json_object_get_int_member (obj, "friends");
	friends = (gint) _tmp33_;
	_tmp34_ = json_object_get_int_member (obj, "statuses");
	statuses = (gint) _tmp34_;
	_tmp35_ = json_object_get_boolean_member (obj, "following");
	following = _tmp35_;
	_tmp36_ = json_object_get_boolean_member (obj, "protected");
	protected = _tmp36_;
	_tmp37_ = g_new0 (GValue, 1);
	g_value_init (_tmp37_, G_TYPE_STRING);
	g_value_set_string (_tmp37_, name);
	gee_abstract_map_set ((GeeAbstractMap*) profile, "name", _tmp37_);
	__vala_GValue_free0 (_tmp37_);
	_tmp38_ = g_new0 (GValue, 1);
	g_value_init (_tmp38_, G_TYPE_STRING);
	g_value_set_string (_tmp38_, nick);
	gee_abstract_map_set ((GeeAbstractMap*) profile, "nick", _tmp38_);
	__vala_GValue_free0 (_tmp38_);
	_tmp39_ = g_new0 (GValue, 1);
	g_value_init (_tmp39_, G_TYPE_STRING);
	g_value_set_string (_tmp39_, account);
	gee_abstract_map_set ((GeeAbstractMap*) profile, "account", _tmp39_);
	__vala_GValue_free0 (_tmp39_);
	_tmp40_ = g_new0 (GValue, 1);
	g_value_init (_tmp40_, G_TYPE_STRING);
	g_value_set_string (_tmp40_, service);
	gee_abstract_map_set ((GeeAbstractMap*) profile, "service", _tmp40_);
	__vala_GValue_free0 (_tmp40_);
	_tmp41_ = g_new0 (GValue, 1);
	g_value_init (_tmp41_, G_TYPE_STRING);
	g_value_set_string (_tmp41_, id);
	gee_abstract_map_set ((GeeAbstractMap*) profile, "id", _tmp41_);
	__vala_GValue_free0 (_tmp41_);
	_tmp42_ = g_new0 (GValue, 1);
	g_value_init (_tmp42_, G_TYPE_STRING);
	g_value_set_string (_tmp42_, description);
	gee_abstract_map_set ((GeeAbstractMap*) profile, "description", _tmp42_);
	__vala_GValue_free0 (_tmp42_);
	_tmp43_ = g_new0 (GValue, 1);
	g_value_init (_tmp43_, G_TYPE_STRING);
	g_value_set_string (_tmp43_, image);
	gee_abstract_map_set ((GeeAbstractMap*) profile, "image", _tmp43_);
	__vala_GValue_free0 (_tmp43_);
	_tmp44_ = g_new0 (GValue, 1);
	g_value_init (_tmp44_, G_TYPE_STRING);
	g_value_set_string (_tmp44_, url);
	gee_abstract_map_set ((GeeAbstractMap*) profile, "url", _tmp44_);
	__vala_GValue_free0 (_tmp44_);
	_tmp45_ = g_new0 (GValue, 1);
	g_value_init (_tmp45_, G_TYPE_INT);
	g_value_set_int (_tmp45_, followers);
	gee_abstract_map_set ((GeeAbstractMap*) profile, "followers", _tmp45_);
	__vala_GValue_free0 (_tmp45_);
	_tmp46_ = g_new0 (GValue, 1);
	g_value_init (_tmp46_, G_TYPE_INT);
	g_value_set_int (_tmp46_, friends);
	gee_abstract_map_set ((GeeAbstractMap*) profile, "friends", _tmp46_);
	__vala_GValue_free0 (_tmp46_);
	_tmp47_ = g_new0 (GValue, 1);
	g_value_init (_tmp47_, G_TYPE_INT);
	g_value_set_int (_tmp47_, statuses);
	gee_abstract_map_set ((GeeAbstractMap*) profile, "statuses", _tmp47_);
	__vala_GValue_free0 (_tmp47_);
	_tmp48_ = g_new0 (GValue, 1);
	g_value_init (_tmp48_, G_TYPE_BOOLEAN);
	g_value_set_boolean (_tmp48_, following);
	gee_abstract_map_set ((GeeAbstractMap*) profile, "following", _tmp48_);
	__vala_GValue_free0 (_tmp48_);
	_tmp49_ = g_new0 (GValue, 1);
	g_value_init (_tmp49_, G_TYPE_BOOLEAN);
	g_value_set_boolean (_tmp49_, protected);
	gee_abstract_map_set ((GeeAbstractMap*) profile, "protected", _tmp49_);
	__vala_GValue_free0 (_tmp49_);
	result = profile;
	_json_object_unref0 (obj);
	_json_array_unref0 (nodeArray);
	_g_object_unref0 (parser);
	_g_free0 (_result_);
	_g_free0 (url);
	_g_free0 (image);
	_g_free0 (description);
	_g_free0 (service);
	_g_free0 (account);
	_g_free0 (nick);
	_g_free0 (name);
	return result;
	_json_object_unref0 (obj);
	_json_array_unref0 (nodeArray);
	_g_object_unref0 (parser);
	_g_free0 (_result_);
	_g_free0 (url);
	_g_free0 (image);
	_g_free0 (description);
	_g_free0 (service);
	_g_free0 (account);
	_g_free0 (nick);
	_g_free0 (name);
	_g_object_unref0 (profile);
	goto __finally51;
	__catch51_g_io_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("streams.vala:908: %s", e->message);
		result = NULL;
		_g_error_free0 (e);
		return result;
	}
	__finally51:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
	g_clear_error (&_inner_error_);
	return NULL;
}


void gwibber_streams_streams_available (GwibberStreams* self, gboolean is_up) {
	g_return_if_fail (self != NULL);
	g_signal_emit_by_name (self, "is-available", is_up);
}


DeeModel* gwibber_streams_get_stream_model (GwibberStreams* self) {
	DeeModel* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (self->priv->_stream_model != NULL) {
		result = self->priv->_stream_model;
		return result;
	} else {
		DeeModel* _tmp0_ = NULL;
		_tmp0_ = gwibber_streams_streams_model (self, FALSE);
		_g_object_unref0 (self->priv->_stream_model);
		self->priv->_stream_model = _tmp0_;
		result = self->priv->_stream_model;
		return result;
	}
}


void gwibber_streams_set_stream_model (GwibberStreams* self, DeeModel* value) {
	g_return_if_fail (self != NULL);
	if (self->priv->_stream_model != value) {
		DeeModel* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_stream_model);
		self->priv->_stream_model = _tmp0_;
	}
	g_object_notify ((GObject *) self, "stream-model");
}


DeeModel* gwibber_streams_get_transient_model (GwibberStreams* self) {
	DeeModel* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (self->priv->_transient_model != NULL) {
		result = self->priv->_transient_model;
		return result;
	} else {
		DeeModel* _tmp0_ = NULL;
		_tmp0_ = gwibber_streams_streams_model (self, TRUE);
		_g_object_unref0 (self->priv->_transient_model);
		self->priv->_transient_model = _tmp0_;
		result = self->priv->_transient_model;
		return result;
	}
}


void gwibber_streams_set_transient_model (GwibberStreams* self, DeeModel* value) {
	g_return_if_fail (self != NULL);
	if (self->priv->_transient_model != value) {
		DeeModel* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_transient_model);
		self->priv->_transient_model = _tmp0_;
	}
	g_object_notify ((GObject *) self, "transient-model");
}


static void gwibber_streams_real_updated (GwibberStreams* self, const gchar* id) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (id != NULL);
	g_debug ("streams.vala:93: UPDATE called");
}


static void gwibber_streams_class_init (GwibberStreamsClass * klass) {
	gwibber_streams_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GwibberStreamsPrivate));
	GWIBBER_STREAMS_CLASS (klass)->updated = gwibber_streams_real_updated;
	G_OBJECT_CLASS (klass)->get_property = _vala_gwibber_streams_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gwibber_streams_set_property;
	G_OBJECT_CLASS (klass)->finalize = gwibber_streams_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GWIBBER_STREAMS_STREAM_MODEL, g_param_spec_object ("stream-model", "stream-model", "stream-model", DEE_TYPE_MODEL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GWIBBER_STREAMS_TRANSIENT_MODEL, g_param_spec_object ("transient-model", "transient-model", "transient-model", DEE_TYPE_MODEL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/** 
	            Streams::is_available:
	            @arg0: The current state
	
	            Emitted when com.Gwibber.Streams availability state changes
	*/
	g_signal_new ("is_available", GWIBBER_TYPE_STREAMS, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__BOOLEAN, G_TYPE_NONE, 1, G_TYPE_BOOLEAN);
	g_signal_new ("updated", GWIBBER_TYPE_STREAMS, G_SIGNAL_RUN_LAST | G_SIGNAL_ACTION, G_STRUCT_OFFSET (GwibberStreamsClass, updated), NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
	g_signal_new ("deleted", GWIBBER_TYPE_STREAMS, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
	g_signal_new ("created", GWIBBER_TYPE_STREAMS, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
}


static void gwibber_streams_instance_init (GwibberStreams * self) {
	self->priv = GWIBBER_STREAMS_GET_PRIVATE (self);
	self->priv->_stream_model = NULL;
	self->priv->_transient_model = NULL;
	self->priv->_service_loading = FALSE;
}


static void gwibber_streams_finalize (GObject* obj) {
	GwibberStreams * self;
	self = GWIBBER_STREAMS (obj);
	_g_object_unref0 (self->priv->streams_service);
	_g_object_unref0 (self->priv->service);
	_g_object_unref0 (self->priv->utils);
	_g_object_unref0 (self->priv->messages_service);
	_g_object_unref0 (self->priv->searches_service);
	_g_object_unref0 (self->priv->_stream_model);
	_g_object_unref0 (self->priv->_transient_model);
	_g_object_unref0 (self->priv->seen);
	G_OBJECT_CLASS (gwibber_streams_parent_class)->finalize (obj);
}


GType gwibber_streams_get_type (void) {
	static volatile gsize gwibber_streams_type_id__volatile = 0;
	if (g_once_init_enter (&gwibber_streams_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GwibberStreamsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gwibber_streams_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GwibberStreams), 0, (GInstanceInitFunc) gwibber_streams_instance_init, NULL };
		GType gwibber_streams_type_id;
		gwibber_streams_type_id = g_type_register_static (G_TYPE_OBJECT, "GwibberStreams", &g_define_type_info, 0);
		g_once_init_leave (&gwibber_streams_type_id__volatile, gwibber_streams_type_id);
	}
	return gwibber_streams_type_id__volatile;
}


static void _vala_gwibber_streams_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GwibberStreams * self;
	self = GWIBBER_STREAMS (object);
	switch (property_id) {
		case GWIBBER_STREAMS_STREAM_MODEL:
		g_value_set_object (value, gwibber_streams_get_stream_model (self));
		break;
		case GWIBBER_STREAMS_TRANSIENT_MODEL:
		g_value_set_object (value, gwibber_streams_get_transient_model (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_gwibber_streams_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GwibberStreams * self;
	self = GWIBBER_STREAMS (object);
	switch (property_id) {
		case GWIBBER_STREAMS_STREAM_MODEL:
		gwibber_streams_set_stream_model (self, g_value_get_object (value));
		break;
		case GWIBBER_STREAMS_TRANSIENT_MODEL:
		gwibber_streams_set_transient_model (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



