/* stream-view-tile.c generated by valac 0.12.1, the Vala compiler
 * generated from stream-view-tile.vala, do not modify */

/*
 * Copyright (C) 2010 Neil Jagdish Patel
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License
 * version 3.0 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3.0 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see
 * <http://www.gnu.org/licenses/>.
 *
 * Authored by Neil Jagdish Patel <njpatel@gmail.com>
 */

#include <glib.h>
#include <glib-object.h>
#include "gwibber-gtk.h"
#include <gtk/gtk.h>
#include <cairo.h>
#include <float.h>
#include <math.h>
#include <gwibber.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <json-glib/json-glib.h>
#include <pango/pango.h>
#include <gdk/gdk.h>
#include <glib/gi18n-lib.h>
#include <gdk-pixbuf/gdk-pixdata.h>
#include <libsoup/soup.h>
#include <gee.h>
#include <libnotify/notify.h>

#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _cairo_pattern_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_pattern_destroy (var), NULL)))
typedef struct _Block2Data Block2Data;
typedef struct _Block3Data Block3Data;
typedef struct _Block4Data Block4Data;
#define _json_object_unref0(var) ((var == NULL) ? NULL : (var = (json_object_unref (var), NULL)))
#define _json_array_unref0(var) ((var == NULL) ? NULL : (var = (json_array_unref (var), NULL)))
typedef struct _Block5Data Block5Data;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _GwibberGtkStreamViewTileLoadAvatarAsyncData GwibberGtkStreamViewTileLoadAvatarAsyncData;
typedef struct _GwibberGtkStreamViewTileLoadThumbnailAsyncData GwibberGtkStreamViewTileLoadThumbnailAsyncData;
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
#define _soup_uri_free0(var) ((var == NULL) ? NULL : (var = (soup_uri_free (var), NULL)))

struct _GwibberGtkStreamViewTilePrivate {
	GtkAlignment* align;
	GtkHBox* main_box;
	GtkAlignment* lalignment;
	GtkAlignment* ralignment;
	GtkEventBox* icon_box;
	GwibberGtkStreamViewAvatar* icon;
	GtkImage* private;
	GtkVBox* vbox;
	GtkVBox* comments_box;
	GtkHBox* likes_hbox;
	GtkLabel* likes_count;
	GtkLabel* name;
	GtkLabel* time;
	GtkLabel* message;
	GwibberGtkStreamViewAvatar* thumbnail;
	GtkEventBox* thumb_box;
	GtkLabel* reply_to;
	GtkLabel* retweeted_by;
	GwibberUtils* _utils;
	GwibberService* _service;
	gboolean _show_fullname;
	guint _update_time_area_id;
	guint _cache_avatar_id;
	GList* _to_disconnect;
	gchar* sender;
	gchar* url;
	gchar* time_string;
	GwibberGtkActionBox* action_box;
	GCancellable* cancellable;
	gchar* img_uri;
	gchar* img_src;
	guint img_id;
};

struct _Block2Data {
	int _ref_count_;
	GwibberGtkStreamViewTile * self;
	gchar* link_str;
	gchar* video_str;
	gchar* _stream;
	gchar* _html;
	gchar* _icon_uri;
	gchar* _img_url;
	gchar* _img_name;
};

struct _Block3Data {
	int _ref_count_;
	Block2Data * _data2_;
	GwibberGtkStreamViewAvatar* cicon;
};

struct _Block4Data {
	int _ref_count_;
	Block3Data * _data3_;
	gchar* cimage;
};

struct _Block5Data {
	int _ref_count_;
	Block2Data * _data2_;
	gchar* img_str;
};

struct _GwibberGtkStreamViewTileLoadAvatarAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	GwibberGtkStreamViewTile* self;
	gchar* url;
	GtkImage* cicon;
	gchar* t;
	GFile* _tmp0_;
	GFile* file;
	GFileInputStream* _tmp1_;
	GFileInputStream* stream;
	GdkPixbuf* pixbuf;
	GdkPixbuf* _tmp2_;
	GdkPixbuf* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* cimage;
	gchar* _tmp9_;
	gboolean _tmp10_;
	gboolean _tmp11_;
	gboolean _tmp12_;
	gboolean _tmp13_;
	gboolean _tmp14_;
	gchar* _tmp15_;
	GError * e;
	GError * _inner_error_;
};

struct _GwibberGtkStreamViewTileLoadThumbnailAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	GwibberGtkStreamViewTile* self;
	gchar* img_markup;
	GtkAllocation alloc;
	GtkAllocation _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GFile* _tmp3_;
	GFile* _tmp4_;
	GFile* file;
	GFileInputStream* _tmp5_;
	GFileInputStream* stream;
	GdkPixbuf* pixbuf;
	GdkPixbuf* _tmp6_;
	GdkPixbuf* _tmp7_;
	GError * e;
	GError * _inner_error_;
};


static gpointer gwibber_gtk_stream_view_avatar_parent_class = NULL;
static gpointer gwibber_gtk_stream_view_tile_parent_class = NULL;

enum  {
	GWIBBER_GTK_STREAM_VIEW_AVATAR_DUMMY_PROPERTY
};
static gboolean gwibber_gtk_stream_view_avatar_on_draw (GwibberGtkStreamViewAvatar* self, cairo_t* cr);
static gboolean _gwibber_gtk_stream_view_avatar_on_draw_gtk_widget_draw (GtkWidget* _sender, cairo_t* cr, gpointer self);
#define GWIBBER_GTK_STREAM_VIEW_TILE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GWIBBER_GTK_TYPE_STREAM_VIEW_TILE, GwibberGtkStreamViewTilePrivate))
enum  {
	GWIBBER_GTK_STREAM_VIEW_TILE_DUMMY_PROPERTY,
	GWIBBER_GTK_STREAM_VIEW_TILE_UTILS,
	GWIBBER_GTK_STREAM_VIEW_TILE_SERVICE,
	GWIBBER_GTK_STREAM_VIEW_TILE_SHOW_FULLNAME
};
#define GWIBBER_GTK_STREAM_VIEW_TILE_our_padding 6
static gboolean gwibber_gtk_stream_view_tile_on_draw (GwibberGtkStreamViewTile* self, cairo_t* cr);
static void gwibber_gtk_stream_view_tile_update_time_area_wrapper (GwibberGtkStreamViewTile* self);
static gboolean _lambda15_ (GwibberGtkStreamViewTile* self);
static void gwibber_gtk_stream_view_tile_update_time_area (GwibberGtkStreamViewTile* self);
static gboolean __lambda15__gsource_func (gpointer self);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (Block2Data* _data2_);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (Block3Data* _data3_);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (Block4Data* _data4_);
static gboolean _lambda16_ (Block4Data* _data4_);
static void gwibber_gtk_stream_view_tile_load_avatar_async (GwibberGtkStreamViewTile* self, const gchar* url, GtkImage* cicon, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void gwibber_gtk_stream_view_tile_load_avatar_finish (GwibberGtkStreamViewTile* self, GAsyncResult* _res_);
static gboolean __lambda16__gsource_func (gpointer self);
static gboolean _vala_string_array_contains (gchar** stack, int stack_length, gchar* needle);
static void _vala_array_add1 (gchar*** array, int* length, int* size, gchar* value);
static void _lambda17_ (const gchar* mid, const gchar* account, const gchar* sender, GwibberGtkStreamViewTile* self);
static void __lambda17__gwibber_gtk_action_box_item_reply (GwibberGtkActionBoxItem* _sender, const gchar* mid, const gchar* account, const gchar* sender, gpointer self);
static gboolean _lambda18_ (Block2Data* _data2_);
static gboolean __lambda18__gsource_func (gpointer self);
static gboolean gwibber_gtk_stream_view_tile_on_avatar_click (GwibberGtkStreamViewTile* self, GdkEventButton* button);
static gboolean _gwibber_gtk_stream_view_tile_on_avatar_click_gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (Block5Data* _data5_);
static gboolean _lambda19_ (Block5Data* _data5_);
static void gwibber_gtk_stream_view_tile_load_thumbnail_async (GwibberGtkStreamViewTile* self, const gchar* img_markup, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void gwibber_gtk_stream_view_tile_load_thumbnail_finish (GwibberGtkStreamViewTile* self, GAsyncResult* _res_);
static gboolean __lambda19__gsource_func (gpointer self);
static void gwibber_gtk_stream_view_tile_load_avatar_async_data_free (gpointer _data);
static gboolean gwibber_gtk_stream_view_tile_load_avatar_async_co (GwibberGtkStreamViewTileLoadAvatarAsyncData* data);
static void gwibber_gtk_stream_view_tile_load_avatar_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void gwibber_gtk_stream_view_tile_load_thumbnail_async_data_free (gpointer _data);
static gboolean gwibber_gtk_stream_view_tile_load_thumbnail_async_co (GwibberGtkStreamViewTileLoadThumbnailAsyncData* data);
static gchar* gwibber_gtk_stream_view_tile_fix_image_uri (GwibberGtkStreamViewTile* self, const gchar* uri);
static void gwibber_gtk_stream_view_tile_load_thumbnail_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void gwibber_gtk_stream_view_tile_real_reply (GwibberGtkStreamViewTile* self, const gchar* mid, const gchar* account, const gchar* sender);
static void g_cclosure_user_marshal_VOID__STRING_STRING_STRING (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static GObject * gwibber_gtk_stream_view_tile_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static gboolean _gwibber_gtk_stream_view_tile_on_draw_gtk_widget_draw (GtkWidget* _sender, cairo_t* cr, gpointer self);
static gboolean _lambda20_ (const gchar* uri, GwibberGtkStreamViewTile* self);
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
static gboolean __lambda20__gtk_label_activate_link (GtkLabel* _sender, const gchar* uri, gpointer self);
static gboolean _lambda21_ (GwibberGtkStreamViewTile* self);
static gboolean __lambda21__gtk_widget_button_release_event (GtkWidget* _sender, GdkEventButton* event, gpointer self);
static gboolean _lambda22_ (GwibberGtkStreamViewTile* self);
static gboolean __lambda22__gtk_widget_enter_notify_event (GtkWidget* _sender, GdkEventCrossing* event, gpointer self);
static gboolean _lambda23_ (GwibberGtkStreamViewTile* self);
static gboolean __lambda23__gtk_widget_enter_notify_event (GtkWidget* _sender, GdkEventCrossing* event, gpointer self);
static gboolean _lambda24_ (GwibberGtkStreamViewTile* self);
static gboolean __lambda24__gtk_widget_enter_notify_event (GtkWidget* _sender, GdkEventCrossing* event, gpointer self);
static gboolean _lambda25_ (GwibberGtkStreamViewTile* self);
static gboolean __lambda25__gtk_widget_leave_notify_event (GtkWidget* _sender, GdkEventCrossing* event, gpointer self);
static void gwibber_gtk_stream_view_tile_finalize (GObject* obj);
static void _vala_gwibber_gtk_stream_view_tile_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_gwibber_gtk_stream_view_tile_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static gboolean _gwibber_gtk_stream_view_avatar_on_draw_gtk_widget_draw (GtkWidget* _sender, cairo_t* cr, gpointer self) {
	gboolean result;
	result = gwibber_gtk_stream_view_avatar_on_draw (self, cr);
	return result;
}


GwibberGtkStreamViewAvatar* gwibber_gtk_stream_view_avatar_construct (GType object_type) {
	GwibberGtkStreamViewAvatar * self = NULL;
	self = (GwibberGtkStreamViewAvatar*) g_object_new (object_type, NULL);
	g_signal_connect_object ((GtkWidget*) self, "draw", (GCallback) _gwibber_gtk_stream_view_avatar_on_draw_gtk_widget_draw, self, 0);
	return self;
}


GwibberGtkStreamViewAvatar* gwibber_gtk_stream_view_avatar_new (void) {
	return gwibber_gtk_stream_view_avatar_construct (GWIBBER_GTK_TYPE_STREAM_VIEW_AVATAR);
}


static gboolean gwibber_gtk_stream_view_avatar_on_draw (GwibberGtkStreamViewAvatar* self, cairo_t* cr) {
	gboolean result = FALSE;
	GtkAllocation alloc = {0};
	GtkAllocation _tmp0_ = {0};
	gfloat radius;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (cr != NULL, FALSE);
	gtk_widget_get_allocation ((GtkWidget*) self, &_tmp0_);
	alloc = _tmp0_;
	radius = 10.0f;
	cairo_move_to (cr, (gdouble) 0, (gdouble) radius);
	cairo_curve_to (cr, (gdouble) 0, (gdouble) 0, (gdouble) 0, (gdouble) 0, (gdouble) radius, (gdouble) 0);
	cairo_line_to (cr, (gdouble) (alloc.width - radius), (gdouble) 0);
	cairo_curve_to (cr, (gdouble) alloc.width, (gdouble) 0, (gdouble) alloc.width, (gdouble) 0, (gdouble) alloc.width, (gdouble) radius);
	cairo_line_to (cr, (gdouble) alloc.width, (gdouble) (alloc.height - radius));
	cairo_curve_to (cr, (gdouble) alloc.width, (gdouble) alloc.height, (gdouble) alloc.width, (gdouble) alloc.height, (gdouble) (alloc.width - radius), (gdouble) alloc.height);
	cairo_line_to (cr, (gdouble) radius, (gdouble) alloc.height);
	cairo_curve_to (cr, (gdouble) 0, (gdouble) alloc.height, (gdouble) 0, (gdouble) alloc.height, (gdouble) 0, (gdouble) (alloc.height - radius));
	cairo_close_path (cr);
	cairo_clip (cr);
	GTK_WIDGET_CLASS (gwibber_gtk_stream_view_avatar_parent_class)->draw ((GtkWidget*) GTK_IMAGE (self), cr);
	result = TRUE;
	return result;
}


static void gwibber_gtk_stream_view_avatar_class_init (GwibberGtkStreamViewAvatarClass * klass) {
	gwibber_gtk_stream_view_avatar_parent_class = g_type_class_peek_parent (klass);
}


static void gwibber_gtk_stream_view_avatar_instance_init (GwibberGtkStreamViewAvatar * self) {
}


GType gwibber_gtk_stream_view_avatar_get_type (void) {
	static volatile gsize gwibber_gtk_stream_view_avatar_type_id__volatile = 0;
	if (g_once_init_enter (&gwibber_gtk_stream_view_avatar_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GwibberGtkStreamViewAvatarClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gwibber_gtk_stream_view_avatar_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GwibberGtkStreamViewAvatar), 0, (GInstanceInitFunc) gwibber_gtk_stream_view_avatar_instance_init, NULL };
		GType gwibber_gtk_stream_view_avatar_type_id;
		gwibber_gtk_stream_view_avatar_type_id = g_type_register_static (GTK_TYPE_IMAGE, "GwibberGtkStreamViewAvatar", &g_define_type_info, 0);
		g_once_init_leave (&gwibber_gtk_stream_view_avatar_type_id__volatile, gwibber_gtk_stream_view_avatar_type_id);
	}
	return gwibber_gtk_stream_view_avatar_type_id__volatile;
}


GwibberGtkStreamViewTile* gwibber_gtk_stream_view_tile_construct (GType object_type, GwibberUtils* utils, GwibberService* service, gboolean show_fullname) {
	GwibberGtkStreamViewTile * self = NULL;
	g_return_val_if_fail (utils != NULL, NULL);
	g_return_val_if_fail (service != NULL, NULL);
	self = (GwibberGtkStreamViewTile*) g_object_new (object_type, "above-child", FALSE, "visible-window", FALSE, "utils", utils, "service", service, "show-fullname", show_fullname, NULL);
	return self;
}


GwibberGtkStreamViewTile* gwibber_gtk_stream_view_tile_new (GwibberUtils* utils, GwibberService* service, gboolean show_fullname) {
	return gwibber_gtk_stream_view_tile_construct (GWIBBER_GTK_TYPE_STREAM_VIEW_TILE, utils, service, show_fullname);
}


static gboolean gwibber_gtk_stream_view_tile_on_draw (GwibberGtkStreamViewTile* self, cairo_t* cr) {
	gboolean result = FALSE;
	GtkAllocation alloc = {0};
	GtkAllocation _tmp0_ = {0};
	cairo_pattern_t* _tmp1_ = NULL;
	cairo_pattern_t* pat;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (cr != NULL, FALSE);
	gtk_widget_get_allocation ((GtkWidget*) self, &_tmp0_);
	alloc = _tmp0_;
	cairo_set_line_width (cr, 1.0);
	cairo_set_source_rgba (cr, 1.0, 1.0, 1.0, 1.0);
	cairo_move_to (cr, (gdouble) alloc.x, 0.5);
	cairo_line_to (cr, (gdouble) (alloc.x + alloc.width), 0.5);
	cairo_stroke (cr);
	_tmp1_ = cairo_pattern_create_linear ((gdouble) 0, (gdouble) 0, (gdouble) 0, (gdouble) alloc.height);
	pat = _tmp1_;
	cairo_pattern_add_color_stop_rgba (pat, (gdouble) 0.0f, (gdouble) 1.0f, (gdouble) 1.0f, (gdouble) 1.0f, (gdouble) 0.2f);
	cairo_pattern_add_color_stop_rgba (pat, (gdouble) 1.0f, (gdouble) 1.0f, (gdouble) 1.0f, (gdouble) 1.0f, (gdouble) 0.0f);
	cairo_rectangle (cr, (gdouble) 0, (gdouble) 0, (gdouble) alloc.width, (gdouble) alloc.height);
	cairo_set_source (cr, pat);
	cairo_fill (cr);
	cairo_set_source_rgba (cr, 0.0, 0.0, 0.0, 0.1);
	cairo_move_to (cr, (gdouble) alloc.x, alloc.height - 0.5);
	cairo_line_to (cr, (gdouble) (alloc.x + alloc.width), alloc.height - 0.5);
	cairo_stroke (cr);
	gtk_container_propagate_draw ((GtkContainer*) self, (GtkWidget*) self->priv->align, cr);
	result = TRUE;
	_cairo_pattern_destroy0 (pat);
	return result;
}


void gwibber_gtk_stream_view_tile_reset (GwibberGtkStreamViewTile* self) {
	g_return_if_fail (self != NULL);
	gtk_widget_hide ((GtkWidget*) self);
}


static gboolean _lambda15_ (GwibberGtkStreamViewTile* self) {
	gboolean result = FALSE;
	gwibber_gtk_stream_view_tile_update_time_area (self);
	result = FALSE;
	return result;
}


static gboolean __lambda15__gsource_func (gpointer self) {
	gboolean result;
	result = _lambda15_ (self);
	return result;
}


static void gwibber_gtk_stream_view_tile_update_time_area_wrapper (GwibberGtkStreamViewTile* self) {
	g_return_if_fail (self != NULL);
	if (self->priv->_update_time_area_id == 0) {
		guint _tmp0_;
		_tmp0_ = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 200, __lambda15__gsource_func, g_object_ref (self), g_object_unref);
		self->priv->_update_time_area_id = _tmp0_;
	}
}


static void gwibber_gtk_stream_view_tile_update_time_area (GwibberGtkStreamViewTile* self) {
	gint x = 0;
	gint y = 0;
	gint _tmp0_;
	gint _tmp1_;
	GtkAllocation a = {0};
	GtkAllocation _tmp2_ = {0};
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	g_return_if_fail (self != NULL);
	gtk_widget_get_pointer ((GtkWidget*) self, &_tmp0_, &_tmp1_);
	x = _tmp0_;
	y = _tmp1_;
	gtk_widget_get_allocation ((GtkWidget*) self, &_tmp2_);
	a = _tmp2_;
	if (x > 0) {
		_tmp5_ = x < a.width;
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		_tmp4_ = y > 0;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		_tmp3_ = y < a.height;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		gtk_widget_hide ((GtkWidget*) self->priv->time);
		gtk_widget_set_no_show_all ((GtkWidget*) self->priv->action_box, FALSE);
		gtk_widget_show_all ((GtkWidget*) self->priv->action_box);
	} else {
		gchar* _tmp6_;
		gchar* str;
		gchar* _tmp7_;
		gchar* _tmp8_;
		_tmp6_ = g_strdup ("<span font_weight='light' font_size='small' color='#999'>");
		str = _tmp6_;
		_tmp7_ = g_strconcat (str, self->priv->time_string, NULL);
		_g_free0 (str);
		str = _tmp7_;
		_tmp8_ = g_strconcat (str, "</span>", NULL);
		_g_free0 (str);
		str = _tmp8_;
		gtk_label_set_markup (self->priv->time, str);
		gtk_widget_hide ((GtkWidget*) self->priv->action_box);
		gtk_widget_show_all ((GtkWidget*) self->priv->time);
		_g_free0 (str);
	}
	self->priv->_update_time_area_id = (guint) 0;
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}


static void block2_data_unref (Block2Data* _data2_) {
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		_g_object_unref0 (_data2_->self);
		_g_free0 (_data2_->video_str);
		_g_free0 (_data2_->link_str);
		_g_free0 (_data2_->_stream);
		_g_free0 (_data2_->_html);
		_g_free0 (_data2_->_icon_uri);
		_g_free0 (_data2_->_img_url);
		_g_free0 (_data2_->_img_name);
		g_slice_free (Block2Data, _data2_);
	}
}


static gpointer _json_object_ref0 (gpointer self) {
	return self ? json_object_ref (self) : NULL;
}


static gpointer _json_array_ref0 (gpointer self) {
	return self ? json_array_ref (self) : NULL;
}


static Block3Data* block3_data_ref (Block3Data* _data3_) {
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}


static void block3_data_unref (Block3Data* _data3_) {
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		block2_data_unref (_data3_->_data2_);
		_data3_->_data2_ = NULL;
		_g_object_unref0 (_data3_->cicon);
		g_slice_free (Block3Data, _data3_);
	}
}


static Block4Data* block4_data_ref (Block4Data* _data4_) {
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}


static void block4_data_unref (Block4Data* _data4_) {
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		block3_data_unref (_data4_->_data3_);
		_data4_->_data3_ = NULL;
		_g_free0 (_data4_->cimage);
		g_slice_free (Block4Data, _data4_);
	}
}


static gboolean _lambda16_ (Block4Data* _data4_) {
	Block3Data* _data3_;
	Block2Data* _data2_;
	GwibberGtkStreamViewTile * self;
	gboolean result = FALSE;
	_data3_ = _data4_->_data3_;
	_data2_ = _data3_->_data2_;
	self = _data2_->self;
	gwibber_gtk_stream_view_tile_load_avatar_async (self, _data4_->cimage, (GtkImage*) _data3_->cicon, NULL, NULL);
	result = FALSE;
	return result;
}


static gboolean __lambda16__gsource_func (gpointer self) {
	gboolean result;
	result = _lambda16_ (self);
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gboolean _vala_string_array_contains (gchar** stack, int stack_length, gchar* needle) {
	int i;
	for (i = 0; i < stack_length; i++) {
		if (g_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}


static void _vala_array_add1 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _lambda17_ (const gchar* mid, const gchar* account, const gchar* sender, GwibberGtkStreamViewTile* self) {
	g_return_if_fail (mid != NULL);
	g_return_if_fail (account != NULL);
	g_return_if_fail (sender != NULL);
	g_signal_emit_by_name (self, "reply", mid, account, sender);
}


static void __lambda17__gwibber_gtk_action_box_item_reply (GwibberGtkActionBoxItem* _sender, const gchar* mid, const gchar* account, const gchar* sender, gpointer self) {
	_lambda17_ (mid, account, sender, self);
}


static gboolean _lambda18_ (Block2Data* _data2_) {
	GwibberGtkStreamViewTile * self;
	gboolean result = FALSE;
	self = _data2_->self;
	gwibber_gtk_stream_view_tile_load_avatar_async (self, _data2_->_icon_uri, (GtkImage*) self->priv->icon, NULL, NULL);
	result = FALSE;
	return result;
}


static gboolean __lambda18__gsource_func (gpointer self) {
	gboolean result;
	result = _lambda18_ (self);
	return result;
}


static gboolean _gwibber_gtk_stream_view_tile_on_avatar_click_gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self) {
	gboolean result;
	result = gwibber_gtk_stream_view_tile_on_avatar_click (self, event);
	return result;
}


static gchar* double_to_string (gdouble self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gint _tmp1__length1;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	gchar* _tmp4_;
	_tmp0_ = g_new0 (gchar, G_ASCII_DTOSTR_BUF_SIZE);
	_tmp1_ = _tmp0_;
	_tmp1__length1 = G_ASCII_DTOSTR_BUF_SIZE;
	_tmp2_ = g_ascii_dtostr (_tmp1_, G_ASCII_DTOSTR_BUF_SIZE, self);
	_tmp3_ = g_strdup (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp1_ = (g_free (_tmp1_), NULL);
	result = _tmp4_;
	return result;
}


static Block5Data* block5_data_ref (Block5Data* _data5_) {
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}


static void block5_data_unref (Block5Data* _data5_) {
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		block2_data_unref (_data5_->_data2_);
		_data5_->_data2_ = NULL;
		_g_free0 (_data5_->img_str);
		g_slice_free (Block5Data, _data5_);
	}
}


static gboolean _lambda19_ (Block5Data* _data5_) {
	Block2Data* _data2_;
	GwibberGtkStreamViewTile * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	_data2_ = _data5_->_data2_;
	self = _data2_->self;
	if (g_strcmp0 (_data2_->_stream, "videos") == 0) {
		gint _tmp1_;
		_tmp1_ = strlen (_data2_->video_str);
		_tmp0_ = _tmp1_ > 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (_data2_->video_str);
		_g_free0 (_data5_->img_str);
		_data5_->img_str = _tmp2_;
	} else {
		gboolean _tmp3_ = FALSE;
		if (g_strcmp0 (_data2_->_stream, "links") == 0) {
			gint _tmp4_;
			_tmp4_ = strlen (_data2_->link_str);
			_tmp3_ = _tmp4_ > 0;
		} else {
			_tmp3_ = FALSE;
		}
		if (_tmp3_) {
			gchar* _tmp5_;
			_tmp5_ = g_strdup (_data2_->link_str);
			_g_free0 (_data5_->img_str);
			_data5_->img_str = _tmp5_;
		} else {
			gint _tmp6_;
			gchar* _tmp21_;
			_tmp6_ = strlen (_data2_->_img_name);
			if (_tmp6_ > 0) {
				gchar* _tmp7_;
				gchar* _tmp8_;
				gchar* _tmp9_;
				gchar* _tmp10_;
				gchar* _tmp11_;
				gchar* _tmp12_;
				gchar* _tmp13_;
				_tmp7_ = g_strconcat ("<a href='", _data2_->_img_url, NULL);
				_tmp8_ = _tmp7_;
				_tmp9_ = g_strconcat (_tmp8_, "'>", NULL);
				_tmp10_ = _tmp9_;
				_tmp11_ = g_strconcat (_tmp10_, _data2_->_img_name, NULL);
				_tmp12_ = _tmp11_;
				_tmp13_ = g_strconcat (_tmp12_, "</a>\n", NULL);
				_g_free0 (_data5_->img_str);
				_data5_->img_str = _tmp13_;
				_g_free0 (_tmp12_);
				_g_free0 (_tmp10_);
				_g_free0 (_tmp8_);
			} else {
				gchar* _tmp14_;
				gchar* _tmp15_;
				gchar* _tmp16_;
				gchar* _tmp17_;
				gchar* _tmp18_;
				gchar* _tmp19_;
				gchar* _tmp20_;
				_tmp14_ = g_strconcat ("<a href='", _data2_->_img_url, NULL);
				_tmp15_ = _tmp14_;
				_tmp16_ = g_strconcat (_tmp15_, "'>", NULL);
				_tmp17_ = _tmp16_;
				_tmp18_ = g_strconcat (_tmp17_, _data2_->_img_url, NULL);
				_tmp19_ = _tmp18_;
				_tmp20_ = g_strconcat (_tmp19_, "</a>\n", NULL);
				_g_free0 (_data5_->img_str);
				_data5_->img_str = _tmp20_;
				_g_free0 (_tmp19_);
				_g_free0 (_tmp17_);
				_g_free0 (_tmp15_);
			}
			_tmp21_ = g_strconcat (_data5_->img_str, _data2_->_html, NULL);
			_g_free0 (_data5_->img_str);
			_data5_->img_str = _tmp21_;
		}
	}
	gwibber_gtk_stream_view_tile_load_thumbnail_async (self, _data5_->img_str, NULL, NULL);
	result = FALSE;
	return result;
}


static gboolean __lambda19__gsource_func (gpointer self) {
	gboolean result;
	result = _lambda19_ (self);
	return result;
}


void gwibber_gtk_stream_view_tile_set_details (GwibberGtkStreamViewTile* self, gchar** _accounts, int _accounts_length1, const gchar* _stream, const gchar* _sender, const gchar* _sender_nick, gboolean _from_me, const gchar* _timestamp, const gchar* _message, const gchar* _html, const gchar* _icon_uri, const gchar* _url, const gchar* _source, const gchar* _timestring, const gchar* _reply_nick, const gchar* _reply_name, const gchar* _reply_url, gdouble _likes, const gchar* _retweet_nick, const gchar* _retweet_name, const gchar* _retweet_id, const gchar* _link_picture, const gchar* _link_name, const gchar* _link_url, const gchar* _link_desc, const gchar* _link_caption, const gchar* _link_icon, const gchar* _img_url, const gchar* _img_src, const gchar* _img_thumb, const gchar* _img_name, const gchar* _video_picture, const gchar* _video_src, const gchar* _video_url, const gchar* _video_name, const gchar* _comments) {
	Block2Data* _data2_;
	gchar* _tmp0_;
	GList* _tmp9_ = NULL;
	gchar* _tmp51_;
	gchar* display_name;
	gboolean _tmp52_ = FALSE;
	gchar* _tmp57_;
	gchar* _tmp58_;
	gchar* _tmp59_;
	gchar* _tmp60_;
	gchar* _tmp61_ = NULL;
	gint _tmp62_;
	gchar* _tmp65_;
	gchar** icon_displayed;
	gint icon_displayed_length1;
	gint _icon_displayed_size_;
	GList* _tmp66_ = NULL;
	gchar* _tmp82_ = NULL;
	gchar* _avatar_cache_image;
	gchar* _tmp84_;
	guint _tmp85_;
	gint _tmp124_;
	glong _tmp126_;
	gchar* _tmp127_ = NULL;
	gchar* _tmp128_;
	gchar* reply_to_string;
	gboolean _tmp129_ = FALSE;
	gchar* _tmp162_;
	gchar* _tmp163_;
	gchar* retweeted_by_string;
	gboolean _tmp164_ = FALSE;
	gchar* _tmp185_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (_stream != NULL);
	g_return_if_fail (_sender != NULL);
	g_return_if_fail (_sender_nick != NULL);
	g_return_if_fail (_timestamp != NULL);
	g_return_if_fail (_message != NULL);
	g_return_if_fail (_html != NULL);
	g_return_if_fail (_icon_uri != NULL);
	g_return_if_fail (_url != NULL);
	g_return_if_fail (_source != NULL);
	g_return_if_fail (_timestring != NULL);
	g_return_if_fail (_reply_nick != NULL);
	g_return_if_fail (_reply_name != NULL);
	g_return_if_fail (_reply_url != NULL);
	g_return_if_fail (_retweet_nick != NULL);
	g_return_if_fail (_retweet_name != NULL);
	g_return_if_fail (_retweet_id != NULL);
	g_return_if_fail (_link_picture != NULL);
	g_return_if_fail (_link_name != NULL);
	g_return_if_fail (_link_url != NULL);
	g_return_if_fail (_link_desc != NULL);
	g_return_if_fail (_link_caption != NULL);
	g_return_if_fail (_link_icon != NULL);
	g_return_if_fail (_img_url != NULL);
	g_return_if_fail (_img_src != NULL);
	g_return_if_fail (_img_thumb != NULL);
	g_return_if_fail (_img_name != NULL);
	g_return_if_fail (_video_picture != NULL);
	g_return_if_fail (_video_src != NULL);
	g_return_if_fail (_video_url != NULL);
	g_return_if_fail (_video_name != NULL);
	g_return_if_fail (_comments != NULL);
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_data2_->self = g_object_ref (self);
	_data2_->_stream = g_strdup (_stream);
	_data2_->_html = g_strdup (_html);
	_data2_->_icon_uri = g_strdup (_icon_uri);
	_data2_->_img_url = g_strdup (_img_url);
	_data2_->_img_name = g_strdup (_img_name);
	gtk_widget_hide ((GtkWidget*) self->priv->icon);
	gtk_widget_hide ((GtkWidget*) self->priv->action_box);
	gtk_widget_set_no_show_all ((GtkWidget*) self->priv->action_box, TRUE);
	gtk_widget_set_no_show_all ((GtkWidget*) self->priv->comments_box, TRUE);
	gtk_widget_hide ((GtkWidget*) self->priv->comments_box);
	gtk_widget_set_no_show_all ((GtkWidget*) self->priv->thumb_box, TRUE);
	gtk_widget_hide ((GtkWidget*) self->priv->thumb_box);
	gtk_widget_hide ((GtkWidget*) self->priv->thumbnail);
	gtk_label_set_markup (self->priv->message, "");
	gtk_label_set_markup (self->priv->name, "");
	gtk_image_set_from_icon_name ((GtkImage*) self->priv->icon, "stock_person", GTK_ICON_SIZE_DIALOG);
	gtk_widget_show ((GtkWidget*) self->priv->icon);
	_g_free0 (self->priv->img_uri);
	self->priv->img_uri = NULL;
	_g_free0 (self->priv->img_src);
	self->priv->img_src = NULL;
	if (self->priv->img_id > 0) {
		g_source_remove (self->priv->img_id);
	}
	self->priv->img_id = (guint) 0;
	_tmp0_ = g_strdup (_img_src);
	_g_free0 (self->priv->img_uri);
	self->priv->img_uri = _tmp0_;
	if (g_strcmp0 (_data2_->_stream, "images") == 0) {
		gboolean _tmp1_ = FALSE;
		gchar* _tmp4_;
		if (_img_thumb != NULL) {
			gint _tmp2_;
			_tmp2_ = strlen (_img_thumb);
			_tmp1_ = _tmp2_ > 0;
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			gchar* _tmp3_;
			_tmp3_ = g_strdup (_img_thumb);
			_g_free0 (self->priv->img_uri);
			self->priv->img_uri = _tmp3_;
		}
		_tmp4_ = g_strdup (_data2_->_img_url);
		_g_free0 (self->priv->img_src);
		self->priv->img_src = _tmp4_;
	} else {
		if (g_strcmp0 (_data2_->_stream, "links") == 0) {
			gchar* _tmp5_;
			gchar* _tmp6_;
			_tmp5_ = g_strdup (_link_picture);
			_g_free0 (self->priv->img_uri);
			self->priv->img_uri = _tmp5_;
			_tmp6_ = g_strdup (_link_url);
			_g_free0 (self->priv->img_src);
			self->priv->img_src = _tmp6_;
		} else {
			if (g_strcmp0 (_data2_->_stream, "videos") == 0) {
				gchar* _tmp7_;
				gchar* _tmp8_;
				_tmp7_ = g_strdup (_video_picture);
				_g_free0 (self->priv->img_uri);
				self->priv->img_uri = _tmp7_;
				_tmp8_ = g_strdup (_video_src);
				_g_free0 (self->priv->img_src);
				self->priv->img_src = _tmp8_;
			}
		}
	}
	if (g_strcmp0 (_data2_->_stream, "private") == 0) {
		gtk_widget_show ((GtkWidget*) self->priv->private);
	} else {
		gtk_widget_hide ((GtkWidget*) self->priv->private);
	}
	{
		GList* _to_disconnect_id_collection;
		GList* _to_disconnect_id_it;
		_to_disconnect_id_collection = self->priv->_to_disconnect;
		for (_to_disconnect_id_it = _to_disconnect_id_collection; _to_disconnect_id_it != NULL; _to_disconnect_id_it = _to_disconnect_id_it->next) {
			guint _to_disconnect_id;
			_to_disconnect_id = GPOINTER_TO_UINT (_to_disconnect_id_it->data);
			{
				g_source_remove (_to_disconnect_id);
				self->priv->_to_disconnect = g_list_remove (self->priv->_to_disconnect, GUINT_TO_POINTER (_to_disconnect_id));
			}
		}
	}
	_tmp9_ = gtk_container_get_children ((GtkContainer*) self->priv->comments_box);
	{
		GList* w_collection;
		GList* w_it;
		w_collection = _tmp9_;
		for (w_it = w_collection; w_it != NULL; w_it = w_it->next) {
			GtkWidget* w;
			w = (GtkWidget*) w_it->data;
			{
				if (GTK_IS_WIDGET (w)) {
					gtk_widget_destroy (w);
				}
			}
		}
		_g_list_free0 (w_collection);
	}
	if (_comments != NULL) {
		JsonParser* _tmp10_ = NULL;
		JsonParser* parser;
		JsonNode* comments_node;
		JsonNode* _tmp11_ = NULL;
		_tmp10_ = json_parser_new ();
		parser = _tmp10_;
		json_parser_load_from_data (parser, _comments, (gssize) (-1), &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (parser);
			block2_data_unref (_data2_);
			_data2_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		comments_node = NULL;
		_tmp11_ = json_parser_get_root (parser);
		comments_node = _tmp11_;
		if (comments_node != NULL) {
			JsonObject* _tmp12_ = NULL;
			JsonObject* _tmp13_;
			JsonObject* comments_obj;
			_tmp12_ = json_node_get_object (comments_node);
			_tmp13_ = _json_object_ref0 (_tmp12_);
			comments_obj = _tmp13_;
			if (comments_obj != NULL) {
				gboolean _tmp14_;
				_tmp14_ = json_object_has_member (comments_obj, "comments");
				if (_tmp14_) {
					JsonArray* _tmp15_ = NULL;
					JsonArray* _tmp16_;
					JsonArray* comments;
					_tmp15_ = json_object_get_array_member (comments_obj, "comments");
					_tmp16_ = _json_array_ref0 (_tmp15_);
					comments = _tmp16_;
					{
						gint i;
						i = 0;
						{
							gboolean _tmp17_;
							_tmp17_ = TRUE;
							while (TRUE) {
								guint _tmp18_;
								JsonNode* _tmp19_ = NULL;
								JsonObject* _tmp20_ = NULL;
								JsonObject* _tmp21_;
								JsonObject* obj;
								if (!_tmp17_) {
									i++;
								}
								_tmp17_ = FALSE;
								_tmp18_ = json_array_get_length (comments);
								if (!(i < _tmp18_)) {
									break;
								}
								_tmp19_ = json_array_get_element (comments, (guint) i);
								_tmp20_ = json_node_get_object (_tmp19_);
								_tmp21_ = _json_object_ref0 (_tmp20_);
								obj = _tmp21_;
								if (obj != NULL) {
									Block3Data* _data3_;
									GtkVBox* _tmp22_ = NULL;
									GtkVBox* cvbox;
									GtkHBox* _tmp23_ = NULL;
									GtkHBox* chbox;
									GtkAlignment* _tmp24_ = NULL;
									GtkAlignment* clalignment;
									GwibberGtkStreamViewAvatar* _tmp25_ = NULL;
									gboolean _tmp26_;
									gboolean _tmp34_;
									_data3_ = g_slice_new0 (Block3Data);
									_data3_->_ref_count_ = 1;
									_data3_->_data2_ = block2_data_ref (_data2_);
									_tmp22_ = (GtkVBox*) gtk_vbox_new (FALSE, 2);
									cvbox = g_object_ref_sink (_tmp22_);
									_tmp23_ = (GtkHBox*) gtk_hbox_new (FALSE, 2);
									chbox = g_object_ref_sink (_tmp23_);
									_tmp24_ = (GtkAlignment*) gtk_alignment_new (0.5f, 0.0f, 0.0f, 0.0f);
									clalignment = g_object_ref_sink (_tmp24_);
									gtk_box_pack_start ((GtkBox*) chbox, (GtkWidget*) clalignment, FALSE, FALSE, (guint) 0);
									_tmp25_ = gwibber_gtk_stream_view_avatar_new ();
									_data3_->cicon = g_object_ref_sink (_tmp25_);
									gtk_container_add ((GtkContainer*) clalignment, (GtkWidget*) _data3_->cicon);
									gtk_box_pack_start ((GtkBox*) self->priv->comments_box, (GtkWidget*) chbox, FALSE, FALSE, (guint) 2);
									gtk_box_pack_start ((GtkBox*) chbox, (GtkWidget*) cvbox, FALSE, FALSE, (guint) 2);
									_tmp26_ = json_object_has_member (obj, "text");
									if (_tmp26_) {
										const gchar* _tmp27_ = NULL;
										gchar* _tmp28_;
										gchar* ctext;
										GtkLabel* _tmp29_ = NULL;
										GtkLabel* ctext_label;
										gchar* _tmp30_;
										gchar* _tmp31_;
										gchar* _tmp32_;
										gchar* _tmp33_;
										_tmp27_ = json_object_get_string_member (obj, "text");
										_tmp28_ = g_strdup (_tmp27_);
										ctext = _tmp28_;
										_tmp29_ = (GtkLabel*) gtk_label_new ("");
										ctext_label = g_object_ref_sink (_tmp29_);
										gtk_label_set_selectable (ctext_label, TRUE);
										gtk_label_set_single_line_mode (ctext_label, FALSE);
										gtk_label_set_line_wrap (ctext_label, TRUE);
										gtk_label_set_line_wrap_mode (ctext_label, PANGO_WRAP_WORD_CHAR);
										gtk_misc_set_alignment ((GtkMisc*) ctext_label, 0.0f, 0.0f);
										_tmp30_ = g_strconcat ("<span font_size='small'>", ctext, NULL);
										_tmp31_ = _tmp30_;
										_tmp32_ = g_strconcat (_tmp31_, "</span>", NULL);
										_tmp33_ = _tmp32_;
										gtk_label_set_markup (ctext_label, _tmp33_);
										_g_free0 (_tmp33_);
										_g_free0 (_tmp31_);
										gtk_box_pack_end ((GtkBox*) cvbox, (GtkWidget*) ctext_label, FALSE, FALSE, (guint) 2);
										_g_object_unref0 (ctext_label);
										_g_free0 (ctext);
									}
									_tmp34_ = json_object_has_member (obj, "sender");
									if (_tmp34_) {
										JsonObject* _tmp35_ = NULL;
										JsonObject* _tmp36_;
										JsonObject* _sender_obj;
										_tmp35_ = json_object_get_object_member (obj, "sender");
										_tmp36_ = _json_object_ref0 (_tmp35_);
										_sender_obj = _tmp36_;
										if (_sender_obj != NULL) {
											gboolean _tmp37_;
											gboolean _tmp46_;
											_tmp37_ = json_object_has_member (_sender_obj, "name");
											if (_tmp37_) {
												const gchar* _tmp38_ = NULL;
												gchar* _tmp39_;
												gchar* cname;
												GtkHBox* _tmp40_ = NULL;
												GtkHBox* cname_box;
												GtkLabel* _tmp41_ = NULL;
												GtkLabel* cname_label;
												gchar* _tmp42_;
												gchar* _tmp43_;
												gchar* _tmp44_;
												gchar* _tmp45_;
												_tmp38_ = json_object_get_string_member (_sender_obj, "name");
												_tmp39_ = g_strdup (_tmp38_);
												cname = _tmp39_;
												_tmp40_ = (GtkHBox*) gtk_hbox_new (FALSE, 2);
												cname_box = g_object_ref_sink (_tmp40_);
												_tmp41_ = (GtkLabel*) gtk_label_new ("");
												cname_label = g_object_ref_sink (_tmp41_);
												_tmp42_ = g_strconcat ("<b><span font_size='small'>", cname, NULL);
												_tmp43_ = _tmp42_;
												_tmp44_ = g_strconcat (_tmp43_, "</span></b>", NULL);
												_tmp45_ = _tmp44_;
												gtk_label_set_markup (cname_label, _tmp45_);
												_g_free0 (_tmp45_);
												_g_free0 (_tmp43_);
												gtk_box_pack_start ((GtkBox*) cname_box, (GtkWidget*) cname_label, FALSE, FALSE, (guint) 2);
												gtk_box_pack_end ((GtkBox*) cvbox, (GtkWidget*) cname_box, FALSE, FALSE, (guint) 2);
												_g_object_unref0 (cname_label);
												_g_object_unref0 (cname_box);
												_g_free0 (cname);
											}
											_tmp46_ = json_object_has_member (_sender_obj, "image");
											if (_tmp46_) {
												Block4Data* _data4_;
												const gchar* _tmp47_ = NULL;
												gchar* _tmp48_;
												gchar* _tmp49_ = NULL;
												gchar* cached_cicon;
												_data4_ = g_slice_new0 (Block4Data);
												_data4_->_ref_count_ = 1;
												_data4_->_data3_ = block3_data_ref (_data3_);
												_tmp47_ = json_object_get_string_member (_sender_obj, "image");
												_tmp48_ = g_strdup (_tmp47_);
												_data4_->cimage = _tmp48_;
												_tmp49_ = gwibber_utils_avatar_path (self->priv->_utils, _data4_->cimage);
												cached_cicon = _tmp49_;
												if (cached_cicon != NULL) {
													gtk_image_set_from_file ((GtkImage*) _data3_->cicon, cached_cicon);
												} else {
													guint _tmp50_;
													guint cid;
													gtk_image_set_from_icon_name ((GtkImage*) _data3_->cicon, "stock_person", GTK_ICON_SIZE_DIALOG);
													gtk_widget_show ((GtkWidget*) _data3_->cicon);
													_tmp50_ = g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, __lambda16__gsource_func, block4_data_ref (_data4_), block4_data_unref);
													cid = _tmp50_;
													self->priv->_to_disconnect = g_list_append (self->priv->_to_disconnect, GUINT_TO_POINTER (cid));
												}
												_g_free0 (cached_cicon);
												block4_data_unref (_data4_);
												_data4_ = NULL;
											}
										}
										_json_object_unref0 (_sender_obj);
									}
									gtk_widget_set_no_show_all ((GtkWidget*) self->priv->comments_box, FALSE);
									gtk_widget_show_all ((GtkWidget*) self->priv->comments_box);
									_g_object_unref0 (clalignment);
									_g_object_unref0 (chbox);
									_g_object_unref0 (cvbox);
									block3_data_unref (_data3_);
									_data3_ = NULL;
								}
								_json_object_unref0 (obj);
							}
						}
					}
					_json_array_unref0 (comments);
				}
			}
			_json_object_unref0 (comments_obj);
		}
		_g_object_unref0 (parser);
	}
	_tmp51_ = g_strdup (_sender);
	display_name = _tmp51_;
	if (self->priv->_show_fullname) {
		gint _tmp53_;
		_tmp53_ = strlen (_sender);
		_tmp52_ = _tmp53_ > 0;
	} else {
		_tmp52_ = FALSE;
	}
	if (_tmp52_) {
		gchar* _tmp54_;
		_tmp54_ = g_strdup (_sender);
		_g_free0 (display_name);
		display_name = _tmp54_;
	} else {
		gint _tmp55_;
		_tmp55_ = strlen (_sender_nick);
		if (_tmp55_ > 0) {
			gchar* _tmp56_;
			_tmp56_ = g_strdup (_sender_nick);
			_g_free0 (display_name);
			display_name = _tmp56_;
		}
	}
	_tmp57_ = g_strconcat ("<b>", display_name, NULL);
	_tmp58_ = _tmp57_;
	_tmp59_ = g_strconcat (_tmp58_, "</b>", NULL);
	_tmp60_ = _tmp59_;
	gtk_label_set_markup (self->priv->name, _tmp60_);
	_g_free0 (_tmp60_);
	_g_free0 (_tmp58_);
	_tmp62_ = strlen (_sender_nick);
	if (_tmp62_ > 0) {
		gchar* _tmp63_;
		_tmp63_ = g_strconcat ("@", _sender_nick, NULL);
		_g_free0 (_tmp61_);
		_tmp61_ = _tmp63_;
	} else {
		gchar* _tmp64_;
		_tmp64_ = g_strdup ("");
		_g_free0 (_tmp61_);
		_tmp61_ = _tmp64_;
	}
	_tmp65_ = g_strdup (_tmp61_);
	_g_free0 (self->priv->sender);
	self->priv->sender = _tmp65_;
	icon_displayed = NULL;
	icon_displayed_length1 = 0;
	_icon_displayed_size_ = 0;
	_tmp66_ = gtk_container_get_children ((GtkContainer*) self->priv->action_box);
	{
		GList* _p_collection;
		GList* _p_it;
		_p_collection = _tmp66_;
		for (_p_it = _p_collection; _p_it != NULL; _p_it = _p_it->next) {
			GtkWidget* _p;
			_p = (GtkWidget*) _p_it->data;
			{
				GtkWidget* _tmp67_;
				GwibberGtkActionBoxItem* _tmp68_;
				GwibberGtkActionBoxItem* _i;
				GList* _tmp69_ = NULL;
				_tmp67_ = _p;
				_tmp68_ = _g_object_ref0 (GWIBBER_GTK_IS_ACTION_BOX_ITEM (_tmp67_) ? ((GwibberGtkActionBoxItem*) _tmp67_) : NULL);
				_i = _tmp68_;
				_tmp69_ = gtk_container_get_children ((GtkContainer*) _i);
				{
					GList* _w_collection;
					GList* _w_it;
					_w_collection = _tmp69_;
					for (_w_it = _w_collection; _w_it != NULL; _w_it = _w_it->next) {
						GtkWidget* _w;
						_w = (GtkWidget*) _w_it->data;
						{
							if (GTK_IS_MENU (_w)) {
								GtkWidget* _tmp70_;
								GtkMenu* _tmp71_;
								GtkMenu* _y;
								GList* _tmp72_ = NULL;
								_tmp70_ = _w;
								_tmp71_ = _g_object_ref0 (GTK_IS_MENU (_tmp70_) ? ((GtkMenu*) _tmp70_) : NULL);
								_y = _tmp71_;
								_tmp72_ = gtk_container_get_children ((GtkContainer*) _y);
								{
									GList* _x_collection;
									GList* _x_it;
									_x_collection = _tmp72_;
									for (_x_it = _x_collection; _x_it != NULL; _x_it = _x_it->next) {
										GtkWidget* _x;
										_x = (GtkWidget*) _x_it->data;
										{
											gtk_container_remove ((GtkContainer*) _y, _x);
											gtk_widget_destroy (_x);
											_x = NULL;
										}
									}
									_g_list_free0 (_x_collection);
								}
								_g_object_unref0 (_y);
							}
							gtk_container_remove ((GtkContainer*) _i, _w);
							gtk_widget_destroy (_w);
							_w = NULL;
						}
					}
					_g_list_free0 (_w_collection);
				}
				gtk_container_remove ((GtkContainer*) self->priv->action_box, (GtkWidget*) _i);
				gtk_widget_destroy ((GtkWidget*) _i);
				g_object_run_dispose ((GObject*) _i);
				_g_object_unref0 (_i);
				_i = NULL;
				_g_object_unref0 (_i);
			}
		}
		_g_list_free0 (_p_collection);
	}
	{
		gchar** _a_collection;
		int _a_collection_length1;
		int _a_it;
		_a_collection = _accounts;
		_a_collection_length1 = _accounts_length1;
		for (_a_it = 0; _a_it < _accounts_length1; _a_it = _a_it + 1) {
			gchar* _tmp73_;
			gchar* _a;
			_tmp73_ = g_strdup (_a_collection[_a_it]);
			_a = _tmp73_;
			{
				gchar* _account = NULL;
				gchar* _service = NULL;
				gchar* _mid = NULL;
				gchar** _tmp74_;
				gchar** _tmp75_ = NULL;
				gchar** _tmp76_;
				gint _tmp76__length1;
				gint __tmp76__size_;
				gchar* _tmp77_;
				gchar* _tmp78_;
				gchar* _tmp79_;
				gchar* _tmp80_;
				GwibberGtkActionBoxItem* _tmp81_ = NULL;
				GwibberGtkActionBoxItem* action_item;
				_tmp75_ = _tmp74_ = g_strsplit (_a, ":", 0);
				_tmp76_ = _tmp75_;
				_tmp76__length1 = _vala_array_length (_tmp74_);
				__tmp76__size_ = _vala_array_length (_tmp74_);
				_tmp77_ = g_strdup (_tmp76_[0]);
				_g_free0 (_account);
				_account = _tmp77_;
				_tmp78_ = g_strdup (_tmp76_[1]);
				_g_free0 (_service);
				_service = _tmp78_;
				_tmp79_ = g_strdup (_tmp76_[2]);
				_g_free0 (_mid);
				_mid = _tmp79_;
				if (_vala_string_array_contains (icon_displayed, icon_displayed_length1, _account)) {
					_tmp76_ = (_vala_array_free (_tmp76_, _tmp76__length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (_mid);
					_g_free0 (_service);
					_g_free0 (_account);
					_g_free0 (_a);
					continue;
				}
				_tmp80_ = g_strdup (_account);
				_vala_array_add1 (&icon_displayed, &icon_displayed_length1, &_icon_displayed_size_, _tmp80_);
				_tmp81_ = gwibber_gtk_action_box_item_new (_service, _data2_->_stream, _account, _mid, self->priv->sender, "");
				action_item = g_object_ref_sink (_tmp81_);
				gtk_container_add ((GtkContainer*) self->priv->action_box, (GtkWidget*) action_item);
				g_signal_connect_object (action_item, "reply", (GCallback) __lambda17__gwibber_gtk_action_box_item_reply, self, 0);
				_g_object_unref0 (action_item);
				_tmp76_ = (_vala_array_free (_tmp76_, _tmp76__length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (_mid);
				_g_free0 (_service);
				_g_free0 (_account);
				_g_free0 (_a);
			}
		}
	}
	if (_from_me) {
		gtk_widget_reparent ((GtkWidget*) self->priv->icon_box, (GtkWidget*) self->priv->ralignment);
	} else {
		gtk_widget_reparent ((GtkWidget*) self->priv->icon_box, (GtkWidget*) self->priv->lalignment);
	}
	if (self->priv->_cache_avatar_id > 0) {
		g_source_remove (self->priv->_cache_avatar_id);
	}
	_tmp82_ = gwibber_utils_avatar_path (self->priv->_utils, _data2_->_icon_uri);
	_avatar_cache_image = _tmp82_;
	if (_avatar_cache_image != NULL) {
		gtk_image_set_from_file ((GtkImage*) self->priv->icon, _avatar_cache_image);
	} else {
		guint _tmp83_;
		gtk_image_set_from_icon_name ((GtkImage*) self->priv->icon, "stock_person", GTK_ICON_SIZE_DIALOG);
		_tmp83_ = g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, __lambda18__gsource_func, block2_data_ref (_data2_), block2_data_unref);
		self->priv->_cache_avatar_id = _tmp83_;
	}
	if (g_strcmp0 (_data2_->_stream, "user") == 0) {
		gtk_widget_set_no_show_all ((GtkWidget*) self->priv->icon_box, TRUE);
		gtk_widget_hide ((GtkWidget*) self->priv->icon_box);
	} else {
		gtk_widget_set_no_show_all ((GtkWidget*) self->priv->icon_box, FALSE);
		gtk_widget_show ((GtkWidget*) self->priv->icon_box);
	}
	_tmp84_ = g_strdup (_url);
	_g_free0 (self->priv->url);
	self->priv->url = _tmp84_;
	g_signal_parse_name ("button-press-event", GTK_TYPE_WIDGET, &_tmp85_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((GtkWidget*) self->priv->icon_box, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp85_, 0, NULL, (GCallback) _gwibber_gtk_stream_view_tile_on_avatar_click_gtk_widget_button_press_event, self);
	g_signal_connect_object ((GtkWidget*) self->priv->icon_box, "button-press-event", (GCallback) _gwibber_gtk_stream_view_tile_on_avatar_click_gtk_widget_button_press_event, self, 0);
	if (((gint) _likes) == 0) {
		gtk_widget_hide ((GtkWidget*) self->priv->likes_hbox);
		gtk_widget_set_no_show_all ((GtkWidget*) self->priv->likes_hbox, TRUE);
	} else {
		if (((gint) _likes) < 0) {
			gtk_label_set_markup (self->priv->likes_count, "");
			gtk_widget_set_no_show_all ((GtkWidget*) self->priv->likes_hbox, FALSE);
			gtk_widget_show_all ((GtkWidget*) self->priv->likes_hbox);
		} else {
			if (((gint) _likes) == 1) {
				gchar* _tmp86_ = NULL;
				gchar* _tmp87_;
				gchar* _tmp88_;
				gchar* _tmp89_;
				gchar* _tmp90_;
				gchar* _tmp91_;
				const gchar* _tmp92_ = NULL;
				gchar* _tmp93_;
				gchar* _tmp94_;
				gchar* _tmp95_;
				gchar* _tmp96_;
				_tmp86_ = double_to_string (_likes);
				_tmp87_ = _tmp86_;
				_tmp88_ = g_strconcat ("<span font_size='small'>", _tmp87_, NULL);
				_tmp89_ = _tmp88_;
				_tmp90_ = g_strconcat (_tmp89_, " ", NULL);
				_tmp91_ = _tmp90_;
				_tmp92_ = _ ("person liked this");
				_tmp93_ = g_strconcat (_tmp91_, _tmp92_, NULL);
				_tmp94_ = _tmp93_;
				_tmp95_ = g_strconcat (_tmp94_, "</span>", NULL);
				_tmp96_ = _tmp95_;
				gtk_label_set_markup (self->priv->likes_count, _tmp96_);
				_g_free0 (_tmp96_);
				_g_free0 (_tmp94_);
				_g_free0 (_tmp91_);
				_g_free0 (_tmp89_);
				_g_free0 (_tmp87_);
				gtk_widget_set_no_show_all ((GtkWidget*) self->priv->likes_hbox, FALSE);
				gtk_widget_show_all ((GtkWidget*) self->priv->likes_hbox);
			} else {
				if (((gint) _likes) > 1) {
					gchar* _tmp97_ = NULL;
					gchar* _tmp98_;
					gchar* _tmp99_;
					gchar* _tmp100_;
					gchar* _tmp101_;
					gchar* _tmp102_;
					const gchar* _tmp103_ = NULL;
					gchar* _tmp104_;
					gchar* _tmp105_;
					gchar* _tmp106_;
					gchar* _tmp107_;
					_tmp97_ = double_to_string (_likes);
					_tmp98_ = _tmp97_;
					_tmp99_ = g_strconcat ("<span font_size='small'>", _tmp98_, NULL);
					_tmp100_ = _tmp99_;
					_tmp101_ = g_strconcat (_tmp100_, " ", NULL);
					_tmp102_ = _tmp101_;
					_tmp103_ = _ ("people liked this");
					_tmp104_ = g_strconcat (_tmp102_, _tmp103_, NULL);
					_tmp105_ = _tmp104_;
					_tmp106_ = g_strconcat (_tmp105_, "</span>", NULL);
					_tmp107_ = _tmp106_;
					gtk_label_set_markup (self->priv->likes_count, _tmp107_);
					_g_free0 (_tmp107_);
					_g_free0 (_tmp105_);
					_g_free0 (_tmp102_);
					_g_free0 (_tmp100_);
					_g_free0 (_tmp98_);
					gtk_widget_set_no_show_all ((GtkWidget*) self->priv->likes_hbox, FALSE);
					gtk_widget_show_all ((GtkWidget*) self->priv->likes_hbox);
				}
			}
		}
	}
	gtk_label_set_markup (self->priv->message, _data2_->_html);
	_data2_->link_str = NULL;
	if (g_strcmp0 (_data2_->_stream, "links") == 0) {
		gchar* _tmp108_;
		gchar* _tmp109_;
		gchar* _tmp110_;
		gchar* _tmp111_;
		gchar* _tmp112_;
		gchar* _tmp113_;
		gchar* _tmp114_;
		gchar* _tmp115_;
		_tmp108_ = g_strconcat ("<a href='", _link_url, NULL);
		_tmp109_ = _tmp108_;
		_tmp110_ = g_strconcat (_tmp109_, "'>", NULL);
		_tmp111_ = _tmp110_;
		_tmp112_ = g_strconcat (_tmp111_, _link_name, NULL);
		_tmp113_ = _tmp112_;
		_tmp114_ = g_strconcat (_tmp113_, "</a>\n", NULL);
		_g_free0 (_data2_->link_str);
		_data2_->link_str = _tmp114_;
		_g_free0 (_tmp113_);
		_g_free0 (_tmp111_);
		_g_free0 (_tmp109_);
		_tmp115_ = g_strconcat (_data2_->link_str, _link_desc, NULL);
		_g_free0 (_data2_->link_str);
		_data2_->link_str = _tmp115_;
		gtk_label_set_markup (self->priv->message, _data2_->link_str);
	}
	_data2_->video_str = NULL;
	if (g_strcmp0 (_data2_->_stream, "videos") == 0) {
		gchar* _tmp116_;
		gchar* _tmp117_;
		gchar* _tmp118_;
		gchar* _tmp119_;
		gchar* _tmp120_;
		gchar* _tmp121_;
		gchar* _tmp122_;
		gchar* _tmp123_;
		_tmp116_ = g_strconcat ("<a href='", _video_url, NULL);
		_tmp117_ = _tmp116_;
		_tmp118_ = g_strconcat (_tmp117_, "'>", NULL);
		_tmp119_ = _tmp118_;
		_tmp120_ = g_strconcat (_tmp119_, _video_name, NULL);
		_tmp121_ = _tmp120_;
		_tmp122_ = g_strconcat (_tmp121_, "</a>\n", NULL);
		_g_free0 (_data2_->video_str);
		_data2_->video_str = _tmp122_;
		_g_free0 (_tmp121_);
		_g_free0 (_tmp119_);
		_g_free0 (_tmp117_);
		_tmp123_ = g_strconcat (_data2_->video_str, _data2_->_html, NULL);
		_g_free0 (_data2_->video_str);
		_data2_->video_str = _tmp123_;
		gtk_label_set_markup (self->priv->message, _data2_->video_str);
	}
	_tmp124_ = strlen (self->priv->img_uri);
	if (_tmp124_ > 0) {
		Block5Data* _data5_;
		guint _tmp125_;
		_data5_ = g_slice_new0 (Block5Data);
		_data5_->_ref_count_ = 1;
		_data5_->_data2_ = block2_data_ref (_data2_);
		_data5_->img_str = NULL;
		_tmp125_ = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 200, __lambda19__gsource_func, block5_data_ref (_data5_), block5_data_unref);
		self->priv->img_id = _tmp125_;
		block5_data_unref (_data5_);
		_data5_ = NULL;
	}
	_tmp126_ = atol (_timestamp);
	_tmp127_ = gwibber_utils_generate_time_string (self->priv->_utils, (guint) _tmp126_);
	_g_free0 (self->priv->time_string);
	self->priv->time_string = _tmp127_;
	gwibber_gtk_stream_view_tile_update_time_area_wrapper (self);
	gtk_widget_hide ((GtkWidget*) self->priv->reply_to);
	_tmp128_ = g_strdup ("<span font_weight='light' font_size='small' color='#999'>");
	reply_to_string = _tmp128_;
	if (self->priv->_show_fullname) {
		gboolean _tmp130_ = FALSE;
		if (_reply_name != NULL) {
			gint _tmp131_;
			_tmp131_ = strlen (_reply_name);
			_tmp130_ = _tmp131_ > 0;
		} else {
			_tmp130_ = FALSE;
		}
		_tmp129_ = _tmp130_;
	} else {
		_tmp129_ = FALSE;
	}
	if (_tmp129_) {
		const gchar* _tmp132_ = NULL;
		gchar* _tmp133_;
		gchar* _tmp134_;
		gchar* _tmp135_;
		gchar* _tmp136_;
		gchar* _tmp137_;
		gchar* _tmp138_;
		gchar* _tmp139_;
		gchar* _tmp140_;
		gchar* _tmp141_;
		gchar* _tmp142_;
		gchar* _tmp143_;
		gchar* _tmp144_;
		gchar* _tmp145_;
		_tmp132_ = _ ("in reply to");
		_tmp133_ = g_strconcat (" ", _tmp132_, NULL);
		_tmp134_ = _tmp133_;
		_tmp135_ = g_strconcat (_tmp134_, " <a href='", NULL);
		_tmp136_ = _tmp135_;
		_tmp137_ = g_strconcat (_tmp136_, _reply_url, NULL);
		_tmp138_ = _tmp137_;
		_tmp139_ = g_strconcat (_tmp138_, "'>", NULL);
		_tmp140_ = _tmp139_;
		_tmp141_ = g_strconcat (_tmp140_, _reply_name, NULL);
		_tmp142_ = _tmp141_;
		_tmp143_ = g_strconcat (_tmp142_, "</a>", NULL);
		_tmp144_ = _tmp143_;
		_tmp145_ = g_strconcat (reply_to_string, _tmp144_, NULL);
		_g_free0 (reply_to_string);
		reply_to_string = _tmp145_;
		_g_free0 (_tmp144_);
		_g_free0 (_tmp142_);
		_g_free0 (_tmp140_);
		_g_free0 (_tmp138_);
		_g_free0 (_tmp136_);
		_g_free0 (_tmp134_);
		gtk_widget_show ((GtkWidget*) self->priv->reply_to);
	} else {
		gboolean _tmp146_ = FALSE;
		if (_reply_nick != NULL) {
			gint _tmp147_;
			_tmp147_ = strlen (_reply_nick);
			_tmp146_ = _tmp147_ > 0;
		} else {
			_tmp146_ = FALSE;
		}
		if (_tmp146_) {
			const gchar* _tmp148_ = NULL;
			gchar* _tmp149_;
			gchar* _tmp150_;
			gchar* _tmp151_;
			gchar* _tmp152_;
			gchar* _tmp153_;
			gchar* _tmp154_;
			gchar* _tmp155_;
			gchar* _tmp156_;
			gchar* _tmp157_;
			gchar* _tmp158_;
			gchar* _tmp159_;
			gchar* _tmp160_;
			gchar* _tmp161_;
			_tmp148_ = _ ("in reply to");
			_tmp149_ = g_strconcat (" ", _tmp148_, NULL);
			_tmp150_ = _tmp149_;
			_tmp151_ = g_strconcat (_tmp150_, " <a href='", NULL);
			_tmp152_ = _tmp151_;
			_tmp153_ = g_strconcat (_tmp152_, _reply_url, NULL);
			_tmp154_ = _tmp153_;
			_tmp155_ = g_strconcat (_tmp154_, "'>", NULL);
			_tmp156_ = _tmp155_;
			_tmp157_ = g_strconcat (_tmp156_, _reply_nick, NULL);
			_tmp158_ = _tmp157_;
			_tmp159_ = g_strconcat (_tmp158_, "</a>", NULL);
			_tmp160_ = _tmp159_;
			_tmp161_ = g_strconcat (reply_to_string, _tmp160_, NULL);
			_g_free0 (reply_to_string);
			reply_to_string = _tmp161_;
			_g_free0 (_tmp160_);
			_g_free0 (_tmp158_);
			_g_free0 (_tmp156_);
			_g_free0 (_tmp154_);
			_g_free0 (_tmp152_);
			_g_free0 (_tmp150_);
			gtk_widget_show ((GtkWidget*) self->priv->reply_to);
		}
	}
	_tmp162_ = g_strconcat (reply_to_string, "</span>", NULL);
	_g_free0 (reply_to_string);
	reply_to_string = _tmp162_;
	gtk_label_set_markup (self->priv->reply_to, reply_to_string);
	gtk_widget_hide ((GtkWidget*) self->priv->retweeted_by);
	_tmp163_ = g_strdup ("<span font_weight='light' font_size='small' color='#999'>");
	retweeted_by_string = _tmp163_;
	if (self->priv->_show_fullname) {
		gboolean _tmp165_ = FALSE;
		if (_retweet_name != NULL) {
			gint _tmp166_;
			_tmp166_ = strlen (_retweet_name);
			_tmp165_ = _tmp166_ > 0;
		} else {
			_tmp165_ = FALSE;
		}
		_tmp164_ = _tmp165_;
	} else {
		_tmp164_ = FALSE;
	}
	if (_tmp164_) {
		const gchar* _tmp167_ = NULL;
		gchar* _tmp168_;
		gchar* _tmp169_;
		gchar* _tmp170_;
		gchar* _tmp171_;
		gchar* _tmp172_;
		gchar* _tmp173_;
		gchar* _tmp174_;
		_tmp167_ = _ ("shared by");
		_tmp168_ = g_strconcat (" ", _tmp167_, NULL);
		_tmp169_ = _tmp168_;
		_tmp170_ = g_strconcat (_tmp169_, " ", NULL);
		_tmp171_ = _tmp170_;
		_tmp172_ = g_strconcat (_tmp171_, _retweet_name, NULL);
		_tmp173_ = _tmp172_;
		_tmp174_ = g_strconcat (retweeted_by_string, _tmp173_, NULL);
		_g_free0 (retweeted_by_string);
		retweeted_by_string = _tmp174_;
		_g_free0 (_tmp173_);
		_g_free0 (_tmp171_);
		_g_free0 (_tmp169_);
		gtk_widget_show ((GtkWidget*) self->priv->retweeted_by);
	} else {
		gboolean _tmp175_ = FALSE;
		if (_retweet_nick != NULL) {
			gint _tmp176_;
			_tmp176_ = strlen (_retweet_nick);
			_tmp175_ = _tmp176_ > 0;
		} else {
			_tmp175_ = FALSE;
		}
		if (_tmp175_) {
			const gchar* _tmp177_ = NULL;
			gchar* _tmp178_;
			gchar* _tmp179_;
			gchar* _tmp180_;
			gchar* _tmp181_;
			gchar* _tmp182_;
			gchar* _tmp183_;
			gchar* _tmp184_;
			_tmp177_ = _ ("shared by");
			_tmp178_ = g_strconcat (" ", _tmp177_, NULL);
			_tmp179_ = _tmp178_;
			_tmp180_ = g_strconcat (_tmp179_, " ", NULL);
			_tmp181_ = _tmp180_;
			_tmp182_ = g_strconcat (_tmp181_, _retweet_nick, NULL);
			_tmp183_ = _tmp182_;
			_tmp184_ = g_strconcat (retweeted_by_string, _tmp183_, NULL);
			_g_free0 (retweeted_by_string);
			retweeted_by_string = _tmp184_;
			_g_free0 (_tmp183_);
			_g_free0 (_tmp181_);
			_g_free0 (_tmp179_);
			gtk_widget_show ((GtkWidget*) self->priv->retweeted_by);
		}
	}
	_tmp185_ = g_strconcat (retweeted_by_string, "</span>", NULL);
	_g_free0 (retweeted_by_string);
	retweeted_by_string = _tmp185_;
	gtk_label_set_markup (self->priv->retweeted_by, retweeted_by_string);
	gtk_widget_queue_resize ((GtkWidget*) self);
	gtk_widget_show ((GtkWidget*) self);
	_g_free0 (retweeted_by_string);
	_g_free0 (reply_to_string);
	_g_free0 (_avatar_cache_image);
	icon_displayed = (_vala_array_free (icon_displayed, icon_displayed_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (_tmp61_);
	_g_free0 (display_name);
	block2_data_unref (_data2_);
	_data2_ = NULL;
}


static void gwibber_gtk_stream_view_tile_load_avatar_async_data_free (gpointer _data) {
	GwibberGtkStreamViewTileLoadAvatarAsyncData* data;
	data = _data;
	_g_free0 (data->url);
	_g_object_unref0 (data->cicon);
	_g_object_unref0 (data->self);
	g_slice_free (GwibberGtkStreamViewTileLoadAvatarAsyncData, data);
}


static void gwibber_gtk_stream_view_tile_load_avatar_async (GwibberGtkStreamViewTile* self, const gchar* url, GtkImage* cicon, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	GwibberGtkStreamViewTileLoadAvatarAsyncData* _data_;
	_data_ = g_slice_new0 (GwibberGtkStreamViewTileLoadAvatarAsyncData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, gwibber_gtk_stream_view_tile_load_avatar_async);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, gwibber_gtk_stream_view_tile_load_avatar_async_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->url = g_strdup (url);
	_data_->cicon = _g_object_ref0 (cicon);
	gwibber_gtk_stream_view_tile_load_avatar_async_co (_data_);
}


static void gwibber_gtk_stream_view_tile_load_avatar_finish (GwibberGtkStreamViewTile* self, GAsyncResult* _res_) {
	GwibberGtkStreamViewTileLoadAvatarAsyncData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void gwibber_gtk_stream_view_tile_load_avatar_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	GwibberGtkStreamViewTileLoadAvatarAsyncData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	gwibber_gtk_stream_view_tile_load_avatar_async_co (data);
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	GRegex* _tmp2_ = NULL;
	GRegex* _tmp3_;
	GRegex* regex;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	_tmp0_ = g_regex_escape_string (old, -1);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_regex_new (_tmp1_, 0, 0, &_inner_error_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	regex = _tmp3_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_REGEX_ERROR) {
			goto __catch4_g_regex_error;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp4_ = g_regex_replace_literal (regex, self, (gssize) (-1), 0, replacement, 0, &_inner_error_);
	_tmp5_ = _tmp4_;
	if (_inner_error_ != NULL) {
		_g_regex_unref0 (regex);
		if (_inner_error_->domain == G_REGEX_ERROR) {
			goto __catch4_g_regex_error;
		}
		_g_regex_unref0 (regex);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	result = _tmp5_;
	_g_regex_unref0 (regex);
	return result;
	_g_regex_unref0 (regex);
	goto __finally4;
	__catch4_g_regex_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally4:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static gboolean gwibber_gtk_stream_view_tile_load_avatar_async_co (GwibberGtkStreamViewTileLoadAvatarAsyncData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_tmp0_ = NULL;
	data->_tmp0_ = g_file_new_for_uri (data->url);
	data->file = data->_tmp0_;
	data->_state_ = 1;
	g_file_read_async (data->file, G_PRIORITY_DEFAULT, data->self->priv->cancellable, gwibber_gtk_stream_view_tile_load_avatar_async_ready, data);
	return FALSE;
	_state_1:
	data->_tmp1_ = NULL;
	data->_tmp1_ = g_file_read_finish (data->file, data->_res_, &data->_inner_error_);
	data->stream = data->_tmp1_;
	if (data->_inner_error_ != NULL) {
		goto __catch3_g_error;
	}
	data->pixbuf = NULL;
	data->_tmp2_ = NULL;
	data->_tmp2_ = gdk_pixbuf_new_from_stream_at_scale ((GInputStream*) data->stream, 48, 48, FALSE, data->self->priv->cancellable, &data->_inner_error_);
	data->_tmp3_ = data->_tmp2_;
	if (data->_inner_error_ != NULL) {
		_g_object_unref0 (data->pixbuf);
		_g_object_unref0 (data->stream);
		goto __catch3_g_error;
	}
	_g_object_unref0 (data->pixbuf);
	data->pixbuf = data->_tmp3_;
	if (GDK_IS_PIXBUF (data->pixbuf)) {
		gtk_image_set_from_pixbuf (data->cicon, data->pixbuf);
		gtk_widget_show ((GtkWidget*) data->cicon);
		data->_tmp4_ = NULL;
		data->_tmp4_ = g_get_user_cache_dir ();
		data->_tmp5_ = NULL;
		data->_tmp5_ = string_replace (data->url, "/", "");
		data->_tmp6_ = data->_tmp5_;
		data->_tmp7_ = NULL;
		data->_tmp7_ = g_build_path (G_DIR_SEPARATOR_S, data->_tmp4_, "gwibber/avatars", data->_tmp6_, NULL);
		data->_tmp8_ = data->_tmp7_;
		_g_free0 (data->_tmp6_);
		data->cimage = data->_tmp8_;
		data->_tmp9_ = g_strdup ("png");
		_g_free0 (data->t);
		data->t = data->_tmp9_;
		data->_tmp12_ = g_str_has_suffix (data->cimage, "JPG");
		if (data->_tmp12_) {
			data->_tmp11_ = TRUE;
		} else {
			data->_tmp13_ = g_str_has_suffix (data->cimage, "jpeg");
			data->_tmp11_ = data->_tmp13_;
		}
		if (data->_tmp11_) {
			data->_tmp10_ = TRUE;
		} else {
			data->_tmp14_ = g_str_has_suffix (data->cimage, "jpg");
			data->_tmp10_ = data->_tmp14_;
		}
		if (data->_tmp10_) {
			data->_tmp15_ = g_strdup ("jpeg");
			_g_free0 (data->t);
			data->t = data->_tmp15_;
		}
		gdk_pixbuf_save (data->pixbuf, data->cimage, data->t, &data->_inner_error_, NULL);
		if (data->_inner_error_ != NULL) {
			_g_free0 (data->cimage);
			_g_object_unref0 (data->pixbuf);
			_g_object_unref0 (data->stream);
			goto __catch3_g_error;
		}
		_g_free0 (data->cimage);
	}
	_g_object_unref0 (data->pixbuf);
	_g_object_unref0 (data->stream);
	goto __finally3;
	__catch3_g_error:
	{
		data->e = data->_inner_error_;
		data->_inner_error_ = NULL;
		g_debug ("stream-view-tile.vala:774: Error trying to load %s: %s", data->url, data->e->message);
		gtk_image_set_from_icon_name (data->cicon, "stock_person", GTK_ICON_SIZE_DIALOG);
		_g_error_free0 (data->e);
	}
	__finally3:
	if (data->_inner_error_ != NULL) {
		_g_object_unref0 (data->file);
		_g_free0 (data->t);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
		g_clear_error (&data->_inner_error_);
		return FALSE;
	}
	_g_object_unref0 (data->file);
	_g_free0 (data->t);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void gwibber_gtk_stream_view_tile_load_thumbnail_async_data_free (gpointer _data) {
	GwibberGtkStreamViewTileLoadThumbnailAsyncData* data;
	data = _data;
	_g_free0 (data->img_markup);
	_g_object_unref0 (data->self);
	g_slice_free (GwibberGtkStreamViewTileLoadThumbnailAsyncData, data);
}


static void gwibber_gtk_stream_view_tile_load_thumbnail_async (GwibberGtkStreamViewTile* self, const gchar* img_markup, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	GwibberGtkStreamViewTileLoadThumbnailAsyncData* _data_;
	_data_ = g_slice_new0 (GwibberGtkStreamViewTileLoadThumbnailAsyncData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, gwibber_gtk_stream_view_tile_load_thumbnail_async);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, gwibber_gtk_stream_view_tile_load_thumbnail_async_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->img_markup = g_strdup (img_markup);
	gwibber_gtk_stream_view_tile_load_thumbnail_async_co (_data_);
}


static void gwibber_gtk_stream_view_tile_load_thumbnail_finish (GwibberGtkStreamViewTile* self, GAsyncResult* _res_) {
	GwibberGtkStreamViewTileLoadThumbnailAsyncData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void gwibber_gtk_stream_view_tile_load_thumbnail_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	GwibberGtkStreamViewTileLoadThumbnailAsyncData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	gwibber_gtk_stream_view_tile_load_thumbnail_async_co (data);
}


static gboolean gwibber_gtk_stream_view_tile_load_thumbnail_async_co (GwibberGtkStreamViewTileLoadThumbnailAsyncData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	memset (&data->_tmp0_, 0, sizeof (GtkAllocation));
	gtk_widget_get_allocation ((GtkWidget*) data->self->priv->message, &data->_tmp0_);
	data->alloc = data->_tmp0_;
	data->self->priv->img_id = (guint) 0;
	data->_tmp1_ = NULL;
	data->_tmp1_ = gwibber_gtk_stream_view_tile_fix_image_uri (data->self, data->self->priv->img_uri);
	data->_tmp2_ = data->_tmp1_;
	data->_tmp3_ = NULL;
	data->_tmp3_ = g_file_new_for_uri (data->_tmp2_);
	data->_tmp4_ = data->_tmp3_;
	_g_free0 (data->_tmp2_);
	data->file = data->_tmp4_;
	data->_state_ = 1;
	g_file_read_async (data->file, G_PRIORITY_DEFAULT, data->self->priv->cancellable, gwibber_gtk_stream_view_tile_load_thumbnail_async_ready, data);
	return FALSE;
	_state_1:
	data->_tmp5_ = NULL;
	data->_tmp5_ = g_file_read_finish (data->file, data->_res_, &data->_inner_error_);
	data->stream = data->_tmp5_;
	if (data->_inner_error_ != NULL) {
		goto __catch5_g_error;
	}
	data->pixbuf = NULL;
	data->_tmp6_ = NULL;
	data->_tmp6_ = gdk_pixbuf_new_from_stream_at_scale ((GInputStream*) data->stream, data->alloc.width - 24, 100, TRUE, data->self->priv->cancellable, &data->_inner_error_);
	data->_tmp7_ = data->_tmp6_;
	if (data->_inner_error_ != NULL) {
		_g_object_unref0 (data->pixbuf);
		_g_object_unref0 (data->stream);
		goto __catch5_g_error;
	}
	_g_object_unref0 (data->pixbuf);
	data->pixbuf = data->_tmp7_;
	if (GDK_IS_PIXBUF (data->pixbuf)) {
		gtk_image_set_from_pixbuf ((GtkImage*) data->self->priv->thumbnail, data->pixbuf);
		gtk_widget_show ((GtkWidget*) data->self->priv->thumbnail);
		gtk_widget_set_no_show_all ((GtkWidget*) data->self->priv->thumb_box, FALSE);
		gtk_widget_show ((GtkWidget*) data->self->priv->thumb_box);
	}
	gtk_label_set_markup (data->self->priv->message, data->img_markup);
	_g_object_unref0 (data->pixbuf);
	_g_object_unref0 (data->stream);
	goto __finally5;
	__catch5_g_error:
	{
		data->e = data->_inner_error_;
		data->_inner_error_ = NULL;
		g_debug ("stream-view-tile.vala:803: Error trying to load %s: %s", data->self->priv->img_uri, data->e->message);
		gtk_widget_hide ((GtkWidget*) data->self->priv->thumbnail);
		gtk_widget_set_no_show_all ((GtkWidget*) data->self->priv->thumb_box, TRUE);
		gtk_widget_hide ((GtkWidget*) data->self->priv->thumb_box);
		_g_error_free0 (data->e);
	}
	__finally5:
	if (data->_inner_error_ != NULL) {
		_g_object_unref0 (data->file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
		g_clear_error (&data->_inner_error_);
		return FALSE;
	}
	_g_object_unref0 (data->file);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* _tmp0_ = NULL;
	gchar* end;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	if (end == NULL) {
		result = maxlen;
		return result;
	} else {
		result = (glong) (end - str);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= 0) {
		_tmp0_ = len >= 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		glong _tmp1_;
		_tmp1_ = string_strnlen ((gchar*) self, offset + len);
		string_length = _tmp1_;
	} else {
		gint _tmp2_;
		_tmp2_ = strlen (self);
		string_length = (glong) _tmp2_;
	}
	if (offset < 0) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= 0, NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < 0) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}


static gchar* gwibber_gtk_stream_view_tile_fix_image_uri (GwibberGtkStreamViewTile* self, const gchar* uri) {
	gchar* result = NULL;
	gchar* _tmp0_;
	gchar* ret;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (uri != NULL, NULL);
	_tmp0_ = g_strdup (uri);
	ret = _tmp0_;
	_tmp2_ = string_contains (uri, "imgur.com");
	if (_tmp2_) {
		gboolean _tmp3_;
		_tmp3_ = g_str_has_suffix (uri, ".png");
		_tmp1_ = !_tmp3_;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		const gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		gchar* last;
		gchar* _tmp6_ = NULL;
		_tmp4_ = g_strrstr (uri, "/");
		_tmp5_ = string_substring (_tmp4_, (glong) 1, (glong) (-1));
		last = _tmp5_;
		_tmp6_ = g_strdup_printf ("http://i.imgur.com/%s.png", last);
		_g_free0 (ret);
		ret = _tmp6_;
		_g_free0 (last);
	} else {
		gboolean _tmp7_;
		_tmp7_ = string_contains (uri, "youtube.com");
		if (_tmp7_) {
			const gchar* _tmp8_ = NULL;
			gchar* _tmp9_ = NULL;
			gchar* id;
			gboolean _tmp10_;
			gchar* _tmp23_ = NULL;
			_tmp8_ = g_strrstr (uri, "/");
			_tmp9_ = string_substring (_tmp8_, (glong) 1, (glong) (-1));
			id = _tmp9_;
			_tmp10_ = string_contains (uri, "watch?v=");
			if (_tmp10_) {
				gboolean _tmp11_;
				_tmp11_ = string_contains (uri, "&");
				if (_tmp11_) {
					gchar** _tmp12_;
					gchar** _tmp13_ = NULL;
					gchar** _tmp14_;
					gint _tmp14__length1;
					gchar** _tmp15_;
					gchar** _tmp16_ = NULL;
					gchar** _tmp17_;
					gint _tmp17__length1;
					gchar* _tmp18_;
					_tmp13_ = _tmp12_ = g_strsplit (uri, "v=", 0);
					_tmp14_ = _tmp13_;
					_tmp14__length1 = _vala_array_length (_tmp12_);
					_tmp16_ = _tmp15_ = g_strsplit (_tmp14_[1], "&", 0);
					_tmp17_ = _tmp16_;
					_tmp17__length1 = _vala_array_length (_tmp15_);
					_tmp18_ = g_strdup (_tmp17_[0]);
					_g_free0 (id);
					id = _tmp18_;
					_tmp17_ = (_vala_array_free (_tmp17_, _tmp17__length1, (GDestroyNotify) g_free), NULL);
					_tmp14_ = (_vala_array_free (_tmp14_, _tmp14__length1, (GDestroyNotify) g_free), NULL);
				} else {
					gchar** _tmp19_;
					gchar** _tmp20_ = NULL;
					gchar** _tmp21_;
					gint _tmp21__length1;
					gchar* _tmp22_;
					_tmp20_ = _tmp19_ = g_strsplit (uri, "v=", 0);
					_tmp21_ = _tmp20_;
					_tmp21__length1 = _vala_array_length (_tmp19_);
					_tmp22_ = g_strdup (_tmp21_[1]);
					_g_free0 (id);
					id = _tmp22_;
					_tmp21_ = (_vala_array_free (_tmp21_, _tmp21__length1, (GDestroyNotify) g_free), NULL);
				}
			}
			_tmp23_ = g_strdup_printf ("http://img.youtube.com/vi/%s/default.jpg", id);
			_g_free0 (ret);
			ret = _tmp23_;
			_g_free0 (id);
		}
	}
	result = ret;
	return result;
}


static gboolean gwibber_gtk_stream_view_tile_on_avatar_click (GwibberGtkStreamViewTile* self, GdkEventButton* button) {
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_app_info_launch_default_for_uri (self->priv->url, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		goto __catch6_g_error;
	}
	goto __finally6;
	__catch6_g_error:
	{
		gchar* _tmp0_;
		gchar* _tmp1_;
		g_clear_error (&_inner_error_);
		_inner_error_ = NULL;
		_tmp0_ = g_strconcat ("Unable to launch: ", self->priv->url, NULL);
		_tmp1_ = _tmp0_;
		g_warning ("stream-view-tile.vala:844: %s", _tmp1_);
		_g_free0 (_tmp1_);
	}
	__finally6:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	result = FALSE;
	return result;
}


GwibberUtils* gwibber_gtk_stream_view_tile_get_utils (GwibberGtkStreamViewTile* self) {
	GwibberUtils* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_utils;
	return result;
}


void gwibber_gtk_stream_view_tile_set_utils (GwibberGtkStreamViewTile* self, GwibberUtils* value) {
	GwibberUtils* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_utils);
	self->priv->_utils = _tmp0_;
	g_object_notify ((GObject *) self, "utils");
}


GwibberService* gwibber_gtk_stream_view_tile_get_service (GwibberGtkStreamViewTile* self) {
	GwibberService* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_service;
	return result;
}


void gwibber_gtk_stream_view_tile_set_service (GwibberGtkStreamViewTile* self, GwibberService* value) {
	GwibberService* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_service);
	self->priv->_service = _tmp0_;
	g_object_notify ((GObject *) self, "service");
}


gboolean gwibber_gtk_stream_view_tile_get_show_fullname (GwibberGtkStreamViewTile* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_show_fullname;
	return result;
}


void gwibber_gtk_stream_view_tile_set_show_fullname (GwibberGtkStreamViewTile* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_show_fullname = value;
	g_object_notify ((GObject *) self, "show-fullname");
}


static void gwibber_gtk_stream_view_tile_real_reply (GwibberGtkStreamViewTile* self, const gchar* mid, const gchar* account, const gchar* sender) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (mid != NULL);
	g_return_if_fail (account != NULL);
	g_return_if_fail (sender != NULL);
}


static void g_cclosure_user_marshal_VOID__STRING_STRING_STRING (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__STRING_STRING_STRING) (gpointer data1, const char* arg_1, const char* arg_2, const char* arg_3, gpointer data2);
	register GMarshalFunc_VOID__STRING_STRING_STRING callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 4);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__STRING_STRING_STRING) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_string (param_values + 1), g_value_get_string (param_values + 2), g_value_get_string (param_values + 3), data2);
}


static gboolean _gwibber_gtk_stream_view_tile_on_draw_gtk_widget_draw (GtkWidget* _sender, cairo_t* cr, gpointer self) {
	gboolean result;
	result = gwibber_gtk_stream_view_tile_on_draw (self, cr);
	return result;
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


static gboolean _lambda20_ (const gchar* uri, GwibberGtkStreamViewTile* self) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	g_return_val_if_fail (uri != NULL, FALSE);
	_tmp0_ = g_str_has_prefix (uri, "gwibber:/");
	if (_tmp0_) {
		SoupURI* _tmp1_ = NULL;
		SoupURI* url;
		gboolean _tmp2_;
		g_debug ("stream-view-tile.vala:165: URI is %s", uri);
		_tmp1_ = soup_uri_new (uri);
		url = _tmp1_;
		_tmp2_ = g_str_has_suffix (url->path, "tag");
		if (_tmp2_) {
			gchar* _tmp3_;
			gchar* acct;
			gchar* _tmp4_;
			gchar* query;
			gchar** _tmp5_;
			gchar** _tmp6_ = NULL;
			gchar** args;
			gint args_length1;
			gint _args_size_;
			gint _tmp12_;
			_tmp3_ = g_strdup ("");
			acct = _tmp3_;
			_tmp4_ = g_strdup ("");
			query = _tmp4_;
			_tmp6_ = _tmp5_ = g_strsplit (url->query, "&", 0);
			args = _tmp6_;
			args_length1 = _vala_array_length (_tmp5_);
			_args_size_ = _vala_array_length (_tmp5_);
			{
				gchar** x_collection;
				int x_collection_length1;
				int x_it;
				x_collection = args;
				x_collection_length1 = args_length1;
				for (x_it = 0; x_it < args_length1; x_it = x_it + 1) {
					gchar* _tmp7_;
					gchar* x;
					_tmp7_ = g_strdup (x_collection[x_it]);
					x = _tmp7_;
					{
						gchar** _tmp8_;
						gchar** _tmp9_ = NULL;
						gchar** args2;
						gint args2_length1;
						gint _args2_size_;
						_tmp9_ = _tmp8_ = g_strsplit (x, "=", 0);
						args2 = _tmp9_;
						args2_length1 = _vala_array_length (_tmp8_);
						_args2_size_ = _vala_array_length (_tmp8_);
						if (g_strcmp0 (args2[0], "acct") == 0) {
							gchar* _tmp10_;
							_tmp10_ = g_strdup (args2[1]);
							_g_free0 (acct);
							acct = _tmp10_;
						}
						if (g_strcmp0 (args2[0], "query") == 0) {
							gchar* _tmp11_;
							_tmp11_ = g_strconcat ("#", args2[1], NULL);
							_g_free0 (query);
							query = _tmp11_;
						}
						args2 = (_vala_array_free (args2, args2_length1, (GDestroyNotify) g_free), NULL);
						_g_free0 (x);
					}
				}
			}
			_tmp12_ = strlen (query);
			if (_tmp12_ > 0) {
				GwibberSearches* _tmp13_ = NULL;
				GwibberSearches* searches_service;
				GList* _tmp14_ = NULL;
				GList* searches;
				gchar* _tmp15_ = NULL;
				gchar* _id;
				_tmp13_ = gwibber_searches_new ();
				searches_service = _tmp13_;
				_tmp14_ = gwibber_searches_list (searches_service);
				searches = _tmp14_;
				_tmp15_ = gwibber_searches_create (searches_service, query, query);
				_id = _tmp15_;
				_g_free0 (_id);
				__g_list_free__g_object_unref0_0 (searches);
				_g_object_unref0 (searches_service);
			}
			args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (query);
			_g_free0 (acct);
		} else {
			gboolean _tmp16_;
			_tmp16_ = g_str_has_suffix (url->path, "user");
			if (_tmp16_) {
				gchar* _tmp17_;
				gchar* acct;
				gchar* _tmp18_;
				gchar* name;
				gchar** _tmp19_;
				gchar** _tmp20_ = NULL;
				gchar** args;
				gint args_length1;
				gint _args_size_;
				gboolean _tmp26_ = FALSE;
				gint _tmp27_;
				_tmp17_ = g_strdup ("");
				acct = _tmp17_;
				_tmp18_ = g_strdup ("");
				name = _tmp18_;
				_tmp20_ = _tmp19_ = g_strsplit (url->query, "&", 0);
				args = _tmp20_;
				args_length1 = _vala_array_length (_tmp19_);
				_args_size_ = _vala_array_length (_tmp19_);
				{
					gchar** x_collection;
					int x_collection_length1;
					int x_it;
					x_collection = args;
					x_collection_length1 = args_length1;
					for (x_it = 0; x_it < args_length1; x_it = x_it + 1) {
						gchar* _tmp21_;
						gchar* x;
						_tmp21_ = g_strdup (x_collection[x_it]);
						x = _tmp21_;
						{
							gchar** _tmp22_;
							gchar** _tmp23_ = NULL;
							gchar** args2;
							gint args2_length1;
							gint _args2_size_;
							_tmp23_ = _tmp22_ = g_strsplit (x, "=", 0);
							args2 = _tmp23_;
							args2_length1 = _vala_array_length (_tmp22_);
							_args2_size_ = _vala_array_length (_tmp22_);
							if (g_strcmp0 (args2[0], "acct") == 0) {
								gchar* _tmp24_;
								_tmp24_ = g_strdup (args2[1]);
								_g_free0 (acct);
								acct = _tmp24_;
							}
							if (g_strcmp0 (args2[0], "name") == 0) {
								gchar* _tmp25_;
								_tmp25_ = g_strdup (args2[1]);
								_g_free0 (name);
								name = _tmp25_;
							}
							args2 = (_vala_array_free (args2, args2_length1, (GDestroyNotify) g_free), NULL);
							_g_free0 (x);
						}
					}
				}
				_tmp27_ = strlen (name);
				if (_tmp27_ > 0) {
					gint _tmp28_;
					_tmp28_ = strlen (acct);
					_tmp26_ = _tmp28_ > 0;
				} else {
					_tmp26_ = FALSE;
				}
				if (_tmp26_) {
					GwibberStreams* _tmp29_ = NULL;
					GwibberStreams* streams_service;
					GList* _tmp30_ = NULL;
					GList* streams_list;
					gchar* _tmp31_ = NULL;
					gchar* _id;
					_tmp29_ = gwibber_streams_new ();
					streams_service = _tmp29_;
					_tmp30_ = gwibber_streams_list (streams_service);
					streams_list = _tmp30_;
					_tmp31_ = gwibber_streams_create (streams_service, acct, name, "user_messages");
					_id = _tmp31_;
					_g_free0 (_id);
					__g_list_free__g_object_unref0_0 (streams_list);
					_g_object_unref0 (streams_service);
				}
				args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (name);
				_g_free0 (acct);
			}
		}
		_soup_uri_free0 (url);
	}
	result = FALSE;
	return result;
}


static gboolean __lambda20__gtk_label_activate_link (GtkLabel* _sender, const gchar* uri, gpointer self) {
	gboolean result;
	result = _lambda20_ (uri, self);
	return result;
}


static gboolean _lambda21_ (GwibberGtkStreamViewTile* self) {
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
	if (self->priv->img_src != NULL) {
		GdkScreen* _tmp0_ = NULL;
		_tmp0_ = gdk_screen_get_default ();
		gtk_show_uri (_tmp0_, self->priv->img_src, (guint32) 0, &_inner_error_);
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	result = FALSE;
	return result;
}


static gboolean __lambda21__gtk_widget_button_release_event (GtkWidget* _sender, GdkEventButton* event, gpointer self) {
	gboolean result;
	result = _lambda21_ (self);
	return result;
}


static gboolean _lambda22_ (GwibberGtkStreamViewTile* self) {
	gboolean result = FALSE;
	gwibber_gtk_stream_view_tile_update_time_area_wrapper (self);
	result = FALSE;
	return result;
}


static gboolean __lambda22__gtk_widget_enter_notify_event (GtkWidget* _sender, GdkEventCrossing* event, gpointer self) {
	gboolean result;
	result = _lambda22_ (self);
	return result;
}


static gboolean _lambda23_ (GwibberGtkStreamViewTile* self) {
	gboolean result = FALSE;
	gwibber_gtk_stream_view_tile_update_time_area_wrapper (self);
	result = FALSE;
	return result;
}


static gboolean __lambda23__gtk_widget_enter_notify_event (GtkWidget* _sender, GdkEventCrossing* event, gpointer self) {
	gboolean result;
	result = _lambda23_ (self);
	return result;
}


static gboolean _lambda24_ (GwibberGtkStreamViewTile* self) {
	gboolean result = FALSE;
	gwibber_gtk_stream_view_tile_update_time_area_wrapper (self);
	result = FALSE;
	return result;
}


static gboolean __lambda24__gtk_widget_enter_notify_event (GtkWidget* _sender, GdkEventCrossing* event, gpointer self) {
	gboolean result;
	result = _lambda24_ (self);
	return result;
}


static gboolean _lambda25_ (GwibberGtkStreamViewTile* self) {
	gboolean result = FALSE;
	gwibber_gtk_stream_view_tile_update_time_area_wrapper (self);
	result = FALSE;
	return result;
}


static gboolean __lambda25__gtk_widget_leave_notify_event (GtkWidget* _sender, GdkEventCrossing* event, gpointer self) {
	gboolean result;
	result = _lambda25_ (self);
	return result;
}


static GObject * gwibber_gtk_stream_view_tile_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	GwibberGtkStreamViewTile * self;
	GtkAlignment* _tmp0_ = NULL;
	GtkHBox* _tmp1_ = NULL;
	GtkAlignment* _tmp2_ = NULL;
	GtkAlignment* _tmp3_ = NULL;
	GtkEventBox* _tmp4_ = NULL;
	GwibberGtkStreamViewAvatar* _tmp5_ = NULL;
	GtkVBox* _tmp6_ = NULL;
	GtkHBox* _tmp7_ = NULL;
	GtkHBox* hbox;
	GtkImage* _tmp8_ = NULL;
	GtkLabel* _tmp9_ = NULL;
	GtkLabel* _tmp10_ = NULL;
	GwibberGtkActionBox* _tmp11_ = NULL;
	GtkLabel* _tmp12_ = NULL;
	GtkEventBox* _tmp13_ = NULL;
	GtkHBox* _tmp14_ = NULL;
	GtkHBox* thumb_hbox;
	GwibberGtkStreamViewAvatar* _tmp15_ = NULL;
	GtkVBox* _tmp16_ = NULL;
	GtkLabel* _tmp17_ = NULL;
	GtkLabel* _tmp18_ = NULL;
	GtkHBox* _tmp19_ = NULL;
	GtkImage* _tmp20_ = NULL;
	GtkImage* likes_icon;
	GtkLabel* _tmp21_ = NULL;
	GCancellable* _tmp22_ = NULL;
	parent_class = G_OBJECT_CLASS (gwibber_gtk_stream_view_tile_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = GWIBBER_GTK_STREAM_VIEW_TILE (obj);
	_g_list_free0 (self->priv->_to_disconnect);
	self->priv->_to_disconnect = NULL;
	g_signal_connect_object ((GtkWidget*) self, "draw", (GCallback) _gwibber_gtk_stream_view_tile_on_draw_gtk_widget_draw, self, 0);
	_tmp0_ = (GtkAlignment*) gtk_alignment_new (0.0f, 0.0f, 1.0f, 1.0f);
	_g_object_unref0 (self->priv->align);
	self->priv->align = g_object_ref_sink (_tmp0_);
	gtk_alignment_set_padding (self->priv->align, (guint) GWIBBER_GTK_STREAM_VIEW_TILE_our_padding, (guint) GWIBBER_GTK_STREAM_VIEW_TILE_our_padding, (guint) GWIBBER_GTK_STREAM_VIEW_TILE_our_padding, (guint) GWIBBER_GTK_STREAM_VIEW_TILE_our_padding);
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) self->priv->align);
	_tmp1_ = (GtkHBox*) gtk_hbox_new (FALSE, 12);
	_g_object_unref0 (self->priv->main_box);
	self->priv->main_box = g_object_ref_sink (_tmp1_);
	gtk_container_add ((GtkContainer*) self->priv->align, (GtkWidget*) self->priv->main_box);
	_tmp2_ = (GtkAlignment*) gtk_alignment_new (0.5f, 0.0f, 0.0f, 0.0f);
	_g_object_unref0 (self->priv->lalignment);
	self->priv->lalignment = g_object_ref_sink (_tmp2_);
	_tmp3_ = (GtkAlignment*) gtk_alignment_new (0.5f, 0.0f, 0.0f, 0.0f);
	_g_object_unref0 (self->priv->ralignment);
	self->priv->ralignment = g_object_ref_sink (_tmp3_);
	gtk_box_pack_start ((GtkBox*) self->priv->main_box, (GtkWidget*) self->priv->lalignment, FALSE, FALSE, (guint) 0);
	gtk_box_pack_end ((GtkBox*) self->priv->main_box, (GtkWidget*) self->priv->ralignment, FALSE, FALSE, (guint) 0);
	_tmp4_ = (GtkEventBox*) gtk_event_box_new ();
	_g_object_unref0 (self->priv->icon_box);
	self->priv->icon_box = g_object_ref_sink (_tmp4_);
	gtk_event_box_set_visible_window (self->priv->icon_box, FALSE);
	_tmp5_ = gwibber_gtk_stream_view_avatar_new ();
	_g_object_unref0 (self->priv->icon);
	self->priv->icon = g_object_ref_sink (_tmp5_);
	gtk_container_add ((GtkContainer*) self->priv->icon_box, (GtkWidget*) self->priv->icon);
	gtk_container_add ((GtkContainer*) self->priv->lalignment, (GtkWidget*) self->priv->icon_box);
	_tmp6_ = (GtkVBox*) gtk_vbox_new (FALSE, 0);
	_g_object_unref0 (self->priv->vbox);
	self->priv->vbox = g_object_ref_sink (_tmp6_);
	gtk_box_pack_start ((GtkBox*) self->priv->main_box, (GtkWidget*) self->priv->vbox, TRUE, TRUE, (guint) 0);
	_tmp7_ = (GtkHBox*) gtk_hbox_new (FALSE, 0);
	hbox = g_object_ref_sink (_tmp7_);
	gtk_box_pack_start ((GtkBox*) self->priv->vbox, (GtkWidget*) hbox, FALSE, FALSE, (guint) 2);
	_tmp8_ = (GtkImage*) gtk_image_new_from_icon_name ("status_lock", GTK_ICON_SIZE_MENU);
	_g_object_unref0 (self->priv->private);
	self->priv->private = g_object_ref_sink (_tmp8_);
	gtk_widget_set_no_show_all ((GtkWidget*) self->priv->private, TRUE);
	gtk_box_pack_start ((GtkBox*) hbox, (GtkWidget*) self->priv->private, FALSE, FALSE, (guint) 0);
	_tmp9_ = (GtkLabel*) gtk_label_new ("");
	_g_object_unref0 (self->priv->name);
	self->priv->name = g_object_ref_sink (_tmp9_);
	gtk_label_set_markup (self->priv->name, "<b></b>");
	gtk_label_set_single_line_mode (self->priv->name, FALSE);
	gtk_label_set_line_wrap (self->priv->name, TRUE);
	gtk_label_set_line_wrap_mode (self->priv->name, PANGO_WRAP_WORD_CHAR);
	gtk_misc_set_alignment ((GtkMisc*) self->priv->name, 0.0f, 0.5f);
	gtk_box_pack_start ((GtkBox*) hbox, (GtkWidget*) self->priv->name, FALSE, FALSE, (guint) 0);
	_tmp10_ = (GtkLabel*) gtk_label_new ("");
	_g_object_unref0 (self->priv->time);
	self->priv->time = g_object_ref_sink (_tmp10_);
	gtk_label_set_markup (self->priv->time, "");
	gtk_misc_set_alignment ((GtkMisc*) self->priv->time, 0.0f, 1.0f);
	gtk_box_pack_end ((GtkBox*) hbox, (GtkWidget*) self->priv->time, FALSE, FALSE, (guint) 0);
	_tmp11_ = gwibber_gtk_action_box_new ();
	_g_object_unref0 (self->priv->action_box);
	self->priv->action_box = g_object_ref_sink (_tmp11_);
	gtk_widget_hide ((GtkWidget*) self->priv->action_box);
	gtk_box_pack_end ((GtkBox*) hbox, (GtkWidget*) self->priv->action_box, FALSE, FALSE, (guint) 0);
	_tmp12_ = (GtkLabel*) gtk_label_new ("");
	_g_object_unref0 (self->priv->message);
	self->priv->message = g_object_ref_sink (_tmp12_);
	gtk_label_set_selectable (self->priv->message, TRUE);
	gtk_label_set_single_line_mode (self->priv->message, FALSE);
	gtk_label_set_line_wrap (self->priv->message, TRUE);
	gtk_label_set_line_wrap_mode (self->priv->message, PANGO_WRAP_WORD_CHAR);
	gtk_misc_set_alignment ((GtkMisc*) self->priv->message, 0.0f, 0.0f);
	gtk_box_pack_start ((GtkBox*) self->priv->vbox, (GtkWidget*) self->priv->message, FALSE, FALSE, (guint) 2);
	g_signal_connect_object (self->priv->message, "activate-link", (GCallback) __lambda20__gtk_label_activate_link, self, 0);
	_tmp13_ = (GtkEventBox*) gtk_event_box_new ();
	_g_object_unref0 (self->priv->thumb_box);
	self->priv->thumb_box = g_object_ref_sink (_tmp13_);
	gtk_event_box_set_visible_window (self->priv->thumb_box, FALSE);
	gtk_widget_set_no_show_all ((GtkWidget*) self->priv->thumb_box, TRUE);
	_tmp14_ = (GtkHBox*) gtk_hbox_new (FALSE, 2);
	thumb_hbox = g_object_ref_sink (_tmp14_);
	gtk_box_pack_start ((GtkBox*) self->priv->vbox, (GtkWidget*) thumb_hbox, FALSE, FALSE, (guint) 4);
	gtk_box_pack_start ((GtkBox*) thumb_hbox, (GtkWidget*) self->priv->thumb_box, FALSE, FALSE, (guint) 4);
	g_signal_connect_object ((GtkWidget*) self->priv->thumb_box, "button-release-event", (GCallback) __lambda21__gtk_widget_button_release_event, self, 0);
	_tmp15_ = gwibber_gtk_stream_view_avatar_new ();
	_g_object_unref0 (self->priv->thumbnail);
	self->priv->thumbnail = g_object_ref_sink (_tmp15_);
	gtk_widget_set_no_show_all ((GtkWidget*) self->priv->thumbnail, TRUE);
	gtk_container_add ((GtkContainer*) self->priv->thumb_box, (GtkWidget*) self->priv->thumbnail);
	gtk_widget_hide ((GtkWidget*) self->priv->thumb_box);
	_tmp16_ = (GtkVBox*) gtk_vbox_new (FALSE, 0);
	_g_object_unref0 (self->priv->comments_box);
	self->priv->comments_box = g_object_ref_sink (_tmp16_);
	gtk_widget_set_no_show_all ((GtkWidget*) self->priv->comments_box, TRUE);
	gtk_box_pack_start ((GtkBox*) self->priv->vbox, (GtkWidget*) self->priv->comments_box, FALSE, FALSE, (guint) 4);
	_tmp17_ = (GtkLabel*) gtk_label_new ("");
	_g_object_unref0 (self->priv->reply_to);
	self->priv->reply_to = g_object_ref_sink (_tmp17_);
	gtk_widget_set_no_show_all ((GtkWidget*) self->priv->reply_to, TRUE);
	gtk_label_set_markup (self->priv->reply_to, "<span font_weight='light' font_size='small'></span>");
	gtk_misc_set_alignment ((GtkMisc*) self->priv->reply_to, 0.0f, 0.5f);
	gtk_box_pack_start ((GtkBox*) self->priv->vbox, (GtkWidget*) self->priv->reply_to, FALSE, FALSE, (guint) 2);
	_tmp18_ = (GtkLabel*) gtk_label_new ("");
	_g_object_unref0 (self->priv->retweeted_by);
	self->priv->retweeted_by = g_object_ref_sink (_tmp18_);
	gtk_label_set_markup (self->priv->retweeted_by, "<span font_weight='light' font_size='small'></span>");
	gtk_misc_set_alignment ((GtkMisc*) self->priv->retweeted_by, 0.0f, 0.5f);
	gtk_widget_set_no_show_all ((GtkWidget*) self->priv->retweeted_by, TRUE);
	gtk_box_pack_start ((GtkBox*) self->priv->vbox, (GtkWidget*) self->priv->retweeted_by, FALSE, FALSE, (guint) 2);
	_tmp19_ = (GtkHBox*) gtk_hbox_new (FALSE, 0);
	_g_object_unref0 (self->priv->likes_hbox);
	self->priv->likes_hbox = g_object_ref_sink (_tmp19_);
	gtk_widget_set_no_show_all ((GtkWidget*) self->priv->likes_hbox, TRUE);
	_tmp20_ = (GtkImage*) gtk_image_new_from_file ("/usr/share/gwibber/ui/icons/streams/16x16/favorite.png");
	likes_icon = g_object_ref_sink (_tmp20_);
	gtk_box_pack_start ((GtkBox*) self->priv->likes_hbox, (GtkWidget*) likes_icon, FALSE, FALSE, (guint) 2);
	_tmp21_ = (GtkLabel*) gtk_label_new ("");
	_g_object_unref0 (self->priv->likes_count);
	self->priv->likes_count = g_object_ref_sink (_tmp21_);
	gtk_box_pack_start ((GtkBox*) self->priv->likes_hbox, (GtkWidget*) self->priv->likes_count, FALSE, FALSE, (guint) 0);
	gtk_box_pack_start ((GtkBox*) self->priv->vbox, (GtkWidget*) self->priv->likes_hbox, FALSE, FALSE, (guint) 2);
	g_signal_connect_object ((GtkWidget*) self, "enter-notify-event", (GCallback) __lambda22__gtk_widget_enter_notify_event, self, 0);
	g_signal_connect_object ((GtkWidget*) self->priv->icon_box, "enter-notify-event", (GCallback) __lambda23__gtk_widget_enter_notify_event, self, 0);
	g_signal_connect_object ((GtkWidget*) self->priv->message, "enter-notify-event", (GCallback) __lambda24__gtk_widget_enter_notify_event, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "leave-notify-event", (GCallback) __lambda25__gtk_widget_leave_notify_event, self, 0);
	_tmp22_ = g_cancellable_new ();
	_g_object_unref0 (self->priv->cancellable);
	self->priv->cancellable = _tmp22_;
	notify_init ("Gwibber");
	_g_object_unref0 (likes_icon);
	_g_object_unref0 (thumb_hbox);
	_g_object_unref0 (hbox);
	return obj;
}


static void gwibber_gtk_stream_view_tile_class_init (GwibberGtkStreamViewTileClass * klass) {
	gwibber_gtk_stream_view_tile_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GwibberGtkStreamViewTilePrivate));
	GWIBBER_GTK_STREAM_VIEW_TILE_CLASS (klass)->reply = gwibber_gtk_stream_view_tile_real_reply;
	G_OBJECT_CLASS (klass)->get_property = _vala_gwibber_gtk_stream_view_tile_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gwibber_gtk_stream_view_tile_set_property;
	G_OBJECT_CLASS (klass)->constructor = gwibber_gtk_stream_view_tile_constructor;
	G_OBJECT_CLASS (klass)->finalize = gwibber_gtk_stream_view_tile_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GWIBBER_GTK_STREAM_VIEW_TILE_UTILS, g_param_spec_object ("utils", "utils", "utils", GWIBBER_TYPE_UTILS, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GWIBBER_GTK_STREAM_VIEW_TILE_SERVICE, g_param_spec_object ("service", "service", "service", GWIBBER_TYPE_SERVICE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GWIBBER_GTK_STREAM_VIEW_TILE_SHOW_FULLNAME, g_param_spec_boolean ("show-fullname", "show-fullname", "show-fullname", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_signal_new ("reply", GWIBBER_GTK_TYPE_STREAM_VIEW_TILE, G_SIGNAL_RUN_LAST | G_SIGNAL_ACTION, G_STRUCT_OFFSET (GwibberGtkStreamViewTileClass, reply), NULL, NULL, g_cclosure_user_marshal_VOID__STRING_STRING_STRING, G_TYPE_NONE, 3, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING);
}


static void gwibber_gtk_stream_view_tile_instance_init (GwibberGtkStreamViewTile * self) {
	gchar* _tmp0_;
	self->priv = GWIBBER_GTK_STREAM_VIEW_TILE_GET_PRIVATE (self);
	self->priv->_update_time_area_id = (guint) 0;
	self->priv->_cache_avatar_id = (guint) 0;
	self->uid = (guint) 0;
	self->priv->sender = NULL;
	self->priv->url = NULL;
	_tmp0_ = g_strdup ("");
	self->priv->time_string = _tmp0_;
}


static void gwibber_gtk_stream_view_tile_finalize (GObject* obj) {
	GwibberGtkStreamViewTile * self;
	self = GWIBBER_GTK_STREAM_VIEW_TILE (obj);
	_g_object_unref0 (self->priv->align);
	_g_object_unref0 (self->priv->main_box);
	_g_object_unref0 (self->priv->lalignment);
	_g_object_unref0 (self->priv->ralignment);
	_g_object_unref0 (self->priv->icon_box);
	_g_object_unref0 (self->priv->icon);
	_g_object_unref0 (self->priv->private);
	_g_object_unref0 (self->priv->vbox);
	_g_object_unref0 (self->priv->comments_box);
	_g_object_unref0 (self->priv->likes_hbox);
	_g_object_unref0 (self->priv->likes_count);
	_g_object_unref0 (self->priv->name);
	_g_object_unref0 (self->priv->time);
	_g_object_unref0 (self->priv->message);
	_g_object_unref0 (self->priv->thumbnail);
	_g_object_unref0 (self->priv->thumb_box);
	_g_object_unref0 (self->priv->reply_to);
	_g_object_unref0 (self->priv->retweeted_by);
	_g_object_unref0 (self->priv->_utils);
	_g_object_unref0 (self->priv->_service);
	_g_list_free0 (self->priv->_to_disconnect);
	_g_free0 (self->priv->sender);
	_g_free0 (self->priv->url);
	_g_free0 (self->priv->time_string);
	_g_object_unref0 (self->priv->action_box);
	_g_object_unref0 (self->priv->cancellable);
	_g_free0 (self->priv->img_uri);
	_g_free0 (self->priv->img_src);
	G_OBJECT_CLASS (gwibber_gtk_stream_view_tile_parent_class)->finalize (obj);
}


GType gwibber_gtk_stream_view_tile_get_type (void) {
	static volatile gsize gwibber_gtk_stream_view_tile_type_id__volatile = 0;
	if (g_once_init_enter (&gwibber_gtk_stream_view_tile_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GwibberGtkStreamViewTileClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gwibber_gtk_stream_view_tile_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GwibberGtkStreamViewTile), 0, (GInstanceInitFunc) gwibber_gtk_stream_view_tile_instance_init, NULL };
		GType gwibber_gtk_stream_view_tile_type_id;
		gwibber_gtk_stream_view_tile_type_id = g_type_register_static (GTK_TYPE_EVENT_BOX, "GwibberGtkStreamViewTile", &g_define_type_info, 0);
		g_once_init_leave (&gwibber_gtk_stream_view_tile_type_id__volatile, gwibber_gtk_stream_view_tile_type_id);
	}
	return gwibber_gtk_stream_view_tile_type_id__volatile;
}


static void _vala_gwibber_gtk_stream_view_tile_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GwibberGtkStreamViewTile * self;
	self = GWIBBER_GTK_STREAM_VIEW_TILE (object);
	switch (property_id) {
		case GWIBBER_GTK_STREAM_VIEW_TILE_UTILS:
		g_value_set_object (value, gwibber_gtk_stream_view_tile_get_utils (self));
		break;
		case GWIBBER_GTK_STREAM_VIEW_TILE_SERVICE:
		g_value_set_object (value, gwibber_gtk_stream_view_tile_get_service (self));
		break;
		case GWIBBER_GTK_STREAM_VIEW_TILE_SHOW_FULLNAME:
		g_value_set_boolean (value, gwibber_gtk_stream_view_tile_get_show_fullname (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_gwibber_gtk_stream_view_tile_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GwibberGtkStreamViewTile * self;
	self = GWIBBER_GTK_STREAM_VIEW_TILE (object);
	switch (property_id) {
		case GWIBBER_GTK_STREAM_VIEW_TILE_UTILS:
		gwibber_gtk_stream_view_tile_set_utils (self, g_value_get_object (value));
		break;
		case GWIBBER_GTK_STREAM_VIEW_TILE_SERVICE:
		gwibber_gtk_stream_view_tile_set_service (self, g_value_get_object (value));
		break;
		case GWIBBER_GTK_STREAM_VIEW_TILE_SHOW_FULLNAME:
		gwibber_gtk_stream_view_tile_set_show_fullname (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



