/* tab-bar.c generated by valac 0.12.1, the Vala compiler
 * generated from tab-bar.vala, do not modify */

/*
 * Copyright (C) 2011 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 3, as published
 * by the Free Software Foundation.

 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranties of
 * MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Neil Jagdish Patel <njpatel@gmail.com>
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <glib/gi18n-lib.h>
#include <float.h>
#include <math.h>
#include <cairo.h>
#include <gwibber-gtk.h>
#include <gdk/gdk.h>


#define TYPE_TAB_BAR_ITEM (tab_bar_item_get_type ())
#define TAB_BAR_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TAB_BAR_ITEM, TabBarItem))
#define TAB_BAR_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TAB_BAR_ITEM, TabBarItemClass))
#define IS_TAB_BAR_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TAB_BAR_ITEM))
#define IS_TAB_BAR_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TAB_BAR_ITEM))
#define TAB_BAR_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TAB_BAR_ITEM, TabBarItemClass))

typedef struct _TabBarItem TabBarItem;
typedef struct _TabBarItemClass TabBarItemClass;
typedef struct _TabBarItemPrivate TabBarItemPrivate;

#define TYPE_STREAM_ENTRY (stream_entry_get_type ())
#define STREAM_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_STREAM_ENTRY, StreamEntry))
#define STREAM_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_STREAM_ENTRY, StreamEntryClass))
#define IS_STREAM_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_STREAM_ENTRY))
#define IS_STREAM_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_STREAM_ENTRY))
#define STREAM_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_STREAM_ENTRY, StreamEntryClass))

typedef struct _StreamEntry StreamEntry;
typedef struct _StreamEntryClass StreamEntryClass;

#define TYPE_WRITE_ITEM (write_item_get_type ())
#define WRITE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_WRITE_ITEM, WriteItem))
#define WRITE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_WRITE_ITEM, WriteItemClass))
#define IS_WRITE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_WRITE_ITEM))
#define IS_WRITE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_WRITE_ITEM))
#define WRITE_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_WRITE_ITEM, WriteItemClass))

typedef struct _WriteItem WriteItem;
typedef struct _WriteItemClass WriteItemClass;
typedef struct _WriteItemPrivate WriteItemPrivate;

#define TYPE_TAB_BAR (tab_bar_get_type ())
#define TAB_BAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TAB_BAR, TabBar))
#define TAB_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TAB_BAR, TabBarClass))
#define IS_TAB_BAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TAB_BAR))
#define IS_TAB_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TAB_BAR))
#define TAB_BAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TAB_BAR, TabBarClass))

typedef struct _TabBar TabBar;
typedef struct _TabBarClass TabBarClass;
typedef struct _TabBarPrivate TabBarPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
typedef struct _StreamEntryPrivate StreamEntryPrivate;

struct _TabBarItem {
	GtkButton parent_instance;
	TabBarItemPrivate * priv;
	StreamEntry* entry;
};

struct _TabBarItemClass {
	GtkButtonClass parent_class;
	GtkWidget* (*get_toolbar) (TabBarItem* self);
	GtkWidget* (*get_view) (TabBarItem* self);
};

struct _WriteItem {
	TabBarItem parent_instance;
	WriteItemPrivate * priv;
};

struct _WriteItemClass {
	TabBarItemClass parent_class;
};

struct _TabBar {
	GtkVBox parent_instance;
	TabBarPrivate * priv;
};

struct _TabBarClass {
	GtkVBoxClass parent_class;
};

struct _TabBarPrivate {
	GtkAlignment* _align;
	GtkVBox* _vbox;
	GtkHBox* _tab_box;
	GtkHBox* _toolbar_box;
	GtkLayout* _layout;
	gint _last_width;
	gint _last_height;
	GtkHBox* _view_box;
	GtkSizeGroup* _view_group;
	WriteItem* _write_item;
	StreamEntry* _entry;
	TabBarItem* _active_item;
	gint _active_item_n;
	guint _anim_id;
	gfloat _anim_offset;
	gint64 _anim_start;
};

struct _StreamEntry {
	GtkAlignment parent_instance;
	StreamEntryPrivate * priv;
	GwibberGtkInputTextView* text_view;
	GtkImage* private;
	GwibberGtkAccountTargetBar* target_bar;
};

struct _StreamEntryClass {
	GtkAlignmentClass parent_class;
};


static gpointer write_item_parent_class = NULL;
static gpointer tab_bar_parent_class = NULL;

GType tab_bar_item_get_type (void) G_GNUC_CONST;
GType stream_entry_get_type (void) G_GNUC_CONST;
GType write_item_get_type (void) G_GNUC_CONST;
enum  {
	WRITE_ITEM_DUMMY_PROPERTY
};
WriteItem* write_item_new (void);
WriteItem* write_item_construct (GType object_type);
static GtkWidget* write_item_real_get_toolbar (TabBarItem* base);
static GtkWidget* write_item_real_get_view (TabBarItem* base);
static GObject * write_item_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
GType tab_bar_get_type (void) G_GNUC_CONST;
#define TAB_BAR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_TAB_BAR, TabBarPrivate))
enum  {
	TAB_BAR_DUMMY_PROPERTY
};
TabBar* tab_bar_new (void);
TabBar* tab_bar_construct (GType object_type);
gboolean tab_bar_on_align_draw (TabBar* self, cairo_t* cr);
GtkWidget* tab_bar_item_get_toolbar (TabBarItem* self);
static void tab_bar_draw_arrowed_line (TabBar* self, cairo_t* cr, gint x, gint y, gint width, gint point);
void tab_bar_add_item (TabBar* self, TabBarItem* item);
void tab_bar_on_tab_clicked (TabBar* self, GtkButton* gtk_item);
static void _tab_bar_on_tab_clicked_gtk_button_clicked (GtkButton* _sender, gpointer self);
GtkWidget* tab_bar_item_get_view (TabBarItem* self);
static gboolean _lambda12_ (GtkWidget* w, cairo_t* c, TabBar* self);
gboolean stream_entry_get_showing (StreamEntry* self);
static gboolean __lambda12__gtk_widget_draw (GtkWidget* _sender, cairo_t* cr, gpointer self);
void stream_entry_set_showing (StreamEntry* self, gboolean value);
void tab_bar_item_set_active (TabBarItem* self, gboolean value);
static gboolean _lambda11_ (TabBar* self);
static gboolean __lambda11__gsource_func (gpointer self);
void tab_bar_show_entry (TabBar* self);
void tab_bar_on_write_clicked (TabBar* self);
static GObject * tab_bar_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static gboolean _tab_bar_on_align_draw_gtk_widget_draw (GtkWidget* _sender, cairo_t* cr, gpointer self);
static void _tab_bar_on_write_clicked_gtk_button_clicked (GtkButton* _sender, gpointer self);
StreamEntry* stream_entry_new (void);
StreamEntry* stream_entry_construct (GType object_type);
static void _lambda13_ (TabBar* self);
static void __lambda13__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _lambda14_ (GdkRectangle* a, TabBar* self);
static void __lambda14__gtk_widget_size_allocate (GtkWidget* _sender, GdkRectangle* allocation, gpointer self);
static void tab_bar_finalize (GObject* obj);


WriteItem* write_item_construct (GType object_type) {
	WriteItem * self = NULL;
	const gchar* _tmp0_ = NULL;
	_tmp0_ = _ ("New Message");
	self = (WriteItem*) g_object_new (object_type, "stream", "", "icon-name", "document-new", "tooltip", _tmp0_, NULL);
	return self;
}


WriteItem* write_item_new (void) {
	return write_item_construct (TYPE_WRITE_ITEM);
}


static GtkWidget* write_item_real_get_toolbar (TabBarItem* base) {
	WriteItem * self;
	GtkWidget* result = NULL;
	self = (WriteItem*) base;
	result = NULL;
	return result;
}


static GtkWidget* write_item_real_get_view (TabBarItem* base) {
	WriteItem * self;
	GtkWidget* result = NULL;
	self = (WriteItem*) base;
	result = NULL;
	return result;
}


static GObject * write_item_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	WriteItem * self;
	parent_class = G_OBJECT_CLASS (write_item_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = WRITE_ITEM (obj);
	return obj;
}


static void write_item_class_init (WriteItemClass * klass) {
	write_item_parent_class = g_type_class_peek_parent (klass);
	TAB_BAR_ITEM_CLASS (klass)->get_toolbar = write_item_real_get_toolbar;
	TAB_BAR_ITEM_CLASS (klass)->get_view = write_item_real_get_view;
	G_OBJECT_CLASS (klass)->constructor = write_item_constructor;
}


static void write_item_instance_init (WriteItem * self) {
}


GType write_item_get_type (void) {
	static volatile gsize write_item_type_id__volatile = 0;
	if (g_once_init_enter (&write_item_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (WriteItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) write_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (WriteItem), 0, (GInstanceInitFunc) write_item_instance_init, NULL };
		GType write_item_type_id;
		write_item_type_id = g_type_register_static (TYPE_TAB_BAR_ITEM, "WriteItem", &g_define_type_info, 0);
		g_once_init_leave (&write_item_type_id__volatile, write_item_type_id);
	}
	return write_item_type_id__volatile;
}


TabBar* tab_bar_construct (GType object_type) {
	TabBar * self = NULL;
	self = (TabBar*) g_object_new (object_type, "homogeneous", FALSE, "spacing", 0, NULL);
	return self;
}


TabBar* tab_bar_new (void) {
	return tab_bar_construct (TYPE_TAB_BAR);
}


gboolean tab_bar_on_align_draw (TabBar* self, cairo_t* cr) {
	gboolean result = FALSE;
	GtkStyleContext* _tmp0_ = NULL;
	gint _tmp1_;
	gint _tmp2_;
	gboolean _tmp3_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (cr != NULL, FALSE);
	cairo_set_operator (cr, CAIRO_OPERATOR_OVER);
	_tmp0_ = gtk_widget_get_style_context ((GtkWidget*) self->priv->_align);
	_tmp1_ = gtk_widget_get_allocated_width ((GtkWidget*) self->priv->_align);
	_tmp2_ = gtk_widget_get_allocated_height ((GtkWidget*) self->priv->_align);
	gtk_render_background (_tmp0_, cr, (gdouble) 0, (gdouble) (-1), (gdouble) _tmp1_, (gdouble) (_tmp2_ + 2));
	if (GTK_IS_WIDGET (self->priv->_active_item)) {
		gboolean _tmp4_;
		_tmp4_ = gtk_widget_get_visible ((GtkWidget*) self->priv->_entry);
		_tmp3_ = !_tmp4_;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		GtkAllocation a = {0};
		GtkAllocation _tmp5_ = {0};
		gint _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		GtkWidget* _tmp9_ = NULL;
		GtkWidget* _tmp10_;
		gboolean _tmp11_;
		gtk_widget_get_allocation ((GtkWidget*) self->priv->_active_item, &_tmp5_);
		a = _tmp5_;
		cairo_set_line_width (cr, 1.0);
		cairo_set_source_rgb (cr, (gdouble) 1.0f, (gdouble) 1.0f, (gdouble) 1.0f);
		_tmp6_ = gtk_widget_get_allocated_height ((GtkWidget*) self->priv->_align);
		cairo_move_to (cr, a.x + (a.width / 2.0), (gdouble) (_tmp6_ - 5));
		_tmp7_ = gtk_widget_get_allocated_height ((GtkWidget*) self->priv->_align);
		cairo_line_to (cr, (a.x + (a.width / 2.0)) + 5, (gdouble) _tmp7_);
		_tmp8_ = gtk_widget_get_allocated_height ((GtkWidget*) self->priv->_align);
		cairo_line_to (cr, (a.x + (a.width / 2.0)) - 5, (gdouble) _tmp8_);
		cairo_close_path (cr);
		cairo_fill (cr);
		_tmp9_ = tab_bar_item_get_toolbar (self->priv->_active_item);
		_tmp10_ = _tmp9_;
		_tmp11_ = GTK_IS_WIDGET (_tmp10_);
		_g_object_unref0 (_tmp10_);
		if (_tmp11_) {
			gint _tmp12_;
			gint _tmp13_;
			cairo_save (cr);
			cairo_translate (cr, 0.5, 0.5);
			_tmp12_ = gtk_widget_get_allocated_width ((GtkWidget*) self->priv->_align);
			tab_bar_draw_arrowed_line (self, cr, 0, a.height + 3, _tmp12_, (gint) (a.x + (a.width / 2.0)));
			cairo_set_source_rgba (cr, (gdouble) 1.0f, (gdouble) 1.0f, (gdouble) 1.0f, (gdouble) 0.2f);
			cairo_stroke (cr);
			_tmp13_ = gtk_widget_get_allocated_width ((GtkWidget*) self->priv->_align);
			tab_bar_draw_arrowed_line (self, cr, 0, a.height + 2, _tmp13_, (gint) (a.x + (a.width / 2.0)));
			cairo_set_source_rgba (cr, (gdouble) 0.0f, (gdouble) 0.0f, (gdouble) 0.0f, (gdouble) 0.5f);
			cairo_stroke (cr);
			cairo_restore (cr);
		}
	}
	gtk_container_propagate_draw ((GtkContainer*) self->priv->_align, (GtkWidget*) self->priv->_vbox, cr);
	result = TRUE;
	return result;
}


static void tab_bar_draw_arrowed_line (TabBar* self, cairo_t* cr, gint x, gint y, gint width, gint point) {
	gint size;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	size = 5;
	cairo_move_to (cr, (gdouble) x, (gdouble) y);
	cairo_line_to (cr, (gdouble) (point - size), (gdouble) y);
	cairo_line_to (cr, (gdouble) point, (gdouble) (y - size));
	cairo_line_to (cr, (gdouble) (point + size), (gdouble) y);
	cairo_line_to (cr, (gdouble) (x + width), (gdouble) y);
}


static void _tab_bar_on_tab_clicked_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	tab_bar_on_tab_clicked (self, _sender);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gboolean _lambda12_ (GtkWidget* w, cairo_t* c, TabBar* self) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	g_return_val_if_fail (w != NULL, FALSE);
	g_return_val_if_fail (c != NULL, FALSE);
	_tmp0_ = stream_entry_get_showing (self->priv->_entry);
	if (_tmp0_) {
		gtk_widget_queue_draw ((GtkWidget*) self->priv->_entry);
	}
	result = FALSE;
	return result;
}


static gboolean __lambda12__gtk_widget_draw (GtkWidget* _sender, cairo_t* cr, gpointer self) {
	gboolean result;
	result = _lambda12_ (_sender, cr, self);
	return result;
}


void tab_bar_add_item (TabBar* self, TabBarItem* item) {
	GtkWidget* _tmp0_ = NULL;
	GtkWidget* _tmp1_;
	gboolean _tmp2_;
	GtkWidget* _tmp4_ = NULL;
	GtkWidget* _tmp5_;
	gboolean _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (item != NULL);
	g_signal_connect_object ((GtkButton*) item, "clicked", (GCallback) _tab_bar_on_tab_clicked_gtk_button_clicked, self, 0);
	gtk_box_pack_start ((GtkBox*) self->priv->_tab_box, (GtkWidget*) item, FALSE, FALSE, (guint) 0);
	_tmp0_ = tab_bar_item_get_toolbar (item);
	_tmp1_ = _tmp0_;
	_tmp2_ = GTK_IS_WIDGET (_tmp1_);
	_g_object_unref0 (_tmp1_);
	if (_tmp2_) {
		GtkWidget* _tmp3_ = NULL;
		GtkWidget* toolbar;
		_tmp3_ = tab_bar_item_get_toolbar (item);
		toolbar = _tmp3_;
		gtk_widget_set_no_show_all (toolbar, TRUE);
		gtk_widget_hide (toolbar);
		gtk_box_pack_start ((GtkBox*) self->priv->_toolbar_box, toolbar, TRUE, TRUE, (guint) 0);
		_g_object_unref0 (toolbar);
	}
	_tmp4_ = tab_bar_item_get_view (item);
	_tmp5_ = _tmp4_;
	_tmp6_ = GTK_IS_WIDGET (_tmp5_);
	_g_object_unref0 (_tmp5_);
	if (_tmp6_) {
		GtkWidget* _tmp7_ = NULL;
		GtkWidget* view;
		StreamEntry* _tmp8_;
		GList* _tmp9_ = NULL;
		GList* children;
		guint _tmp10_;
		_tmp7_ = tab_bar_item_get_view (item);
		view = _tmp7_;
		_tmp8_ = _g_object_ref0 (self->priv->_entry);
		_g_object_unref0 (item->entry);
		item->entry = _tmp8_;
		gtk_widget_show (view);
		gtk_box_pack_start ((GtkBox*) self->priv->_view_box, view, FALSE, FALSE, (guint) 0);
		gtk_size_group_add_widget (self->priv->_view_group, view);
		_tmp9_ = gtk_container_get_children ((GtkContainer*) self->priv->_view_box);
		children = _tmp9_;
		_tmp10_ = g_list_length (children);
		gtk_widget_set_size_request ((GtkWidget*) self->priv->_view_box, self->priv->_last_width * ((gint) _tmp10_), self->priv->_last_height);
		g_signal_connect_object (view, "draw", (GCallback) __lambda12__gtk_widget_draw, self, G_CONNECT_AFTER);
		_g_list_free0 (children);
		_g_object_unref0 (view);
	}
	gtk_widget_queue_draw ((GtkWidget*) self);
}


static gboolean _lambda11_ (TabBar* self) {
	gboolean result = FALSE;
	gfloat LENGTH;
	gint64 _tmp0_;
	gint64 diff;
	gfloat progress;
	GtkAllocation a = {0};
	GtkAllocation _tmp1_ = {0};
	gint _tmp2_;
	gfloat target_x;
	gfloat current_x;
	gfloat new_x;
	LENGTH = 200000.0f;
	_tmp0_ = g_get_monotonic_time ();
	diff = _tmp0_ - self->priv->_anim_start;
	progress = diff / LENGTH;
	gtk_widget_get_allocation ((GtkWidget*) self->priv->_view_box, &_tmp1_);
	a = _tmp1_;
	_tmp2_ = gtk_widget_get_allocated_width ((GtkWidget*) self->priv->_layout);
	target_x = (gfloat) ((self->priv->_active_item_n * _tmp2_) * (-1));
	current_x = (gfloat) a.x;
	new_x = (gfloat) 0;
	if (target_x > current_x) {
		new_x = current_x + ((target_x - current_x) * progress);
	} else {
		if (target_x < current_x) {
			new_x = current_x - ((current_x - target_x) * progress);
		}
	}
	gtk_layout_move (self->priv->_layout, (GtkWidget*) self->priv->_view_box, (gint) new_x, 0);
	gtk_widget_queue_draw ((GtkWidget*) self);
	if (diff > LENGTH) {
		gint _tmp3_;
		self->priv->_anim_id = (guint) 0;
		self->priv->_anim_offset = 1.0f;
		_tmp3_ = gtk_widget_get_allocated_width ((GtkWidget*) self->priv->_layout);
		gtk_layout_move (self->priv->_layout, (GtkWidget*) self->priv->_view_box, (_tmp3_ * self->priv->_active_item_n) * (-1), 0);
		result = FALSE;
		return result;
	}
	result = TRUE;
	return result;
}


static gboolean __lambda11__gsource_func (gpointer self) {
	gboolean result;
	result = _lambda11_ (self);
	return result;
}


void tab_bar_on_tab_clicked (TabBar* self, GtkButton* gtk_item) {
	GtkButton* _tmp0_;
	TabBarItem* _tmp1_;
	TabBarItem* item;
	gboolean _tmp2_ = FALSE;
	TabBarItem* _tmp8_;
	GtkWidget* _tmp9_ = NULL;
	GtkWidget* _tmp10_;
	gboolean _tmp11_;
	GtkWidget* _tmp14_ = NULL;
	GtkWidget* _tmp15_;
	gboolean _tmp16_;
	g_return_if_fail (self != NULL);
	stream_entry_set_showing (self->priv->_entry, FALSE);
	gwibber_gtk_input_text_view_reset (self->priv->_entry->text_view);
	_tmp0_ = gtk_item;
	_tmp1_ = _g_object_ref0 (IS_TAB_BAR_ITEM (_tmp0_) ? ((TabBarItem*) _tmp0_) : NULL);
	item = _tmp1_;
	if (self->priv->_active_item == item) {
		_tmp2_ = TRUE;
	} else {
		_tmp2_ = gtk_item == NULL;
	}
	if (_tmp2_) {
		_g_object_unref0 (item);
		return;
	}
	if (IS_TAB_BAR_ITEM (self->priv->_active_item)) {
		GtkWidget* _tmp3_ = NULL;
		GtkWidget* _tmp4_;
		gboolean _tmp5_;
		tab_bar_item_set_active (self->priv->_active_item, FALSE);
		_tmp3_ = tab_bar_item_get_toolbar (self->priv->_active_item);
		_tmp4_ = _tmp3_;
		_tmp5_ = GTK_IS_WIDGET (_tmp4_);
		_g_object_unref0 (_tmp4_);
		if (_tmp5_) {
			GtkWidget* _tmp6_ = NULL;
			GtkWidget* _tmp7_;
			_tmp6_ = tab_bar_item_get_toolbar (self->priv->_active_item);
			_tmp7_ = _tmp6_;
			gtk_widget_hide (_tmp7_);
			_g_object_unref0 (_tmp7_);
		}
	}
	_tmp8_ = _g_object_ref0 (item);
	_g_object_unref0 (self->priv->_active_item);
	self->priv->_active_item = _tmp8_;
	tab_bar_item_set_active (self->priv->_active_item, TRUE);
	_tmp9_ = tab_bar_item_get_toolbar (self->priv->_active_item);
	_tmp10_ = _tmp9_;
	_tmp11_ = GTK_IS_WIDGET (_tmp10_);
	_g_object_unref0 (_tmp10_);
	if (_tmp11_) {
		GtkWidget* _tmp12_ = NULL;
		GtkWidget* _tmp13_;
		_tmp12_ = tab_bar_item_get_toolbar (self->priv->_active_item);
		_tmp13_ = _tmp12_;
		gtk_widget_show (_tmp13_);
		_g_object_unref0 (_tmp13_);
		gtk_alignment_set_padding (self->priv->_align, (guint) 0, (guint) 8, (guint) 0, (guint) 0);
	} else {
		gtk_alignment_set_padding (self->priv->_align, (guint) 0, (guint) 0, (guint) 0, (guint) 0);
	}
	_tmp14_ = tab_bar_item_get_view (self->priv->_active_item);
	_tmp15_ = _tmp14_;
	_tmp16_ = GTK_IS_WIDGET (_tmp15_);
	_g_object_unref0 (_tmp15_);
	if (_tmp16_) {
		GList* _tmp17_ = NULL;
		GList* children;
		gint i;
		gint64 _tmp22_;
		guint _tmp23_;
		GtkWidget* _tmp24_ = NULL;
		GtkWidget* _tmp25_;
		_tmp17_ = gtk_container_get_children ((GtkContainer*) self->priv->_view_box);
		children = _tmp17_;
		i = 0;
		{
			GList* child_collection;
			GList* child_it;
			child_collection = children;
			for (child_it = child_collection; child_it != NULL; child_it = child_it->next) {
				GtkWidget* _tmp18_;
				GtkWidget* child;
				_tmp18_ = _g_object_ref0 ((GtkWidget*) child_it->data);
				child = _tmp18_;
				{
					GtkWidget* _tmp19_ = NULL;
					GtkWidget* _tmp20_;
					gboolean _tmp21_;
					_tmp19_ = tab_bar_item_get_view (self->priv->_active_item);
					_tmp20_ = _tmp19_;
					_tmp21_ = child == _tmp20_;
					_g_object_unref0 (_tmp20_);
					if (_tmp21_) {
						_g_object_unref0 (child);
						break;
					}
					i++;
					_g_object_unref0 (child);
				}
			}
		}
		self->priv->_active_item_n = i;
		if (self->priv->_anim_id != 0) {
			g_source_remove (self->priv->_anim_id);
		}
		_tmp22_ = g_get_monotonic_time ();
		self->priv->_anim_start = _tmp22_;
		_tmp23_ = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 15, __lambda11__gsource_func, g_object_ref (self), g_object_unref);
		self->priv->_anim_id = _tmp23_;
		_tmp24_ = tab_bar_item_get_view (self->priv->_active_item);
		_tmp25_ = _tmp24_;
		gtk_widget_queue_draw (_tmp25_);
		_g_object_unref0 (_tmp25_);
		gtk_widget_queue_draw ((GtkWidget*) self->priv->_view_box);
		gtk_widget_queue_draw ((GtkWidget*) self->priv->_layout);
		_g_list_free0 (children);
	}
	gtk_widget_queue_draw ((GtkWidget*) self->priv->_entry);
	g_signal_emit_by_name (self, "tab-changed", item);
	gtk_widget_queue_draw ((GtkWidget*) self);
	_g_object_unref0 (item);
}


void tab_bar_show_entry (TabBar* self) {
	g_return_if_fail (self != NULL);
}


void tab_bar_on_write_clicked (TabBar* self) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = stream_entry_get_showing (self->priv->_entry);
	if (_tmp0_) {
		stream_entry_set_showing (self->priv->_entry, FALSE);
		gwibber_gtk_input_text_view_reset (self->priv->_entry->text_view);
		gtk_widget_set_sensitive ((GtkWidget*) self->priv->_view_box, TRUE);
	} else {
		stream_entry_set_showing (self->priv->_entry, TRUE);
		gtk_widget_grab_focus ((GtkWidget*) self->priv->_entry->text_view);
		gtk_widget_set_sensitive ((GtkWidget*) self->priv->_view_box, FALSE);
	}
	gtk_widget_queue_draw ((GtkWidget*) self);
}


static gboolean _tab_bar_on_align_draw_gtk_widget_draw (GtkWidget* _sender, cairo_t* cr, gpointer self) {
	gboolean result;
	result = tab_bar_on_align_draw (self, cr);
	return result;
}


static void _tab_bar_on_write_clicked_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	tab_bar_on_write_clicked (self);
}


static void _lambda13_ (TabBar* self) {
	gboolean _tmp0_;
	gboolean _tmp1_;
	_tmp0_ = stream_entry_get_showing (self->priv->_entry);
	if (!_tmp0_) {
		gwibber_gtk_input_text_view_reset (self->priv->_entry->text_view);
	}
	_tmp1_ = stream_entry_get_showing (self->priv->_entry);
	gtk_widget_set_sensitive ((GtkWidget*) self->priv->_view_box, !_tmp1_);
}


static void __lambda13__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_lambda13_ (self);
}


static void _lambda14_ (GdkRectangle* a, TabBar* self) {
	gboolean _tmp0_ = FALSE;
	if (self->priv->_last_width != (*a).width) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = self->priv->_last_height != (*a).height;
	}
	if (_tmp0_) {
		GList* _tmp1_ = NULL;
		GList* children;
		guint _tmp3_;
		self->priv->_last_width = (*a).width;
		self->priv->_last_height = (*a).height;
		_tmp1_ = gtk_container_get_children ((GtkContainer*) self->priv->_view_box);
		children = _tmp1_;
		{
			GList* child_collection;
			GList* child_it;
			child_collection = children;
			for (child_it = child_collection; child_it != NULL; child_it = child_it->next) {
				GtkWidget* _tmp2_;
				GtkWidget* child;
				_tmp2_ = _g_object_ref0 ((GtkWidget*) child_it->data);
				child = _tmp2_;
				{
					gtk_widget_set_size_request (child, self->priv->_last_width, self->priv->_last_height);
					gtk_widget_queue_draw (child);
					_g_object_unref0 (child);
				}
			}
		}
		_tmp3_ = g_list_length (children);
		gtk_widget_set_size_request ((GtkWidget*) self->priv->_view_box, self->priv->_last_width * ((gint) _tmp3_), self->priv->_last_height);
		gtk_widget_set_size_request ((GtkWidget*) self->priv->_entry, self->priv->_last_width, self->priv->_last_height);
		gtk_widget_queue_draw ((GtkWidget*) self);
		_g_list_free0 (children);
	}
}


static void __lambda14__gtk_widget_size_allocate (GtkWidget* _sender, GdkRectangle* allocation, gpointer self) {
	_lambda14_ (allocation, self);
}


static GObject * tab_bar_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	TabBar * self;
	GtkAlignment* _tmp0_ = NULL;
	GtkStyleContext* _tmp1_ = NULL;
	GtkStyleContext* _tmp2_ = NULL;
	GtkVBox* _tmp3_ = NULL;
	GtkHBox* _tmp4_ = NULL;
	GtkHBox* _tmp5_ = NULL;
	GtkLayout* _tmp6_ = NULL;
	GtkHBox* _tmp7_ = NULL;
	GtkSizeGroup* _tmp8_ = NULL;
	WriteItem* _tmp9_ = NULL;
	StreamEntry* _tmp10_ = NULL;
	parent_class = G_OBJECT_CLASS (tab_bar_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = TAB_BAR (obj);
	_tmp0_ = (GtkAlignment*) gtk_alignment_new (0.0f, 0.0f, 1.0f, 1.0f);
	_g_object_unref0 (self->priv->_align);
	self->priv->_align = g_object_ref_sink (_tmp0_);
	_tmp1_ = gtk_widget_get_style_context ((GtkWidget*) self->priv->_align);
	gtk_style_context_add_class (_tmp1_, "primary-toolbar");
	_tmp2_ = gtk_widget_get_style_context ((GtkWidget*) self->priv->_align);
	gtk_style_context_add_class (_tmp2_, "toolbar");
	g_signal_connect_object ((GtkWidget*) self->priv->_align, "draw", (GCallback) _tab_bar_on_align_draw_gtk_widget_draw, self, 0);
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) self->priv->_align, FALSE, TRUE, (guint) 0);
	_tmp3_ = (GtkVBox*) gtk_vbox_new (FALSE, 8);
	_g_object_unref0 (self->priv->_vbox);
	self->priv->_vbox = g_object_ref_sink (_tmp3_);
	gtk_container_add ((GtkContainer*) self->priv->_align, (GtkWidget*) self->priv->_vbox);
	_tmp4_ = (GtkHBox*) gtk_hbox_new (FALSE, 0);
	_g_object_unref0 (self->priv->_tab_box);
	self->priv->_tab_box = g_object_ref_sink (_tmp4_);
	gtk_box_pack_start ((GtkBox*) self->priv->_vbox, (GtkWidget*) self->priv->_tab_box, FALSE, FALSE, (guint) 0);
	_tmp5_ = (GtkHBox*) gtk_hbox_new (FALSE, 0);
	_g_object_unref0 (self->priv->_toolbar_box);
	self->priv->_toolbar_box = g_object_ref_sink (_tmp5_);
	gtk_box_pack_start ((GtkBox*) self->priv->_vbox, (GtkWidget*) self->priv->_toolbar_box, FALSE, TRUE, (guint) 0);
	_tmp6_ = (GtkLayout*) gtk_layout_new (NULL, NULL);
	_g_object_unref0 (self->priv->_layout);
	self->priv->_layout = g_object_ref_sink (_tmp6_);
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) self->priv->_layout, TRUE, TRUE, (guint) 0);
	_tmp7_ = (GtkHBox*) gtk_hbox_new (TRUE, 0);
	_g_object_unref0 (self->priv->_view_box);
	self->priv->_view_box = g_object_ref_sink (_tmp7_);
	gtk_layout_put (self->priv->_layout, (GtkWidget*) self->priv->_view_box, 0, 0);
	_tmp8_ = gtk_size_group_new (GTK_SIZE_GROUP_BOTH);
	_g_object_unref0 (self->priv->_view_group);
	self->priv->_view_group = _tmp8_;
	_tmp9_ = write_item_new ();
	_g_object_unref0 (self->priv->_write_item);
	self->priv->_write_item = g_object_ref_sink (_tmp9_);
	g_signal_connect_object ((GtkButton*) self->priv->_write_item, "clicked", (GCallback) _tab_bar_on_write_clicked_gtk_button_clicked, self, 0);
	gtk_box_pack_end ((GtkBox*) self->priv->_tab_box, (GtkWidget*) self->priv->_write_item, FALSE, TRUE, (guint) 0);
	_tmp10_ = stream_entry_new ();
	_g_object_unref0 (self->priv->_entry);
	self->priv->_entry = g_object_ref_sink (_tmp10_);
	gtk_layout_put (self->priv->_layout, (GtkWidget*) self->priv->_entry, 0, 0);
	g_signal_connect_object ((GObject*) self->priv->_entry, "notify::showing", (GCallback) __lambda13__g_object_notify, self, 0);
	g_signal_connect_object ((GtkWidget*) self->priv->_layout, "size-allocate", (GCallback) __lambda14__gtk_widget_size_allocate, self, G_CONNECT_AFTER);
	gtk_widget_show_all ((GtkWidget*) self);
	return obj;
}


static void tab_bar_class_init (TabBarClass * klass) {
	tab_bar_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (TabBarPrivate));
	G_OBJECT_CLASS (klass)->constructor = tab_bar_constructor;
	G_OBJECT_CLASS (klass)->finalize = tab_bar_finalize;
	g_signal_new ("tab_changed", TYPE_TAB_BAR, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, TYPE_TAB_BAR_ITEM);
}


static void tab_bar_instance_init (TabBar * self) {
	self->priv = TAB_BAR_GET_PRIVATE (self);
	self->priv->_entry = NULL;
	self->priv->_active_item = NULL;
	self->priv->_active_item_n = 0;
	self->priv->_anim_id = (guint) 0;
	self->priv->_anim_offset = 0.0f;
	self->priv->_anim_start = (gint64) 0;
}


static void tab_bar_finalize (GObject* obj) {
	TabBar * self;
	self = TAB_BAR (obj);
	_g_object_unref0 (self->priv->_align);
	_g_object_unref0 (self->priv->_vbox);
	_g_object_unref0 (self->priv->_tab_box);
	_g_object_unref0 (self->priv->_toolbar_box);
	_g_object_unref0 (self->priv->_layout);
	_g_object_unref0 (self->priv->_view_box);
	_g_object_unref0 (self->priv->_view_group);
	_g_object_unref0 (self->priv->_write_item);
	_g_object_unref0 (self->priv->_entry);
	_g_object_unref0 (self->priv->_active_item);
	G_OBJECT_CLASS (tab_bar_parent_class)->finalize (obj);
}


GType tab_bar_get_type (void) {
	static volatile gsize tab_bar_type_id__volatile = 0;
	if (g_once_init_enter (&tab_bar_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TabBarClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tab_bar_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TabBar), 0, (GInstanceInitFunc) tab_bar_instance_init, NULL };
		GType tab_bar_type_id;
		tab_bar_type_id = g_type_register_static (GTK_TYPE_VBOX, "TabBar", &g_define_type_info, 0);
		g_once_init_leave (&tab_bar_type_id__volatile, tab_bar_type_id);
	}
	return tab_bar_type_id__volatile;
}



