#include <check.h>

#define LOGFILE_PREFIX ""

extern Suite *make_mapping_suite();
extern Suite *make_transform_suite();

int main(int argc CK_ATTRIBUTE_UNUSED, char* argv[] CK_ATTRIBUTE_UNUSED)
{
	Suite *s = suite_create("grail-test-suite");
	SRunner *sr = srunner_create(s);
	int num_failed;

	srunner_add_suite(sr, make_mapping_suite());
	srunner_add_suite(sr, make_transform_suite());

	srunner_set_log(sr, "check_grail.log");
	srunner_set_xml(sr, "check_grail.xml");
	srunner_run_all(sr, CK_NORMAL);
	num_failed = srunner_ntests_failed(sr);

	srunner_free(sr);

	return num_failed;
}
