#
# @file geisview/gesture_classview.py
# @brief GestureClass viewer for geisview.
#
# Copyright (C) 2011 Canonical Ltd
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#

import pygtk
pygtk.require('2.0')
import gtk

class GestureClassView(gtk.Window):

    def __init__(self, gesture_classes):
        gtk.Window.__init__(self)
        self.set_title("GEIS GestureClasss")
        self.set_size_request(200, 200)

        self._tree_store = gtk.TreeStore(str, str)
        for (class_id, gclass) in gesture_classes.iteritems():
            it = self._tree_store.append(None, ["%s" % gclass.id(),
                                                "%s" % gclass.name()])
        self._tree_view = gtk.TreeView(self._tree_store)
#        self._tree_view.set_mode(gtk.SELECTION_SINGLE)

        cell = gtk.CellRendererText()
        col = gtk.TreeViewColumn('ID')
        col.pack_start(cell, True)
        col.add_attribute(cell, 'text', 0)
        self._tree_view.append_column(col)

        cell = gtk.CellRendererText()
        col = gtk.TreeViewColumn('Name')
        col.pack_start(cell, True)
        col.add_attribute(cell, 'text', 1)
        self._tree_view.append_column(col)

        self.add(self._tree_view)
        self.show_all()

