'\" t
.\" Manual page created with latex2man on Tue Feb  7 20:06:27 EST 2012
.\" NOTE: This file is generated, DO NOT EDIT.
.de Vb
.ft CW
.nf
..
.de Ve
.ft R

.fi
..
.TH "UNW\\_GETCONTEXT" "3" "07 February 2012" "Programming Library " "Programming Library "
.SH NAME
unw_getcontext
\-\- get initial machine\-state 
.PP
.SH SYNOPSIS

.PP
#include <libunwind.h>
.br
.PP
int
unw_getcontext(unw_context_t *ucp);
.br
.PP
.SH DESCRIPTION

.PP
The unw_getcontext()
routine initializes the context structure 
pointed to by ucp
with the machine\-state of the call\-site. The 
exact set of registers stored by unw_getcontext()
is 
platform\-specific, but, in general, at least all preserved 
(``callee\-saved\&'') and all frame\-related registers, such as the 
stack\-pointer, will be stored. 
.PP
This routine is normally implemented as a macro and applications 
should not attempt to take its address. 
.PP
.SH PLATFORM\-SPECIFIC NOTES

.PP
On IA\-64, unw_context_t
has a layout that is compatible with 
that of ucontext_t
and such structures can be initialized with 
getcontext()
instead of unw_getcontext().
However, the 
reverse is \fInot\fP
true and it is \fInot\fP
safe to use structures 
initialized by unw_getcontext()
in places where a structure 
initialized by getcontext()
is expected. The reason for this 
asymmetry is that unw_getcontext()
is optimized for maximum 
performance and does not, for example, save the signal mask. 
.PP
.SH RETURN VALUE

.PP
On successful completion, unw_getcontext()
returns 0. 
Otherwise, a value of \-1 is returned. 
.PP
.SH THREAD AND SIGNAL SAFETY

.PP
unw_getcontext()
is thread\-safe as well as safe to use 
from a signal handler. 
.PP
.SH SEE ALSO

.PP
libunwind(3),
unw_init_local(3)
.PP
.SH AUTHOR

.PP
David Mosberger\-Tang
.br
Email: \fBdmosberger@gmail.com\fP
.br
WWW: \fBhttp://www.nongnu.org/libunwind/\fP\&.
.\" NOTE: This file is generated, DO NOT EDIT.
