<?
	/**
	 * Create the images for the Firefox preferences dialog in the specified
	 * directory.
	 */
	function createPreferences($dir) {
		renderPreferences($dir.'Options.png', 32);
	}
	
	/**
	 * Render the complete image to a given file.
	 *
	 * The columns are:
	 * Main, Tabs, Content, Feeds, Privacy, Security, Advanced
	 *
	 * The rows are:
	 * Normal, Hover
	 */
	function renderPreferences($filename, $size) {
		// define the icons to render
		$icons = array(
			array(CATEGORIES, 'preferences-desktop'),
			getTabIcon(),
			array(CATEGORIES, 'applications-internet'),
			getFeedsIcon(),
			array(ACTIONS, 'edit-clear'),
			array(PLACES, 'privacy'),					// TODO
			array(CATEGORIES, 'applications-system')
		);
		
		// compose the first rows of the toolbar
		$firstrow = renderRow($icons, $size);
		$highlight = renderHighlight($firstrow);
		
		// create single PNG containing all states
		$states = array($firstrow, $highlight);
		$prefs =
			renderColumnFromPngs(
				$states, count($icons) * $size, $size);
		copy($prefs, $filename);
	}
		
	/**
	 * Get the neutral tab icon.
	 */
	function getTabIcon() {
		// return custom icon (TODO)
		return array(PLACES, 'tab');	
	}

	/**
	 * Get the feeds icon.
	 */
	function getFeedsIcon() {
		// return custom icon (TODO)
		return array(PLACES, 'feeds');
	}
	
?>
