/*
 * $Id: JmsConnectionFactoryTestCase.java 10489 2008-01-23 17:53:38Z dfeist $
 * --------------------------------------------------------------------------------------
 * Copyright (c) MuleSource, Inc.  All rights reserved.  http://www.mulesource.com
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.transport.jms;

import org.mule.tck.FunctionalTestCase;
import org.mule.transport.jms.test.TestConnectionFactory;

import javax.jms.ConnectionFactory;

public class JmsConnectionFactoryTestCase extends FunctionalTestCase
{
    protected String getConfigResources()
    {
        return "jms-connection-factory.xml";
    }

    /**
     * Test providerProperties set on JmsConnector are not passed to the underlying
     * ConnectionFactory.
     */
    public void testProviderPropertiesNotPassed() throws Exception
    {
        JmsConnector c = (JmsConnector)muleContext.getRegistry().lookupConnector("jmsConnector1");
        assertNotNull(c);

        ConnectionFactory cf = c.getConnectionFactory();
        assertTrue(cf instanceof TestConnectionFactory);
        assertEquals("Provider properties should not be passed to the ConnectionFactory.", "NOT_SET",
            ((TestConnectionFactory)cf).getProviderProperty());
    }

    /**
     * Test connectionFactoryProperties set on JmsConnector are actually passed to
     * the underlying ConnectionFactory.
     */
    public void testConnectionFactoryPropertiesPassed() throws Exception
    {
        JmsConnector c = (JmsConnector)muleContext.getRegistry().lookupConnector("jmsConnector2");
        assertNotNull(c);

        ConnectionFactory cf = c.getConnectionFactory();
        assertTrue(cf instanceof TestConnectionFactory);
        assertEquals("ConnectionFactory properties should be passed to the ConnectionFactory.", "TEST_VALUE",
            ((TestConnectionFactory)cf).getConnectionFactoryProperty());
    }
}
