%%
%% %CopyrightBegin%
%%
%% Copyright Ericsson AB 2009-2011. All Rights Reserved.
%%
%% The contents of this file are subject to the Erlang Public License,
%% Version 1.1, (the "License"); you may not use this file except in
%% compliance with the License. You should have received a copy of the
%% Erlang Public License along with this software. If not, it can be
%% retrieved online at http://www.erlang.org/.
%%
%% Software distributed under the License is distributed on an "AS IS"
%% basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
%% the License for the specific language governing rights and limitations
%% under the License.
%%
%% %CopyrightEnd%
%%

%%%-------------------------------------------------------------------
%%% File: ct_repeat_1_SUITE.erl
%%%
%%% Description:
%%% Test some simple test case group scenarios with repeat.
%%%
%%% The suites used for the test are located in the data directory.
%%%-------------------------------------------------------------------
-module(ct_repeat_1_SUITE).

-compile(export_all).

-include_lib("common_test/include/ct.hrl").
-include_lib("common_test/include/ct_event.hrl").

-define(eh, ct_test_support_eh).

%%--------------------------------------------------------------------
%% TEST SERVER CALLBACK FUNCTIONS
%%--------------------------------------------------------------------

%%--------------------------------------------------------------------
%% Description: Since Common Test starts another Test Server
%% instance, the tests need to be performed on a separate node (or
%% there will be clashes with logging processes etc).
%%--------------------------------------------------------------------
init_per_suite(Config) ->
    Config1 = ct_test_support:init_per_suite(Config),
    Config1.

end_per_suite(Config) ->
    ct_test_support:end_per_suite(Config).

init_per_testcase(TestCase, Config) ->
    ct_test_support:init_per_testcase(TestCase, Config).

end_per_testcase(TestCase, Config) ->
    ct_test_support:end_per_testcase(TestCase, Config).

suite() -> [{ct_hooks,[ts_install_cth]}].

all() -> 
    [repeat_cs, repeat_cs_and_grs, repeat_seq,
     repeat_cs_until_any_ok, repeat_gr_until_any_ok,
     repeat_cs_until_any_fail, repeat_gr_until_any_fail,
     repeat_cs_until_all_ok, repeat_gr_until_all_ok,
     repeat_cs_until_all_fail, repeat_gr_until_all_fail,
     repeat_seq_until_any_fail,
     repeat_shuffled_seq_until_any_fail].

groups() -> 
    [].

init_per_group(_GroupName, Config) ->
	Config.

end_per_group(_GroupName, Config) ->
	Config.


%%--------------------------------------------------------------------
%% TEST CASES
%%--------------------------------------------------------------------

repeat_cs(Config) when is_list(Config) ->
    execute(repeat_cs,
	    "repeat_1_SUITE", repeat_cs,
	    Config).
%%%-------------------------------------------------------------------
repeat_cs_and_grs(Config) when is_list(Config) ->
    execute(repeat_cs_and_grs,
	    "repeat_1_SUITE", repeat_cs_and_grs,
	    Config).
%%%-------------------------------------------------------------------
repeat_seq(Config) when is_list(Config) ->
    execute(repeat_seq,
	    "repeat_1_SUITE", repeat_seq,
	    Config).
%%%-------------------------------------------------------------------
repeat_cs_until_any_ok(Config) when is_list(Config) ->
    execute(repeat_cs_until_any_ok,
	    "repeat_1_SUITE", repeat_cs_until_any_ok,
	    Config).
%%%-------------------------------------------------------------------
repeat_gr_until_any_ok(Config) when is_list(Config) ->
    execute(repeat_gr_until_any_ok,
	    "repeat_1_SUITE", repeat_gr_until_any_ok,
	    Config).
%%%-------------------------------------------------------------------
repeat_cs_until_any_fail(Config) when is_list(Config) ->
    execute(repeat_cs_until_any_fail,
	    "repeat_1_SUITE", repeat_cs_until_any_fail,
	    Config).
%%%-------------------------------------------------------------------
repeat_gr_until_any_fail(Config) when is_list(Config) ->
    execute(repeat_gr_until_any_fail,
	    "repeat_1_SUITE", repeat_gr_until_any_fail,
	    Config).
%%%-------------------------------------------------------------------
repeat_cs_until_all_ok(Config) when is_list(Config) ->
    execute(repeat_cs_until_all_ok,
	    "repeat_1_SUITE", repeat_cs_until_all_ok,
	    Config).
%%%-------------------------------------------------------------------
repeat_gr_until_all_ok(Config) when is_list(Config) ->
    execute(repeat_gr_until_all_ok,
	    "repeat_1_SUITE", repeat_gr_until_all_ok,
	    Config).
%%%-------------------------------------------------------------------
repeat_cs_until_all_fail(Config) when is_list(Config) ->
    execute(repeat_cs_until_all_fail,
	    "repeat_1_SUITE", repeat_cs_until_all_fail,
	    Config).
%%%-------------------------------------------------------------------
repeat_gr_until_all_fail(Config) when is_list(Config) ->
    execute(repeat_gr_until_all_fail,
	    "repeat_1_SUITE", repeat_gr_until_all_fail,
	    Config).
%%%-------------------------------------------------------------------
repeat_seq_until_any_fail(Config) when is_list(Config) ->
    execute(repeat_seq_until_any_fail,
	    "repeat_1_SUITE", repeat_seq_until_any_fail,
	    Config).
%%%-------------------------------------------------------------------
repeat_shuffled_seq_until_any_fail(Config) when is_list(Config) ->
    execute(repeat_shuffled_seq_until_any_fail,
	    "repeat_1_SUITE", repeat_shuffled_seq_until_any_fail,
	    Config).

%%%-----------------------------------------------------------------
%%% HELP FUNCTIONS
%%%-----------------------------------------------------------------
execute(TestCase, SuiteName, Group, Config) ->
    DataDir = ?config(data_dir, Config),
    Suite = filename:join(DataDir, SuiteName),

    {Opts,ERPid} = setup([{suite,Suite},{group,Group},{label,TestCase}], Config),
    ok = ct_test_support:run(Opts, Config),
    Events = ct_test_support:get_events(ERPid, Config),

    ct_test_support:log_events(TestCase,
			       reformat(Events, ?eh),
			       ?config(priv_dir, Config)),

    TestEvents = events_to_check(TestCase),
    ok = ct_test_support:verify_events(TestEvents, Events, Config).

setup(Test, Config) ->
    Opts0 = ct_test_support:get_opts(Config),
    Level = ?config(trace_level, Config),
    EvHArgs = [{cbm,ct_test_support},{trace_level,Level}],
    Opts = Opts0 ++ [{event_handler,{?eh,EvHArgs}} | Test],
    ERPid = ct_test_support:start_event_receiver(Config),
    {Opts,ERPid}.

reformat(Events, EH) ->
    ct_test_support:reformat(Events, EH).
%reformat(Events, _EH) ->
%    Events.

%%%-----------------------------------------------------------------
%%% TEST EVENTS
%%%-----------------------------------------------------------------
events_to_check(Test) ->
    %% 2 tests (ct:run_test + script_start) is default
    events_to_check(Test, 2).

events_to_check(_, 0) ->
    [];
events_to_check(Test, N) ->
    test_events(Test) ++ events_to_check(Test, N-1).

test_events(repeat_cs) ->
    [{?eh,start_logging,{'DEF','RUNDIR'}},
     {?eh,test_start,{'DEF',{'START_TIME','LOGDIR'}}},
     {?eh,start_info,{1,1,unknown}},
     [{?eh,tc_done,{repeat_1_SUITE,{init_per_group,repeat_cs,[]},ok}},
      [{?eh,tc_done,{repeat_1_SUITE,{init_per_group,repeat_cs_1,[]},ok}},
       {?eh,test_stats,{2,0,{0,0}}},
       {?eh,tc_done,{repeat_1_SUITE,{end_per_group,repeat_cs_1,[]},ok}}],
      [{?eh,tc_done,{repeat_1_SUITE,{init_per_group,repeat_cs_2,[{repeat,2}]},ok}},
       {?eh,test_stats,{4,0,{0,0}}},
       {?eh,tc_done,{repeat_1_SUITE,{end_per_group,repeat_cs_2,[{repeat,2}]},ok}}],
      [{?eh,tc_done,{repeat_1_SUITE,{init_per_group,repeat_cs_2,[]},ok}},
       {?eh,test_stats,{6,0,{0,0}}},
       {?eh,tc_done,{repeat_1_SUITE,{end_per_group,repeat_cs_2,[]},ok}}],
      {?eh,tc_done,{repeat_1_SUITE,{end_per_group,repeat_cs,[]},ok}}],
     {?eh,test_done,{'DEF','STOP_TIME'}},
     {?eh,stop_logging,[]}];

test_events(repeat_cs_and_grs) ->
    [{?eh,start_logging,{'DEF','RUNDIR'}},
     {?eh,test_start,{'DEF',{'START_TIME','LOGDIR'}}},
     {?eh,start_info,{1,1,unknown}},
     [{?eh,tc_done,{repeat_1_SUITE,{init_per_group,repeat_cs_and_grs,[{repeat,2}]},ok}},
      [{?eh,tc_done,{repeat_1_SUITE,{init_per_group,gr_ok_1,[]},ok}},
       {?eh,test_stats,{1,0,{0,0}}},
       {?eh,tc_done,{repeat_1_SUITE,{end_per_group,gr_ok_1,[]},ok}}],
      {?eh,tc_done,{repeat_1_SUITE,tc_fail_1,{failed,{error,{{badmatch,2},'_'}}}}},
      {?eh,test_stats,{1,1,{0,0}}},
      [{?eh,tc_done,{repeat_1_SUITE,{init_per_group,gr_fail_result,[]},ok}},
       {?eh,test_stats,{2,1,{0,0}}},
       {?eh,tc_done,{repeat_1_SUITE,{end_per_group,gr_fail_result,[]},
		     {return_group_result,failed}}}],
      {?eh,test_stats,{3,1,{0,0}}},
      [{?eh,tc_done,{repeat_1_SUITE,{init_per_group,gr_fail_init,[]},
		     {failed,{error,fails_on_purpose}}}},
       {?eh,tc_auto_skip,{repeat_1_SUITE,tc_ok_1,
			  {failed,{repeat_1_SUITE,init_per_group,
				   {'EXIT',fails_on_purpose}}}}},
       {?eh,test_stats,{3,1,{0,1}}},
       {?eh,tc_auto_skip,{repeat_1_SUITE,end_per_group,
			  {failed,{repeat_1_SUITE,init_per_group,
				   {'EXIT',fails_on_purpose}}}}}],
      {?eh,test_stats,{4,1,{0,1}}},
      {?eh,tc_done,{repeat_1_SUITE,{end_per_group,repeat_cs_and_grs,[{repeat,2}]},ok}}],
     [{?eh,tc_done,{repeat_1_SUITE,{init_per_group,repeat_cs_and_grs,[]},ok}},
      [{?eh,tc_done,{repeat_1_SUITE,{init_per_group,gr_ok_1,[]},ok}},
       {?eh,test_stats,{5,1,{0,1}}},
       {?eh,tc_done,{repeat_1_SUITE,{end_per_group,gr_ok_1,[]},ok}}],
      {?eh,tc_done,{repeat_1_SUITE,tc_fail_1,{failed,{error,{{badmatch,2},'_'}}}}},
      {?eh,test_stats,{5,2,{0,1}}},
      [{?eh,tc_done,{repeat_1_SUITE,{init_per_group,gr_fail_result,[]},ok}},
       {?eh,test_stats,{6,2,{0,1}}},
       {?eh,tc_done,{repeat_1_SUITE,{end_per_group,gr_fail_result,[]},
		     {return_group_result,failed}}}],
      {?eh,test_stats,{7,2,{0,1}}},
      [{?eh,tc_done,{repeat_1_SUITE,{init_per_group,gr_fail_init,[]},
		     {failed,{error,fails_on_purpose}}}},
       {?eh,tc_auto_skip,{repeat_1_SUITE,tc_ok_1,
			  {failed,{repeat_1_SUITE,init_per_group,
				   {'EXIT',fails_on_purpose}}}}},
       {?eh,test_stats,{7,2,{0,2}}},
       {?eh,tc_auto_skip,{repeat_1_SUITE,end_per_group,
			  {failed,{repeat_1_SUITE,init_per_group,
				   {'EXIT',fails_on_purpose}}}}}],
      {?eh,test_stats,{8,2,{0,2}}},
      {?eh,tc_done,{repeat_1_SUITE,{end_per_group,repeat_cs_and_grs,[]},ok}}],
     {?eh,test_done,{'DEF','STOP_TIME'}},
     {?eh,stop_logging,[]}
    ];

test_events(repeat_seq) ->
    [{?eh,start_logging,{'DEF','RUNDIR'}},
     {?eh,start_info,{1,1,unknown}},
     [{?eh,tc_done,{repeat_1_SUITE,{init_per_group,repeat_seq,[]},ok}},
      [{?eh,tc_done,{repeat_1_SUITE,
		     {init_per_group,repeat_seq_1,[sequence,{repeat,2}]},
		     ok}},
       {?eh,test_stats,{1,0,{0,0}}},
       {?eh,test_stats,{1,1,{0,0}}},
       {?eh,tc_auto_skip,{repeat_1_SUITE,tc_ok_2,
			  {failed,{repeat_1_SUITE,tc_fail_1}}}},
       {?eh,test_stats,{1,1,{0,1}}},
       {?eh,tc_done,{repeat_1_SUITE,
		     {end_per_group,repeat_seq_1,[sequence,{repeat,2}]},
		     ok}}],
      [{?eh,tc_done,{repeat_1_SUITE,{init_per_group,repeat_seq_1,
				     [sequence]},ok}},
       {?eh,test_stats,{2,2,{0,2}}},
       {?eh,tc_done,{repeat_1_SUITE,{end_per_group,repeat_seq_1,
				     [sequence]},ok}}],

      [{?eh,tc_done,{repeat_1_SUITE,
		     {init_per_group,repeat_seq_2,[sequence,{repeat,2}]},
		     ok}},
       {?eh,test_stats,{3,2,{0,2}}},
       [{?eh,tc_done,{repeat_1_SUITE,
		      {init_per_group,gr_fail_result,[]},ok}},
	{?eh,test_stats,{4,2,{0,2}}},
	{?eh,tc_done,{repeat_1_SUITE,
		      {end_per_group,gr_fail_result,[]},
		      {return_group_result,failed}}}],
       {?eh,tc_auto_skip,{repeat_1_SUITE,tc_ok_2,
			  {group_result,gr_fail_result,failed}}},
       {?eh,test_stats,{4,2,{0,3}}},
       {?eh,tc_done,{repeat_1_SUITE,
		     {end_per_group,repeat_seq_2,[sequence,{repeat,2}]},
		     ok}}],
      [{?eh,tc_done,
        {repeat_1_SUITE,{init_per_group,repeat_seq_2,[sequence]},ok}},
       {?eh,test_stats,{6,2,{0,4}}},
       {?eh,tc_done,{repeat_1_SUITE,{end_per_group,repeat_seq_2,
				     [sequence]},ok}}],

      [{?eh,tc_done,{repeat_1_SUITE,
		     {init_per_group,repeat_seq_3,[sequence,{repeat,2}]},
		     ok}},
       {?eh,test_stats,{7,2,{0,4}}},
       [{?eh,tc_done,{repeat_1_SUITE,
		      {init_per_group,gr_fail_init,[]},
		      {failed,{error,fails_on_purpose}}}},
	{?eh,test_stats,{7,2,{0,5}}},
	{?eh,tc_auto_skip,{repeat_1_SUITE,end_per_group,
			   {failed,
			    {repeat_1_SUITE,init_per_group,
			     {'EXIT',fails_on_purpose}}}}}],
       {?eh,tc_auto_skip,{repeat_1_SUITE,tc_ok_2,
			  {group_result,gr_fail_init,failed}}},
       {?eh,test_stats,{7,2,{0,6}}},
       {?eh,tc_done,{repeat_1_SUITE,
		     {end_per_group,repeat_seq_3,[sequence,{repeat,2}]},
		     ok}}],
      [{?eh,tc_done,{repeat_1_SUITE,
		     {init_per_group,repeat_seq_3,[sequence]},ok}},
       {?eh,test_stats,{8,2,{0,8}}},
       {?eh,tc_done,{repeat_1_SUITE,
		     {end_per_group,repeat_seq_3,[sequence]},ok}}],
      [{?eh,tc_done,{repeat_1_SUITE,
		     {init_per_group,repeat_seq_4,[sequence,{repeat,2}]},
		     ok}},
       {?eh,test_stats,{8,3,{0,8}}},
       {?eh,tc_auto_skip,{repeat_1_SUITE,
			  tc_ok_1,{failed,{repeat_1_SUITE,tc_fail_1}}}},
       {?eh,test_stats,{8,3,{0,9}}},
       {?eh,tc_auto_skip,{repeat_1_SUITE,
			  tc_ok_1,{failed,{repeat_1_SUITE,tc_fail_1}}}},
       {?eh,test_stats,{8,3,{0,10}}},
       {?eh,tc_done,{repeat_1_SUITE,
		     {end_per_group,repeat_seq_4,[sequence,{repeat,2}]},
		     ok}}],
      [{?eh,tc_done,{repeat_1_SUITE,{init_per_group,repeat_seq_4,[sequence]},ok}},
       {?eh,test_stats,{8,4,{0,12}}},
       {?eh,tc_done,{repeat_1_SUITE,
		     {end_per_group,repeat_seq_4,[sequence]},ok}}],

      {?eh,tc_done,{repeat_1_SUITE,{end_per_group,repeat_seq,[]},ok}}],
     {?eh,test_done,{'DEF','STOP_TIME'}},
     {?eh,stop_logging,[]}];

test_events(repeat_cs_until_any_ok) ->
    [
     {?eh,start_logging,{'DEF','RUNDIR'}},
     {?eh,test_start,{'DEF',{'START_TIME','LOGDIR'}}},
     {?eh,start_info,{1,1,unknown}},
     [{?eh,tc_done,{repeat_1_SUITE,
		    {init_per_group,repeat_cs_until_any_ok,[]},ok}},
      [{?eh,tc_done,{repeat_1_SUITE,
		     {init_per_group,repeat_cs_until_any_ok_1,
		      [{repeat_until_any_ok,3}]},ok}},
       {?eh,test_stats,{0,2,{0,0}}},
       {?eh,tc_done,{repeat_1_SUITE,tc_fail_then_ok_1,
		     {failed,{error,failing_this_time}}}},
       {?eh,test_stats,{0,3,{0,0}}},
       {?eh,tc_done,{repeat_1_SUITE,
		     {end_per_group,repeat_cs_until_any_ok_1,
		      [{repeat_until_any_ok,3}]},ok}}],
      [{?eh,tc_done,{repeat_1_SUITE,
		     {init_per_group,repeat_cs_until_any_ok_1,
		      [{repeat_until_any_ok,2}]},ok}},
       {?eh,test_stats,{0,5,{0,0}}},
       {?eh,tc_done,{repeat_1_SUITE,tc_fail_then_ok_1,ok}},
       {?eh,test_stats,{1,5,{0,0}}},
       {?eh,tc_done,{repeat_1_SUITE,
		     {end_per_group,repeat_cs_until_any_ok_1,
		      [{repeat_until_any_ok,2}]},ok}}],

      [{?eh,tc_done,{repeat_1_SUITE,
		     {init_per_group,repeat_cs_until_any_ok_2,
		      [{repeat_until_any_ok,3}]},ok}},
       {?eh,tc_done,{repeat_1_SUITE,tc_ok_1,ok}},
       {?eh,test_stats,{2,5,{0,0}}},
       {?eh,test_stats,{2,6,{0,0}}},
       {?eh,tc_done,{repeat_1_SUITE,
		     {end_per_group,repeat_cs_until_any_ok_2,
		      [{repeat_until_any_ok,3}]},ok}}],
      {?eh,tc_done,{repeat_1_SUITE,
		    {end_per_group,repeat_cs_until_any_ok,[]},ok}}],
     {?eh,test_done,{'DEF','STOP_TIME'}},
     {?eh,stop_logging,[]}];

test_events(repeat_gr_until_any_ok) ->
    [{?eh,start_logging,{'DEF','RUNDIR'}},
     {?eh,test_start,{'DEF',{'START_TIME','LOGDIR'}}},
     {?eh,start_info,{1,1,unknown}},
     [{?eh,tc_done,
       {repeat_1_SUITE,{init_per_group,repeat_gr_until_any_ok,[]},ok}},
      [{?eh,tc_done,{repeat_1_SUITE,
		     {init_per_group,repeat_gr_until_any_ok_1,
		      [{repeat_until_any_ok,3}]},ok}},
       [{?eh,tc_done,{repeat_1_SUITE,
		      {init_per_group,gr_fail_result,[]},ok}},
	{?eh,tc_done,{repeat_1_SUITE,
		      {end_per_group,gr_fail_result,[]},
		      {return_group_result,failed}}}],
       {?eh,tc_done,{repeat_1_SUITE,tc_fail_1,
		     {failed,{error,{{badmatch,2},'_'}}}}},
       {?eh,test_stats,{1,1,{0,0}}},
       [{?eh,tc_done,{repeat_1_SUITE,
		      {init_per_group,gr_fail_init,[]},
		      {failed,{error,fails_on_purpose}}}},
	{?eh,test_stats,{1,1,{0,1}}},
	{?eh,tc_auto_skip,{repeat_1_SUITE,end_per_group,
			   {failed,{repeat_1_SUITE,init_per_group,
				    {'EXIT',fails_on_purpose}}}}}],
       {?eh,test_stats,{1,2,{0,1}}},
       [{?eh,tc_done,{repeat_1_SUITE,
		      {init_per_group,gr_fail_result_then_ok,[]},ok}},
	{?eh,tc_done,{repeat_1_SUITE,
		      {end_per_group,gr_fail_result_then_ok,[]},
		      {return_group_result,failed}}}],
       {?eh,tc_done,{repeat_1_SUITE,
		     {end_per_group,repeat_gr_until_any_ok_1,
		      [{repeat_until_any_ok,3}]},ok}}],
      [{?eh,tc_done,{repeat_1_SUITE,
		     {init_per_group,repeat_gr_until_any_ok_1,
		      [{repeat_until_any_ok,2}]},ok}},
       %% ...
       {?eh,test_stats,{3,4,{0,2}}},
       [{?eh,tc_done,{repeat_1_SUITE,
		      {init_per_group,gr_fail_result_then_ok,[]},ok}},
         {?eh,test_stats,{4,4,{0,2}}},
        {?eh,tc_done,{repeat_1_SUITE,
		      {end_per_group,gr_fail_result_then_ok,[]},ok}}],
      {?eh,tc_done,{repeat_1_SUITE,
		    {end_per_group,repeat_gr_until_any_ok_1,
		     [{repeat_until_any_ok,2}]},ok}}],

      [{?eh,tc_done,{repeat_1_SUITE,
		     {init_per_group,repeat_gr_until_any_ok_2,
		      [{repeat_until_any_ok,3}]},ok}},
       [{?eh,tc_done,{repeat_1_SUITE,
		      {end_per_group,gr_fail_result,[]},
		      {return_group_result,failed}}}],
       {?eh,tc_done,{repeat_1_SUITE,tc_fail_1,
		     {failed,{error,{{badmatch,2},'_'}}}}},
       {?eh,test_stats,{5,5,{0,2}}},
       {?eh,tc_done,{repeat_1_SUITE,tc_fail_then_ok_1,
		     {failed,{error,failing_this_time}}}},
       {?eh,test_stats,{5,6,{0,2}}},
       [{?eh,tc_done,{repeat_1_SUITE,
		      {init_per_group,gr_fail_init,[]},
		      {failed,{error,fails_on_purpose}}}},
         {?eh,test_stats,{5,6,{0,3}}},
         {?eh,tc_auto_skip,{repeat_1_SUITE,end_per_group,
			    {failed,{repeat_1_SUITE,init_per_group,
				     {'EXIT',fails_on_purpose}}}}}],
       {?eh,tc_done,{repeat_1_SUITE,
		     {end_per_group,repeat_gr_until_any_ok_2,
		      [{repeat_until_any_ok,3}]},ok}}],
      [{?eh,tc_done,{repeat_1_SUITE,
		     {init_per_group,repeat_gr_until_any_ok_2,
		      [{repeat_until_any_ok,2}]},ok}},
        {?eh,test_stats,{6,7,{0,3}}},
        {?eh,tc_start,{repeat_1_SUITE,tc_fail_then_ok_1}},
        {?eh,tc_done,{repeat_1_SUITE,tc_fail_then_ok_1,ok}},
        {?eh,test_stats,{7,7,{0,3}}},
        [{?eh,tc_done,{repeat_1_SUITE,
		       {init_per_group,gr_fail_init,[]},
		       {failed,{error,fails_on_purpose}}}},
	 {?eh,test_stats,{7,7,{0,4}}},
	 {?eh,tc_auto_skip,{repeat_1_SUITE,end_per_group,
			    {failed,{repeat_1_SUITE,init_per_group,
				     {'EXIT',fails_on_purpose}}}}}],
       {?eh,tc_done,{repeat_1_SUITE,
		     {end_per_group,repeat_gr_until_any_ok_2,
		      [{repeat_until_any_ok,2}]},ok}}],
      {?eh,tc_done,{repeat_1_SUITE,
		    {end_per_group,repeat_gr_until_any_ok,[]},ok}}],
     {?eh,test_done,{'DEF','STOP_TIME'}},
     {?eh,stop_logging,[]}];

test_events(repeat_cs_until_any_fail) ->
    [{?eh,start_logging,{'DEF','RUNDIR'}},
     {?eh,test_start,{'DEF',{'START_TIME','LOGDIR'}}},
     {?eh,start_info,{1,1,unknown}},
     {?eh,tc_start,{repeat_1_SUITE,init_per_suite}},
     {?eh,tc_done,{repeat_1_SUITE,init_per_suite,ok}},
     [{?eh,tc_start,
       {repeat_1_SUITE,{init_per_group,repeat_cs_until_any_fail,[]}}},
      {?eh,tc_done,
       {repeat_1_SUITE,{init_per_group,repeat_cs_until_any_fail,[]},ok}},
      [{?eh,tc_start,
        {repeat_1_SUITE,
	 {init_per_group,repeat_cs_until_any_fail_1,
	  [{repeat_until_any_fail,3}]}}},
       {?eh,tc_done,
        {repeat_1_SUITE,
	 {init_per_group,repeat_cs_until_any_fail_1,
	  [{repeat_until_any_fail,3}]},
	 ok}},
       {?eh,tc_start,{repeat_1_SUITE,tc_ok_1}},
       {?eh,tc_done,{repeat_1_SUITE,tc_ok_1,ok}},
       {?eh,test_stats,{1,0,{0,0}}},
       {?eh,tc_start,{repeat_1_SUITE,tc_ok_2}},
       {?eh,tc_done,{repeat_1_SUITE,tc_ok_2,ok}},
       {?eh,test_stats,{2,0,{0,0}}},
       {?eh,tc_start,{repeat_1_SUITE,tc_ok_then_fail_1}},
       {?eh,tc_done,{repeat_1_SUITE,tc_ok_then_fail_1,ok}},
       {?eh,test_stats,{3,0,{0,0}}},
       {?eh,tc_start,
        {repeat_1_SUITE,
	 {end_per_group,repeat_cs_until_any_fail_1,
	  [{repeat_until_any_fail,3}]}}},
       {?eh,tc_done,
        {repeat_1_SUITE,
	 {end_per_group,repeat_cs_until_any_fail_1,
	  [{repeat_until_any_fail,3}]},
	 ok}}],
      [{?eh,tc_start,
        {repeat_1_SUITE,
	 {init_per_group,repeat_cs_until_any_fail_1,
	  [{repeat_until_any_fail,2}]}}},
       {?eh,tc_done,
        {repeat_1_SUITE,
	 {init_per_group,repeat_cs_until_any_fail_1,
	  [{repeat_until_any_fail,2}]},
	 ok}},
       {?eh,tc_start,{repeat_1_SUITE,tc_ok_1}},
       {?eh,tc_done,{repeat_1_SUITE,tc_ok_1,ok}},
       {?eh,test_stats,{4,0,{0,0}}},
       {?eh,tc_start,{repeat_1_SUITE,tc_ok_2}},
       {?eh,tc_done,{repeat_1_SUITE,tc_ok_2,ok}},
       {?eh,test_stats,{5,0,{0,0}}},
       {?eh,tc_start,{repeat_1_SUITE,tc_ok_then_fail_1}},
       {?eh,tc_done,
	{repeat_1_SUITE,tc_ok_then_fail_1,
	 {failed,{error,failing_this_time}}}},
       {?eh,test_stats,{5,1,{0,0}}},
       {?eh,tc_start,
        {repeat_1_SUITE,
	 {end_per_group,repeat_cs_until_any_fail_1,
	  [{repeat_until_any_fail,2}]}}},
       {?eh,tc_done,
        {repeat_1_SUITE,
	 {end_per_group,repeat_cs_until_any_fail_1,
	  [{repeat_until_any_fail,2}]},
	 ok}}],
      [{?eh,tc_start,
        {repeat_1_SUITE,
	 {init_per_group,repeat_cs_until_any_fail_2,
	  [{repeat_until_any_fail,3}]}}},
       {?eh,tc_done,
        {repeat_1_SUITE,
	 {init_per_group,repeat_cs_until_any_fail_2,
	  [{repeat_until_any_fail,3}]},
	 ok}},
       {?eh,tc_start,{repeat_1_SUITE,tc_fail_1}},
       {?eh,tc_done,
	{repeat_1_SUITE,tc_fail_1,
	 {failed,
	  {error,
	   {{badmatch,2},
	    [{repeat_1_SUITE,tc_fail_1,1},
	     {repeat_1_SUITE,tc_fail_1,1},
	     {test_server,my_apply,3},
	     {test_server,ts_tc,3},
	     {test_server,run_test_case_eval1,6},
	     {test_server,run_test_case_eval,8}]}}}}},
       {?eh,test_stats,{5,2,{0,0}}},
       {?eh,tc_start,{repeat_1_SUITE,tc_fail_2}},
       {?eh,tc_done,
	{repeat_1_SUITE,tc_fail_2,{failed,{error,exit_on_purpose}}}},
       {?eh,test_stats,{5,3,{0,0}}},
       {?eh,tc_start,
        {repeat_1_SUITE,
	 {end_per_group,repeat_cs_until_any_fail_2,
	  [{repeat_until_any_fail,3}]}}},
       {?eh,tc_done,
        {repeat_1_SUITE,
	 {end_per_group,repeat_cs_until_any_fail_2,
	  [{repeat_until_any_fail,3}]},
	 ok}}],
      {?eh,tc_start,
       {repeat_1_SUITE,{end_per_group,repeat_cs_until_any_fail,[]}}},
      {?eh,tc_done,
       {repeat_1_SUITE,{end_per_group,repeat_cs_until_any_fail,[]},ok}}],
     {?eh,tc_start,{repeat_1_SUITE,end_per_suite}},
     {?eh,tc_done,{repeat_1_SUITE,end_per_suite,ok}},
     {?eh,test_done,{'DEF','STOP_TIME'}},
     {?eh,stop_logging,[]}];

test_events(repeat_gr_until_any_fail) ->
    [{?eh,start_logging,{'DEF','RUNDIR'}},
 {?eh,test_start,{'DEF',{'START_TIME','LOGDIR'}}},
 {?eh,start_info,{1,1,unknown}},
 {?eh,tc_start,{repeat_1_SUITE,init_per_suite}},
 {?eh,tc_done,{repeat_1_SUITE,init_per_suite,ok}},
 [{?eh,tc_start,
      {repeat_1_SUITE,{init_per_group,repeat_gr_until_any_fail,[]}}},
  {?eh,tc_done,
      {repeat_1_SUITE,{init_per_group,repeat_gr_until_any_fail,[]},ok}},
   [{?eh,tc_start,
        {repeat_1_SUITE,
            {init_per_group,repeat_gr_until_any_fail_1,
                [{repeat_until_any_fail,3}]}}},
    {?eh,tc_done,
        {repeat_1_SUITE,
            {init_per_group,repeat_gr_until_any_fail_1,
                [{repeat_until_any_fail,3}]},
            ok}},
     [{?eh,tc_start,
                          {repeat_1_SUITE,{init_per_group,gr_ok_1,[]}}},
      {?eh,tc_done,
                          {repeat_1_SUITE,{init_per_group,gr_ok_1,[]},ok}},
       {?eh,tc_start,{repeat_1_SUITE,tc_ok_1}},
       {?eh,tc_done,{repeat_1_SUITE,tc_ok_1,ok}},
       {?eh,test_stats,{1,0,{0,0}}},
      {?eh,tc_start,
                          {repeat_1_SUITE,{end_per_group,gr_ok_1,[]}}},
      {?eh,tc_done,
                          {repeat_1_SUITE,{end_per_group,gr_ok_1,[]},ok}}],
     {?eh,tc_start,{repeat_1_SUITE,tc_ok_1}},
     {?eh,tc_done,{repeat_1_SUITE,tc_ok_1,ok}},
     {?eh,test_stats,{2,0,{0,0}}},
     [{?eh,tc_start,
          {repeat_1_SUITE,{init_per_group,gr_ok_then_fail_result,[]}}},
      {?eh,tc_done,
          {repeat_1_SUITE,{init_per_group,gr_ok_then_fail_result,[]},ok}},
       {?eh,tc_start,{repeat_1_SUITE,tc_ok_1}},
       {?eh,tc_done,{repeat_1_SUITE,tc_ok_1,ok}},
       {?eh,test_stats,{3,0,{0,0}}},
      {?eh,tc_start,
          {repeat_1_SUITE,{end_per_group,gr_ok_then_fail_result,[]}}},
      {?eh,tc_done,
          {repeat_1_SUITE,{end_per_group,gr_ok_then_fail_result,[]},ok}}],
     {?eh,tc_start,{repeat_1_SUITE,tc_ok_2}},
     {?eh,tc_done,{repeat_1_SUITE,tc_ok_2,ok}},
     {?eh,test_stats,{4,0,{0,0}}},
    {?eh,tc_start,
        {repeat_1_SUITE,
            {end_per_group,repeat_gr_until_any_fail_1,
                [{repeat_until_any_fail,3}]}}},
    {?eh,tc_done,
        {repeat_1_SUITE,
            {end_per_group,repeat_gr_until_any_fail_1,
                [{repeat_until_any_fail,3}]},
            ok}}],
   [{?eh,tc_start,
        {repeat_1_SUITE,
            {init_per_group,repeat_gr_until_any_fail_1,
                [{repeat_until_any_fail,2}]}}},
    {?eh,tc_done,
        {repeat_1_SUITE,
            {init_per_group,repeat_gr_until_any_fail_1,
                [{repeat_until_any_fail,2}]},
            ok}},
     [{?eh,tc_start,
                          {repeat_1_SUITE,{init_per_group,gr_ok_1,[]}}},
      {?eh,tc_done,
                          {repeat_1_SUITE,{init_per_group,gr_ok_1,[]},ok}},
       {?eh,tc_start,{repeat_1_SUITE,tc_ok_1}},
       {?eh,tc_done,{repeat_1_SUITE,tc_ok_1,ok}},
       {?eh,test_stats,{5,0,{0,0}}},
      {?eh,tc_start,
                          {repeat_1_SUITE,{end_per_group,gr_ok_1,[]}}},
      {?eh,tc_done,
                          {repeat_1_SUITE,{end_per_group,gr_ok_1,[]},ok}}],
     {?eh,tc_start,{repeat_1_SUITE,tc_ok_1}},
     {?eh,tc_done,{repeat_1_SUITE,tc_ok_1,ok}},
     {?eh,test_stats,{6,0,{0,0}}},
     [{?eh,tc_start,
          {repeat_1_SUITE,{init_per_group,gr_ok_then_fail_result,[]}}},
      {?eh,tc_done,
          {repeat_1_SUITE,{init_per_group,gr_ok_then_fail_result,[]},ok}},
       {?eh,tc_start,{repeat_1_SUITE,tc_ok_1}},
       {?eh,tc_done,{repeat_1_SUITE,tc_ok_1,ok}},
       {?eh,test_stats,{7,0,{0,0}}},
      {?eh,tc_start,
          {repeat_1_SUITE,{end_per_group,gr_ok_then_fail_result,[]}}},
      {?eh,tc_done,
          {repeat_1_SUITE,
              {end_per_group,gr_ok_then_fail_result,[]},
              {return_group_result,failed}}}],
     {?eh,tc_start,{repeat_1_SUITE,tc_ok_2}},
     {?eh,tc_done,{repeat_1_SUITE,tc_ok_2,ok}},
     {?eh,test_stats,{8,0,{0,0}}},
    {?eh,tc_start,
        {repeat_1_SUITE,
            {end_per_group,repeat_gr_until_any_fail_1,
                [{repeat_until_any_fail,2}]}}},
    {?eh,tc_done,
        {repeat_1_SUITE,
            {end_per_group,repeat_gr_until_any_fail_1,
                [{repeat_until_any_fail,2}]},
            ok}}],
   [{?eh,tc_start,
        {repeat_1_SUITE,
            {init_per_group,repeat_gr_until_any_fail_2,
                [{repeat_until_any_fail,3}]}}},
    {?eh,tc_done,
        {repeat_1_SUITE,
            {init_per_group,repeat_gr_until_any_fail_2,
                [{repeat_until_any_fail,3}]},
            ok}},
     [{?eh,tc_start,
                          {repeat_1_SUITE,{init_per_group,gr_ok_1,[]}}},
      {?eh,tc_done,
                          {repeat_1_SUITE,{init_per_group,gr_ok_1,[]},ok}},
       {?eh,tc_start,{repeat_1_SUITE,tc_ok_1}},
       {?eh,tc_done,{repeat_1_SUITE,tc_ok_1,ok}},
       {?eh,test_stats,{9,0,{0,0}}},
      {?eh,tc_start,
                          {repeat_1_SUITE,{end_per_group,gr_ok_1,[]}}},
      {?eh,tc_done,
                          {repeat_1_SUITE,{end_per_group,gr_ok_1,[]},ok}}],
     {?eh,tc_start,{repeat_1_SUITE,tc_ok_1}},
     {?eh,tc_done,{repeat_1_SUITE,tc_ok_1,ok}},
     {?eh,test_stats,{10,0,{0,0}}},
     [{?eh,tc_start,
          {repeat_1_SUITE,{init_per_group,gr_ok_then_fail_init,[]}}},
      {?eh,tc_done,
          {repeat_1_SUITE,{init_per_group,gr_ok_then_fail_init,[]},ok}},
       {?eh,tc_start,{repeat_1_SUITE,tc_ok_1}},
       {?eh,tc_done,{repeat_1_SUITE,tc_ok_1,ok}},
       {?eh,test_stats,{11,0,{0,0}}},
      {?eh,tc_start,
          {repeat_1_SUITE,{end_per_group,gr_ok_then_fail_init,[]}}},
      {?eh,tc_done,
          {repeat_1_SUITE,{end_per_group,gr_ok_then_fail_init,[]},ok}}],
     {?eh,tc_start,{repeat_1_SUITE,tc_ok_2}},
     {?eh,tc_done,{repeat_1_SUITE,tc_ok_2,ok}},
     {?eh,test_stats,{12,0,{0,0}}},
    {?eh,tc_start,
        {repeat_1_SUITE,
            {end_per_group,repeat_gr_until_any_fail_2,
                [{repeat_until_any_fail,3}]}}},
    {?eh,tc_done,
        {repeat_1_SUITE,
            {end_per_group,repeat_gr_until_any_fail_2,
                [{repeat_until_any_fail,3}]},
            ok}}],
   [{?eh,tc_start,
        {repeat_1_SUITE,
            {init_per_group,repeat_gr_until_any_fail_2,
                [{repeat_until_any_fail,2}]}}},
    {?eh,tc_done,
        {repeat_1_SUITE,
            {init_per_group,repeat_gr_until_any_fail_2,
                [{repeat_until_any_fail,2}]},
            ok}},
     [{?eh,tc_start,
                          {repeat_1_SUITE,{init_per_group,gr_ok_1,[]}}},
      {?eh,tc_done,
                          {repeat_1_SUITE,{init_per_group,gr_ok_1,[]},ok}},
       {?eh,tc_start,{repeat_1_SUITE,tc_ok_1}},
       {?eh,tc_done,{repeat_1_SUITE,tc_ok_1,ok}},
       {?eh,test_stats,{13,0,{0,0}}},
      {?eh,tc_start,
                          {repeat_1_SUITE,{end_per_group,gr_ok_1,[]}}},
      {?eh,tc_done,
                          {repeat_1_SUITE,{end_per_group,gr_ok_1,[]},ok}}],
     {?eh,tc_start,{repeat_1_SUITE,tc_ok_1}},
     {?eh,tc_done,{repeat_1_SUITE,tc_ok_1,ok}},
     {?eh,test_stats,{14,0,{0,0}}},
     [{?eh,tc_start,
          {repeat_1_SUITE,{init_per_group,gr_ok_then_fail_init,[]}}},
      {?eh,tc_done,
          {repeat_1_SUITE,
              {init_per_group,gr_ok_then_fail_init,[]},
              {failed,{error,failing_this_time}}}},
       {?eh,tc_auto_skip,
           {repeat_1_SUITE,tc_ok_1,
               {failed,
                   {repeat_1_SUITE,init_per_group,
                       {'EXIT',failing_this_time}}}}},
       {?eh,test_stats,{14,0,{0,1}}},
       {?eh,tc_auto_skip,
           {repeat_1_SUITE,end_per_group,
               {failed,
                   {repeat_1_SUITE,init_per_group,
                       {'EXIT',failing_this_time}}}}}],
      {?eh,tc_start,{repeat_1_SUITE,tc_ok_2}},
      {?eh,tc_done,{repeat_1_SUITE,tc_ok_2,ok}},
      {?eh,test_stats,{15,0,{0,1}}},
     {?eh,tc_start,
         {repeat_1_SUITE,
             {end_per_group,repeat_gr_until_any_fail_2,
                 [{repeat_until_any_fail,2}]}}},
     {?eh,tc_done,
         {repeat_1_SUITE,
             {end_per_group,repeat_gr_until_any_fail_2,
                 [{repeat_until_any_fail,2}]},
             ok}}],
    [{?eh,tc_start,
         {repeat_1_SUITE,
             {init_per_group,repeat_gr_until_any_fail_3,
                 [{repeat_until_any_fail,3}]}}},
     {?eh,tc_done,
         {repeat_1_SUITE,
             {init_per_group,repeat_gr_until_any_fail_3,
                 [{repeat_until_any_fail,3}]},
             ok}},
      {?eh,tc_start,{repeat_1_SUITE,tc_ok_then_fail_1}},
      {?eh,tc_done,{repeat_1_SUITE,tc_ok_then_fail_1,ok}},
      {?eh,test_stats,{16,0,{0,1}}},
      [{?eh,tc_start,
                           {repeat_1_SUITE,{init_per_group,gr_ok_1,[]}}},
       {?eh,tc_done,
                           {repeat_1_SUITE,{init_per_group,gr_ok_1,[]},ok}},
        {?eh,tc_start,{repeat_1_SUITE,tc_ok_1}},
        {?eh,tc_done,{repeat_1_SUITE,tc_ok_1,ok}},
        {?eh,test_stats,{17,0,{0,1}}},
       {?eh,tc_start,
                           {repeat_1_SUITE,{end_per_group,gr_ok_1,[]}}},
       {?eh,tc_done,
                           {repeat_1_SUITE,{end_per_group,gr_ok_1,[]},ok}}],
      {?eh,tc_start,{repeat_1_SUITE,tc_ok_1}},
      {?eh,tc_done,{repeat_1_SUITE,tc_ok_1,ok}},
      {?eh,test_stats,{18,0,{0,1}}},
     {?eh,tc_start,
         {repeat_1_SUITE,
             {end_per_group,repeat_gr_until_any_fail_3,
                 [{repeat_until_any_fail,3}]}}},
     {?eh,tc_done,
         {repeat_1_SUITE,
             {end_per_group,repeat_gr_until_any_fail_3,
                 [{repeat_until_any_fail,3}]},
             ok}}],
    [{?eh,tc_start,
         {repeat_1_SUITE,
             {init_per_group,repeat_gr_until_any_fail_3,
                 [{repeat_until_any_fail,2}]}}},
     {?eh,tc_done,
         {repeat_1_SUITE,
             {init_per_group,repeat_gr_until_any_fail_3,
                 [{repeat_until_any_fail,2}]},
             ok}},
      {?eh,tc_start,{repeat_1_SUITE,tc_ok_then_fail_1}},
      {?eh,tc_done,
          {repeat_1_SUITE,tc_ok_then_fail_1,
              {failed,{error,failing_this_time}}}},
      {?eh,test_stats,{18,1,{0,1}}},
      [{?eh,tc_start,
                           {repeat_1_SUITE,{init_per_group,gr_ok_1,[]}}},
       {?eh,tc_done,
                           {repeat_1_SUITE,{init_per_group,gr_ok_1,[]},ok}},
        {?eh,tc_start,{repeat_1_SUITE,tc_ok_1}},
        {?eh,tc_done,{repeat_1_SUITE,tc_ok_1,ok}},
        {?eh,test_stats,{19,1,{0,1}}},
       {?eh,tc_start,
                           {repeat_1_SUITE,{end_per_group,gr_ok_1,[]}}},
       {?eh,tc_done,
                           {repeat_1_SUITE,{end_per_group,gr_ok_1,[]},ok}}],
      {?eh,tc_start,{repeat_1_SUITE,tc_ok_1}},
      {?eh,tc_done,{repeat_1_SUITE,tc_ok_1,ok}},
      {?eh,test_stats,{20,1,{0,1}}},
     {?eh,tc_start,
         {repeat_1_SUITE,
             {end_per_group,repeat_gr_until_any_fail_3,
                 [{repeat_until_any_fail,2}]}}},
     {?eh,tc_done,
         {repeat_1_SUITE,
             {end_per_group,repeat_gr_until_any_fail_3,
                 [{repeat_until_any_fail,2}]},
             ok}}],
   {?eh,tc_start,
       {repeat_1_SUITE,{end_per_group,repeat_gr_until_any_fail,[]}}},
   {?eh,tc_done,
       {repeat_1_SUITE,{end_per_group,repeat_gr_until_any_fail,[]},ok}}],
  {?eh,tc_start,{repeat_1_SUITE,end_per_suite}},
  {?eh,tc_done,{repeat_1_SUITE,end_per_suite,ok}},
  {?eh,test_done,{'DEF','STOP_TIME'}},
     {?eh,stop_logging,[]}];

test_events(repeat_cs_until_all_ok) ->
    [{?eh,start_logging,{'DEF','RUNDIR'}},
     {?eh,test_start,{'DEF',{'START_TIME','LOGDIR'}}},
     {?eh,start_info,{1,1,unknown}},
     [{?eh,tc_done,{repeat_1_SUITE,{init_per_group,repeat_cs_until_all_ok,[]},ok}},
      [{?eh,tc_done,{repeat_1_SUITE,
		     {init_per_group,repeat_cs_until_all_ok_1,
		      [{repeat_until_all_ok,3}]},ok}},
       {?eh,tc_done,{repeat_1_SUITE,tc_fail_then_ok_1,
		     {failed,{error,failing_this_time}}}},
       {?eh,test_stats,{0,1,{0,0}}},
       {?eh,tc_done,{repeat_1_SUITE,tc_ok_1,ok}},
       {?eh,test_stats,{1,1,{0,0}}},
       {?eh,tc_done,{repeat_1_SUITE,tc_fail_then_ok_2,
		     {failed,{error,failing_this_time}}}},
       {?eh,test_stats,{1,2,{0,0}}},
       {?eh,tc_done,{repeat_1_SUITE,
		     {end_per_group,repeat_cs_until_all_ok_1,
		      [{repeat_until_all_ok,3}]},ok}}],
      [{?eh,tc_done,{repeat_1_SUITE,
		     {init_per_group,repeat_cs_until_all_ok_1,
		      [{repeat_until_all_ok,2}]},ok}},
       {?eh,tc_done,{repeat_1_SUITE,tc_fail_then_ok_1,ok}},
       {?eh,test_stats,{2,2,{0,0}}},
       {?eh,tc_done,{repeat_1_SUITE,tc_ok_1,ok}},
       {?eh,test_stats,{3,2,{0,0}}},
       {?eh,tc_done,{repeat_1_SUITE,tc_fail_then_ok_2,ok}},
       {?eh,test_stats,{4,2,{0,0}}},
       {?eh,tc_done,{repeat_1_SUITE,
		     {end_per_group,repeat_cs_until_all_ok_1,
		      [{repeat_until_all_ok,2}]},ok}}],

      [{?eh,tc_done,{repeat_1_SUITE,
		     {init_per_group,repeat_cs_until_all_ok_2,
		      [{repeat_until_all_ok,3}]},ok}},
       {?eh,tc_done,{repeat_1_SUITE,tc_ok_1,ok}},
       {?eh,tc_done,{repeat_1_SUITE,tc_ok_2,ok}},
       {?eh,test_stats,{6,2,{0,0}}},
       {?eh,tc_done,{repeat_1_SUITE,
		     {end_per_group,repeat_cs_until_all_ok_2,
		      [{repeat_until_all_ok,3}]},ok}}],

      {?eh,tc_done,{repeat_1_SUITE,
		    {end_per_group,repeat_cs_until_all_ok,[]},ok}}],
     {?eh,test_done,{'DEF','STOP_TIME'}},
     {?eh,stop_logging,[]}];

test_events(repeat_gr_until_all_ok) ->
    [{?eh,start_logging,{'DEF','RUNDIR'}},
     {?eh,test_start,{'DEF',{'START_TIME','LOGDIR'}}},
     {?eh,start_info,{1,1,unknown}},
     [{?eh,tc_done,{repeat_1_SUITE,
		    {init_per_group,repeat_gr_until_all_ok,[]},ok}},
      [{?eh,tc_done,{repeat_1_SUITE,
		     {init_per_group,repeat_gr_until_all_ok_1,
		      [{repeat_until_all_ok,3}]},ok}},
       {?eh,tc_done,{repeat_1_SUITE,tc_ok_1,ok}},
       {?eh,test_stats,{1,0,{0,0}}},
       [{?eh,tc_done,{repeat_1_SUITE,{init_per_group,gr_ok_1,[]},ok}},
	{?eh,tc_done,{repeat_1_SUITE,tc_ok_1,ok}},
	{?eh,test_stats,{2,0,{0,0}}},
	{?eh,tc_done,{repeat_1_SUITE,{end_per_group,gr_ok_1,[]},ok}}],
       {?eh,tc_done,{repeat_1_SUITE,tc_fail_then_ok_1,
		     {failed,{error,failing_this_time}}}},
       {?eh,test_stats,{2,1,{0,0}}},
       [{?eh,tc_done,{repeat_1_SUITE,
		      {init_per_group,gr_fail_result_then_ok,[]},ok}},
	{?eh,tc_done,{repeat_1_SUITE,tc_ok_1,ok}},
	{?eh,test_stats,{3,1,{0,0}}},
	{?eh,tc_done,{repeat_1_SUITE,
		      {end_per_group,gr_fail_result_then_ok,[]},
		      {return_group_result,failed}}}],
       {?eh,tc_done,{repeat_1_SUITE,
		     {end_per_group,repeat_gr_until_all_ok_1,
		      [{repeat_until_all_ok,3}]},ok}}],
      [{?eh,tc_done,{repeat_1_SUITE,
		     {init_per_group,repeat_gr_until_all_ok_1,
		      [{repeat_until_all_ok,2}]},ok}},
       {?eh,test_stats,{5,1,{0,0}}},
       {?eh,tc_done,{repeat_1_SUITE,tc_fail_then_ok_1,ok}},
       {?eh,test_stats,{6,1,{0,0}}},
       [{?eh,tc_done,{repeat_1_SUITE,
		      {init_per_group,gr_fail_result_then_ok,[]},ok}},
	{?eh,test_stats,{7,1,{0,0}}},
	{?eh,tc_done,{repeat_1_SUITE,
		      {end_per_group,gr_fail_result_then_ok,[]},ok}}],
       {?eh,tc_done,{repeat_1_SUITE,
		     {end_per_group,repeat_gr_until_all_ok_1,
		      [{repeat_until_all_ok,2}]},ok}}],

      [{?eh,tc_done,{repeat_1_SUITE,
		     {init_per_group,repeat_gr_until_all_ok_2,
		      [{repeat_until_all_ok,3}]},ok}},
       [{?eh,tc_done,{repeat_1_SUITE,
		      {init_per_group,gr_fail_init_then_ok,[]},
		      {failed,{error,failing_this_time}}}},
	{?eh,tc_auto_skip,{repeat_1_SUITE,tc_ok_1,
			   {failed,{repeat_1_SUITE,init_per_group,
				    {'EXIT',failing_this_time}}}}},
	{?eh,test_stats,{7,1,{0,1}}},
	{?eh,tc_auto_skip,{repeat_1_SUITE,end_per_group,
			   {failed,{repeat_1_SUITE,init_per_group,
				    {'EXIT',failing_this_time}}}}}],
       {?eh,tc_done,{repeat_1_SUITE,tc_ok_1,ok}},
       {?eh,test_stats,{8,1,{0,1}}},
       {?eh,tc_done,{repeat_1_SUITE,
		     {end_per_group,repeat_gr_until_all_ok_2,
		      [{repeat_until_all_ok,3}]},ok}}],
      [{?eh,tc_done,{repeat_1_SUITE,
		     {init_per_group,repeat_gr_until_all_ok_2,
		      [{repeat_until_all_ok,2}]},ok}},
       [{?eh,tc_done,{repeat_1_SUITE,
		      {init_per_group,gr_fail_init_then_ok,[]},ok}},
        {?eh,tc_done,{repeat_1_SUITE,tc_ok_1,ok}},
        {?eh,test_stats,{9,1,{0,1}}},
	{?eh,tc_done,{repeat_1_SUITE,
		      {end_per_group,gr_fail_init_then_ok,[]},ok}}],
       {?eh,tc_done,{repeat_1_SUITE,tc_ok_1,ok}},
       {?eh,test_stats,{10,1,{0,1}}},
       {?eh,tc_done,{repeat_1_SUITE,
		     {end_per_group,repeat_gr_until_all_ok_2,
		      [{repeat_until_all_ok,2}]},ok}}],

      [{?eh,tc_done,{repeat_1_SUITE,
		     {init_per_group,repeat_gr_until_all_ok_3,
		      [{repeat_until_all_ok,3}]},ok}},
       [{?eh,tc_done,{repeat_1_SUITE,{init_per_group,gr_ok_1,[]},ok}},
        {?eh,tc_done,{repeat_1_SUITE,tc_ok_1,ok}},
        {?eh,test_stats,{11,1,{0,1}}},
	{?eh,tc_done,{repeat_1_SUITE,{end_per_group,gr_ok_1,[]},ok}}],
       {?eh,tc_done,{repeat_1_SUITE,tc_fail_then_ok_1,
		     {failed,{error,failing_this_time}}}},
       {?eh,test_stats,{11,2,{0,1}}},
       {?eh,tc_done,{repeat_1_SUITE,
		     {end_per_group,repeat_gr_until_all_ok_3,
		      [{repeat_until_all_ok,3}]},ok}}],
      [{?eh,tc_done,{repeat_1_SUITE,
		     {init_per_group,repeat_gr_until_all_ok_3,
		      [{repeat_until_all_ok,2}]},ok}},
       [{?eh,tc_done,{repeat_1_SUITE,{init_per_group,gr_ok_1,[]},ok}},
        {?eh,tc_done,{repeat_1_SUITE,tc_ok_1,ok}},
        {?eh,test_stats,{12,2,{0,1}}},
	{?eh,tc_done,{repeat_1_SUITE,{end_per_group,gr_ok_1,[]},ok}}],
       {?eh,tc_done,{repeat_1_SUITE,tc_fail_then_ok_1,ok}},
       {?eh,test_stats,{13,2,{0,1}}},
       {?eh,tc_done,{repeat_1_SUITE,
		     {end_per_group,repeat_gr_until_all_ok_3,
		      [{repeat_until_all_ok,2}]},ok}}],

      {?eh,tc_done,{repeat_1_SUITE,
		    {end_per_group,repeat_gr_until_all_ok,[]},ok}}],
     {?eh,test_done,{'DEF','STOP_TIME'}},
     {?eh,stop_logging,[]}];

test_events(repeat_cs_until_all_fail) ->
    [{?eh,start_logging,{'DEF','RUNDIR'}},
     {?eh,test_start,{'DEF',{'START_TIME','LOGDIR'}}},
     {?eh,start_info,{1,1,unknown}},
     [{?eh,tc_done,{repeat_1_SUITE,
		    {init_per_group,repeat_cs_until_all_fail,[]},ok}},
      [{?eh,tc_done,{repeat_1_SUITE,
		     {init_per_group,repeat_cs_until_all_fail_1,
		      [{repeat_until_all_fail,3}]},ok}},
       {?eh,tc_done,{repeat_1_SUITE,tc_ok_then_fail_1,ok}},
       {?eh,test_stats,{1,0,{0,0}}},
       {?eh,tc_start,{repeat_1_SUITE,tc_fail_1}},
       {?eh,test_stats,{1,1,{0,0}}},
       {?eh,tc_done,{repeat_1_SUITE,tc_ok_then_fail_2,ok}},
       {?eh,test_stats,{2,1,{0,0}}},
       {?eh,tc_done,{repeat_1_SUITE,
		     {end_per_group,repeat_cs_until_all_fail_1,
		      [{repeat_until_all_fail,3}]},ok}}],
      [{?eh,tc_done,{repeat_1_SUITE,
		     {init_per_group,repeat_cs_until_all_fail_1,
		      [{repeat_until_all_fail,2}]},ok}},
       {?eh,tc_done,{repeat_1_SUITE,tc_ok_then_fail_1,
		     {failed,{error,failing_this_time}}}},
       {?eh,test_stats,{2,2,{0,0}}},
       {?eh,tc_start,{repeat_1_SUITE,tc_fail_1}},
       {?eh,test_stats,{2,3,{0,0}}},
       {?eh,tc_done,{repeat_1_SUITE,tc_ok_then_fail_2,
		     {failed,{error,failing_this_time}}}},
       {?eh,test_stats,{2,4,{0,0}}},
       {?eh,tc_done,{repeat_1_SUITE,
		     {end_per_group,repeat_cs_until_all_fail_1,
		      [{repeat_until_all_fail,2}]},ok}}],

      [{?eh,tc_done,{repeat_1_SUITE,
		     {init_per_group,repeat_cs_until_all_fail_2,
		      [{repeat_until_all_fail,3}]},ok}},
       {?eh,tc_start,{repeat_1_SUITE,tc_fail_1}},
       {?eh,test_stats,{2,5,{0,0}}},
       {?eh,tc_done,{repeat_1_SUITE,
		     {end_per_group,repeat_cs_until_all_fail_2,
		      [{repeat_until_all_fail,3}]},ok}}],
      {?eh,tc_done,{repeat_1_SUITE,
		    {end_per_group,repeat_cs_until_all_fail,[]},ok}}],

     {?eh,test_done,{'DEF','STOP_TIME'}},
     {?eh,stop_logging,[]}];

test_events(repeat_gr_until_all_fail) ->
    [{?eh,start_logging,{'DEF','RUNDIR'}},
     {?eh,test_start,{'DEF',{'START_TIME','LOGDIR'}}},
     {?eh,start_info,{1,1,unknown}},
     [{?eh,tc_done,{repeat_1_SUITE,
		    {init_per_group,repeat_gr_until_all_fail,[]},ok}},
      [{?eh,tc_done,{repeat_1_SUITE,
		     {init_per_group,repeat_gr_until_all_fail_1,
		      [{repeat_until_all_fail,3}]},ok}},
       {?eh,tc_start,{repeat_1_SUITE,tc_fail_1}},
       {?eh,test_stats,{0,1,{0,0}}},
       [{?eh,tc_done,{repeat_1_SUITE,
		      {init_per_group,gr_fail_init,[]},
		      {failed,{error,fails_on_purpose}}}},
	{?eh,test_stats,{0,1,{0,1}}},
	{?eh,tc_auto_skip,{repeat_1_SUITE,end_per_group,
			   {failed,{repeat_1_SUITE,init_per_group,
				    {'EXIT',fails_on_purpose}}}}}],
       {?eh,tc_done,{repeat_1_SUITE,tc_ok_then_fail_1,ok}},
       {?eh,test_stats,{1,1,{0,1}}},
       [{?eh,tc_done,{repeat_1_SUITE,{end_per_group,
				      gr_ok_then_fail_result,[]},ok}}],
       {?eh,tc_done,{repeat_1_SUITE,
		     {end_per_group,repeat_gr_until_all_fail_1,
		      [{repeat_until_all_fail,3}]},ok}}],
      [{?eh,tc_done,{repeat_1_SUITE,
		     {init_per_group,repeat_gr_until_all_fail_1,
		      [{repeat_until_all_fail,2}]},ok}},
       {?eh,tc_start,{repeat_1_SUITE,tc_fail_1}},
       {?eh,test_stats,{2,2,{0,1}}},
       [{?eh,tc_done,{repeat_1_SUITE,
		      {init_per_group,gr_fail_init,[]},
		      {failed,{error,fails_on_purpose}}}},
        {?eh,test_stats,{2,2,{0,2}}},
        {?eh,tc_auto_skip,{repeat_1_SUITE,end_per_group,
			   {failed,{repeat_1_SUITE,init_per_group,
				    {'EXIT',fails_on_purpose}}}}}],
       {?eh,tc_done,{repeat_1_SUITE,tc_ok_then_fail_1,
		     {failed,{error,failing_this_time}}}},
       {?eh,test_stats,{2,3,{0,2}}},
       [{?eh,tc_done,{repeat_1_SUITE,{init_per_group,
				      gr_ok_then_fail_result,[]},ok}},
	{?eh,test_stats,{3,3,{0,2}}},
	{?eh,tc_done,{repeat_1_SUITE,
		      {end_per_group,gr_ok_then_fail_result,[]},
		      {return_group_result,failed}}}],
       {?eh,tc_done,{repeat_1_SUITE,
		     {end_per_group,repeat_gr_until_all_fail_1,
		      [{repeat_until_all_fail,2}]},ok}}],

      [{?eh,tc_done,{repeat_1_SUITE,
		     {init_per_group,repeat_gr_until_all_fail_2,
		      [{repeat_until_all_fail,3}]},ok}},
       [{?eh,tc_done,{repeat_1_SUITE,{end_per_group,gr_ok_then_fail_init,[]},ok}}],
       {?eh,tc_start,{repeat_1_SUITE,tc_fail_1}},
       {?eh,test_stats,{4,4,{0,2}}},
       {?eh,tc_done,{repeat_1_SUITE,
		     {end_per_group,repeat_gr_until_all_fail_2,
		      [{repeat_until_all_fail,3}]},ok}}],
      [{?eh,tc_done,{repeat_1_SUITE,
		     {init_per_group,repeat_gr_until_all_fail_2,
		      [{repeat_until_all_fail,2}]},ok}},
       [{?eh,tc_done,{repeat_1_SUITE,
		      {init_per_group,gr_ok_then_fail_init,[]},
		      {failed,{error,failing_this_time}}}},
	{?eh,test_stats,{4,4,{0,3}}},
	{?eh,tc_auto_skip,{repeat_1_SUITE,end_per_group,
			   {failed,{repeat_1_SUITE,init_per_group,
				    {'EXIT',failing_this_time}}}}}],
       {?eh,tc_start,{repeat_1_SUITE,tc_fail_1}},
       {?eh,test_stats,{4,5,{0,3}}},
       {?eh,tc_done,{repeat_1_SUITE,
		     {end_per_group,repeat_gr_until_all_fail_2,
		      [{repeat_until_all_fail,2}]},ok}}],

      [{?eh,tc_done,{repeat_1_SUITE,
		     {init_per_group,repeat_gr_until_all_fail_3,
		      [{repeat_until_all_fail,3}]},ok}},
       [{?eh,tc_done,{repeat_1_SUITE,
		      {end_per_group,gr_fail_result,[]},
		      {return_group_result,failed}}}],
       {?eh,tc_done,{repeat_1_SUITE,tc_ok_then_fail_1,ok}},
       {?eh,test_stats,{6,5,{0,3}}},
       {?eh,tc_done,{repeat_1_SUITE,
		     {end_per_group,repeat_gr_until_all_fail_3,
		      [{repeat_until_all_fail,3}]},ok}}],
      [{?eh,tc_done,{repeat_1_SUITE,
		     {init_per_group,repeat_gr_until_all_fail_3,
		      [{repeat_until_all_fail,2}]},ok}},
       [{?eh,tc_done,{repeat_1_SUITE,
		      {end_per_group,gr_fail_result,[]},
		      {return_group_result,failed}}}],
       {?eh,tc_done,{repeat_1_SUITE,tc_ok_then_fail_1,
		     {failed,{error,failing_this_time}}}},
       {?eh,test_stats,{7,6,{0,3}}},
       {?eh,tc_done,{repeat_1_SUITE,
		     {end_per_group,repeat_gr_until_all_fail_3,
		      [{repeat_until_all_fail,2}]},ok}}],
      {?eh,tc_done,{repeat_1_SUITE,
		    {end_per_group,repeat_gr_until_all_fail,[]},ok}}],
     {?eh,test_done,{'DEF','STOP_TIME'}},
     {?eh,stop_logging,[]}];

test_events(repeat_seq_until_any_fail) ->
    [{?eh,start_logging,{'DEF','RUNDIR'}},
     {?eh,test_start,{'DEF',{'START_TIME','LOGDIR'}}},
     {?eh,start_info,{1,1,unknown}},

     [{?eh,tc_done,{repeat_1_SUITE,
		    {init_per_group,repeat_seq_until_any_fail,[]},ok}},
      [{?eh,tc_done,{repeat_1_SUITE,
		     {init_per_group,repeat_seq_until_any_fail_1,
		      [sequence,{repeat_until_any_fail,2}]},ok}},
       {?eh,tc_done,{repeat_1_SUITE,tc_ok_1,ok}},
       {?eh,tc_done,{repeat_1_SUITE,tc_ok_2,ok}},
       {?eh,test_stats,{2,0,{0,0}}},
       {?eh,tc_done,{repeat_1_SUITE,
		     {end_per_group,repeat_seq_until_any_fail_1,
		      [sequence,{repeat_until_any_fail,2}]},ok}}],
      [{?eh,tc_done,{repeat_1_SUITE,
		     {init_per_group,
		      repeat_seq_until_any_fail_1,[sequence]},ok}},
       {?eh,tc_done,{repeat_1_SUITE,tc_ok_1,ok}},
       {?eh,tc_done,{repeat_1_SUITE,tc_ok_2,ok}},
       {?eh,test_stats,{4,0,{0,0}}},
       {?eh,tc_done,{repeat_1_SUITE,
		     {end_per_group,
		      repeat_seq_until_any_fail_1,[sequence]},ok}}],

      [{?eh,tc_done,{repeat_1_SUITE,
		     {init_per_group,repeat_seq_until_any_fail_2,
		      [{repeat_until_any_fail,2},sequence]},ok}},
       {?eh,test_stats,{5,0,{0,0}}},
       [{?eh,tc_done,{repeat_1_SUITE,{end_per_group,gr_ok_1,[]},ok}}],
       {?eh,test_stats,{7,0,{0,0}}},
       {?eh,tc_done,{repeat_1_SUITE,
		     {end_per_group,repeat_seq_until_any_fail_2,
		      [{repeat_until_any_fail,2},sequence]},ok}}],
      [{?eh,tc_done,{repeat_1_SUITE,
		     {init_per_group,repeat_seq_until_any_fail_2,[sequence]},
		     ok}},
       {?eh,test_stats,{8,0,{0,0}}},
       [{?eh,tc_done,{repeat_1_SUITE,{end_per_group,gr_ok_1,[]},ok}}],
       {?eh,test_stats,{10,0,{0,0}}},
       {?eh,tc_done,{repeat_1_SUITE,
		     {end_per_group,repeat_seq_until_any_fail_2,[sequence]},
		     ok}}],

      [{?eh,tc_done,{repeat_1_SUITE,
		     {init_per_group,repeat_seq_until_any_fail_3,
		      [sequence,{repeat_until_any_fail,3}]},ok}},
       {?eh,tc_done,{repeat_1_SUITE,tc_ok_1,ok}},
       {?eh,test_stats,{11,0,{0,0}}},
       {?eh,tc_done,{repeat_1_SUITE,tc_ok_then_fail_1,ok}},
       {?eh,test_stats,{12,0,{0,0}}},
       {?eh,tc_done,{repeat_1_SUITE,tc_ok_2,ok}},
       {?eh,test_stats,{13,0,{0,0}}},
       [{?eh,tc_done,{repeat_1_SUITE,{end_per_group,gr_ok_1,[]},ok}}],
       {?eh,tc_done,{repeat_1_SUITE,
		     {end_per_group,repeat_seq_until_any_fail_3,
		      [sequence,{repeat_until_any_fail,3}]},ok}}],
      [{?eh,tc_done,{repeat_1_SUITE,
		     {init_per_group,repeat_seq_until_any_fail_3,
		      [{repeat_until_any_fail,2},sequence]},ok}},
       {?eh,tc_done,{repeat_1_SUITE,tc_ok_1,ok}},
       {?eh,test_stats,{15,0,{0,0}}},
       {?eh,tc_done,{repeat_1_SUITE,tc_ok_then_fail_1,
		     {failed,{error,failing_this_time}}}},
       {?eh,test_stats,{15,1,{0,0}}},
       {?eh,tc_auto_skip,{repeat_1_SUITE,tc_ok_2,
			  {failed,{repeat_1_SUITE,tc_ok_then_fail_1}}}},
       {?eh,test_stats,{15,1,{0,1}}},
       {?eh,tc_auto_skip,{repeat_1_SUITE,tc_ok_1,
			  {failed,{repeat_1_SUITE,tc_ok_then_fail_1}}}},
       {?eh,test_stats,{15,1,{0,2}}},
       {?eh,tc_done,{repeat_1_SUITE,
		     {end_per_group,repeat_seq_until_any_fail_3,
		      [{repeat_until_any_fail,2},sequence]},ok}}],

      [{?eh,tc_done,{repeat_1_SUITE,
		     {init_per_group,repeat_seq_until_any_fail_4,
		      [{repeat_until_any_fail,3},sequence]},ok}},
       [{?eh,tc_done,{repeat_1_SUITE,{end_per_group,
				      gr_ok_then_fail_result,[]},ok}}],
       [{?eh,tc_done,{repeat_1_SUITE,{end_per_group,gr_ok_1,[]},ok}}],
       {?eh,tc_done,{repeat_1_SUITE,tc_ok_1,ok}},
       {?eh,test_stats,{18,1,{0,2}}},
       {?eh,tc_done,{repeat_1_SUITE,
		     {end_per_group,repeat_seq_until_any_fail_4,
		      [{repeat_until_any_fail,3},sequence]},ok}}],
      [{?eh,tc_done,{repeat_1_SUITE,
		     {init_per_group,repeat_seq_until_any_fail_4,
		      [{repeat_until_any_fail,2},sequence]},ok}},
       [{?eh,tc_done,{repeat_1_SUITE,
		      {end_per_group,gr_ok_then_fail_result,[]},
		      {return_group_result,failed}}}],
       {?eh,tc_auto_skip,{repeat_1_SUITE,tc_ok_1,
			  {group_result,gr_ok_then_fail_result,failed}}},
       {?eh,test_stats,{19,1,{0,3}}},
       {?eh,tc_auto_skip,{repeat_1_SUITE,tc_ok_1,
			  {group_result,gr_ok_then_fail_result,failed}}},
       {?eh,test_stats,{19,1,{0,4}}},
       {?eh,tc_done,{repeat_1_SUITE,
		     {end_per_group,repeat_seq_until_any_fail_4,
		      [{repeat_until_any_fail,2},sequence]},ok}}],

      [{?eh,tc_done,{repeat_1_SUITE,
		     {init_per_group,repeat_seq_until_any_fail_5,
		      [{repeat_until_any_fail,3},sequence]},ok}},
       [{?eh,tc_done,{repeat_1_SUITE,{end_per_group,gr_ok_1,[]},ok}}],
       [{?eh,tc_done,{repeat_1_SUITE,{end_per_group,gr_ok_then_fail_init,[]},ok}}],
       [{?eh,tc_done,{repeat_1_SUITE,{end_per_group,gr_ok_2,[]},ok}}],
       {?eh,tc_done,{repeat_1_SUITE,tc_ok_1,ok}},
       {?eh,test_stats,{23,1,{0,4}}},
       {?eh,tc_done,{repeat_1_SUITE,
		     {end_per_group,repeat_seq_until_any_fail_5,
		      [{repeat_until_any_fail,3},sequence]},ok}}],
      [{?eh,tc_done,{repeat_1_SUITE,
		     {init_per_group,repeat_seq_until_any_fail_5,
		      [{repeat_until_any_fail,2},sequence]},ok}},
       [{?eh,tc_done,{repeat_1_SUITE,{end_per_group,gr_ok_1,[]},ok}}],
       [{?eh,tc_done,{repeat_1_SUITE,
		      {init_per_group,gr_ok_then_fail_init,[]},
		      {failed,{error,failing_this_time}}}},
	{?eh,test_stats,{24,1,{0,5}}},
	{?eh,tc_auto_skip,{repeat_1_SUITE,end_per_group,
			   {failed,{repeat_1_SUITE,init_per_group,
				    {'EXIT',failing_this_time}}}}}],
       {?eh,tc_auto_skip,{repeat_1_SUITE,tc_ok_1,
			  {group_result,gr_ok_then_fail_init,failed}}},
       {?eh,test_stats,{24,1,{0,6}}},
      {?eh,tc_auto_skip,{repeat_1_SUITE,tc_ok_1,
			 {group_result,gr_ok_then_fail_init,failed}}},
       {?eh,test_stats,{24,1,{0,7}}},
       {?eh,tc_done,{repeat_1_SUITE,
		     {end_per_group,repeat_seq_until_any_fail_5,
		      [{repeat_until_any_fail,2},sequence]},ok}}],
      {?eh,tc_done,{repeat_1_SUITE,
		    {end_per_group,repeat_seq_until_any_fail,[]},ok}}],

     {?eh,test_done,{'DEF','STOP_TIME'}},
     {?eh,stop_logging,[]}];

%%! Note that when testing shuffled groups, ct_test_support expects
%%! both the start and done event for cases and init/end_per_group
test_events(repeat_shuffled_seq_until_any_fail) ->
    [{?eh,start_logging,{'DEF','RUNDIR'}},
     {?eh,test_start,{'DEF',{'START_TIME','LOGDIR'}}},
     {?eh,start_info,{1,1,unknown}},

     [{?eh,tc_done,{repeat_1_SUITE,
		    {init_per_group,repeat_shuffled_seq_until_any_fail,[]},
		    ok}},

      {shuffle,
       [{?eh,tc_start,{repeat_1_SUITE,
		       {init_per_group,repeat_shuffled_seq_until_any_fail_1,
			[{shuffle,'_'},sequence,
			 {repeat_until_any_fail,2}]}}},
	{?eh,tc_done,{repeat_1_SUITE,
		      {init_per_group,repeat_shuffled_seq_until_any_fail_1,
		       [{shuffle,'_'},sequence,
			{repeat_until_any_fail,2}]},ok}},
	{?eh,test_stats,{2,0,{0,0}}},
	{?eh,tc_start,{repeat_1_SUITE,
		       {end_per_group,repeat_shuffled_seq_until_any_fail_1,
			[sequence,shuffle,{repeat_until_any_fail,2}]}}},
	{?eh,tc_done,{repeat_1_SUITE,
		      {end_per_group,repeat_shuffled_seq_until_any_fail_1,
		       [sequence,shuffle,{repeat_until_any_fail,2}]},ok}}]},
      {shuffle,
       [{?eh,tc_start,{repeat_1_SUITE,
		       {init_per_group,repeat_shuffled_seq_until_any_fail_1,
			[{shuffle,'_'},sequence]}}},
	{?eh,tc_done,{repeat_1_SUITE,
		      {init_per_group,repeat_shuffled_seq_until_any_fail_1,
		       [{shuffle,'_'},sequence]},ok}},
	{?eh,test_stats,{4,0,{0,0}}},
	{?eh,tc_start,{repeat_1_SUITE,
		      {end_per_group,repeat_shuffled_seq_until_any_fail_1,
		       [{shuffle,repeated},sequence]}}},
	{?eh,tc_done,{repeat_1_SUITE,
		      {end_per_group,repeat_shuffled_seq_until_any_fail_1,
		       [{shuffle,repeated},sequence]},ok}}]},

      {shuffle,
       [{?eh,tc_start,{repeat_1_SUITE,
		      {init_per_group,repeat_shuffled_seq_until_any_fail_2,
		       [{shuffle,{1,2,3}},{repeat_until_any_fail,2},sequence]}}},
	{?eh,tc_done,{repeat_1_SUITE,
		      {init_per_group,repeat_shuffled_seq_until_any_fail_2,
		       [{shuffle,{1,2,3}},{repeat_until_any_fail,2},sequence]},
		      ok}},
	{?eh,tc_start,{repeat_1_SUITE,tc_ok_1}},
	{?eh,tc_done,{repeat_1_SUITE,tc_ok_1,ok}},
	{?eh,tc_start,{repeat_1_SUITE,tc_ok_2}},
	{?eh,tc_done,{repeat_1_SUITE,tc_ok_2,ok}},
	[{?eh,tc_start,{repeat_1_SUITE,{end_per_group,gr_ok_1,[]}}},
	 {?eh,tc_done,{repeat_1_SUITE,{end_per_group,gr_ok_1,[]},ok}}],
	{?eh,test_stats,{7,0,{0,0}}},
	{?eh,tc_start,{repeat_1_SUITE,
		       {end_per_group,repeat_shuffled_seq_until_any_fail_2,
			[{repeat_until_any_fail,2},{shuffle,{1,2,3}},sequence]}}},
	{?eh,tc_done,{repeat_1_SUITE,
		      {end_per_group,repeat_shuffled_seq_until_any_fail_2,
		       [{repeat_until_any_fail,2},{shuffle,{1,2,3}},sequence]},
		      ok}}]},
      {shuffle,
       [{?eh,tc_start,{repeat_1_SUITE,
		       {init_per_group,repeat_shuffled_seq_until_any_fail_2,
			[{shuffle,'_'},sequence]}}},
	{?eh,tc_done,{repeat_1_SUITE,
		      {init_per_group,repeat_shuffled_seq_until_any_fail_2,
		       [{shuffle,'_'},sequence]},ok}},
	{?eh,tc_start,{repeat_1_SUITE,tc_ok_1}},
	{?eh,tc_done,{repeat_1_SUITE,tc_ok_1,ok}},
	{?eh,tc_start,{repeat_1_SUITE,tc_ok_2}},
	{?eh,tc_done,{repeat_1_SUITE,tc_ok_2,ok}},
	[{?eh,tc_start,{repeat_1_SUITE,{end_per_group,gr_ok_1,[]}}},
	 {?eh,tc_done,{repeat_1_SUITE,{end_per_group,gr_ok_1,[]},ok}}],
	{?eh,tc_start,{repeat_1_SUITE,
		       {end_per_group,repeat_shuffled_seq_until_any_fail_2,
			[{shuffle,repeated},sequence]}}},
	{?eh,tc_done,{repeat_1_SUITE,
		      {end_per_group,repeat_shuffled_seq_until_any_fail_2,
		       [{shuffle,repeated},sequence]},ok}}]},

      {shuffle,
       [{?eh,tc_start,{repeat_1_SUITE,
		      {init_per_group,repeat_shuffled_seq_until_any_fail_3,
		       [{shuffle,'_'},sequence,
			{repeat_until_any_fail,3}]}}},
	{?eh,tc_done,{repeat_1_SUITE,
		      {init_per_group,repeat_shuffled_seq_until_any_fail_3,
		       [{shuffle,'_'},sequence,
			{repeat_until_any_fail,3}]},ok}},
	{?eh,tc_start,{repeat_1_SUITE,tc_ok_then_fail_1}},
	{?eh,tc_done,{repeat_1_SUITE,tc_ok_then_fail_1,ok}},
	{?eh,tc_start,{repeat_1_SUITE,tc_ok_1}},
	{?eh,tc_done,{repeat_1_SUITE,tc_ok_1,ok}},
	{?eh,tc_start,{repeat_1_SUITE,tc_ok_2}},
	{?eh,tc_done,{repeat_1_SUITE,tc_ok_2,ok}},
	[{?eh,tc_start,{repeat_1_SUITE,{end_per_group,gr_ok_1,[]}}},
	 {?eh,tc_done,{repeat_1_SUITE,{end_per_group,gr_ok_1,[]},ok}}],
	{?eh,test_stats,{14,0,{0,0}}},
	{?eh,tc_start,{repeat_1_SUITE,
		       {end_per_group,repeat_shuffled_seq_until_any_fail_3,
			[shuffle,sequence,{repeat_until_any_fail,3}]}}},
	{?eh,tc_done,{repeat_1_SUITE,
		      {end_per_group,repeat_shuffled_seq_until_any_fail_3,
		       [shuffle,sequence,{repeat_until_any_fail,3}]},ok}}]},
      {shuffle,
       [{?eh,tc_start,{repeat_1_SUITE,
		      {init_per_group,repeat_shuffled_seq_until_any_fail_3,
		       [{shuffle,'_'},{repeat_until_any_fail,2},sequence]}}},
	{?eh,tc_done,{repeat_1_SUITE,
		      {init_per_group,repeat_shuffled_seq_until_any_fail_3,
		       [{shuffle,'_'},{repeat_until_any_fail,2},sequence]},
		      ok}},
	{?eh,tc_start,{repeat_1_SUITE,tc_ok_then_fail_1}},
	{?eh,tc_done,{repeat_1_SUITE,tc_ok_then_fail_1,
		      {failed,{error,failing_this_time}}}},
	{?eh,tc_start,{repeat_1_SUITE,
		      {end_per_group,repeat_shuffled_seq_until_any_fail_3,
		       [{shuffle,repeated},{repeat_until_any_fail,2},sequence]}}},
	{?eh,tc_done,{repeat_1_SUITE,
		      {end_per_group,repeat_shuffled_seq_until_any_fail_3,
		       [{shuffle,repeated},{repeat_until_any_fail,2},sequence]},
		      ok}}]},

      {shuffle,
       [{?eh,tc_start,{repeat_1_SUITE,
		      {init_per_group,repeat_shuffled_seq_until_any_fail_4,
		       [{shuffle,{1,2,3}},{repeat_until_any_fail,3},sequence]}}},
	{?eh,tc_done,{repeat_1_SUITE,
		      {init_per_group,repeat_shuffled_seq_until_any_fail_4,
		       [{shuffle,{1,2,3}},{repeat_until_any_fail,3},sequence]},
		      ok}},
	{?eh,tc_start,{repeat_1_SUITE,tc_ok_1}},
	{?eh,tc_done,{repeat_1_SUITE,tc_ok_1,ok}},
	[{?eh,tc_start,{repeat_1_SUITE,{end_per_group,gr_ok_1,[]}}},
	 {?eh,tc_done,{repeat_1_SUITE,{end_per_group,gr_ok_1,[]},ok}}],
	[{?eh,tc_start,{repeat_1_SUITE,{end_per_group,
					gr_ok_then_fail_result,[]}}},
	 {?eh,tc_done,{repeat_1_SUITE,{end_per_group,
				       gr_ok_then_fail_result,[]},ok}}],
	{?eh,tc_start,{repeat_1_SUITE,
		       {end_per_group,repeat_shuffled_seq_until_any_fail_4,
			[{repeat_until_any_fail,3},sequence,{shuffle,{1,2,3}}]}}},
	{?eh,tc_done,{repeat_1_SUITE,
		      {end_per_group,repeat_shuffled_seq_until_any_fail_4,
		       [{repeat_until_any_fail,3},sequence,{shuffle,{1,2,3}}]},
		      ok}}]},
      {shuffle,
       [{?eh,tc_start,{repeat_1_SUITE,
		       {init_per_group,repeat_shuffled_seq_until_any_fail_4,
			[{shuffle,'_'},{repeat_until_any_fail,2},sequence]}}},
	{?eh,tc_done,{repeat_1_SUITE,
		      {init_per_group,repeat_shuffled_seq_until_any_fail_4,
		       [{shuffle,'_'},{repeat_until_any_fail,2},sequence]},
		      ok}},
	[{?eh,tc_start,{repeat_1_SUITE,
			{end_per_group,gr_ok_then_fail_result,[]}}},
	 {?eh,tc_done,{repeat_1_SUITE,
		       {end_per_group,gr_ok_then_fail_result,[]},
		       {return_group_result,failed}}}],
	{?eh,tc_start,{repeat_1_SUITE,
		       {end_per_group,repeat_shuffled_seq_until_any_fail_4,
			[{shuffle,repeated},{repeat_until_any_fail,2},sequence]}}},
	{?eh,tc_done,{repeat_1_SUITE,
		      {end_per_group,repeat_shuffled_seq_until_any_fail_4,
		       [{shuffle,repeated},{repeat_until_any_fail,2},sequence]},
		      ok}}]},

      {shuffle,
       [{?eh,tc_start,{repeat_1_SUITE,
		       {init_per_group,repeat_shuffled_seq_until_any_fail_5,
			[{shuffle,{1,2,3}},{repeat_until_any_fail,3},sequence]}}},
	{?eh,tc_done,{repeat_1_SUITE,
		      {init_per_group,repeat_shuffled_seq_until_any_fail_5,
		       [{shuffle,{1,2,3}},{repeat_until_any_fail,3},sequence]},
		      ok}},
	{?eh,tc_start,{repeat_1_SUITE,tc_ok_1}},
	{?eh,tc_done,{repeat_1_SUITE,tc_ok_1,ok}},
	[{?eh,tc_start,{repeat_1_SUITE,{end_per_group,gr_ok_1,[]}}},
	 {?eh,tc_done,{repeat_1_SUITE,{end_per_group,gr_ok_1,[]},ok}}],
	[{?eh,tc_start,{repeat_1_SUITE,{end_per_group,gr_ok_2,[]}}},
	 {?eh,tc_done,{repeat_1_SUITE,{end_per_group,gr_ok_2,[]},ok}}],
	[{?eh,tc_start,{repeat_1_SUITE,{end_per_group,
					gr_ok_then_fail_init,[]}}},
	 {?eh,tc_done,{repeat_1_SUITE,{end_per_group,
				       gr_ok_then_fail_init,[]},ok}}],
	{?eh,tc_start,{repeat_1_SUITE,
		       {end_per_group,repeat_shuffled_seq_until_any_fail_5,
			[{repeat_until_any_fail,3},sequence,{shuffle,{1,2,3}}]}}},
	{?eh,tc_done,{repeat_1_SUITE,
		      {end_per_group,repeat_shuffled_seq_until_any_fail_5,
		       [{repeat_until_any_fail,3},sequence,{shuffle,{1,2,3}}]},
		      ok}}]},
      {shuffle,
       [{?eh,tc_start,{repeat_1_SUITE,
		      {init_per_group,repeat_shuffled_seq_until_any_fail_5,
		       [{shuffle,'_'},{repeat_until_any_fail,2},
			sequence]}}},
	{?eh,tc_done,{repeat_1_SUITE,
		      {init_per_group,repeat_shuffled_seq_until_any_fail_5,
		       [{shuffle,'_'},{repeat_until_any_fail,2},
			sequence]},ok}},
	[{?eh,tc_auto_skip,{repeat_1_SUITE,end_per_group,
			    {failed,{repeat_1_SUITE,init_per_group,
				     {'EXIT',failing_this_time}}}}}],
	{?eh,tc_start,{repeat_1_SUITE,
		       {end_per_group,repeat_shuffled_seq_until_any_fail_5,
			[{shuffle,repeated},{repeat_until_any_fail,2},sequence]}}},
	{?eh,tc_done,{repeat_1_SUITE,
		      {end_per_group,repeat_shuffled_seq_until_any_fail_5,
		       [{shuffle,repeated},{repeat_until_any_fail,2},sequence]},
		      ok}}]},

       {?eh,tc_done,{repeat_1_SUITE,
		     {end_per_group,repeat_shuffled_seq_until_any_fail,[]},
		     ok}}],
     {?eh,test_done,{'DEF','STOP_TIME'}},
     {?eh,stop_logging,[]}].
