# -*- coding: utf-8 -*-
# Elisa - Home multimedia server
# Copyright (C) 2006-2008 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.


__maintainer__ = 'Benjamin Kampmann <benjamin@fluendo.com>'

from elisa.core import common

from menu_entry_builder import MenuEntryBuilder

from twisted.internet import defer

class PlaylistNodeBuilder(MenuEntryBuilder):
    """
    Build MenuEntries for the type 'menu_node'. this is meant to be temporaly
    """

    def __init__(self):
        registry = common.application.plugin_registry
        self._clear_model = registry.create_component('base:menu_node_model')
        self._clear_model.text = "Clear Playlist"
        self._clear_model.theme_icon = "clear_playlist_icon"

        clear_action = registry.create_component('xmlmenu:clearplaylist_action')

        # FIXME: cross-referencing is bad!
        clear_action.clearing_model = self._clear_model

        # FIXME: cross-referencing is bad!
        self._clear_model.activate_action = clear_action



    def menu_entry_identifiers__get(self):
        return ['playlist_node']

    def build_menu_entry(self, parent, node):
        # Label-Making
        label_tag = node.find('Label')
        label = self._make_label(label_tag)

        default_config = self.model_configs[parent]
        config = self._make_config(node.find('Configuration'),
                                   default_config)

        registry = common.application.plugin_registry
        menu_model = registry.create_component('base:menu_node_model')
        menu_model.children = parent.activity.player_model.playlist
        menu_model.activity = self
        menu_model.text = label
        menu_model.has_children = True
        self._set_icon(menu_model, node.find('Icon'),
                        fallback=config['DefaultDirsIcon'])

        self.model_configs[menu_model] = config

        # FIXME: wrong place to do that!
        self._clear_model.activate_action.player_model = parent.activity.player_model

        parent.children.append(menu_model)
        return defer.succeed([menu_model])

    def loadmore(self, model):
        if not self._clear_model in model.children:
            model.children.insert(0, self._clear_model)
        return defer.succeed(model.children)

    def unload(self, model):
        if len(model.children):
            model.children.remove(self._clear_model)
