/*
 * This file is autogenerated with bcop:
 * The Compiz option code generator
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */

#ifndef _WIDGET_OPTIONS_H
#define _WIDGET_OPTIONS_H

#include <compiz-common.h>

COMPIZ_BEGIN_DECLS

CompPluginVTable * getCompPluginInfo (void);

typedef enum
{
    WidgetDisplayOptionToggleKey,
    WidgetDisplayOptionToggleButton,
    WidgetDisplayOptionToggleEdge,
    WidgetDisplayOptionNum
} WidgetDisplayOptions;

typedef void (*widgetDisplayOptionChangeNotifyProc) (CompDisplay *display, CompOption *opt, WidgetDisplayOptions num);

CompOption *widgetGetDisplayOption (CompDisplay *d, WidgetDisplayOptions num);

typedef enum
{
    WidgetScreenOptionMatch,
    WidgetScreenOptionEndOnClick,
    WidgetScreenOptionFadeTime,
    WidgetScreenOptionBgBrightness,
    WidgetScreenOptionBgSaturation,
    WidgetScreenOptionNum
} WidgetScreenOptions;

typedef void (*widgetScreenOptionChangeNotifyProc) (CompScreen *screen, CompOption *opt, WidgetScreenOptions num);

CompOption *widgetGetScreenOption (CompScreen *s, WidgetScreenOptions num);

CompAction *     widgetGetToggleKey (CompDisplay *d);
void             widgetSetToggleKeyInitiate (CompDisplay *d, CompActionCallBackProc init);
void             widgetSetToggleKeyTerminate (CompDisplay *d, CompActionCallBackProc term);
CompOption *     widgetGetToggleKeyOption (CompDisplay *d);
void             widgetSetToggleKeyNotify (CompDisplay *d, widgetDisplayOptionChangeNotifyProc notify);

CompAction *     widgetGetToggleButton (CompDisplay *d);
void             widgetSetToggleButtonInitiate (CompDisplay *d, CompActionCallBackProc init);
void             widgetSetToggleButtonTerminate (CompDisplay *d, CompActionCallBackProc term);
CompOption *     widgetGetToggleButtonOption (CompDisplay *d);
void             widgetSetToggleButtonNotify (CompDisplay *d, widgetDisplayOptionChangeNotifyProc notify);

CompAction *     widgetGetToggleEdge (CompDisplay *d);
void             widgetSetToggleEdgeInitiate (CompDisplay *d, CompActionCallBackProc init);
void             widgetSetToggleEdgeTerminate (CompDisplay *d, CompActionCallBackProc term);
CompOption *     widgetGetToggleEdgeOption (CompDisplay *d);
void             widgetSetToggleEdgeNotify (CompDisplay *d, widgetDisplayOptionChangeNotifyProc notify);

CompMatch *      widgetGetMatch (CompScreen *s);
CompOption *     widgetGetMatchOption (CompScreen *s);
void             widgetSetMatchNotify (CompScreen *s, widgetScreenOptionChangeNotifyProc notify);

Bool             widgetGetEndOnClick (CompScreen *s);
CompOption *     widgetGetEndOnClickOption (CompScreen *s);
void             widgetSetEndOnClickNotify (CompScreen *s, widgetScreenOptionChangeNotifyProc notify);

float            widgetGetFadeTime (CompScreen *s);
CompOption *     widgetGetFadeTimeOption (CompScreen *s);
void             widgetSetFadeTimeNotify (CompScreen *s, widgetScreenOptionChangeNotifyProc notify);

int              widgetGetBgBrightness (CompScreen *s);
CompOption *     widgetGetBgBrightnessOption (CompScreen *s);
void             widgetSetBgBrightnessNotify (CompScreen *s, widgetScreenOptionChangeNotifyProc notify);

int              widgetGetBgSaturation (CompScreen *s);
CompOption *     widgetGetBgSaturationOption (CompScreen *s);
void             widgetSetBgSaturationNotify (CompScreen *s, widgetScreenOptionChangeNotifyProc notify);

#ifndef GENERIC_PRIVATE_DEFINES
#define GENERIC_PRIVATE_DEFINES

#define GET_PLUGIN_CORE(object, plugin) \
    ((plugin##Core *) (object)->base.privates[plugin##CorePrivateIndex].ptr)
#define PLUGIN_CORE(object, plugin, prefix) \
    plugin##Core * prefix##c = GET_PLUGIN_CORE (object, plugin)

#define GET_PLUGIN_DISPLAY(object, plugin) \
    ((plugin##Display *) \
	(object)->base.privates[plugin##DisplayPrivateIndex].ptr)
#define PLUGIN_DISPLAY(object, plugin, prefix) \
    plugin##Display * prefix##d = GET_PLUGIN_DISPLAY (object, plugin)

#define GET_PLUGIN_SCREEN(object, parent, plugin) \
    ((plugin##Screen *) \
	(object)->base.privates[(parent)->screenPrivateIndex].ptr)
#define PLUGIN_SCREEN(object, plugin, prefix) \
    plugin##Screen * prefix##s = \
	GET_PLUGIN_SCREEN (object, \
	GET_PLUGIN_DISPLAY ((object)->display, plugin), plugin)

#define GET_PLUGIN_WINDOW(object, parent, plugin) \
    ((plugin##Window *) \
	(object)->base.privates[(parent)->windowPrivateIndex].ptr)
#define PLUGIN_WINDOW(object, plugin, prefix) \
    plugin##Window * prefix##w = \
	GET_PLUGIN_WINDOW  (object, \
	GET_PLUGIN_SCREEN  ((object)->screen, \
	GET_PLUGIN_DISPLAY ((object)->screen->display, plugin), plugin), plugin)

#endif

COMPIZ_END_DECLS

#endif
