/*
 * This file is autogenerated with bcop:
 * The Compiz option code generator
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <compiz-core.h>

#include "maximumize_options.h"

static int MaximumizeOptionsDisplayPrivateIndex;

static CompMetadata maximumizeOptionsMetadata;

static CompPluginVTable *maximumizePluginVTable = NULL;
CompPluginVTable maximumizeOptionsVTable;

#define MAXIMUMIZE_OPTIONS_DISPLAY(d) PLUGIN_DISPLAY(d, MaximumizeOptions, o)
#define MAXIMUMIZE_OPTIONS_SCREEN(s) PLUGIN_SCREEN(s, MaximumizeOptions, o)

typedef struct _MaximumizeOptionsDisplay
{
    int screenPrivateIndex;

    CompOption opt[MaximumizeDisplayOptionNum];
    maximumizeDisplayOptionChangeNotifyProc notify[MaximumizeDisplayOptionNum];
} MaximumizeOptionsDisplay;

typedef struct _MaximumizeOptionsScreen
{
} MaximumizeOptionsScreen;

Bool maximumizeGetIgnoreSticky (CompDisplay *d)
{
    MAXIMUMIZE_OPTIONS_DISPLAY(d);
    return od->opt[MaximumizeDisplayOptionIgnoreSticky].value.b;
}

CompOption * maximumizeGetIgnoreStickyOption (CompDisplay *d)
{
    MAXIMUMIZE_OPTIONS_DISPLAY(d);
    return &od->opt[MaximumizeDisplayOptionIgnoreSticky];
}

void maximumizeSetIgnoreStickyNotify (CompDisplay *d, maximumizeDisplayOptionChangeNotifyProc notify)
{
    MAXIMUMIZE_OPTIONS_DISPLAY(d);
    od->notify[MaximumizeDisplayOptionIgnoreSticky] = notify;
}

Bool maximumizeGetIgnoreOverlapping (CompDisplay *d)
{
    MAXIMUMIZE_OPTIONS_DISPLAY(d);
    return od->opt[MaximumizeDisplayOptionIgnoreOverlapping].value.b;
}

CompOption * maximumizeGetIgnoreOverlappingOption (CompDisplay *d)
{
    MAXIMUMIZE_OPTIONS_DISPLAY(d);
    return &od->opt[MaximumizeDisplayOptionIgnoreOverlapping];
}

void maximumizeSetIgnoreOverlappingNotify (CompDisplay *d, maximumizeDisplayOptionChangeNotifyProc notify)
{
    MAXIMUMIZE_OPTIONS_DISPLAY(d);
    od->notify[MaximumizeDisplayOptionIgnoreOverlapping] = notify;
}

CompAction * maximumizeGetTriggerKey (CompDisplay *d)
{
    MAXIMUMIZE_OPTIONS_DISPLAY(d);
    return &od->opt[MaximumizeDisplayOptionTriggerKey].value.action;
}

void maximumizeSetTriggerKeyInitiate (CompDisplay *d, CompActionCallBackProc init)
{
    MAXIMUMIZE_OPTIONS_DISPLAY(d);
    od->opt[MaximumizeDisplayOptionTriggerKey].value.action.initiate = init;
}

void maximumizeSetTriggerKeyTerminate (CompDisplay *d, CompActionCallBackProc term)
{
    MAXIMUMIZE_OPTIONS_DISPLAY(d);
    od->opt[MaximumizeDisplayOptionTriggerKey].value.action.terminate = term;
}

CompOption * maximumizeGetTriggerKeyOption (CompDisplay *d)
{
    MAXIMUMIZE_OPTIONS_DISPLAY(d);
    return &od->opt[MaximumizeDisplayOptionTriggerKey];
}

void maximumizeSetTriggerKeyNotify (CompDisplay *d, maximumizeDisplayOptionChangeNotifyProc notify)
{
    MAXIMUMIZE_OPTIONS_DISPLAY(d);
    od->notify[MaximumizeDisplayOptionTriggerKey] = notify;
}

CompOption * maximumizeGetDisplayOption (CompDisplay *d, MaximumizeDisplayOptions num)
{
    MAXIMUMIZE_OPTIONS_DISPLAY(d);
    return &od->opt[num];
}

static const CompMetadataOptionInfo maximumizeOptionsDisplayOptionInfo[] = {
    { "ignore_sticky", "bool", 0, 0, 0 },
    { "ignore_overlapping", "bool", 0, 0, 0 },
    { "trigger_key", "key", 0, 0, 0 },
};

static Bool maximumizeOptionsSetDisplayOption (CompPlugin *plugin, CompDisplay *d, const char *name, CompOptionValue *value)
{
    MAXIMUMIZE_OPTIONS_DISPLAY(d);
    CompOption *o;
    int        index;

    o = compFindOption (od->opt, MaximumizeDisplayOptionNum, name, &index);

    if (!o)
        return FALSE;

    switch (index)
    {
     case MaximumizeDisplayOptionIgnoreSticky:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[MaximumizeDisplayOptionIgnoreSticky])
                (*od->notify[MaximumizeDisplayOptionIgnoreSticky]) (d, o, MaximumizeDisplayOptionIgnoreSticky);
            return TRUE;
        }
        break;
     case MaximumizeDisplayOptionIgnoreOverlapping:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[MaximumizeDisplayOptionIgnoreOverlapping])
                (*od->notify[MaximumizeDisplayOptionIgnoreOverlapping]) (d, o, MaximumizeDisplayOptionIgnoreOverlapping);
            return TRUE;
        }
        break;
     case MaximumizeDisplayOptionTriggerKey:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[MaximumizeDisplayOptionTriggerKey])
                (*od->notify[MaximumizeDisplayOptionTriggerKey]) (d, o, MaximumizeDisplayOptionTriggerKey);
            return TRUE;
        }
        break;
    default:
        break;
    }
    return FALSE;
}

static CompOption * maximumizeOptionsGetDisplayOptions (CompPlugin *plugin, CompDisplay *d, int *count)
{
    MAXIMUMIZE_OPTIONS_DISPLAY(d);
    *count = MaximumizeDisplayOptionNum;
    return od->opt;
}

static Bool maximumizeOptionsInitScreen (CompPlugin *p, CompScreen *s)
{
    MaximumizeOptionsScreen *os;
    
    MAXIMUMIZE_OPTIONS_DISPLAY (s->display);

    os = calloc (1, sizeof(MaximumizeOptionsScreen));
    if (!os)
        return FALSE;

    s->base.privates[od->screenPrivateIndex].ptr = os;

    
    return TRUE;
}

static void maximumizeOptionsFiniScreen (CompPlugin *p, CompScreen *s)
{
    MAXIMUMIZE_OPTIONS_SCREEN (s);

    free (os);
}

static Bool maximumizeOptionsInitDisplay (CompPlugin *p, CompDisplay *d)
{
    MaximumizeOptionsDisplay *od;
   
    
    od = calloc (1, sizeof(MaximumizeOptionsDisplay));
    if (!od)
        return FALSE;

    od->screenPrivateIndex = allocateScreenPrivateIndex(d);
    if (od->screenPrivateIndex < 0)
    {
        free(od);
        return FALSE;
    }

    d->base.privates[MaximumizeOptionsDisplayPrivateIndex].ptr = od;

    if (!compInitDisplayOptionsFromMetadata (d, &maximumizeOptionsMetadata, maximumizeOptionsDisplayOptionInfo, od->opt, MaximumizeDisplayOptionNum))
    {
        free (od);
        return FALSE;
    }

    return TRUE;
}

static void maximumizeOptionsFiniDisplay (CompPlugin *p, CompDisplay *d)
{
    MAXIMUMIZE_OPTIONS_DISPLAY (d);

    freeScreenPrivateIndex(d, od->screenPrivateIndex);

    compFiniDisplayOptions (d, od->opt, MaximumizeDisplayOptionNum);

    free (od);
}

static Bool maximumizeOptionsInit (CompPlugin *p)
{
    MaximumizeOptionsDisplayPrivateIndex = allocateDisplayPrivateIndex();
    if (MaximumizeOptionsDisplayPrivateIndex < 0)
        return FALSE;

    if (!compInitPluginMetadataFromInfo (&maximumizeOptionsMetadata, "maximumize",maximumizeOptionsDisplayOptionInfo, MaximumizeDisplayOptionNum, 0, 0))
        return FALSE;

    compAddMetadataFromFile (&maximumizeOptionsMetadata, "maximumize");
    if (maximumizePluginVTable && maximumizePluginVTable->init)
        return maximumizePluginVTable->init (p);
    return TRUE;
}

static void maximumizeOptionsFini (CompPlugin *p)
{
    if (maximumizePluginVTable && maximumizePluginVTable->fini)
        maximumizePluginVTable->fini (p);

    if (MaximumizeOptionsDisplayPrivateIndex >= 0)
        freeDisplayPrivateIndex (MaximumizeOptionsDisplayPrivateIndex);

    compFiniMetadata (&maximumizeOptionsMetadata);
}

static CompBool maximumizeOptionsInitObject (CompPlugin *p, CompObject *o)
{
    static InitPluginObjectProc dispTab[] = {
        (InitPluginObjectProc) 0,
        (InitPluginObjectProc) maximumizeOptionsInitDisplay,
        (InitPluginObjectProc) maximumizeOptionsInitScreen
    };

    RETURN_DISPATCH (o, dispTab, ARRAY_SIZE (dispTab), TRUE, (p, o));
}

static void maximumizeOptionsFiniObject (CompPlugin *p, CompObject *o)
{
    static FiniPluginObjectProc dispTab[] = {
        (FiniPluginObjectProc) 0,
        (FiniPluginObjectProc) maximumizeOptionsFiniDisplay,
        (FiniPluginObjectProc) maximumizeOptionsFiniScreen
    };

    DISPATCH (o, dispTab, ARRAY_SIZE (dispTab), (p, o));
}

static CompBool maximumizeOptionsInitObjectWrapper (CompPlugin *p, CompObject *o)
{
    CompBool rv = TRUE;
    rv = maximumizeOptionsInitObject (p, o);
    if (maximumizePluginVTable->initObject)
        rv &= maximumizePluginVTable->initObject (p, o);
    return rv;
}

static void maximumizeOptionsFiniObjectWrapper (CompPlugin *p, CompObject *o)
{
    if (maximumizePluginVTable->finiObject)
        maximumizePluginVTable->finiObject (p, o);
    maximumizeOptionsFiniObject (p, o);
}

static CompOption * maximumizeOptionsGetObjectOptions (CompPlugin *p, CompObject *o, int *count)
{
    static GetPluginObjectOptionsProc dispTab[] = {
        (GetPluginObjectOptionsProc) 0,
            (GetPluginObjectOptionsProc) maximumizeOptionsGetDisplayOptions,
    };

    *count = 0;
    RETURN_DISPATCH (o, dispTab, ARRAY_SIZE (dispTab),
		     NULL, (p, o, count));
}

static CompBool maximumizeOptionsSetObjectOption (CompPlugin *p, CompObject *o, const char *name, CompOptionValue *value)
{
    static SetPluginObjectOptionProc dispTab[] = {
        (SetPluginObjectOptionProc) 0,
        (SetPluginObjectOptionProc) maximumizeOptionsSetDisplayOption,
    };

    RETURN_DISPATCH (o, dispTab, ARRAY_SIZE (dispTab), FALSE,
		     (p, o, name, value));
}

static CompMetadata *
maximumizeOptionsGetMetadata (CompPlugin *plugin)
{
    return &maximumizeOptionsMetadata;
}

CompPluginVTable *getCompPluginInfo20070830 (void)
{
    if (!maximumizePluginVTable)
    {
        maximumizePluginVTable = getCompPluginInfo ();
        memcpy(&maximumizeOptionsVTable, maximumizePluginVTable, sizeof(CompPluginVTable));
        maximumizeOptionsVTable.getMetadata = maximumizeOptionsGetMetadata;
        maximumizeOptionsVTable.init = maximumizeOptionsInit;
        maximumizeOptionsVTable.fini = maximumizeOptionsFini;
        maximumizeOptionsVTable.initObject = maximumizeOptionsInitObjectWrapper;
        maximumizeOptionsVTable.finiObject = maximumizeOptionsFiniObjectWrapper;
        maximumizeOptionsVTable.getObjectOptions = maximumizeOptionsGetObjectOptions;
	maximumizeOptionsVTable.setObjectOption = maximumizeOptionsSetObjectOption;
	
    }
    return &maximumizeOptionsVTable;
}

