/*
 * Copyright (C) 2009 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as 
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Mirco Müller <mirco.mueller@canonical.com>
 *
 */

#include <math.h>
#include <glib.h>
#include <stdio.h>
#include <stdlib.h>
#include <strings.h>
#include <clutk/clutk.h>

void on_focus_out(ClutterActor *actor, gpointer data)
{
    g_debug ("focus out\n");
}

void on_focus_in(ClutterActor *actor, gpointer data)
{
    g_debug ("focus in\n");
}

gint
main (gint    argc,
      gchar** argv)
{
  g_type_init (); 

	clutter_init (&argc, &argv);
	ctk_init (&argc, &argv);

  ClutterActor *stage;
  CtkActor     *actor;
  ClutterColor stage_color = { 0x4D, 0x4D, 0x4D, 0xff };
  ClutterColor selection_color = { 0x1D, 0x1D, 0x3D, 0x99 };

  stage = clutter_stage_get_default ();
  clutter_actor_set_size (CLUTTER_ACTOR(stage), 640, 200);
  clutter_stage_set_color (CLUTTER_STAGE(stage), &stage_color);

  actor = (CtkActor *)ctk_text_new ("Hello World!");
  clutter_actor_set_reactive (CLUTTER_ACTOR(actor), TRUE);
  clutter_text_set_selectable (CLUTTER_TEXT(actor), TRUE);
  clutter_text_set_editable (CLUTTER_TEXT(actor), TRUE);
  clutter_text_set_activatable (CLUTTER_TEXT(actor), TRUE);
  clutter_text_set_single_line_mode (CLUTTER_TEXT(actor), TRUE);
  clutter_text_set_selection_color (CLUTTER_TEXT(actor), &selection_color);

  g_signal_connect (CLUTTER_ACTOR(actor), "key-focus-out", G_CALLBACK (on_focus_out), NULL);
  g_signal_connect (CLUTTER_ACTOR(actor), "key-focus-in", G_CALLBACK (on_focus_in), NULL);


  clutter_container_add_actor (CLUTTER_CONTAINER (stage), CLUTTER_ACTOR (actor));
  clutter_actor_set_size (CLUTTER_ACTOR (actor), 250, 32);
  clutter_actor_set_position (CLUTTER_ACTOR (actor), 5, 5);

  clutter_actor_show_all (stage);

  clutter_main ();

  return 0;
}


