/*
 * Copyright 2009 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of either or both of the following licenses:
 *
 * 1) the GNU Lesser General Public License version 3, as published by the
 * Free Software Foundation; and/or
 * 2) the GNU Lesser General Public License version 2.1, as published by
 * the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranties of
 * MERCHANTABILITY, SATISFACTORY QUALITY or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the applicable version of the GNU Lesser General Public
 * License for more details.
 *
 * You should have received a copy of both the GNU Lesser General Public
 * License version 3 and version 2.1 along with this program.  If not, see
 * <http://www.gnu.org/licenses/>
 *
 * Authored by: Neil Jagdish Patel <neil.patel@canonical.com>
 *
 */
/** 
 * SECTION:ctk-vbox
 * @short_description: A vertical container 
 * @see_also: #CtkHBox
 * @include ctk-vbox.h
 *
 * #CtkVBox is a container that organises children into a single column.
 */
#if HAVE_CONFIG_H
#include <config.h>
#endif

#include "ctk-vbox.h"

G_DEFINE_TYPE (CtkVBox, ctk_vbox, CTK_TYPE_BOX);

#define CTK_VBOX_GET_PRIVATE(obj) (G_TYPE_INSTANCE_GET_PRIVATE ((obj),\
  CTK_TYPE_VBOX, \
  CtkVBoxPrivate))

/* GObject stuff */
static void
ctk_vbox_class_init (CtkVBoxClass *klass)
{
}

static void
ctk_vbox_init (CtkVBox *vbox)
{
}

/*
 * Public methods
 */

/**
 * ctk_vbox_new:
 * @spacing: a guint to specify the spacing for this box
 *
 * creates a new CtkVBox
 *
 * Returns: A new CtkVBox
 */
ClutterActor *
ctk_vbox_new (guint spacing)

{
  ClutterActor *vbox = NULL;

  vbox = g_object_new (CTK_TYPE_VBOX,
                       "spacing", spacing,
                       "homogeneous", FALSE,
                       "orientation", CTK_ORIENTATION_VERTICAL,
                       NULL);
  return vbox;
}

