/*
 * Copyright 2009 Canonical Ltd.
 * 
 * This program is free software: you can redistribute it and/or modify it 
 * under the terms of either or both of the following licenses:
 *
 * 1) the GNU Lesser General Public License version 3, as published by the 
 * Free Software Foundation; and/or
 * 2) the GNU Lesser General Public License version 2.1, as published by 
 * the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranties of 
 * MERCHANTABILITY, SATISFTOPLEVELY QUALITY or FITNESS FOR A PARTICULAR 
 * PURPOSE.  See the applicable version of the GNU Lesser General Public 
 * License for more details.
 * 
 * You should have received a copy of both the GNU Lesser General Public 
 * License version 3 and version 2.1 along with this program.  If not, see 
 * <http://www.gnu.org/licenses/>
 *
 * Authored by: Neil Jagdish Patel <neil.patel@canonical.com>
 *
 */

#ifndef _CTK_TOPLEVEL_H_
#define _CTK_TOPLEVEL_H_

#include <glib.h>
#include <clutter-gtk/clutter-gtk.h>
#include <clutk/ctk-bin.h>
#include <clutk/ctk-focusable.h>

G_BEGIN_DECLS

#define CTK_TYPE_TOPLEVEL (ctk_toplevel_get_type ())

#define CTK_TOPLEVEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj),\
	CTK_TYPE_TOPLEVEL, CtkToplevel))

#define CTK_TOPLEVEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass),\
	CTK_TYPE_TOPLEVEL, CtkToplevelClass))

#define CTK_IS_TOPLEVEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj),\
	CTK_TYPE_TOPLEVEL))

#define CTK_IS_TOPLEVEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass),\
	CTK_TYPE_TOPLEVEL))

#define CTK_TOPLEVEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj),\
	CTK_TYPE_TOPLEVEL, CtkToplevelClass))

typedef struct _CtkToplevel        CtkToplevel;
typedef struct _CtkToplevelClass   CtkToplevelClass;
typedef struct _CtkToplevelPrivate CtkToplevelPrivate;
 
struct _CtkToplevel
{
  CtkBin parent;	

  CtkToplevelPrivate *priv;
};

struct _CtkToplevelClass
{
  /*< private >*/
  CtkBinClass  parent_class;

  /*< public >*/
  /* signals, not vfuncs */

  /* vtable */

  /*< private >*/
  /* padding */
  void (*_ctk_padding1) (void);
  void (*_ctk_padding2) (void);
  void (*_ctk_padding3) (void);
  void (*_ctk_padding4) (void);
  void (*_ctk_padding5) (void);
  void (*_ctk_padding6) (void);
};

GType          ctk_toplevel_get_type              (void) G_GNUC_CONST;

ClutterActor * ctk_toplevel_get_default_for_stage (ClutterActor    *stage);

void           ctk_toplevel_set_focus             (CtkToplevel     *self,
                                                   CtkFocusable    *focusable);

ClutterActor * ctk_toplevel_get_stage             (CtkToplevel     *self);

G_END_DECLS

#endif /* _CTK_TOPLEVEL_H_ */

