/*
 * Copyright 2009 Canonical Ltd.
 * 
 * This program is free software: you can redistribute it and/or modify it 
 * under the terms of either or both of the following licenses:
 *
 * 1) the GNU Lesser General Public License version 3, as published by the 
 * Free Software Foundation; and/or
 * 2) the GNU Lesser General Public License version 2.1, as published by 
 * the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranties of 
 * MERCHANTABILITY, SATISFACTORY QUALITY or FITNESS FOR A PARTICULAR 
 * PURPOSE.  See the applicable version of the GNU Lesser General Public 
 * License for more details.
 * 
 * You should have received a copy of both the GNU Lesser General Public 
 * License version 3 and version 2.1 along with this program.  If not, see 
 * <http://www.gnu.org/licenses/>
 *
 * Authored by: Neil Jagdish Patel <neil.patel@canonical.com>
 *
 */

#ifndef __CTK_FOCUSABLE_H__
#define __CTK_FOCUSABLE_H__

#include <clutter/clutter.h>

G_BEGIN_DECLS

#define CTK_TYPE_FOCUSABLE (ctk_focusable_get_type ())
#define CTK_FOCUSABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), \
        CTK_TYPE_FOCUSABLE, CtkFocusable))
#define CTK_IS_FOCUSABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), \
        CTK_TYPE_FOCUSABLE))
#define CTK_FOCUSABLE_GET_IFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), \
        CTK_TYPE_FOCUSABLE, CtkFocusableIface))

typedef struct _CtkFocusable      CtkFocusable;
typedef struct _CtkFocusableIface CtkFocusableIface;

struct _CtkFocusableIface
{
  /*< private >*/
  GTypeInterface g_iface;

  /*< public >*/
  void     (*set_focused) (CtkFocusable *focusable,
                           gboolean      is_focused);

  gboolean (*get_focused) (CtkFocusable *focusable);

  gboolean (*can_focus)   (CtkFocusable *focusable);

  void     (*activate)    (CtkFocusable      *focusable);
};

typedef enum
{
  CTK_FOCUS_DIR_NONE,
  CTK_FOCUS_DIR_NEXT,
  CTK_FOCUS_DIR_PREV,
  CTK_FOCUS_DIR_UP,
  CTK_FOCUS_DIR_RIGHT,
  CTK_FOCUS_DIR_DOWN,
  CTK_FOCUS_DIR_LEFT
} CtkFocusDirection;

typedef enum
{
  CTK_FOCUS_EVENT_NONE,
  CTK_FOCUS_EVENT_DIRECTION,
  CTK_FOCUS_EVENT_ACTIVATE
} CtkFocusEventType ;

GType    ctk_focusable_get_type         (void) G_GNUC_CONST;

void     ctk_focusable_set_focused (CtkFocusable      *focusable,
                                    gboolean           is_focused);

gboolean ctk_focusable_get_focused (CtkFocusable      *focusable);

gboolean ctk_focusable_can_focus   (CtkFocusable      *focusable);

void     ctk_focusable_activate    (CtkFocusable      *focusable);

/*
 * Convenience function to get the direction for a ClutterKeyEvent
 */

CtkFocusEventType ctk_focusable_get_event_type (ClutterKeyEvent   *event,
                                                CtkFocusDirection *direction);

G_END_DECLS

#endif /* __CTK_FOCUSABLE_H__ */
