/*
 * Copyright 2009 Canonical Ltd.
 * 
 * This program is free software: you can redistribute it and/or modify it 
 * under the terms of either or both of the following licenses:
 *
 * 1) the GNU Lesser General Public License version 3, as published by the 
 * Free Software Foundation; and/or
 * 2) the GNU Lesser General Public License version 2.1, as published by 
 * the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranties of 
 * MERCHANTABILITY, SATISFACTORY QUALITY or FITNESS FOR A PARTICULAR 
 * PURPOSE.  See the applicable version of the GNU Lesser General Public 
 * License for more details.
 * 
 * You should have received a copy of both the GNU Lesser General Public 
 * License version 3 and version 2.1 along with this program.  If not, see 
 * <http://www.gnu.org/licenses/>
 *
 * Authored by: Neil Jagdish Patel <neil.patel@canonical.com>
 *
 */

#ifndef _CTK_ACTOR_H_
#define _CTK_ACTOR_H_

#include <glib.h>
#include <clutter-gtk/clutter-gtk.h>
#include <clutk/ctk-effect.h>
#include <clutk/ctk-types.h>

G_BEGIN_DECLS

#define CTK_TYPE_ACTOR (ctk_actor_get_type ())

#define CTK_ACTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj),\
	CTK_TYPE_ACTOR, CtkActor))

#define CTK_ACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass),\
	CTK_TYPE_ACTOR, CtkActorClass))

#define CTK_IS_ACTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj),\
	CTK_TYPE_ACTOR))

#define CTK_IS_ACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass),\
	CTK_TYPE_ACTOR))

#define CTK_ACTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj),\
	CTK_TYPE_ACTOR, CtkActorClass))

typedef struct _CtkActor        CtkActor;
typedef struct _CtkActorClass   CtkActorClass;
typedef struct _CtkActorPrivate CtkActorPrivate;

struct _CtkActor
{
  ClutterActor parent;	

  CtkActorPrivate *priv;
};

struct _CtkActorClass
{
  /*< private >*/
  ClutterActorClass  parent_class;

  /*< public >*/
  /* signals, not vfuncs */
  void (*child_focus_changed) (CtkActor *actor, ClutterActorBox *box);
  void (*drag_leave) (CtkActor *actor, GdkDragContext *context, guint time_);
  void (*drag_begin) (CtkActor *actor, GdkDragContext *context);
  void (*drag_end) (CtkActor *actor, GdkDragContext *context);
  void (*drag_data_delete) (CtkActor *actor, GdkDragContext *context);
  void (*drag_failed) (CtkActor *actor, GdkDragContext *context, GtkDragResult result);
  void (*drag_motion) (CtkActor *actor, GdkDragContext *context, gint x, gint y, guint time_);
  void (*drag_drop) (CtkActor *actor, GdkDragContext *context, gint x, gint y, guint time_);
  void (*drag_data_get) (CtkActor *actor, GdkDragContext *context, GtkSelectionData *data, guint info, guint time_);
  void (*drag_data_received) (CtkActor *actor, GdkDragContext *context, gint x, gint y, GtkSelectionData *data, guint info, guint time_);
  /* vtable */

  /*< private >*/
  /* padding */
  /*void (*_ctk_padding1) (void); Restore when we break ABI again */
  void (*_ctk_padding2) (void);
  void (*_ctk_padding3) (void);
  void (*_ctk_padding4) (void);
  void (*_ctk_padding5) (void);
  void (*_ctk_padding6) (void);
};

GType ctk_actor_get_type (void) G_GNUC_CONST;

void             ctk_actor_set_state                (CtkActor     *actor,
                                                     CtkActorState state);

CtkActorState    ctk_actor_get_state                (CtkActor     *actor);

void             ctk_actor_set_padding              (CtkActor    *actor, 
                                                     CtkPadding  *padding);

void             ctk_actor_get_padding              (CtkActor    *actor, 
                                                     CtkPadding  *padding);

GtkTextDirection ctk_actor_get_default_direction    (void);

void             ctk_actor_set_default_direction    (GtkTextDirection  dir);

void             ctk_actor_set_background           (CtkActor     *actor,
                                                     ClutterActor *bg);

ClutterActor   * ctk_actor_get_background           (CtkActor     *actor);

void             ctk_actor_set_background_for_state (CtkActor     *actor,
                                                     CtkActorState state,
                                                     ClutterActor *bg);

ClutterActor   * ctk_actor_get_background_for_state (CtkActor     *actor,
                                                     CtkActorState state);
void             ctk_actor_set_tooltip_text         (CtkActor     *actor,
                                                     const gchar  *self);

const gchar    * ctk_actor_get_tooltip_text         (CtkActor     *actor);

void             ctk_actor_add_effect               (CtkActor     *actor,
                                                     CtkEffect    *effect);

void             ctk_actor_remove_effect            (CtkActor     *actor,
                                                     CtkEffect    *effect);

void             ctk_actor_remove_all_effects       (CtkActor     *actor);

GSList         * ctk_actor_get_effects              (CtkActor     *actor);

void             ctk_actor_set_effects_painting     (CtkActor     *actor,
                                                     gboolean      painting);

gboolean         ctk_actor_get_effects_painting     (CtkActor     *actor);

void             ctk_actor_set_damaged              (CtkActor     *actor,
						     gboolean     damaged);

gboolean         ctk_actor_get_damaged              (CtkActor     *actor);

void             ctk_actor_get_stored_allocation    (CtkActor *actor, 
						     ClutterActorBox* box);

void             ctk_actor_recurse_get_stored_allocation_box(CtkActor *actor,
                 ClutterActorBox* box);

G_END_DECLS

#endif /* _CTK_ACTOR_H_ */

