# Copyright (C) 2005 by Aaron Bentley

# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
from bzrlib.option import Option
from bzrlib.workingtree import WorkingTree
import sys
import os
import bzrtools

from command import BzrToolsCommand

class cmd_rspush(BzrToolsCommand):
    """Upload this branch to another location using rsync.

    If no location is specified, the last-used location will be used.  To
    prevent dirty trees from being uploaded, rspush will error out if there are
    unknown files or local changes.  It will also error out if the upstream
    directory is non-empty and not an earlier version of the branch.
    """
    takes_args = ['location?']
    takes_options = [Option('overwrite', help='Ignore differences between'
                            ' branches and overwrite unconditionally'),
                     Option('no-tree', help='Do not push the working tree,'
                            ' just the .bzr.')]

    def run(self, location=None, overwrite=False, no_tree=False):
        cur_branch = WorkingTree.open_containing(".")[0]
        bzrtools.rspush(cur_branch, location, overwrite=overwrite,
                      working_tree=not no_tree)
