// -*- C++ -*-

#include <deque>

#include <qsplitter.h>
#include <qwidgetstack.h>

#include <adept/lister.h>
#include <adept/filterlist.h>

#ifndef EPT_VIEW_H
#define EPT_VIEW_H

class QSplitter;

namespace adept {

class FilterSidebar;
class PackageDetails;

class View: public QSplitter, public Lister::RangeProvider {
    Q_OBJECT
public:
    View( QWidget *p = 0, const char *n = 0 );
    FilterList *filterList() { return m_flist; }
    Lister *lister() { return m_lister; }
    virtual Lister::Range listerRange();
public slots:
    void cleanRebuild() { m_lister->cleanRebuild(); }
    void hideFilters();
    void hideTags();
    void setPreviewMode();
    void setUpgradeMode();
protected slots:
    void delayed();
protected:
    predicate::Predicate< entity::Entity > previewPredicate();
    QSplitter *m_bottom;
    FilterList *m_flist;
    Lister *m_lister;
    FilterSidebar *m_sidebar;
};

class Browser : public QWidgetStack {
    Q_OBJECT
public:
    Browser( QWidget *p = 0, const char *n = 0 );
    View *searchView() const { return m_view; }
public slots:
    void forward();
    void back();
    void show( Lister::Entity e );
    void showList();
    void doShow( Lister::Entity e );
protected:
    typedef std::deque< Lister::Entity > Deque;
    Deque m_forward, m_back;
    entity::Entity m_current;
    View *m_view;
    PackageDetails *m_details;
    bool m_currentValid;
};

}

#endif
