(* Warning! This file is generated. Modify at your own risk. *)

(** Service definition for Google Analytics API (v3).
  
  View and manage your Google Analytics data.
  
  For more information about this service, see the
  {{:https://developers.google.com/analytics/}API Documentation}.
  *)

module Scope :
sig
  val analytics : string
  (** View and manage your Google Analytics data *)
  
  val analytics_readonly : string
  (** View your Google Analytics data *)
  
  
end
(** Service Auth Scopes *)

module DataResource :
sig
  module Realtime :
  sig
    
    (** Returns real time data for a view (profile).
      
      @param base_url Service endpoint base URL (defaults to ["https://www.googleapis.com/analytics/v3/"]).
      @param etag Optional ETag.
      @param std_params Optional standard parameters.
      @param dimensions A comma-separated list of real time dimensions. E.g., 'ga:medium,ga:city'.
      @param filters A comma-separated list of dimension or metric filters to be applied to real time data.
      @param max_results The maximum number of entries to include in this feed.
      @param sort A comma-separated list of dimensions or metrics that determine the sort order for real time data.
      @param ids Unique table ID for retrieving real time data. Table ID is of the form ga:XXXX, where XXXX is the Analytics view (profile) ID.
      @param metrics A comma-separated list of real time metrics. E.g., 'ga:activeVisitors'. At least one metric must be specified.
      *)
    val get :
      ?base_url:string ->
      ?etag:string ->
      ?std_params:GapiService.StandardParameters.t ->
      ?dimensions:string ->
      ?filters:string ->
      ?max_results:int ->
      ?sort:string ->
      ids:string ->
      metrics:string ->
      GapiConversation.Session.t ->
      GapiAnalyticsV3Model.RealtimeData.t * GapiConversation.Session.t
    
    
  end
  
  module Mcf :
  sig
    
    (** Returns Analytics Multi-Channel Funnels data for a view (profile).
      
      @param base_url Service endpoint base URL (defaults to ["https://www.googleapis.com/analytics/v3/"]).
      @param etag Optional ETag.
      @param std_params Optional standard parameters.
      @param dimensions A comma-separated list of Multi-Channel Funnels dimensions. E.g., 'mcf:source,mcf:medium'.
      @param filters A comma-separated list of dimension or metric filters to be applied to the Analytics data.
      @param max_results The maximum number of entries to include in this feed.
      @param sort A comma-separated list of dimensions or metrics that determine the sort order for the Analytics data.
      @param start_index An index of the first entity to retrieve. Use this parameter as a pagination mechanism along with the max-results parameter.
      @param ids Unique table ID for retrieving Analytics data. Table ID is of the form ga:XXXX, where XXXX is the Analytics view (profile) ID.
      @param start_date Start date for fetching Analytics data. All requests should specify a start date formatted as YYYY-MM-DD.
      @param end_date End date for fetching Analytics data. All requests should specify an end date formatted as YYYY-MM-DD.
      @param metrics A comma-separated list of Multi-Channel Funnels metrics. E.g., 'mcf:totalConversions,mcf:totalConversionValue'. At least one metric must be specified.
      *)
    val get :
      ?base_url:string ->
      ?etag:string ->
      ?std_params:GapiService.StandardParameters.t ->
      ?dimensions:string ->
      ?filters:string ->
      ?max_results:int ->
      ?sort:string ->
      ?start_index:int ->
      ids:string ->
      start_date:string ->
      end_date:string ->
      metrics:string ->
      GapiConversation.Session.t ->
      GapiAnalyticsV3Model.McfData.t * GapiConversation.Session.t
    
    
  end
  
  module Ga :
  sig
    
    (** Returns Analytics data for a view (profile).
      
      @param base_url Service endpoint base URL (defaults to ["https://www.googleapis.com/analytics/v3/"]).
      @param etag Optional ETag.
      @param std_params Optional standard parameters.
      @param dimensions A comma-separated list of Analytics dimensions. E.g., 'ga:browser,ga:city'.
      @param filters A comma-separated list of dimension or metric filters to be applied to Analytics data.
      @param max_results The maximum number of entries to include in this feed.
      @param segment An Analytics advanced segment to be applied to data.
      @param sort A comma-separated list of dimensions or metrics that determine the sort order for Analytics data.
      @param start_index An index of the first entity to retrieve. Use this parameter as a pagination mechanism along with the max-results parameter.
      @param ids Unique table ID for retrieving Analytics data. Table ID is of the form ga:XXXX, where XXXX is the Analytics view (profile) ID.
      @param start_date Start date for fetching Analytics data. All requests should specify a start date formatted as YYYY-MM-DD.
      @param end_date End date for fetching Analytics data. All requests should specify an end date formatted as YYYY-MM-DD.
      @param metrics A comma-separated list of Analytics metrics. E.g., 'ga:visits,ga:pageviews'. At least one metric must be specified.
      *)
    val get :
      ?base_url:string ->
      ?etag:string ->
      ?std_params:GapiService.StandardParameters.t ->
      ?dimensions:string ->
      ?filters:string ->
      ?max_results:int ->
      ?segment:string ->
      ?sort:string ->
      ?start_index:int ->
      ids:string ->
      start_date:string ->
      end_date:string ->
      metrics:string ->
      GapiConversation.Session.t ->
      GapiAnalyticsV3Model.GaData.t * GapiConversation.Session.t
    
    
  end
  
  
  
end

module ManagementResource :
sig
  module Webproperties :
  sig
    
    (** Lists web properties to which the user has access.
      
      @param base_url Service endpoint base URL (defaults to ["https://www.googleapis.com/analytics/v3/"]).
      @param std_params Optional standard parameters.
      @param max_results The maximum number of web properties to include in this response.
      @param start_index An index of the first entity to retrieve. Use this parameter as a pagination mechanism along with the max-results parameter.
      @param accountId Account ID to retrieve web properties for. Can either be a specific account ID or '~all', which refers to all the accounts that user has access to.
      *)
    val list :
      ?base_url:string ->
      ?std_params:GapiService.StandardParameters.t ->
      ?max_results:int ->
      ?start_index:int ->
      accountId:string ->
      GapiConversation.Session.t ->
      GapiAnalyticsV3Model.Webproperties.t * GapiConversation.Session.t
    
    
  end
  
  module Segments :
  sig
    
    (** Lists advanced segments to which the user has access.
      
      @param base_url Service endpoint base URL (defaults to ["https://www.googleapis.com/analytics/v3/"]).
      @param std_params Optional standard parameters.
      @param max_results The maximum number of advanced segments to include in this response.
      @param start_index An index of the first advanced segment to retrieve. Use this parameter as a pagination mechanism along with the max-results parameter.
      *)
    val list :
      ?base_url:string ->
      ?std_params:GapiService.StandardParameters.t ->
      ?max_results:int ->
      ?start_index:int ->
      GapiConversation.Session.t ->
      GapiAnalyticsV3Model.Segments.t * GapiConversation.Session.t
    
    
  end
  
  module Profiles :
  sig
    
    (** Lists views (profiles) to which the user has access.
      
      @param base_url Service endpoint base URL (defaults to ["https://www.googleapis.com/analytics/v3/"]).
      @param std_params Optional standard parameters.
      @param max_results The maximum number of views (profiles) to include in this response.
      @param start_index An index of the first entity to retrieve. Use this parameter as a pagination mechanism along with the max-results parameter.
      @param accountId Account ID for the view (profiles) to retrieve. Can either be a specific account ID or '~all', which refers to all the accounts to which the user has access.
      @param webPropertyId Web property ID for the views (profiles) to retrieve. Can either be a specific web property ID or '~all', which refers to all the web properties to which the user has access.
      *)
    val list :
      ?base_url:string ->
      ?std_params:GapiService.StandardParameters.t ->
      ?max_results:int ->
      ?start_index:int ->
      accountId:string ->
      webPropertyId:string ->
      GapiConversation.Session.t ->
      GapiAnalyticsV3Model.Profiles.t * GapiConversation.Session.t
    
    
  end
  
  module Goals :
  sig
    
    (** Lists goals to which the user has access.
      
      @param base_url Service endpoint base URL (defaults to ["https://www.googleapis.com/analytics/v3/"]).
      @param std_params Optional standard parameters.
      @param max_results The maximum number of goals to include in this response.
      @param start_index An index of the first goal to retrieve. Use this parameter as a pagination mechanism along with the max-results parameter.
      @param accountId Account ID to retrieve goals for. Can either be a specific account ID or '~all', which refers to all the accounts that user has access to.
      @param webPropertyId Web property ID to retrieve goals for. Can either be a specific web property ID or '~all', which refers to all the web properties that user has access to.
      @param profileId View (Profile) ID to retrieve goals for. Can either be a specific view (profile) ID or '~all', which refers to all the views (profiles) that user has access to.
      *)
    val list :
      ?base_url:string ->
      ?std_params:GapiService.StandardParameters.t ->
      ?max_results:int ->
      ?start_index:int ->
      accountId:string ->
      webPropertyId:string ->
      profileId:string ->
      GapiConversation.Session.t ->
      GapiAnalyticsV3Model.Goals.t * GapiConversation.Session.t
    
    
  end
  
  module Experiments :
  sig
    
    (** Delete an experiment.
      
      @param base_url Service endpoint base URL (defaults to ["https://www.googleapis.com/analytics/v3/"]).
      @param std_params Optional standard parameters.
      @param accountId Account ID to which the experiment belongs
      @param webPropertyId Web property ID to which the experiment belongs
      @param profileId View (Profile) ID to which the experiment belongs
      @param experimentId ID of the experiment to delete
      *)
    val delete :
      ?base_url:string ->
      ?std_params:GapiService.StandardParameters.t ->
      accountId:string ->
      webPropertyId:string ->
      profileId:string ->
      experimentId:string ->
      GapiConversation.Session.t ->
      unit * GapiConversation.Session.t
    
    (** Returns an experiment to which the user has access.
      
      @param base_url Service endpoint base URL (defaults to ["https://www.googleapis.com/analytics/v3/"]).
      @param etag Optional ETag.
      @param std_params Optional standard parameters.
      @param accountId Account ID to retrieve the experiment for.
      @param webPropertyId Web property ID to retrieve the experiment for.
      @param profileId View (Profile) ID to retrieve the experiment for.
      @param experimentId Experiment ID to retrieve the experiment for.
      *)
    val get :
      ?base_url:string ->
      ?etag:string ->
      ?std_params:GapiService.StandardParameters.t ->
      accountId:string ->
      webPropertyId:string ->
      profileId:string ->
      experimentId:string ->
      GapiConversation.Session.t ->
      GapiAnalyticsV3Model.Experiment.t * GapiConversation.Session.t
    
    (** Create a new experiment.
      
      @param base_url Service endpoint base URL (defaults to ["https://www.googleapis.com/analytics/v3/"]).
      @param std_params Optional standard parameters.
      @param accountId Account ID to create the experiment for.
      @param webPropertyId Web property ID to create the experiment for.
      @param profileId View (Profile) ID to create the experiment for.
      *)
    val insert :
      ?base_url:string ->
      ?std_params:GapiService.StandardParameters.t ->
      accountId:string ->
      webPropertyId:string ->
      profileId:string ->
      GapiAnalyticsV3Model.Experiment.t ->
      GapiConversation.Session.t ->
      GapiAnalyticsV3Model.Experiment.t * GapiConversation.Session.t
    
    (** Lists experiments to which the user has access.
      
      @param base_url Service endpoint base URL (defaults to ["https://www.googleapis.com/analytics/v3/"]).
      @param std_params Optional standard parameters.
      @param max_results The maximum number of experiments to include in this response.
      @param start_index An index of the first experiment to retrieve. Use this parameter as a pagination mechanism along with the max-results parameter.
      @param accountId Account ID to retrieve experiments for.
      @param webPropertyId Web property ID to retrieve experiments for.
      @param profileId View (Profile) ID to retrieve experiments for.
      *)
    val list :
      ?base_url:string ->
      ?std_params:GapiService.StandardParameters.t ->
      ?max_results:int ->
      ?start_index:int ->
      accountId:string ->
      webPropertyId:string ->
      profileId:string ->
      GapiConversation.Session.t ->
      GapiAnalyticsV3Model.Experiments.t * GapiConversation.Session.t
    
    (** Update an existing experiment. This method supports patch semantics.
      
      @param base_url Service endpoint base URL (defaults to ["https://www.googleapis.com/analytics/v3/"]).
      @param std_params Optional standard parameters.
      @param accountId Account ID of the experiment to update.
      @param webPropertyId Web property ID of the experiment to update.
      @param profileId View (Profile) ID of the experiment to update.
      @param experimentId Experiment ID of the experiment to update.
      *)
    val patch :
      ?base_url:string ->
      ?std_params:GapiService.StandardParameters.t ->
      accountId:string ->
      webPropertyId:string ->
      profileId:string ->
      experimentId:string ->
      GapiAnalyticsV3Model.Experiment.t ->
      GapiConversation.Session.t ->
      GapiAnalyticsV3Model.Experiment.t * GapiConversation.Session.t
    
    (** Update an existing experiment.
      
      @param base_url Service endpoint base URL (defaults to ["https://www.googleapis.com/analytics/v3/"]).
      @param std_params Optional standard parameters.
      @param accountId Account ID of the experiment to update.
      @param webPropertyId Web property ID of the experiment to update.
      @param profileId View (Profile) ID of the experiment to update.
      @param experimentId Experiment ID of the experiment to update.
      *)
    val update :
      ?base_url:string ->
      ?std_params:GapiService.StandardParameters.t ->
      accountId:string ->
      webPropertyId:string ->
      profileId:string ->
      experimentId:string ->
      GapiAnalyticsV3Model.Experiment.t ->
      GapiConversation.Session.t ->
      GapiAnalyticsV3Model.Experiment.t * GapiConversation.Session.t
    
    
  end
  
  module DailyUploads :
  sig
    
    module Type :
    sig
      type t =
        | Default
        | Cost (** Value for specifying cost data upload. *)
        
      val to_string : t -> string
      
      val of_string : string -> t
      
    end
    
    (** Delete uploaded data for the given date.
      
      @param base_url Service endpoint base URL (defaults to ["https://www.googleapis.com/analytics/v3/"]).
      @param std_params Optional standard parameters.
      @param accountId Account Id associated with daily upload delete.
      @param webPropertyId Web property Id associated with daily upload delete.
      @param customDataSourceId Custom data source Id associated with daily upload delete.
      @param date Date for which data is to be deleted. Date should be formatted as YYYY-MM-DD.
      @param _type Type of data for this delete.
      *)
    val delete :
      ?base_url:string ->
      ?std_params:GapiService.StandardParameters.t ->
      accountId:string ->
      webPropertyId:string ->
      customDataSourceId:string ->
      date:string ->
      _type:Type.t ->
      GapiConversation.Session.t ->
      unit * GapiConversation.Session.t
    
    (** List daily uploads to which the user has access.
      
      @param base_url Service endpoint base URL (defaults to ["https://www.googleapis.com/analytics/v3/"]).
      @param std_params Optional standard parameters.
      @param max_results The maximum number of custom data sources to include in this response.
      @param start_index A 1-based index of the first daily upload to retrieve. Use this parameter as a pagination mechanism along with the max-results parameter.
      @param accountId Account Id for the daily uploads to retrieve.
      @param webPropertyId Web property Id for the daily uploads to retrieve.
      @param customDataSourceId Custom data source Id for daily uploads to retrieve.
      @param start_date Start date of the form YYYY-MM-DD.
      @param end_date End date of the form YYYY-MM-DD.
      *)
    val list :
      ?base_url:string ->
      ?std_params:GapiService.StandardParameters.t ->
      ?max_results:int ->
      ?start_index:int ->
      accountId:string ->
      webPropertyId:string ->
      customDataSourceId:string ->
      start_date:string ->
      end_date:string ->
      GapiConversation.Session.t ->
      GapiAnalyticsV3Model.DailyUploads.t * GapiConversation.Session.t
    
    (** Update/Overwrite data for a custom data source.
      
      @param base_url Service endpoint base URL (defaults to ["https://www.googleapis.com/analytics/v3/"]).
      @param std_params Optional standard parameters.
      @param reset Reset/Overwrite all previous appends for this date and start over with this file as the first upload.
      @param accountId Account Id associated with daily upload.
      @param webPropertyId Web property Id associated with daily upload.
      @param customDataSourceId Custom data source Id to which the data being uploaded belongs.
      @param date Date for which data is uploaded. Date should be formatted as YYYY-MM-DD.
      @param appendNumber Append number for this upload indexed from 1.
      @param _type Type of data for this upload.
      *)
    val upload :
      ?base_url:string ->
      ?std_params:GapiService.StandardParameters.t ->
      ?media_source:GapiMediaResource.t ->
      ?reset:bool ->
      accountId:string ->
      webPropertyId:string ->
      customDataSourceId:string ->
      date:string ->
      appendNumber:int ->
      _type:Type.t ->
      GapiConversation.Session.t ->
      GapiAnalyticsV3Model.DailyUploadAppend.t * GapiConversation.Session.t
    
    
  end
  
  module CustomDataSources :
  sig
    
    (** List custom data sources to which the user has access.
      
      @param base_url Service endpoint base URL (defaults to ["https://www.googleapis.com/analytics/v3/"]).
      @param std_params Optional standard parameters.
      @param max_results The maximum number of custom data sources to include in this response.
      @param start_index A 1-based index of the first custom data source to retrieve. Use this parameter as a pagination mechanism along with the max-results parameter.
      @param accountId Account Id for the custom data sources to retrieve.
      @param webPropertyId Web property Id for the custom data sources to retrieve.
      *)
    val list :
      ?base_url:string ->
      ?std_params:GapiService.StandardParameters.t ->
      ?max_results:int ->
      ?start_index:int ->
      accountId:string ->
      webPropertyId:string ->
      GapiConversation.Session.t ->
      GapiAnalyticsV3Model.CustomDataSources.t * GapiConversation.Session.t
    
    
  end
  
  module Accounts :
  sig
    
    (** Lists all accounts to which the user has access.
      
      @param base_url Service endpoint base URL (defaults to ["https://www.googleapis.com/analytics/v3/"]).
      @param std_params Optional standard parameters.
      @param max_results The maximum number of accounts to include in this response.
      @param start_index An index of the first account to retrieve. Use this parameter as a pagination mechanism along with the max-results parameter.
      *)
    val list :
      ?base_url:string ->
      ?std_params:GapiService.StandardParameters.t ->
      ?max_results:int ->
      ?start_index:int ->
      GapiConversation.Session.t ->
      GapiAnalyticsV3Model.Accounts.t * GapiConversation.Session.t
    
    
  end
  
  
  
end

module MetadataResource :
sig
  module Columns :
  sig
    
    (** Lists all columns for a report type
      
      @param base_url Service endpoint base URL (defaults to ["https://www.googleapis.com/analytics/v3/"]).
      @param std_params Optional standard parameters.
      @param reportType Report type. Allowed Values: 'ga'. Where 'ga' corresponds to the Core Reporting API
      *)
    val list :
      ?base_url:string ->
      ?std_params:GapiService.StandardParameters.t ->
      reportType:string ->
      GapiConversation.Session.t ->
      GapiAnalyticsV3Model.Columns.t * GapiConversation.Session.t
    
    
  end
  
  
  
end


