#!/bin/bash
# Steven Shiau <steven _at_ nchc org tw>
# License: GPL
# Des: download the syslinux and extract the necessary program for DRBL.
# The reason we do not use syslinux rpm/deb is that it's not easy to make
# all distribution works, otherwise you have to use the statically link program.
# I am lazy... do not want to compile it everytime.
MEMTEST86_URL="http://www.memtest.org/download/"

usage() {
  echo "Usage: $0 VERSION"
  echo "Ex: $0 1.60"
}

ver="$1"
[ -z "$ver" ] && usage && exit 1
[ ! -d "memtest86+" ] && mkdir -p memtest86+
wd=`pwd`
memfile="memtest86+-${ver}.bin"
tmp_wd="$(mktemp -d /tmp/memtest_tmp.XXXXXXX)"
cd $tmp_wd 
wget $MEMTEST86_URL/$ver/$memfile
cp -afv $memfile $wd/memtest86+/memtest86
echo $ver > $wd/memtest86+/VERSION
[ -d "$tmp_wd" -a -n "$(echo $tmp_wd | grep "memtest_tmp" )" ] && rm -rf $tmp_wd
