#!/bin/sh
### BEGIN INIT INFO
# Provides:		kdump
# Required-Start:	$local_fs
# Required-Stop:	$local_fs
# Should-Start:
# Should-Stop:
# Default-Start:	0 1 2 3 4 5
# Default-Stop:		6
# Short-Description: Load crashkernel image with kexec
# Description:
### END INIT INFO

PATH=/usr/sbin:/usr/bin:/sbin:/bin

. /lib/lsb/init-functions

KVER="`uname -r`"
KERNEL_IMAGE="/boot/vmlinuz-$KVER"
INITRD="/boot/initrd.img-$KVER"

# Without makedumpfile, there will be no vmcore on crash, so no point
test -x /usr/bin/makedumpfile || exit 0
if [ ! -e "$KERNEL_IMAGE" -o ! -e "$INITRD" ]; then
	exit 0;
fi


do_start () {
	test -x /sbin/kexec || exit 0

	# We have to be booted with crashkernel= to work. See
	# /boot/grub/menu.lst
	grep -q crashkernel= /proc/cmdline || exit 0

	# Remove crashkernel, vga, video and splash options
	APPEND=""
	for x in `cat /proc/cmdline`; do
		case $x in
			splash*|vga*|video*|crashkernel*|quiet)
				;;
			*)
				APPEND="$APPEND $x"
				;;
		esac
	done

	# Append kdump_needed for initramfs to know what to do, and add
	# maxcpus=1 to keep things sane.
	APPEND="$APPEND kdump_needed maxcpus=1 irqpoll reset_devices"

	# --elf32-core-headers is needed for 32-bit systems (ok
	# for 64-bit ones too).
	log_action_begin_msg "Loading crashkernel"
	kexec -p "$KERNEL_IMAGE" --initrd="$INITRD" --append="$APPEND"
	log_action_end_msg $?
}

run_apport_on_vmcore()
{
    if [ -e /var/crash/vmcore -a -x /usr/share/apport/kernel_crashdump ]; then
	/usr/share/apport/kernel_crashdump || true
    fi
}

case "$1" in
  start)
	run_apport_on_vmcore
	do_start
	;;
  restart|reload|force-reload)
	echo "Error: argument '$1' not supported" >&2
	exit 3
	;;
  stop)
	# No-op
	;;
  *)
	echo "Usage: $0 start|stop" >&2
	exit 3
	;;
esac
exit 0
