/* server functions auto-generated by pidl */
#include "librpc/gen_ndr/ndr_svcctl.h"

/* svcctl - dcerpc server boilerplate generated by pidl */


static NTSTATUS svcctl__op_bind(struct dcesrv_call_state *dce_call, const struct dcesrv_interface *iface, uint32_t if_version)
{
#ifdef DCESRV_INTERFACE_SVCCTL_BIND
	return DCESRV_INTERFACE_SVCCTL_BIND(dce_call,iface);
#else
	return NT_STATUS_OK;
#endif
}

static void svcctl__op_unbind(struct dcesrv_connection_context *context, const struct dcesrv_interface *iface)
{
#ifdef DCESRV_INTERFACE_SVCCTL_UNBIND
	DCESRV_INTERFACE_SVCCTL_UNBIND(context, iface);
#else
	return;
#endif
}

static NTSTATUS svcctl__op_ndr_pull(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, struct ndr_pull *pull, void **r)
{
	enum ndr_err_code ndr_err;
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	dce_call->fault_code = 0;

	if (opnum >= ndr_table_svcctl.num_calls) {
		dce_call->fault_code = DCERPC_FAULT_OP_RNG_ERROR;
		return NT_STATUS_NET_WRITE_FAULT;
	}

	*r = talloc_named(mem_ctx,
			  ndr_table_svcctl.calls[opnum].struct_size,
			  "struct %s",
			  ndr_table_svcctl.calls[opnum].name);
	NT_STATUS_HAVE_NO_MEMORY(*r);

        /* unravel the NDR for the packet */
	ndr_err = ndr_table_svcctl.calls[opnum].ndr_pull(pull, NDR_IN, *r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		dcerpc_log_packet(dce_call->conn->packet_log_dir, 
				  &ndr_table_svcctl, opnum, NDR_IN,
				  &dce_call->pkt.u.request.stub_and_verifier);
		dce_call->fault_code = DCERPC_FAULT_NDR;
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

static NTSTATUS svcctl__op_dispatch(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, void *r)
{
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	switch (opnum) {
	case 0: {
		struct svcctl_CloseServiceHandle *r2 = (struct svcctl_CloseServiceHandle *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_CloseServiceHandle, NDR_IN, r2);
		}
		r2->out.result = dcesrv_svcctl_CloseServiceHandle(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function svcctl_CloseServiceHandle will reply async\n"));
		}
		break;
	}
	case 1: {
		struct svcctl_ControlService *r2 = (struct svcctl_ControlService *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_ControlService, NDR_IN, r2);
		}
		r2->out.result = dcesrv_svcctl_ControlService(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function svcctl_ControlService will reply async\n"));
		}
		break;
	}
	case 2: {
		struct svcctl_DeleteService *r2 = (struct svcctl_DeleteService *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_DeleteService, NDR_IN, r2);
		}
		r2->out.result = dcesrv_svcctl_DeleteService(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function svcctl_DeleteService will reply async\n"));
		}
		break;
	}
	case 3: {
		struct svcctl_LockServiceDatabase *r2 = (struct svcctl_LockServiceDatabase *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_LockServiceDatabase, NDR_IN, r2);
		}
		r2->out.result = dcesrv_svcctl_LockServiceDatabase(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function svcctl_LockServiceDatabase will reply async\n"));
		}
		break;
	}
	case 4: {
		struct svcctl_QueryServiceObjectSecurity *r2 = (struct svcctl_QueryServiceObjectSecurity *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_QueryServiceObjectSecurity, NDR_IN, r2);
		}
		r2->out.result = dcesrv_svcctl_QueryServiceObjectSecurity(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function svcctl_QueryServiceObjectSecurity will reply async\n"));
		}
		break;
	}
	case 5: {
		struct svcctl_SetServiceObjectSecurity *r2 = (struct svcctl_SetServiceObjectSecurity *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_SetServiceObjectSecurity, NDR_IN, r2);
		}
		r2->out.result = dcesrv_svcctl_SetServiceObjectSecurity(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function svcctl_SetServiceObjectSecurity will reply async\n"));
		}
		break;
	}
	case 6: {
		struct svcctl_QueryServiceStatus *r2 = (struct svcctl_QueryServiceStatus *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_QueryServiceStatus, NDR_IN, r2);
		}
		r2->out.result = dcesrv_svcctl_QueryServiceStatus(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function svcctl_QueryServiceStatus will reply async\n"));
		}
		break;
	}
	case 7: {
		struct svcctl_SetServiceStatus *r2 = (struct svcctl_SetServiceStatus *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_SetServiceStatus, NDR_IN, r2);
		}
		r2->out.result = dcesrv_svcctl_SetServiceStatus(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function svcctl_SetServiceStatus will reply async\n"));
		}
		break;
	}
	case 8: {
		struct svcctl_UnlockServiceDatabase *r2 = (struct svcctl_UnlockServiceDatabase *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_UnlockServiceDatabase, NDR_IN, r2);
		}
		r2->out.result = dcesrv_svcctl_UnlockServiceDatabase(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function svcctl_UnlockServiceDatabase will reply async\n"));
		}
		break;
	}
	case 9: {
		struct svcctl_NotifyBootConfigStatus *r2 = (struct svcctl_NotifyBootConfigStatus *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_NotifyBootConfigStatus, NDR_IN, r2);
		}
		r2->out.result = dcesrv_svcctl_NotifyBootConfigStatus(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function svcctl_NotifyBootConfigStatus will reply async\n"));
		}
		break;
	}
	case 10: {
		struct svcctl_SCSetServiceBitsW *r2 = (struct svcctl_SCSetServiceBitsW *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_SCSetServiceBitsW, NDR_IN, r2);
		}
		r2->out.result = dcesrv_svcctl_SCSetServiceBitsW(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function svcctl_SCSetServiceBitsW will reply async\n"));
		}
		break;
	}
	case 11: {
		struct svcctl_ChangeServiceConfigW *r2 = (struct svcctl_ChangeServiceConfigW *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_ChangeServiceConfigW, NDR_IN, r2);
		}
		r2->out.result = dcesrv_svcctl_ChangeServiceConfigW(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function svcctl_ChangeServiceConfigW will reply async\n"));
		}
		break;
	}
	case 12: {
		struct svcctl_CreateServiceW *r2 = (struct svcctl_CreateServiceW *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_CreateServiceW, NDR_IN, r2);
		}
		r2->out.result = dcesrv_svcctl_CreateServiceW(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function svcctl_CreateServiceW will reply async\n"));
		}
		break;
	}
	case 13: {
		struct svcctl_EnumDependentServicesW *r2 = (struct svcctl_EnumDependentServicesW *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_EnumDependentServicesW, NDR_IN, r2);
		}
		r2->out.result = dcesrv_svcctl_EnumDependentServicesW(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function svcctl_EnumDependentServicesW will reply async\n"));
		}
		break;
	}
	case 14: {
		struct svcctl_EnumServicesStatusW *r2 = (struct svcctl_EnumServicesStatusW *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_EnumServicesStatusW, NDR_IN, r2);
		}
		r2->out.result = dcesrv_svcctl_EnumServicesStatusW(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function svcctl_EnumServicesStatusW will reply async\n"));
		}
		break;
	}
	case 15: {
		struct svcctl_OpenSCManagerW *r2 = (struct svcctl_OpenSCManagerW *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_OpenSCManagerW, NDR_IN, r2);
		}
		r2->out.result = dcesrv_svcctl_OpenSCManagerW(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function svcctl_OpenSCManagerW will reply async\n"));
		}
		break;
	}
	case 16: {
		struct svcctl_OpenServiceW *r2 = (struct svcctl_OpenServiceW *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_OpenServiceW, NDR_IN, r2);
		}
		r2->out.result = dcesrv_svcctl_OpenServiceW(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function svcctl_OpenServiceW will reply async\n"));
		}
		break;
	}
	case 17: {
		struct svcctl_QueryServiceConfigW *r2 = (struct svcctl_QueryServiceConfigW *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_QueryServiceConfigW, NDR_IN, r2);
		}
		r2->out.result = dcesrv_svcctl_QueryServiceConfigW(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function svcctl_QueryServiceConfigW will reply async\n"));
		}
		break;
	}
	case 18: {
		struct svcctl_QueryServiceLockStatusW *r2 = (struct svcctl_QueryServiceLockStatusW *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_QueryServiceLockStatusW, NDR_IN, r2);
		}
		r2->out.result = dcesrv_svcctl_QueryServiceLockStatusW(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function svcctl_QueryServiceLockStatusW will reply async\n"));
		}
		break;
	}
	case 19: {
		struct svcctl_StartServiceW *r2 = (struct svcctl_StartServiceW *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_StartServiceW, NDR_IN, r2);
		}
		r2->out.result = dcesrv_svcctl_StartServiceW(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function svcctl_StartServiceW will reply async\n"));
		}
		break;
	}
	case 20: {
		struct svcctl_GetServiceDisplayNameW *r2 = (struct svcctl_GetServiceDisplayNameW *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_GetServiceDisplayNameW, NDR_IN, r2);
		}
		r2->out.result = dcesrv_svcctl_GetServiceDisplayNameW(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function svcctl_GetServiceDisplayNameW will reply async\n"));
		}
		break;
	}
	case 21: {
		struct svcctl_GetServiceKeyNameW *r2 = (struct svcctl_GetServiceKeyNameW *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_GetServiceKeyNameW, NDR_IN, r2);
		}
		r2->out.result = dcesrv_svcctl_GetServiceKeyNameW(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function svcctl_GetServiceKeyNameW will reply async\n"));
		}
		break;
	}
	case 22: {
		struct svcctl_SCSetServiceBitsA *r2 = (struct svcctl_SCSetServiceBitsA *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_SCSetServiceBitsA, NDR_IN, r2);
		}
		r2->out.result = dcesrv_svcctl_SCSetServiceBitsA(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function svcctl_SCSetServiceBitsA will reply async\n"));
		}
		break;
	}
	case 23: {
		struct svcctl_ChangeServiceConfigA *r2 = (struct svcctl_ChangeServiceConfigA *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_ChangeServiceConfigA, NDR_IN, r2);
		}
		r2->out.result = dcesrv_svcctl_ChangeServiceConfigA(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function svcctl_ChangeServiceConfigA will reply async\n"));
		}
		break;
	}
	case 24: {
		struct svcctl_CreateServiceA *r2 = (struct svcctl_CreateServiceA *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_CreateServiceA, NDR_IN, r2);
		}
		r2->out.result = dcesrv_svcctl_CreateServiceA(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function svcctl_CreateServiceA will reply async\n"));
		}
		break;
	}
	case 25: {
		struct svcctl_EnumDependentServicesA *r2 = (struct svcctl_EnumDependentServicesA *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_EnumDependentServicesA, NDR_IN, r2);
		}
		r2->out.result = dcesrv_svcctl_EnumDependentServicesA(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function svcctl_EnumDependentServicesA will reply async\n"));
		}
		break;
	}
	case 26: {
		struct svcctl_EnumServicesStatusA *r2 = (struct svcctl_EnumServicesStatusA *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_EnumServicesStatusA, NDR_IN, r2);
		}
		r2->out.result = dcesrv_svcctl_EnumServicesStatusA(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function svcctl_EnumServicesStatusA will reply async\n"));
		}
		break;
	}
	case 27: {
		struct svcctl_OpenSCManagerA *r2 = (struct svcctl_OpenSCManagerA *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_OpenSCManagerA, NDR_IN, r2);
		}
		r2->out.result = dcesrv_svcctl_OpenSCManagerA(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function svcctl_OpenSCManagerA will reply async\n"));
		}
		break;
	}
	case 28: {
		struct svcctl_OpenServiceA *r2 = (struct svcctl_OpenServiceA *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_OpenServiceA, NDR_IN, r2);
		}
		r2->out.result = dcesrv_svcctl_OpenServiceA(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function svcctl_OpenServiceA will reply async\n"));
		}
		break;
	}
	case 29: {
		struct svcctl_QueryServiceConfigA *r2 = (struct svcctl_QueryServiceConfigA *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_QueryServiceConfigA, NDR_IN, r2);
		}
		r2->out.result = dcesrv_svcctl_QueryServiceConfigA(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function svcctl_QueryServiceConfigA will reply async\n"));
		}
		break;
	}
	case 30: {
		struct svcctl_QueryServiceLockStatusA *r2 = (struct svcctl_QueryServiceLockStatusA *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_QueryServiceLockStatusA, NDR_IN, r2);
		}
		r2->out.result = dcesrv_svcctl_QueryServiceLockStatusA(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function svcctl_QueryServiceLockStatusA will reply async\n"));
		}
		break;
	}
	case 31: {
		struct svcctl_StartServiceA *r2 = (struct svcctl_StartServiceA *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_StartServiceA, NDR_IN, r2);
		}
		r2->out.result = dcesrv_svcctl_StartServiceA(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function svcctl_StartServiceA will reply async\n"));
		}
		break;
	}
	case 32: {
		struct svcctl_GetServiceDisplayNameA *r2 = (struct svcctl_GetServiceDisplayNameA *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_GetServiceDisplayNameA, NDR_IN, r2);
		}
		r2->out.result = dcesrv_svcctl_GetServiceDisplayNameA(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function svcctl_GetServiceDisplayNameA will reply async\n"));
		}
		break;
	}
	case 33: {
		struct svcctl_GetServiceKeyNameA *r2 = (struct svcctl_GetServiceKeyNameA *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_GetServiceKeyNameA, NDR_IN, r2);
		}
		r2->out.result = dcesrv_svcctl_GetServiceKeyNameA(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function svcctl_GetServiceKeyNameA will reply async\n"));
		}
		break;
	}
	case 34: {
		struct svcctl_GetCurrentGroupeStateW *r2 = (struct svcctl_GetCurrentGroupeStateW *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_GetCurrentGroupeStateW, NDR_IN, r2);
		}
		r2->out.result = dcesrv_svcctl_GetCurrentGroupeStateW(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function svcctl_GetCurrentGroupeStateW will reply async\n"));
		}
		break;
	}
	case 35: {
		struct svcctl_EnumServiceGroupW *r2 = (struct svcctl_EnumServiceGroupW *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_EnumServiceGroupW, NDR_IN, r2);
		}
		r2->out.result = dcesrv_svcctl_EnumServiceGroupW(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function svcctl_EnumServiceGroupW will reply async\n"));
		}
		break;
	}
	case 36: {
		struct svcctl_ChangeServiceConfig2A *r2 = (struct svcctl_ChangeServiceConfig2A *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_ChangeServiceConfig2A, NDR_IN, r2);
		}
		r2->out.result = dcesrv_svcctl_ChangeServiceConfig2A(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function svcctl_ChangeServiceConfig2A will reply async\n"));
		}
		break;
	}
	case 37: {
		struct svcctl_ChangeServiceConfig2W *r2 = (struct svcctl_ChangeServiceConfig2W *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_ChangeServiceConfig2W, NDR_IN, r2);
		}
		r2->out.result = dcesrv_svcctl_ChangeServiceConfig2W(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function svcctl_ChangeServiceConfig2W will reply async\n"));
		}
		break;
	}
	case 38: {
		struct svcctl_QueryServiceConfig2A *r2 = (struct svcctl_QueryServiceConfig2A *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_QueryServiceConfig2A, NDR_IN, r2);
		}
		r2->out.result = dcesrv_svcctl_QueryServiceConfig2A(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function svcctl_QueryServiceConfig2A will reply async\n"));
		}
		break;
	}
	case 39: {
		struct svcctl_QueryServiceConfig2W *r2 = (struct svcctl_QueryServiceConfig2W *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_QueryServiceConfig2W, NDR_IN, r2);
		}
		r2->out.result = dcesrv_svcctl_QueryServiceConfig2W(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function svcctl_QueryServiceConfig2W will reply async\n"));
		}
		break;
	}
	case 40: {
		struct svcctl_QueryServiceStatusEx *r2 = (struct svcctl_QueryServiceStatusEx *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_QueryServiceStatusEx, NDR_IN, r2);
		}
		r2->out.result = dcesrv_svcctl_QueryServiceStatusEx(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function svcctl_QueryServiceStatusEx will reply async\n"));
		}
		break;
	}
	case 41: {
		struct EnumServicesStatusExA *r2 = (struct EnumServicesStatusExA *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(EnumServicesStatusExA, NDR_IN, r2);
		}
		r2->out.result = dcesrv_EnumServicesStatusExA(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function EnumServicesStatusExA will reply async\n"));
		}
		break;
	}
	case 42: {
		struct EnumServicesStatusExW *r2 = (struct EnumServicesStatusExW *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(EnumServicesStatusExW, NDR_IN, r2);
		}
		r2->out.result = dcesrv_EnumServicesStatusExW(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function EnumServicesStatusExW will reply async\n"));
		}
		break;
	}
	case 43: {
		struct svcctl_SCSendTSMessage *r2 = (struct svcctl_SCSendTSMessage *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_SCSendTSMessage, NDR_IN, r2);
		}
		r2->out.result = dcesrv_svcctl_SCSendTSMessage(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function svcctl_SCSendTSMessage will reply async\n"));
		}
		break;
	}

	default:
		dce_call->fault_code = DCERPC_FAULT_OP_RNG_ERROR;
		break;
	}

	if (dce_call->fault_code != 0) {
		dcerpc_log_packet(dce_call->conn->packet_log_dir, 
		          &ndr_table_svcctl, opnum, NDR_IN,
				  &dce_call->pkt.u.request.stub_and_verifier);
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

static NTSTATUS svcctl__op_reply(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, void *r)
{
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	switch (opnum) {
	case 0: {
		struct svcctl_CloseServiceHandle *r2 = (struct svcctl_CloseServiceHandle *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function svcctl_CloseServiceHandle replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_CloseServiceHandle, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in svcctl_CloseServiceHandle\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 1: {
		struct svcctl_ControlService *r2 = (struct svcctl_ControlService *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function svcctl_ControlService replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_ControlService, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in svcctl_ControlService\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 2: {
		struct svcctl_DeleteService *r2 = (struct svcctl_DeleteService *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function svcctl_DeleteService replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_DeleteService, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in svcctl_DeleteService\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 3: {
		struct svcctl_LockServiceDatabase *r2 = (struct svcctl_LockServiceDatabase *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function svcctl_LockServiceDatabase replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_LockServiceDatabase, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in svcctl_LockServiceDatabase\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 4: {
		struct svcctl_QueryServiceObjectSecurity *r2 = (struct svcctl_QueryServiceObjectSecurity *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function svcctl_QueryServiceObjectSecurity replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_QueryServiceObjectSecurity, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in svcctl_QueryServiceObjectSecurity\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 5: {
		struct svcctl_SetServiceObjectSecurity *r2 = (struct svcctl_SetServiceObjectSecurity *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function svcctl_SetServiceObjectSecurity replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_SetServiceObjectSecurity, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in svcctl_SetServiceObjectSecurity\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 6: {
		struct svcctl_QueryServiceStatus *r2 = (struct svcctl_QueryServiceStatus *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function svcctl_QueryServiceStatus replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_QueryServiceStatus, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in svcctl_QueryServiceStatus\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 7: {
		struct svcctl_SetServiceStatus *r2 = (struct svcctl_SetServiceStatus *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function svcctl_SetServiceStatus replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_SetServiceStatus, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in svcctl_SetServiceStatus\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 8: {
		struct svcctl_UnlockServiceDatabase *r2 = (struct svcctl_UnlockServiceDatabase *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function svcctl_UnlockServiceDatabase replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_UnlockServiceDatabase, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in svcctl_UnlockServiceDatabase\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 9: {
		struct svcctl_NotifyBootConfigStatus *r2 = (struct svcctl_NotifyBootConfigStatus *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function svcctl_NotifyBootConfigStatus replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_NotifyBootConfigStatus, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in svcctl_NotifyBootConfigStatus\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 10: {
		struct svcctl_SCSetServiceBitsW *r2 = (struct svcctl_SCSetServiceBitsW *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function svcctl_SCSetServiceBitsW replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_SCSetServiceBitsW, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in svcctl_SCSetServiceBitsW\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 11: {
		struct svcctl_ChangeServiceConfigW *r2 = (struct svcctl_ChangeServiceConfigW *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function svcctl_ChangeServiceConfigW replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_ChangeServiceConfigW, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in svcctl_ChangeServiceConfigW\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 12: {
		struct svcctl_CreateServiceW *r2 = (struct svcctl_CreateServiceW *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function svcctl_CreateServiceW replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_CreateServiceW, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in svcctl_CreateServiceW\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 13: {
		struct svcctl_EnumDependentServicesW *r2 = (struct svcctl_EnumDependentServicesW *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function svcctl_EnumDependentServicesW replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_EnumDependentServicesW, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in svcctl_EnumDependentServicesW\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 14: {
		struct svcctl_EnumServicesStatusW *r2 = (struct svcctl_EnumServicesStatusW *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function svcctl_EnumServicesStatusW replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_EnumServicesStatusW, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in svcctl_EnumServicesStatusW\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 15: {
		struct svcctl_OpenSCManagerW *r2 = (struct svcctl_OpenSCManagerW *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function svcctl_OpenSCManagerW replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_OpenSCManagerW, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in svcctl_OpenSCManagerW\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 16: {
		struct svcctl_OpenServiceW *r2 = (struct svcctl_OpenServiceW *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function svcctl_OpenServiceW replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_OpenServiceW, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in svcctl_OpenServiceW\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 17: {
		struct svcctl_QueryServiceConfigW *r2 = (struct svcctl_QueryServiceConfigW *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function svcctl_QueryServiceConfigW replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_QueryServiceConfigW, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in svcctl_QueryServiceConfigW\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 18: {
		struct svcctl_QueryServiceLockStatusW *r2 = (struct svcctl_QueryServiceLockStatusW *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function svcctl_QueryServiceLockStatusW replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_QueryServiceLockStatusW, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in svcctl_QueryServiceLockStatusW\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 19: {
		struct svcctl_StartServiceW *r2 = (struct svcctl_StartServiceW *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function svcctl_StartServiceW replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_StartServiceW, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in svcctl_StartServiceW\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 20: {
		struct svcctl_GetServiceDisplayNameW *r2 = (struct svcctl_GetServiceDisplayNameW *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function svcctl_GetServiceDisplayNameW replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_GetServiceDisplayNameW, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in svcctl_GetServiceDisplayNameW\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 21: {
		struct svcctl_GetServiceKeyNameW *r2 = (struct svcctl_GetServiceKeyNameW *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function svcctl_GetServiceKeyNameW replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_GetServiceKeyNameW, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in svcctl_GetServiceKeyNameW\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 22: {
		struct svcctl_SCSetServiceBitsA *r2 = (struct svcctl_SCSetServiceBitsA *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function svcctl_SCSetServiceBitsA replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_SCSetServiceBitsA, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in svcctl_SCSetServiceBitsA\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 23: {
		struct svcctl_ChangeServiceConfigA *r2 = (struct svcctl_ChangeServiceConfigA *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function svcctl_ChangeServiceConfigA replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_ChangeServiceConfigA, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in svcctl_ChangeServiceConfigA\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 24: {
		struct svcctl_CreateServiceA *r2 = (struct svcctl_CreateServiceA *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function svcctl_CreateServiceA replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_CreateServiceA, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in svcctl_CreateServiceA\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 25: {
		struct svcctl_EnumDependentServicesA *r2 = (struct svcctl_EnumDependentServicesA *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function svcctl_EnumDependentServicesA replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_EnumDependentServicesA, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in svcctl_EnumDependentServicesA\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 26: {
		struct svcctl_EnumServicesStatusA *r2 = (struct svcctl_EnumServicesStatusA *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function svcctl_EnumServicesStatusA replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_EnumServicesStatusA, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in svcctl_EnumServicesStatusA\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 27: {
		struct svcctl_OpenSCManagerA *r2 = (struct svcctl_OpenSCManagerA *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function svcctl_OpenSCManagerA replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_OpenSCManagerA, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in svcctl_OpenSCManagerA\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 28: {
		struct svcctl_OpenServiceA *r2 = (struct svcctl_OpenServiceA *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function svcctl_OpenServiceA replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_OpenServiceA, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in svcctl_OpenServiceA\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 29: {
		struct svcctl_QueryServiceConfigA *r2 = (struct svcctl_QueryServiceConfigA *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function svcctl_QueryServiceConfigA replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_QueryServiceConfigA, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in svcctl_QueryServiceConfigA\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 30: {
		struct svcctl_QueryServiceLockStatusA *r2 = (struct svcctl_QueryServiceLockStatusA *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function svcctl_QueryServiceLockStatusA replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_QueryServiceLockStatusA, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in svcctl_QueryServiceLockStatusA\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 31: {
		struct svcctl_StartServiceA *r2 = (struct svcctl_StartServiceA *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function svcctl_StartServiceA replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_StartServiceA, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in svcctl_StartServiceA\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 32: {
		struct svcctl_GetServiceDisplayNameA *r2 = (struct svcctl_GetServiceDisplayNameA *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function svcctl_GetServiceDisplayNameA replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_GetServiceDisplayNameA, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in svcctl_GetServiceDisplayNameA\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 33: {
		struct svcctl_GetServiceKeyNameA *r2 = (struct svcctl_GetServiceKeyNameA *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function svcctl_GetServiceKeyNameA replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_GetServiceKeyNameA, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in svcctl_GetServiceKeyNameA\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 34: {
		struct svcctl_GetCurrentGroupeStateW *r2 = (struct svcctl_GetCurrentGroupeStateW *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function svcctl_GetCurrentGroupeStateW replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_GetCurrentGroupeStateW, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in svcctl_GetCurrentGroupeStateW\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 35: {
		struct svcctl_EnumServiceGroupW *r2 = (struct svcctl_EnumServiceGroupW *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function svcctl_EnumServiceGroupW replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_EnumServiceGroupW, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in svcctl_EnumServiceGroupW\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 36: {
		struct svcctl_ChangeServiceConfig2A *r2 = (struct svcctl_ChangeServiceConfig2A *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function svcctl_ChangeServiceConfig2A replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_ChangeServiceConfig2A, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in svcctl_ChangeServiceConfig2A\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 37: {
		struct svcctl_ChangeServiceConfig2W *r2 = (struct svcctl_ChangeServiceConfig2W *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function svcctl_ChangeServiceConfig2W replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_ChangeServiceConfig2W, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in svcctl_ChangeServiceConfig2W\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 38: {
		struct svcctl_QueryServiceConfig2A *r2 = (struct svcctl_QueryServiceConfig2A *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function svcctl_QueryServiceConfig2A replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_QueryServiceConfig2A, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in svcctl_QueryServiceConfig2A\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 39: {
		struct svcctl_QueryServiceConfig2W *r2 = (struct svcctl_QueryServiceConfig2W *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function svcctl_QueryServiceConfig2W replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_QueryServiceConfig2W, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in svcctl_QueryServiceConfig2W\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 40: {
		struct svcctl_QueryServiceStatusEx *r2 = (struct svcctl_QueryServiceStatusEx *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function svcctl_QueryServiceStatusEx replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_QueryServiceStatusEx, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in svcctl_QueryServiceStatusEx\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 41: {
		struct EnumServicesStatusExA *r2 = (struct EnumServicesStatusExA *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function EnumServicesStatusExA replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(EnumServicesStatusExA, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in EnumServicesStatusExA\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 42: {
		struct EnumServicesStatusExW *r2 = (struct EnumServicesStatusExW *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function EnumServicesStatusExW replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(EnumServicesStatusExW, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in EnumServicesStatusExW\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 43: {
		struct svcctl_SCSendTSMessage *r2 = (struct svcctl_SCSendTSMessage *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function svcctl_SCSendTSMessage replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(svcctl_SCSendTSMessage, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in svcctl_SCSendTSMessage\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}

	default:
		dce_call->fault_code = DCERPC_FAULT_OP_RNG_ERROR;
		break;
	}

	if (dce_call->fault_code != 0) {
		dcerpc_log_packet(dce_call->conn->packet_log_dir,
		          &ndr_table_svcctl, opnum, NDR_IN,
				  &dce_call->pkt.u.request.stub_and_verifier);
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

static NTSTATUS svcctl__op_ndr_push(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, struct ndr_push *push, const void *r)
{
	enum ndr_err_code ndr_err;
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	ndr_err = ndr_table_svcctl.calls[opnum].ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		dce_call->fault_code = DCERPC_FAULT_NDR;
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

const struct dcesrv_interface dcesrv_svcctl_interface = {
	.name		= "svcctl",
	.syntax_id  = {{0x367abb81,0x9844,0x35f1,{0xad,0x32},{0x98,0xf0,0x38,0x00,0x10,0x03}},2.0},
	.bind		= svcctl__op_bind,
	.unbind		= svcctl__op_unbind,
	.ndr_pull	= svcctl__op_ndr_pull,
	.dispatch	= svcctl__op_dispatch,
	.reply		= svcctl__op_reply,
	.ndr_push	= svcctl__op_ndr_push
};


static NTSTATUS svcctl__op_init_server(struct dcesrv_context *dce_ctx, const struct dcesrv_endpoint_server *ep_server)
{
	int i;

	for (i=0;i<ndr_table_svcctl.endpoints->count;i++) {
		NTSTATUS ret;
		const char *name = ndr_table_svcctl.endpoints->names[i];

		ret = dcesrv_interface_register(dce_ctx, name, &dcesrv_svcctl_interface, NULL);
		if (!NT_STATUS_IS_OK(ret)) {
			DEBUG(1,("svcctl_op_init_server: failed to register endpoint '%s'\n",name));
			return ret;
		}
	}

	return NT_STATUS_OK;
}

static bool svcctl__op_interface_by_uuid(struct dcesrv_interface *iface, const struct GUID *uuid, uint32_t if_version)
{
	if (dcesrv_svcctl_interface.syntax_id.if_version == if_version &&
		GUID_equal(&dcesrv_svcctl_interface.syntax_id.uuid, uuid)) {
		memcpy(iface,&dcesrv_svcctl_interface, sizeof(*iface));
		return true;
	}

	return false;
}

static bool svcctl__op_interface_by_name(struct dcesrv_interface *iface, const char *name)
{
	if (strcmp(dcesrv_svcctl_interface.name, name)==0) {
		memcpy(iface, &dcesrv_svcctl_interface, sizeof(*iface));
		return true;
	}

	return false;	
}
	
NTSTATUS dcerpc_server_svcctl_init(void)
{
	NTSTATUS ret;
	struct dcesrv_endpoint_server ep_server;

	/* fill in our name */
	ep_server.name = "svcctl";

	/* fill in all the operations */
	ep_server.init_server = svcctl__op_init_server;

	ep_server.interface_by_uuid = svcctl__op_interface_by_uuid;
	ep_server.interface_by_name = svcctl__op_interface_by_name;

	/* register ourselves with the DCERPC subsystem. */
	ret = dcerpc_register_ep_server(&ep_server);

	if (!NT_STATUS_IS_OK(ret)) {
		DEBUG(0,("Failed to register 'svcctl' endpoint server!\n"));
		return ret;
	}

	return ret;
}

