/* parser auto-generated by pidl */

#include "includes.h"
#include "librpc/gen_ndr/ndr_mgmt.h"

#include "librpc/gen_ndr/ndr_misc.h"
static enum ndr_err_code ndr_push_ndr_syntax_id_p(struct ndr_push *ndr, int ndr_flags, const struct ndr_syntax_id_p *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->id));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->id) {
			NDR_CHECK(ndr_push_ndr_syntax_id(ndr, NDR_SCALARS, r->id));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_ndr_syntax_id_p(struct ndr_pull *ndr, int ndr_flags, struct ndr_syntax_id_p *r)
{
	uint32_t _ptr_id;
	TALLOC_CTX *_mem_save_id_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_id));
		if (_ptr_id) {
			NDR_PULL_ALLOC(ndr, r->id);
		} else {
			r->id = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->id) {
			_mem_save_id_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->id, 0);
			NDR_CHECK(ndr_pull_ndr_syntax_id(ndr, NDR_SCALARS, r->id));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_id_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_ndr_syntax_id_p(struct ndr_print *ndr, const char *name, const struct ndr_syntax_id_p *r)
{
	ndr_print_struct(ndr, name, "ndr_syntax_id_p");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_ptr(ndr, "id", r->id);
	ndr->depth++;
	if (r->id) {
		ndr_print_ndr_syntax_id(ndr, "id", r->id);
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_rpc_if_id_vector_t(struct ndr_push *ndr, int ndr_flags, const struct rpc_if_id_vector_t *r)
{
	uint32_t cntr_if_id_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->count));
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
		for (cntr_if_id_0 = 0; cntr_if_id_0 < r->count; cntr_if_id_0++) {
			NDR_CHECK(ndr_push_ndr_syntax_id_p(ndr, NDR_SCALARS, &r->if_id[cntr_if_id_0]));
		}
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		for (cntr_if_id_0 = 0; cntr_if_id_0 < r->count; cntr_if_id_0++) {
			NDR_CHECK(ndr_push_ndr_syntax_id_p(ndr, NDR_BUFFERS, &r->if_id[cntr_if_id_0]));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_rpc_if_id_vector_t(struct ndr_pull *ndr, int ndr_flags, struct rpc_if_id_vector_t *r)
{
	uint32_t cntr_if_id_0;
	TALLOC_CTX *_mem_save_if_id_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_array_size(ndr, &r->if_id));
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->count));
		NDR_PULL_ALLOC_N(ndr, r->if_id, ndr_get_array_size(ndr, &r->if_id));
		_mem_save_if_id_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->if_id, 0);
		for (cntr_if_id_0 = 0; cntr_if_id_0 < r->count; cntr_if_id_0++) {
			NDR_CHECK(ndr_pull_ndr_syntax_id_p(ndr, NDR_SCALARS, &r->if_id[cntr_if_id_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_if_id_0, 0);
		if (r->if_id) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->if_id, r->count));
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		_mem_save_if_id_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->if_id, 0);
		for (cntr_if_id_0 = 0; cntr_if_id_0 < r->count; cntr_if_id_0++) {
			NDR_CHECK(ndr_pull_ndr_syntax_id_p(ndr, NDR_BUFFERS, &r->if_id[cntr_if_id_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_if_id_0, 0);
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_rpc_if_id_vector_t(struct ndr_print *ndr, const char *name, const struct rpc_if_id_vector_t *r)
{
	uint32_t cntr_if_id_0;
	ndr_print_struct(ndr, name, "rpc_if_id_vector_t");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "count", r->count);
	ndr->print(ndr, "%s: ARRAY(%d)", "if_id", (int)r->count);
	ndr->depth++;
	for (cntr_if_id_0=0;cntr_if_id_0<r->count;cntr_if_id_0++) {
		ndr_print_ndr_syntax_id_p(ndr, "if_id", &r->if_id[cntr_if_id_0]);
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_mgmt_statistics(struct ndr_push *ndr, int ndr_flags, const struct mgmt_statistics *r)
{
	uint32_t cntr_statistics_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->count));
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
		for (cntr_statistics_0 = 0; cntr_statistics_0 < r->count; cntr_statistics_0++) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->statistics[cntr_statistics_0]));
		}
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_mgmt_statistics(struct ndr_pull *ndr, int ndr_flags, struct mgmt_statistics *r)
{
	uint32_t cntr_statistics_0;
	TALLOC_CTX *_mem_save_statistics_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_array_size(ndr, &r->statistics));
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->count));
		NDR_PULL_ALLOC_N(ndr, r->statistics, ndr_get_array_size(ndr, &r->statistics));
		_mem_save_statistics_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->statistics, 0);
		for (cntr_statistics_0 = 0; cntr_statistics_0 < r->count; cntr_statistics_0++) {
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->statistics[cntr_statistics_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_statistics_0, 0);
		if (r->statistics) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->statistics, r->count));
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_mgmt_statistics(struct ndr_print *ndr, const char *name, const struct mgmt_statistics *r)
{
	uint32_t cntr_statistics_0;
	ndr_print_struct(ndr, name, "mgmt_statistics");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "count", r->count);
	ndr->print(ndr, "%s: ARRAY(%d)", "statistics", (int)r->count);
	ndr->depth++;
	for (cntr_statistics_0=0;cntr_statistics_0<r->count;cntr_statistics_0++) {
		ndr_print_uint32(ndr, "statistics", r->statistics[cntr_statistics_0]);
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_mgmt_inq_if_ids(struct ndr_push *ndr, int flags, const struct mgmt_inq_if_ids *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		if (r->out.if_id_vector == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.if_id_vector));
		if (*r->out.if_id_vector) {
			NDR_CHECK(ndr_push_rpc_if_id_vector_t(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.if_id_vector));
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_mgmt_inq_if_ids(struct ndr_pull *ndr, int flags, struct mgmt_inq_if_ids *r)
{
	uint32_t _ptr_if_id_vector;
	TALLOC_CTX *_mem_save_if_id_vector_0;
	TALLOC_CTX *_mem_save_if_id_vector_1;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_PULL_ALLOC(ndr, r->out.if_id_vector);
		ZERO_STRUCTP(r->out.if_id_vector);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.if_id_vector);
		}
		_mem_save_if_id_vector_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.if_id_vector, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_if_id_vector));
		if (_ptr_if_id_vector) {
			NDR_PULL_ALLOC(ndr, *r->out.if_id_vector);
		} else {
			*r->out.if_id_vector = NULL;
		}
		if (*r->out.if_id_vector) {
			_mem_save_if_id_vector_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.if_id_vector, 0);
			NDR_CHECK(ndr_pull_rpc_if_id_vector_t(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.if_id_vector));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_if_id_vector_1, 0);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_if_id_vector_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_mgmt_inq_if_ids(struct ndr_print *ndr, const char *name, int flags, const struct mgmt_inq_if_ids *r)
{
	ndr_print_struct(ndr, name, "mgmt_inq_if_ids");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "mgmt_inq_if_ids");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "mgmt_inq_if_ids");
		ndr->depth++;
		ndr_print_ptr(ndr, "if_id_vector", r->out.if_id_vector);
		ndr->depth++;
		ndr_print_ptr(ndr, "if_id_vector", *r->out.if_id_vector);
		ndr->depth++;
		if (*r->out.if_id_vector) {
			ndr_print_rpc_if_id_vector_t(ndr, "if_id_vector", *r->out.if_id_vector);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_mgmt_inq_stats(struct ndr_push *ndr, int flags, const struct mgmt_inq_stats *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.max_count));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.unknown));
	}
	if (flags & NDR_OUT) {
		if (r->out.statistics == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_mgmt_statistics(ndr, NDR_SCALARS, r->out.statistics));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_mgmt_inq_stats(struct ndr_pull *ndr, int flags, struct mgmt_inq_stats *r)
{
	TALLOC_CTX *_mem_save_statistics_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.max_count));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.unknown));
		NDR_PULL_ALLOC(ndr, r->out.statistics);
		ZERO_STRUCTP(r->out.statistics);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.statistics);
		}
		_mem_save_statistics_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.statistics, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_mgmt_statistics(ndr, NDR_SCALARS, r->out.statistics));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_statistics_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_mgmt_inq_stats(struct ndr_print *ndr, const char *name, int flags, const struct mgmt_inq_stats *r)
{
	ndr_print_struct(ndr, name, "mgmt_inq_stats");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "mgmt_inq_stats");
		ndr->depth++;
		ndr_print_uint32(ndr, "max_count", r->in.max_count);
		ndr_print_uint32(ndr, "unknown", r->in.unknown);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "mgmt_inq_stats");
		ndr->depth++;
		ndr_print_ptr(ndr, "statistics", r->out.statistics);
		ndr->depth++;
		ndr_print_mgmt_statistics(ndr, "statistics", r->out.statistics);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_mgmt_is_server_listening(struct ndr_push *ndr, int flags, const struct mgmt_is_server_listening *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		if (r->out.status == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.status));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_mgmt_is_server_listening(struct ndr_pull *ndr, int flags, struct mgmt_is_server_listening *r)
{
	TALLOC_CTX *_mem_save_status_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_PULL_ALLOC(ndr, r->out.status);
		ZERO_STRUCTP(r->out.status);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.status);
		}
		_mem_save_status_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.status, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.status));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_status_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_mgmt_is_server_listening(struct ndr_print *ndr, const char *name, int flags, const struct mgmt_is_server_listening *r)
{
	ndr_print_struct(ndr, name, "mgmt_is_server_listening");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "mgmt_is_server_listening");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "mgmt_is_server_listening");
		ndr->depth++;
		ndr_print_ptr(ndr, "status", r->out.status);
		ndr->depth++;
		ndr_print_uint32(ndr, "status", *r->out.status);
		ndr->depth--;
		ndr_print_uint32(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_mgmt_stop_server_listening(struct ndr_push *ndr, int flags, const struct mgmt_stop_server_listening *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_mgmt_stop_server_listening(struct ndr_pull *ndr, int flags, struct mgmt_stop_server_listening *r)
{
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_mgmt_stop_server_listening(struct ndr_print *ndr, const char *name, int flags, const struct mgmt_stop_server_listening *r)
{
	ndr_print_struct(ndr, name, "mgmt_stop_server_listening");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "mgmt_stop_server_listening");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "mgmt_stop_server_listening");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_mgmt_inq_princ_name(struct ndr_push *ndr, int flags, const struct mgmt_inq_princ_name *r)
{
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.authn_proto));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.princ_name_size));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->out.princ_name, CH_DOS)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->out.princ_name, CH_DOS)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->out.princ_name, ndr_charset_length(r->out.princ_name, CH_DOS), sizeof(uint8_t), CH_DOS));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_mgmt_inq_princ_name(struct ndr_pull *ndr, int flags, struct mgmt_inq_princ_name *r)
{
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.authn_proto));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.princ_name_size));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_array_size(ndr, &r->out.princ_name));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->out.princ_name));
		if (ndr_get_array_length(ndr, &r->out.princ_name) > ndr_get_array_size(ndr, &r->out.princ_name)) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->out.princ_name), ndr_get_array_length(ndr, &r->out.princ_name));
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->out.princ_name), sizeof(uint8_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->out.princ_name, ndr_get_array_length(ndr, &r->out.princ_name), sizeof(uint8_t), CH_DOS));
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_mgmt_inq_princ_name(struct ndr_print *ndr, const char *name, int flags, const struct mgmt_inq_princ_name *r)
{
	ndr_print_struct(ndr, name, "mgmt_inq_princ_name");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "mgmt_inq_princ_name");
		ndr->depth++;
		ndr_print_uint32(ndr, "authn_proto", r->in.authn_proto);
		ndr_print_uint32(ndr, "princ_name_size", r->in.princ_name_size);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "mgmt_inq_princ_name");
		ndr->depth++;
		ndr_print_string(ndr, "princ_name", r->out.princ_name);
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static const struct ndr_interface_call mgmt_calls[] = {
	{
		"mgmt_inq_if_ids",
		sizeof(struct mgmt_inq_if_ids),
		(ndr_push_flags_fn_t) ndr_push_mgmt_inq_if_ids,
		(ndr_pull_flags_fn_t) ndr_pull_mgmt_inq_if_ids,
		(ndr_print_function_t) ndr_print_mgmt_inq_if_ids,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"mgmt_inq_stats",
		sizeof(struct mgmt_inq_stats),
		(ndr_push_flags_fn_t) ndr_push_mgmt_inq_stats,
		(ndr_pull_flags_fn_t) ndr_pull_mgmt_inq_stats,
		(ndr_print_function_t) ndr_print_mgmt_inq_stats,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"mgmt_is_server_listening",
		sizeof(struct mgmt_is_server_listening),
		(ndr_push_flags_fn_t) ndr_push_mgmt_is_server_listening,
		(ndr_pull_flags_fn_t) ndr_pull_mgmt_is_server_listening,
		(ndr_print_function_t) ndr_print_mgmt_is_server_listening,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"mgmt_stop_server_listening",
		sizeof(struct mgmt_stop_server_listening),
		(ndr_push_flags_fn_t) ndr_push_mgmt_stop_server_listening,
		(ndr_pull_flags_fn_t) ndr_pull_mgmt_stop_server_listening,
		(ndr_print_function_t) ndr_print_mgmt_stop_server_listening,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"mgmt_inq_princ_name",
		sizeof(struct mgmt_inq_princ_name),
		(ndr_push_flags_fn_t) ndr_push_mgmt_inq_princ_name,
		(ndr_pull_flags_fn_t) ndr_pull_mgmt_inq_princ_name,
		(ndr_print_function_t) ndr_print_mgmt_inq_princ_name,
		{ 0, NULL },
		{ 0, NULL },
	},
	{ NULL, 0, NULL, NULL, NULL }
};

static const char * const mgmt_endpoint_strings[] = {
	"ncacn_np:[\\pipe\\mgmt]", 
};

static const struct ndr_interface_string_array mgmt_endpoints = {
	.count	= 1,
	.names	= mgmt_endpoint_strings
};

static const char * const mgmt_authservice_strings[] = {
	"host", 
};

static const struct ndr_interface_string_array mgmt_authservices = {
	.count	= 1,
	.names	= mgmt_authservice_strings
};


const struct ndr_interface_table ndr_table_mgmt = {
	.name		= "mgmt",
	.syntax_id	= {
		{0xafa8bd80,0x7d8a,0x11c9,{0xbe,0xf4},{0x08,0x00,0x2b,0x10,0x29,0x89}},
		NDR_MGMT_VERSION
	},
	.helpstring	= NDR_MGMT_HELPSTRING,
	.num_calls	= 5,
	.calls		= mgmt_calls,
	.endpoints	= &mgmt_endpoints,
	.authservices	= &mgmt_authservices
};

