/* parser auto-generated by pidl */

#include "includes.h"
#include "librpc/gen_ndr/ndr_libnetapi.h"

#include "librpc/gen_ndr/ndr_misc.h"
_PUBLIC_ enum ndr_err_code ndr_push_NET_API_STATUS(struct ndr_push *ndr, int ndr_flags, enum NET_API_STATUS r)
{
	NDR_CHECK(ndr_push_enum_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_NET_API_STATUS(struct ndr_pull *ndr, int ndr_flags, enum NET_API_STATUS *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_enum_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_NET_API_STATUS(struct ndr_print *ndr, const char *name, enum NET_API_STATUS r)
{
	const char *val = NULL;

	switch (r) {
		case NERR_Success: val = "NERR_Success"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

_PUBLIC_ enum ndr_err_code ndr_push_domsid(struct ndr_push *ndr, int ndr_flags, const struct domsid *r)
{
	uint32_t cntr_sub_auths_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->sid_rev_num));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->num_auths));
		NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->id_auth, 6));
		for (cntr_sub_auths_0 = 0; cntr_sub_auths_0 < MAXSUBAUTHS; cntr_sub_auths_0++) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sub_auths[cntr_sub_auths_0]));
		}
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_domsid(struct ndr_pull *ndr, int ndr_flags, struct domsid *r)
{
	uint32_t cntr_sub_auths_0;
	TALLOC_CTX *_mem_save_sub_auths_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->sid_rev_num));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->num_auths));
		NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->id_auth, 6));
		NDR_PULL_ALLOC_N(ndr, r->sub_auths, MAXSUBAUTHS);
		_mem_save_sub_auths_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->sub_auths, 0);
		for (cntr_sub_auths_0 = 0; cntr_sub_auths_0 < MAXSUBAUTHS; cntr_sub_auths_0++) {
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sub_auths[cntr_sub_auths_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sub_auths_0, 0);
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_domsid(struct ndr_print *ndr, const char *name, const struct domsid *r)
{
	uint32_t cntr_sub_auths_0;
	ndr_print_struct(ndr, name, "domsid");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint8(ndr, "sid_rev_num", r->sid_rev_num);
	ndr_print_uint8(ndr, "num_auths", r->num_auths);
	ndr_print_array_uint8(ndr, "id_auth", r->id_auth, 6);
	ndr->print(ndr, "%s: ARRAY(%d)", "sub_auths", (int)MAXSUBAUTHS);
	ndr->depth++;
	for (cntr_sub_auths_0=0;cntr_sub_auths_0<MAXSUBAUTHS;cntr_sub_auths_0++) {
		ndr_print_uint32(ndr, "sub_auths", r->sub_auths[cntr_sub_auths_0]);
	}
	ndr->depth--;
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_NetJoinFlags(struct ndr_push *ndr, int ndr_flags, uint32_t r)
{
	NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_NetJoinFlags(struct ndr_pull *ndr, int ndr_flags, uint32_t *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_NetJoinFlags(struct ndr_print *ndr, const char *name, uint32_t r)
{
	ndr_print_uint32(ndr, name, r);
	ndr->depth++;
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "NETSETUP_JOIN_DOMAIN", NETSETUP_JOIN_DOMAIN, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "NETSETUP_ACCT_CREATE", NETSETUP_ACCT_CREATE, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "NETSETUP_ACCT_DELETE", NETSETUP_ACCT_DELETE, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "NETSETUP_WIN9X_UPGRADE", NETSETUP_WIN9X_UPGRADE, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "NETSETUP_DOMAIN_JOIN_IF_JOINED", NETSETUP_DOMAIN_JOIN_IF_JOINED, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "NETSETUP_JOIN_UNSECURE", NETSETUP_JOIN_UNSECURE, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "NETSETUP_MACHINE_PWD_PASSED", NETSETUP_MACHINE_PWD_PASSED, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "NETSETUP_DEFER_SPN_SET", NETSETUP_DEFER_SPN_SET, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "NETSETUP_JOIN_DC_ACCOUNT", NETSETUP_JOIN_DC_ACCOUNT, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "NETSETUP_JOIN_WITH_NEW_NAME", NETSETUP_JOIN_WITH_NEW_NAME, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "NETSETUP_INSTALL_INVOCATION", NETSETUP_INSTALL_INVOCATION, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "NETSETUP_IGNORE_UNSUPPORTED_FLAGS", NETSETUP_IGNORE_UNSUPPORTED_FLAGS, r);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_SERVER_INFO_100(struct ndr_push *ndr, int ndr_flags, const struct SERVER_INFO_100 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv100_platform_id));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->sv100_name));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_SERVER_INFO_100(struct ndr_pull *ndr, int ndr_flags, struct SERVER_INFO_100 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv100_platform_id));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->sv100_name));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_SERVER_INFO_100(struct ndr_print *ndr, const char *name, const struct SERVER_INFO_100 *r)
{
	ndr_print_struct(ndr, name, "SERVER_INFO_100");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "sv100_platform_id", r->sv100_platform_id);
	ndr_print_string(ndr, "sv100_name", r->sv100_name);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_SERVER_INFO_101(struct ndr_push *ndr, int ndr_flags, const struct SERVER_INFO_101 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv101_platform_id));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->sv101_name));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv101_version_major));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv101_version_minor));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv101_type));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->sv101_comment));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_SERVER_INFO_101(struct ndr_pull *ndr, int ndr_flags, struct SERVER_INFO_101 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv101_platform_id));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->sv101_name));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv101_version_major));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv101_version_minor));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv101_type));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->sv101_comment));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_SERVER_INFO_101(struct ndr_print *ndr, const char *name, const struct SERVER_INFO_101 *r)
{
	ndr_print_struct(ndr, name, "SERVER_INFO_101");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "sv101_platform_id", r->sv101_platform_id);
	ndr_print_string(ndr, "sv101_name", r->sv101_name);
	ndr_print_uint32(ndr, "sv101_version_major", r->sv101_version_major);
	ndr_print_uint32(ndr, "sv101_version_minor", r->sv101_version_minor);
	ndr_print_uint32(ndr, "sv101_type", r->sv101_type);
	ndr_print_string(ndr, "sv101_comment", r->sv101_comment);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_SERVER_INFO_102(struct ndr_push *ndr, int ndr_flags, const struct SERVER_INFO_102 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv102_platform_id));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->sv102_name));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv102_version_major));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv102_version_minor));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv102_type));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->sv102_comment));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv102_users));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv102_disc));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->sv102_hidden));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv102_announce));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv102_anndelta));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv102_licenses));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->sv102_userpath));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_SERVER_INFO_102(struct ndr_pull *ndr, int ndr_flags, struct SERVER_INFO_102 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv102_platform_id));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->sv102_name));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv102_version_major));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv102_version_minor));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv102_type));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->sv102_comment));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv102_users));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv102_disc));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->sv102_hidden));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv102_announce));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv102_anndelta));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv102_licenses));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->sv102_userpath));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_SERVER_INFO_102(struct ndr_print *ndr, const char *name, const struct SERVER_INFO_102 *r)
{
	ndr_print_struct(ndr, name, "SERVER_INFO_102");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "sv102_platform_id", r->sv102_platform_id);
	ndr_print_string(ndr, "sv102_name", r->sv102_name);
	ndr_print_uint32(ndr, "sv102_version_major", r->sv102_version_major);
	ndr_print_uint32(ndr, "sv102_version_minor", r->sv102_version_minor);
	ndr_print_uint32(ndr, "sv102_type", r->sv102_type);
	ndr_print_string(ndr, "sv102_comment", r->sv102_comment);
	ndr_print_uint32(ndr, "sv102_users", r->sv102_users);
	ndr_print_uint32(ndr, "sv102_disc", r->sv102_disc);
	ndr_print_uint8(ndr, "sv102_hidden", r->sv102_hidden);
	ndr_print_uint32(ndr, "sv102_announce", r->sv102_announce);
	ndr_print_uint32(ndr, "sv102_anndelta", r->sv102_anndelta);
	ndr_print_uint32(ndr, "sv102_licenses", r->sv102_licenses);
	ndr_print_string(ndr, "sv102_userpath", r->sv102_userpath);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_SERVER_INFO_402(struct ndr_push *ndr, int ndr_flags, const struct SERVER_INFO_402 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv402_ulist_mtime));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv402_glist_mtime));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv402_alist_mtime));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->sv402_alerts));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv402_security));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv402_numadmin));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv402_lanmask));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->sv402_guestacct));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv402_chdevs));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv402_chdevq));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv402_chdevjobs));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv402_connections));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv402_shares));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv402_openfiles));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv402_sessopens));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv402_sessvcs));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv402_sessreqs));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv402_opensearch));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv402_activelocks));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv402_numreqbuf));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv402_sizreqbuf));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv402_numbigbuf));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv402_numfiletasks));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv402_alertsched));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv402_erroralert));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv402_logonalert));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv402_accessalert));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv402_diskalert));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv402_netioalert));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv402_maxauditsz));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->sv402_srvheuristics));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_SERVER_INFO_402(struct ndr_pull *ndr, int ndr_flags, struct SERVER_INFO_402 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv402_ulist_mtime));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv402_glist_mtime));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv402_alist_mtime));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->sv402_alerts));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv402_security));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv402_numadmin));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv402_lanmask));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->sv402_guestacct));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv402_chdevs));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv402_chdevq));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv402_chdevjobs));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv402_connections));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv402_shares));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv402_openfiles));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv402_sessopens));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv402_sessvcs));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv402_sessreqs));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv402_opensearch));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv402_activelocks));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv402_numreqbuf));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv402_sizreqbuf));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv402_numbigbuf));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv402_numfiletasks));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv402_alertsched));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv402_erroralert));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv402_logonalert));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv402_accessalert));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv402_diskalert));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv402_netioalert));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv402_maxauditsz));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->sv402_srvheuristics));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_SERVER_INFO_402(struct ndr_print *ndr, const char *name, const struct SERVER_INFO_402 *r)
{
	ndr_print_struct(ndr, name, "SERVER_INFO_402");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "sv402_ulist_mtime", r->sv402_ulist_mtime);
	ndr_print_uint32(ndr, "sv402_glist_mtime", r->sv402_glist_mtime);
	ndr_print_uint32(ndr, "sv402_alist_mtime", r->sv402_alist_mtime);
	ndr_print_string(ndr, "sv402_alerts", r->sv402_alerts);
	ndr_print_uint32(ndr, "sv402_security", r->sv402_security);
	ndr_print_uint32(ndr, "sv402_numadmin", r->sv402_numadmin);
	ndr_print_uint32(ndr, "sv402_lanmask", r->sv402_lanmask);
	ndr_print_string(ndr, "sv402_guestacct", r->sv402_guestacct);
	ndr_print_uint32(ndr, "sv402_chdevs", r->sv402_chdevs);
	ndr_print_uint32(ndr, "sv402_chdevq", r->sv402_chdevq);
	ndr_print_uint32(ndr, "sv402_chdevjobs", r->sv402_chdevjobs);
	ndr_print_uint32(ndr, "sv402_connections", r->sv402_connections);
	ndr_print_uint32(ndr, "sv402_shares", r->sv402_shares);
	ndr_print_uint32(ndr, "sv402_openfiles", r->sv402_openfiles);
	ndr_print_uint32(ndr, "sv402_sessopens", r->sv402_sessopens);
	ndr_print_uint32(ndr, "sv402_sessvcs", r->sv402_sessvcs);
	ndr_print_uint32(ndr, "sv402_sessreqs", r->sv402_sessreqs);
	ndr_print_uint32(ndr, "sv402_opensearch", r->sv402_opensearch);
	ndr_print_uint32(ndr, "sv402_activelocks", r->sv402_activelocks);
	ndr_print_uint32(ndr, "sv402_numreqbuf", r->sv402_numreqbuf);
	ndr_print_uint32(ndr, "sv402_sizreqbuf", r->sv402_sizreqbuf);
	ndr_print_uint32(ndr, "sv402_numbigbuf", r->sv402_numbigbuf);
	ndr_print_uint32(ndr, "sv402_numfiletasks", r->sv402_numfiletasks);
	ndr_print_uint32(ndr, "sv402_alertsched", r->sv402_alertsched);
	ndr_print_uint32(ndr, "sv402_erroralert", r->sv402_erroralert);
	ndr_print_uint32(ndr, "sv402_logonalert", r->sv402_logonalert);
	ndr_print_uint32(ndr, "sv402_accessalert", r->sv402_accessalert);
	ndr_print_uint32(ndr, "sv402_diskalert", r->sv402_diskalert);
	ndr_print_uint32(ndr, "sv402_netioalert", r->sv402_netioalert);
	ndr_print_uint32(ndr, "sv402_maxauditsz", r->sv402_maxauditsz);
	ndr_print_string(ndr, "sv402_srvheuristics", r->sv402_srvheuristics);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_SERVER_INFO_403(struct ndr_push *ndr, int ndr_flags, const struct SERVER_INFO_403 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv403_ulist_mtime));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv403_glist_mtime));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv403_alist_mtime));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->sv403_alerts));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv403_security));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv403_numadmin));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv403_lanmask));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->sv403_guestacct));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv403_chdevs));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv403_chdevq));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv403_chdevjobs));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv403_connections));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv403_shares));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv403_openfiles));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv403_sessopens));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv403_sessvcs));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv403_sessreqs));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv403_opensearch));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv403_activelocks));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv403_numreqbuf));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv403_sizreqbuf));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv403_numbigbuf));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv403_numfiletasks));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv403_alertsched));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv403_erroralert));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv403_logonalert));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv403_accessalert));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv403_diskalert));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv403_netioalert));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv403_maxauditsz));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->sv403_srvheuristics));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv403_auditedevents));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv403_autoprofile));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->sv403_autopath));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_SERVER_INFO_403(struct ndr_pull *ndr, int ndr_flags, struct SERVER_INFO_403 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv403_ulist_mtime));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv403_glist_mtime));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv403_alist_mtime));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->sv403_alerts));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv403_security));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv403_numadmin));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv403_lanmask));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->sv403_guestacct));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv403_chdevs));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv403_chdevq));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv403_chdevjobs));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv403_connections));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv403_shares));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv403_openfiles));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv403_sessopens));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv403_sessvcs));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv403_sessreqs));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv403_opensearch));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv403_activelocks));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv403_numreqbuf));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv403_sizreqbuf));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv403_numbigbuf));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv403_numfiletasks));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv403_alertsched));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv403_erroralert));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv403_logonalert));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv403_accessalert));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv403_diskalert));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv403_netioalert));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv403_maxauditsz));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->sv403_srvheuristics));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv403_auditedevents));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv403_autoprofile));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->sv403_autopath));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_SERVER_INFO_403(struct ndr_print *ndr, const char *name, const struct SERVER_INFO_403 *r)
{
	ndr_print_struct(ndr, name, "SERVER_INFO_403");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "sv403_ulist_mtime", r->sv403_ulist_mtime);
	ndr_print_uint32(ndr, "sv403_glist_mtime", r->sv403_glist_mtime);
	ndr_print_uint32(ndr, "sv403_alist_mtime", r->sv403_alist_mtime);
	ndr_print_string(ndr, "sv403_alerts", r->sv403_alerts);
	ndr_print_uint32(ndr, "sv403_security", r->sv403_security);
	ndr_print_uint32(ndr, "sv403_numadmin", r->sv403_numadmin);
	ndr_print_uint32(ndr, "sv403_lanmask", r->sv403_lanmask);
	ndr_print_string(ndr, "sv403_guestacct", r->sv403_guestacct);
	ndr_print_uint32(ndr, "sv403_chdevs", r->sv403_chdevs);
	ndr_print_uint32(ndr, "sv403_chdevq", r->sv403_chdevq);
	ndr_print_uint32(ndr, "sv403_chdevjobs", r->sv403_chdevjobs);
	ndr_print_uint32(ndr, "sv403_connections", r->sv403_connections);
	ndr_print_uint32(ndr, "sv403_shares", r->sv403_shares);
	ndr_print_uint32(ndr, "sv403_openfiles", r->sv403_openfiles);
	ndr_print_uint32(ndr, "sv403_sessopens", r->sv403_sessopens);
	ndr_print_uint32(ndr, "sv403_sessvcs", r->sv403_sessvcs);
	ndr_print_uint32(ndr, "sv403_sessreqs", r->sv403_sessreqs);
	ndr_print_uint32(ndr, "sv403_opensearch", r->sv403_opensearch);
	ndr_print_uint32(ndr, "sv403_activelocks", r->sv403_activelocks);
	ndr_print_uint32(ndr, "sv403_numreqbuf", r->sv403_numreqbuf);
	ndr_print_uint32(ndr, "sv403_sizreqbuf", r->sv403_sizreqbuf);
	ndr_print_uint32(ndr, "sv403_numbigbuf", r->sv403_numbigbuf);
	ndr_print_uint32(ndr, "sv403_numfiletasks", r->sv403_numfiletasks);
	ndr_print_uint32(ndr, "sv403_alertsched", r->sv403_alertsched);
	ndr_print_uint32(ndr, "sv403_erroralert", r->sv403_erroralert);
	ndr_print_uint32(ndr, "sv403_logonalert", r->sv403_logonalert);
	ndr_print_uint32(ndr, "sv403_accessalert", r->sv403_accessalert);
	ndr_print_uint32(ndr, "sv403_diskalert", r->sv403_diskalert);
	ndr_print_uint32(ndr, "sv403_netioalert", r->sv403_netioalert);
	ndr_print_uint32(ndr, "sv403_maxauditsz", r->sv403_maxauditsz);
	ndr_print_string(ndr, "sv403_srvheuristics", r->sv403_srvheuristics);
	ndr_print_uint32(ndr, "sv403_auditedevents", r->sv403_auditedevents);
	ndr_print_uint32(ndr, "sv403_autoprofile", r->sv403_autoprofile);
	ndr_print_string(ndr, "sv403_autopath", r->sv403_autopath);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_SERVER_INFO_502(struct ndr_push *ndr, int ndr_flags, const struct SERVER_INFO_502 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv502_sessopens));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv502_sessvcs));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv502_opensearch));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv502_sizreqbuf));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv502_initworkitems));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv502_maxworkitems));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv502_rawworkitems));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv502_irpstacksize));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv502_maxrawbuflen));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv502_sessusers));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv502_sessconns));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv502_maxpagedmemoryusage));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv502_maxnonpagedmemoryusage));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->sv502_enablesoftcompat));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->sv502_enableforcedlogoff));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->sv502_timesource));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->sv502_acceptdownlevelapis));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->sv502_lmannounce));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_SERVER_INFO_502(struct ndr_pull *ndr, int ndr_flags, struct SERVER_INFO_502 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv502_sessopens));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv502_sessvcs));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv502_opensearch));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv502_sizreqbuf));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv502_initworkitems));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv502_maxworkitems));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv502_rawworkitems));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv502_irpstacksize));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv502_maxrawbuflen));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv502_sessusers));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv502_sessconns));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv502_maxpagedmemoryusage));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv502_maxnonpagedmemoryusage));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->sv502_enablesoftcompat));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->sv502_enableforcedlogoff));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->sv502_timesource));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->sv502_acceptdownlevelapis));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->sv502_lmannounce));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_SERVER_INFO_502(struct ndr_print *ndr, const char *name, const struct SERVER_INFO_502 *r)
{
	ndr_print_struct(ndr, name, "SERVER_INFO_502");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "sv502_sessopens", r->sv502_sessopens);
	ndr_print_uint32(ndr, "sv502_sessvcs", r->sv502_sessvcs);
	ndr_print_uint32(ndr, "sv502_opensearch", r->sv502_opensearch);
	ndr_print_uint32(ndr, "sv502_sizreqbuf", r->sv502_sizreqbuf);
	ndr_print_uint32(ndr, "sv502_initworkitems", r->sv502_initworkitems);
	ndr_print_uint32(ndr, "sv502_maxworkitems", r->sv502_maxworkitems);
	ndr_print_uint32(ndr, "sv502_rawworkitems", r->sv502_rawworkitems);
	ndr_print_uint32(ndr, "sv502_irpstacksize", r->sv502_irpstacksize);
	ndr_print_uint32(ndr, "sv502_maxrawbuflen", r->sv502_maxrawbuflen);
	ndr_print_uint32(ndr, "sv502_sessusers", r->sv502_sessusers);
	ndr_print_uint32(ndr, "sv502_sessconns", r->sv502_sessconns);
	ndr_print_uint32(ndr, "sv502_maxpagedmemoryusage", r->sv502_maxpagedmemoryusage);
	ndr_print_uint32(ndr, "sv502_maxnonpagedmemoryusage", r->sv502_maxnonpagedmemoryusage);
	ndr_print_uint8(ndr, "sv502_enablesoftcompat", r->sv502_enablesoftcompat);
	ndr_print_uint8(ndr, "sv502_enableforcedlogoff", r->sv502_enableforcedlogoff);
	ndr_print_uint8(ndr, "sv502_timesource", r->sv502_timesource);
	ndr_print_uint8(ndr, "sv502_acceptdownlevelapis", r->sv502_acceptdownlevelapis);
	ndr_print_uint8(ndr, "sv502_lmannounce", r->sv502_lmannounce);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_SERVER_INFO_503(struct ndr_push *ndr, int ndr_flags, const struct SERVER_INFO_503 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv503_sessopens));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv503_sessvcs));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv503_opensearch));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv503_sizreqbuf));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv503_initworkitems));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv503_maxworkitems));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv503_rawworkitems));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv503_irpstacksize));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv503_maxrawbuflen));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv503_sessusers));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv503_sessconns));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv503_maxpagedmemoryusage));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv503_maxnonpagedmemoryusage));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->sv503_enablesoftcompat));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->sv503_enableforcedlogoff));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->sv503_timesource));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->sv503_acceptdownlevelapis));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->sv503_lmannounce));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->sv503_domain));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv503_maxcopyreadlen));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv503_maxcopywritelen));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv503_minkeepsearch));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv503_maxkeepsearch));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv503_minkeepcomplsearch));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv503_maxkeepcomplsearch));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv503_threadcountadd));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv503_numblockthreads));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv503_scavtimeout));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv503_minrcvqueue));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv503_minfreeworkitems));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv503_xactmemsize));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv503_threadpriority));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv503_maxmpxct));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv503_oplockbreakwait));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv503_oplockbreakresponsewait));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->sv503_enableoplocks));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->sv503_enableoplockforceclose));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->sv503_enablefcbopens));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->sv503_enableraw));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->sv503_enablesharednetdrives));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv503_minfreeconnections));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv503_maxfreeconnections));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_SERVER_INFO_503(struct ndr_pull *ndr, int ndr_flags, struct SERVER_INFO_503 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv503_sessopens));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv503_sessvcs));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv503_opensearch));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv503_sizreqbuf));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv503_initworkitems));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv503_maxworkitems));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv503_rawworkitems));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv503_irpstacksize));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv503_maxrawbuflen));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv503_sessusers));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv503_sessconns));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv503_maxpagedmemoryusage));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv503_maxnonpagedmemoryusage));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->sv503_enablesoftcompat));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->sv503_enableforcedlogoff));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->sv503_timesource));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->sv503_acceptdownlevelapis));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->sv503_lmannounce));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->sv503_domain));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv503_maxcopyreadlen));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv503_maxcopywritelen));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv503_minkeepsearch));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv503_maxkeepsearch));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv503_minkeepcomplsearch));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv503_maxkeepcomplsearch));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv503_threadcountadd));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv503_numblockthreads));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv503_scavtimeout));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv503_minrcvqueue));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv503_minfreeworkitems));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv503_xactmemsize));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv503_threadpriority));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv503_maxmpxct));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv503_oplockbreakwait));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv503_oplockbreakresponsewait));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->sv503_enableoplocks));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->sv503_enableoplockforceclose));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->sv503_enablefcbopens));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->sv503_enableraw));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->sv503_enablesharednetdrives));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv503_minfreeconnections));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv503_maxfreeconnections));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_SERVER_INFO_503(struct ndr_print *ndr, const char *name, const struct SERVER_INFO_503 *r)
{
	ndr_print_struct(ndr, name, "SERVER_INFO_503");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "sv503_sessopens", r->sv503_sessopens);
	ndr_print_uint32(ndr, "sv503_sessvcs", r->sv503_sessvcs);
	ndr_print_uint32(ndr, "sv503_opensearch", r->sv503_opensearch);
	ndr_print_uint32(ndr, "sv503_sizreqbuf", r->sv503_sizreqbuf);
	ndr_print_uint32(ndr, "sv503_initworkitems", r->sv503_initworkitems);
	ndr_print_uint32(ndr, "sv503_maxworkitems", r->sv503_maxworkitems);
	ndr_print_uint32(ndr, "sv503_rawworkitems", r->sv503_rawworkitems);
	ndr_print_uint32(ndr, "sv503_irpstacksize", r->sv503_irpstacksize);
	ndr_print_uint32(ndr, "sv503_maxrawbuflen", r->sv503_maxrawbuflen);
	ndr_print_uint32(ndr, "sv503_sessusers", r->sv503_sessusers);
	ndr_print_uint32(ndr, "sv503_sessconns", r->sv503_sessconns);
	ndr_print_uint32(ndr, "sv503_maxpagedmemoryusage", r->sv503_maxpagedmemoryusage);
	ndr_print_uint32(ndr, "sv503_maxnonpagedmemoryusage", r->sv503_maxnonpagedmemoryusage);
	ndr_print_uint8(ndr, "sv503_enablesoftcompat", r->sv503_enablesoftcompat);
	ndr_print_uint8(ndr, "sv503_enableforcedlogoff", r->sv503_enableforcedlogoff);
	ndr_print_uint8(ndr, "sv503_timesource", r->sv503_timesource);
	ndr_print_uint8(ndr, "sv503_acceptdownlevelapis", r->sv503_acceptdownlevelapis);
	ndr_print_uint8(ndr, "sv503_lmannounce", r->sv503_lmannounce);
	ndr_print_string(ndr, "sv503_domain", r->sv503_domain);
	ndr_print_uint32(ndr, "sv503_maxcopyreadlen", r->sv503_maxcopyreadlen);
	ndr_print_uint32(ndr, "sv503_maxcopywritelen", r->sv503_maxcopywritelen);
	ndr_print_uint32(ndr, "sv503_minkeepsearch", r->sv503_minkeepsearch);
	ndr_print_uint32(ndr, "sv503_maxkeepsearch", r->sv503_maxkeepsearch);
	ndr_print_uint32(ndr, "sv503_minkeepcomplsearch", r->sv503_minkeepcomplsearch);
	ndr_print_uint32(ndr, "sv503_maxkeepcomplsearch", r->sv503_maxkeepcomplsearch);
	ndr_print_uint32(ndr, "sv503_threadcountadd", r->sv503_threadcountadd);
	ndr_print_uint32(ndr, "sv503_numblockthreads", r->sv503_numblockthreads);
	ndr_print_uint32(ndr, "sv503_scavtimeout", r->sv503_scavtimeout);
	ndr_print_uint32(ndr, "sv503_minrcvqueue", r->sv503_minrcvqueue);
	ndr_print_uint32(ndr, "sv503_minfreeworkitems", r->sv503_minfreeworkitems);
	ndr_print_uint32(ndr, "sv503_xactmemsize", r->sv503_xactmemsize);
	ndr_print_uint32(ndr, "sv503_threadpriority", r->sv503_threadpriority);
	ndr_print_uint32(ndr, "sv503_maxmpxct", r->sv503_maxmpxct);
	ndr_print_uint32(ndr, "sv503_oplockbreakwait", r->sv503_oplockbreakwait);
	ndr_print_uint32(ndr, "sv503_oplockbreakresponsewait", r->sv503_oplockbreakresponsewait);
	ndr_print_uint8(ndr, "sv503_enableoplocks", r->sv503_enableoplocks);
	ndr_print_uint8(ndr, "sv503_enableoplockforceclose", r->sv503_enableoplockforceclose);
	ndr_print_uint8(ndr, "sv503_enablefcbopens", r->sv503_enablefcbopens);
	ndr_print_uint8(ndr, "sv503_enableraw", r->sv503_enableraw);
	ndr_print_uint8(ndr, "sv503_enablesharednetdrives", r->sv503_enablesharednetdrives);
	ndr_print_uint32(ndr, "sv503_minfreeconnections", r->sv503_minfreeconnections);
	ndr_print_uint32(ndr, "sv503_maxfreeconnections", r->sv503_maxfreeconnections);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_SERVER_INFO_599(struct ndr_push *ndr, int ndr_flags, const struct SERVER_INFO_599 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv599_sessopens));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv599_sessvcs));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv599_opensearch));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv599_sizreqbuf));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv599_initworkitems));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv599_maxworkitems));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv599_rawworkitems));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv599_irpstacksize));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv599_maxrawbuflen));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv599_sessusers));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv599_sessconns));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv599_maxpagedmemoryusage));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv599_maxnonpagedmemoryusage));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->sv599_enablesoftcompat));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->sv599_enableforcedlogoff));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->sv599_timesource));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->sv599_acceptdownlevelapis));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->sv599_lmannounce));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->sv599_domain));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv599_maxcopyreadlen));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv599_maxcopywritelen));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv599_minkeepsearch));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv599_maxkeepsearch));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv599_minkeepcomplsearch));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv599_maxkeepcomplsearch));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv599_threadcountadd));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv599_numblockthreads));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv599_scavtimeout));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv599_minrcvqueue));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv599_minfreeworkitems));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv599_xactmemsize));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv599_threadpriority));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv599_maxmpxct));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv599_oplockbreakwait));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv599_oplockbreakresponsewait));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->sv599_enableoplocks));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->sv599_enableoplockforceclose));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->sv599_enablefcbopens));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->sv599_enableraw));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->sv599_enablesharednetdrives));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv599_minfreeconnections));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv599_maxfreeconnections));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv599_initsesstable));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv599_initconntable));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv599_initfiletable));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv599_initsearchtable));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv599_alertschedule));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv599_errorthreshold));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv599_networkerrorthreshold));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv599_diskspacethreshold));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv599_reserved));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv599_maxlinkdelay));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv599_minlinkthroughput));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv599_linkinfovalidtime));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv599_scavqosinfoupdatetime));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv599_maxworkitemidletime));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_SERVER_INFO_599(struct ndr_pull *ndr, int ndr_flags, struct SERVER_INFO_599 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv599_sessopens));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv599_sessvcs));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv599_opensearch));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv599_sizreqbuf));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv599_initworkitems));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv599_maxworkitems));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv599_rawworkitems));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv599_irpstacksize));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv599_maxrawbuflen));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv599_sessusers));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv599_sessconns));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv599_maxpagedmemoryusage));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv599_maxnonpagedmemoryusage));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->sv599_enablesoftcompat));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->sv599_enableforcedlogoff));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->sv599_timesource));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->sv599_acceptdownlevelapis));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->sv599_lmannounce));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->sv599_domain));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv599_maxcopyreadlen));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv599_maxcopywritelen));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv599_minkeepsearch));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv599_maxkeepsearch));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv599_minkeepcomplsearch));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv599_maxkeepcomplsearch));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv599_threadcountadd));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv599_numblockthreads));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv599_scavtimeout));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv599_minrcvqueue));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv599_minfreeworkitems));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv599_xactmemsize));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv599_threadpriority));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv599_maxmpxct));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv599_oplockbreakwait));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv599_oplockbreakresponsewait));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->sv599_enableoplocks));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->sv599_enableoplockforceclose));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->sv599_enablefcbopens));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->sv599_enableraw));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->sv599_enablesharednetdrives));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv599_minfreeconnections));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv599_maxfreeconnections));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv599_initsesstable));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv599_initconntable));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv599_initfiletable));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv599_initsearchtable));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv599_alertschedule));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv599_errorthreshold));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv599_networkerrorthreshold));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv599_diskspacethreshold));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv599_reserved));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv599_maxlinkdelay));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv599_minlinkthroughput));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv599_linkinfovalidtime));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv599_scavqosinfoupdatetime));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv599_maxworkitemidletime));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_SERVER_INFO_599(struct ndr_print *ndr, const char *name, const struct SERVER_INFO_599 *r)
{
	ndr_print_struct(ndr, name, "SERVER_INFO_599");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "sv599_sessopens", r->sv599_sessopens);
	ndr_print_uint32(ndr, "sv599_sessvcs", r->sv599_sessvcs);
	ndr_print_uint32(ndr, "sv599_opensearch", r->sv599_opensearch);
	ndr_print_uint32(ndr, "sv599_sizreqbuf", r->sv599_sizreqbuf);
	ndr_print_uint32(ndr, "sv599_initworkitems", r->sv599_initworkitems);
	ndr_print_uint32(ndr, "sv599_maxworkitems", r->sv599_maxworkitems);
	ndr_print_uint32(ndr, "sv599_rawworkitems", r->sv599_rawworkitems);
	ndr_print_uint32(ndr, "sv599_irpstacksize", r->sv599_irpstacksize);
	ndr_print_uint32(ndr, "sv599_maxrawbuflen", r->sv599_maxrawbuflen);
	ndr_print_uint32(ndr, "sv599_sessusers", r->sv599_sessusers);
	ndr_print_uint32(ndr, "sv599_sessconns", r->sv599_sessconns);
	ndr_print_uint32(ndr, "sv599_maxpagedmemoryusage", r->sv599_maxpagedmemoryusage);
	ndr_print_uint32(ndr, "sv599_maxnonpagedmemoryusage", r->sv599_maxnonpagedmemoryusage);
	ndr_print_uint8(ndr, "sv599_enablesoftcompat", r->sv599_enablesoftcompat);
	ndr_print_uint8(ndr, "sv599_enableforcedlogoff", r->sv599_enableforcedlogoff);
	ndr_print_uint8(ndr, "sv599_timesource", r->sv599_timesource);
	ndr_print_uint8(ndr, "sv599_acceptdownlevelapis", r->sv599_acceptdownlevelapis);
	ndr_print_uint8(ndr, "sv599_lmannounce", r->sv599_lmannounce);
	ndr_print_string(ndr, "sv599_domain", r->sv599_domain);
	ndr_print_uint32(ndr, "sv599_maxcopyreadlen", r->sv599_maxcopyreadlen);
	ndr_print_uint32(ndr, "sv599_maxcopywritelen", r->sv599_maxcopywritelen);
	ndr_print_uint32(ndr, "sv599_minkeepsearch", r->sv599_minkeepsearch);
	ndr_print_uint32(ndr, "sv599_maxkeepsearch", r->sv599_maxkeepsearch);
	ndr_print_uint32(ndr, "sv599_minkeepcomplsearch", r->sv599_minkeepcomplsearch);
	ndr_print_uint32(ndr, "sv599_maxkeepcomplsearch", r->sv599_maxkeepcomplsearch);
	ndr_print_uint32(ndr, "sv599_threadcountadd", r->sv599_threadcountadd);
	ndr_print_uint32(ndr, "sv599_numblockthreads", r->sv599_numblockthreads);
	ndr_print_uint32(ndr, "sv599_scavtimeout", r->sv599_scavtimeout);
	ndr_print_uint32(ndr, "sv599_minrcvqueue", r->sv599_minrcvqueue);
	ndr_print_uint32(ndr, "sv599_minfreeworkitems", r->sv599_minfreeworkitems);
	ndr_print_uint32(ndr, "sv599_xactmemsize", r->sv599_xactmemsize);
	ndr_print_uint32(ndr, "sv599_threadpriority", r->sv599_threadpriority);
	ndr_print_uint32(ndr, "sv599_maxmpxct", r->sv599_maxmpxct);
	ndr_print_uint32(ndr, "sv599_oplockbreakwait", r->sv599_oplockbreakwait);
	ndr_print_uint32(ndr, "sv599_oplockbreakresponsewait", r->sv599_oplockbreakresponsewait);
	ndr_print_uint8(ndr, "sv599_enableoplocks", r->sv599_enableoplocks);
	ndr_print_uint8(ndr, "sv599_enableoplockforceclose", r->sv599_enableoplockforceclose);
	ndr_print_uint8(ndr, "sv599_enablefcbopens", r->sv599_enablefcbopens);
	ndr_print_uint8(ndr, "sv599_enableraw", r->sv599_enableraw);
	ndr_print_uint8(ndr, "sv599_enablesharednetdrives", r->sv599_enablesharednetdrives);
	ndr_print_uint32(ndr, "sv599_minfreeconnections", r->sv599_minfreeconnections);
	ndr_print_uint32(ndr, "sv599_maxfreeconnections", r->sv599_maxfreeconnections);
	ndr_print_uint32(ndr, "sv599_initsesstable", r->sv599_initsesstable);
	ndr_print_uint32(ndr, "sv599_initconntable", r->sv599_initconntable);
	ndr_print_uint32(ndr, "sv599_initfiletable", r->sv599_initfiletable);
	ndr_print_uint32(ndr, "sv599_initsearchtable", r->sv599_initsearchtable);
	ndr_print_uint32(ndr, "sv599_alertschedule", r->sv599_alertschedule);
	ndr_print_uint32(ndr, "sv599_errorthreshold", r->sv599_errorthreshold);
	ndr_print_uint32(ndr, "sv599_networkerrorthreshold", r->sv599_networkerrorthreshold);
	ndr_print_uint32(ndr, "sv599_diskspacethreshold", r->sv599_diskspacethreshold);
	ndr_print_uint32(ndr, "sv599_reserved", r->sv599_reserved);
	ndr_print_uint32(ndr, "sv599_maxlinkdelay", r->sv599_maxlinkdelay);
	ndr_print_uint32(ndr, "sv599_minlinkthroughput", r->sv599_minlinkthroughput);
	ndr_print_uint32(ndr, "sv599_linkinfovalidtime", r->sv599_linkinfovalidtime);
	ndr_print_uint32(ndr, "sv599_scavqosinfoupdatetime", r->sv599_scavqosinfoupdatetime);
	ndr_print_uint32(ndr, "sv599_maxworkitemidletime", r->sv599_maxworkitemidletime);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_SERVER_INFO_598(struct ndr_push *ndr, int ndr_flags, const struct SERVER_INFO_598 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv598_maxrawworkitems));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv598_maxthreadsperqueue));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv598_producttype));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv598_serversize));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv598_connectionlessautodisc));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv598_sharingviolationretries));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv598_sharingviolationdelay));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv598_maxglobalopensearch));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv598_removeduplicatesearches));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv598_lockviolationoffset));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv598_lockviolationdelay));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv598_mdlreadswitchover));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv598_cachedopenlimit));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv598_otherqueueaffinity));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->sv598_restrictnullsessaccess));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->sv598_enablewfw311directipx));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv598_queuesamplesecs));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv598_balancecount));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv598_preferredaffinity));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv598_maxfreerfcbs));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv598_maxfreemfcbs));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv598_maxfreelfcbs));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv598_maxfreepagedpoolchunks));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv598_minpagedpoolchunksize));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv598_maxpagedpoolchunksize));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->sv598_sendsfrompreferredprocessor));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv598_cacheddirectorylimit));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv598_maxcopylength));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->sv598_enablecompression));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->sv598_autosharewks));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->sv598_autoshareserver));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->sv598_enablesecuritysignature));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->sv598_requiresecuritysignature));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv598_minclientbuffersize));
		NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, &r->sv598_serverguid));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv598_ConnectionNoSessionsTimeout));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv598_IdleThreadTimeOut));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->sv598_enableW9xsecuritysignature));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->sv598_enforcekerberosreauthentication));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->sv598_disabledos));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv598_lowdiskspaceminimum));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->sv598_disablestrictnamechecking));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_SERVER_INFO_598(struct ndr_pull *ndr, int ndr_flags, struct SERVER_INFO_598 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv598_maxrawworkitems));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv598_maxthreadsperqueue));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv598_producttype));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv598_serversize));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv598_connectionlessautodisc));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv598_sharingviolationretries));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv598_sharingviolationdelay));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv598_maxglobalopensearch));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv598_removeduplicatesearches));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv598_lockviolationoffset));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv598_lockviolationdelay));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv598_mdlreadswitchover));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv598_cachedopenlimit));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv598_otherqueueaffinity));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->sv598_restrictnullsessaccess));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->sv598_enablewfw311directipx));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv598_queuesamplesecs));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv598_balancecount));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv598_preferredaffinity));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv598_maxfreerfcbs));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv598_maxfreemfcbs));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv598_maxfreelfcbs));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv598_maxfreepagedpoolchunks));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv598_minpagedpoolchunksize));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv598_maxpagedpoolchunksize));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->sv598_sendsfrompreferredprocessor));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv598_cacheddirectorylimit));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv598_maxcopylength));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->sv598_enablecompression));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->sv598_autosharewks));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->sv598_autoshareserver));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->sv598_enablesecuritysignature));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->sv598_requiresecuritysignature));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv598_minclientbuffersize));
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, &r->sv598_serverguid));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv598_ConnectionNoSessionsTimeout));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv598_IdleThreadTimeOut));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->sv598_enableW9xsecuritysignature));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->sv598_enforcekerberosreauthentication));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->sv598_disabledos));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv598_lowdiskspaceminimum));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->sv598_disablestrictnamechecking));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_SERVER_INFO_598(struct ndr_print *ndr, const char *name, const struct SERVER_INFO_598 *r)
{
	ndr_print_struct(ndr, name, "SERVER_INFO_598");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "sv598_maxrawworkitems", r->sv598_maxrawworkitems);
	ndr_print_uint32(ndr, "sv598_maxthreadsperqueue", r->sv598_maxthreadsperqueue);
	ndr_print_uint32(ndr, "sv598_producttype", r->sv598_producttype);
	ndr_print_uint32(ndr, "sv598_serversize", r->sv598_serversize);
	ndr_print_uint32(ndr, "sv598_connectionlessautodisc", r->sv598_connectionlessautodisc);
	ndr_print_uint32(ndr, "sv598_sharingviolationretries", r->sv598_sharingviolationretries);
	ndr_print_uint32(ndr, "sv598_sharingviolationdelay", r->sv598_sharingviolationdelay);
	ndr_print_uint32(ndr, "sv598_maxglobalopensearch", r->sv598_maxglobalopensearch);
	ndr_print_uint32(ndr, "sv598_removeduplicatesearches", r->sv598_removeduplicatesearches);
	ndr_print_uint32(ndr, "sv598_lockviolationoffset", r->sv598_lockviolationoffset);
	ndr_print_uint32(ndr, "sv598_lockviolationdelay", r->sv598_lockviolationdelay);
	ndr_print_uint32(ndr, "sv598_mdlreadswitchover", r->sv598_mdlreadswitchover);
	ndr_print_uint32(ndr, "sv598_cachedopenlimit", r->sv598_cachedopenlimit);
	ndr_print_uint32(ndr, "sv598_otherqueueaffinity", r->sv598_otherqueueaffinity);
	ndr_print_uint8(ndr, "sv598_restrictnullsessaccess", r->sv598_restrictnullsessaccess);
	ndr_print_uint8(ndr, "sv598_enablewfw311directipx", r->sv598_enablewfw311directipx);
	ndr_print_uint32(ndr, "sv598_queuesamplesecs", r->sv598_queuesamplesecs);
	ndr_print_uint32(ndr, "sv598_balancecount", r->sv598_balancecount);
	ndr_print_uint32(ndr, "sv598_preferredaffinity", r->sv598_preferredaffinity);
	ndr_print_uint32(ndr, "sv598_maxfreerfcbs", r->sv598_maxfreerfcbs);
	ndr_print_uint32(ndr, "sv598_maxfreemfcbs", r->sv598_maxfreemfcbs);
	ndr_print_uint32(ndr, "sv598_maxfreelfcbs", r->sv598_maxfreelfcbs);
	ndr_print_uint32(ndr, "sv598_maxfreepagedpoolchunks", r->sv598_maxfreepagedpoolchunks);
	ndr_print_uint32(ndr, "sv598_minpagedpoolchunksize", r->sv598_minpagedpoolchunksize);
	ndr_print_uint32(ndr, "sv598_maxpagedpoolchunksize", r->sv598_maxpagedpoolchunksize);
	ndr_print_uint8(ndr, "sv598_sendsfrompreferredprocessor", r->sv598_sendsfrompreferredprocessor);
	ndr_print_uint32(ndr, "sv598_cacheddirectorylimit", r->sv598_cacheddirectorylimit);
	ndr_print_uint32(ndr, "sv598_maxcopylength", r->sv598_maxcopylength);
	ndr_print_uint8(ndr, "sv598_enablecompression", r->sv598_enablecompression);
	ndr_print_uint8(ndr, "sv598_autosharewks", r->sv598_autosharewks);
	ndr_print_uint8(ndr, "sv598_autoshareserver", r->sv598_autoshareserver);
	ndr_print_uint8(ndr, "sv598_enablesecuritysignature", r->sv598_enablesecuritysignature);
	ndr_print_uint8(ndr, "sv598_requiresecuritysignature", r->sv598_requiresecuritysignature);
	ndr_print_uint32(ndr, "sv598_minclientbuffersize", r->sv598_minclientbuffersize);
	ndr_print_GUID(ndr, "sv598_serverguid", &r->sv598_serverguid);
	ndr_print_uint32(ndr, "sv598_ConnectionNoSessionsTimeout", r->sv598_ConnectionNoSessionsTimeout);
	ndr_print_uint32(ndr, "sv598_IdleThreadTimeOut", r->sv598_IdleThreadTimeOut);
	ndr_print_uint8(ndr, "sv598_enableW9xsecuritysignature", r->sv598_enableW9xsecuritysignature);
	ndr_print_uint8(ndr, "sv598_enforcekerberosreauthentication", r->sv598_enforcekerberosreauthentication);
	ndr_print_uint8(ndr, "sv598_disabledos", r->sv598_disabledos);
	ndr_print_uint32(ndr, "sv598_lowdiskspaceminimum", r->sv598_lowdiskspaceminimum);
	ndr_print_uint8(ndr, "sv598_disablestrictnamechecking", r->sv598_disablestrictnamechecking);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_SERVER_INFO_1005(struct ndr_push *ndr, int ndr_flags, const struct SERVER_INFO_1005 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->sv1005_comment));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_SERVER_INFO_1005(struct ndr_pull *ndr, int ndr_flags, struct SERVER_INFO_1005 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->sv1005_comment));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_SERVER_INFO_1005(struct ndr_print *ndr, const char *name, const struct SERVER_INFO_1005 *r)
{
	ndr_print_struct(ndr, name, "SERVER_INFO_1005");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_string(ndr, "sv1005_comment", r->sv1005_comment);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_SERVER_INFO_1107(struct ndr_push *ndr, int ndr_flags, const struct SERVER_INFO_1107 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv1107_users));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_SERVER_INFO_1107(struct ndr_pull *ndr, int ndr_flags, struct SERVER_INFO_1107 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv1107_users));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_SERVER_INFO_1107(struct ndr_print *ndr, const char *name, const struct SERVER_INFO_1107 *r)
{
	ndr_print_struct(ndr, name, "SERVER_INFO_1107");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "sv1107_users", r->sv1107_users);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_SERVER_INFO_1010(struct ndr_push *ndr, int ndr_flags, const struct SERVER_INFO_1010 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_int32(ndr, NDR_SCALARS, r->sv1010_disc));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_SERVER_INFO_1010(struct ndr_pull *ndr, int ndr_flags, struct SERVER_INFO_1010 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_int32(ndr, NDR_SCALARS, &r->sv1010_disc));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_SERVER_INFO_1010(struct ndr_print *ndr, const char *name, const struct SERVER_INFO_1010 *r)
{
	ndr_print_struct(ndr, name, "SERVER_INFO_1010");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_int32(ndr, "sv1010_disc", r->sv1010_disc);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_SERVER_INFO_1016(struct ndr_push *ndr, int ndr_flags, const struct SERVER_INFO_1016 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 1));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->sv1016_hidden));
		NDR_CHECK(ndr_push_trailer_align(ndr, 1));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_SERVER_INFO_1016(struct ndr_pull *ndr, int ndr_flags, struct SERVER_INFO_1016 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 1));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->sv1016_hidden));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 1));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_SERVER_INFO_1016(struct ndr_print *ndr, const char *name, const struct SERVER_INFO_1016 *r)
{
	ndr_print_struct(ndr, name, "SERVER_INFO_1016");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint8(ndr, "sv1016_hidden", r->sv1016_hidden);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_SERVER_INFO_1017(struct ndr_push *ndr, int ndr_flags, const struct SERVER_INFO_1017 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv1017_announce));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_SERVER_INFO_1017(struct ndr_pull *ndr, int ndr_flags, struct SERVER_INFO_1017 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv1017_announce));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_SERVER_INFO_1017(struct ndr_print *ndr, const char *name, const struct SERVER_INFO_1017 *r)
{
	ndr_print_struct(ndr, name, "SERVER_INFO_1017");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "sv1017_announce", r->sv1017_announce);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_SERVER_INFO_1018(struct ndr_push *ndr, int ndr_flags, const struct SERVER_INFO_1018 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv1018_anndelta));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_SERVER_INFO_1018(struct ndr_pull *ndr, int ndr_flags, struct SERVER_INFO_1018 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv1018_anndelta));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_SERVER_INFO_1018(struct ndr_print *ndr, const char *name, const struct SERVER_INFO_1018 *r)
{
	ndr_print_struct(ndr, name, "SERVER_INFO_1018");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "sv1018_anndelta", r->sv1018_anndelta);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_SERVER_INFO_1501(struct ndr_push *ndr, int ndr_flags, const struct SERVER_INFO_1501 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv1501_sessopens));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_SERVER_INFO_1501(struct ndr_pull *ndr, int ndr_flags, struct SERVER_INFO_1501 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv1501_sessopens));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_SERVER_INFO_1501(struct ndr_print *ndr, const char *name, const struct SERVER_INFO_1501 *r)
{
	ndr_print_struct(ndr, name, "SERVER_INFO_1501");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "sv1501_sessopens", r->sv1501_sessopens);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_SERVER_INFO_1502(struct ndr_push *ndr, int ndr_flags, const struct SERVER_INFO_1502 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv1502_sessvcs));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_SERVER_INFO_1502(struct ndr_pull *ndr, int ndr_flags, struct SERVER_INFO_1502 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv1502_sessvcs));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_SERVER_INFO_1502(struct ndr_print *ndr, const char *name, const struct SERVER_INFO_1502 *r)
{
	ndr_print_struct(ndr, name, "SERVER_INFO_1502");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "sv1502_sessvcs", r->sv1502_sessvcs);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_SERVER_INFO_1503(struct ndr_push *ndr, int ndr_flags, const struct SERVER_INFO_1503 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv1503_opensearch));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_SERVER_INFO_1503(struct ndr_pull *ndr, int ndr_flags, struct SERVER_INFO_1503 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv1503_opensearch));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_SERVER_INFO_1503(struct ndr_print *ndr, const char *name, const struct SERVER_INFO_1503 *r)
{
	ndr_print_struct(ndr, name, "SERVER_INFO_1503");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "sv1503_opensearch", r->sv1503_opensearch);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_SERVER_INFO_1506(struct ndr_push *ndr, int ndr_flags, const struct SERVER_INFO_1506 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv1506_maxworkitems));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_SERVER_INFO_1506(struct ndr_pull *ndr, int ndr_flags, struct SERVER_INFO_1506 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv1506_maxworkitems));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_SERVER_INFO_1506(struct ndr_print *ndr, const char *name, const struct SERVER_INFO_1506 *r)
{
	ndr_print_struct(ndr, name, "SERVER_INFO_1506");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "sv1506_maxworkitems", r->sv1506_maxworkitems);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_SERVER_INFO_1509(struct ndr_push *ndr, int ndr_flags, const struct SERVER_INFO_1509 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv1509_maxrawbuflen));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_SERVER_INFO_1509(struct ndr_pull *ndr, int ndr_flags, struct SERVER_INFO_1509 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv1509_maxrawbuflen));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_SERVER_INFO_1509(struct ndr_print *ndr, const char *name, const struct SERVER_INFO_1509 *r)
{
	ndr_print_struct(ndr, name, "SERVER_INFO_1509");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "sv1509_maxrawbuflen", r->sv1509_maxrawbuflen);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_SERVER_INFO_1510(struct ndr_push *ndr, int ndr_flags, const struct SERVER_INFO_1510 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv1510_sessusers));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_SERVER_INFO_1510(struct ndr_pull *ndr, int ndr_flags, struct SERVER_INFO_1510 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv1510_sessusers));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_SERVER_INFO_1510(struct ndr_print *ndr, const char *name, const struct SERVER_INFO_1510 *r)
{
	ndr_print_struct(ndr, name, "SERVER_INFO_1510");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "sv1510_sessusers", r->sv1510_sessusers);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_SERVER_INFO_1511(struct ndr_push *ndr, int ndr_flags, const struct SERVER_INFO_1511 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv1511_sessconns));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_SERVER_INFO_1511(struct ndr_pull *ndr, int ndr_flags, struct SERVER_INFO_1511 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv1511_sessconns));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_SERVER_INFO_1511(struct ndr_print *ndr, const char *name, const struct SERVER_INFO_1511 *r)
{
	ndr_print_struct(ndr, name, "SERVER_INFO_1511");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "sv1511_sessconns", r->sv1511_sessconns);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_SERVER_INFO_1512(struct ndr_push *ndr, int ndr_flags, const struct SERVER_INFO_1512 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv1512_maxnonpagedmemoryusage));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_SERVER_INFO_1512(struct ndr_pull *ndr, int ndr_flags, struct SERVER_INFO_1512 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv1512_maxnonpagedmemoryusage));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_SERVER_INFO_1512(struct ndr_print *ndr, const char *name, const struct SERVER_INFO_1512 *r)
{
	ndr_print_struct(ndr, name, "SERVER_INFO_1512");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "sv1512_maxnonpagedmemoryusage", r->sv1512_maxnonpagedmemoryusage);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_SERVER_INFO_1513(struct ndr_push *ndr, int ndr_flags, const struct SERVER_INFO_1513 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv1513_maxpagedmemoryusage));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_SERVER_INFO_1513(struct ndr_pull *ndr, int ndr_flags, struct SERVER_INFO_1513 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv1513_maxpagedmemoryusage));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_SERVER_INFO_1513(struct ndr_print *ndr, const char *name, const struct SERVER_INFO_1513 *r)
{
	ndr_print_struct(ndr, name, "SERVER_INFO_1513");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "sv1513_maxpagedmemoryusage", r->sv1513_maxpagedmemoryusage);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_SERVER_INFO_1514(struct ndr_push *ndr, int ndr_flags, const struct SERVER_INFO_1514 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 1));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->sv1514_enablesoftcompat));
		NDR_CHECK(ndr_push_trailer_align(ndr, 1));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_SERVER_INFO_1514(struct ndr_pull *ndr, int ndr_flags, struct SERVER_INFO_1514 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 1));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->sv1514_enablesoftcompat));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 1));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_SERVER_INFO_1514(struct ndr_print *ndr, const char *name, const struct SERVER_INFO_1514 *r)
{
	ndr_print_struct(ndr, name, "SERVER_INFO_1514");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint8(ndr, "sv1514_enablesoftcompat", r->sv1514_enablesoftcompat);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_SERVER_INFO_1515(struct ndr_push *ndr, int ndr_flags, const struct SERVER_INFO_1515 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 1));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->sv1515_enableforcedlogoff));
		NDR_CHECK(ndr_push_trailer_align(ndr, 1));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_SERVER_INFO_1515(struct ndr_pull *ndr, int ndr_flags, struct SERVER_INFO_1515 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 1));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->sv1515_enableforcedlogoff));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 1));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_SERVER_INFO_1515(struct ndr_print *ndr, const char *name, const struct SERVER_INFO_1515 *r)
{
	ndr_print_struct(ndr, name, "SERVER_INFO_1515");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint8(ndr, "sv1515_enableforcedlogoff", r->sv1515_enableforcedlogoff);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_SERVER_INFO_1516(struct ndr_push *ndr, int ndr_flags, const struct SERVER_INFO_1516 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 1));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->sv1516_timesource));
		NDR_CHECK(ndr_push_trailer_align(ndr, 1));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_SERVER_INFO_1516(struct ndr_pull *ndr, int ndr_flags, struct SERVER_INFO_1516 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 1));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->sv1516_timesource));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 1));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_SERVER_INFO_1516(struct ndr_print *ndr, const char *name, const struct SERVER_INFO_1516 *r)
{
	ndr_print_struct(ndr, name, "SERVER_INFO_1516");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint8(ndr, "sv1516_timesource", r->sv1516_timesource);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_SERVER_INFO_1518(struct ndr_push *ndr, int ndr_flags, const struct SERVER_INFO_1518 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 1));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->sv1518_lmannounce));
		NDR_CHECK(ndr_push_trailer_align(ndr, 1));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_SERVER_INFO_1518(struct ndr_pull *ndr, int ndr_flags, struct SERVER_INFO_1518 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 1));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->sv1518_lmannounce));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 1));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_SERVER_INFO_1518(struct ndr_print *ndr, const char *name, const struct SERVER_INFO_1518 *r)
{
	ndr_print_struct(ndr, name, "SERVER_INFO_1518");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint8(ndr, "sv1518_lmannounce", r->sv1518_lmannounce);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_SERVER_INFO_1520(struct ndr_push *ndr, int ndr_flags, const struct SERVER_INFO_1520 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv1520_maxcopyreadlen));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_SERVER_INFO_1520(struct ndr_pull *ndr, int ndr_flags, struct SERVER_INFO_1520 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv1520_maxcopyreadlen));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_SERVER_INFO_1520(struct ndr_print *ndr, const char *name, const struct SERVER_INFO_1520 *r)
{
	ndr_print_struct(ndr, name, "SERVER_INFO_1520");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "sv1520_maxcopyreadlen", r->sv1520_maxcopyreadlen);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_SERVER_INFO_1521(struct ndr_push *ndr, int ndr_flags, const struct SERVER_INFO_1521 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv1521_maxcopywritelen));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_SERVER_INFO_1521(struct ndr_pull *ndr, int ndr_flags, struct SERVER_INFO_1521 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv1521_maxcopywritelen));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_SERVER_INFO_1521(struct ndr_print *ndr, const char *name, const struct SERVER_INFO_1521 *r)
{
	ndr_print_struct(ndr, name, "SERVER_INFO_1521");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "sv1521_maxcopywritelen", r->sv1521_maxcopywritelen);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_SERVER_INFO_1522(struct ndr_push *ndr, int ndr_flags, const struct SERVER_INFO_1522 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv1522_minkeepsearch));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_SERVER_INFO_1522(struct ndr_pull *ndr, int ndr_flags, struct SERVER_INFO_1522 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv1522_minkeepsearch));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_SERVER_INFO_1522(struct ndr_print *ndr, const char *name, const struct SERVER_INFO_1522 *r)
{
	ndr_print_struct(ndr, name, "SERVER_INFO_1522");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "sv1522_minkeepsearch", r->sv1522_minkeepsearch);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_SERVER_INFO_1523(struct ndr_push *ndr, int ndr_flags, const struct SERVER_INFO_1523 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv1523_maxkeepsearch));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_SERVER_INFO_1523(struct ndr_pull *ndr, int ndr_flags, struct SERVER_INFO_1523 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv1523_maxkeepsearch));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_SERVER_INFO_1523(struct ndr_print *ndr, const char *name, const struct SERVER_INFO_1523 *r)
{
	ndr_print_struct(ndr, name, "SERVER_INFO_1523");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "sv1523_maxkeepsearch", r->sv1523_maxkeepsearch);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_SERVER_INFO_1524(struct ndr_push *ndr, int ndr_flags, const struct SERVER_INFO_1524 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv1524_minkeepcomplsearch));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_SERVER_INFO_1524(struct ndr_pull *ndr, int ndr_flags, struct SERVER_INFO_1524 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv1524_minkeepcomplsearch));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_SERVER_INFO_1524(struct ndr_print *ndr, const char *name, const struct SERVER_INFO_1524 *r)
{
	ndr_print_struct(ndr, name, "SERVER_INFO_1524");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "sv1524_minkeepcomplsearch", r->sv1524_minkeepcomplsearch);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_SERVER_INFO_1525(struct ndr_push *ndr, int ndr_flags, const struct SERVER_INFO_1525 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv1525_maxkeepcomplsearch));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_SERVER_INFO_1525(struct ndr_pull *ndr, int ndr_flags, struct SERVER_INFO_1525 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv1525_maxkeepcomplsearch));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_SERVER_INFO_1525(struct ndr_print *ndr, const char *name, const struct SERVER_INFO_1525 *r)
{
	ndr_print_struct(ndr, name, "SERVER_INFO_1525");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "sv1525_maxkeepcomplsearch", r->sv1525_maxkeepcomplsearch);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_SERVER_INFO_1528(struct ndr_push *ndr, int ndr_flags, const struct SERVER_INFO_1528 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv1528_scavtimeout));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_SERVER_INFO_1528(struct ndr_pull *ndr, int ndr_flags, struct SERVER_INFO_1528 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv1528_scavtimeout));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_SERVER_INFO_1528(struct ndr_print *ndr, const char *name, const struct SERVER_INFO_1528 *r)
{
	ndr_print_struct(ndr, name, "SERVER_INFO_1528");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "sv1528_scavtimeout", r->sv1528_scavtimeout);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_SERVER_INFO_1529(struct ndr_push *ndr, int ndr_flags, const struct SERVER_INFO_1529 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv1529_minrcvqueue));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_SERVER_INFO_1529(struct ndr_pull *ndr, int ndr_flags, struct SERVER_INFO_1529 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv1529_minrcvqueue));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_SERVER_INFO_1529(struct ndr_print *ndr, const char *name, const struct SERVER_INFO_1529 *r)
{
	ndr_print_struct(ndr, name, "SERVER_INFO_1529");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "sv1529_minrcvqueue", r->sv1529_minrcvqueue);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_SERVER_INFO_1530(struct ndr_push *ndr, int ndr_flags, const struct SERVER_INFO_1530 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv1530_minfreeworkitems));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_SERVER_INFO_1530(struct ndr_pull *ndr, int ndr_flags, struct SERVER_INFO_1530 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv1530_minfreeworkitems));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_SERVER_INFO_1530(struct ndr_print *ndr, const char *name, const struct SERVER_INFO_1530 *r)
{
	ndr_print_struct(ndr, name, "SERVER_INFO_1530");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "sv1530_minfreeworkitems", r->sv1530_minfreeworkitems);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_SERVER_INFO_1533(struct ndr_push *ndr, int ndr_flags, const struct SERVER_INFO_1533 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv1533_maxmpxct));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_SERVER_INFO_1533(struct ndr_pull *ndr, int ndr_flags, struct SERVER_INFO_1533 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv1533_maxmpxct));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_SERVER_INFO_1533(struct ndr_print *ndr, const char *name, const struct SERVER_INFO_1533 *r)
{
	ndr_print_struct(ndr, name, "SERVER_INFO_1533");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "sv1533_maxmpxct", r->sv1533_maxmpxct);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_SERVER_INFO_1534(struct ndr_push *ndr, int ndr_flags, const struct SERVER_INFO_1534 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv1534_oplockbreakwait));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_SERVER_INFO_1534(struct ndr_pull *ndr, int ndr_flags, struct SERVER_INFO_1534 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv1534_oplockbreakwait));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_SERVER_INFO_1534(struct ndr_print *ndr, const char *name, const struct SERVER_INFO_1534 *r)
{
	ndr_print_struct(ndr, name, "SERVER_INFO_1534");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "sv1534_oplockbreakwait", r->sv1534_oplockbreakwait);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_SERVER_INFO_1535(struct ndr_push *ndr, int ndr_flags, const struct SERVER_INFO_1535 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv1535_oplockbreakresponsewait));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_SERVER_INFO_1535(struct ndr_pull *ndr, int ndr_flags, struct SERVER_INFO_1535 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv1535_oplockbreakresponsewait));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_SERVER_INFO_1535(struct ndr_print *ndr, const char *name, const struct SERVER_INFO_1535 *r)
{
	ndr_print_struct(ndr, name, "SERVER_INFO_1535");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "sv1535_oplockbreakresponsewait", r->sv1535_oplockbreakresponsewait);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_SERVER_INFO_1536(struct ndr_push *ndr, int ndr_flags, const struct SERVER_INFO_1536 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 1));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->sv1536_enableoplocks));
		NDR_CHECK(ndr_push_trailer_align(ndr, 1));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_SERVER_INFO_1536(struct ndr_pull *ndr, int ndr_flags, struct SERVER_INFO_1536 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 1));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->sv1536_enableoplocks));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 1));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_SERVER_INFO_1536(struct ndr_print *ndr, const char *name, const struct SERVER_INFO_1536 *r)
{
	ndr_print_struct(ndr, name, "SERVER_INFO_1536");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint8(ndr, "sv1536_enableoplocks", r->sv1536_enableoplocks);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_SERVER_INFO_1537(struct ndr_push *ndr, int ndr_flags, const struct SERVER_INFO_1537 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 1));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->sv1537_enableoplockforceclose));
		NDR_CHECK(ndr_push_trailer_align(ndr, 1));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_SERVER_INFO_1537(struct ndr_pull *ndr, int ndr_flags, struct SERVER_INFO_1537 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 1));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->sv1537_enableoplockforceclose));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 1));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_SERVER_INFO_1537(struct ndr_print *ndr, const char *name, const struct SERVER_INFO_1537 *r)
{
	ndr_print_struct(ndr, name, "SERVER_INFO_1537");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint8(ndr, "sv1537_enableoplockforceclose", r->sv1537_enableoplockforceclose);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_SERVER_INFO_1538(struct ndr_push *ndr, int ndr_flags, const struct SERVER_INFO_1538 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 1));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->sv1538_enablefcbopens));
		NDR_CHECK(ndr_push_trailer_align(ndr, 1));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_SERVER_INFO_1538(struct ndr_pull *ndr, int ndr_flags, struct SERVER_INFO_1538 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 1));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->sv1538_enablefcbopens));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 1));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_SERVER_INFO_1538(struct ndr_print *ndr, const char *name, const struct SERVER_INFO_1538 *r)
{
	ndr_print_struct(ndr, name, "SERVER_INFO_1538");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint8(ndr, "sv1538_enablefcbopens", r->sv1538_enablefcbopens);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_SERVER_INFO_1539(struct ndr_push *ndr, int ndr_flags, const struct SERVER_INFO_1539 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 1));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->sv1539_enableraw));
		NDR_CHECK(ndr_push_trailer_align(ndr, 1));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_SERVER_INFO_1539(struct ndr_pull *ndr, int ndr_flags, struct SERVER_INFO_1539 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 1));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->sv1539_enableraw));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 1));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_SERVER_INFO_1539(struct ndr_print *ndr, const char *name, const struct SERVER_INFO_1539 *r)
{
	ndr_print_struct(ndr, name, "SERVER_INFO_1539");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint8(ndr, "sv1539_enableraw", r->sv1539_enableraw);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_SERVER_INFO_1540(struct ndr_push *ndr, int ndr_flags, const struct SERVER_INFO_1540 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 1));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->sv1540_enablesharednetdrives));
		NDR_CHECK(ndr_push_trailer_align(ndr, 1));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_SERVER_INFO_1540(struct ndr_pull *ndr, int ndr_flags, struct SERVER_INFO_1540 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 1));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->sv1540_enablesharednetdrives));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 1));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_SERVER_INFO_1540(struct ndr_print *ndr, const char *name, const struct SERVER_INFO_1540 *r)
{
	ndr_print_struct(ndr, name, "SERVER_INFO_1540");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint8(ndr, "sv1540_enablesharednetdrives", r->sv1540_enablesharednetdrives);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_SERVER_INFO_1541(struct ndr_push *ndr, int ndr_flags, const struct SERVER_INFO_1541 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 1));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->sv1541_minfreeconnections));
		NDR_CHECK(ndr_push_trailer_align(ndr, 1));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_SERVER_INFO_1541(struct ndr_pull *ndr, int ndr_flags, struct SERVER_INFO_1541 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 1));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->sv1541_minfreeconnections));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 1));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_SERVER_INFO_1541(struct ndr_print *ndr, const char *name, const struct SERVER_INFO_1541 *r)
{
	ndr_print_struct(ndr, name, "SERVER_INFO_1541");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint8(ndr, "sv1541_minfreeconnections", r->sv1541_minfreeconnections);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_SERVER_INFO_1542(struct ndr_push *ndr, int ndr_flags, const struct SERVER_INFO_1542 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 1));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->sv1542_maxfreeconnections));
		NDR_CHECK(ndr_push_trailer_align(ndr, 1));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_SERVER_INFO_1542(struct ndr_pull *ndr, int ndr_flags, struct SERVER_INFO_1542 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 1));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->sv1542_maxfreeconnections));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 1));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_SERVER_INFO_1542(struct ndr_print *ndr, const char *name, const struct SERVER_INFO_1542 *r)
{
	ndr_print_struct(ndr, name, "SERVER_INFO_1542");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint8(ndr, "sv1542_maxfreeconnections", r->sv1542_maxfreeconnections);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_SERVER_INFO_1543(struct ndr_push *ndr, int ndr_flags, const struct SERVER_INFO_1543 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv1543_initsesstable));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_SERVER_INFO_1543(struct ndr_pull *ndr, int ndr_flags, struct SERVER_INFO_1543 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv1543_initsesstable));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_SERVER_INFO_1543(struct ndr_print *ndr, const char *name, const struct SERVER_INFO_1543 *r)
{
	ndr_print_struct(ndr, name, "SERVER_INFO_1543");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "sv1543_initsesstable", r->sv1543_initsesstable);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_SERVER_INFO_1544(struct ndr_push *ndr, int ndr_flags, const struct SERVER_INFO_1544 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv1544_initconntable));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_SERVER_INFO_1544(struct ndr_pull *ndr, int ndr_flags, struct SERVER_INFO_1544 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv1544_initconntable));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_SERVER_INFO_1544(struct ndr_print *ndr, const char *name, const struct SERVER_INFO_1544 *r)
{
	ndr_print_struct(ndr, name, "SERVER_INFO_1544");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "sv1544_initconntable", r->sv1544_initconntable);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_SERVER_INFO_1545(struct ndr_push *ndr, int ndr_flags, const struct SERVER_INFO_1545 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv1545_initfiletable));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_SERVER_INFO_1545(struct ndr_pull *ndr, int ndr_flags, struct SERVER_INFO_1545 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv1545_initfiletable));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_SERVER_INFO_1545(struct ndr_print *ndr, const char *name, const struct SERVER_INFO_1545 *r)
{
	ndr_print_struct(ndr, name, "SERVER_INFO_1545");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "sv1545_initfiletable", r->sv1545_initfiletable);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_SERVER_INFO_1546(struct ndr_push *ndr, int ndr_flags, const struct SERVER_INFO_1546 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv1546_initsearchtable));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_SERVER_INFO_1546(struct ndr_pull *ndr, int ndr_flags, struct SERVER_INFO_1546 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv1546_initsearchtable));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_SERVER_INFO_1546(struct ndr_print *ndr, const char *name, const struct SERVER_INFO_1546 *r)
{
	ndr_print_struct(ndr, name, "SERVER_INFO_1546");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "sv1546_initsearchtable", r->sv1546_initsearchtable);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_SERVER_INFO_1547(struct ndr_push *ndr, int ndr_flags, const struct SERVER_INFO_1547 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv1547_alertschedule));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_SERVER_INFO_1547(struct ndr_pull *ndr, int ndr_flags, struct SERVER_INFO_1547 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv1547_alertschedule));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_SERVER_INFO_1547(struct ndr_print *ndr, const char *name, const struct SERVER_INFO_1547 *r)
{
	ndr_print_struct(ndr, name, "SERVER_INFO_1547");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "sv1547_alertschedule", r->sv1547_alertschedule);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_SERVER_INFO_1548(struct ndr_push *ndr, int ndr_flags, const struct SERVER_INFO_1548 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv1548_errorthreshold));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_SERVER_INFO_1548(struct ndr_pull *ndr, int ndr_flags, struct SERVER_INFO_1548 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv1548_errorthreshold));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_SERVER_INFO_1548(struct ndr_print *ndr, const char *name, const struct SERVER_INFO_1548 *r)
{
	ndr_print_struct(ndr, name, "SERVER_INFO_1548");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "sv1548_errorthreshold", r->sv1548_errorthreshold);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_SERVER_INFO_1549(struct ndr_push *ndr, int ndr_flags, const struct SERVER_INFO_1549 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv1549_networkerrorthreshold));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_SERVER_INFO_1549(struct ndr_pull *ndr, int ndr_flags, struct SERVER_INFO_1549 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv1549_networkerrorthreshold));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_SERVER_INFO_1549(struct ndr_print *ndr, const char *name, const struct SERVER_INFO_1549 *r)
{
	ndr_print_struct(ndr, name, "SERVER_INFO_1549");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "sv1549_networkerrorthreshold", r->sv1549_networkerrorthreshold);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_SERVER_INFO_1550(struct ndr_push *ndr, int ndr_flags, const struct SERVER_INFO_1550 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv1550_diskspacethreshold));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_SERVER_INFO_1550(struct ndr_pull *ndr, int ndr_flags, struct SERVER_INFO_1550 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv1550_diskspacethreshold));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_SERVER_INFO_1550(struct ndr_print *ndr, const char *name, const struct SERVER_INFO_1550 *r)
{
	ndr_print_struct(ndr, name, "SERVER_INFO_1550");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "sv1550_diskspacethreshold", r->sv1550_diskspacethreshold);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_SERVER_INFO_1552(struct ndr_push *ndr, int ndr_flags, const struct SERVER_INFO_1552 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv1552_maxlinkdelay));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_SERVER_INFO_1552(struct ndr_pull *ndr, int ndr_flags, struct SERVER_INFO_1552 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv1552_maxlinkdelay));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_SERVER_INFO_1552(struct ndr_print *ndr, const char *name, const struct SERVER_INFO_1552 *r)
{
	ndr_print_struct(ndr, name, "SERVER_INFO_1552");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "sv1552_maxlinkdelay", r->sv1552_maxlinkdelay);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_SERVER_INFO_1553(struct ndr_push *ndr, int ndr_flags, const struct SERVER_INFO_1553 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv1553_minlinkthroughput));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_SERVER_INFO_1553(struct ndr_pull *ndr, int ndr_flags, struct SERVER_INFO_1553 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv1553_minlinkthroughput));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_SERVER_INFO_1553(struct ndr_print *ndr, const char *name, const struct SERVER_INFO_1553 *r)
{
	ndr_print_struct(ndr, name, "SERVER_INFO_1553");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "sv1553_minlinkthroughput", r->sv1553_minlinkthroughput);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_SERVER_INFO_1554(struct ndr_push *ndr, int ndr_flags, const struct SERVER_INFO_1554 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv1554_linkinfovalidtime));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_SERVER_INFO_1554(struct ndr_pull *ndr, int ndr_flags, struct SERVER_INFO_1554 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv1554_linkinfovalidtime));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_SERVER_INFO_1554(struct ndr_print *ndr, const char *name, const struct SERVER_INFO_1554 *r)
{
	ndr_print_struct(ndr, name, "SERVER_INFO_1554");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "sv1554_linkinfovalidtime", r->sv1554_linkinfovalidtime);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_SERVER_INFO_1555(struct ndr_push *ndr, int ndr_flags, const struct SERVER_INFO_1555 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv1555_scavqosinfoupdatetime));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_SERVER_INFO_1555(struct ndr_pull *ndr, int ndr_flags, struct SERVER_INFO_1555 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv1555_scavqosinfoupdatetime));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_SERVER_INFO_1555(struct ndr_print *ndr, const char *name, const struct SERVER_INFO_1555 *r)
{
	ndr_print_struct(ndr, name, "SERVER_INFO_1555");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "sv1555_scavqosinfoupdatetime", r->sv1555_scavqosinfoupdatetime);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_SERVER_INFO_1556(struct ndr_push *ndr, int ndr_flags, const struct SERVER_INFO_1556 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv1556_maxworkitemidletime));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_SERVER_INFO_1556(struct ndr_pull *ndr, int ndr_flags, struct SERVER_INFO_1556 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv1556_maxworkitemidletime));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_SERVER_INFO_1556(struct ndr_print *ndr, const char *name, const struct SERVER_INFO_1556 *r)
{
	ndr_print_struct(ndr, name, "SERVER_INFO_1556");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "sv1556_maxworkitemidletime", r->sv1556_maxworkitemidletime);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_SERVER_INFO_1557(struct ndr_push *ndr, int ndr_flags, const struct SERVER_INFO_1557 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv1557_maxrawworkitems));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_SERVER_INFO_1557(struct ndr_pull *ndr, int ndr_flags, struct SERVER_INFO_1557 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv1557_maxrawworkitems));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_SERVER_INFO_1557(struct ndr_print *ndr, const char *name, const struct SERVER_INFO_1557 *r)
{
	ndr_print_struct(ndr, name, "SERVER_INFO_1557");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "sv1557_maxrawworkitems", r->sv1557_maxrawworkitems);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_SERVER_INFO_1560(struct ndr_push *ndr, int ndr_flags, const struct SERVER_INFO_1560 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv1560_producttype));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_SERVER_INFO_1560(struct ndr_pull *ndr, int ndr_flags, struct SERVER_INFO_1560 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv1560_producttype));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_SERVER_INFO_1560(struct ndr_print *ndr, const char *name, const struct SERVER_INFO_1560 *r)
{
	ndr_print_struct(ndr, name, "SERVER_INFO_1560");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "sv1560_producttype", r->sv1560_producttype);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_SERVER_INFO_1561(struct ndr_push *ndr, int ndr_flags, const struct SERVER_INFO_1561 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv1561_serversize));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_SERVER_INFO_1561(struct ndr_pull *ndr, int ndr_flags, struct SERVER_INFO_1561 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv1561_serversize));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_SERVER_INFO_1561(struct ndr_print *ndr, const char *name, const struct SERVER_INFO_1561 *r)
{
	ndr_print_struct(ndr, name, "SERVER_INFO_1561");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "sv1561_serversize", r->sv1561_serversize);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_SERVER_INFO_1562(struct ndr_push *ndr, int ndr_flags, const struct SERVER_INFO_1562 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv1562_connectionlessautodisc));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_SERVER_INFO_1562(struct ndr_pull *ndr, int ndr_flags, struct SERVER_INFO_1562 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv1562_connectionlessautodisc));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_SERVER_INFO_1562(struct ndr_print *ndr, const char *name, const struct SERVER_INFO_1562 *r)
{
	ndr_print_struct(ndr, name, "SERVER_INFO_1562");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "sv1562_connectionlessautodisc", r->sv1562_connectionlessautodisc);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_SERVER_INFO_1563(struct ndr_push *ndr, int ndr_flags, const struct SERVER_INFO_1563 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv1563_sharingviolationretries));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_SERVER_INFO_1563(struct ndr_pull *ndr, int ndr_flags, struct SERVER_INFO_1563 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv1563_sharingviolationretries));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_SERVER_INFO_1563(struct ndr_print *ndr, const char *name, const struct SERVER_INFO_1563 *r)
{
	ndr_print_struct(ndr, name, "SERVER_INFO_1563");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "sv1563_sharingviolationretries", r->sv1563_sharingviolationretries);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_SERVER_INFO_1564(struct ndr_push *ndr, int ndr_flags, const struct SERVER_INFO_1564 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv1564_sharingviolationdelay));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_SERVER_INFO_1564(struct ndr_pull *ndr, int ndr_flags, struct SERVER_INFO_1564 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv1564_sharingviolationdelay));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_SERVER_INFO_1564(struct ndr_print *ndr, const char *name, const struct SERVER_INFO_1564 *r)
{
	ndr_print_struct(ndr, name, "SERVER_INFO_1564");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "sv1564_sharingviolationdelay", r->sv1564_sharingviolationdelay);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_SERVER_INFO_1565(struct ndr_push *ndr, int ndr_flags, const struct SERVER_INFO_1565 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv1565_maxglobalopensearch));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_SERVER_INFO_1565(struct ndr_pull *ndr, int ndr_flags, struct SERVER_INFO_1565 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv1565_maxglobalopensearch));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_SERVER_INFO_1565(struct ndr_print *ndr, const char *name, const struct SERVER_INFO_1565 *r)
{
	ndr_print_struct(ndr, name, "SERVER_INFO_1565");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "sv1565_maxglobalopensearch", r->sv1565_maxglobalopensearch);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_SERVER_INFO_1566(struct ndr_push *ndr, int ndr_flags, const struct SERVER_INFO_1566 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 1));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->sv1566_removeduplicatesearches));
		NDR_CHECK(ndr_push_trailer_align(ndr, 1));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_SERVER_INFO_1566(struct ndr_pull *ndr, int ndr_flags, struct SERVER_INFO_1566 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 1));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->sv1566_removeduplicatesearches));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 1));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_SERVER_INFO_1566(struct ndr_print *ndr, const char *name, const struct SERVER_INFO_1566 *r)
{
	ndr_print_struct(ndr, name, "SERVER_INFO_1566");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint8(ndr, "sv1566_removeduplicatesearches", r->sv1566_removeduplicatesearches);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_SERVER_INFO_1567(struct ndr_push *ndr, int ndr_flags, const struct SERVER_INFO_1567 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv1567_lockviolationretries));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_SERVER_INFO_1567(struct ndr_pull *ndr, int ndr_flags, struct SERVER_INFO_1567 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv1567_lockviolationretries));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_SERVER_INFO_1567(struct ndr_print *ndr, const char *name, const struct SERVER_INFO_1567 *r)
{
	ndr_print_struct(ndr, name, "SERVER_INFO_1567");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "sv1567_lockviolationretries", r->sv1567_lockviolationretries);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_SERVER_INFO_1568(struct ndr_push *ndr, int ndr_flags, const struct SERVER_INFO_1568 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv1568_lockviolationoffset));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_SERVER_INFO_1568(struct ndr_pull *ndr, int ndr_flags, struct SERVER_INFO_1568 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv1568_lockviolationoffset));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_SERVER_INFO_1568(struct ndr_print *ndr, const char *name, const struct SERVER_INFO_1568 *r)
{
	ndr_print_struct(ndr, name, "SERVER_INFO_1568");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "sv1568_lockviolationoffset", r->sv1568_lockviolationoffset);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_SERVER_INFO_1569(struct ndr_push *ndr, int ndr_flags, const struct SERVER_INFO_1569 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv1569_lockviolationdelay));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_SERVER_INFO_1569(struct ndr_pull *ndr, int ndr_flags, struct SERVER_INFO_1569 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv1569_lockviolationdelay));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_SERVER_INFO_1569(struct ndr_print *ndr, const char *name, const struct SERVER_INFO_1569 *r)
{
	ndr_print_struct(ndr, name, "SERVER_INFO_1569");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "sv1569_lockviolationdelay", r->sv1569_lockviolationdelay);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_SERVER_INFO_1570(struct ndr_push *ndr, int ndr_flags, const struct SERVER_INFO_1570 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv1570_mdlreadswitchover));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_SERVER_INFO_1570(struct ndr_pull *ndr, int ndr_flags, struct SERVER_INFO_1570 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv1570_mdlreadswitchover));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_SERVER_INFO_1570(struct ndr_print *ndr, const char *name, const struct SERVER_INFO_1570 *r)
{
	ndr_print_struct(ndr, name, "SERVER_INFO_1570");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "sv1570_mdlreadswitchover", r->sv1570_mdlreadswitchover);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_SERVER_INFO_1571(struct ndr_push *ndr, int ndr_flags, const struct SERVER_INFO_1571 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv1571_cachedopenlimit));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_SERVER_INFO_1571(struct ndr_pull *ndr, int ndr_flags, struct SERVER_INFO_1571 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv1571_cachedopenlimit));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_SERVER_INFO_1571(struct ndr_print *ndr, const char *name, const struct SERVER_INFO_1571 *r)
{
	ndr_print_struct(ndr, name, "SERVER_INFO_1571");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "sv1571_cachedopenlimit", r->sv1571_cachedopenlimit);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_SERVER_INFO_1572(struct ndr_push *ndr, int ndr_flags, const struct SERVER_INFO_1572 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv1572_criticalthreads));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_SERVER_INFO_1572(struct ndr_pull *ndr, int ndr_flags, struct SERVER_INFO_1572 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv1572_criticalthreads));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_SERVER_INFO_1572(struct ndr_print *ndr, const char *name, const struct SERVER_INFO_1572 *r)
{
	ndr_print_struct(ndr, name, "SERVER_INFO_1572");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "sv1572_criticalthreads", r->sv1572_criticalthreads);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_SERVER_INFO_1573(struct ndr_push *ndr, int ndr_flags, const struct SERVER_INFO_1573 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv1573_restrictnullsessaccess));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_SERVER_INFO_1573(struct ndr_pull *ndr, int ndr_flags, struct SERVER_INFO_1573 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv1573_restrictnullsessaccess));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_SERVER_INFO_1573(struct ndr_print *ndr, const char *name, const struct SERVER_INFO_1573 *r)
{
	ndr_print_struct(ndr, name, "SERVER_INFO_1573");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "sv1573_restrictnullsessaccess", r->sv1573_restrictnullsessaccess);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_SERVER_INFO_1574(struct ndr_push *ndr, int ndr_flags, const struct SERVER_INFO_1574 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv1574_enablewfw311directipx));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_SERVER_INFO_1574(struct ndr_pull *ndr, int ndr_flags, struct SERVER_INFO_1574 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv1574_enablewfw311directipx));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_SERVER_INFO_1574(struct ndr_print *ndr, const char *name, const struct SERVER_INFO_1574 *r)
{
	ndr_print_struct(ndr, name, "SERVER_INFO_1574");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "sv1574_enablewfw311directipx", r->sv1574_enablewfw311directipx);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_SERVER_INFO_1575(struct ndr_push *ndr, int ndr_flags, const struct SERVER_INFO_1575 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv1575_otherqueueaffinity));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_SERVER_INFO_1575(struct ndr_pull *ndr, int ndr_flags, struct SERVER_INFO_1575 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv1575_otherqueueaffinity));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_SERVER_INFO_1575(struct ndr_print *ndr, const char *name, const struct SERVER_INFO_1575 *r)
{
	ndr_print_struct(ndr, name, "SERVER_INFO_1575");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "sv1575_otherqueueaffinity", r->sv1575_otherqueueaffinity);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_SERVER_INFO_1576(struct ndr_push *ndr, int ndr_flags, const struct SERVER_INFO_1576 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv1576_queuesamplesecs));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_SERVER_INFO_1576(struct ndr_pull *ndr, int ndr_flags, struct SERVER_INFO_1576 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv1576_queuesamplesecs));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_SERVER_INFO_1576(struct ndr_print *ndr, const char *name, const struct SERVER_INFO_1576 *r)
{
	ndr_print_struct(ndr, name, "SERVER_INFO_1576");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "sv1576_queuesamplesecs", r->sv1576_queuesamplesecs);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_SERVER_INFO_1577(struct ndr_push *ndr, int ndr_flags, const struct SERVER_INFO_1577 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv1577_balancecount));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_SERVER_INFO_1577(struct ndr_pull *ndr, int ndr_flags, struct SERVER_INFO_1577 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv1577_balancecount));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_SERVER_INFO_1577(struct ndr_print *ndr, const char *name, const struct SERVER_INFO_1577 *r)
{
	ndr_print_struct(ndr, name, "SERVER_INFO_1577");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "sv1577_balancecount", r->sv1577_balancecount);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_SERVER_INFO_1578(struct ndr_push *ndr, int ndr_flags, const struct SERVER_INFO_1578 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv1578_preferredaffinity));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_SERVER_INFO_1578(struct ndr_pull *ndr, int ndr_flags, struct SERVER_INFO_1578 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv1578_preferredaffinity));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_SERVER_INFO_1578(struct ndr_print *ndr, const char *name, const struct SERVER_INFO_1578 *r)
{
	ndr_print_struct(ndr, name, "SERVER_INFO_1578");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "sv1578_preferredaffinity", r->sv1578_preferredaffinity);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_SERVER_INFO_1579(struct ndr_push *ndr, int ndr_flags, const struct SERVER_INFO_1579 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv1579_maxfreerfcbs));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_SERVER_INFO_1579(struct ndr_pull *ndr, int ndr_flags, struct SERVER_INFO_1579 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv1579_maxfreerfcbs));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_SERVER_INFO_1579(struct ndr_print *ndr, const char *name, const struct SERVER_INFO_1579 *r)
{
	ndr_print_struct(ndr, name, "SERVER_INFO_1579");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "sv1579_maxfreerfcbs", r->sv1579_maxfreerfcbs);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_SERVER_INFO_1580(struct ndr_push *ndr, int ndr_flags, const struct SERVER_INFO_1580 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv1580_maxfreemfcbs));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_SERVER_INFO_1580(struct ndr_pull *ndr, int ndr_flags, struct SERVER_INFO_1580 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv1580_maxfreemfcbs));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_SERVER_INFO_1580(struct ndr_print *ndr, const char *name, const struct SERVER_INFO_1580 *r)
{
	ndr_print_struct(ndr, name, "SERVER_INFO_1580");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "sv1580_maxfreemfcbs", r->sv1580_maxfreemfcbs);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_SERVER_INFO_1581(struct ndr_push *ndr, int ndr_flags, const struct SERVER_INFO_1581 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv1581_maxfreemlcbs));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_SERVER_INFO_1581(struct ndr_pull *ndr, int ndr_flags, struct SERVER_INFO_1581 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv1581_maxfreemlcbs));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_SERVER_INFO_1581(struct ndr_print *ndr, const char *name, const struct SERVER_INFO_1581 *r)
{
	ndr_print_struct(ndr, name, "SERVER_INFO_1581");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "sv1581_maxfreemlcbs", r->sv1581_maxfreemlcbs);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_SERVER_INFO_1582(struct ndr_push *ndr, int ndr_flags, const struct SERVER_INFO_1582 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv1582_maxfreepagedpoolchunks));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_SERVER_INFO_1582(struct ndr_pull *ndr, int ndr_flags, struct SERVER_INFO_1582 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv1582_maxfreepagedpoolchunks));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_SERVER_INFO_1582(struct ndr_print *ndr, const char *name, const struct SERVER_INFO_1582 *r)
{
	ndr_print_struct(ndr, name, "SERVER_INFO_1582");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "sv1582_maxfreepagedpoolchunks", r->sv1582_maxfreepagedpoolchunks);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_SERVER_INFO_1583(struct ndr_push *ndr, int ndr_flags, const struct SERVER_INFO_1583 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv1583_minpagedpoolchunksize));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_SERVER_INFO_1583(struct ndr_pull *ndr, int ndr_flags, struct SERVER_INFO_1583 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv1583_minpagedpoolchunksize));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_SERVER_INFO_1583(struct ndr_print *ndr, const char *name, const struct SERVER_INFO_1583 *r)
{
	ndr_print_struct(ndr, name, "SERVER_INFO_1583");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "sv1583_minpagedpoolchunksize", r->sv1583_minpagedpoolchunksize);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_SERVER_INFO_1584(struct ndr_push *ndr, int ndr_flags, const struct SERVER_INFO_1584 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv1584_maxpagedpoolchunksize));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_SERVER_INFO_1584(struct ndr_pull *ndr, int ndr_flags, struct SERVER_INFO_1584 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv1584_maxpagedpoolchunksize));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_SERVER_INFO_1584(struct ndr_print *ndr, const char *name, const struct SERVER_INFO_1584 *r)
{
	ndr_print_struct(ndr, name, "SERVER_INFO_1584");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "sv1584_maxpagedpoolchunksize", r->sv1584_maxpagedpoolchunksize);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_SERVER_INFO_1585(struct ndr_push *ndr, int ndr_flags, const struct SERVER_INFO_1585 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 1));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->sv1585_sendsfrompreferredprocessor));
		NDR_CHECK(ndr_push_trailer_align(ndr, 1));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_SERVER_INFO_1585(struct ndr_pull *ndr, int ndr_flags, struct SERVER_INFO_1585 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 1));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->sv1585_sendsfrompreferredprocessor));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 1));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_SERVER_INFO_1585(struct ndr_print *ndr, const char *name, const struct SERVER_INFO_1585 *r)
{
	ndr_print_struct(ndr, name, "SERVER_INFO_1585");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint8(ndr, "sv1585_sendsfrompreferredprocessor", r->sv1585_sendsfrompreferredprocessor);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_SERVER_INFO_1586(struct ndr_push *ndr, int ndr_flags, const struct SERVER_INFO_1586 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv1586_maxthreadsperqueue));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_SERVER_INFO_1586(struct ndr_pull *ndr, int ndr_flags, struct SERVER_INFO_1586 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv1586_maxthreadsperqueue));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_SERVER_INFO_1586(struct ndr_print *ndr, const char *name, const struct SERVER_INFO_1586 *r)
{
	ndr_print_struct(ndr, name, "SERVER_INFO_1586");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "sv1586_maxthreadsperqueue", r->sv1586_maxthreadsperqueue);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_SERVER_INFO_1587(struct ndr_push *ndr, int ndr_flags, const struct SERVER_INFO_1587 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv1587_cacheddirectorylimit));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_SERVER_INFO_1587(struct ndr_pull *ndr, int ndr_flags, struct SERVER_INFO_1587 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv1587_cacheddirectorylimit));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_SERVER_INFO_1587(struct ndr_print *ndr, const char *name, const struct SERVER_INFO_1587 *r)
{
	ndr_print_struct(ndr, name, "SERVER_INFO_1587");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "sv1587_cacheddirectorylimit", r->sv1587_cacheddirectorylimit);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_SERVER_INFO_1588(struct ndr_push *ndr, int ndr_flags, const struct SERVER_INFO_1588 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv1588_maxcopylength));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_SERVER_INFO_1588(struct ndr_pull *ndr, int ndr_flags, struct SERVER_INFO_1588 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv1588_maxcopylength));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_SERVER_INFO_1588(struct ndr_print *ndr, const char *name, const struct SERVER_INFO_1588 *r)
{
	ndr_print_struct(ndr, name, "SERVER_INFO_1588");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "sv1588_maxcopylength", r->sv1588_maxcopylength);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_SERVER_INFO_1590(struct ndr_push *ndr, int ndr_flags, const struct SERVER_INFO_1590 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv1590_enablecompression));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_SERVER_INFO_1590(struct ndr_pull *ndr, int ndr_flags, struct SERVER_INFO_1590 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv1590_enablecompression));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_SERVER_INFO_1590(struct ndr_print *ndr, const char *name, const struct SERVER_INFO_1590 *r)
{
	ndr_print_struct(ndr, name, "SERVER_INFO_1590");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "sv1590_enablecompression", r->sv1590_enablecompression);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_SERVER_INFO_1591(struct ndr_push *ndr, int ndr_flags, const struct SERVER_INFO_1591 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv1591_autosharewks));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_SERVER_INFO_1591(struct ndr_pull *ndr, int ndr_flags, struct SERVER_INFO_1591 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv1591_autosharewks));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_SERVER_INFO_1591(struct ndr_print *ndr, const char *name, const struct SERVER_INFO_1591 *r)
{
	ndr_print_struct(ndr, name, "SERVER_INFO_1591");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "sv1591_autosharewks", r->sv1591_autosharewks);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_SERVER_INFO_1592(struct ndr_push *ndr, int ndr_flags, const struct SERVER_INFO_1592 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv1592_autosharewks));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_SERVER_INFO_1592(struct ndr_pull *ndr, int ndr_flags, struct SERVER_INFO_1592 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv1592_autosharewks));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_SERVER_INFO_1592(struct ndr_print *ndr, const char *name, const struct SERVER_INFO_1592 *r)
{
	ndr_print_struct(ndr, name, "SERVER_INFO_1592");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "sv1592_autosharewks", r->sv1592_autosharewks);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_SERVER_INFO_1593(struct ndr_push *ndr, int ndr_flags, const struct SERVER_INFO_1593 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv1593_enablesecuritysignature));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_SERVER_INFO_1593(struct ndr_pull *ndr, int ndr_flags, struct SERVER_INFO_1593 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv1593_enablesecuritysignature));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_SERVER_INFO_1593(struct ndr_print *ndr, const char *name, const struct SERVER_INFO_1593 *r)
{
	ndr_print_struct(ndr, name, "SERVER_INFO_1593");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "sv1593_enablesecuritysignature", r->sv1593_enablesecuritysignature);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_SERVER_INFO_1594(struct ndr_push *ndr, int ndr_flags, const struct SERVER_INFO_1594 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv1594_requiresecuritysignature));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_SERVER_INFO_1594(struct ndr_pull *ndr, int ndr_flags, struct SERVER_INFO_1594 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv1594_requiresecuritysignature));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_SERVER_INFO_1594(struct ndr_print *ndr, const char *name, const struct SERVER_INFO_1594 *r)
{
	ndr_print_struct(ndr, name, "SERVER_INFO_1594");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "sv1594_requiresecuritysignature", r->sv1594_requiresecuritysignature);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_SERVER_INFO_1595(struct ndr_push *ndr, int ndr_flags, const struct SERVER_INFO_1595 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv1595_minclientbuffersize));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_SERVER_INFO_1595(struct ndr_pull *ndr, int ndr_flags, struct SERVER_INFO_1595 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv1595_minclientbuffersize));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_SERVER_INFO_1595(struct ndr_print *ndr, const char *name, const struct SERVER_INFO_1595 *r)
{
	ndr_print_struct(ndr, name, "SERVER_INFO_1595");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "sv1595_minclientbuffersize", r->sv1595_minclientbuffersize);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_SERVER_INFO_1596(struct ndr_push *ndr, int ndr_flags, const struct SERVER_INFO_1596 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv1596_ConnectionNoSessionsTimeout));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_SERVER_INFO_1596(struct ndr_pull *ndr, int ndr_flags, struct SERVER_INFO_1596 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv1596_ConnectionNoSessionsTimeout));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_SERVER_INFO_1596(struct ndr_print *ndr, const char *name, const struct SERVER_INFO_1596 *r)
{
	ndr_print_struct(ndr, name, "SERVER_INFO_1596");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "sv1596_ConnectionNoSessionsTimeout", r->sv1596_ConnectionNoSessionsTimeout);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_SERVER_INFO_1597(struct ndr_push *ndr, int ndr_flags, const struct SERVER_INFO_1597 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv1597_IdleThreadTimeOut));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_SERVER_INFO_1597(struct ndr_pull *ndr, int ndr_flags, struct SERVER_INFO_1597 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv1597_IdleThreadTimeOut));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_SERVER_INFO_1597(struct ndr_print *ndr, const char *name, const struct SERVER_INFO_1597 *r)
{
	ndr_print_struct(ndr, name, "SERVER_INFO_1597");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "sv1597_IdleThreadTimeOut", r->sv1597_IdleThreadTimeOut);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_SERVER_INFO_1598(struct ndr_push *ndr, int ndr_flags, const struct SERVER_INFO_1598 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv1598_enableW9xsecuritysignature));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_SERVER_INFO_1598(struct ndr_pull *ndr, int ndr_flags, struct SERVER_INFO_1598 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv1598_enableW9xsecuritysignature));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_SERVER_INFO_1598(struct ndr_print *ndr, const char *name, const struct SERVER_INFO_1598 *r)
{
	ndr_print_struct(ndr, name, "SERVER_INFO_1598");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "sv1598_enableW9xsecuritysignature", r->sv1598_enableW9xsecuritysignature);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_SERVER_INFO_1599(struct ndr_push *ndr, int ndr_flags, const struct SERVER_INFO_1599 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 1));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->sv1598_enforcekerberosreauthentication));
		NDR_CHECK(ndr_push_trailer_align(ndr, 1));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_SERVER_INFO_1599(struct ndr_pull *ndr, int ndr_flags, struct SERVER_INFO_1599 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 1));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->sv1598_enforcekerberosreauthentication));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 1));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_SERVER_INFO_1599(struct ndr_print *ndr, const char *name, const struct SERVER_INFO_1599 *r)
{
	ndr_print_struct(ndr, name, "SERVER_INFO_1599");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint8(ndr, "sv1598_enforcekerberosreauthentication", r->sv1598_enforcekerberosreauthentication);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_SERVER_INFO_1600(struct ndr_push *ndr, int ndr_flags, const struct SERVER_INFO_1600 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 1));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->sv1598_disabledos));
		NDR_CHECK(ndr_push_trailer_align(ndr, 1));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_SERVER_INFO_1600(struct ndr_pull *ndr, int ndr_flags, struct SERVER_INFO_1600 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 1));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->sv1598_disabledos));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 1));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_SERVER_INFO_1600(struct ndr_print *ndr, const char *name, const struct SERVER_INFO_1600 *r)
{
	ndr_print_struct(ndr, name, "SERVER_INFO_1600");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint8(ndr, "sv1598_disabledos", r->sv1598_disabledos);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_SERVER_INFO_1601(struct ndr_push *ndr, int ndr_flags, const struct SERVER_INFO_1601 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv1598_lowdiskspaceminimum));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_SERVER_INFO_1601(struct ndr_pull *ndr, int ndr_flags, struct SERVER_INFO_1601 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv1598_lowdiskspaceminimum));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_SERVER_INFO_1601(struct ndr_print *ndr, const char *name, const struct SERVER_INFO_1601 *r)
{
	ndr_print_struct(ndr, name, "SERVER_INFO_1601");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "sv1598_lowdiskspaceminimum", r->sv1598_lowdiskspaceminimum);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_SERVER_INFO_1602(struct ndr_push *ndr, int ndr_flags, const struct SERVER_INFO_1602 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 1));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->sv_1598_disablestrictnamechecking));
		NDR_CHECK(ndr_push_trailer_align(ndr, 1));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_SERVER_INFO_1602(struct ndr_pull *ndr, int ndr_flags, struct SERVER_INFO_1602 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 1));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->sv_1598_disablestrictnamechecking));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 1));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_SERVER_INFO_1602(struct ndr_print *ndr, const char *name, const struct SERVER_INFO_1602 *r)
{
	ndr_print_struct(ndr, name, "SERVER_INFO_1602");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint8(ndr, "sv_1598_disablestrictnamechecking", r->sv_1598_disablestrictnamechecking);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_DOMAIN_CONTROLLER_INFO_FLAGS(struct ndr_push *ndr, int ndr_flags, enum DOMAIN_CONTROLLER_INFO_FLAGS r)
{
	NDR_CHECK(ndr_push_enum_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_DOMAIN_CONTROLLER_INFO_FLAGS(struct ndr_pull *ndr, int ndr_flags, enum DOMAIN_CONTROLLER_INFO_FLAGS *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_enum_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_DOMAIN_CONTROLLER_INFO_FLAGS(struct ndr_print *ndr, const char *name, enum DOMAIN_CONTROLLER_INFO_FLAGS r)
{
	const char *val = NULL;

	switch (r) {
		case DS_PDC_FLAG: val = "DS_PDC_FLAG"; break;
		case DS_GC_FLAG: val = "DS_GC_FLAG"; break;
		case DS_LDAP_FLAG: val = "DS_LDAP_FLAG"; break;
		case DS_DS_FLAG: val = "DS_DS_FLAG"; break;
		case DS_KDC_FLAG: val = "DS_KDC_FLAG"; break;
		case DS_TIMESERV_FLAG: val = "DS_TIMESERV_FLAG"; break;
		case DS_CLOSEST_FLAG: val = "DS_CLOSEST_FLAG"; break;
		case DS_WRITABLE_FLAG: val = "DS_WRITABLE_FLAG"; break;
		case DS_GOOD_TIMESERV_FLAG: val = "DS_GOOD_TIMESERV_FLAG"; break;
		case DS_NDNC_FLAG: val = "DS_NDNC_FLAG"; break;
		case DS_SELECT_SECRET_DOMAIN_6_FLAG: val = "DS_SELECT_SECRET_DOMAIN_6_FLAG"; break;
		case DS_FULL_SECRET_DOMAIN_6_FLAG: val = "DS_FULL_SECRET_DOMAIN_6_FLAG"; break;
		case DS_DNS_CONTROLLER_FLAG: val = "DS_DNS_CONTROLLER_FLAG"; break;
		case DS_DNS_DOMAIN_FLAG: val = "DS_DNS_DOMAIN_FLAG"; break;
		case DS_DNS_FOREST_FLAG: val = "DS_DNS_FOREST_FLAG"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

_PUBLIC_ enum ndr_err_code ndr_push_DOMAIN_CONTROLLER_INFO(struct ndr_push *ndr, int ndr_flags, const struct DOMAIN_CONTROLLER_INFO *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->domain_controller_name));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->domain_controller_address));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->domain_controller_address_type));
		NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, &r->domain_guid));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->domain_name));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->dns_forest_name));
		NDR_CHECK(ndr_push_DOMAIN_CONTROLLER_INFO_FLAGS(ndr, NDR_SCALARS, r->flags));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->dc_site_name));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->client_site_name));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_DOMAIN_CONTROLLER_INFO(struct ndr_pull *ndr, int ndr_flags, struct DOMAIN_CONTROLLER_INFO *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->domain_controller_name));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->domain_controller_address));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->domain_controller_address_type));
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, &r->domain_guid));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->domain_name));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->dns_forest_name));
		NDR_CHECK(ndr_pull_DOMAIN_CONTROLLER_INFO_FLAGS(ndr, NDR_SCALARS, &r->flags));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->dc_site_name));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->client_site_name));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_DOMAIN_CONTROLLER_INFO(struct ndr_print *ndr, const char *name, const struct DOMAIN_CONTROLLER_INFO *r)
{
	ndr_print_struct(ndr, name, "DOMAIN_CONTROLLER_INFO");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_string(ndr, "domain_controller_name", r->domain_controller_name);
	ndr_print_string(ndr, "domain_controller_address", r->domain_controller_address);
	ndr_print_uint32(ndr, "domain_controller_address_type", r->domain_controller_address_type);
	ndr_print_GUID(ndr, "domain_guid", &r->domain_guid);
	ndr_print_string(ndr, "domain_name", r->domain_name);
	ndr_print_string(ndr, "dns_forest_name", r->dns_forest_name);
	ndr_print_DOMAIN_CONTROLLER_INFO_FLAGS(ndr, "flags", r->flags);
	ndr_print_string(ndr, "dc_site_name", r->dc_site_name);
	ndr_print_string(ndr, "client_site_name", r->client_site_name);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_USER_INFO_0(struct ndr_push *ndr, int ndr_flags, const struct USER_INFO_0 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usri0_name));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_USER_INFO_0(struct ndr_pull *ndr, int ndr_flags, struct USER_INFO_0 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usri0_name));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_USER_INFO_0(struct ndr_print *ndr, const char *name, const struct USER_INFO_0 *r)
{
	ndr_print_struct(ndr, name, "USER_INFO_0");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_string(ndr, "usri0_name", r->usri0_name);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_USER_INFO_1(struct ndr_push *ndr, int ndr_flags, const struct USER_INFO_1 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usri1_name));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usri1_password));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usri1_password_age));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usri1_priv));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usri1_home_dir));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usri1_comment));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usri1_flags));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usri1_script_path));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_USER_INFO_1(struct ndr_pull *ndr, int ndr_flags, struct USER_INFO_1 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usri1_name));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usri1_password));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usri1_password_age));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usri1_priv));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usri1_home_dir));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usri1_comment));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usri1_flags));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usri1_script_path));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_USER_INFO_1(struct ndr_print *ndr, const char *name, const struct USER_INFO_1 *r)
{
	ndr_print_struct(ndr, name, "USER_INFO_1");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_string(ndr, "usri1_name", r->usri1_name);
	ndr_print_string(ndr, "usri1_password", r->usri1_password);
	ndr_print_uint32(ndr, "usri1_password_age", r->usri1_password_age);
	ndr_print_uint32(ndr, "usri1_priv", r->usri1_priv);
	ndr_print_string(ndr, "usri1_home_dir", r->usri1_home_dir);
	ndr_print_string(ndr, "usri1_comment", r->usri1_comment);
	ndr_print_uint32(ndr, "usri1_flags", r->usri1_flags);
	ndr_print_string(ndr, "usri1_script_path", r->usri1_script_path);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_USER_INFO_2(struct ndr_push *ndr, int ndr_flags, const struct USER_INFO_2 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usri2_name));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usri2_password));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usri2_password_age));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usri2_priv));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usri2_home_dir));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usri2_comment));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usri2_flags));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usri2_script_path));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usri2_auth_flags));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usri2_full_name));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usri2_usr_comment));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usri2_parms));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usri2_workstations));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usri2_last_logon));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usri2_last_logoff));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usri2_acct_expires));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usri2_max_storage));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usri2_units_per_week));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->usri2_logon_hours));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usri2_bad_pw_count));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usri2_num_logons));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usri2_logon_server));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usri2_country_code));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usri2_code_page));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->usri2_logon_hours) {
			NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, *r->usri2_logon_hours));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_USER_INFO_2(struct ndr_pull *ndr, int ndr_flags, struct USER_INFO_2 *r)
{
	uint32_t _ptr_usri2_logon_hours;
	TALLOC_CTX *_mem_save_usri2_logon_hours_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usri2_name));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usri2_password));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usri2_password_age));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usri2_priv));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usri2_home_dir));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usri2_comment));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usri2_flags));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usri2_script_path));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usri2_auth_flags));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usri2_full_name));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usri2_usr_comment));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usri2_parms));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usri2_workstations));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usri2_last_logon));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usri2_last_logoff));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usri2_acct_expires));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usri2_max_storage));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usri2_units_per_week));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_usri2_logon_hours));
		if (_ptr_usri2_logon_hours) {
			NDR_PULL_ALLOC(ndr, r->usri2_logon_hours);
		} else {
			r->usri2_logon_hours = NULL;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usri2_bad_pw_count));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usri2_num_logons));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usri2_logon_server));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usri2_country_code));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usri2_code_page));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->usri2_logon_hours) {
			_mem_save_usri2_logon_hours_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->usri2_logon_hours, 0);
			NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, r->usri2_logon_hours));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_usri2_logon_hours_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_USER_INFO_2(struct ndr_print *ndr, const char *name, const struct USER_INFO_2 *r)
{
	ndr_print_struct(ndr, name, "USER_INFO_2");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_string(ndr, "usri2_name", r->usri2_name);
	ndr_print_string(ndr, "usri2_password", r->usri2_password);
	ndr_print_uint32(ndr, "usri2_password_age", r->usri2_password_age);
	ndr_print_uint32(ndr, "usri2_priv", r->usri2_priv);
	ndr_print_string(ndr, "usri2_home_dir", r->usri2_home_dir);
	ndr_print_string(ndr, "usri2_comment", r->usri2_comment);
	ndr_print_uint32(ndr, "usri2_flags", r->usri2_flags);
	ndr_print_string(ndr, "usri2_script_path", r->usri2_script_path);
	ndr_print_uint32(ndr, "usri2_auth_flags", r->usri2_auth_flags);
	ndr_print_string(ndr, "usri2_full_name", r->usri2_full_name);
	ndr_print_string(ndr, "usri2_usr_comment", r->usri2_usr_comment);
	ndr_print_string(ndr, "usri2_parms", r->usri2_parms);
	ndr_print_string(ndr, "usri2_workstations", r->usri2_workstations);
	ndr_print_uint32(ndr, "usri2_last_logon", r->usri2_last_logon);
	ndr_print_uint32(ndr, "usri2_last_logoff", r->usri2_last_logoff);
	ndr_print_uint32(ndr, "usri2_acct_expires", r->usri2_acct_expires);
	ndr_print_uint32(ndr, "usri2_max_storage", r->usri2_max_storage);
	ndr_print_uint32(ndr, "usri2_units_per_week", r->usri2_units_per_week);
	ndr_print_ptr(ndr, "usri2_logon_hours", r->usri2_logon_hours);
	ndr->depth++;
	if (r->usri2_logon_hours) {
		ndr_print_uint8(ndr, "usri2_logon_hours", *r->usri2_logon_hours);
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "usri2_bad_pw_count", r->usri2_bad_pw_count);
	ndr_print_uint32(ndr, "usri2_num_logons", r->usri2_num_logons);
	ndr_print_string(ndr, "usri2_logon_server", r->usri2_logon_server);
	ndr_print_uint32(ndr, "usri2_country_code", r->usri2_country_code);
	ndr_print_uint32(ndr, "usri2_code_page", r->usri2_code_page);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_USER_INFO_3(struct ndr_push *ndr, int ndr_flags, const struct USER_INFO_3 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usri3_name));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usri3_password_age));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usri3_priv));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usri3_home_dir));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usri3_comment));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usri3_flags));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usri3_script_path));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usri3_auth_flags));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usri3_full_name));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usri3_usr_comment));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usri3_parms));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usri3_workstations));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usri3_last_logon));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usri3_last_logoff));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usri3_acct_expires));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usri3_max_storage));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usri3_units_per_week));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->usri3_logon_hours));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usri3_bad_pw_count));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usri3_num_logons));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usri3_logon_server));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usri3_country_code));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usri3_code_page));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usri3_user_id));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usri3_primary_group_id));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usri3_profile));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usri3_home_dir_drive));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usri3_password_expired));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->usri3_logon_hours) {
			NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, *r->usri3_logon_hours));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_USER_INFO_3(struct ndr_pull *ndr, int ndr_flags, struct USER_INFO_3 *r)
{
	uint32_t _ptr_usri3_logon_hours;
	TALLOC_CTX *_mem_save_usri3_logon_hours_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usri3_name));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usri3_password_age));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usri3_priv));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usri3_home_dir));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usri3_comment));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usri3_flags));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usri3_script_path));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usri3_auth_flags));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usri3_full_name));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usri3_usr_comment));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usri3_parms));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usri3_workstations));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usri3_last_logon));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usri3_last_logoff));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usri3_acct_expires));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usri3_max_storage));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usri3_units_per_week));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_usri3_logon_hours));
		if (_ptr_usri3_logon_hours) {
			NDR_PULL_ALLOC(ndr, r->usri3_logon_hours);
		} else {
			r->usri3_logon_hours = NULL;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usri3_bad_pw_count));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usri3_num_logons));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usri3_logon_server));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usri3_country_code));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usri3_code_page));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usri3_user_id));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usri3_primary_group_id));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usri3_profile));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usri3_home_dir_drive));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usri3_password_expired));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->usri3_logon_hours) {
			_mem_save_usri3_logon_hours_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->usri3_logon_hours, 0);
			NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, r->usri3_logon_hours));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_usri3_logon_hours_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_USER_INFO_3(struct ndr_print *ndr, const char *name, const struct USER_INFO_3 *r)
{
	ndr_print_struct(ndr, name, "USER_INFO_3");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_string(ndr, "usri3_name", r->usri3_name);
	ndr_print_uint32(ndr, "usri3_password_age", r->usri3_password_age);
	ndr_print_uint32(ndr, "usri3_priv", r->usri3_priv);
	ndr_print_string(ndr, "usri3_home_dir", r->usri3_home_dir);
	ndr_print_string(ndr, "usri3_comment", r->usri3_comment);
	ndr_print_uint32(ndr, "usri3_flags", r->usri3_flags);
	ndr_print_string(ndr, "usri3_script_path", r->usri3_script_path);
	ndr_print_uint32(ndr, "usri3_auth_flags", r->usri3_auth_flags);
	ndr_print_string(ndr, "usri3_full_name", r->usri3_full_name);
	ndr_print_string(ndr, "usri3_usr_comment", r->usri3_usr_comment);
	ndr_print_string(ndr, "usri3_parms", r->usri3_parms);
	ndr_print_string(ndr, "usri3_workstations", r->usri3_workstations);
	ndr_print_uint32(ndr, "usri3_last_logon", r->usri3_last_logon);
	ndr_print_uint32(ndr, "usri3_last_logoff", r->usri3_last_logoff);
	ndr_print_uint32(ndr, "usri3_acct_expires", r->usri3_acct_expires);
	ndr_print_uint32(ndr, "usri3_max_storage", r->usri3_max_storage);
	ndr_print_uint32(ndr, "usri3_units_per_week", r->usri3_units_per_week);
	ndr_print_ptr(ndr, "usri3_logon_hours", r->usri3_logon_hours);
	ndr->depth++;
	if (r->usri3_logon_hours) {
		ndr_print_uint8(ndr, "usri3_logon_hours", *r->usri3_logon_hours);
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "usri3_bad_pw_count", r->usri3_bad_pw_count);
	ndr_print_uint32(ndr, "usri3_num_logons", r->usri3_num_logons);
	ndr_print_string(ndr, "usri3_logon_server", r->usri3_logon_server);
	ndr_print_uint32(ndr, "usri3_country_code", r->usri3_country_code);
	ndr_print_uint32(ndr, "usri3_code_page", r->usri3_code_page);
	ndr_print_uint32(ndr, "usri3_user_id", r->usri3_user_id);
	ndr_print_uint32(ndr, "usri3_primary_group_id", r->usri3_primary_group_id);
	ndr_print_string(ndr, "usri3_profile", r->usri3_profile);
	ndr_print_string(ndr, "usri3_home_dir_drive", r->usri3_home_dir_drive);
	ndr_print_uint32(ndr, "usri3_password_expired", r->usri3_password_expired);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_USER_INFO_4(struct ndr_push *ndr, int ndr_flags, const struct USER_INFO_4 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usri4_name));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usri4_password));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usri4_password_age));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usri4_priv));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usri4_home_dir));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usri4_comment));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usri4_flags));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usri4_script_path));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usri4_auth_flags));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usri4_full_name));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usri4_usr_comment));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usri4_parms));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usri4_workstations));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usri4_last_logon));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usri4_last_logoff));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usri4_acct_expires));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usri4_max_storage));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usri4_units_per_week));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->usri4_logon_hours));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usri4_bad_pw_count));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usri4_num_logons));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usri4_logon_server));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usri4_country_code));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usri4_code_page));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->usri4_user_sid));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usri4_primary_group_id));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usri4_profile));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usri4_home_dir_drive));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usri4_password_expired));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->usri4_logon_hours) {
			NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, *r->usri4_logon_hours));
		}
		if (r->usri4_user_sid) {
			NDR_CHECK(ndr_push_domsid(ndr, NDR_SCALARS, r->usri4_user_sid));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_USER_INFO_4(struct ndr_pull *ndr, int ndr_flags, struct USER_INFO_4 *r)
{
	uint32_t _ptr_usri4_logon_hours;
	TALLOC_CTX *_mem_save_usri4_logon_hours_0;
	uint32_t _ptr_usri4_user_sid;
	TALLOC_CTX *_mem_save_usri4_user_sid_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usri4_name));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usri4_password));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usri4_password_age));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usri4_priv));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usri4_home_dir));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usri4_comment));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usri4_flags));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usri4_script_path));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usri4_auth_flags));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usri4_full_name));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usri4_usr_comment));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usri4_parms));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usri4_workstations));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usri4_last_logon));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usri4_last_logoff));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usri4_acct_expires));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usri4_max_storage));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usri4_units_per_week));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_usri4_logon_hours));
		if (_ptr_usri4_logon_hours) {
			NDR_PULL_ALLOC(ndr, r->usri4_logon_hours);
		} else {
			r->usri4_logon_hours = NULL;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usri4_bad_pw_count));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usri4_num_logons));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usri4_logon_server));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usri4_country_code));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usri4_code_page));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_usri4_user_sid));
		if (_ptr_usri4_user_sid) {
			NDR_PULL_ALLOC(ndr, r->usri4_user_sid);
		} else {
			r->usri4_user_sid = NULL;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usri4_primary_group_id));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usri4_profile));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usri4_home_dir_drive));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usri4_password_expired));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->usri4_logon_hours) {
			_mem_save_usri4_logon_hours_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->usri4_logon_hours, 0);
			NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, r->usri4_logon_hours));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_usri4_logon_hours_0, 0);
		}
		if (r->usri4_user_sid) {
			_mem_save_usri4_user_sid_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->usri4_user_sid, 0);
			NDR_CHECK(ndr_pull_domsid(ndr, NDR_SCALARS, r->usri4_user_sid));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_usri4_user_sid_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_USER_INFO_4(struct ndr_print *ndr, const char *name, const struct USER_INFO_4 *r)
{
	ndr_print_struct(ndr, name, "USER_INFO_4");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_string(ndr, "usri4_name", r->usri4_name);
	ndr_print_string(ndr, "usri4_password", r->usri4_password);
	ndr_print_uint32(ndr, "usri4_password_age", r->usri4_password_age);
	ndr_print_uint32(ndr, "usri4_priv", r->usri4_priv);
	ndr_print_string(ndr, "usri4_home_dir", r->usri4_home_dir);
	ndr_print_string(ndr, "usri4_comment", r->usri4_comment);
	ndr_print_uint32(ndr, "usri4_flags", r->usri4_flags);
	ndr_print_string(ndr, "usri4_script_path", r->usri4_script_path);
	ndr_print_uint32(ndr, "usri4_auth_flags", r->usri4_auth_flags);
	ndr_print_string(ndr, "usri4_full_name", r->usri4_full_name);
	ndr_print_string(ndr, "usri4_usr_comment", r->usri4_usr_comment);
	ndr_print_string(ndr, "usri4_parms", r->usri4_parms);
	ndr_print_string(ndr, "usri4_workstations", r->usri4_workstations);
	ndr_print_uint32(ndr, "usri4_last_logon", r->usri4_last_logon);
	ndr_print_uint32(ndr, "usri4_last_logoff", r->usri4_last_logoff);
	ndr_print_uint32(ndr, "usri4_acct_expires", r->usri4_acct_expires);
	ndr_print_uint32(ndr, "usri4_max_storage", r->usri4_max_storage);
	ndr_print_uint32(ndr, "usri4_units_per_week", r->usri4_units_per_week);
	ndr_print_ptr(ndr, "usri4_logon_hours", r->usri4_logon_hours);
	ndr->depth++;
	if (r->usri4_logon_hours) {
		ndr_print_uint8(ndr, "usri4_logon_hours", *r->usri4_logon_hours);
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "usri4_bad_pw_count", r->usri4_bad_pw_count);
	ndr_print_uint32(ndr, "usri4_num_logons", r->usri4_num_logons);
	ndr_print_string(ndr, "usri4_logon_server", r->usri4_logon_server);
	ndr_print_uint32(ndr, "usri4_country_code", r->usri4_country_code);
	ndr_print_uint32(ndr, "usri4_code_page", r->usri4_code_page);
	ndr_print_ptr(ndr, "usri4_user_sid", r->usri4_user_sid);
	ndr->depth++;
	if (r->usri4_user_sid) {
		ndr_print_domsid(ndr, "usri4_user_sid", r->usri4_user_sid);
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "usri4_primary_group_id", r->usri4_primary_group_id);
	ndr_print_string(ndr, "usri4_profile", r->usri4_profile);
	ndr_print_string(ndr, "usri4_home_dir_drive", r->usri4_home_dir_drive);
	ndr_print_uint32(ndr, "usri4_password_expired", r->usri4_password_expired);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_USER_INFO_10(struct ndr_push *ndr, int ndr_flags, const struct USER_INFO_10 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usri10_name));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usri10_comment));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usri10_usr_comment));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usri10_full_name));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_USER_INFO_10(struct ndr_pull *ndr, int ndr_flags, struct USER_INFO_10 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usri10_name));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usri10_comment));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usri10_usr_comment));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usri10_full_name));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_USER_INFO_10(struct ndr_print *ndr, const char *name, const struct USER_INFO_10 *r)
{
	ndr_print_struct(ndr, name, "USER_INFO_10");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_string(ndr, "usri10_name", r->usri10_name);
	ndr_print_string(ndr, "usri10_comment", r->usri10_comment);
	ndr_print_string(ndr, "usri10_usr_comment", r->usri10_usr_comment);
	ndr_print_string(ndr, "usri10_full_name", r->usri10_full_name);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_USER_INFO_11(struct ndr_push *ndr, int ndr_flags, const struct USER_INFO_11 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usri11_name));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usri11_comment));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usri11_usr_comment));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usri11_full_name));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usri11_priv));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usri11_auth_flags));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usri11_password_age));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usri11_home_dir));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usri11_parms));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usri11_last_logon));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usri11_last_logoff));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usri11_bad_pw_count));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usri11_num_logons));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usri11_logon_server));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usri11_country_code));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usri11_workstations));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usri11_max_storage));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usri11_units_per_week));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->usri11_logon_hours));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usri11_code_page));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->usri11_logon_hours) {
			NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, *r->usri11_logon_hours));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_USER_INFO_11(struct ndr_pull *ndr, int ndr_flags, struct USER_INFO_11 *r)
{
	uint32_t _ptr_usri11_logon_hours;
	TALLOC_CTX *_mem_save_usri11_logon_hours_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usri11_name));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usri11_comment));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usri11_usr_comment));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usri11_full_name));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usri11_priv));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usri11_auth_flags));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usri11_password_age));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usri11_home_dir));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usri11_parms));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usri11_last_logon));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usri11_last_logoff));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usri11_bad_pw_count));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usri11_num_logons));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usri11_logon_server));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usri11_country_code));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usri11_workstations));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usri11_max_storage));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usri11_units_per_week));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_usri11_logon_hours));
		if (_ptr_usri11_logon_hours) {
			NDR_PULL_ALLOC(ndr, r->usri11_logon_hours);
		} else {
			r->usri11_logon_hours = NULL;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usri11_code_page));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->usri11_logon_hours) {
			_mem_save_usri11_logon_hours_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->usri11_logon_hours, 0);
			NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, r->usri11_logon_hours));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_usri11_logon_hours_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_USER_INFO_11(struct ndr_print *ndr, const char *name, const struct USER_INFO_11 *r)
{
	ndr_print_struct(ndr, name, "USER_INFO_11");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_string(ndr, "usri11_name", r->usri11_name);
	ndr_print_string(ndr, "usri11_comment", r->usri11_comment);
	ndr_print_string(ndr, "usri11_usr_comment", r->usri11_usr_comment);
	ndr_print_string(ndr, "usri11_full_name", r->usri11_full_name);
	ndr_print_uint32(ndr, "usri11_priv", r->usri11_priv);
	ndr_print_uint32(ndr, "usri11_auth_flags", r->usri11_auth_flags);
	ndr_print_uint32(ndr, "usri11_password_age", r->usri11_password_age);
	ndr_print_string(ndr, "usri11_home_dir", r->usri11_home_dir);
	ndr_print_string(ndr, "usri11_parms", r->usri11_parms);
	ndr_print_uint32(ndr, "usri11_last_logon", r->usri11_last_logon);
	ndr_print_uint32(ndr, "usri11_last_logoff", r->usri11_last_logoff);
	ndr_print_uint32(ndr, "usri11_bad_pw_count", r->usri11_bad_pw_count);
	ndr_print_uint32(ndr, "usri11_num_logons", r->usri11_num_logons);
	ndr_print_string(ndr, "usri11_logon_server", r->usri11_logon_server);
	ndr_print_uint32(ndr, "usri11_country_code", r->usri11_country_code);
	ndr_print_string(ndr, "usri11_workstations", r->usri11_workstations);
	ndr_print_uint32(ndr, "usri11_max_storage", r->usri11_max_storage);
	ndr_print_uint32(ndr, "usri11_units_per_week", r->usri11_units_per_week);
	ndr_print_ptr(ndr, "usri11_logon_hours", r->usri11_logon_hours);
	ndr->depth++;
	if (r->usri11_logon_hours) {
		ndr_print_uint8(ndr, "usri11_logon_hours", *r->usri11_logon_hours);
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "usri11_code_page", r->usri11_code_page);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_USER_INFO_20(struct ndr_push *ndr, int ndr_flags, const struct USER_INFO_20 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usri20_name));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usri20_full_name));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usri20_comment));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usri20_flags));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usri20_user_id));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_USER_INFO_20(struct ndr_pull *ndr, int ndr_flags, struct USER_INFO_20 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usri20_name));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usri20_full_name));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usri20_comment));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usri20_flags));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usri20_user_id));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_USER_INFO_20(struct ndr_print *ndr, const char *name, const struct USER_INFO_20 *r)
{
	ndr_print_struct(ndr, name, "USER_INFO_20");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_string(ndr, "usri20_name", r->usri20_name);
	ndr_print_string(ndr, "usri20_full_name", r->usri20_full_name);
	ndr_print_string(ndr, "usri20_comment", r->usri20_comment);
	ndr_print_uint32(ndr, "usri20_flags", r->usri20_flags);
	ndr_print_uint32(ndr, "usri20_user_id", r->usri20_user_id);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_USER_INFO_21(struct ndr_push *ndr, int ndr_flags, const struct USER_INFO_21 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 1));
		NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->usri21_password, ENCRYPTED_PWLEN));
		NDR_CHECK(ndr_push_trailer_align(ndr, 1));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_USER_INFO_21(struct ndr_pull *ndr, int ndr_flags, struct USER_INFO_21 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 1));
		NDR_PULL_ALLOC_N(ndr, r->usri21_password, ENCRYPTED_PWLEN);
		NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->usri21_password, ENCRYPTED_PWLEN));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 1));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_USER_INFO_21(struct ndr_print *ndr, const char *name, const struct USER_INFO_21 *r)
{
	ndr_print_struct(ndr, name, "USER_INFO_21");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_array_uint8(ndr, "usri21_password", r->usri21_password, ENCRYPTED_PWLEN);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_USER_INFO_22(struct ndr_push *ndr, int ndr_flags, const struct USER_INFO_22 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usri22_name));
		NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->usri22_password, ENCRYPTED_PWLEN));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usri22_password_age));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usri22_priv));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usri22_home_dir));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usri22_comment));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usri22_flags));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usri22_script_path));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usri22_auth_flags));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usri22_full_name));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usri22_usr_comment));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usri22_parms));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usri22_workstations));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usri22_last_logon));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usri22_last_logoff));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usri22_acct_expires));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usri22_max_storage));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usri22_units_per_week));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->usri22_logon_hours));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usri22_bad_pw_count));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usri22_num_logons));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usri22_logon_server));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usri22_country_code));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usri22_code_page));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->usri22_logon_hours) {
			NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, *r->usri22_logon_hours));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_USER_INFO_22(struct ndr_pull *ndr, int ndr_flags, struct USER_INFO_22 *r)
{
	uint32_t _ptr_usri22_logon_hours;
	TALLOC_CTX *_mem_save_usri22_logon_hours_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usri22_name));
		NDR_PULL_ALLOC_N(ndr, r->usri22_password, ENCRYPTED_PWLEN);
		NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->usri22_password, ENCRYPTED_PWLEN));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usri22_password_age));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usri22_priv));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usri22_home_dir));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usri22_comment));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usri22_flags));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usri22_script_path));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usri22_auth_flags));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usri22_full_name));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usri22_usr_comment));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usri22_parms));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usri22_workstations));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usri22_last_logon));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usri22_last_logoff));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usri22_acct_expires));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usri22_max_storage));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usri22_units_per_week));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_usri22_logon_hours));
		if (_ptr_usri22_logon_hours) {
			NDR_PULL_ALLOC(ndr, r->usri22_logon_hours);
		} else {
			r->usri22_logon_hours = NULL;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usri22_bad_pw_count));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usri22_num_logons));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usri22_logon_server));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usri22_country_code));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usri22_code_page));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->usri22_logon_hours) {
			_mem_save_usri22_logon_hours_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->usri22_logon_hours, 0);
			NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, r->usri22_logon_hours));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_usri22_logon_hours_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_USER_INFO_22(struct ndr_print *ndr, const char *name, const struct USER_INFO_22 *r)
{
	ndr_print_struct(ndr, name, "USER_INFO_22");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_string(ndr, "usri22_name", r->usri22_name);
	ndr_print_array_uint8(ndr, "usri22_password", r->usri22_password, ENCRYPTED_PWLEN);
	ndr_print_uint32(ndr, "usri22_password_age", r->usri22_password_age);
	ndr_print_uint32(ndr, "usri22_priv", r->usri22_priv);
	ndr_print_string(ndr, "usri22_home_dir", r->usri22_home_dir);
	ndr_print_string(ndr, "usri22_comment", r->usri22_comment);
	ndr_print_uint32(ndr, "usri22_flags", r->usri22_flags);
	ndr_print_uint32(ndr, "usri22_script_path", r->usri22_script_path);
	ndr_print_uint32(ndr, "usri22_auth_flags", r->usri22_auth_flags);
	ndr_print_string(ndr, "usri22_full_name", r->usri22_full_name);
	ndr_print_string(ndr, "usri22_usr_comment", r->usri22_usr_comment);
	ndr_print_string(ndr, "usri22_parms", r->usri22_parms);
	ndr_print_string(ndr, "usri22_workstations", r->usri22_workstations);
	ndr_print_uint32(ndr, "usri22_last_logon", r->usri22_last_logon);
	ndr_print_uint32(ndr, "usri22_last_logoff", r->usri22_last_logoff);
	ndr_print_uint32(ndr, "usri22_acct_expires", r->usri22_acct_expires);
	ndr_print_uint32(ndr, "usri22_max_storage", r->usri22_max_storage);
	ndr_print_uint32(ndr, "usri22_units_per_week", r->usri22_units_per_week);
	ndr_print_ptr(ndr, "usri22_logon_hours", r->usri22_logon_hours);
	ndr->depth++;
	if (r->usri22_logon_hours) {
		ndr_print_uint8(ndr, "usri22_logon_hours", *r->usri22_logon_hours);
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "usri22_bad_pw_count", r->usri22_bad_pw_count);
	ndr_print_uint32(ndr, "usri22_num_logons", r->usri22_num_logons);
	ndr_print_string(ndr, "usri22_logon_server", r->usri22_logon_server);
	ndr_print_uint32(ndr, "usri22_country_code", r->usri22_country_code);
	ndr_print_uint32(ndr, "usri22_code_page", r->usri22_code_page);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_USER_INFO_23(struct ndr_push *ndr, int ndr_flags, const struct USER_INFO_23 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usri23_name));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usri23_full_name));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usri23_comment));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usri23_flags));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->usri23_user_sid));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->usri23_user_sid) {
			NDR_CHECK(ndr_push_domsid(ndr, NDR_SCALARS, r->usri23_user_sid));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_USER_INFO_23(struct ndr_pull *ndr, int ndr_flags, struct USER_INFO_23 *r)
{
	uint32_t _ptr_usri23_user_sid;
	TALLOC_CTX *_mem_save_usri23_user_sid_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usri23_name));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usri23_full_name));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usri23_comment));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usri23_flags));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_usri23_user_sid));
		if (_ptr_usri23_user_sid) {
			NDR_PULL_ALLOC(ndr, r->usri23_user_sid);
		} else {
			r->usri23_user_sid = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->usri23_user_sid) {
			_mem_save_usri23_user_sid_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->usri23_user_sid, 0);
			NDR_CHECK(ndr_pull_domsid(ndr, NDR_SCALARS, r->usri23_user_sid));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_usri23_user_sid_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_USER_INFO_23(struct ndr_print *ndr, const char *name, const struct USER_INFO_23 *r)
{
	ndr_print_struct(ndr, name, "USER_INFO_23");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_string(ndr, "usri23_name", r->usri23_name);
	ndr_print_string(ndr, "usri23_full_name", r->usri23_full_name);
	ndr_print_string(ndr, "usri23_comment", r->usri23_comment);
	ndr_print_uint32(ndr, "usri23_flags", r->usri23_flags);
	ndr_print_ptr(ndr, "usri23_user_sid", r->usri23_user_sid);
	ndr->depth++;
	if (r->usri23_user_sid) {
		ndr_print_domsid(ndr, "usri23_user_sid", r->usri23_user_sid);
	}
	ndr->depth--;
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_USER_INFO_1003(struct ndr_push *ndr, int ndr_flags, const struct USER_INFO_1003 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usri1003_password));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_USER_INFO_1003(struct ndr_pull *ndr, int ndr_flags, struct USER_INFO_1003 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usri1003_password));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_USER_INFO_1003(struct ndr_print *ndr, const char *name, const struct USER_INFO_1003 *r)
{
	ndr_print_struct(ndr, name, "USER_INFO_1003");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_string(ndr, "usri1003_password", r->usri1003_password);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_USER_INFO_1005(struct ndr_push *ndr, int ndr_flags, const struct USER_INFO_1005 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usri1005_priv));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_USER_INFO_1005(struct ndr_pull *ndr, int ndr_flags, struct USER_INFO_1005 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usri1005_priv));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_USER_INFO_1005(struct ndr_print *ndr, const char *name, const struct USER_INFO_1005 *r)
{
	ndr_print_struct(ndr, name, "USER_INFO_1005");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "usri1005_priv", r->usri1005_priv);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_USER_INFO_1006(struct ndr_push *ndr, int ndr_flags, const struct USER_INFO_1006 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usri1006_home_dir));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_USER_INFO_1006(struct ndr_pull *ndr, int ndr_flags, struct USER_INFO_1006 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usri1006_home_dir));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_USER_INFO_1006(struct ndr_print *ndr, const char *name, const struct USER_INFO_1006 *r)
{
	ndr_print_struct(ndr, name, "USER_INFO_1006");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_string(ndr, "usri1006_home_dir", r->usri1006_home_dir);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_USER_INFO_1007(struct ndr_push *ndr, int ndr_flags, const struct USER_INFO_1007 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usri1007_comment));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_USER_INFO_1007(struct ndr_pull *ndr, int ndr_flags, struct USER_INFO_1007 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usri1007_comment));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_USER_INFO_1007(struct ndr_print *ndr, const char *name, const struct USER_INFO_1007 *r)
{
	ndr_print_struct(ndr, name, "USER_INFO_1007");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_string(ndr, "usri1007_comment", r->usri1007_comment);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_USER_INFO_1008(struct ndr_push *ndr, int ndr_flags, const struct USER_INFO_1008 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usri1008_flags));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_USER_INFO_1008(struct ndr_pull *ndr, int ndr_flags, struct USER_INFO_1008 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usri1008_flags));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_USER_INFO_1008(struct ndr_print *ndr, const char *name, const struct USER_INFO_1008 *r)
{
	ndr_print_struct(ndr, name, "USER_INFO_1008");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "usri1008_flags", r->usri1008_flags);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_USER_INFO_1009(struct ndr_push *ndr, int ndr_flags, const struct USER_INFO_1009 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usri1009_script_path));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_USER_INFO_1009(struct ndr_pull *ndr, int ndr_flags, struct USER_INFO_1009 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usri1009_script_path));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_USER_INFO_1009(struct ndr_print *ndr, const char *name, const struct USER_INFO_1009 *r)
{
	ndr_print_struct(ndr, name, "USER_INFO_1009");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_string(ndr, "usri1009_script_path", r->usri1009_script_path);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_USER_INFO_1010(struct ndr_push *ndr, int ndr_flags, const struct USER_INFO_1010 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usri1010_auth_flags));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_USER_INFO_1010(struct ndr_pull *ndr, int ndr_flags, struct USER_INFO_1010 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usri1010_auth_flags));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_USER_INFO_1010(struct ndr_print *ndr, const char *name, const struct USER_INFO_1010 *r)
{
	ndr_print_struct(ndr, name, "USER_INFO_1010");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "usri1010_auth_flags", r->usri1010_auth_flags);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_USER_INFO_1011(struct ndr_push *ndr, int ndr_flags, const struct USER_INFO_1011 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usri1011_full_name));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_USER_INFO_1011(struct ndr_pull *ndr, int ndr_flags, struct USER_INFO_1011 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usri1011_full_name));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_USER_INFO_1011(struct ndr_print *ndr, const char *name, const struct USER_INFO_1011 *r)
{
	ndr_print_struct(ndr, name, "USER_INFO_1011");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_string(ndr, "usri1011_full_name", r->usri1011_full_name);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_USER_INFO_1012(struct ndr_push *ndr, int ndr_flags, const struct USER_INFO_1012 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usri1012_usr_comment));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_USER_INFO_1012(struct ndr_pull *ndr, int ndr_flags, struct USER_INFO_1012 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usri1012_usr_comment));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_USER_INFO_1012(struct ndr_print *ndr, const char *name, const struct USER_INFO_1012 *r)
{
	ndr_print_struct(ndr, name, "USER_INFO_1012");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_string(ndr, "usri1012_usr_comment", r->usri1012_usr_comment);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_USER_INFO_1013(struct ndr_push *ndr, int ndr_flags, const struct USER_INFO_1013 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usri1013_parms));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_USER_INFO_1013(struct ndr_pull *ndr, int ndr_flags, struct USER_INFO_1013 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usri1013_parms));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_USER_INFO_1013(struct ndr_print *ndr, const char *name, const struct USER_INFO_1013 *r)
{
	ndr_print_struct(ndr, name, "USER_INFO_1013");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_string(ndr, "usri1013_parms", r->usri1013_parms);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_USER_INFO_1014(struct ndr_push *ndr, int ndr_flags, const struct USER_INFO_1014 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usri1014_workstations));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_USER_INFO_1014(struct ndr_pull *ndr, int ndr_flags, struct USER_INFO_1014 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usri1014_workstations));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_USER_INFO_1014(struct ndr_print *ndr, const char *name, const struct USER_INFO_1014 *r)
{
	ndr_print_struct(ndr, name, "USER_INFO_1014");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_string(ndr, "usri1014_workstations", r->usri1014_workstations);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_USER_INFO_1017(struct ndr_push *ndr, int ndr_flags, const struct USER_INFO_1017 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usri1017_acct_expires));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_USER_INFO_1017(struct ndr_pull *ndr, int ndr_flags, struct USER_INFO_1017 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usri1017_acct_expires));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_USER_INFO_1017(struct ndr_print *ndr, const char *name, const struct USER_INFO_1017 *r)
{
	ndr_print_struct(ndr, name, "USER_INFO_1017");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "usri1017_acct_expires", r->usri1017_acct_expires);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_USER_INFO_1018(struct ndr_push *ndr, int ndr_flags, const struct USER_INFO_1018 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usri1018_max_storage));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_USER_INFO_1018(struct ndr_pull *ndr, int ndr_flags, struct USER_INFO_1018 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usri1018_max_storage));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_USER_INFO_1018(struct ndr_print *ndr, const char *name, const struct USER_INFO_1018 *r)
{
	ndr_print_struct(ndr, name, "USER_INFO_1018");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "usri1018_max_storage", r->usri1018_max_storage);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_USER_INFO_1020(struct ndr_push *ndr, int ndr_flags, const struct USER_INFO_1020 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usri1020_units_per_week));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->usri1020_logon_hours));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->usri1020_logon_hours) {
			NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, *r->usri1020_logon_hours));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_USER_INFO_1020(struct ndr_pull *ndr, int ndr_flags, struct USER_INFO_1020 *r)
{
	uint32_t _ptr_usri1020_logon_hours;
	TALLOC_CTX *_mem_save_usri1020_logon_hours_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usri1020_units_per_week));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_usri1020_logon_hours));
		if (_ptr_usri1020_logon_hours) {
			NDR_PULL_ALLOC(ndr, r->usri1020_logon_hours);
		} else {
			r->usri1020_logon_hours = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->usri1020_logon_hours) {
			_mem_save_usri1020_logon_hours_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->usri1020_logon_hours, 0);
			NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, r->usri1020_logon_hours));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_usri1020_logon_hours_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_USER_INFO_1020(struct ndr_print *ndr, const char *name, const struct USER_INFO_1020 *r)
{
	ndr_print_struct(ndr, name, "USER_INFO_1020");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "usri1020_units_per_week", r->usri1020_units_per_week);
	ndr_print_ptr(ndr, "usri1020_logon_hours", r->usri1020_logon_hours);
	ndr->depth++;
	if (r->usri1020_logon_hours) {
		ndr_print_uint8(ndr, "usri1020_logon_hours", *r->usri1020_logon_hours);
	}
	ndr->depth--;
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_USER_INFO_1023(struct ndr_push *ndr, int ndr_flags, const struct USER_INFO_1023 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usri1023_logon_server));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_USER_INFO_1023(struct ndr_pull *ndr, int ndr_flags, struct USER_INFO_1023 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usri1023_logon_server));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_USER_INFO_1023(struct ndr_print *ndr, const char *name, const struct USER_INFO_1023 *r)
{
	ndr_print_struct(ndr, name, "USER_INFO_1023");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_string(ndr, "usri1023_logon_server", r->usri1023_logon_server);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_USER_INFO_1024(struct ndr_push *ndr, int ndr_flags, const struct USER_INFO_1024 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usri1024_country_code));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_USER_INFO_1024(struct ndr_pull *ndr, int ndr_flags, struct USER_INFO_1024 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usri1024_country_code));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_USER_INFO_1024(struct ndr_print *ndr, const char *name, const struct USER_INFO_1024 *r)
{
	ndr_print_struct(ndr, name, "USER_INFO_1024");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "usri1024_country_code", r->usri1024_country_code);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_USER_INFO_1025(struct ndr_push *ndr, int ndr_flags, const struct USER_INFO_1025 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usri1025_code_page));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_USER_INFO_1025(struct ndr_pull *ndr, int ndr_flags, struct USER_INFO_1025 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usri1025_code_page));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_USER_INFO_1025(struct ndr_print *ndr, const char *name, const struct USER_INFO_1025 *r)
{
	ndr_print_struct(ndr, name, "USER_INFO_1025");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "usri1025_code_page", r->usri1025_code_page);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_USER_INFO_1051(struct ndr_push *ndr, int ndr_flags, const struct USER_INFO_1051 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usri1051_primary_group_id));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_USER_INFO_1051(struct ndr_pull *ndr, int ndr_flags, struct USER_INFO_1051 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usri1051_primary_group_id));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_USER_INFO_1051(struct ndr_print *ndr, const char *name, const struct USER_INFO_1051 *r)
{
	ndr_print_struct(ndr, name, "USER_INFO_1051");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "usri1051_primary_group_id", r->usri1051_primary_group_id);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_USER_INFO_1052(struct ndr_push *ndr, int ndr_flags, const struct USER_INFO_1052 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usri1052_profile));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_USER_INFO_1052(struct ndr_pull *ndr, int ndr_flags, struct USER_INFO_1052 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usri1052_profile));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_USER_INFO_1052(struct ndr_print *ndr, const char *name, const struct USER_INFO_1052 *r)
{
	ndr_print_struct(ndr, name, "USER_INFO_1052");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_string(ndr, "usri1052_profile", r->usri1052_profile);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_USER_INFO_1053(struct ndr_push *ndr, int ndr_flags, const struct USER_INFO_1053 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usri1053_home_dir_drive));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_USER_INFO_1053(struct ndr_pull *ndr, int ndr_flags, struct USER_INFO_1053 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usri1053_home_dir_drive));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_USER_INFO_1053(struct ndr_print *ndr, const char *name, const struct USER_INFO_1053 *r)
{
	ndr_print_struct(ndr, name, "USER_INFO_1053");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_string(ndr, "usri1053_home_dir_drive", r->usri1053_home_dir_drive);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_USER_INFO_X(struct ndr_push *ndr, int ndr_flags, const struct USER_INFO_X *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usriX_name));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usriX_password));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usriX_password_age));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usriX_priv));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usriX_home_dir));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usriX_comment));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usriX_flags));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usriX_script_path));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usriX_auth_flags));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usriX_full_name));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usriX_usr_comment));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usriX_parms));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usriX_workstations));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usriX_last_logon));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usriX_last_logoff));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usriX_acct_expires));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usriX_max_storage));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usriX_units_per_week));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->usriX_logon_hours));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usriX_bad_pw_count));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usriX_num_logons));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usriX_logon_server));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usriX_country_code));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usriX_code_page));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usriX_profile));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usriX_home_dir_drive));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usriX_user_id));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usriX_primary_group_id));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usriX_password_expired));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->usriX_logon_hours) {
			NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, *r->usriX_logon_hours));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_USER_INFO_X(struct ndr_pull *ndr, int ndr_flags, struct USER_INFO_X *r)
{
	uint32_t _ptr_usriX_logon_hours;
	TALLOC_CTX *_mem_save_usriX_logon_hours_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usriX_name));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usriX_password));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usriX_password_age));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usriX_priv));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usriX_home_dir));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usriX_comment));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usriX_flags));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usriX_script_path));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usriX_auth_flags));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usriX_full_name));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usriX_usr_comment));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usriX_parms));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usriX_workstations));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usriX_last_logon));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usriX_last_logoff));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usriX_acct_expires));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usriX_max_storage));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usriX_units_per_week));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_usriX_logon_hours));
		if (_ptr_usriX_logon_hours) {
			NDR_PULL_ALLOC(ndr, r->usriX_logon_hours);
		} else {
			r->usriX_logon_hours = NULL;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usriX_bad_pw_count));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usriX_num_logons));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usriX_logon_server));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usriX_country_code));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usriX_code_page));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usriX_profile));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usriX_home_dir_drive));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usriX_user_id));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usriX_primary_group_id));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usriX_password_expired));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->usriX_logon_hours) {
			_mem_save_usriX_logon_hours_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->usriX_logon_hours, 0);
			NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, r->usriX_logon_hours));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_usriX_logon_hours_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_USER_INFO_X(struct ndr_print *ndr, const char *name, const struct USER_INFO_X *r)
{
	ndr_print_struct(ndr, name, "USER_INFO_X");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_string(ndr, "usriX_name", r->usriX_name);
	ndr_print_string(ndr, "usriX_password", r->usriX_password);
	ndr_print_uint32(ndr, "usriX_password_age", r->usriX_password_age);
	ndr_print_uint32(ndr, "usriX_priv", r->usriX_priv);
	ndr_print_string(ndr, "usriX_home_dir", r->usriX_home_dir);
	ndr_print_string(ndr, "usriX_comment", r->usriX_comment);
	ndr_print_uint32(ndr, "usriX_flags", r->usriX_flags);
	ndr_print_string(ndr, "usriX_script_path", r->usriX_script_path);
	ndr_print_uint32(ndr, "usriX_auth_flags", r->usriX_auth_flags);
	ndr_print_string(ndr, "usriX_full_name", r->usriX_full_name);
	ndr_print_string(ndr, "usriX_usr_comment", r->usriX_usr_comment);
	ndr_print_string(ndr, "usriX_parms", r->usriX_parms);
	ndr_print_string(ndr, "usriX_workstations", r->usriX_workstations);
	ndr_print_uint32(ndr, "usriX_last_logon", r->usriX_last_logon);
	ndr_print_uint32(ndr, "usriX_last_logoff", r->usriX_last_logoff);
	ndr_print_uint32(ndr, "usriX_acct_expires", r->usriX_acct_expires);
	ndr_print_uint32(ndr, "usriX_max_storage", r->usriX_max_storage);
	ndr_print_uint32(ndr, "usriX_units_per_week", r->usriX_units_per_week);
	ndr_print_ptr(ndr, "usriX_logon_hours", r->usriX_logon_hours);
	ndr->depth++;
	if (r->usriX_logon_hours) {
		ndr_print_uint8(ndr, "usriX_logon_hours", *r->usriX_logon_hours);
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "usriX_bad_pw_count", r->usriX_bad_pw_count);
	ndr_print_uint32(ndr, "usriX_num_logons", r->usriX_num_logons);
	ndr_print_string(ndr, "usriX_logon_server", r->usriX_logon_server);
	ndr_print_uint32(ndr, "usriX_country_code", r->usriX_country_code);
	ndr_print_uint32(ndr, "usriX_code_page", r->usriX_code_page);
	ndr_print_string(ndr, "usriX_profile", r->usriX_profile);
	ndr_print_string(ndr, "usriX_home_dir_drive", r->usriX_home_dir_drive);
	ndr_print_uint32(ndr, "usriX_user_id", r->usriX_user_id);
	ndr_print_uint32(ndr, "usriX_primary_group_id", r->usriX_primary_group_id);
	ndr_print_uint32(ndr, "usriX_password_expired", r->usriX_password_expired);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_GROUP_USERS_INFO_0(struct ndr_push *ndr, int ndr_flags, const struct GROUP_USERS_INFO_0 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->grui0_name));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_GROUP_USERS_INFO_0(struct ndr_pull *ndr, int ndr_flags, struct GROUP_USERS_INFO_0 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->grui0_name));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_GROUP_USERS_INFO_0(struct ndr_print *ndr, const char *name, const struct GROUP_USERS_INFO_0 *r)
{
	ndr_print_struct(ndr, name, "GROUP_USERS_INFO_0");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_string(ndr, "grui0_name", r->grui0_name);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_GROUP_USERS_INFO_1(struct ndr_push *ndr, int ndr_flags, const struct GROUP_USERS_INFO_1 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->grui1_name));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->grui1_attributes));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_GROUP_USERS_INFO_1(struct ndr_pull *ndr, int ndr_flags, struct GROUP_USERS_INFO_1 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->grui1_name));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->grui1_attributes));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_GROUP_USERS_INFO_1(struct ndr_print *ndr, const char *name, const struct GROUP_USERS_INFO_1 *r)
{
	ndr_print_struct(ndr, name, "GROUP_USERS_INFO_1");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_string(ndr, "grui1_name", r->grui1_name);
	ndr_print_uint32(ndr, "grui1_attributes", r->grui1_attributes);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_NET_DISPLAY_USER(struct ndr_push *ndr, int ndr_flags, const struct NET_DISPLAY_USER *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usri1_name));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usri1_comment));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usri1_flags));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usri1_full_name));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usri1_user_id));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usri1_next_index));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_NET_DISPLAY_USER(struct ndr_pull *ndr, int ndr_flags, struct NET_DISPLAY_USER *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usri1_name));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usri1_comment));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usri1_flags));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usri1_full_name));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usri1_user_id));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usri1_next_index));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_NET_DISPLAY_USER(struct ndr_print *ndr, const char *name, const struct NET_DISPLAY_USER *r)
{
	ndr_print_struct(ndr, name, "NET_DISPLAY_USER");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_string(ndr, "usri1_name", r->usri1_name);
	ndr_print_string(ndr, "usri1_comment", r->usri1_comment);
	ndr_print_uint32(ndr, "usri1_flags", r->usri1_flags);
	ndr_print_string(ndr, "usri1_full_name", r->usri1_full_name);
	ndr_print_uint32(ndr, "usri1_user_id", r->usri1_user_id);
	ndr_print_uint32(ndr, "usri1_next_index", r->usri1_next_index);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_NET_DISPLAY_MACHINE(struct ndr_push *ndr, int ndr_flags, const struct NET_DISPLAY_MACHINE *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usri2_name));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usri2_comment));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usri2_flags));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usri2_user_id));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usri2_next_index));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_NET_DISPLAY_MACHINE(struct ndr_pull *ndr, int ndr_flags, struct NET_DISPLAY_MACHINE *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usri2_name));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usri2_comment));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usri2_flags));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usri2_user_id));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usri2_next_index));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_NET_DISPLAY_MACHINE(struct ndr_print *ndr, const char *name, const struct NET_DISPLAY_MACHINE *r)
{
	ndr_print_struct(ndr, name, "NET_DISPLAY_MACHINE");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_string(ndr, "usri2_name", r->usri2_name);
	ndr_print_string(ndr, "usri2_comment", r->usri2_comment);
	ndr_print_uint32(ndr, "usri2_flags", r->usri2_flags);
	ndr_print_uint32(ndr, "usri2_user_id", r->usri2_user_id);
	ndr_print_uint32(ndr, "usri2_next_index", r->usri2_next_index);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_NET_DISPLAY_GROUP(struct ndr_push *ndr, int ndr_flags, const struct NET_DISPLAY_GROUP *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->grpi3_name));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->grpi3_comment));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->grpi3_group_id));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->grpi3_attributes));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->grpi3_next_index));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_NET_DISPLAY_GROUP(struct ndr_pull *ndr, int ndr_flags, struct NET_DISPLAY_GROUP *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->grpi3_name));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->grpi3_comment));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->grpi3_group_id));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->grpi3_attributes));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->grpi3_next_index));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_NET_DISPLAY_GROUP(struct ndr_print *ndr, const char *name, const struct NET_DISPLAY_GROUP *r)
{
	ndr_print_struct(ndr, name, "NET_DISPLAY_GROUP");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_string(ndr, "grpi3_name", r->grpi3_name);
	ndr_print_string(ndr, "grpi3_comment", r->grpi3_comment);
	ndr_print_uint32(ndr, "grpi3_group_id", r->grpi3_group_id);
	ndr_print_uint32(ndr, "grpi3_attributes", r->grpi3_attributes);
	ndr_print_uint32(ndr, "grpi3_next_index", r->grpi3_next_index);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_SHARE_INFO_1005_FLAGS(struct ndr_push *ndr, int ndr_flags, uint32_t r)
{
	NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_SHARE_INFO_1005_FLAGS(struct ndr_pull *ndr, int ndr_flags, uint32_t *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_SHARE_INFO_1005_FLAGS(struct ndr_print *ndr, const char *name, uint32_t r)
{
	ndr_print_uint32(ndr, name, r);
	ndr->depth++;
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SHI1005_FLAGS_DFS", SHI1005_FLAGS_DFS, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SHI1005_FLAGS_DFS_ROOT", SHI1005_FLAGS_DFS_ROOT, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "CSC_CACHE_MANUAL_REINT", CSC_CACHE_MANUAL_REINT, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "CSC_CACHE_AUTO_REINT", CSC_CACHE_AUTO_REINT, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "CSC_CACHE_VDO", CSC_CACHE_VDO, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "CSC_CACHE_NONE", CSC_CACHE_NONE, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SHI1005_FLAGS_RESTRICT_EXCLUSIVE_OPENS", SHI1005_FLAGS_RESTRICT_EXCLUSIVE_OPENS, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SHI1005_FLAGS_FORCE_SHARED_DELETE", SHI1005_FLAGS_FORCE_SHARED_DELETE, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SHI1005_FLAGS_ALLOW_NAMESPACE_CACHING", SHI1005_FLAGS_ALLOW_NAMESPACE_CACHING, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SHI1005_FLAGS_ACCESS_BASED_DIRECTORY_ENUM", SHI1005_FLAGS_ACCESS_BASED_DIRECTORY_ENUM, r);
	ndr->depth--;
}

_PUBLIC_ void ndr_print_NetJoinDomain(struct ndr_print *ndr, const char *name, int flags, const struct NetJoinDomain *r)
{
	ndr_print_struct(ndr, name, "NetJoinDomain");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "NetJoinDomain");
		ndr->depth++;
		ndr_print_ptr(ndr, "server", r->in.server);
		ndr->depth++;
		if (r->in.server) {
			ndr_print_string(ndr, "server", r->in.server);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "domain", r->in.domain);
		ndr->depth++;
		ndr_print_string(ndr, "domain", r->in.domain);
		ndr->depth--;
		ndr_print_ptr(ndr, "account_ou", r->in.account_ou);
		ndr->depth++;
		if (r->in.account_ou) {
			ndr_print_string(ndr, "account_ou", r->in.account_ou);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "account", r->in.account);
		ndr->depth++;
		if (r->in.account) {
			ndr_print_string(ndr, "account", r->in.account);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "password", r->in.password);
		ndr->depth++;
		if (r->in.password) {
			ndr_print_string(ndr, "password", r->in.password);
		}
		ndr->depth--;
		ndr_print_NetJoinFlags(ndr, "join_flags", r->in.join_flags);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "NetJoinDomain");
		ndr->depth++;
		ndr_print_NET_API_STATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ void ndr_print_NetUnjoinDomain(struct ndr_print *ndr, const char *name, int flags, const struct NetUnjoinDomain *r)
{
	ndr_print_struct(ndr, name, "NetUnjoinDomain");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "NetUnjoinDomain");
		ndr->depth++;
		ndr_print_ptr(ndr, "server_name", r->in.server_name);
		ndr->depth++;
		if (r->in.server_name) {
			ndr_print_string(ndr, "server_name", r->in.server_name);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "account", r->in.account);
		ndr->depth++;
		if (r->in.account) {
			ndr_print_string(ndr, "account", r->in.account);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "password", r->in.password);
		ndr->depth++;
		if (r->in.password) {
			ndr_print_string(ndr, "password", r->in.password);
		}
		ndr->depth--;
		ndr_print_NetJoinFlags(ndr, "unjoin_flags", r->in.unjoin_flags);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "NetUnjoinDomain");
		ndr->depth++;
		ndr_print_NET_API_STATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ void ndr_print_NetGetJoinInformation(struct ndr_print *ndr, const char *name, int flags, const struct NetGetJoinInformation *r)
{
	ndr_print_struct(ndr, name, "NetGetJoinInformation");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "NetGetJoinInformation");
		ndr->depth++;
		ndr_print_ptr(ndr, "server_name", r->in.server_name);
		ndr->depth++;
		if (r->in.server_name) {
			ndr_print_string(ndr, "server_name", r->in.server_name);
		}
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "NetGetJoinInformation");
		ndr->depth++;
		ndr_print_ptr(ndr, "name_buffer", r->out.name_buffer);
		ndr->depth++;
		ndr_print_ptr(ndr, "name_buffer", *r->out.name_buffer);
		ndr->depth++;
		if (*r->out.name_buffer) {
			ndr_print_string(ndr, "name_buffer", *r->out.name_buffer);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_ptr(ndr, "name_type", r->out.name_type);
		ndr->depth++;
		ndr_print_uint16(ndr, "name_type", *r->out.name_type);
		ndr->depth--;
		ndr_print_NET_API_STATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ void ndr_print_NetGetJoinableOUs(struct ndr_print *ndr, const char *name, int flags, const struct NetGetJoinableOUs *r)
{
	ndr_print_struct(ndr, name, "NetGetJoinableOUs");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "NetGetJoinableOUs");
		ndr->depth++;
		ndr_print_ptr(ndr, "server_name", r->in.server_name);
		ndr->depth++;
		if (r->in.server_name) {
			ndr_print_string(ndr, "server_name", r->in.server_name);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "domain", r->in.domain);
		ndr->depth++;
		ndr_print_string(ndr, "domain", r->in.domain);
		ndr->depth--;
		ndr_print_ptr(ndr, "account", r->in.account);
		ndr->depth++;
		if (r->in.account) {
			ndr_print_string(ndr, "account", r->in.account);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "password", r->in.password);
		ndr->depth++;
		if (r->in.password) {
			ndr_print_string(ndr, "password", r->in.password);
		}
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "NetGetJoinableOUs");
		ndr->depth++;
		ndr_print_ptr(ndr, "ou_count", r->out.ou_count);
		ndr->depth++;
		ndr_print_uint32(ndr, "ou_count", *r->out.ou_count);
		ndr->depth--;
		ndr_print_ptr(ndr, "ous", r->out.ous);
		ndr->depth++;
		ndr_print_ptr(ndr, "ous", *r->out.ous);
		ndr->depth++;
		if (*r->out.ous) {
			ndr_print_ptr(ndr, "ous", **r->out.ous);
			ndr->depth++;
			if (**r->out.ous) {
				ndr_print_string(ndr, "ous", **r->out.ous);
			}
			ndr->depth--;
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_NET_API_STATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ void ndr_print_NetRenameMachineInDomain(struct ndr_print *ndr, const char *name, int flags, const struct NetRenameMachineInDomain *r)
{
	ndr_print_struct(ndr, name, "NetRenameMachineInDomain");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "NetRenameMachineInDomain");
		ndr->depth++;
		ndr_print_string(ndr, "server_name", r->in.server_name);
		ndr_print_string(ndr, "new_machine_name", r->in.new_machine_name);
		ndr_print_string(ndr, "account", r->in.account);
		ndr_print_string(ndr, "password", r->in.password);
		ndr_print_uint32(ndr, "rename_options", r->in.rename_options);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "NetRenameMachineInDomain");
		ndr->depth++;
		ndr_print_NET_API_STATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ void ndr_print_NetServerGetInfo(struct ndr_print *ndr, const char *name, int flags, const struct NetServerGetInfo *r)
{
	ndr_print_struct(ndr, name, "NetServerGetInfo");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "NetServerGetInfo");
		ndr->depth++;
		ndr_print_ptr(ndr, "server_name", r->in.server_name);
		ndr->depth++;
		if (r->in.server_name) {
			ndr_print_string(ndr, "server_name", r->in.server_name);
		}
		ndr->depth--;
		ndr_print_uint32(ndr, "level", r->in.level);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "NetServerGetInfo");
		ndr->depth++;
		ndr_print_ptr(ndr, "buffer", r->out.buffer);
		ndr->depth++;
		ndr_print_ptr(ndr, "buffer", *r->out.buffer);
		ndr->depth++;
		if (*r->out.buffer) {
			ndr_print_uint8(ndr, "buffer", **r->out.buffer);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_NET_API_STATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ void ndr_print_NetServerSetInfo(struct ndr_print *ndr, const char *name, int flags, const struct NetServerSetInfo *r)
{
	ndr_print_struct(ndr, name, "NetServerSetInfo");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "NetServerSetInfo");
		ndr->depth++;
		ndr_print_ptr(ndr, "server_name", r->in.server_name);
		ndr->depth++;
		if (r->in.server_name) {
			ndr_print_string(ndr, "server_name", r->in.server_name);
		}
		ndr->depth--;
		ndr_print_uint32(ndr, "level", r->in.level);
		ndr_print_ptr(ndr, "buffer", r->in.buffer);
		ndr->depth++;
		ndr_print_uint8(ndr, "buffer", *r->in.buffer);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "NetServerSetInfo");
		ndr->depth++;
		ndr_print_ptr(ndr, "parm_error", r->out.parm_error);
		ndr->depth++;
		ndr_print_uint32(ndr, "parm_error", *r->out.parm_error);
		ndr->depth--;
		ndr_print_NET_API_STATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ void ndr_print_NetGetDCName(struct ndr_print *ndr, const char *name, int flags, const struct NetGetDCName *r)
{
	ndr_print_struct(ndr, name, "NetGetDCName");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "NetGetDCName");
		ndr->depth++;
		ndr_print_ptr(ndr, "server_name", r->in.server_name);
		ndr->depth++;
		if (r->in.server_name) {
			ndr_print_string(ndr, "server_name", r->in.server_name);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "domain_name", r->in.domain_name);
		ndr->depth++;
		if (r->in.domain_name) {
			ndr_print_string(ndr, "domain_name", r->in.domain_name);
		}
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "NetGetDCName");
		ndr->depth++;
		ndr_print_ptr(ndr, "buffer", r->out.buffer);
		ndr->depth++;
		ndr_print_ptr(ndr, "buffer", *r->out.buffer);
		ndr->depth++;
		if (*r->out.buffer) {
			ndr_print_uint8(ndr, "buffer", **r->out.buffer);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_NET_API_STATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ void ndr_print_NetGetAnyDCName(struct ndr_print *ndr, const char *name, int flags, const struct NetGetAnyDCName *r)
{
	ndr_print_struct(ndr, name, "NetGetAnyDCName");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "NetGetAnyDCName");
		ndr->depth++;
		ndr_print_ptr(ndr, "server_name", r->in.server_name);
		ndr->depth++;
		if (r->in.server_name) {
			ndr_print_string(ndr, "server_name", r->in.server_name);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "domain_name", r->in.domain_name);
		ndr->depth++;
		if (r->in.domain_name) {
			ndr_print_string(ndr, "domain_name", r->in.domain_name);
		}
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "NetGetAnyDCName");
		ndr->depth++;
		ndr_print_ptr(ndr, "buffer", r->out.buffer);
		ndr->depth++;
		ndr_print_ptr(ndr, "buffer", *r->out.buffer);
		ndr->depth++;
		if (*r->out.buffer) {
			ndr_print_uint8(ndr, "buffer", **r->out.buffer);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_NET_API_STATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ void ndr_print_DsGetDcName(struct ndr_print *ndr, const char *name, int flags, const struct DsGetDcName *r)
{
	ndr_print_struct(ndr, name, "DsGetDcName");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "DsGetDcName");
		ndr->depth++;
		ndr_print_ptr(ndr, "server_name", r->in.server_name);
		ndr->depth++;
		if (r->in.server_name) {
			ndr_print_string(ndr, "server_name", r->in.server_name);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "domain_name", r->in.domain_name);
		ndr->depth++;
		ndr_print_string(ndr, "domain_name", r->in.domain_name);
		ndr->depth--;
		ndr_print_ptr(ndr, "domain_guid", r->in.domain_guid);
		ndr->depth++;
		if (r->in.domain_guid) {
			ndr_print_GUID(ndr, "domain_guid", r->in.domain_guid);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "site_name", r->in.site_name);
		ndr->depth++;
		if (r->in.site_name) {
			ndr_print_string(ndr, "site_name", r->in.site_name);
		}
		ndr->depth--;
		ndr_print_uint32(ndr, "flags", r->in.flags);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "DsGetDcName");
		ndr->depth++;
		ndr_print_ptr(ndr, "dc_info", r->out.dc_info);
		ndr->depth++;
		ndr_print_ptr(ndr, "dc_info", *r->out.dc_info);
		ndr->depth++;
		if (*r->out.dc_info) {
			ndr_print_DOMAIN_CONTROLLER_INFO(ndr, "dc_info", *r->out.dc_info);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_NET_API_STATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ void ndr_print_NetUserAdd(struct ndr_print *ndr, const char *name, int flags, const struct NetUserAdd *r)
{
	ndr_print_struct(ndr, name, "NetUserAdd");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "NetUserAdd");
		ndr->depth++;
		ndr_print_ptr(ndr, "server_name", r->in.server_name);
		ndr->depth++;
		if (r->in.server_name) {
			ndr_print_string(ndr, "server_name", r->in.server_name);
		}
		ndr->depth--;
		ndr_print_uint32(ndr, "level", r->in.level);
		ndr_print_ptr(ndr, "buffer", r->in.buffer);
		ndr->depth++;
		ndr_print_uint8(ndr, "buffer", *r->in.buffer);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "NetUserAdd");
		ndr->depth++;
		ndr_print_ptr(ndr, "parm_error", r->out.parm_error);
		ndr->depth++;
		ndr_print_uint32(ndr, "parm_error", *r->out.parm_error);
		ndr->depth--;
		ndr_print_NET_API_STATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ void ndr_print_NetUserDel(struct ndr_print *ndr, const char *name, int flags, const struct NetUserDel *r)
{
	ndr_print_struct(ndr, name, "NetUserDel");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "NetUserDel");
		ndr->depth++;
		ndr_print_ptr(ndr, "server_name", r->in.server_name);
		ndr->depth++;
		if (r->in.server_name) {
			ndr_print_string(ndr, "server_name", r->in.server_name);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "user_name", r->in.user_name);
		ndr->depth++;
		ndr_print_string(ndr, "user_name", r->in.user_name);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "NetUserDel");
		ndr->depth++;
		ndr_print_NET_API_STATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ void ndr_print_NetUserEnum(struct ndr_print *ndr, const char *name, int flags, const struct NetUserEnum *r)
{
	ndr_print_struct(ndr, name, "NetUserEnum");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "NetUserEnum");
		ndr->depth++;
		ndr_print_ptr(ndr, "server_name", r->in.server_name);
		ndr->depth++;
		if (r->in.server_name) {
			ndr_print_string(ndr, "server_name", r->in.server_name);
		}
		ndr->depth--;
		ndr_print_uint32(ndr, "level", r->in.level);
		ndr_print_uint32(ndr, "filter", r->in.filter);
		ndr_print_uint32(ndr, "prefmaxlen", r->in.prefmaxlen);
		ndr_print_ptr(ndr, "resume_handle", r->in.resume_handle);
		ndr->depth++;
		ndr_print_uint32(ndr, "resume_handle", *r->in.resume_handle);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "NetUserEnum");
		ndr->depth++;
		ndr_print_ptr(ndr, "buffer", r->out.buffer);
		ndr->depth++;
		ndr_print_ptr(ndr, "buffer", *r->out.buffer);
		ndr->depth++;
		if (*r->out.buffer) {
			ndr_print_uint8(ndr, "buffer", **r->out.buffer);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_ptr(ndr, "entries_read", r->out.entries_read);
		ndr->depth++;
		ndr_print_uint32(ndr, "entries_read", *r->out.entries_read);
		ndr->depth--;
		ndr_print_ptr(ndr, "total_entries", r->out.total_entries);
		ndr->depth++;
		ndr_print_uint32(ndr, "total_entries", *r->out.total_entries);
		ndr->depth--;
		ndr_print_ptr(ndr, "resume_handle", r->out.resume_handle);
		ndr->depth++;
		ndr_print_uint32(ndr, "resume_handle", *r->out.resume_handle);
		ndr->depth--;
		ndr_print_NET_API_STATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ void ndr_print_NetUserChangePassword(struct ndr_print *ndr, const char *name, int flags, const struct NetUserChangePassword *r)
{
	ndr_print_struct(ndr, name, "NetUserChangePassword");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "NetUserChangePassword");
		ndr->depth++;
		ndr_print_string(ndr, "domain_name", r->in.domain_name);
		ndr_print_string(ndr, "user_name", r->in.user_name);
		ndr_print_string(ndr, "old_password", r->in.old_password);
		ndr_print_string(ndr, "new_password", r->in.new_password);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "NetUserChangePassword");
		ndr->depth++;
		ndr_print_NET_API_STATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ void ndr_print_NetUserGetInfo(struct ndr_print *ndr, const char *name, int flags, const struct NetUserGetInfo *r)
{
	ndr_print_struct(ndr, name, "NetUserGetInfo");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "NetUserGetInfo");
		ndr->depth++;
		ndr_print_string(ndr, "server_name", r->in.server_name);
		ndr_print_string(ndr, "user_name", r->in.user_name);
		ndr_print_uint32(ndr, "level", r->in.level);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "NetUserGetInfo");
		ndr->depth++;
		ndr_print_ptr(ndr, "buffer", r->out.buffer);
		ndr->depth++;
		ndr_print_ptr(ndr, "buffer", *r->out.buffer);
		ndr->depth++;
		if (*r->out.buffer) {
			ndr_print_uint8(ndr, "buffer", **r->out.buffer);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_NET_API_STATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ void ndr_print_NetUserSetInfo(struct ndr_print *ndr, const char *name, int flags, const struct NetUserSetInfo *r)
{
	ndr_print_struct(ndr, name, "NetUserSetInfo");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "NetUserSetInfo");
		ndr->depth++;
		ndr_print_string(ndr, "server_name", r->in.server_name);
		ndr_print_string(ndr, "user_name", r->in.user_name);
		ndr_print_uint32(ndr, "level", r->in.level);
		ndr_print_ptr(ndr, "buffer", r->in.buffer);
		ndr->depth++;
		ndr_print_uint8(ndr, "buffer", *r->in.buffer);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "NetUserSetInfo");
		ndr->depth++;
		ndr_print_ptr(ndr, "parm_err", r->out.parm_err);
		ndr->depth++;
		ndr_print_uint32(ndr, "parm_err", *r->out.parm_err);
		ndr->depth--;
		ndr_print_NET_API_STATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ void ndr_print_NetUserGetGroups(struct ndr_print *ndr, const char *name, int flags, const struct NetUserGetGroups *r)
{
	ndr_print_struct(ndr, name, "NetUserGetGroups");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "NetUserGetGroups");
		ndr->depth++;
		ndr_print_string(ndr, "server_name", r->in.server_name);
		ndr_print_string(ndr, "user_name", r->in.user_name);
		ndr_print_uint32(ndr, "level", r->in.level);
		ndr_print_uint32(ndr, "prefmaxlen", r->in.prefmaxlen);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "NetUserGetGroups");
		ndr->depth++;
		ndr_print_ptr(ndr, "buffer", r->out.buffer);
		ndr->depth++;
		ndr_print_ptr(ndr, "buffer", *r->out.buffer);
		ndr->depth++;
		if (*r->out.buffer) {
			ndr_print_uint8(ndr, "buffer", **r->out.buffer);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_ptr(ndr, "entries_read", r->out.entries_read);
		ndr->depth++;
		ndr_print_uint32(ndr, "entries_read", *r->out.entries_read);
		ndr->depth--;
		ndr_print_ptr(ndr, "total_entries", r->out.total_entries);
		ndr->depth++;
		ndr_print_uint32(ndr, "total_entries", *r->out.total_entries);
		ndr->depth--;
		ndr_print_NET_API_STATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ void ndr_print_NetUserSetGroups(struct ndr_print *ndr, const char *name, int flags, const struct NetUserSetGroups *r)
{
	ndr_print_struct(ndr, name, "NetUserSetGroups");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "NetUserSetGroups");
		ndr->depth++;
		ndr_print_string(ndr, "server_name", r->in.server_name);
		ndr_print_string(ndr, "user_name", r->in.user_name);
		ndr_print_uint32(ndr, "level", r->in.level);
		ndr_print_ptr(ndr, "buffer", r->in.buffer);
		ndr->depth++;
		ndr_print_uint8(ndr, "buffer", *r->in.buffer);
		ndr->depth--;
		ndr_print_uint32(ndr, "num_entries", r->in.num_entries);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "NetUserSetGroups");
		ndr->depth++;
		ndr_print_NET_API_STATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ void ndr_print_NetUserGetLocalGroups(struct ndr_print *ndr, const char *name, int flags, const struct NetUserGetLocalGroups *r)
{
	ndr_print_struct(ndr, name, "NetUserGetLocalGroups");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "NetUserGetLocalGroups");
		ndr->depth++;
		ndr_print_string(ndr, "server_name", r->in.server_name);
		ndr_print_string(ndr, "user_name", r->in.user_name);
		ndr_print_uint32(ndr, "level", r->in.level);
		ndr_print_uint32(ndr, "flags", r->in.flags);
		ndr_print_uint32(ndr, "prefmaxlen", r->in.prefmaxlen);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "NetUserGetLocalGroups");
		ndr->depth++;
		ndr_print_ptr(ndr, "buffer", r->out.buffer);
		ndr->depth++;
		ndr_print_ptr(ndr, "buffer", *r->out.buffer);
		ndr->depth++;
		if (*r->out.buffer) {
			ndr_print_uint8(ndr, "buffer", **r->out.buffer);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_ptr(ndr, "entries_read", r->out.entries_read);
		ndr->depth++;
		ndr_print_uint32(ndr, "entries_read", *r->out.entries_read);
		ndr->depth--;
		ndr_print_ptr(ndr, "total_entries", r->out.total_entries);
		ndr->depth++;
		ndr_print_uint32(ndr, "total_entries", *r->out.total_entries);
		ndr->depth--;
		ndr_print_NET_API_STATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ void ndr_print_NetUserModalsGet(struct ndr_print *ndr, const char *name, int flags, const struct NetUserModalsGet *r)
{
	ndr_print_struct(ndr, name, "NetUserModalsGet");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "NetUserModalsGet");
		ndr->depth++;
		ndr_print_string(ndr, "server_name", r->in.server_name);
		ndr_print_uint32(ndr, "level", r->in.level);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "NetUserModalsGet");
		ndr->depth++;
		ndr_print_ptr(ndr, "buffer", r->out.buffer);
		ndr->depth++;
		ndr_print_ptr(ndr, "buffer", *r->out.buffer);
		ndr->depth++;
		if (*r->out.buffer) {
			ndr_print_uint8(ndr, "buffer", **r->out.buffer);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_NET_API_STATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ void ndr_print_NetUserModalsSet(struct ndr_print *ndr, const char *name, int flags, const struct NetUserModalsSet *r)
{
	ndr_print_struct(ndr, name, "NetUserModalsSet");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "NetUserModalsSet");
		ndr->depth++;
		ndr_print_string(ndr, "server_name", r->in.server_name);
		ndr_print_uint32(ndr, "level", r->in.level);
		ndr_print_ptr(ndr, "buffer", r->in.buffer);
		ndr->depth++;
		ndr_print_uint8(ndr, "buffer", *r->in.buffer);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "NetUserModalsSet");
		ndr->depth++;
		ndr_print_ptr(ndr, "parm_err", r->out.parm_err);
		ndr->depth++;
		ndr_print_uint32(ndr, "parm_err", *r->out.parm_err);
		ndr->depth--;
		ndr_print_NET_API_STATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ void ndr_print_NetQueryDisplayInformation(struct ndr_print *ndr, const char *name, int flags, const struct NetQueryDisplayInformation *r)
{
	ndr_print_struct(ndr, name, "NetQueryDisplayInformation");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "NetQueryDisplayInformation");
		ndr->depth++;
		ndr_print_ptr(ndr, "server_name", r->in.server_name);
		ndr->depth++;
		if (r->in.server_name) {
			ndr_print_string(ndr, "server_name", r->in.server_name);
		}
		ndr->depth--;
		ndr_print_uint32(ndr, "level", r->in.level);
		ndr_print_uint32(ndr, "idx", r->in.idx);
		ndr_print_uint32(ndr, "entries_requested", r->in.entries_requested);
		ndr_print_uint32(ndr, "prefmaxlen", r->in.prefmaxlen);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "NetQueryDisplayInformation");
		ndr->depth++;
		ndr_print_ptr(ndr, "entries_read", r->out.entries_read);
		ndr->depth++;
		ndr_print_uint32(ndr, "entries_read", *r->out.entries_read);
		ndr->depth--;
		ndr_print_NET_API_STATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ void ndr_print_NetGroupAdd(struct ndr_print *ndr, const char *name, int flags, const struct NetGroupAdd *r)
{
	ndr_print_struct(ndr, name, "NetGroupAdd");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "NetGroupAdd");
		ndr->depth++;
		ndr_print_string(ndr, "server_name", r->in.server_name);
		ndr_print_uint32(ndr, "level", r->in.level);
		ndr_print_ptr(ndr, "buffer", r->in.buffer);
		ndr->depth++;
		ndr_print_uint8(ndr, "buffer", *r->in.buffer);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "NetGroupAdd");
		ndr->depth++;
		ndr_print_ptr(ndr, "parm_err", r->out.parm_err);
		ndr->depth++;
		ndr_print_uint32(ndr, "parm_err", *r->out.parm_err);
		ndr->depth--;
		ndr_print_NET_API_STATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ void ndr_print_NetGroupDel(struct ndr_print *ndr, const char *name, int flags, const struct NetGroupDel *r)
{
	ndr_print_struct(ndr, name, "NetGroupDel");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "NetGroupDel");
		ndr->depth++;
		ndr_print_string(ndr, "server_name", r->in.server_name);
		ndr_print_string(ndr, "group_name", r->in.group_name);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "NetGroupDel");
		ndr->depth++;
		ndr_print_NET_API_STATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ void ndr_print_NetGroupEnum(struct ndr_print *ndr, const char *name, int flags, const struct NetGroupEnum *r)
{
	ndr_print_struct(ndr, name, "NetGroupEnum");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "NetGroupEnum");
		ndr->depth++;
		ndr_print_string(ndr, "server_name", r->in.server_name);
		ndr_print_uint32(ndr, "level", r->in.level);
		ndr_print_uint32(ndr, "prefmaxlen", r->in.prefmaxlen);
		ndr_print_ptr(ndr, "resume_handle", r->in.resume_handle);
		ndr->depth++;
		ndr_print_uint32(ndr, "resume_handle", *r->in.resume_handle);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "NetGroupEnum");
		ndr->depth++;
		ndr_print_ptr(ndr, "buffer", r->out.buffer);
		ndr->depth++;
		ndr_print_ptr(ndr, "buffer", *r->out.buffer);
		ndr->depth++;
		if (*r->out.buffer) {
			ndr_print_uint8(ndr, "buffer", **r->out.buffer);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_ptr(ndr, "entries_read", r->out.entries_read);
		ndr->depth++;
		ndr_print_uint32(ndr, "entries_read", *r->out.entries_read);
		ndr->depth--;
		ndr_print_ptr(ndr, "total_entries", r->out.total_entries);
		ndr->depth++;
		ndr_print_uint32(ndr, "total_entries", *r->out.total_entries);
		ndr->depth--;
		ndr_print_ptr(ndr, "resume_handle", r->out.resume_handle);
		ndr->depth++;
		ndr_print_uint32(ndr, "resume_handle", *r->out.resume_handle);
		ndr->depth--;
		ndr_print_NET_API_STATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ void ndr_print_NetGroupSetInfo(struct ndr_print *ndr, const char *name, int flags, const struct NetGroupSetInfo *r)
{
	ndr_print_struct(ndr, name, "NetGroupSetInfo");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "NetGroupSetInfo");
		ndr->depth++;
		ndr_print_string(ndr, "server_name", r->in.server_name);
		ndr_print_string(ndr, "group_name", r->in.group_name);
		ndr_print_uint32(ndr, "level", r->in.level);
		ndr_print_ptr(ndr, "buffer", r->in.buffer);
		ndr->depth++;
		ndr_print_uint8(ndr, "buffer", *r->in.buffer);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "NetGroupSetInfo");
		ndr->depth++;
		ndr_print_ptr(ndr, "parm_err", r->out.parm_err);
		ndr->depth++;
		ndr_print_uint32(ndr, "parm_err", *r->out.parm_err);
		ndr->depth--;
		ndr_print_NET_API_STATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ void ndr_print_NetGroupGetInfo(struct ndr_print *ndr, const char *name, int flags, const struct NetGroupGetInfo *r)
{
	ndr_print_struct(ndr, name, "NetGroupGetInfo");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "NetGroupGetInfo");
		ndr->depth++;
		ndr_print_string(ndr, "server_name", r->in.server_name);
		ndr_print_string(ndr, "group_name", r->in.group_name);
		ndr_print_uint32(ndr, "level", r->in.level);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "NetGroupGetInfo");
		ndr->depth++;
		ndr_print_ptr(ndr, "buffer", r->out.buffer);
		ndr->depth++;
		ndr_print_ptr(ndr, "buffer", *r->out.buffer);
		ndr->depth++;
		if (*r->out.buffer) {
			ndr_print_uint8(ndr, "buffer", **r->out.buffer);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_NET_API_STATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ void ndr_print_NetGroupAddUser(struct ndr_print *ndr, const char *name, int flags, const struct NetGroupAddUser *r)
{
	ndr_print_struct(ndr, name, "NetGroupAddUser");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "NetGroupAddUser");
		ndr->depth++;
		ndr_print_string(ndr, "server_name", r->in.server_name);
		ndr_print_string(ndr, "group_name", r->in.group_name);
		ndr_print_string(ndr, "user_name", r->in.user_name);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "NetGroupAddUser");
		ndr->depth++;
		ndr_print_NET_API_STATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ void ndr_print_NetGroupDelUser(struct ndr_print *ndr, const char *name, int flags, const struct NetGroupDelUser *r)
{
	ndr_print_struct(ndr, name, "NetGroupDelUser");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "NetGroupDelUser");
		ndr->depth++;
		ndr_print_string(ndr, "server_name", r->in.server_name);
		ndr_print_string(ndr, "group_name", r->in.group_name);
		ndr_print_string(ndr, "user_name", r->in.user_name);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "NetGroupDelUser");
		ndr->depth++;
		ndr_print_NET_API_STATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ void ndr_print_NetGroupGetUsers(struct ndr_print *ndr, const char *name, int flags, const struct NetGroupGetUsers *r)
{
	ndr_print_struct(ndr, name, "NetGroupGetUsers");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "NetGroupGetUsers");
		ndr->depth++;
		ndr_print_string(ndr, "server_name", r->in.server_name);
		ndr_print_string(ndr, "group_name", r->in.group_name);
		ndr_print_uint32(ndr, "level", r->in.level);
		ndr_print_uint32(ndr, "prefmaxlen", r->in.prefmaxlen);
		ndr_print_ptr(ndr, "resume_handle", r->in.resume_handle);
		ndr->depth++;
		ndr_print_uint32(ndr, "resume_handle", *r->in.resume_handle);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "NetGroupGetUsers");
		ndr->depth++;
		ndr_print_ptr(ndr, "buffer", r->out.buffer);
		ndr->depth++;
		ndr_print_ptr(ndr, "buffer", *r->out.buffer);
		ndr->depth++;
		if (*r->out.buffer) {
			ndr_print_uint8(ndr, "buffer", **r->out.buffer);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_ptr(ndr, "entries_read", r->out.entries_read);
		ndr->depth++;
		ndr_print_uint32(ndr, "entries_read", *r->out.entries_read);
		ndr->depth--;
		ndr_print_ptr(ndr, "total_entries", r->out.total_entries);
		ndr->depth++;
		ndr_print_uint32(ndr, "total_entries", *r->out.total_entries);
		ndr->depth--;
		ndr_print_ptr(ndr, "resume_handle", r->out.resume_handle);
		ndr->depth++;
		ndr_print_uint32(ndr, "resume_handle", *r->out.resume_handle);
		ndr->depth--;
		ndr_print_NET_API_STATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ void ndr_print_NetGroupSetUsers(struct ndr_print *ndr, const char *name, int flags, const struct NetGroupSetUsers *r)
{
	ndr_print_struct(ndr, name, "NetGroupSetUsers");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "NetGroupSetUsers");
		ndr->depth++;
		ndr_print_string(ndr, "server_name", r->in.server_name);
		ndr_print_string(ndr, "group_name", r->in.group_name);
		ndr_print_uint32(ndr, "level", r->in.level);
		ndr_print_ptr(ndr, "buffer", r->in.buffer);
		ndr->depth++;
		ndr_print_uint8(ndr, "buffer", *r->in.buffer);
		ndr->depth--;
		ndr_print_uint32(ndr, "num_entries", r->in.num_entries);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "NetGroupSetUsers");
		ndr->depth++;
		ndr_print_NET_API_STATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ void ndr_print_NetLocalGroupAdd(struct ndr_print *ndr, const char *name, int flags, const struct NetLocalGroupAdd *r)
{
	ndr_print_struct(ndr, name, "NetLocalGroupAdd");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "NetLocalGroupAdd");
		ndr->depth++;
		ndr_print_string(ndr, "server_name", r->in.server_name);
		ndr_print_uint32(ndr, "level", r->in.level);
		ndr_print_ptr(ndr, "buffer", r->in.buffer);
		ndr->depth++;
		ndr_print_uint8(ndr, "buffer", *r->in.buffer);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "NetLocalGroupAdd");
		ndr->depth++;
		ndr_print_ptr(ndr, "parm_err", r->out.parm_err);
		ndr->depth++;
		ndr_print_uint32(ndr, "parm_err", *r->out.parm_err);
		ndr->depth--;
		ndr_print_NET_API_STATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ void ndr_print_NetLocalGroupDel(struct ndr_print *ndr, const char *name, int flags, const struct NetLocalGroupDel *r)
{
	ndr_print_struct(ndr, name, "NetLocalGroupDel");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "NetLocalGroupDel");
		ndr->depth++;
		ndr_print_string(ndr, "server_name", r->in.server_name);
		ndr_print_string(ndr, "group_name", r->in.group_name);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "NetLocalGroupDel");
		ndr->depth++;
		ndr_print_NET_API_STATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ void ndr_print_NetLocalGroupGetInfo(struct ndr_print *ndr, const char *name, int flags, const struct NetLocalGroupGetInfo *r)
{
	ndr_print_struct(ndr, name, "NetLocalGroupGetInfo");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "NetLocalGroupGetInfo");
		ndr->depth++;
		ndr_print_string(ndr, "server_name", r->in.server_name);
		ndr_print_string(ndr, "group_name", r->in.group_name);
		ndr_print_uint32(ndr, "level", r->in.level);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "NetLocalGroupGetInfo");
		ndr->depth++;
		ndr_print_ptr(ndr, "buffer", r->out.buffer);
		ndr->depth++;
		ndr_print_ptr(ndr, "buffer", *r->out.buffer);
		ndr->depth++;
		if (*r->out.buffer) {
			ndr_print_uint8(ndr, "buffer", **r->out.buffer);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_NET_API_STATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ void ndr_print_NetLocalGroupSetInfo(struct ndr_print *ndr, const char *name, int flags, const struct NetLocalGroupSetInfo *r)
{
	ndr_print_struct(ndr, name, "NetLocalGroupSetInfo");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "NetLocalGroupSetInfo");
		ndr->depth++;
		ndr_print_string(ndr, "server_name", r->in.server_name);
		ndr_print_string(ndr, "group_name", r->in.group_name);
		ndr_print_uint32(ndr, "level", r->in.level);
		ndr_print_ptr(ndr, "buffer", r->in.buffer);
		ndr->depth++;
		ndr_print_uint8(ndr, "buffer", *r->in.buffer);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "NetLocalGroupSetInfo");
		ndr->depth++;
		ndr_print_ptr(ndr, "parm_err", r->out.parm_err);
		ndr->depth++;
		ndr_print_uint32(ndr, "parm_err", *r->out.parm_err);
		ndr->depth--;
		ndr_print_NET_API_STATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ void ndr_print_NetLocalGroupEnum(struct ndr_print *ndr, const char *name, int flags, const struct NetLocalGroupEnum *r)
{
	ndr_print_struct(ndr, name, "NetLocalGroupEnum");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "NetLocalGroupEnum");
		ndr->depth++;
		ndr_print_string(ndr, "server_name", r->in.server_name);
		ndr_print_uint32(ndr, "level", r->in.level);
		ndr_print_uint32(ndr, "prefmaxlen", r->in.prefmaxlen);
		ndr_print_ptr(ndr, "resume_handle", r->in.resume_handle);
		ndr->depth++;
		ndr_print_uint32(ndr, "resume_handle", *r->in.resume_handle);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "NetLocalGroupEnum");
		ndr->depth++;
		ndr_print_ptr(ndr, "buffer", r->out.buffer);
		ndr->depth++;
		ndr_print_ptr(ndr, "buffer", *r->out.buffer);
		ndr->depth++;
		if (*r->out.buffer) {
			ndr_print_uint8(ndr, "buffer", **r->out.buffer);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_ptr(ndr, "entries_read", r->out.entries_read);
		ndr->depth++;
		ndr_print_uint32(ndr, "entries_read", *r->out.entries_read);
		ndr->depth--;
		ndr_print_ptr(ndr, "total_entries", r->out.total_entries);
		ndr->depth++;
		ndr_print_uint32(ndr, "total_entries", *r->out.total_entries);
		ndr->depth--;
		ndr_print_ptr(ndr, "resume_handle", r->out.resume_handle);
		ndr->depth++;
		ndr_print_uint32(ndr, "resume_handle", *r->out.resume_handle);
		ndr->depth--;
		ndr_print_NET_API_STATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ void ndr_print_NetLocalGroupAddMembers(struct ndr_print *ndr, const char *name, int flags, const struct NetLocalGroupAddMembers *r)
{
	ndr_print_struct(ndr, name, "NetLocalGroupAddMembers");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "NetLocalGroupAddMembers");
		ndr->depth++;
		ndr_print_string(ndr, "server_name", r->in.server_name);
		ndr_print_string(ndr, "group_name", r->in.group_name);
		ndr_print_uint32(ndr, "level", r->in.level);
		ndr_print_ptr(ndr, "buffer", r->in.buffer);
		ndr->depth++;
		ndr_print_uint8(ndr, "buffer", *r->in.buffer);
		ndr->depth--;
		ndr_print_uint32(ndr, "total_entries", r->in.total_entries);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "NetLocalGroupAddMembers");
		ndr->depth++;
		ndr_print_NET_API_STATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ void ndr_print_NetLocalGroupDelMembers(struct ndr_print *ndr, const char *name, int flags, const struct NetLocalGroupDelMembers *r)
{
	ndr_print_struct(ndr, name, "NetLocalGroupDelMembers");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "NetLocalGroupDelMembers");
		ndr->depth++;
		ndr_print_string(ndr, "server_name", r->in.server_name);
		ndr_print_string(ndr, "group_name", r->in.group_name);
		ndr_print_uint32(ndr, "level", r->in.level);
		ndr_print_ptr(ndr, "buffer", r->in.buffer);
		ndr->depth++;
		ndr_print_uint8(ndr, "buffer", *r->in.buffer);
		ndr->depth--;
		ndr_print_uint32(ndr, "total_entries", r->in.total_entries);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "NetLocalGroupDelMembers");
		ndr->depth++;
		ndr_print_NET_API_STATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ void ndr_print_NetLocalGroupGetMembers(struct ndr_print *ndr, const char *name, int flags, const struct NetLocalGroupGetMembers *r)
{
	ndr_print_struct(ndr, name, "NetLocalGroupGetMembers");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "NetLocalGroupGetMembers");
		ndr->depth++;
		ndr_print_string(ndr, "server_name", r->in.server_name);
		ndr_print_string(ndr, "local_group_name", r->in.local_group_name);
		ndr_print_uint32(ndr, "level", r->in.level);
		ndr_print_uint32(ndr, "prefmaxlen", r->in.prefmaxlen);
		ndr_print_ptr(ndr, "resume_handle", r->in.resume_handle);
		ndr->depth++;
		ndr_print_uint32(ndr, "resume_handle", *r->in.resume_handle);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "NetLocalGroupGetMembers");
		ndr->depth++;
		ndr_print_ptr(ndr, "buffer", r->out.buffer);
		ndr->depth++;
		ndr_print_ptr(ndr, "buffer", *r->out.buffer);
		ndr->depth++;
		if (*r->out.buffer) {
			ndr_print_uint8(ndr, "buffer", **r->out.buffer);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_ptr(ndr, "entries_read", r->out.entries_read);
		ndr->depth++;
		ndr_print_uint32(ndr, "entries_read", *r->out.entries_read);
		ndr->depth--;
		ndr_print_ptr(ndr, "total_entries", r->out.total_entries);
		ndr->depth++;
		ndr_print_uint32(ndr, "total_entries", *r->out.total_entries);
		ndr->depth--;
		ndr_print_ptr(ndr, "resume_handle", r->out.resume_handle);
		ndr->depth++;
		ndr_print_uint32(ndr, "resume_handle", *r->out.resume_handle);
		ndr->depth--;
		ndr_print_NET_API_STATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ void ndr_print_NetLocalGroupSetMembers(struct ndr_print *ndr, const char *name, int flags, const struct NetLocalGroupSetMembers *r)
{
	ndr_print_struct(ndr, name, "NetLocalGroupSetMembers");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "NetLocalGroupSetMembers");
		ndr->depth++;
		ndr_print_string(ndr, "server_name", r->in.server_name);
		ndr_print_string(ndr, "group_name", r->in.group_name);
		ndr_print_uint32(ndr, "level", r->in.level);
		ndr_print_ptr(ndr, "buffer", r->in.buffer);
		ndr->depth++;
		ndr_print_uint8(ndr, "buffer", *r->in.buffer);
		ndr->depth--;
		ndr_print_uint32(ndr, "total_entries", r->in.total_entries);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "NetLocalGroupSetMembers");
		ndr->depth++;
		ndr_print_NET_API_STATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ void ndr_print_NetRemoteTOD(struct ndr_print *ndr, const char *name, int flags, const struct NetRemoteTOD *r)
{
	ndr_print_struct(ndr, name, "NetRemoteTOD");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "NetRemoteTOD");
		ndr->depth++;
		ndr_print_string(ndr, "server_name", r->in.server_name);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "NetRemoteTOD");
		ndr->depth++;
		ndr_print_ptr(ndr, "buffer", r->out.buffer);
		ndr->depth++;
		ndr_print_ptr(ndr, "buffer", *r->out.buffer);
		ndr->depth++;
		if (*r->out.buffer) {
			ndr_print_uint8(ndr, "buffer", **r->out.buffer);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_NET_API_STATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ void ndr_print_NetShareAdd(struct ndr_print *ndr, const char *name, int flags, const struct NetShareAdd *r)
{
	ndr_print_struct(ndr, name, "NetShareAdd");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "NetShareAdd");
		ndr->depth++;
		ndr_print_string(ndr, "server_name", r->in.server_name);
		ndr_print_uint32(ndr, "level", r->in.level);
		ndr_print_ptr(ndr, "buffer", r->in.buffer);
		ndr->depth++;
		ndr_print_uint8(ndr, "buffer", *r->in.buffer);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "NetShareAdd");
		ndr->depth++;
		ndr_print_ptr(ndr, "parm_err", r->out.parm_err);
		ndr->depth++;
		ndr_print_uint32(ndr, "parm_err", *r->out.parm_err);
		ndr->depth--;
		ndr_print_NET_API_STATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ void ndr_print_NetShareDel(struct ndr_print *ndr, const char *name, int flags, const struct NetShareDel *r)
{
	ndr_print_struct(ndr, name, "NetShareDel");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "NetShareDel");
		ndr->depth++;
		ndr_print_string(ndr, "server_name", r->in.server_name);
		ndr_print_string(ndr, "net_name", r->in.net_name);
		ndr_print_uint32(ndr, "reserved", r->in.reserved);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "NetShareDel");
		ndr->depth++;
		ndr_print_NET_API_STATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ void ndr_print_NetShareEnum(struct ndr_print *ndr, const char *name, int flags, const struct NetShareEnum *r)
{
	ndr_print_struct(ndr, name, "NetShareEnum");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "NetShareEnum");
		ndr->depth++;
		ndr_print_string(ndr, "server_name", r->in.server_name);
		ndr_print_uint32(ndr, "level", r->in.level);
		ndr_print_uint32(ndr, "prefmaxlen", r->in.prefmaxlen);
		ndr_print_ptr(ndr, "resume_handle", r->in.resume_handle);
		ndr->depth++;
		ndr_print_uint32(ndr, "resume_handle", *r->in.resume_handle);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "NetShareEnum");
		ndr->depth++;
		ndr_print_ptr(ndr, "buffer", r->out.buffer);
		ndr->depth++;
		ndr_print_ptr(ndr, "buffer", *r->out.buffer);
		ndr->depth++;
		if (*r->out.buffer) {
			ndr_print_uint8(ndr, "buffer", **r->out.buffer);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_ptr(ndr, "entries_read", r->out.entries_read);
		ndr->depth++;
		ndr_print_uint32(ndr, "entries_read", *r->out.entries_read);
		ndr->depth--;
		ndr_print_ptr(ndr, "total_entries", r->out.total_entries);
		ndr->depth++;
		ndr_print_uint32(ndr, "total_entries", *r->out.total_entries);
		ndr->depth--;
		ndr_print_ptr(ndr, "resume_handle", r->out.resume_handle);
		ndr->depth++;
		ndr_print_uint32(ndr, "resume_handle", *r->out.resume_handle);
		ndr->depth--;
		ndr_print_NET_API_STATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ void ndr_print_NetShareGetInfo(struct ndr_print *ndr, const char *name, int flags, const struct NetShareGetInfo *r)
{
	ndr_print_struct(ndr, name, "NetShareGetInfo");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "NetShareGetInfo");
		ndr->depth++;
		ndr_print_string(ndr, "server_name", r->in.server_name);
		ndr_print_string(ndr, "net_name", r->in.net_name);
		ndr_print_uint32(ndr, "level", r->in.level);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "NetShareGetInfo");
		ndr->depth++;
		ndr_print_ptr(ndr, "buffer", r->out.buffer);
		ndr->depth++;
		ndr_print_ptr(ndr, "buffer", *r->out.buffer);
		ndr->depth++;
		if (*r->out.buffer) {
			ndr_print_uint8(ndr, "buffer", **r->out.buffer);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_NET_API_STATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ void ndr_print_NetShareSetInfo(struct ndr_print *ndr, const char *name, int flags, const struct NetShareSetInfo *r)
{
	ndr_print_struct(ndr, name, "NetShareSetInfo");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "NetShareSetInfo");
		ndr->depth++;
		ndr_print_string(ndr, "server_name", r->in.server_name);
		ndr_print_string(ndr, "net_name", r->in.net_name);
		ndr_print_uint32(ndr, "level", r->in.level);
		ndr_print_ptr(ndr, "buffer", r->in.buffer);
		ndr->depth++;
		ndr_print_uint8(ndr, "buffer", *r->in.buffer);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "NetShareSetInfo");
		ndr->depth++;
		ndr_print_ptr(ndr, "parm_err", r->out.parm_err);
		ndr->depth++;
		ndr_print_uint32(ndr, "parm_err", *r->out.parm_err);
		ndr->depth--;
		ndr_print_NET_API_STATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ void ndr_print_NetFileClose(struct ndr_print *ndr, const char *name, int flags, const struct NetFileClose *r)
{
	ndr_print_struct(ndr, name, "NetFileClose");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "NetFileClose");
		ndr->depth++;
		ndr_print_string(ndr, "server_name", r->in.server_name);
		ndr_print_uint32(ndr, "fileid", r->in.fileid);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "NetFileClose");
		ndr->depth++;
		ndr_print_NET_API_STATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ void ndr_print_NetFileGetInfo(struct ndr_print *ndr, const char *name, int flags, const struct NetFileGetInfo *r)
{
	ndr_print_struct(ndr, name, "NetFileGetInfo");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "NetFileGetInfo");
		ndr->depth++;
		ndr_print_string(ndr, "server_name", r->in.server_name);
		ndr_print_uint32(ndr, "fileid", r->in.fileid);
		ndr_print_uint32(ndr, "level", r->in.level);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "NetFileGetInfo");
		ndr->depth++;
		ndr_print_ptr(ndr, "buffer", r->out.buffer);
		ndr->depth++;
		ndr_print_ptr(ndr, "buffer", *r->out.buffer);
		ndr->depth++;
		if (*r->out.buffer) {
			ndr_print_uint8(ndr, "buffer", **r->out.buffer);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_NET_API_STATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ void ndr_print_NetFileEnum(struct ndr_print *ndr, const char *name, int flags, const struct NetFileEnum *r)
{
	ndr_print_struct(ndr, name, "NetFileEnum");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "NetFileEnum");
		ndr->depth++;
		ndr_print_string(ndr, "server_name", r->in.server_name);
		ndr_print_string(ndr, "base_path", r->in.base_path);
		ndr_print_string(ndr, "user_name", r->in.user_name);
		ndr_print_uint32(ndr, "level", r->in.level);
		ndr_print_uint32(ndr, "prefmaxlen", r->in.prefmaxlen);
		ndr_print_ptr(ndr, "resume_handle", r->in.resume_handle);
		ndr->depth++;
		ndr_print_uint32(ndr, "resume_handle", *r->in.resume_handle);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "NetFileEnum");
		ndr->depth++;
		ndr_print_ptr(ndr, "buffer", r->out.buffer);
		ndr->depth++;
		ndr_print_ptr(ndr, "buffer", *r->out.buffer);
		ndr->depth++;
		if (*r->out.buffer) {
			ndr_print_uint8(ndr, "buffer", **r->out.buffer);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_ptr(ndr, "entries_read", r->out.entries_read);
		ndr->depth++;
		ndr_print_uint32(ndr, "entries_read", *r->out.entries_read);
		ndr->depth--;
		ndr_print_ptr(ndr, "total_entries", r->out.total_entries);
		ndr->depth++;
		ndr_print_uint32(ndr, "total_entries", *r->out.total_entries);
		ndr->depth--;
		ndr_print_ptr(ndr, "resume_handle", r->out.resume_handle);
		ndr->depth++;
		ndr_print_uint32(ndr, "resume_handle", *r->out.resume_handle);
		ndr->depth--;
		ndr_print_NET_API_STATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ void ndr_print_NetShutdownInit(struct ndr_print *ndr, const char *name, int flags, const struct NetShutdownInit *r)
{
	ndr_print_struct(ndr, name, "NetShutdownInit");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "NetShutdownInit");
		ndr->depth++;
		ndr_print_string(ndr, "server_name", r->in.server_name);
		ndr_print_string(ndr, "message", r->in.message);
		ndr_print_uint32(ndr, "timeout", r->in.timeout);
		ndr_print_uint8(ndr, "force_apps", r->in.force_apps);
		ndr_print_uint8(ndr, "do_reboot", r->in.do_reboot);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "NetShutdownInit");
		ndr->depth++;
		ndr_print_NET_API_STATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ void ndr_print_NetShutdownAbort(struct ndr_print *ndr, const char *name, int flags, const struct NetShutdownAbort *r)
{
	ndr_print_struct(ndr, name, "NetShutdownAbort");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "NetShutdownAbort");
		ndr->depth++;
		ndr_print_string(ndr, "server_name", r->in.server_name);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "NetShutdownAbort");
		ndr->depth++;
		ndr_print_NET_API_STATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ void ndr_print_I_NetLogonControl(struct ndr_print *ndr, const char *name, int flags, const struct I_NetLogonControl *r)
{
	ndr_print_struct(ndr, name, "I_NetLogonControl");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "I_NetLogonControl");
		ndr->depth++;
		ndr_print_string(ndr, "server_name", r->in.server_name);
		ndr_print_uint32(ndr, "function_code", r->in.function_code);
		ndr_print_uint32(ndr, "query_level", r->in.query_level);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "I_NetLogonControl");
		ndr->depth++;
		ndr_print_ptr(ndr, "buffer", r->out.buffer);
		ndr->depth++;
		ndr_print_ptr(ndr, "buffer", *r->out.buffer);
		ndr->depth++;
		if (*r->out.buffer) {
			ndr_print_uint8(ndr, "buffer", **r->out.buffer);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_NET_API_STATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ void ndr_print_I_NetLogonControl2(struct ndr_print *ndr, const char *name, int flags, const struct I_NetLogonControl2 *r)
{
	ndr_print_struct(ndr, name, "I_NetLogonControl2");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "I_NetLogonControl2");
		ndr->depth++;
		ndr_print_string(ndr, "server_name", r->in.server_name);
		ndr_print_uint32(ndr, "function_code", r->in.function_code);
		ndr_print_uint32(ndr, "query_level", r->in.query_level);
		ndr_print_ptr(ndr, "data", r->in.data);
		ndr->depth++;
		if (r->in.data) {
			ndr_print_uint8(ndr, "data", *r->in.data);
		}
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "I_NetLogonControl2");
		ndr->depth++;
		ndr_print_ptr(ndr, "buffer", r->out.buffer);
		ndr->depth++;
		ndr_print_ptr(ndr, "buffer", *r->out.buffer);
		ndr->depth++;
		if (*r->out.buffer) {
			ndr_print_uint8(ndr, "buffer", **r->out.buffer);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_NET_API_STATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

