/* Source Installer, Copyright (c) 2005,2006,2007 Claudio Fontana

 srcparser.c - parsing utility functions

 This program is free software; you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 3 of the License, or
     (at your option) any later version.

 This program is distributed in the hope that it will be useful,
     but WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
     along with this program (look for the file called COPYING);
     if not, write to the Free Software Foundation, Inc.,
         51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

     You can contact the author (Claudio Fontana) by sending a mail
     to claudio@gnu.org
*/

#include "src_stdinc.h"

/* parse function that takes a parsed DATA entry and assigns variable according to the input string S. Returns 0 on failure and 1 on success. */

/* accessor function for parsed data key */
char* srcinst_get_parsed_data_key(struct srcinst_parsed_data* d, int i) {
  return d[i].key;
}

int srcinst_parse(struct srcinst_parsed_data* data, char* s) {

  switch (data->format[1]) {

  case '%': /* nop */
    break;

  case 's':
    if (*((char**)data->variable)) {
      free(*((char**)data->variable));
    }
    *((char**)data->variable) = srcinst_strdup(s);
    break;

  case 'd':
    {
      int temp;
      if (sscanf(s, "%d", &temp) != 1)
	return 0;
      *((char*)data->variable) = temp;
      break;
    }

  default:
    if (sscanf(s, data->format, data->variable) != 1)
      return 0;
  }

  return 1;
}

int srcinst_load_parse_file(void* p, char* filename, int (*parse_f)(void*, char*, char*)) {
  FILE* f; char line[SRCINST_BUFSIZE];
  SRCINST_REGEX preg; SRCINST_MATCH matches;
  
  if (!(f = fopen(filename, "r")))
    return 0;
  
  preg = srcinst_init_regex("^([^:]+): +(.*)", REG_EXTENDED | REG_ICASE);
  matches = srcinst_init_match(3);

  while (srcinst_readline(line, sizeof(line), f) != 0) {
    char* key_tmp, *key, *value;

    if (srcinst_exec_regex(preg, line, matches)) {
      key_tmp = srcinst_get_match(matches, 1);
      key = srcinst_upper(key_tmp); free(key_tmp);
      value = srcinst_get_match(matches, 2);
	
      if (!(parse_f(p, key, value))) {
	srcinst_warning(SRCINST_ERR_PARSER, "could not parse keyword", key);
	srcinst_warning(SRCINST_ERR_PARSER, line, 0);
      }
      free(key); free(value);
    }
  }

  srcinst_free_match(matches);
  srcinst_free_regex(preg);
  fclose(f);

  return 1;
}
