/* Source Installer, Copyright (c) 2005,2006,2007 Claudio Fontana

 srcerror.h - custom error handling

 This program is free software; you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 3 of the License, or
     (at your option) any later version.

 This program is distributed in the hope that it will be useful,
     but WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
     along with this program (look for the file called COPYING);
     if not, write to the Free Software Foundation, Inc.,
         51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

     You can contact the author (Claudio Fontana) by sending a mail
     to claudio@gnu.org

*/

#ifndef SRCINST_ERROR_H
#define SRCINST_ERROR_H

/* you will get these return values from requested actions */

typedef enum {
  SRCINST_ERR_OK,		/* action completed successfully */
  SRCINST_ERR_CORE, 		/* internal error */
  SRCINST_ERR_HEAP,		/* heap error (AP will not get this) */
  SRCINST_ERR_REGEX,		/* invalid regular expression */
  SRCINST_ERR_LOCK,		/* user lock-file error */
  SRCINST_ERR_ACTION,		/* generic action failure */
  SRCINST_ERR_PARSER,		/* input parser error */
  SRCINST_ERR_PERM,		/* permission denied */
  SRCINST_ERR_INVALID,		/* invalid state for this action */
  SRCINST_ERR_MISSING,		/* required resource is missing */
  SRCINST_ERR_POLICY,           /* GNU policies error (DESTDIR) */
  SRCINST_ERR_INTR,		/* action interrupted through SIGINT */
  SRCINST_ERR_BUSY,             /* resource already in use */

  SRCINST_ERR_N			/* counter only, do _not_ use */

} SRCINST_ERR;

/* produce an error string on stderr, then quit with code ERRCODE.
   OPT_STRING is optional. Avoid it passing (char*)0 */

void srcinst_error(int errcode, char* required_string, char* opt_string);

/* produce a warning string on stderr, then return normally.
   OPT_STRING is optional. Avoid it passing (char*)0 */
void srcinst_warning(int warcode, char* required_string, char* opt_string);

/* get the string corresponding to errcode. Do not free or change! */
char* srcinst_error_string(int errcode);

#endif /* SRCINST_ERROR_H */
