/*
 * Decompiled with CFR 0.152.
 */
package gnu.gleem.linalg;

import gnu.gleem.linalg.Matf;
import gnu.gleem.linalg.Vec2f;

public class Mat2f {
    private float[] data = new float[4];

    public void makeIdent() {
        int i = 0;
        while (i < 2) {
            int j = 0;
            while (j < 2) {
                if (i == j) {
                    this.set(i, j, 1.0f);
                } else {
                    this.set(i, j, 0.0f);
                }
                ++j;
            }
            ++i;
        }
    }

    public float get(int i, int j) {
        return this.data[2 * i + j];
    }

    public void set(int i, int j, float val) {
        this.data[2 * i + j] = val;
    }

    public void setCol(int i, Vec2f v) {
        this.set(0, i, v.x());
        this.set(1, i, v.y());
    }

    public void setRow(int i, Vec2f v) {
        this.set(i, 0, v.x());
        this.set(i, 1, v.y());
    }

    public void transpose() {
        float t = this.get(0, 1);
        this.set(0, 1, this.get(1, 0));
        this.set(1, 0, t);
    }

    public float determinant() {
        return this.get(0, 0) * this.get(1, 1) - this.get(1, 0) * this.get(0, 1);
    }

    public boolean invert() {
        float det = this.determinant();
        if (det == 0.0f) {
            return false;
        }
        float t = this.get(0, 0);
        this.set(0, 0, this.get(1, 1));
        this.set(1, 1, t);
        this.set(0, 1, -this.get(0, 1));
        this.set(1, 0, -this.get(1, 0));
        int i = 0;
        while (i < 4) {
            int n = i++;
            this.data[n] = this.data[n] / det;
        }
        return true;
    }

    public void xformVec(Vec2f src, Vec2f dest) {
        dest.set(this.get(0, 0) * src.x() + this.get(0, 1) * src.y(), this.get(1, 0) * src.x() + this.get(1, 1) * src.y());
    }

    public Mat2f mul(Mat2f b) {
        Mat2f tmp = new Mat2f();
        tmp.mul(this, b);
        return tmp;
    }

    public void mul(Mat2f a, Mat2f b) {
        int rc = 0;
        while (rc < 2) {
            int cc = 0;
            while (cc < 2) {
                float tmp = 0.0f;
                int i = 0;
                while (i < 2) {
                    tmp += a.get(rc, i) * b.get(i, cc);
                    ++i;
                }
                this.set(rc, cc, tmp);
                ++cc;
            }
            ++rc;
        }
    }

    public Matf toMatf() {
        Matf out = new Matf(2, 2);
        int i = 0;
        while (i < 2) {
            int j = 0;
            while (j < 2) {
                out.set(i, j, this.get(i, j));
                ++j;
            }
            ++i;
        }
        return out;
    }

    public String toString() {
        String endl = System.getProperty("line.separator");
        return "(" + this.get(0, 0) + ", " + this.get(0, 1) + endl + this.get(1, 0) + ", " + this.get(1, 1) + ")";
    }
}

