/*
 * Decompiled with CFR 0.152.
 */
package gnu.gleem;

import gl4java.GLFunc;
import gl4java.GLRunnable;
import gl4java.drawable.GLDrawable;
import gnu.gleem.CameraParameters;
import gnu.gleem.HitPoint;
import gnu.gleem.Manip;
import gnu.gleem.RightTruncPyrMapping;
import gnu.gleem.ScreenToRayMapping;
import gnu.gleem.WindowUpdateListener;
import gnu.gleem.linalg.Vec2f;
import gnu.gleem.linalg.Vec3f;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class ManipManager {
    private ScreenToRayMapping mapping;
    private static ManipManager soleInstance;
    private Map windowToInfoMap = new HashMap();
    private Map manipToWindowMap = new HashMap();
    private MouseAdapter mouseListener = new MouseAdapter(){

        public void mousePressed(MouseEvent e) {
            ManipManager.this.mousePressed(e);
        }

        public void mouseReleased(MouseEvent e) {
            ManipManager.this.mouseReleased(e);
        }
    };
    private MouseMotionAdapter mouseMotionListener = new MouseMotionAdapter(){

        public void mouseDragged(MouseEvent e) {
            ManipManager.this.mouseDragged(e);
        }

        public void mouseMoved(MouseEvent e) {
            ManipManager.this.mouseMoved(e);
        }
    };
    private WindowUpdateListener defaultWindowListener = new WindowUpdateListener(){

        public void update(GLDrawable window) {
            if (!(window instanceof GLRunnable)) {
                window.repaint();
            }
        }
    };
    private WindowUpdateListener windowListener;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$gnu$gleem$ManipManager;

    public static synchronized ManipManager getManipManager() {
        if (soleInstance == null) {
            soleInstance = new ManipManager();
        }
        return soleInstance;
    }

    public synchronized void registerWindow(GLDrawable window) {
        this.windowToInfoMap.put(window, new WindowInfo());
        this.setupMouseListeners(window);
    }

    public synchronized void unregisterWindow(GLDrawable window) {
        WindowInfo info = (WindowInfo)this.windowToInfoMap.get(window);
        Iterator iter = info.manips.iterator();
        while (iter.hasNext()) {
            this.removeManipFromWindow((Manip)iter.next(), window);
        }
        this.windowToInfoMap.remove(window);
        this.removeMouseListeners(window);
    }

    public synchronized void showManipInWindow(Manip manip, GLDrawable window) {
        WindowInfo info = (WindowInfo)this.windowToInfoMap.get(window);
        if (info == null) {
            throw new RuntimeException("Window not registered");
        }
        info.manips.add(manip);
        HashSet<GLDrawable> windows = (HashSet<GLDrawable>)this.manipToWindowMap.get(manip);
        if (windows == null) {
            windows = new HashSet<GLDrawable>();
            this.manipToWindowMap.put(manip, windows);
        }
        windows.add(window);
    }

    public synchronized void removeManipFromWindow(Manip manip, GLDrawable window) {
        WindowInfo info = (WindowInfo)this.windowToInfoMap.get(window);
        if (info == null) {
            throw new RuntimeException("Window not registered");
        }
        if (!info.manips.remove(manip)) {
            throw new RuntimeException("Manip not registered in window");
        }
        Set windows = (Set)this.manipToWindowMap.get(manip);
        if (!$assertionsDisabled && windows == null) {
            throw new AssertionError();
        }
        windows.remove(window);
    }

    public synchronized void updateCameraParameters(GLDrawable window, CameraParameters params) {
        WindowInfo info = (WindowInfo)this.windowToInfoMap.get(window);
        if (info == null) {
            throw new RuntimeException("Window not registered");
        }
        info.params.set(params);
    }

    public synchronized void setScreenToRayMapping(ScreenToRayMapping mapping) {
        this.mapping = mapping;
    }

    public synchronized ScreenToRayMapping getScreenToRayMapping() {
        return this.mapping;
    }

    public synchronized void setWindowUpdateListener(WindowUpdateListener listener) {
        this.windowListener = listener != null ? listener : this.defaultWindowListener;
    }

    public synchronized void render(GLDrawable window, GLFunc gl) {
        WindowInfo info = (WindowInfo)this.windowToInfoMap.get(window);
        if (info == null) {
            throw new RuntimeException("Window not registered");
        }
        Iterator iter = info.manips.iterator();
        while (iter.hasNext()) {
            ((Manip)iter.next()).render(gl);
        }
    }

    public synchronized void setupMouseListeners(GLDrawable window) {
        window.addMouseMotionListener((MouseMotionListener)this.mouseMotionListener);
        window.addMouseListener((MouseListener)this.mouseListener);
    }

    public synchronized void removeMouseListeners(GLDrawable window) {
        window.removeMouseMotionListener((MouseMotionListener)this.mouseMotionListener);
        window.removeMouseListener((MouseListener)this.mouseListener);
    }

    public synchronized void mouseMoved(MouseEvent e) {
        this.passiveMotionMethod((GLDrawable)e.getComponent(), e.getX(), e.getY());
    }

    public synchronized void mouseDragged(MouseEvent e) {
        this.motionMethod((GLDrawable)e.getComponent(), e.getX(), e.getY());
    }

    public synchronized void mousePressed(MouseEvent e) {
        this.mouseMethod((GLDrawable)e.getComponent(), e.getModifiers(), true, e.getX(), e.getY());
    }

    public synchronized void mouseReleased(MouseEvent e) {
        this.mouseMethod((GLDrawable)e.getComponent(), e.getModifiers(), false, e.getX(), e.getY());
    }

    private ManipManager() {
        this.mapping = new RightTruncPyrMapping();
        this.setWindowUpdateListener(null);
    }

    private void motionMethod(GLDrawable window, int x, int y) {
        WindowInfo info = (WindowInfo)this.windowToInfoMap.get(window);
        if (info.dragging) {
            Vec3f rayStart = new Vec3f();
            Vec3f rayDirection = new Vec3f();
            this.computeRay(info.params, x, y, rayStart, rayDirection);
            info.curManip.drag(rayStart, rayDirection);
            this.fireUpdate(info.curManip);
        }
    }

    private void passiveMotionMethod(GLDrawable window, int x, int y) {
        WindowInfo info = (WindowInfo)this.windowToInfoMap.get(window);
        Vec3f rayStart = new Vec3f();
        Vec3f rayDirection = new Vec3f();
        this.computeRay(info.params, x, y, rayStart, rayDirection);
        ArrayList hits = new ArrayList();
        Iterator iter = info.manips.iterator();
        while (iter.hasNext()) {
            ((Manip)iter.next()).intersectRay(rayStart, rayDirection, hits);
        }
        HitPoint hp = null;
        Iterator iter2 = hits.iterator();
        while (iter2.hasNext()) {
            HitPoint cur = (HitPoint)iter2.next();
            if (hp != null && !(cur.intPt.getT() < hp.intPt.getT())) continue;
            hp = cur;
        }
        if (info.curHighlightedManip != null) {
            info.curHighlightedManip.clearHighlight();
            this.fireUpdate(info.curHighlightedManip);
        }
        if (hp != null) {
            info.curHighlightedManip = hp.manipulator;
            info.curHighlightedManip.highlight(hp);
            this.fireUpdate(info.curHighlightedManip);
        } else {
            info.curHighlightedManip = null;
        }
    }

    private void mouseMethod(GLDrawable window, int modifiers, boolean isPress, int x, int y) {
        if ((modifiers & 0x10) != 0) {
            WindowInfo info = (WindowInfo)this.windowToInfoMap.get(window);
            if (isPress) {
                Vec3f rayStart = new Vec3f();
                Vec3f rayDirection = new Vec3f();
                this.computeRay(info.params, x, y, rayStart, rayDirection);
                ArrayList hits = new ArrayList();
                Iterator iter = info.manips.iterator();
                while (iter.hasNext()) {
                    ((Manip)iter.next()).intersectRay(rayStart, rayDirection, hits);
                }
                HitPoint hp = null;
                Iterator iter2 = hits.iterator();
                while (iter2.hasNext()) {
                    HitPoint cur = (HitPoint)iter2.next();
                    if (hp != null && !(cur.intPt.getT() < hp.intPt.getT())) continue;
                    hp = cur;
                }
                if (hp != null) {
                    if (info.curHighlightedManip != null) {
                        info.curHighlightedManip.clearHighlight();
                        this.fireUpdate(info.curHighlightedManip);
                        info.curHighlightedManip = null;
                    }
                    if ((modifiers & 1) != 0) {
                        hp.shiftDown = true;
                    }
                    hp.manipulator.makeActive(hp);
                    info.curManip = hp.manipulator;
                    info.dragging = true;
                    this.fireUpdate(info.curManip);
                }
            } else if (info.curManip != null) {
                info.curManip.makeInactive();
                info.dragging = false;
                this.fireUpdate(info.curManip);
                info.curManip = null;
                this.passiveMotionMethod(window, x, y);
            }
        }
    }

    private Vec2f screenToNormalizedCoordinates(CameraParameters params, int x, int y) {
        return new Vec2f(((float)x / (float)(params.xSize - 1) - 0.5f) * 2.0f, (0.5f - (float)y / (float)(params.ySize - 1)) * 2.0f);
    }

    private void computeRay(CameraParameters params, int x, int y, Vec3f raySource, Vec3f rayDirection) {
        if (this.mapping == null) {
            throw new RuntimeException("Screen to ray mapping was unspecified");
        }
        this.mapping.mapScreenToRay(this.screenToNormalizedCoordinates(params, x, y), params, raySource, rayDirection);
    }

    private void fireUpdate(Manip manip) {
        Set windows = (Set)this.manipToWindowMap.get(manip);
        if (!$assertionsDisabled && windows == null) {
            throw new AssertionError();
        }
        Iterator iter = windows.iterator();
        while (iter.hasNext()) {
            this.windowListener.update((GLDrawable)iter.next());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$gnu$gleem$ManipManager == null ? (class$gnu$gleem$ManipManager = ManipManager.class$("gnu.gleem.ManipManager")) : class$gnu$gleem$ManipManager).desiredAssertionStatus();
    }

    class WindowInfo {
        Set manips = new HashSet();
        CameraParameters params = new CameraParameters();
        Manip curHighlightedManip;
        Manip curManip;
        boolean dragging;

        WindowInfo() {
        }
    }
}

