/*
 * StringBenchmark.cs - Implementation of the "StringBenchmark" class.
 *
 * Copyright (C) 2001  Southern Storm Software, Pty Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

namespace PNetMark
{

using System;
using System.Text;

/// <summary>
/// <para>The <see cref="T:PNetMark.StringBenchmark"/> class implements
/// the <see cref="T:PNetMark.IBenchmark"/> interface, and runs number
/// of string tests.</para>
/// </summary>
public class StringBenchmark : IBenchmark
{
	// Internal state.
	public int numIterations;
	public String pattern1;
	public String pattern2;
	public String pattern3;

	/// <summary>
	/// <para>Construct a new <see cref="T:PNetMark.StringBenchmark"/>
	/// instance.</para>
	/// </summary>
	public StringBenchmark()
	{
		numIterations = 50;
	}

	/// <summary>
	/// <para>Initialize the benchmark to run on this system.</para>
	/// </summary>
	///
	/// <param name="size">
	/// <para>A value that indicates the size of the benchmark to run.
	/// This should be zero to use the default value.</para>
	/// </param>
	///
	/// <returns>
	/// <para>Returns <see langword="true"/> if the benchmark could be
	/// initialized, or <see langword="false"/> otherwise.</para>
	/// </returns>
	public bool Initialize(int size)
	{
		if(size != 0)
		{
			numIterations = size;
		}
		pattern1 = "one ";
		pattern2 = "two ";
		pattern3 = "three ";
		return true;
	}

	/// <summary>
	/// <para>Get the name of the benchmark.</para>
	/// </summary>
	///
	/// <value>
	/// <para>A <see cref="T:System.String"/> that contains the name
	/// of the benchmark.</para>
	/// </value>
	public String Name
	{
		get
		{
			return "String";
		}
	}

	/// <summary>
	/// <para>Get the magnification factor for test scoring.</para>
	/// </summary>
	///
	/// <value>
	/// <para>The magnification factor.</para>
	/// </value>
	public int Magnification
	{
		get
		{
			return 2771;
		}
	}

	/// <summary>
	/// <para>Run the benchmark.</para>
	/// </summary>
	public void Run()
	{
		StringBuilder builder;
		int iter, posn;

		// Perform append tests.
		builder = new StringBuilder("Test");
		for(iter = 0; iter < numIterations; ++iter)
		{
			builder.Append(pattern1).Append(pattern2).Append(pattern3);
		}
		builder.Append("four");

		// Perform search tests.
		for(iter = 0; iter < numIterations; ++iter)
		{
			posn = builder.ToString().IndexOf("four", iter * 3);
		}
	}

	/// <summary>
	/// <para>Clean up after the benchmark has been run.</para>
	/// </summary>
	public void CleanUp()
	{
		// Nothing needs to be done here.
	}

} // class StringBenchmark

} // namespace PNetMark
