/*
 * TimeoutFiredEventHandler.cs - Curses timeout fired event handler delegate.
 *
 * Copyright (C) 2001  Southern Storm Software, Pty Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

namespace Curses
{

using System;

/// <summary>
/// <para>Event handler that is called when a timeout fires.</para>
/// </summary>
///
/// <param name="sender">
/// <para>The <see cref="T:Curses.Timeout"/> instance that sent
/// this event.</para>
/// </param>
///
/// <param name="args">
/// <para>The arguments for the event.  Usually <see langword="null"/>.</para>
/// </param>
public delegate void TimeoutFiredEventHandler
			(Object sender, EventArgs args);

} // namespace Curses
