/*
* (C) 2000, 2001 David O'Toole $Date: 2001/04/03 17:56:38 $
* 
* Simple Square Wave Generator Machine for GNU OCTAL. Block-oriented output.
* This is intended as a working example of how to write a machine for the OCTAL API.
* It is not really intended for use in songs, as it is not very pretty-sounding. 
* You can also use C++ if you prefer; use ox_wrappers (see the Developer's Guide)
* 
* $Revision: 1.5 $
*
* This software is distributed under the terms of the
* GNU General Public License (GPL). Read the included file
* COPYING for more information. 
* 
*/

static const char rcsid[]="$Id: squaregen.c,v 1.5 2001/04/03 17:56:38 dto Exp $";

#include "machine.h"  // OCTAL machine interface 

#include <stdlib.h>
#include <stdio.h>
#include <string.h>

/* some info about my machine type, to be passed to OCTAL during ox_init() */ 

enum {ix_note = 0, ix_vol=1};  /* indexes of parameters in an event */
enum {my_track = 0 };          /* we only have one track for now    */
enum {my_num_params = 2};

char *my_params[] = {
	"|note|Which note to play|note|slider|0|128|0",
	"|vol|Volume: 0.0-1.0|generic|slider|0|255|140",
	NULL	
};


typedef struct _my_state { 
  float pitch;    /* calculated from note param whenever it changes */ 
  float vol;      /* calculated from vol param whenever it changes  */  
  float phase;    /* current phase of wave                          */  
  int play;	      /* use this to tell when we have noteoff          */ 

} my_state; 



/* initialize the library and tell OCTAL about yourself */
 
int ox_init(machine_type* t) {
  
  t->long_name        = "David's Simple Squarewave Machine"; 
  t->short_name       = "dtosquare"; 
  t->max_channels     = 1; 
  t->input_channels   = 0; 
  t->output_channels  = 1;   
  t->param_info       = my_params;

  return(1); 
}



void ox_create(machine* m) {
  my_state* s;

  s = m->pkg->alloc(sizeof(my_state));

  s->vol  = 0x80;     
  s->play = 0;           /* don't start until you get a note */ 
  m->state = (void*)s;  
  }


/* free the memory when you destroy machines */ 

void ox_destroy(machine* m) {
  m->pkg->free(m->state);  
}


void ox_event(machine* m, int track, int param_index, param value) {

	my_state *s = (my_state*)m->state;      

	switch(param_index) {
	case ix_note:
		if (value == OX_NOTE_OFF) s->play = 0; 
		else {
			s->pitch = m->pkg->note2freq(value); 
			s->play = 1;
		} 
		break; 

	case ix_vol:
    	s->vol = ((float)value) / 255.0;    /* scale from 0x00..0xFE to floating point 0..1 */  
  		break;
	}
} 


void ox_desc(char* dest, int which_param, param value) {
  float x;
  int percent; 

  switch (which_param) {
  
  case ix_note: 
    strcpy(dest, "$");
    break; 

  case ix_vol: 
    x = ((float)value) / 255.0;  /* scale from 0x00..0xFE to floating point 0..1 */ 
    percent = (int)(x * 100);
    sprintf(dest, "%d%%", percent); 
    break;

  default: 
    sprintf(dest, "ERROR"); 
  }
}


int ox_work(machine* m, int block_size) {

 my_state* s;  
 samp* mout;              /* mono output for this machine */ 
 freq phaseinc; 
 freq phase;  
 samp vol; 
 int i;

 s = (my_state*)m->state;         /* grab our state data address                           */ 
 mout = m->lout;                  /* since lout=rout for mono machines, I could use either */ 
 phaseinc = (freq)(s->pitch/44100.0);
 phase = s->phase; 
 vol = s->vol; 

 if (!s->play) return (0); /* nothing to generate */  

 for (i=0; i < block_size; i++) {
    mout[i] = (phase >= 0.5) ? vol : -vol;
    phase += phaseinc;
    if (phase >= 1.0) phase -= 1.0;
  }

 //s->play = 0;
 s->phase = phase;   /* put state data back in state struct */  
 return(1);          /* generated successfully */ 
}

void ox_channel(machine* m, int creating, int channel_number) { 

}



