/*
* (C) 2000,2001 David O'Toole $Date: 2001/03/07 03:18:12 $
*
* storage for musical patterns 
* 
* $Revision: 1.1.1.1 $
* This software is distributed under the terms of the
* GNU General Public License (GPL). Read the included file
* COPYING for more information. 
*
*/
static const char rcsid[]="$Id: pattern.c,v 1.1.1.1 2001/03/07 03:18:12 dto Exp $";
#include "pattern.h"
#include "machine.h"
#include <string.h>
#include <stdlib.h>
#include <assert.h>

//
// PATTERNS
//

pattern* pt_create(int params_per_track, int num_rows)
{
	pattern* p;

	p = malloc(sizeof(pattern));
	if (!p) return p;
 
	p->num_rows = num_rows; 
	p->params_per_track = params_per_track; 
	pt_add_track(p, tk_normal);  	// start with one 
	p->mixer = 0;
	strcpy(p->name, "untitled");
	
	return p; 
}

void pt_destroy(pattern *p)
{
	while (p->normal) pt_remove_track(p, tk_normal);
	while (p->mixer) pt_remove_track(p, tk_mixer);
	free(p);
}


track **pt_choose_list(pattern *p, int type)
{
	return (type ? &p->mixer : &p->normal);
}


void pt_add_track(pattern *p, int type)
{
	track *temp, *q, **qq;

	temp = tk_create(p->params_per_track, p->num_rows, type);
	if (!temp) return;		

	// choose list to append to 

	qq = pt_choose_list(p, type);	

	// handle case that list is empty

	if (!*qq) {
		*qq = temp;
		return;
	}

	// otherwise seek to end and append

	q = *qq;
	while (q->next) q = q->next;
	q->next = temp;
}


void pt_remove_track(pattern *p, int type)
{
	track *prev, *q, **qq;

	qq = pt_choose_list(p, type);
	if (!qq) return;		// empty list, nothing to do 
	q = *qq;				// otherwise begin at listhead
	
	// handle the case that there is only one node

	if (!q->next) {
		free(q);
		*qq = 0;			// list head pointer in Pattern becomes null
		return;
	}

	// seek to end

	while (q->next) {
		prev = q;			// so that we can "back up one"
		q = q->next;		// thus q = prev->next  
	}

	free (prev->next);
	prev->next = 0;
}


//
// CELL ACCESSORS
// know about internals of both track and pattern, hiding tracks in process
//

int pt_set_cell(pattern* p, int type, int track, int row, int col, param value)
{
	return 0;
}


param pt_get_cell(pattern* p, int type, int track, int row, int col)
{
	return OX_NOCHANGE;
}

//
// TRACK HANDLING FUNCTIONS
//

param *tk_grab_current_values(track *t)
{
	assert(t->c);
	if (t->type != tk_normal) return 0;
	
	return(t->current_values);
}



// normal tracks get an extra row tacked on at the end,
// for storing current parameter values

track *tk_create(int params_per_track, int num_rows, int type)
{
	track *t = malloc(sizeof(track));
	int i, numcells; 

	switch (type) {
		case tk_normal:
		numcells = params_per_track * (num_rows + 1);
		break;

		case tk_mixer_mono:
		numcells = num_rows;		// no pan control
		break;

		case tk_mixer_stereo:
		numcells = num_rows * 2;	
		break;

		default:
		assert(0);		// shouldn't happen
	}

	// allocate cells
	t->c = malloc(numcells * sizeof(param)); 
	if (!t) return t;
 
  	// clear them out with OX_NOCHANGE 
	for (i=0; i < numcells; i++)
		t->c[i] = OX_NOCHANGE; 

	if (type == tk_normal)	
		t->current_values = t->c + (params_per_track * num_rows);
	else 
		t->current_values = 0;

	t->type = type;
	t->next = 0;
	return t;
}


void tk_destroy (track *t) 
{
	free (t->c);
	free (t);
}


