/* $Id: jtelnet.java 1.6 1997/08/02 12:36:40 iganza Exp $
 *
 * This is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * "The Java Telnet Applet" is distributed in the hope that it will be 
 * useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this software; see the file COPYING.  If not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
import java.io.*;
import java.util.*;
/**
 * Simple Telnet-IO redirector. 
 * @author Ivan Ganza/iganza@watchit.com
 * 
 *
 */
public class jtelnet implements Runnable {
  /**
   * STDIN/STDOUT
   */
  static DataInputStream in;
  static DataOutputStream out;

  /**
   * Thread Flags
   */
  boolean doRemote_running = false;
  boolean doLocal_running = false;

  /**
   * TelnetIO Module
   */
  static TelnetIO tio = new TelnetIO();

  /**
   * MAIN
   */
  public static void main(String args[]) {
    try {
        in = new DataInputStream(System.in);
        out = new DataOutputStream(System.out);
        init(args);
    } catch (Exception e)
        {
            System.out.println(e.getMessage());
        }
  }
  /*
   * Pretend we are Telnet
   */
  public static void init(String args[]) {
    try {

        switch(args.length)
        {
            //
            // We have no command line so Emacs must be running us.
            case 0:
                //
                // Send "telnet> "
                byte b[];
                b = new String("telnet> ").getBytes();
                out.write(b, 0, b.length);
                //
                // Figure out the hostname
                byte read[] = new byte[32];
                in.read(read);
                //
                // tokenize the string emacs sends us
                String param = new String(read).trim();
                StringTokenizer tokenizer = new StringTokenizer(param, " ");
                String host=null;
                int port = 23;
                //System.out.println("tokens:" + tokenizer.countTokens());

                switch(tokenizer.countTokens())
                {
                    case 2:   // open host
                        tokenizer.nextToken();
                        host = tokenizer.nextToken();
                        break;
                    case 3:   // open host port
                        tokenizer.nextToken();
                        host = tokenizer.nextToken();
                        port = Integer.parseInt(tokenizer.nextToken());
                        break;
                }
                // so chop of the 'open'
                //
                // Send Trying
                String trying = new String("Trying " + host + ".\n");
                b = trying.getBytes();
                out.write(b, 0, b.length);
                //
                // Make the connection
                tio.connect(host, port);
                String connected = new String("Connected to " + host + ".\n");
                b = connected.getBytes();
                out.write(b, 0, b.length);
                //
                // Send the part about the escape character
                String escape = new String("There is no escape character.\n");
                b = escape.getBytes();
                out.write(b, 0, b.length);
                break;

                //
                // Being run from the command line
            case 1:
                String s = args[0];
                System.out.println("Trying " + s + ".");
                tio.connect(s);
                System.out.println("Connected to " + s + ".");
                System.out.println("There is no escape character :)");
                break;
        }
          
        //
        // Start the threads
        jtelnet j = new jtelnet();
          
    } catch (Exception e)
        {
            System.out.println(e.getMessage());
            System.exit(1);
        }
  }
  public jtelnet() {
    try {
        new Thread(this).start();
        new Thread(this).start();
    } catch(Exception e)
        {
            System.out.println(e.getMessage());
        }
  }
  /**
   * Starts up the doRemote and doLocal threads.
   * This is called when we say new Thread(this).start().
   * 
   *
   */
  public void run() {
    if(!doRemote_running)
    {
        doRemote_running = true;
        doRemote();
    }

    if(!doLocal_running)
    {
        doLocal_running = true;
        doLocal();
    }
  }
  /**
   * Read bytes from the remote host and send
   * them to stdout.
   * 
   *
   */
  public final void doRemote() {
    byte b[];
    String s;
    int i;
    int count;
    try {
          
        for (; ; )
        {
            b = tio.receive();
            //
            // Strip of ugly characters before emacs sees them
            // (Terribly ineffecient)
            i = 0;
            count = b.length;
            for(i = 0; i < count; i++)
            {
                switch(b[i])
                {
                    case 0x00:
                        b[i] = 0x0D;
                        break;
                }
            }
            out.write(b);
        }
          
    } catch (IOException e)
        {
            System.out.println(e.getMessage());
            quit();
        }
  }
  /**
   * Read bytes from stdin and send them
   * to the remote host.
   * 
   *
   */
  public final void doLocal() {
    byte b;
    try {
          
        for (; ; )
        {
            b = (byte)in.read();
            tio.send(b);
        }
          
    } catch (IOException e)
        {
            System.out.println(e.getMessage());
            quit();
        }
  }
    
  public void quit() {
    System.exit(0);
  }
}
