PHP_PACKAGES=\
  php-zeroc-ice

PHP_LIBDIR=$(CURDIR)/$(DEB_DH_INSTALL_SOURCEDIR)$(shell php-config5 --extension-dir)
PHP_API=$(shell php-config5 --phpapi)

debian/stamp-build-php:: DEB_MAKE_INVOKE := $(DEB_MAKE_ENVVARS) make \
	OPTIMIZE=$(OPTIMIZE) UNAME=$(UNAME) \
	LP64=yes lp64suffix= \
	LDPLATFORMFLAGS=-g \
	prefix=/usr -j $(PROCESSORS)
debian/stamp-build-php:: debian/stamp-build-cpp
	-mkdir -p php/lib
	@if test ! -f $@ ; then \
		$(DEB_MAKE_INVOKE) -C php all; \
	fi
	:> $@

debian/stamp-install-php:: DEB_MAKE_INVOKE := $(DEB_MAKE_ENVVARS) make \
	prefix=$(CURDIR)/$(DEB_DH_INSTALL_SOURCEDIR)/usr \
	LP64=yes lp64suffix= UNAME=$(UNAME) \
	install_phplibdir=$(PHP_LIBDIR) \
	install_slicedir=$(CURDIR)/$(DEB_DH_INSTALL_SOURCEDIR)/usr/share/Ice-$(V)/slice \
	-j $(PROCESSORS)
debian/stamp-install-php::
	-mkdir -p $(PHP_LIBDIR) $(DEB_DH_INSTALL_SOURCEDIR)/etc/php5/conf.d
	-mkdir -p $(CURDIR)/$(DEB_DH_INSTALL_SOURCEDIR)/usr/share/Ice-$(V)/slice
	echo "php:Depends=phpapi-$(PHP_API)" >> $(CURDIR)/debian/$(PHP_PACKAGES).substvars
	@if test ! -f $@ ; then \
		$(DEB_MAKE_INVOKE) -C php install ; \
	fi
	-cp debian/IcePHP.ini $(DEB_DH_INSTALL_SOURCEDIR)/etc/php5/conf.d
	:> $@

.PHONY: build/php install/php

build/php:: debian/stamp-build-cpp debian/stamp-build-php
install/php:: debian/stamp-install-php

$(patsubst %,build/%,$(PHP_PACKAGES)) :: build/% : build/php
$(patsubst %,install/%,$(PHP_PACKAGES)) :: install/% : install/php

clean::
	$(MAKE) UNAME=$(UNAME) -C php clean
	$(RM) debian/stamp-build-php debian/stamp-install-php
#	$(RM) -r php/lib
