PY_PACKAGES=\
  python-zeroc-ice

PY_PREFIX=$(CURDIR)/$(DEB_DH_INSTALL_SOURCEDIR)/usr
DEFAULT_PYTHON_VERSION=$(shell pyversions -d)
PY_MODULES=IcePy
PYVERS=$(shell pyversions -s)

debian/stamp-build-py:: $(PYVERS:%=debian/stamp-build-py-%)
debian/stamp-build-py-%:: DEB_MAKE_INVOKE := $(DEB_MAKE_ENVVARS) make \
	OPTIMIZE=$(OPTIMIZE) UNAME=$(UNAME) \
	LP64=yes lp64suffix= PYTHON_LIBS= \
	LDPLATFORMFLAGS=-g prefix=/usr libdir=. -j $(PROCESSORS)
debian/stamp-build-py-%:: build/cpp
	test -f $@ || for m in $(PY_MODULES) ; do \
	  mkdir -p py/modules/$$m-$* ; \
	  ( cd py/modules/$$m-$* && \
	    ln -s ../$$m/*.h ../$$m/*.cpp ../$$m/Makefile \
	      ../$$m/.depend . ) ; \
	  $(DEB_MAKE_INVOKE) PYTHON_VERSION=$* -C py/modules/$$m-$* all; \
	done
	:> $@

debian/stamp-install-py:: debian/stamp-build-py $(PYVERS:%=debian/stamp-install-py-%)
debian/stamp-install-py-%:: DEB_MAKE_INVOKE := $(DEB_MAKE_ENVVARS) make \
	LP64=yes lp64suffix= UNAME=$(UNAME) PYTHON_LIBS= \
	install_slicedir=$(PY_PREFIX)/share/Ice-$(V)/slice \
	prefix=$(PY_PREFIX) libdir=. -j $(PROCESSORS)
debian/stamp-install-py-%:: debian/stamp-build-py-%
	mkdir -p $(PY_PREFIX)/share/Ice-$(V)/slice ; \
	mkdir -p $(PY_PREFIX)/lib/$*/site-packages ; \
	$(DEB_MAKE_INVOKE) PYTHON_VERSION=$* \
		install_pythondir=$(PY_PREFIX)/lib/$*/site-packages \
		install_pylibdir=$(PY_PREFIX)/lib/$*/site-packages \
		-C py/python install ; \
	test -f $@ || for m in $(PY_MODULES) ; do \
	  $(DEB_MAKE_INVOKE) PYTHON_VERSION=$* \
		install_pythondir=$(PY_PREFIX)/lib/$*/site-packages \
		install_pylibdir=$(PY_PREFIX)/lib/$*/site-packages \
		-C py/modules/$$m-$* install ; \
	done
	:> $@

# Hack! dh_pysupport breaks symlinks, fix them afterwards
binary-install/python-zeroc-ice::
	dh_pysupport
	for i in `find debian/python-zeroc-ice -name python\?.\?` ; do \
		( cd $$i && rm -f *.so.?? && ln -sf *.so.* *.so ) ; \
	done
	dh_installdeb

.PHONY: build/py install/py

build/py:: debian/stamp-build-py
install/py:: debian/stamp-install-py

$(patsubst %,build/%,$(PY_PACKAGES)) :: build/% : build/py
$(patsubst %,install/%,$(PY_PACKAGES)) :: install/% : install/py

clean::
	$(MAKE) UNAME=$(UNAME) -C py clean
	$(RM) debian/stamp-build-py* debian/stamp-install-py*
	-for v in $(PYVERS) ; do \
	  for m in $(PY_MODULES) ; do \
	    $(RM) -rf py/modules/$$m-$$v \
		debian/stamp-build-$$v debian/stamp-install-$$v ; \
	  done ; \
	done
