/* extension-store.c generated by valac 0.14.0, the Vala compiler
 * generated from extension-store.vala, do not modify */

/* extension-store.vala
 *
 * Copyright © 2011 Collabora Ltd.
 *             By Siegfried-Angel Gevatter Pujals <siegfried@gevatter.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <sqlite3.h>
#include <stdlib.h>
#include <string.h>


#define ZEITGEIST_TYPE_EXTENSION_STORE (zeitgeist_extension_store_get_type ())
#define ZEITGEIST_EXTENSION_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZEITGEIST_TYPE_EXTENSION_STORE, ZeitgeistExtensionStore))
#define ZEITGEIST_EXTENSION_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZEITGEIST_TYPE_EXTENSION_STORE, ZeitgeistExtensionStoreClass))
#define ZEITGEIST_IS_EXTENSION_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZEITGEIST_TYPE_EXTENSION_STORE))
#define ZEITGEIST_IS_EXTENSION_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZEITGEIST_TYPE_EXTENSION_STORE))
#define ZEITGEIST_EXTENSION_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZEITGEIST_TYPE_EXTENSION_STORE, ZeitgeistExtensionStoreClass))

typedef struct _ZeitgeistExtensionStore ZeitgeistExtensionStore;
typedef struct _ZeitgeistExtensionStoreClass ZeitgeistExtensionStoreClass;
typedef struct _ZeitgeistExtensionStorePrivate ZeitgeistExtensionStorePrivate;

#define ZEITGEIST_SQ_LITE_TYPE_ZEITGEIST_DATABASE (zeitgeist_sq_lite_zeitgeist_database_get_type ())
#define ZEITGEIST_SQ_LITE_ZEITGEIST_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZEITGEIST_SQ_LITE_TYPE_ZEITGEIST_DATABASE, ZeitgeistSQLiteZeitgeistDatabase))
#define ZEITGEIST_SQ_LITE_ZEITGEIST_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZEITGEIST_SQ_LITE_TYPE_ZEITGEIST_DATABASE, ZeitgeistSQLiteZeitgeistDatabaseClass))
#define ZEITGEIST_SQ_LITE_IS_ZEITGEIST_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZEITGEIST_SQ_LITE_TYPE_ZEITGEIST_DATABASE))
#define ZEITGEIST_SQ_LITE_IS_ZEITGEIST_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZEITGEIST_SQ_LITE_TYPE_ZEITGEIST_DATABASE))
#define ZEITGEIST_SQ_LITE_ZEITGEIST_DATABASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZEITGEIST_SQ_LITE_TYPE_ZEITGEIST_DATABASE, ZeitgeistSQLiteZeitgeistDatabaseClass))

typedef struct _ZeitgeistSQLiteZeitgeistDatabase ZeitgeistSQLiteZeitgeistDatabase;
typedef struct _ZeitgeistSQLiteZeitgeistDatabaseClass ZeitgeistSQLiteZeitgeistDatabaseClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _sqlite3_finalize0(var) ((var == NULL) ? NULL : (var = (sqlite3_finalize (var), NULL)))

#define ZEITGEIST_TYPE_ENGINE (zeitgeist_engine_get_type ())
#define ZEITGEIST_ENGINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZEITGEIST_TYPE_ENGINE, ZeitgeistEngine))
#define ZEITGEIST_ENGINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZEITGEIST_TYPE_ENGINE, ZeitgeistEngineClass))
#define ZEITGEIST_IS_ENGINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZEITGEIST_TYPE_ENGINE))
#define ZEITGEIST_IS_ENGINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZEITGEIST_TYPE_ENGINE))
#define ZEITGEIST_ENGINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZEITGEIST_TYPE_ENGINE, ZeitgeistEngineClass))

typedef struct _ZeitgeistEngine ZeitgeistEngine;
typedef struct _ZeitgeistEngineClass ZeitgeistEngineClass;
typedef struct _ZeitgeistSQLiteZeitgeistDatabasePrivate ZeitgeistSQLiteZeitgeistDatabasePrivate;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_byte_array_unref0(var) ((var == NULL) ? NULL : (var = (g_byte_array_unref (var), NULL)))

struct _ZeitgeistExtensionStore {
	GObject parent_instance;
	ZeitgeistExtensionStorePrivate * priv;
};

struct _ZeitgeistExtensionStoreClass {
	GObjectClass parent_class;
};

struct _ZeitgeistExtensionStorePrivate {
	ZeitgeistSQLiteZeitgeistDatabase* database;
	sqlite3* db;
	sqlite3_stmt* storage_stmt;
	sqlite3_stmt* retrieval_stmt;
};

struct _ZeitgeistSQLiteZeitgeistDatabase {
	GObject parent_instance;
	ZeitgeistSQLiteZeitgeistDatabasePrivate * priv;
	sqlite3_stmt* event_insertion_stmt;
	sqlite3_stmt* id_retrieval_stmt;
	sqlite3_stmt* move_handling_stmt;
	sqlite3_stmt* payload_insertion_stmt;
	sqlite3* database;
};

struct _ZeitgeistSQLiteZeitgeistDatabaseClass {
	GObjectClass parent_class;
};

typedef enum  {
	ZEITGEIST_ENGINE_ERROR_DATABASE_ERROR,
	ZEITGEIST_ENGINE_ERROR_INVALID_ARGUMENT,
	ZEITGEIST_ENGINE_ERROR_INVALID_KEY,
	ZEITGEIST_ENGINE_ERROR_BACKUP_FAILED
} ZeitgeistEngineError;
#define ZEITGEIST_ENGINE_ERROR zeitgeist_engine_error_quark ()

static gpointer zeitgeist_extension_store_parent_class = NULL;

GType zeitgeist_extension_store_get_type (void) G_GNUC_CONST;
GType zeitgeist_sq_lite_zeitgeist_database_get_type (void) G_GNUC_CONST;
#define ZEITGEIST_EXTENSION_STORE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), ZEITGEIST_TYPE_EXTENSION_STORE, ZeitgeistExtensionStorePrivate))
enum  {
	ZEITGEIST_EXTENSION_STORE_DUMMY_PROPERTY
};
GType zeitgeist_engine_get_type (void) G_GNUC_CONST;
ZeitgeistExtensionStore* zeitgeist_extension_store_new (ZeitgeistEngine* engine);
ZeitgeistExtensionStore* zeitgeist_extension_store_construct (GType object_type, ZeitgeistEngine* engine);
ZeitgeistSQLiteZeitgeistDatabase* zeitgeist_engine_get_database (ZeitgeistEngine* self);
GQuark zeitgeist_engine_error_quark (void);
static void zeitgeist_extension_store_prepare_queries (ZeitgeistExtensionStore* self, GError** error);
void zeitgeist_sq_lite_zeitgeist_database_assert_query_success (ZeitgeistSQLiteZeitgeistDatabase* self, gint rc, const gchar* msg, gint success_code, GError** error);
void zeitgeist_extension_store_store (ZeitgeistExtensionStore* self, const gchar* extension, const gchar* key, GVariant* data);
GVariant* zeitgeist_extension_store_retrieve (ZeitgeistExtensionStore* self, const gchar* extension, const gchar* key, const GVariantType* format);
static void zeitgeist_extension_store_finalize (GObject* obj);


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


ZeitgeistExtensionStore* zeitgeist_extension_store_construct (GType object_type, ZeitgeistEngine* engine) {
	ZeitgeistExtensionStore * self = NULL;
	ZeitgeistEngine* _tmp0_;
	ZeitgeistSQLiteZeitgeistDatabase* _tmp1_;
	ZeitgeistSQLiteZeitgeistDatabase* _tmp2_;
	ZeitgeistSQLiteZeitgeistDatabase* _tmp3_;
	ZeitgeistSQLiteZeitgeistDatabase* _tmp4_;
	sqlite3* _tmp5_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (engine != NULL, NULL);
	self = (ZeitgeistExtensionStore*) g_object_new (object_type, NULL);
	_tmp0_ = engine;
	_tmp1_ = zeitgeist_engine_get_database (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 (self->priv->database);
	self->priv->database = _tmp3_;
	_tmp4_ = self->priv->database;
	_tmp5_ = _tmp4_->database;
	self->priv->db = _tmp5_;
	{
		zeitgeist_extension_store_prepare_queries (self, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch8_g_error;
		}
	}
	goto __finally8;
	__catch8_g_error:
	{
		GError* err = NULL;
		GError* _tmp6_;
		const gchar* _tmp7_;
		err = _inner_error_;
		_inner_error_ = NULL;
		_tmp6_ = err;
		_tmp7_ = _tmp6_->message;
		g_warning ("extension-store.vala:42: %s", _tmp7_);
		_g_error_free0 (err);
	}
	__finally8:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	return self;
}


ZeitgeistExtensionStore* zeitgeist_extension_store_new (ZeitgeistEngine* engine) {
	return zeitgeist_extension_store_construct (ZEITGEIST_TYPE_EXTENSION_STORE, engine);
}


static void zeitgeist_extension_store_prepare_queries (ZeitgeistExtensionStore* self, GError** error) {
	gint rc = 0;
	gchar* sql = NULL;
	gchar* _tmp0_;
	ZeitgeistSQLiteZeitgeistDatabase* _tmp1_;
	sqlite3* _tmp2_;
	const gchar* _tmp3_;
	sqlite3_stmt* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	ZeitgeistSQLiteZeitgeistDatabase* _tmp6_;
	gint _tmp7_;
	gchar* _tmp8_;
	ZeitgeistSQLiteZeitgeistDatabase* _tmp9_;
	sqlite3* _tmp10_;
	const gchar* _tmp11_;
	sqlite3_stmt* _tmp12_ = NULL;
	gint _tmp13_ = 0;
	ZeitgeistSQLiteZeitgeistDatabase* _tmp14_;
	gint _tmp15_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup ("\n" \
"                INSERT OR REPLACE INTO extensions_conf (\n" \
"                    extension, key, value\n" \
"                ) VALUES (\n" \
"                    ?, ?, ?\n" \
"                )");
	_g_free0 (sql);
	sql = _tmp0_;
	_tmp1_ = self->priv->database;
	_tmp2_ = _tmp1_->database;
	_tmp3_ = sql;
	_tmp5_ = sqlite3_prepare_v2 (_tmp2_, _tmp3_, -1, &_tmp4_, NULL);
	_sqlite3_finalize0 (self->priv->storage_stmt);
	self->priv->storage_stmt = _tmp4_;
	rc = _tmp5_;
	_tmp6_ = self->priv->database;
	_tmp7_ = rc;
	zeitgeist_sq_lite_zeitgeist_database_assert_query_success (_tmp6_, _tmp7_, "Storage query error", SQLITE_OK, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (sql);
			return;
		} else {
			_g_free0 (sql);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp8_ = g_strdup ("\n" \
"                SELECT value\n" \
"                FROM extensions_conf\n" \
"                WHERE extension=? AND key=?\n" \
"                ");
	_g_free0 (sql);
	sql = _tmp8_;
	_tmp9_ = self->priv->database;
	_tmp10_ = _tmp9_->database;
	_tmp11_ = sql;
	_tmp13_ = sqlite3_prepare_v2 (_tmp10_, _tmp11_, -1, &_tmp12_, NULL);
	_sqlite3_finalize0 (self->priv->retrieval_stmt);
	self->priv->retrieval_stmt = _tmp12_;
	rc = _tmp13_;
	_tmp14_ = self->priv->database;
	_tmp15_ = rc;
	zeitgeist_sq_lite_zeitgeist_database_assert_query_success (_tmp14_, _tmp15_, "Retrieval query error", SQLITE_OK, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (sql);
			return;
		} else {
			_g_free0 (sql);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_g_free0 (sql);
}


/**
         * Store the given Variant under the given (extension, key)
         * identifier, replacing any previous value.
         */
void zeitgeist_extension_store_store (ZeitgeistExtensionStore* self, const gchar* extension, const gchar* key, GVariant* data) {
	gint rc = 0;
	sqlite3_stmt* _tmp0_;
	sqlite3_stmt* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	GDestroyNotify _tmp4_;
	sqlite3_stmt* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	GDestroyNotify _tmp8_;
	sqlite3_stmt* _tmp9_;
	GVariant* _tmp10_;
	void* _tmp11_ = NULL;
	GVariant* _tmp12_;
	gsize _tmp13_ = 0UL;
	sqlite3_stmt* _tmp14_;
	gint _tmp15_ = 0;
	gint _tmp16_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (extension != NULL);
	g_return_if_fail (key != NULL);
	g_return_if_fail (data != NULL);
	_tmp0_ = self->priv->storage_stmt;
	sqlite3_reset (_tmp0_);
	_tmp1_ = self->priv->storage_stmt;
	_tmp2_ = extension;
	_tmp3_ = g_strdup (_tmp2_);
	_tmp4_ = g_free;
	sqlite3_bind_text (_tmp1_, 1, _tmp3_, -1, _tmp4_);
	_tmp5_ = self->priv->storage_stmt;
	_tmp6_ = key;
	_tmp7_ = g_strdup (_tmp6_);
	_tmp8_ = g_free;
	sqlite3_bind_text (_tmp5_, 2, _tmp7_, -1, _tmp8_);
	_tmp9_ = self->priv->storage_stmt;
	_tmp10_ = data;
	_tmp11_ = g_variant_get_data (_tmp10_);
	_tmp12_ = data;
	_tmp13_ = g_variant_get_size (_tmp12_);
	sqlite3_bind_blob (_tmp9_, 3, _tmp11_, (gint) _tmp13_, NULL);
	_tmp14_ = self->priv->storage_stmt;
	_tmp15_ = sqlite3_step (_tmp14_);
	rc = _tmp15_;
	_tmp16_ = rc;
	if (_tmp16_ != SQLITE_DONE) {
		gint _tmp17_;
		sqlite3* _tmp18_;
		const gchar* _tmp19_ = NULL;
		_tmp17_ = rc;
		_tmp18_ = self->priv->db;
		_tmp19_ = sqlite3_errmsg (_tmp18_);
		g_warning ("extension-store.vala:84: SQL error: %d, %s", _tmp17_, _tmp19_);
	}
}


/**
         * Retrieve a previously stored value.
         */
static gpointer _g_byte_array_ref0 (gpointer self) {
	return self ? g_byte_array_ref (self) : NULL;
}


GVariant* zeitgeist_extension_store_retrieve (ZeitgeistExtensionStore* self, const gchar* extension, const gchar* key, const GVariantType* format) {
	GVariant* result = NULL;
	sqlite3_stmt* _tmp0_;
	sqlite3_stmt* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	GDestroyNotify _tmp4_;
	sqlite3_stmt* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	GDestroyNotify _tmp8_;
	sqlite3_stmt* _tmp9_;
	gint _tmp10_ = 0;
	gint rc;
	gint _tmp11_;
	guchar* blob = NULL;
	gint blob_length1 = 0;
	gint _blob_size_ = 0;
	sqlite3_stmt* _tmp16_;
	void* _tmp17_ = NULL;
	sqlite3_stmt* _tmp18_;
	gint _tmp19_ = 0;
	gint _tmp20_;
	GVariant* data;
	guchar* _tmp21_;
	gint _tmp21__length1;
	sqlite3_stmt* _tmp33_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (extension != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	g_return_val_if_fail (format != NULL, NULL);
	_tmp0_ = self->priv->retrieval_stmt;
	sqlite3_reset (_tmp0_);
	_tmp1_ = self->priv->retrieval_stmt;
	_tmp2_ = extension;
	_tmp3_ = g_strdup (_tmp2_);
	_tmp4_ = g_free;
	sqlite3_bind_text (_tmp1_, 1, _tmp3_, -1, _tmp4_);
	_tmp5_ = self->priv->retrieval_stmt;
	_tmp6_ = key;
	_tmp7_ = g_strdup (_tmp6_);
	_tmp8_ = g_free;
	sqlite3_bind_text (_tmp5_, 2, _tmp7_, -1, _tmp8_);
	_tmp9_ = self->priv->retrieval_stmt;
	_tmp10_ = sqlite3_step (_tmp9_);
	rc = _tmp10_;
	_tmp11_ = rc;
	if (_tmp11_ != SQLITE_ROW) {
		gint _tmp12_;
		_tmp12_ = rc;
		if (_tmp12_ != SQLITE_DONE) {
			gint _tmp13_;
			sqlite3* _tmp14_;
			const gchar* _tmp15_ = NULL;
			_tmp13_ = rc;
			_tmp14_ = self->priv->db;
			_tmp15_ = sqlite3_errmsg (_tmp14_);
			g_warning ("extension-store.vala:100: SQL error: %d, %s", _tmp13_, _tmp15_);
		}
		result = NULL;
		return result;
	}
	_tmp16_ = self->priv->retrieval_stmt;
	_tmp17_ = sqlite3_column_blob (_tmp16_, 0);
	blob = (guchar*) _tmp17_;
	blob_length1 = -1;
	_blob_size_ = blob_length1;
	_tmp18_ = self->priv->retrieval_stmt;
	_tmp19_ = sqlite3_column_bytes (_tmp18_, 0);
	blob_length1 = _tmp19_;
	_tmp20_ = blob_length1;
	data = NULL;
	_tmp21_ = blob;
	_tmp21__length1 = blob_length1;
	if (_tmp21_ != NULL) {
		guchar* _tmp22_;
		gint _tmp22__length1;
		GByteArray* _tmp23_;
		GByteArray* byte_array;
		GByteArray* _tmp24_;
		guchar* _tmp25_;
		gint _tmp25__length1;
		const GVariantType* _tmp26_;
		GByteArray* _tmp27_;
		guint8* _tmp28_;
		gint _tmp28__length1;
		GByteArray* _tmp29_;
		GByteArray* _tmp30_;
		GVariant* _tmp31_ = NULL;
		GVariant* _tmp32_;
		_tmp22_ = blob;
		_tmp22__length1 = blob_length1;
		_tmp23_ = g_byte_array_sized_new ((guint) _tmp22__length1);
		byte_array = _tmp23_;
		_tmp24_ = byte_array;
		_tmp25_ = blob;
		_tmp25__length1 = blob_length1;
		g_byte_array_append (_tmp24_, _tmp25_, _tmp25__length1);
		_tmp26_ = format;
		_tmp27_ = byte_array;
		_tmp28_ = _tmp27_->data;
		_tmp28__length1 = (gint) _tmp27_->len;
		_tmp29_ = byte_array;
		_tmp30_ = _g_byte_array_ref0 (_tmp29_);
		_tmp31_ = g_variant_new_from_data (_tmp26_, _tmp28_, _tmp28__length1, FALSE, g_byte_array_unref, _tmp30_);
		_tmp32_ = g_variant_ref_sink (_tmp31_);
		_g_variant_unref0 (data);
		data = _tmp32_;
		_g_byte_array_unref0 (byte_array);
	}
	_tmp33_ = self->priv->retrieval_stmt;
	sqlite3_reset (_tmp33_);
	result = data;
	return result;
}


static void zeitgeist_extension_store_class_init (ZeitgeistExtensionStoreClass * klass) {
	zeitgeist_extension_store_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ZeitgeistExtensionStorePrivate));
	G_OBJECT_CLASS (klass)->finalize = zeitgeist_extension_store_finalize;
}


static void zeitgeist_extension_store_instance_init (ZeitgeistExtensionStore * self) {
	self->priv = ZEITGEIST_EXTENSION_STORE_GET_PRIVATE (self);
}


static void zeitgeist_extension_store_finalize (GObject* obj) {
	ZeitgeistExtensionStore * self;
	self = ZEITGEIST_EXTENSION_STORE (obj);
	_g_object_unref0 (self->priv->database);
	_sqlite3_finalize0 (self->priv->storage_stmt);
	_sqlite3_finalize0 (self->priv->retrieval_stmt);
	G_OBJECT_CLASS (zeitgeist_extension_store_parent_class)->finalize (obj);
}


GType zeitgeist_extension_store_get_type (void) {
	static volatile gsize zeitgeist_extension_store_type_id__volatile = 0;
	if (g_once_init_enter (&zeitgeist_extension_store_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ZeitgeistExtensionStoreClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) zeitgeist_extension_store_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ZeitgeistExtensionStore), 0, (GInstanceInitFunc) zeitgeist_extension_store_instance_init, NULL };
		GType zeitgeist_extension_store_type_id;
		zeitgeist_extension_store_type_id = g_type_register_static (G_TYPE_OBJECT, "ZeitgeistExtensionStore", &g_define_type_info, 0);
		g_once_init_leave (&zeitgeist_extension_store_type_id__volatile, zeitgeist_extension_store_type_id);
	}
	return zeitgeist_extension_store_type_id__volatile;
}



