/* engine.c generated by valac 0.14.0, the Vala compiler
 * generated from engine.vala, do not modify */

/* engine.vala
 *
 * Copyright © 2011 Collabora Ltd.
 *             By Siegfried-Angel Gevatter Pujals <siegfried@gevatter.com>
 *             By Seif Lotfy <seif@lotfy.com>
 *
 * Based upon a Python implementation (2009-2011) by:
 *  Markus Korn <thekorn@gmx.net>
 *  Mikkel Kamstrup Erlandsen <mikkel.kamstrup@gmail.com>
 *  Seif Lotfy <seif@lotfy.com>
 *  Siegfried-Angel Gevatter Pujals <siegfried@gevatter.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <sqlite3.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>


#define ZEITGEIST_TYPE_ENGINE (zeitgeist_engine_get_type ())
#define ZEITGEIST_ENGINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZEITGEIST_TYPE_ENGINE, ZeitgeistEngine))
#define ZEITGEIST_ENGINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZEITGEIST_TYPE_ENGINE, ZeitgeistEngineClass))
#define ZEITGEIST_IS_ENGINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZEITGEIST_TYPE_ENGINE))
#define ZEITGEIST_IS_ENGINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZEITGEIST_TYPE_ENGINE))
#define ZEITGEIST_ENGINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZEITGEIST_TYPE_ENGINE, ZeitgeistEngineClass))

typedef struct _ZeitgeistEngine ZeitgeistEngine;
typedef struct _ZeitgeistEngineClass ZeitgeistEngineClass;
typedef struct _ZeitgeistEnginePrivate ZeitgeistEnginePrivate;

#define ZEITGEIST_TYPE_EXTENSION_STORE (zeitgeist_extension_store_get_type ())
#define ZEITGEIST_EXTENSION_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZEITGEIST_TYPE_EXTENSION_STORE, ZeitgeistExtensionStore))
#define ZEITGEIST_EXTENSION_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZEITGEIST_TYPE_EXTENSION_STORE, ZeitgeistExtensionStoreClass))
#define ZEITGEIST_IS_EXTENSION_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZEITGEIST_TYPE_EXTENSION_STORE))
#define ZEITGEIST_IS_EXTENSION_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZEITGEIST_TYPE_EXTENSION_STORE))
#define ZEITGEIST_EXTENSION_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZEITGEIST_TYPE_EXTENSION_STORE, ZeitgeistExtensionStoreClass))

typedef struct _ZeitgeistExtensionStore ZeitgeistExtensionStore;
typedef struct _ZeitgeistExtensionStoreClass ZeitgeistExtensionStoreClass;

#define ZEITGEIST_SQ_LITE_TYPE_TABLE_LOOKUP (zeitgeist_sq_lite_table_lookup_get_type ())
#define ZEITGEIST_SQ_LITE_TABLE_LOOKUP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZEITGEIST_SQ_LITE_TYPE_TABLE_LOOKUP, ZeitgeistSQLiteTableLookup))
#define ZEITGEIST_SQ_LITE_TABLE_LOOKUP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZEITGEIST_SQ_LITE_TYPE_TABLE_LOOKUP, ZeitgeistSQLiteTableLookupClass))
#define ZEITGEIST_SQ_LITE_IS_TABLE_LOOKUP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZEITGEIST_SQ_LITE_TYPE_TABLE_LOOKUP))
#define ZEITGEIST_SQ_LITE_IS_TABLE_LOOKUP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZEITGEIST_SQ_LITE_TYPE_TABLE_LOOKUP))
#define ZEITGEIST_SQ_LITE_TABLE_LOOKUP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZEITGEIST_SQ_LITE_TYPE_TABLE_LOOKUP, ZeitgeistSQLiteTableLookupClass))

typedef struct _ZeitgeistSQLiteTableLookup ZeitgeistSQLiteTableLookup;
typedef struct _ZeitgeistSQLiteTableLookupClass ZeitgeistSQLiteTableLookupClass;

#define ZEITGEIST_SQ_LITE_TYPE_ZEITGEIST_DATABASE (zeitgeist_sq_lite_zeitgeist_database_get_type ())
#define ZEITGEIST_SQ_LITE_ZEITGEIST_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZEITGEIST_SQ_LITE_TYPE_ZEITGEIST_DATABASE, ZeitgeistSQLiteZeitgeistDatabase))
#define ZEITGEIST_SQ_LITE_ZEITGEIST_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZEITGEIST_SQ_LITE_TYPE_ZEITGEIST_DATABASE, ZeitgeistSQLiteZeitgeistDatabaseClass))
#define ZEITGEIST_SQ_LITE_IS_ZEITGEIST_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZEITGEIST_SQ_LITE_TYPE_ZEITGEIST_DATABASE))
#define ZEITGEIST_SQ_LITE_IS_ZEITGEIST_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZEITGEIST_SQ_LITE_TYPE_ZEITGEIST_DATABASE))
#define ZEITGEIST_SQ_LITE_ZEITGEIST_DATABASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZEITGEIST_SQ_LITE_TYPE_ZEITGEIST_DATABASE, ZeitgeistSQLiteZeitgeistDatabaseClass))

typedef struct _ZeitgeistSQLiteZeitgeistDatabase ZeitgeistSQLiteZeitgeistDatabase;
typedef struct _ZeitgeistSQLiteZeitgeistDatabaseClass ZeitgeistSQLiteZeitgeistDatabaseClass;

#define ZEITGEIST_TYPE_EXTENSION_COLLECTION (zeitgeist_extension_collection_get_type ())
#define ZEITGEIST_EXTENSION_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZEITGEIST_TYPE_EXTENSION_COLLECTION, ZeitgeistExtensionCollection))
#define ZEITGEIST_EXTENSION_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZEITGEIST_TYPE_EXTENSION_COLLECTION, ZeitgeistExtensionCollectionClass))
#define ZEITGEIST_IS_EXTENSION_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZEITGEIST_TYPE_EXTENSION_COLLECTION))
#define ZEITGEIST_IS_EXTENSION_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZEITGEIST_TYPE_EXTENSION_COLLECTION))
#define ZEITGEIST_EXTENSION_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZEITGEIST_TYPE_EXTENSION_COLLECTION, ZeitgeistExtensionCollectionClass))

typedef struct _ZeitgeistExtensionCollection ZeitgeistExtensionCollection;
typedef struct _ZeitgeistExtensionCollectionClass ZeitgeistExtensionCollectionClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _ZeitgeistSQLiteZeitgeistDatabasePrivate ZeitgeistSQLiteZeitgeistDatabasePrivate;

#define ZEITGEIST_TYPE_EVENT (zeitgeist_event_get_type ())
#define ZEITGEIST_EVENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZEITGEIST_TYPE_EVENT, ZeitgeistEvent))
#define ZEITGEIST_EVENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZEITGEIST_TYPE_EVENT, ZeitgeistEventClass))
#define ZEITGEIST_IS_EVENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZEITGEIST_TYPE_EVENT))
#define ZEITGEIST_IS_EVENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZEITGEIST_TYPE_EVENT))
#define ZEITGEIST_EVENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZEITGEIST_TYPE_EVENT, ZeitgeistEventClass))

typedef struct _ZeitgeistEvent ZeitgeistEvent;
typedef struct _ZeitgeistEventClass ZeitgeistEventClass;

#define ZEITGEIST_SQ_LITE_TYPE_EVENT_VIEW_ROWS (zeitgeist_sq_lite_event_view_rows_get_type ())
#define _g_byte_array_unref0(var) ((var == NULL) ? NULL : (var = (g_byte_array_unref (var), NULL)))

#define ZEITGEIST_TYPE_SUBJECT (zeitgeist_subject_get_type ())
#define ZEITGEIST_SUBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZEITGEIST_TYPE_SUBJECT, ZeitgeistSubject))
#define ZEITGEIST_SUBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZEITGEIST_TYPE_SUBJECT, ZeitgeistSubjectClass))
#define ZEITGEIST_IS_SUBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZEITGEIST_TYPE_SUBJECT))
#define ZEITGEIST_IS_SUBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZEITGEIST_TYPE_SUBJECT))
#define ZEITGEIST_SUBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZEITGEIST_TYPE_SUBJECT, ZeitgeistSubjectClass))

typedef struct _ZeitgeistSubject ZeitgeistSubject;
typedef struct _ZeitgeistSubjectClass ZeitgeistSubjectClass;
#define _sqlite3_finalize0(var) ((var == NULL) ? NULL : (var = (sqlite3_finalize (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))

#define ZEITGEIST_TYPE_TIME_RANGE (zeitgeist_time_range_get_type ())
#define ZEITGEIST_TIME_RANGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZEITGEIST_TYPE_TIME_RANGE, ZeitgeistTimeRange))
#define ZEITGEIST_TIME_RANGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZEITGEIST_TYPE_TIME_RANGE, ZeitgeistTimeRangeClass))
#define ZEITGEIST_IS_TIME_RANGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZEITGEIST_TYPE_TIME_RANGE))
#define ZEITGEIST_IS_TIME_RANGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZEITGEIST_TYPE_TIME_RANGE))
#define ZEITGEIST_TIME_RANGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZEITGEIST_TYPE_TIME_RANGE, ZeitgeistTimeRangeClass))

typedef struct _ZeitgeistTimeRange ZeitgeistTimeRange;
typedef struct _ZeitgeistTimeRangeClass ZeitgeistTimeRangeClass;

#define ZEITGEIST_WHERE_CLAUSE_TYPE_TYPE (zeitgeist_where_clause_type_get_type ())

#define ZEITGEIST_TYPE_WHERE_CLAUSE (zeitgeist_where_clause_get_type ())
#define ZEITGEIST_WHERE_CLAUSE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZEITGEIST_TYPE_WHERE_CLAUSE, ZeitgeistWhereClause))
#define ZEITGEIST_WHERE_CLAUSE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZEITGEIST_TYPE_WHERE_CLAUSE, ZeitgeistWhereClauseClass))
#define ZEITGEIST_IS_WHERE_CLAUSE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZEITGEIST_TYPE_WHERE_CLAUSE))
#define ZEITGEIST_IS_WHERE_CLAUSE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZEITGEIST_TYPE_WHERE_CLAUSE))
#define ZEITGEIST_WHERE_CLAUSE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZEITGEIST_TYPE_WHERE_CLAUSE, ZeitgeistWhereClauseClass))

typedef struct _ZeitgeistWhereClause ZeitgeistWhereClause;
typedef struct _ZeitgeistWhereClauseClass ZeitgeistWhereClauseClass;

#define ZEITGEIST_TYPE_STORAGE_STATE (zeitgeist_storage_state_get_type ())

#define ZEITGEIST_TYPE_RESULT_TYPE (zeitgeist_result_type_get_type ())

#define ZEITGEIST_ENGINE_TYPE_RELATED_URI (zeitgeist_engine_related_uri_get_type ())
typedef struct _ZeitgeistEngineRelatedUri ZeitgeistEngineRelatedUri;
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
#define _zeitgeist_engine_related_uri_free0(var) ((var == NULL) ? NULL : (var = (zeitgeist_engine_related_uri_free (var), NULL)))
#define __g_list_free__zeitgeist_engine_related_uri_free0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__zeitgeist_engine_related_uri_free0_ (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

struct _ZeitgeistEngine {
	GObject parent_instance;
	ZeitgeistEnginePrivate * priv;
	ZeitgeistExtensionStore* extension_store;
	ZeitgeistSQLiteTableLookup* interpretations_table;
	ZeitgeistSQLiteTableLookup* manifestations_table;
	ZeitgeistSQLiteTableLookup* mimetypes_table;
	ZeitgeistSQLiteTableLookup* actors_table;
};

struct _ZeitgeistEngineClass {
	GObjectClass parent_class;
};

struct _ZeitgeistEnginePrivate {
	ZeitgeistSQLiteZeitgeistDatabase* _database;
	ZeitgeistExtensionCollection* extension_collection;
	sqlite3* db;
	guint32 last_id;
};

typedef enum  {
	ZEITGEIST_ENGINE_ERROR_DATABASE_ERROR,
	ZEITGEIST_ENGINE_ERROR_INVALID_ARGUMENT,
	ZEITGEIST_ENGINE_ERROR_INVALID_KEY,
	ZEITGEIST_ENGINE_ERROR_BACKUP_FAILED
} ZeitgeistEngineError;
#define ZEITGEIST_ENGINE_ERROR zeitgeist_engine_error_quark ()
typedef void (*ZeitgeistSQLiteDeletionCallback) (const gchar* table, gint64 rowid, void* user_data);
struct _ZeitgeistSQLiteZeitgeistDatabase {
	GObject parent_instance;
	ZeitgeistSQLiteZeitgeistDatabasePrivate * priv;
	sqlite3_stmt* event_insertion_stmt;
	sqlite3_stmt* id_retrieval_stmt;
	sqlite3_stmt* move_handling_stmt;
	sqlite3_stmt* payload_insertion_stmt;
	sqlite3* database;
};

struct _ZeitgeistSQLiteZeitgeistDatabaseClass {
	GObjectClass parent_class;
};

typedef enum  {
	ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_ID,
	ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_TIMESTAMP,
	ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_INTERPRETATION,
	ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_MANIFESTATION,
	ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_ACTOR,
	ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_PAYLOAD,
	ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_URI,
	ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_ID,
	ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_INTERPRETATION,
	ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_MANIFESTATION,
	ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_ORIGIN,
	ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_ORIGIN_URI,
	ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_MIMETYPE,
	ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_TEXT,
	ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_STORAGE,
	ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_STORAGE_STATE,
	ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_ORIGIN,
	ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_EVENT_ORIGIN_URI,
	ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_CURRENT_URI,
	ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_ID_CURRENT
} ZeitgeistSQLiteEventViewRows;

typedef enum  {
	ZEITGEIST_WHERE_CLAUSE_TYPE_AND,
	ZEITGEIST_WHERE_CLAUSE_TYPE_OR
} ZeitgeistWhereClauseType;

typedef enum  {
	ZEITGEIST_STORAGE_STATE_NOT_AVAILABLE = 0,
	ZEITGEIST_STORAGE_STATE_AVAILABLE = 1,
	ZEITGEIST_STORAGE_STATE_ANY = 2
} ZeitgeistStorageState;

typedef enum  {
	ZEITGEIST_RESULT_TYPE_MOST_RECENT_EVENTS = 0,
	ZEITGEIST_RESULT_TYPE_LEAST_RECENT_EVENTS = 1,
	ZEITGEIST_RESULT_TYPE_MOST_RECENT_SUBJECTS = 2,
	ZEITGEIST_RESULT_TYPE_LEAST_RECENT_SUBJECTS = 3,
	ZEITGEIST_RESULT_TYPE_MOST_POPULAR_SUBJECTS = 4,
	ZEITGEIST_RESULT_TYPE_LEAST_POPULAR_SUBJECTS = 5,
	ZEITGEIST_RESULT_TYPE_MOST_POPULAR_ACTOR = 6,
	ZEITGEIST_RESULT_TYPE_LEAST_POPULAR_ACTOR = 7,
	ZEITGEIST_RESULT_TYPE_MOST_RECENT_ACTOR = 8,
	ZEITGEIST_RESULT_TYPE_LEAST_RECENT_ACTOR = 9,
	ZEITGEIST_RESULT_TYPE_MOST_RECENT_ORIGIN = 10,
	ZEITGEIST_RESULT_TYPE_LEAST_RECENT_ORIGIN = 11,
	ZEITGEIST_RESULT_TYPE_MOST_POPULAR_ORIGIN = 12,
	ZEITGEIST_RESULT_TYPE_LEAST_POPULAR_ORIGIN = 13,
	ZEITGEIST_RESULT_TYPE_OLDEST_ACTOR = 14,
	ZEITGEIST_RESULT_TYPE_MOST_RECENT_SUBJECT_INTERPRETATION = 15,
	ZEITGEIST_RESULT_TYPE_LEAST_RECENT_SUBJECT_INTERPRETATION = 16,
	ZEITGEIST_RESULT_TYPE_MOST_POPULAR_SUBJECT_INTERPRETATION = 17,
	ZEITGEIST_RESULT_TYPE_LEAST_POPULAR_SUBJECT_INTERPRETATION = 18,
	ZEITGEIST_RESULT_TYPE_MOST_RECENT_MIMETYPE = 19,
	ZEITGEIST_RESULT_TYPE_LEAST_RECENT_MIMETYPE = 20,
	ZEITGEIST_RESULT_TYPE_MOST_POPULAR_MIMETYPE = 21,
	ZEITGEIST_RESULT_TYPE_LEAST_POPULAR_MIMETYPE = 22,
	ZEITGEIST_RESULT_TYPE_MOST_RECENT_CURRENT_URI = 23,
	ZEITGEIST_RESULT_TYPE_LEAST_RECENT_CURRENT_URI = 24,
	ZEITGEIST_RESULT_TYPE_MOST_POPULAR_CURRENT_URI = 25,
	ZEITGEIST_RESULT_TYPE_LEAST_POPULAR_CURRENT_URI = 26,
	ZEITGEIST_RESULT_TYPE_MOST_RECENT_EVENT_ORIGIN = 27,
	ZEITGEIST_RESULT_TYPE_LEAST_RECENT_EVENT_ORIGIN = 28,
	ZEITGEIST_RESULT_TYPE_MOST_POPULAR_EVENT_ORIGIN = 29,
	ZEITGEIST_RESULT_TYPE_LEAST_POPULAR_EVENT_ORIGIN = 30
} ZeitgeistResultType;

struct _ZeitgeistEngineRelatedUri {
	guint32 id;
	gint64 timestamp;
	gchar* uri;
	gint32 counter;
};


static gpointer zeitgeist_engine_parent_class = NULL;

GType zeitgeist_engine_get_type (void) G_GNUC_CONST;
GType zeitgeist_extension_store_get_type (void) G_GNUC_CONST;
GType zeitgeist_sq_lite_table_lookup_get_type (void) G_GNUC_CONST;
GType zeitgeist_sq_lite_zeitgeist_database_get_type (void) G_GNUC_CONST;
GType zeitgeist_extension_collection_get_type (void) G_GNUC_CONST;
#define ZEITGEIST_ENGINE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), ZEITGEIST_TYPE_ENGINE, ZeitgeistEnginePrivate))
enum  {
	ZEITGEIST_ENGINE_DUMMY_PROPERTY,
	ZEITGEIST_ENGINE_DATABASE
};
GQuark zeitgeist_engine_error_quark (void);
ZeitgeistEngine* zeitgeist_engine_new (GError** error);
ZeitgeistEngine* zeitgeist_engine_construct (GType object_type, GError** error);
ZeitgeistSQLiteZeitgeistDatabase* zeitgeist_sq_lite_zeitgeist_database_new (GError** error);
ZeitgeistSQLiteZeitgeistDatabase* zeitgeist_sq_lite_zeitgeist_database_construct (GType object_type, GError** error);
static void zeitgeist_engine_set_database (ZeitgeistEngine* self, ZeitgeistSQLiteZeitgeistDatabase* value);
ZeitgeistSQLiteZeitgeistDatabase* zeitgeist_engine_get_database (ZeitgeistEngine* self);
void zeitgeist_sq_lite_zeitgeist_database_set_deletion_callback (ZeitgeistSQLiteZeitgeistDatabase* self, ZeitgeistSQLiteDeletionCallback callback, void* callback_target);
static void zeitgeist_engine_delete_from_cache (ZeitgeistEngine* self, const gchar* table, gint64 rowid);
static void _zeitgeist_engine_delete_from_cache_zeitgeist_sq_lite_deletion_callback (const gchar* table, gint64 rowid, gpointer self);
guint32 zeitgeist_sq_lite_zeitgeist_database_get_last_id (ZeitgeistSQLiteZeitgeistDatabase* self, GError** error);
ZeitgeistSQLiteTableLookup* zeitgeist_sq_lite_table_lookup_new (ZeitgeistSQLiteZeitgeistDatabase* database, const gchar* table_name);
ZeitgeistSQLiteTableLookup* zeitgeist_sq_lite_table_lookup_construct (GType object_type, ZeitgeistSQLiteZeitgeistDatabase* database, const gchar* table_name);
ZeitgeistExtensionStore* zeitgeist_extension_store_new (ZeitgeistEngine* engine);
ZeitgeistExtensionStore* zeitgeist_extension_store_construct (GType object_type, ZeitgeistEngine* engine);
ZeitgeistExtensionCollection* zeitgeist_extension_collection_new (ZeitgeistEngine* engine);
ZeitgeistExtensionCollection* zeitgeist_extension_collection_construct (GType object_type, ZeitgeistEngine* engine);
gchar** zeitgeist_engine_get_extension_names (ZeitgeistEngine* self, int* result_length1);
gchar** zeitgeist_extension_collection_get_extension_names (ZeitgeistExtensionCollection* self, int* result_length1);
GType zeitgeist_event_get_type (void) G_GNUC_CONST;
static ZeitgeistEvent* zeitgeist_engine_get_event_from_row (ZeitgeistEngine* self, sqlite3_stmt* stmt, guint32 event_id);
ZeitgeistEvent* zeitgeist_event_new (void);
ZeitgeistEvent* zeitgeist_event_construct (GType object_type);
void zeitgeist_event_set_id (ZeitgeistEvent* self, guint32 value);
GType zeitgeist_sq_lite_event_view_rows_get_type (void) G_GNUC_CONST;
void zeitgeist_event_set_timestamp (ZeitgeistEvent* self, gint64 value);
const gchar* zeitgeist_sq_lite_table_lookup_get_value (ZeitgeistSQLiteTableLookup* self, gint id);
void zeitgeist_event_set_interpretation (ZeitgeistEvent* self, const gchar* value);
void zeitgeist_event_set_manifestation (ZeitgeistEvent* self, const gchar* value);
void zeitgeist_event_set_actor (ZeitgeistEvent* self, const gchar* value);
void zeitgeist_event_set_origin (ZeitgeistEvent* self, const gchar* value);
void zeitgeist_event_set_payload (ZeitgeistEvent* self, GByteArray* value);
GByteArray* zeitgeist_event_get_payload (ZeitgeistEvent* self);
GType zeitgeist_subject_get_type (void) G_GNUC_CONST;
static ZeitgeistSubject* zeitgeist_engine_get_subject_from_row (ZeitgeistEngine* self, sqlite3_stmt* stmt);
ZeitgeistSubject* zeitgeist_subject_new (void);
ZeitgeistSubject* zeitgeist_subject_construct (GType object_type);
void zeitgeist_subject_set_uri (ZeitgeistSubject* self, const gchar* value);
void zeitgeist_subject_set_text (ZeitgeistSubject* self, const gchar* value);
void zeitgeist_subject_set_storage (ZeitgeistSubject* self, const gchar* value);
void zeitgeist_subject_set_origin (ZeitgeistSubject* self, const gchar* value);
void zeitgeist_subject_set_current_uri (ZeitgeistSubject* self, const gchar* value);
void zeitgeist_subject_set_interpretation (ZeitgeistSubject* self, const gchar* value);
void zeitgeist_subject_set_manifestation (ZeitgeistSubject* self, const gchar* value);
void zeitgeist_subject_set_mimetype (ZeitgeistSubject* self, const gchar* value);
GPtrArray* zeitgeist_engine_get_events (ZeitgeistEngine* self, guint32* event_ids, int event_ids_length1, const char* sender, GError** error);
static void _g_object_unref0_ (gpointer var);
gchar* zeitgeist_sq_lite_zeitgeist_database_get_sql_string_from_event_ids (ZeitgeistSQLiteZeitgeistDatabase* self, guint32* event_ids, int event_ids_length1);
void zeitgeist_sq_lite_zeitgeist_database_assert_query_success (ZeitgeistSQLiteZeitgeistDatabase* self, gint rc, const gchar* msg, gint success_code, GError** error);
void zeitgeist_event_add_subject (ZeitgeistEvent* self, ZeitgeistSubject* subject);
GType zeitgeist_time_range_get_type (void) G_GNUC_CONST;
guint32* zeitgeist_engine_find_event_ids (ZeitgeistEngine* self, ZeitgeistTimeRange* time_range, GPtrArray* event_templates, guint storage_state, guint max_events, guint result_type, const char* sender, int* result_length1, GError** error);
GType zeitgeist_where_clause_type_get_type (void) G_GNUC_CONST;
ZeitgeistWhereClause* zeitgeist_where_clause_new (ZeitgeistWhereClauseType type, gboolean negate);
ZeitgeistWhereClause* zeitgeist_where_clause_construct (GType object_type, ZeitgeistWhereClauseType type, gboolean negate);
GType zeitgeist_where_clause_get_type (void) G_GNUC_CONST;
gint64 zeitgeist_time_range_get_start (ZeitgeistTimeRange* self);
void zeitgeist_where_clause_add (ZeitgeistWhereClause* self, const gchar* condition, const gchar* argument);
gint64 zeitgeist_time_range_get_end (ZeitgeistTimeRange* self);
GType zeitgeist_storage_state_get_type (void) G_GNUC_CONST;
static ZeitgeistWhereClause* zeitgeist_engine_get_where_clause_from_event_templates (ZeitgeistEngine* self, GPtrArray* templates, GError** error);
void zeitgeist_where_clause_extend (ZeitgeistWhereClause* self, ZeitgeistWhereClause* clause);
gboolean zeitgeist_where_clause_is_empty (ZeitgeistWhereClause* self);
gchar* zeitgeist_where_clause_get_sql_conditions (ZeitgeistWhereClause* self);
GType zeitgeist_result_type_get_type (void) G_GNUC_CONST;
static gchar* zeitgeist_engine_group_and_sort (ZeitgeistEngine* self, const gchar* field, const gchar* where_sql, gboolean time_asc, gboolean* count_asc, const gchar* aggregation_type);
GPtrArray* zeitgeist_where_clause_get_bind_arguments (ZeitgeistWhereClause* self);
static void _vala_array_add1 (guint32** array, int* length, int* size, guint32 value);
GPtrArray* zeitgeist_engine_find_events (ZeitgeistEngine* self, ZeitgeistTimeRange* time_range, GPtrArray* event_templates, guint storage_state, guint max_events, guint result_type, const char* sender, GError** error);
gchar** zeitgeist_engine_find_related_uris (ZeitgeistEngine* self, ZeitgeistTimeRange* time_range, GPtrArray* event_templates, GPtrArray* result_event_templates, guint storage_state, guint max_results, guint result_type, const char* sender, int* result_length1, GError** error);
static GType zeitgeist_engine_related_uri_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static ZeitgeistEngineRelatedUri* zeitgeist_engine_related_uri_dup (const ZeitgeistEngineRelatedUri* self);
static void zeitgeist_engine_related_uri_free (ZeitgeistEngineRelatedUri* self);
static void zeitgeist_engine_related_uri_copy (const ZeitgeistEngineRelatedUri* self, ZeitgeistEngineRelatedUri* dest);
static void zeitgeist_engine_related_uri_destroy (ZeitgeistEngineRelatedUri* self);
static void _zeitgeist_engine_related_uri_free0_ (gpointer var);
static void _g_free0_ (gpointer var);
static gboolean _vala_uint32_array_contains (guint32* stack, int stack_length, guint32 needle);
static gint ___lambda5_ (ZeitgeistEngineRelatedUri* a, ZeitgeistEngineRelatedUri* b);
static gint ____lambda5__gcompare_func (gconstpointer a, gconstpointer b);
static gint ___lambda6_ (ZeitgeistEngineRelatedUri* a, ZeitgeistEngineRelatedUri* b);
static gint ____lambda6__gcompare_func (gconstpointer a, gconstpointer b);
static gint ____lambda7_ (ZeitgeistEngineRelatedUri* a, ZeitgeistEngineRelatedUri* b);
static gint _____lambda7__gcompare_func (gconstpointer a, gconstpointer b);
static void _g_list_free__zeitgeist_engine_related_uri_free0_ (GList* self);
guint32* zeitgeist_engine_insert_events (ZeitgeistEngine* self, GPtrArray* events, const char* sender, int* result_length1, GError** error);
void zeitgeist_extension_collection_call_pre_insert_events (ZeitgeistExtensionCollection* self, GPtrArray* events, const char* sender);
void zeitgeist_sq_lite_zeitgeist_database_begin_transaction (ZeitgeistSQLiteZeitgeistDatabase* self, GError** error);
guint32 zeitgeist_engine_insert_event (ZeitgeistEngine* self, ZeitgeistEvent* event, const char* sender, GError** error);
void zeitgeist_sq_lite_zeitgeist_database_end_transaction (ZeitgeistSQLiteZeitgeistDatabase* self, GError** error);
void zeitgeist_extension_collection_call_post_insert_events (ZeitgeistExtensionCollection* self, GPtrArray* events, const char* sender);
guint32 zeitgeist_event_get_id (ZeitgeistEvent* self);
gint zeitgeist_event_num_subjects (ZeitgeistEvent* self);
const gchar* zeitgeist_event_get_origin (ZeitgeistEvent* self);
GPtrArray* zeitgeist_event_get_subjects (ZeitgeistEvent* self);
const gchar* zeitgeist_subject_get_uri (ZeitgeistSubject* self);
const gchar* zeitgeist_subject_get_current_uri (ZeitgeistSubject* self);
const gchar* zeitgeist_event_get_interpretation (ZeitgeistEvent* self);
#define ZEITGEIST_ZG_MOVE_EVENT "http://www.zeitgeist-project.com/ontologies/2010/01/27/zg#MoveEvent"
const gchar* zeitgeist_subject_get_origin (ZeitgeistSubject* self);
const gchar* zeitgeist_subject_get_text (ZeitgeistSubject* self);
const gchar* zeitgeist_subject_get_storage (ZeitgeistSubject* self);
void zeitgeist_sq_lite_zeitgeist_database_insert_or_ignore_into_table (ZeitgeistSQLiteZeitgeistDatabase* self, const gchar* table_name, GPtrArray* values, GError** error);
static gint64 zeitgeist_engine_store_payload (ZeitgeistEngine* self, ZeitgeistEvent* event);
gint64 zeitgeist_event_get_timestamp (ZeitgeistEvent* self);
gint zeitgeist_sq_lite_table_lookup_get_id (ZeitgeistSQLiteTableLookup* self, const gchar* name);
const gchar* zeitgeist_event_get_manifestation (ZeitgeistEvent* self);
const gchar* zeitgeist_event_get_actor (ZeitgeistEvent* self);
const gchar* zeitgeist_subject_get_interpretation (ZeitgeistSubject* self);
const gchar* zeitgeist_subject_get_manifestation (ZeitgeistSubject* self);
const gchar* zeitgeist_subject_get_mimetype (ZeitgeistSubject* self);
static void zeitgeist_engine_handle_move_event (ZeitgeistEngine* self, ZeitgeistEvent* event);
ZeitgeistTimeRange* zeitgeist_engine_delete_events (ZeitgeistEngine* self, guint32* event_ids, int event_ids_length1, const char* sender, GError** error);
guint32* zeitgeist_extension_collection_call_pre_delete_events (ZeitgeistExtensionCollection* self, guint32* event_ids, int event_ids_length1, const char* sender, int* result_length1);
ZeitgeistTimeRange* zeitgeist_sq_lite_zeitgeist_database_get_time_range_for_event_ids (ZeitgeistSQLiteZeitgeistDatabase* self, guint32* event_ids, int event_ids_length1, GError** error);
void zeitgeist_extension_collection_call_post_delete_events (ZeitgeistExtensionCollection* self, guint32* event_ids, int event_ids_length1, const char* sender);
void zeitgeist_engine_close (ZeitgeistEngine* self);
void zeitgeist_sq_lite_zeitgeist_database_close (ZeitgeistSQLiteZeitgeistDatabase* self);
static ZeitgeistWhereClause* zeitgeist_engine_get_where_clause_from_event_template (ZeitgeistEngine* self, ZeitgeistEvent* template, GError** error);
void zeitgeist_engine_assert_no_wildcard (ZeitgeistEngine* self, const gchar* field, const gchar* val, GError** error);
ZeitgeistWhereClause* zeitgeist_engine_get_where_clause_for_symbol (ZeitgeistEngine* self, const gchar* table_name, const gchar* symbol, ZeitgeistSQLiteTableLookup* lookup_table, GError** error);
gboolean zeitgeist_engine_parse_wildcard (gchar** val);
gboolean zeitgeist_engine_parse_negation (gchar** val);
void zeitgeist_where_clause_add_wildcard_condition (ZeitgeistWhereClause* self, const gchar* column, const gchar* needle, gboolean negation);
void zeitgeist_where_clause_add_match_condition (ZeitgeistWhereClause* self, const gchar* column, gint val, gboolean negation);
void zeitgeist_where_clause_add_text_condition_subquery (ZeitgeistWhereClause* self, const gchar* column, const gchar* val, gboolean negation);
void zeitgeist_engine_assert_no_negation (ZeitgeistEngine* self, const gchar* field, const gchar* val, GError** error);
GList* zeitgeist_symbol_get_all_children (const gchar* symbol_uri);
void zeitgeist_sq_lite_table_lookup_remove (ZeitgeistSQLiteTableLookup* self, gint id);
static void zeitgeist_engine_finalize (GObject* obj);
static void _vala_zeitgeist_engine_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_zeitgeist_engine_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static void _zeitgeist_engine_delete_from_cache_zeitgeist_sq_lite_deletion_callback (const gchar* table, gint64 rowid, gpointer self) {
	zeitgeist_engine_delete_from_cache (self, table, rowid);
}


ZeitgeistEngine* zeitgeist_engine_construct (GType object_type, GError** error) {
	ZeitgeistEngine * self = NULL;
	ZeitgeistSQLiteZeitgeistDatabase* _tmp0_;
	ZeitgeistSQLiteZeitgeistDatabase* _tmp1_;
	ZeitgeistSQLiteZeitgeistDatabase* _tmp2_;
	ZeitgeistSQLiteZeitgeistDatabase* _tmp3_;
	ZeitgeistSQLiteZeitgeistDatabase* _tmp4_;
	sqlite3* _tmp5_;
	ZeitgeistSQLiteZeitgeistDatabase* _tmp6_;
	guint32 _tmp7_ = 0U;
	guint32 _tmp8_;
	ZeitgeistSQLiteZeitgeistDatabase* _tmp9_;
	ZeitgeistSQLiteTableLookup* _tmp10_;
	ZeitgeistSQLiteZeitgeistDatabase* _tmp11_;
	ZeitgeistSQLiteTableLookup* _tmp12_;
	ZeitgeistSQLiteZeitgeistDatabase* _tmp13_;
	ZeitgeistSQLiteTableLookup* _tmp14_;
	ZeitgeistSQLiteZeitgeistDatabase* _tmp15_;
	ZeitgeistSQLiteTableLookup* _tmp16_;
	ZeitgeistExtensionStore* _tmp17_;
	ZeitgeistExtensionCollection* _tmp18_;
	GError * _inner_error_ = NULL;
	self = (ZeitgeistEngine*) g_object_new (object_type, NULL);
	_tmp0_ = zeitgeist_sq_lite_zeitgeist_database_new (&_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp2_ = _tmp1_;
	zeitgeist_engine_set_database (self, _tmp2_);
	_g_object_unref0 (_tmp2_);
	_tmp3_ = self->priv->_database;
	zeitgeist_sq_lite_zeitgeist_database_set_deletion_callback (_tmp3_, _zeitgeist_engine_delete_from_cache_zeitgeist_sq_lite_deletion_callback, self);
	_tmp4_ = self->priv->_database;
	_tmp5_ = _tmp4_->database;
	self->priv->db = _tmp5_;
	_tmp6_ = self->priv->_database;
	_tmp7_ = zeitgeist_sq_lite_zeitgeist_database_get_last_id (_tmp6_, &_inner_error_);
	_tmp8_ = _tmp7_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	self->priv->last_id = _tmp8_;
	_tmp9_ = self->priv->_database;
	_tmp10_ = zeitgeist_sq_lite_table_lookup_new (_tmp9_, "interpretation");
	_g_object_unref0 (self->interpretations_table);
	self->interpretations_table = _tmp10_;
	_tmp11_ = self->priv->_database;
	_tmp12_ = zeitgeist_sq_lite_table_lookup_new (_tmp11_, "manifestation");
	_g_object_unref0 (self->manifestations_table);
	self->manifestations_table = _tmp12_;
	_tmp13_ = self->priv->_database;
	_tmp14_ = zeitgeist_sq_lite_table_lookup_new (_tmp13_, "mimetype");
	_g_object_unref0 (self->mimetypes_table);
	self->mimetypes_table = _tmp14_;
	_tmp15_ = self->priv->_database;
	_tmp16_ = zeitgeist_sq_lite_table_lookup_new (_tmp15_, "actor");
	_g_object_unref0 (self->actors_table);
	self->actors_table = _tmp16_;
	_tmp17_ = zeitgeist_extension_store_new (self);
	_g_object_unref0 (self->extension_store);
	self->extension_store = _tmp17_;
	_tmp18_ = zeitgeist_extension_collection_new (self);
	_g_object_unref0 (self->priv->extension_collection);
	self->priv->extension_collection = _tmp18_;
	return self;
}


ZeitgeistEngine* zeitgeist_engine_new (GError** error) {
	return zeitgeist_engine_construct (ZEITGEIST_TYPE_ENGINE, error);
}


gchar** zeitgeist_engine_get_extension_names (ZeitgeistEngine* self, int* result_length1) {
	gchar** result = NULL;
	ZeitgeistExtensionCollection* _tmp0_;
	gint _tmp1_ = 0;
	gchar** _tmp2_ = NULL;
	gchar** _tmp3_;
	gint _tmp3__length1;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->extension_collection;
	_tmp2_ = zeitgeist_extension_collection_get_extension_names (_tmp0_, &_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp3__length1 = _tmp1_;
	if (result_length1) {
		*result_length1 = _tmp3__length1;
	}
	result = _tmp3_;
	return result;
}


static ZeitgeistEvent* zeitgeist_engine_get_event_from_row (ZeitgeistEngine* self, sqlite3_stmt* stmt, guint32 event_id) {
	ZeitgeistEvent* result = NULL;
	ZeitgeistEvent* _tmp0_;
	ZeitgeistEvent* event;
	ZeitgeistEvent* _tmp1_;
	guint32 _tmp2_;
	ZeitgeistEvent* _tmp3_;
	sqlite3_stmt* _tmp4_;
	gint64 _tmp5_ = 0LL;
	ZeitgeistEvent* _tmp6_;
	ZeitgeistSQLiteTableLookup* _tmp7_;
	sqlite3_stmt* _tmp8_;
	gint _tmp9_ = 0;
	const gchar* _tmp10_ = NULL;
	ZeitgeistEvent* _tmp11_;
	ZeitgeistSQLiteTableLookup* _tmp12_;
	sqlite3_stmt* _tmp13_;
	gint _tmp14_ = 0;
	const gchar* _tmp15_ = NULL;
	ZeitgeistEvent* _tmp16_;
	ZeitgeistSQLiteTableLookup* _tmp17_;
	sqlite3_stmt* _tmp18_;
	gint _tmp19_ = 0;
	const gchar* _tmp20_ = NULL;
	ZeitgeistEvent* _tmp21_;
	sqlite3_stmt* _tmp22_;
	const gchar* _tmp23_ = NULL;
	sqlite3_stmt* _tmp24_;
	void* _tmp25_ = NULL;
	guint8* data;
	gint data_length1;
	gint _data_size_;
	sqlite3_stmt* _tmp26_;
	gint _tmp27_ = 0;
	gint _tmp28_;
	guint8* _tmp29_;
	gint _tmp29__length1;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (stmt != NULL, NULL);
	_tmp0_ = zeitgeist_event_new ();
	event = _tmp0_;
	_tmp1_ = event;
	_tmp2_ = event_id;
	zeitgeist_event_set_id (_tmp1_, _tmp2_);
	_tmp3_ = event;
	_tmp4_ = stmt;
	_tmp5_ = sqlite3_column_int64 (_tmp4_, (gint) ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_TIMESTAMP);
	zeitgeist_event_set_timestamp (_tmp3_, _tmp5_);
	_tmp6_ = event;
	_tmp7_ = self->interpretations_table;
	_tmp8_ = stmt;
	_tmp9_ = sqlite3_column_int (_tmp8_, (gint) ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_INTERPRETATION);
	_tmp10_ = zeitgeist_sq_lite_table_lookup_get_value (_tmp7_, _tmp9_);
	zeitgeist_event_set_interpretation (_tmp6_, _tmp10_);
	_tmp11_ = event;
	_tmp12_ = self->manifestations_table;
	_tmp13_ = stmt;
	_tmp14_ = sqlite3_column_int (_tmp13_, (gint) ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_MANIFESTATION);
	_tmp15_ = zeitgeist_sq_lite_table_lookup_get_value (_tmp12_, _tmp14_);
	zeitgeist_event_set_manifestation (_tmp11_, _tmp15_);
	_tmp16_ = event;
	_tmp17_ = self->actors_table;
	_tmp18_ = stmt;
	_tmp19_ = sqlite3_column_int (_tmp18_, (gint) ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_ACTOR);
	_tmp20_ = zeitgeist_sq_lite_table_lookup_get_value (_tmp17_, _tmp19_);
	zeitgeist_event_set_actor (_tmp16_, _tmp20_);
	_tmp21_ = event;
	_tmp22_ = stmt;
	_tmp23_ = sqlite3_column_text (_tmp22_, (gint) ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_EVENT_ORIGIN_URI);
	zeitgeist_event_set_origin (_tmp21_, _tmp23_);
	_tmp24_ = stmt;
	_tmp25_ = sqlite3_column_blob (_tmp24_, (gint) ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_PAYLOAD);
	data = (guint8*) _tmp25_;
	data_length1 = -1;
	_data_size_ = data_length1;
	_tmp26_ = stmt;
	_tmp27_ = sqlite3_column_bytes (_tmp26_, (gint) ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_PAYLOAD);
	data_length1 = _tmp27_;
	_tmp28_ = data_length1;
	_tmp29_ = data;
	_tmp29__length1 = data_length1;
	if (_tmp29_ != NULL) {
		ZeitgeistEvent* _tmp30_;
		GByteArray* _tmp31_;
		GByteArray* _tmp32_;
		ZeitgeistEvent* _tmp33_;
		GByteArray* _tmp34_;
		GByteArray* _tmp35_;
		guint8* _tmp36_;
		gint _tmp36__length1;
		_tmp30_ = event;
		_tmp31_ = g_byte_array_new ();
		_tmp32_ = _tmp31_;
		zeitgeist_event_set_payload (_tmp30_, _tmp32_);
		_g_byte_array_unref0 (_tmp32_);
		_tmp33_ = event;
		_tmp34_ = zeitgeist_event_get_payload (_tmp33_);
		_tmp35_ = _tmp34_;
		_tmp36_ = data;
		_tmp36__length1 = data_length1;
		g_byte_array_append (_tmp35_, _tmp36_, _tmp36__length1);
	}
	result = event;
	return result;
}


static ZeitgeistSubject* zeitgeist_engine_get_subject_from_row (ZeitgeistEngine* self, sqlite3_stmt* stmt) {
	ZeitgeistSubject* result = NULL;
	ZeitgeistSubject* _tmp0_;
	ZeitgeistSubject* subject;
	sqlite3_stmt* _tmp1_;
	const gchar* _tmp2_ = NULL;
	sqlite3_stmt* _tmp3_;
	const gchar* _tmp4_ = NULL;
	sqlite3_stmt* _tmp5_;
	const gchar* _tmp6_ = NULL;
	sqlite3_stmt* _tmp7_;
	const gchar* _tmp8_ = NULL;
	sqlite3_stmt* _tmp9_;
	const gchar* _tmp10_ = NULL;
	ZeitgeistSQLiteTableLookup* _tmp11_;
	sqlite3_stmt* _tmp12_;
	gint _tmp13_ = 0;
	const gchar* _tmp14_ = NULL;
	ZeitgeistSQLiteTableLookup* _tmp15_;
	sqlite3_stmt* _tmp16_;
	gint _tmp17_ = 0;
	const gchar* _tmp18_ = NULL;
	ZeitgeistSQLiteTableLookup* _tmp19_;
	sqlite3_stmt* _tmp20_;
	gint _tmp21_ = 0;
	const gchar* _tmp22_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (stmt != NULL, NULL);
	_tmp0_ = zeitgeist_subject_new ();
	subject = _tmp0_;
	_tmp1_ = stmt;
	_tmp2_ = sqlite3_column_text (_tmp1_, (gint) ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_URI);
	zeitgeist_subject_set_uri (subject, _tmp2_);
	_tmp3_ = stmt;
	_tmp4_ = sqlite3_column_text (_tmp3_, (gint) ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_TEXT);
	zeitgeist_subject_set_text (subject, _tmp4_);
	_tmp5_ = stmt;
	_tmp6_ = sqlite3_column_text (_tmp5_, (gint) ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_STORAGE);
	zeitgeist_subject_set_storage (subject, _tmp6_);
	_tmp7_ = stmt;
	_tmp8_ = sqlite3_column_text (_tmp7_, (gint) ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_ORIGIN_URI);
	zeitgeist_subject_set_origin (subject, _tmp8_);
	_tmp9_ = stmt;
	_tmp10_ = sqlite3_column_text (_tmp9_, (gint) ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_CURRENT_URI);
	zeitgeist_subject_set_current_uri (subject, _tmp10_);
	_tmp11_ = self->interpretations_table;
	_tmp12_ = stmt;
	_tmp13_ = sqlite3_column_int (_tmp12_, (gint) ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_INTERPRETATION);
	_tmp14_ = zeitgeist_sq_lite_table_lookup_get_value (_tmp11_, _tmp13_);
	zeitgeist_subject_set_interpretation (subject, _tmp14_);
	_tmp15_ = self->manifestations_table;
	_tmp16_ = stmt;
	_tmp17_ = sqlite3_column_int (_tmp16_, (gint) ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_MANIFESTATION);
	_tmp18_ = zeitgeist_sq_lite_table_lookup_get_value (_tmp15_, _tmp17_);
	zeitgeist_subject_set_manifestation (subject, _tmp18_);
	_tmp19_ = self->mimetypes_table;
	_tmp20_ = stmt;
	_tmp21_ = sqlite3_column_int (_tmp20_, (gint) ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_MIMETYPE);
	_tmp22_ = zeitgeist_sq_lite_table_lookup_get_value (_tmp19_, _tmp21_);
	zeitgeist_subject_set_mimetype (subject, _tmp22_);
	result = subject;
	return result;
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gint g_ptr_array_get_length (GPtrArray* self) {
	gint result;
	guint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->len;
	result = (gint) _tmp0_;
	return result;
}


static void g_ptr_array_set_length (GPtrArray* self, gint value) {
	gint _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	g_ptr_array_set_size (self, _tmp0_);
}


static void g_ptr_array_set (GPtrArray* self, guint index, gpointer data) {
	gpointer _tmp0_;
	guint _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = data;
	data = NULL;
	g_ptr_array_add (self, _tmp0_);
	_tmp1_ = index;
	g_ptr_array_remove_index_fast (self, _tmp1_);
}


GPtrArray* zeitgeist_engine_get_events (ZeitgeistEngine* self, guint32* event_ids, int event_ids_length1, const char* sender, GError** error) {
	GPtrArray* result = NULL;
	guint32* _tmp0_;
	gint _tmp0__length1;
	ZeitgeistSQLiteZeitgeistDatabase* _tmp2_;
	guint32* _tmp3_;
	gint _tmp3__length1;
	gchar* _tmp4_ = NULL;
	gchar* sql_event_ids;
	const gchar* _tmp5_;
	gchar* _tmp6_ = NULL;
	gchar* sql;
	sqlite3_stmt* stmt = NULL;
	sqlite3* _tmp7_;
	const gchar* _tmp8_;
	sqlite3_stmt* _tmp9_ = NULL;
	gint _tmp10_ = 0;
	gint rc;
	ZeitgeistSQLiteZeitgeistDatabase* _tmp11_;
	gint _tmp12_;
	GHashFunc _tmp13_;
	GEqualFunc _tmp14_;
	GHashTable* _tmp15_;
	GHashTable* events;
	gint _tmp37_;
	GPtrArray* _tmp42_;
	GPtrArray* results;
	GPtrArray* _tmp43_;
	guint32* _tmp44_;
	gint _tmp44__length1;
	gint i;
	guint32* _tmp45_;
	gint _tmp45__length1;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = event_ids;
	_tmp0__length1 = event_ids_length1;
	if (_tmp0__length1 == 0) {
		GPtrArray* _tmp1_;
		_tmp1_ = g_ptr_array_new_with_free_func (_g_object_unref0_);
		result = _tmp1_;
		return result;
	}
	_tmp2_ = self->priv->_database;
	_tmp3_ = event_ids;
	_tmp3__length1 = event_ids_length1;
	_tmp4_ = zeitgeist_sq_lite_zeitgeist_database_get_sql_string_from_event_ids (_tmp2_, _tmp3_, _tmp3__length1);
	sql_event_ids = _tmp4_;
	_tmp5_ = sql_event_ids;
	_tmp6_ = g_strdup_printf ("\n" \
"            SELECT * FROM event_view\n" \
"            WHERE id IN (%s)\n" \
"            ", _tmp5_);
	sql = _tmp6_;
	_tmp7_ = self->priv->db;
	_tmp8_ = sql;
	_tmp10_ = sqlite3_prepare_v2 (_tmp7_, _tmp8_, -1, &_tmp9_, NULL);
	_sqlite3_finalize0 (stmt);
	stmt = _tmp9_;
	rc = _tmp10_;
	_tmp11_ = self->priv->_database;
	_tmp12_ = rc;
	zeitgeist_sq_lite_zeitgeist_database_assert_query_success (_tmp11_, _tmp12_, "SQL error", SQLITE_OK, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_sqlite3_finalize0 (stmt);
			_g_free0 (sql);
			_g_free0 (sql_event_ids);
			return NULL;
		} else {
			_sqlite3_finalize0 (stmt);
			_g_free0 (sql);
			_g_free0 (sql_event_ids);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp13_ = g_direct_hash;
	_tmp14_ = g_direct_equal;
	_tmp15_ = g_hash_table_new_full (_tmp13_, _tmp14_, NULL, _g_object_unref0_);
	events = _tmp15_;
	while (TRUE) {
		sqlite3_stmt* _tmp16_;
		gint _tmp17_ = 0;
		gint _tmp18_;
		sqlite3_stmt* _tmp19_;
		gint64 _tmp20_ = 0LL;
		guint32 event_id;
		GHashTable* _tmp21_;
		guint32 _tmp22_;
		gconstpointer _tmp23_ = NULL;
		ZeitgeistEvent* _tmp24_;
		ZeitgeistEvent* event;
		ZeitgeistEvent* _tmp25_;
		sqlite3_stmt* _tmp33_;
		ZeitgeistSubject* _tmp34_ = NULL;
		ZeitgeistSubject* subject;
		ZeitgeistEvent* _tmp35_;
		ZeitgeistSubject* _tmp36_;
		_tmp16_ = stmt;
		_tmp17_ = sqlite3_step (_tmp16_);
		rc = _tmp17_;
		_tmp18_ = rc;
		if (!(_tmp18_ == SQLITE_ROW)) {
			break;
		}
		_tmp19_ = stmt;
		_tmp20_ = sqlite3_column_int64 (_tmp19_, (gint) ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_ID);
		event_id = (guint32) _tmp20_;
		_tmp21_ = events;
		_tmp22_ = event_id;
		_tmp23_ = g_hash_table_lookup (_tmp21_, GUINT_TO_POINTER (_tmp22_));
		_tmp24_ = _g_object_ref0 ((ZeitgeistEvent*) _tmp23_);
		event = _tmp24_;
		_tmp25_ = event;
		if (_tmp25_ == NULL) {
			sqlite3_stmt* _tmp26_;
			guint32 _tmp27_;
			ZeitgeistEvent* _tmp28_ = NULL;
			GHashTable* _tmp29_;
			guint32 _tmp30_;
			ZeitgeistEvent* _tmp31_;
			ZeitgeistEvent* _tmp32_;
			_tmp26_ = stmt;
			_tmp27_ = event_id;
			_tmp28_ = zeitgeist_engine_get_event_from_row (self, _tmp26_, _tmp27_);
			_g_object_unref0 (event);
			event = _tmp28_;
			_tmp29_ = events;
			_tmp30_ = event_id;
			_tmp31_ = event;
			_tmp32_ = _g_object_ref0 (_tmp31_);
			g_hash_table_insert (_tmp29_, GUINT_TO_POINTER (_tmp30_), _tmp32_);
		}
		_tmp33_ = stmt;
		_tmp34_ = zeitgeist_engine_get_subject_from_row (self, _tmp33_);
		subject = _tmp34_;
		_tmp35_ = event;
		_tmp36_ = subject;
		zeitgeist_event_add_subject (_tmp35_, _tmp36_);
		_g_object_unref0 (subject);
		_g_object_unref0 (event);
	}
	_tmp37_ = rc;
	if (_tmp37_ != SQLITE_DONE) {
		gint _tmp38_;
		sqlite3* _tmp39_;
		const gchar* _tmp40_ = NULL;
		GError* _tmp41_;
		_tmp38_ = rc;
		_tmp39_ = self->priv->db;
		_tmp40_ = sqlite3_errmsg (_tmp39_);
		_tmp41_ = g_error_new (ZEITGEIST_ENGINE_ERROR, ZEITGEIST_ENGINE_ERROR_DATABASE_ERROR, "Error: %d, %s\n", _tmp38_, _tmp40_);
		_inner_error_ = _tmp41_;
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_hash_table_unref0 (events);
			_sqlite3_finalize0 (stmt);
			_g_free0 (sql);
			_g_free0 (sql_event_ids);
			return NULL;
		} else {
			_g_hash_table_unref0 (events);
			_sqlite3_finalize0 (stmt);
			_g_free0 (sql);
			_g_free0 (sql_event_ids);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp42_ = g_ptr_array_new_with_free_func (_g_object_unref0_);
	results = _tmp42_;
	_tmp43_ = results;
	_tmp44_ = event_ids;
	_tmp44__length1 = event_ids_length1;
	g_ptr_array_set_length (_tmp43_, _tmp44__length1);
	i = 0;
	_tmp45_ = event_ids;
	_tmp45__length1 = event_ids_length1;
	{
		guint32* id_collection = NULL;
		gint id_collection_length1 = 0;
		gint _id_collection_size_ = 0;
		gint id_it = 0;
		id_collection = _tmp45_;
		id_collection_length1 = _tmp45__length1;
		for (id_it = 0; id_it < _tmp45__length1; id_it = id_it + 1) {
			guint32 id = 0U;
			id = id_collection[id_it];
			{
				GPtrArray* _tmp46_;
				gint _tmp47_;
				GHashTable* _tmp48_;
				guint32 _tmp49_;
				gconstpointer _tmp50_ = NULL;
				ZeitgeistEvent* _tmp51_;
				_tmp46_ = results;
				_tmp47_ = i;
				i = _tmp47_ + 1;
				_tmp48_ = events;
				_tmp49_ = id;
				_tmp50_ = g_hash_table_lookup (_tmp48_, GUINT_TO_POINTER (_tmp49_));
				_tmp51_ = _g_object_ref0 ((ZeitgeistEvent*) _tmp50_);
				g_ptr_array_set (_tmp46_, (guint) _tmp47_, _tmp51_);
			}
		}
	}
	result = results;
	_g_hash_table_unref0 (events);
	_sqlite3_finalize0 (stmt);
	_g_free0 (sql);
	_g_free0 (sql_event_ids);
	return result;
}


static gpointer _g_ptr_array_ref0 (gpointer self) {
	return self ? g_ptr_array_ref (self) : NULL;
}


static guint64 uint64_parse (const gchar* str) {
	guint64 result = 0ULL;
	const gchar* _tmp0_;
	guint64 _tmp1_ = 0ULL;
	g_return_val_if_fail (str != NULL, 0ULL);
	_tmp0_ = str;
	_tmp1_ = g_ascii_strtoull (_tmp0_, NULL, (guint) 0);
	result = _tmp1_;
	return result;
}


static void _vala_array_add1 (guint32** array, int* length, int* size, guint32 value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (guint32, *array, *size);
	}
	(*array)[(*length)++] = value;
}


guint32* zeitgeist_engine_find_event_ids (ZeitgeistEngine* self, ZeitgeistTimeRange* time_range, GPtrArray* event_templates, guint storage_state, guint max_events, guint result_type, const char* sender, int* result_length1, GError** error) {
	guint32* result = NULL;
	ZeitgeistWhereClause* _tmp0_;
	ZeitgeistWhereClause* where;
	ZeitgeistTimeRange* _tmp1_;
	gint64 _tmp2_;
	gint64 _tmp3_;
	ZeitgeistTimeRange* _tmp10_;
	gint64 _tmp11_;
	gint64 _tmp12_;
	gboolean _tmp19_ = FALSE;
	guint _tmp20_;
	gboolean _tmp22_;
	GPtrArray* _tmp33_;
	ZeitgeistWhereClause* _tmp34_ = NULL;
	ZeitgeistWhereClause* tpl_conditions;
	ZeitgeistWhereClause* _tmp35_;
	ZeitgeistWhereClause* _tmp36_;
	gchar* _tmp37_;
	gchar* sql;
	gchar* _tmp38_;
	gchar* where_sql;
	ZeitgeistWhereClause* _tmp39_;
	gboolean _tmp40_ = FALSE;
	guint _tmp45_;
	guint _tmp219_;
	gint rc = 0;
	sqlite3_stmt* stmt = NULL;
	sqlite3* _tmp225_;
	const gchar* _tmp226_;
	sqlite3_stmt* _tmp227_ = NULL;
	gint _tmp228_ = 0;
	ZeitgeistSQLiteZeitgeistDatabase* _tmp229_;
	gint _tmp230_;
	ZeitgeistWhereClause* _tmp231_;
	GPtrArray* _tmp232_ = NULL;
	GPtrArray* _tmp233_;
	GPtrArray* arguments;
	guint32* _tmp248_ = NULL;
	guint32* event_ids;
	gint event_ids_length1;
	gint _event_ids_size_;
	gint _tmp257_;
	guint32* _tmp265_;
	gint _tmp265__length1;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (time_range != NULL, NULL);
	g_return_val_if_fail (event_templates != NULL, NULL);
	_tmp0_ = zeitgeist_where_clause_new (ZEITGEIST_WHERE_CLAUSE_TYPE_AND, FALSE);
	where = _tmp0_;
	_tmp1_ = time_range;
	_tmp2_ = zeitgeist_time_range_get_start (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ != ((gint64) 0)) {
		ZeitgeistWhereClause* _tmp4_;
		ZeitgeistTimeRange* _tmp5_;
		gint64 _tmp6_;
		gint64 _tmp7_;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_;
		_tmp4_ = where;
		_tmp5_ = time_range;
		_tmp6_ = zeitgeist_time_range_get_start (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = g_strdup_printf ("+timestamp >= %" G_GINT64_FORMAT, _tmp7_);
		_tmp9_ = _tmp8_;
		zeitgeist_where_clause_add (_tmp4_, _tmp9_, NULL);
		_g_free0 (_tmp9_);
	}
	_tmp10_ = time_range;
	_tmp11_ = zeitgeist_time_range_get_end (_tmp10_);
	_tmp12_ = _tmp11_;
	if (_tmp12_ != ((gint64) 0)) {
		ZeitgeistWhereClause* _tmp13_;
		ZeitgeistTimeRange* _tmp14_;
		gint64 _tmp15_;
		gint64 _tmp16_;
		gchar* _tmp17_ = NULL;
		gchar* _tmp18_;
		_tmp13_ = where;
		_tmp14_ = time_range;
		_tmp15_ = zeitgeist_time_range_get_end (_tmp14_);
		_tmp16_ = _tmp15_;
		_tmp17_ = g_strdup_printf ("+timestamp <= %" G_GINT64_FORMAT, _tmp16_);
		_tmp18_ = _tmp17_;
		zeitgeist_where_clause_add (_tmp13_, _tmp18_, NULL);
		_g_free0 (_tmp18_);
	}
	_tmp20_ = storage_state;
	if (_tmp20_ == ((guint) ZEITGEIST_STORAGE_STATE_AVAILABLE)) {
		_tmp19_ = TRUE;
	} else {
		guint _tmp21_;
		_tmp21_ = storage_state;
		_tmp19_ = _tmp21_ == ((guint) ZEITGEIST_STORAGE_STATE_NOT_AVAILABLE);
	}
	_tmp22_ = _tmp19_;
	if (_tmp22_) {
		ZeitgeistWhereClause* _tmp23_;
		guint _tmp24_;
		gchar* _tmp25_ = NULL;
		gchar* _tmp26_;
		_tmp23_ = where;
		_tmp24_ = storage_state;
		_tmp25_ = g_strdup_printf ("%u", _tmp24_);
		_tmp26_ = _tmp25_;
		zeitgeist_where_clause_add (_tmp23_, "(subj_storage_state=? OR subj_storage_state IS NULL)", _tmp26_);
		_g_free0 (_tmp26_);
	} else {
		guint _tmp27_;
		_tmp27_ = storage_state;
		if (_tmp27_ != ((guint) ZEITGEIST_STORAGE_STATE_ANY)) {
			guint _tmp28_;
			gchar* _tmp29_ = NULL;
			gchar* _tmp30_;
			GError* _tmp31_;
			GError* _tmp32_;
			_tmp28_ = storage_state;
			_tmp29_ = g_strdup_printf ("Unknown storage state '%u'", _tmp28_);
			_tmp30_ = _tmp29_;
			_tmp31_ = g_error_new_literal (ZEITGEIST_ENGINE_ERROR, ZEITGEIST_ENGINE_ERROR_INVALID_ARGUMENT, _tmp30_);
			_tmp32_ = _tmp31_;
			_g_free0 (_tmp30_);
			_inner_error_ = _tmp32_;
			if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (where);
				return NULL;
			} else {
				_g_object_unref0 (where);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
	}
	_tmp33_ = event_templates;
	_tmp34_ = zeitgeist_engine_get_where_clause_from_event_templates (self, _tmp33_, &_inner_error_);
	tpl_conditions = _tmp34_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (where);
			return NULL;
		} else {
			_g_object_unref0 (where);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp35_ = where;
	_tmp36_ = tpl_conditions;
	zeitgeist_where_clause_extend (_tmp35_, _tmp36_);
	_tmp37_ = g_strdup ("SELECT DISTINCT id FROM event_view ");
	sql = _tmp37_;
	_tmp38_ = g_strdup ("");
	where_sql = _tmp38_;
	_tmp39_ = where;
	_tmp40_ = zeitgeist_where_clause_is_empty (_tmp39_);
	if (!_tmp40_) {
		ZeitgeistWhereClause* _tmp41_;
		gchar* _tmp42_ = NULL;
		gchar* _tmp43_;
		gchar* _tmp44_;
		_tmp41_ = where;
		_tmp42_ = zeitgeist_where_clause_get_sql_conditions (_tmp41_);
		_tmp43_ = _tmp42_;
		_tmp44_ = g_strconcat ("WHERE ", _tmp43_, NULL);
		_g_free0 (where_sql);
		where_sql = _tmp44_;
		_g_free0 (_tmp43_);
	}
	_tmp45_ = result_type;
	switch (_tmp45_) {
		case ZEITGEIST_RESULT_TYPE_MOST_RECENT_EVENTS:
		{
			const gchar* _tmp46_;
			const gchar* _tmp47_;
			gchar* _tmp48_;
			gchar* _tmp49_;
			gchar* _tmp50_;
			_tmp46_ = sql;
			_tmp47_ = where_sql;
			_tmp48_ = g_strconcat (_tmp47_, " ORDER BY timestamp DESC", NULL);
			_tmp49_ = _tmp48_;
			_tmp50_ = g_strconcat (_tmp46_, _tmp49_, NULL);
			_g_free0 (sql);
			sql = _tmp50_;
			_g_free0 (_tmp49_);
			break;
		}
		case ZEITGEIST_RESULT_TYPE_LEAST_RECENT_EVENTS:
		{
			const gchar* _tmp51_;
			const gchar* _tmp52_;
			gchar* _tmp53_;
			gchar* _tmp54_;
			gchar* _tmp55_;
			_tmp51_ = sql;
			_tmp52_ = where_sql;
			_tmp53_ = g_strconcat (_tmp52_, " ORDER BY timestamp ASC", NULL);
			_tmp54_ = _tmp53_;
			_tmp55_ = g_strconcat (_tmp51_, _tmp54_, NULL);
			_g_free0 (sql);
			sql = _tmp55_;
			_g_free0 (_tmp54_);
			break;
		}
		case ZEITGEIST_RESULT_TYPE_MOST_RECENT_EVENT_ORIGIN:
		{
			const gchar* _tmp56_;
			const gchar* _tmp57_;
			gchar* _tmp58_ = NULL;
			gchar* _tmp59_;
			gchar* _tmp60_;
			_tmp56_ = sql;
			_tmp57_ = where_sql;
			_tmp58_ = zeitgeist_engine_group_and_sort (self, "origin", _tmp57_, FALSE, NULL, "max");
			_tmp59_ = _tmp58_;
			_tmp60_ = g_strconcat (_tmp56_, _tmp59_, NULL);
			_g_free0 (sql);
			sql = _tmp60_;
			_g_free0 (_tmp59_);
			break;
		}
		case ZEITGEIST_RESULT_TYPE_LEAST_RECENT_EVENT_ORIGIN:
		{
			const gchar* _tmp61_;
			const gchar* _tmp62_;
			gchar* _tmp63_ = NULL;
			gchar* _tmp64_;
			gchar* _tmp65_;
			_tmp61_ = sql;
			_tmp62_ = where_sql;
			_tmp63_ = zeitgeist_engine_group_and_sort (self, "origin", _tmp62_, TRUE, NULL, "max");
			_tmp64_ = _tmp63_;
			_tmp65_ = g_strconcat (_tmp61_, _tmp64_, NULL);
			_g_free0 (sql);
			sql = _tmp65_;
			_g_free0 (_tmp64_);
			break;
		}
		case ZEITGEIST_RESULT_TYPE_MOST_POPULAR_EVENT_ORIGIN:
		{
			const gchar* _tmp66_;
			const gchar* _tmp67_;
			gboolean _tmp68_;
			gchar* _tmp69_ = NULL;
			gchar* _tmp70_;
			gchar* _tmp71_;
			_tmp66_ = sql;
			_tmp67_ = where_sql;
			_tmp68_ = FALSE;
			_tmp69_ = zeitgeist_engine_group_and_sort (self, "origin", _tmp67_, FALSE, &_tmp68_, "max");
			_tmp70_ = _tmp69_;
			_tmp71_ = g_strconcat (_tmp66_, _tmp70_, NULL);
			_g_free0 (sql);
			sql = _tmp71_;
			_g_free0 (_tmp70_);
			break;
		}
		case ZEITGEIST_RESULT_TYPE_LEAST_POPULAR_EVENT_ORIGIN:
		{
			const gchar* _tmp72_;
			const gchar* _tmp73_;
			gboolean _tmp74_;
			gchar* _tmp75_ = NULL;
			gchar* _tmp76_;
			gchar* _tmp77_;
			_tmp72_ = sql;
			_tmp73_ = where_sql;
			_tmp74_ = TRUE;
			_tmp75_ = zeitgeist_engine_group_and_sort (self, "origin", _tmp73_, TRUE, &_tmp74_, "max");
			_tmp76_ = _tmp75_;
			_tmp77_ = g_strconcat (_tmp72_, _tmp76_, NULL);
			_g_free0 (sql);
			sql = _tmp77_;
			_g_free0 (_tmp76_);
			break;
		}
		case ZEITGEIST_RESULT_TYPE_MOST_RECENT_SUBJECTS:
		{
			const gchar* _tmp78_;
			const gchar* _tmp79_;
			gchar* _tmp80_ = NULL;
			gchar* _tmp81_;
			gchar* _tmp82_;
			_tmp78_ = sql;
			_tmp79_ = where_sql;
			_tmp80_ = zeitgeist_engine_group_and_sort (self, "subj_id", _tmp79_, FALSE, NULL, "max");
			_tmp81_ = _tmp80_;
			_tmp82_ = g_strconcat (_tmp78_, _tmp81_, NULL);
			_g_free0 (sql);
			sql = _tmp82_;
			_g_free0 (_tmp81_);
			break;
		}
		case ZEITGEIST_RESULT_TYPE_LEAST_RECENT_SUBJECTS:
		{
			const gchar* _tmp83_;
			const gchar* _tmp84_;
			gchar* _tmp85_ = NULL;
			gchar* _tmp86_;
			gchar* _tmp87_;
			_tmp83_ = sql;
			_tmp84_ = where_sql;
			_tmp85_ = zeitgeist_engine_group_and_sort (self, "subj_id", _tmp84_, TRUE, NULL, "max");
			_tmp86_ = _tmp85_;
			_tmp87_ = g_strconcat (_tmp83_, _tmp86_, NULL);
			_g_free0 (sql);
			sql = _tmp87_;
			_g_free0 (_tmp86_);
			break;
		}
		case ZEITGEIST_RESULT_TYPE_MOST_POPULAR_SUBJECTS:
		{
			const gchar* _tmp88_;
			const gchar* _tmp89_;
			gboolean _tmp90_;
			gchar* _tmp91_ = NULL;
			gchar* _tmp92_;
			gchar* _tmp93_;
			_tmp88_ = sql;
			_tmp89_ = where_sql;
			_tmp90_ = FALSE;
			_tmp91_ = zeitgeist_engine_group_and_sort (self, "subj_id", _tmp89_, FALSE, &_tmp90_, "max");
			_tmp92_ = _tmp91_;
			_tmp93_ = g_strconcat (_tmp88_, _tmp92_, NULL);
			_g_free0 (sql);
			sql = _tmp93_;
			_g_free0 (_tmp92_);
			break;
		}
		case ZEITGEIST_RESULT_TYPE_LEAST_POPULAR_SUBJECTS:
		{
			const gchar* _tmp94_;
			const gchar* _tmp95_;
			gboolean _tmp96_;
			gchar* _tmp97_ = NULL;
			gchar* _tmp98_;
			gchar* _tmp99_;
			_tmp94_ = sql;
			_tmp95_ = where_sql;
			_tmp96_ = TRUE;
			_tmp97_ = zeitgeist_engine_group_and_sort (self, "subj_id", _tmp95_, TRUE, &_tmp96_, "max");
			_tmp98_ = _tmp97_;
			_tmp99_ = g_strconcat (_tmp94_, _tmp98_, NULL);
			_g_free0 (sql);
			sql = _tmp99_;
			_g_free0 (_tmp98_);
			break;
		}
		case ZEITGEIST_RESULT_TYPE_MOST_RECENT_CURRENT_URI:
		{
			const gchar* _tmp100_;
			const gchar* _tmp101_;
			gchar* _tmp102_ = NULL;
			gchar* _tmp103_;
			gchar* _tmp104_;
			_tmp100_ = sql;
			_tmp101_ = where_sql;
			_tmp102_ = zeitgeist_engine_group_and_sort (self, "subj_id_current", _tmp101_, FALSE, NULL, "max");
			_tmp103_ = _tmp102_;
			_tmp104_ = g_strconcat (_tmp100_, _tmp103_, NULL);
			_g_free0 (sql);
			sql = _tmp104_;
			_g_free0 (_tmp103_);
			break;
		}
		case ZEITGEIST_RESULT_TYPE_LEAST_RECENT_CURRENT_URI:
		{
			const gchar* _tmp105_;
			const gchar* _tmp106_;
			gchar* _tmp107_ = NULL;
			gchar* _tmp108_;
			gchar* _tmp109_;
			_tmp105_ = sql;
			_tmp106_ = where_sql;
			_tmp107_ = zeitgeist_engine_group_and_sort (self, "subj_id_current", _tmp106_, TRUE, NULL, "max");
			_tmp108_ = _tmp107_;
			_tmp109_ = g_strconcat (_tmp105_, _tmp108_, NULL);
			_g_free0 (sql);
			sql = _tmp109_;
			_g_free0 (_tmp108_);
			break;
		}
		case ZEITGEIST_RESULT_TYPE_MOST_POPULAR_CURRENT_URI:
		{
			const gchar* _tmp110_;
			const gchar* _tmp111_;
			gboolean _tmp112_;
			gchar* _tmp113_ = NULL;
			gchar* _tmp114_;
			gchar* _tmp115_;
			_tmp110_ = sql;
			_tmp111_ = where_sql;
			_tmp112_ = FALSE;
			_tmp113_ = zeitgeist_engine_group_and_sort (self, "subj_id_current", _tmp111_, FALSE, &_tmp112_, "max");
			_tmp114_ = _tmp113_;
			_tmp115_ = g_strconcat (_tmp110_, _tmp114_, NULL);
			_g_free0 (sql);
			sql = _tmp115_;
			_g_free0 (_tmp114_);
			break;
		}
		case ZEITGEIST_RESULT_TYPE_LEAST_POPULAR_CURRENT_URI:
		{
			const gchar* _tmp116_;
			const gchar* _tmp117_;
			gboolean _tmp118_;
			gchar* _tmp119_ = NULL;
			gchar* _tmp120_;
			gchar* _tmp121_;
			_tmp116_ = sql;
			_tmp117_ = where_sql;
			_tmp118_ = TRUE;
			_tmp119_ = zeitgeist_engine_group_and_sort (self, "subj_id_current", _tmp117_, TRUE, &_tmp118_, "max");
			_tmp120_ = _tmp119_;
			_tmp121_ = g_strconcat (_tmp116_, _tmp120_, NULL);
			_g_free0 (sql);
			sql = _tmp121_;
			_g_free0 (_tmp120_);
			break;
		}
		case ZEITGEIST_RESULT_TYPE_MOST_RECENT_ACTOR:
		{
			const gchar* _tmp122_;
			const gchar* _tmp123_;
			gchar* _tmp124_ = NULL;
			gchar* _tmp125_;
			gchar* _tmp126_;
			_tmp122_ = sql;
			_tmp123_ = where_sql;
			_tmp124_ = zeitgeist_engine_group_and_sort (self, "actor", _tmp123_, FALSE, NULL, "max");
			_tmp125_ = _tmp124_;
			_tmp126_ = g_strconcat (_tmp122_, _tmp125_, NULL);
			_g_free0 (sql);
			sql = _tmp126_;
			_g_free0 (_tmp125_);
			break;
		}
		case ZEITGEIST_RESULT_TYPE_LEAST_RECENT_ACTOR:
		{
			const gchar* _tmp127_;
			const gchar* _tmp128_;
			gchar* _tmp129_ = NULL;
			gchar* _tmp130_;
			gchar* _tmp131_;
			_tmp127_ = sql;
			_tmp128_ = where_sql;
			_tmp129_ = zeitgeist_engine_group_and_sort (self, "actor", _tmp128_, TRUE, NULL, "max");
			_tmp130_ = _tmp129_;
			_tmp131_ = g_strconcat (_tmp127_, _tmp130_, NULL);
			_g_free0 (sql);
			sql = _tmp131_;
			_g_free0 (_tmp130_);
			break;
		}
		case ZEITGEIST_RESULT_TYPE_MOST_POPULAR_ACTOR:
		{
			const gchar* _tmp132_;
			const gchar* _tmp133_;
			gboolean _tmp134_;
			gchar* _tmp135_ = NULL;
			gchar* _tmp136_;
			gchar* _tmp137_;
			_tmp132_ = sql;
			_tmp133_ = where_sql;
			_tmp134_ = FALSE;
			_tmp135_ = zeitgeist_engine_group_and_sort (self, "actor", _tmp133_, FALSE, &_tmp134_, "max");
			_tmp136_ = _tmp135_;
			_tmp137_ = g_strconcat (_tmp132_, _tmp136_, NULL);
			_g_free0 (sql);
			sql = _tmp137_;
			_g_free0 (_tmp136_);
			break;
		}
		case ZEITGEIST_RESULT_TYPE_LEAST_POPULAR_ACTOR:
		{
			const gchar* _tmp138_;
			const gchar* _tmp139_;
			gboolean _tmp140_;
			gchar* _tmp141_ = NULL;
			gchar* _tmp142_;
			gchar* _tmp143_;
			_tmp138_ = sql;
			_tmp139_ = where_sql;
			_tmp140_ = TRUE;
			_tmp141_ = zeitgeist_engine_group_and_sort (self, "actor", _tmp139_, TRUE, &_tmp140_, "max");
			_tmp142_ = _tmp141_;
			_tmp143_ = g_strconcat (_tmp138_, _tmp142_, NULL);
			_g_free0 (sql);
			sql = _tmp143_;
			_g_free0 (_tmp142_);
			break;
		}
		case ZEITGEIST_RESULT_TYPE_OLDEST_ACTOR:
		{
			const gchar* _tmp144_;
			const gchar* _tmp145_;
			gchar* _tmp146_ = NULL;
			gchar* _tmp147_;
			gchar* _tmp148_;
			_tmp144_ = sql;
			_tmp145_ = where_sql;
			_tmp146_ = zeitgeist_engine_group_and_sort (self, "actor", _tmp145_, TRUE, NULL, "min");
			_tmp147_ = _tmp146_;
			_tmp148_ = g_strconcat (_tmp144_, _tmp147_, NULL);
			_g_free0 (sql);
			sql = _tmp148_;
			_g_free0 (_tmp147_);
			break;
		}
		case ZEITGEIST_RESULT_TYPE_MOST_RECENT_ORIGIN:
		{
			const gchar* _tmp149_;
			const gchar* _tmp150_;
			gchar* _tmp151_ = NULL;
			gchar* _tmp152_;
			gchar* _tmp153_;
			_tmp149_ = sql;
			_tmp150_ = where_sql;
			_tmp151_ = zeitgeist_engine_group_and_sort (self, "subj_origin", _tmp150_, FALSE, NULL, "max");
			_tmp152_ = _tmp151_;
			_tmp153_ = g_strconcat (_tmp149_, _tmp152_, NULL);
			_g_free0 (sql);
			sql = _tmp153_;
			_g_free0 (_tmp152_);
			break;
		}
		case ZEITGEIST_RESULT_TYPE_LEAST_RECENT_ORIGIN:
		{
			const gchar* _tmp154_;
			const gchar* _tmp155_;
			gchar* _tmp156_ = NULL;
			gchar* _tmp157_;
			gchar* _tmp158_;
			_tmp154_ = sql;
			_tmp155_ = where_sql;
			_tmp156_ = zeitgeist_engine_group_and_sort (self, "subj_origin", _tmp155_, TRUE, NULL, "max");
			_tmp157_ = _tmp156_;
			_tmp158_ = g_strconcat (_tmp154_, _tmp157_, NULL);
			_g_free0 (sql);
			sql = _tmp158_;
			_g_free0 (_tmp157_);
			break;
		}
		case ZEITGEIST_RESULT_TYPE_MOST_POPULAR_ORIGIN:
		{
			const gchar* _tmp159_;
			const gchar* _tmp160_;
			gboolean _tmp161_;
			gchar* _tmp162_ = NULL;
			gchar* _tmp163_;
			gchar* _tmp164_;
			_tmp159_ = sql;
			_tmp160_ = where_sql;
			_tmp161_ = FALSE;
			_tmp162_ = zeitgeist_engine_group_and_sort (self, "subj_origin", _tmp160_, FALSE, &_tmp161_, "max");
			_tmp163_ = _tmp162_;
			_tmp164_ = g_strconcat (_tmp159_, _tmp163_, NULL);
			_g_free0 (sql);
			sql = _tmp164_;
			_g_free0 (_tmp163_);
			break;
		}
		case ZEITGEIST_RESULT_TYPE_LEAST_POPULAR_ORIGIN:
		{
			const gchar* _tmp165_;
			const gchar* _tmp166_;
			gboolean _tmp167_;
			gchar* _tmp168_ = NULL;
			gchar* _tmp169_;
			gchar* _tmp170_;
			_tmp165_ = sql;
			_tmp166_ = where_sql;
			_tmp167_ = TRUE;
			_tmp168_ = zeitgeist_engine_group_and_sort (self, "subj_origin", _tmp166_, TRUE, &_tmp167_, "max");
			_tmp169_ = _tmp168_;
			_tmp170_ = g_strconcat (_tmp165_, _tmp169_, NULL);
			_g_free0 (sql);
			sql = _tmp170_;
			_g_free0 (_tmp169_);
			break;
		}
		case ZEITGEIST_RESULT_TYPE_MOST_RECENT_SUBJECT_INTERPRETATION:
		{
			const gchar* _tmp171_;
			const gchar* _tmp172_;
			gchar* _tmp173_ = NULL;
			gchar* _tmp174_;
			gchar* _tmp175_;
			_tmp171_ = sql;
			_tmp172_ = where_sql;
			_tmp173_ = zeitgeist_engine_group_and_sort (self, "subj_interpretation", _tmp172_, FALSE, NULL, "max");
			_tmp174_ = _tmp173_;
			_tmp175_ = g_strconcat (_tmp171_, _tmp174_, NULL);
			_g_free0 (sql);
			sql = _tmp175_;
			_g_free0 (_tmp174_);
			break;
		}
		case ZEITGEIST_RESULT_TYPE_LEAST_RECENT_SUBJECT_INTERPRETATION:
		{
			const gchar* _tmp176_;
			const gchar* _tmp177_;
			gchar* _tmp178_ = NULL;
			gchar* _tmp179_;
			gchar* _tmp180_;
			_tmp176_ = sql;
			_tmp177_ = where_sql;
			_tmp178_ = zeitgeist_engine_group_and_sort (self, "subj_interpretation", _tmp177_, TRUE, NULL, "max");
			_tmp179_ = _tmp178_;
			_tmp180_ = g_strconcat (_tmp176_, _tmp179_, NULL);
			_g_free0 (sql);
			sql = _tmp180_;
			_g_free0 (_tmp179_);
			break;
		}
		case ZEITGEIST_RESULT_TYPE_MOST_POPULAR_SUBJECT_INTERPRETATION:
		{
			const gchar* _tmp181_;
			const gchar* _tmp182_;
			gboolean _tmp183_;
			gchar* _tmp184_ = NULL;
			gchar* _tmp185_;
			gchar* _tmp186_;
			_tmp181_ = sql;
			_tmp182_ = where_sql;
			_tmp183_ = FALSE;
			_tmp184_ = zeitgeist_engine_group_and_sort (self, "subj_interpretation", _tmp182_, FALSE, &_tmp183_, "max");
			_tmp185_ = _tmp184_;
			_tmp186_ = g_strconcat (_tmp181_, _tmp185_, NULL);
			_g_free0 (sql);
			sql = _tmp186_;
			_g_free0 (_tmp185_);
			break;
		}
		case ZEITGEIST_RESULT_TYPE_LEAST_POPULAR_SUBJECT_INTERPRETATION:
		{
			const gchar* _tmp187_;
			const gchar* _tmp188_;
			gboolean _tmp189_;
			gchar* _tmp190_ = NULL;
			gchar* _tmp191_;
			gchar* _tmp192_;
			_tmp187_ = sql;
			_tmp188_ = where_sql;
			_tmp189_ = TRUE;
			_tmp190_ = zeitgeist_engine_group_and_sort (self, "subj_interpretation", _tmp188_, TRUE, &_tmp189_, "max");
			_tmp191_ = _tmp190_;
			_tmp192_ = g_strconcat (_tmp187_, _tmp191_, NULL);
			_g_free0 (sql);
			sql = _tmp192_;
			_g_free0 (_tmp191_);
			break;
		}
		case ZEITGEIST_RESULT_TYPE_MOST_RECENT_MIMETYPE:
		{
			const gchar* _tmp193_;
			const gchar* _tmp194_;
			gchar* _tmp195_ = NULL;
			gchar* _tmp196_;
			gchar* _tmp197_;
			_tmp193_ = sql;
			_tmp194_ = where_sql;
			_tmp195_ = zeitgeist_engine_group_and_sort (self, "subj_mimetype", _tmp194_, FALSE, NULL, "max");
			_tmp196_ = _tmp195_;
			_tmp197_ = g_strconcat (_tmp193_, _tmp196_, NULL);
			_g_free0 (sql);
			sql = _tmp197_;
			_g_free0 (_tmp196_);
			break;
		}
		case ZEITGEIST_RESULT_TYPE_LEAST_RECENT_MIMETYPE:
		{
			const gchar* _tmp198_;
			const gchar* _tmp199_;
			gchar* _tmp200_ = NULL;
			gchar* _tmp201_;
			gchar* _tmp202_;
			_tmp198_ = sql;
			_tmp199_ = where_sql;
			_tmp200_ = zeitgeist_engine_group_and_sort (self, "subj_mimetype", _tmp199_, TRUE, NULL, "max");
			_tmp201_ = _tmp200_;
			_tmp202_ = g_strconcat (_tmp198_, _tmp201_, NULL);
			_g_free0 (sql);
			sql = _tmp202_;
			_g_free0 (_tmp201_);
			break;
		}
		case ZEITGEIST_RESULT_TYPE_MOST_POPULAR_MIMETYPE:
		{
			const gchar* _tmp203_;
			const gchar* _tmp204_;
			gboolean _tmp205_;
			gchar* _tmp206_ = NULL;
			gchar* _tmp207_;
			gchar* _tmp208_;
			_tmp203_ = sql;
			_tmp204_ = where_sql;
			_tmp205_ = FALSE;
			_tmp206_ = zeitgeist_engine_group_and_sort (self, "subj_mimetype", _tmp204_, FALSE, &_tmp205_, "max");
			_tmp207_ = _tmp206_;
			_tmp208_ = g_strconcat (_tmp203_, _tmp207_, NULL);
			_g_free0 (sql);
			sql = _tmp208_;
			_g_free0 (_tmp207_);
			break;
		}
		case ZEITGEIST_RESULT_TYPE_LEAST_POPULAR_MIMETYPE:
		{
			const gchar* _tmp209_;
			const gchar* _tmp210_;
			gboolean _tmp211_;
			gchar* _tmp212_ = NULL;
			gchar* _tmp213_;
			gchar* _tmp214_;
			_tmp209_ = sql;
			_tmp210_ = where_sql;
			_tmp211_ = TRUE;
			_tmp212_ = zeitgeist_engine_group_and_sort (self, "subj_mimetype", _tmp210_, TRUE, &_tmp211_, "max");
			_tmp213_ = _tmp212_;
			_tmp214_ = g_strconcat (_tmp209_, _tmp213_, NULL);
			_g_free0 (sql);
			sql = _tmp214_;
			_g_free0 (_tmp213_);
			break;
		}
		default:
		{
			gchar* _tmp215_;
			gchar* error_message;
			const gchar* _tmp216_;
			const gchar* _tmp217_;
			GError* _tmp218_;
			_tmp215_ = g_strdup ("Invalid ResultType.");
			error_message = _tmp215_;
			_tmp216_ = error_message;
			g_warning ("engine.vala:320: %s", _tmp216_);
			_tmp217_ = error_message;
			_tmp218_ = g_error_new_literal (ZEITGEIST_ENGINE_ERROR, ZEITGEIST_ENGINE_ERROR_INVALID_ARGUMENT, _tmp217_);
			_inner_error_ = _tmp218_;
			if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (error_message);
				_g_free0 (where_sql);
				_g_free0 (sql);
				_g_object_unref0 (tpl_conditions);
				_g_object_unref0 (where);
				return NULL;
			} else {
				_g_free0 (error_message);
				_g_free0 (where_sql);
				_g_free0 (sql);
				_g_object_unref0 (tpl_conditions);
				_g_object_unref0 (where);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
			_g_free0 (error_message);
		}
	}
	_tmp219_ = max_events;
	if (_tmp219_ > ((guint) 0)) {
		const gchar* _tmp220_;
		guint _tmp221_;
		gchar* _tmp222_ = NULL;
		gchar* _tmp223_;
		gchar* _tmp224_;
		_tmp220_ = sql;
		_tmp221_ = max_events;
		_tmp222_ = g_strdup_printf (" LIMIT %u", _tmp221_);
		_tmp223_ = _tmp222_;
		_tmp224_ = g_strconcat (_tmp220_, _tmp223_, NULL);
		_g_free0 (sql);
		sql = _tmp224_;
		_g_free0 (_tmp223_);
	}
	_tmp225_ = self->priv->db;
	_tmp226_ = sql;
	_tmp228_ = sqlite3_prepare_v2 (_tmp225_, _tmp226_, -1, &_tmp227_, NULL);
	_sqlite3_finalize0 (stmt);
	stmt = _tmp227_;
	rc = _tmp228_;
	_tmp229_ = self->priv->_database;
	_tmp230_ = rc;
	zeitgeist_sq_lite_zeitgeist_database_assert_query_success (_tmp229_, _tmp230_, "SQL error", SQLITE_OK, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_sqlite3_finalize0 (stmt);
			_g_free0 (where_sql);
			_g_free0 (sql);
			_g_object_unref0 (tpl_conditions);
			_g_object_unref0 (where);
			return NULL;
		} else {
			_sqlite3_finalize0 (stmt);
			_g_free0 (where_sql);
			_g_free0 (sql);
			_g_object_unref0 (tpl_conditions);
			_g_object_unref0 (where);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp231_ = where;
	_tmp232_ = zeitgeist_where_clause_get_bind_arguments (_tmp231_);
	_tmp233_ = _g_ptr_array_ref0 (_tmp232_);
	arguments = _tmp233_;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp234_;
			_tmp234_ = TRUE;
			while (TRUE) {
				gboolean _tmp235_;
				gint _tmp237_;
				GPtrArray* _tmp238_;
				gint _tmp239_;
				gint _tmp240_;
				sqlite3_stmt* _tmp241_;
				gint _tmp242_;
				GPtrArray* _tmp243_;
				gint _tmp244_;
				gconstpointer _tmp245_ = NULL;
				gchar* _tmp246_;
				GDestroyNotify _tmp247_;
				_tmp235_ = _tmp234_;
				if (!_tmp235_) {
					gint _tmp236_;
					_tmp236_ = i;
					i = _tmp236_ + 1;
				}
				_tmp234_ = FALSE;
				_tmp237_ = i;
				_tmp238_ = arguments;
				_tmp239_ = g_ptr_array_get_length (_tmp238_);
				_tmp240_ = _tmp239_;
				if (!(_tmp237_ < _tmp240_)) {
					break;
				}
				_tmp241_ = stmt;
				_tmp242_ = i;
				_tmp243_ = arguments;
				_tmp244_ = i;
				_tmp245_ = g_ptr_array_index (_tmp243_, (guint) _tmp244_);
				_tmp246_ = g_strdup ((const gchar*) _tmp245_);
				_tmp247_ = g_free;
				sqlite3_bind_text (_tmp241_, _tmp242_ + 1, _tmp246_, -1, _tmp247_);
			}
		}
	}
	_tmp248_ = g_new0 (guint32, 0);
	event_ids = _tmp248_;
	event_ids_length1 = 0;
	_event_ids_size_ = event_ids_length1;
	while (TRUE) {
		sqlite3_stmt* _tmp249_;
		gint _tmp250_ = 0;
		gint _tmp251_;
		sqlite3_stmt* _tmp252_;
		const gchar* _tmp253_ = NULL;
		guint64 _tmp254_ = 0ULL;
		guint32 id;
		guint32* _tmp255_;
		gint _tmp255__length1;
		guint32 _tmp256_;
		_tmp249_ = stmt;
		_tmp250_ = sqlite3_step (_tmp249_);
		rc = _tmp250_;
		_tmp251_ = rc;
		if (!(_tmp251_ == SQLITE_ROW)) {
			break;
		}
		_tmp252_ = stmt;
		_tmp253_ = sqlite3_column_text (_tmp252_, (gint) ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_ID);
		_tmp254_ = uint64_parse (_tmp253_);
		id = (guint32) _tmp254_;
		_tmp255_ = event_ids;
		_tmp255__length1 = event_ids_length1;
		_tmp256_ = id;
		_vala_array_add1 (&event_ids, &event_ids_length1, &_event_ids_size_, _tmp256_);
	}
	_tmp257_ = rc;
	if (_tmp257_ != SQLITE_DONE) {
		gint _tmp258_;
		sqlite3* _tmp259_;
		const gchar* _tmp260_ = NULL;
		gchar* _tmp261_ = NULL;
		gchar* error_message;
		const gchar* _tmp262_;
		const gchar* _tmp263_;
		GError* _tmp264_;
		_tmp258_ = rc;
		_tmp259_ = self->priv->db;
		_tmp260_ = sqlite3_errmsg (_tmp259_);
		_tmp261_ = g_strdup_printf ("Error in find_event_ids: %d, %s", _tmp258_, _tmp260_);
		error_message = _tmp261_;
		_tmp262_ = error_message;
		g_warning ("engine.vala:349: %s", _tmp262_);
		_tmp263_ = error_message;
		_tmp264_ = g_error_new_literal (ZEITGEIST_ENGINE_ERROR, ZEITGEIST_ENGINE_ERROR_DATABASE_ERROR, _tmp263_);
		_inner_error_ = _tmp264_;
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (error_message);
			event_ids = (g_free (event_ids), NULL);
			_g_ptr_array_unref0 (arguments);
			_sqlite3_finalize0 (stmt);
			_g_free0 (where_sql);
			_g_free0 (sql);
			_g_object_unref0 (tpl_conditions);
			_g_object_unref0 (where);
			return NULL;
		} else {
			_g_free0 (error_message);
			event_ids = (g_free (event_ids), NULL);
			_g_ptr_array_unref0 (arguments);
			_sqlite3_finalize0 (stmt);
			_g_free0 (where_sql);
			_g_free0 (sql);
			_g_object_unref0 (tpl_conditions);
			_g_object_unref0 (where);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_g_free0 (error_message);
	}
	_tmp265_ = event_ids;
	_tmp265__length1 = event_ids_length1;
	if (result_length1) {
		*result_length1 = _tmp265__length1;
	}
	result = _tmp265_;
	_g_ptr_array_unref0 (arguments);
	_sqlite3_finalize0 (stmt);
	_g_free0 (where_sql);
	_g_free0 (sql);
	_g_object_unref0 (tpl_conditions);
	_g_object_unref0 (where);
	return result;
}


GPtrArray* zeitgeist_engine_find_events (ZeitgeistEngine* self, ZeitgeistTimeRange* time_range, GPtrArray* event_templates, guint storage_state, guint max_events, guint result_type, const char* sender, GError** error) {
	GPtrArray* result = NULL;
	ZeitgeistTimeRange* _tmp0_;
	GPtrArray* _tmp1_;
	guint _tmp2_;
	guint _tmp3_;
	guint _tmp4_;
	gint _tmp5_ = 0;
	guint32* _tmp6_ = NULL;
	guint32* _tmp7_;
	gint _tmp7__length1;
	gint __tmp7__size_;
	guint32* _tmp8_;
	gint _tmp8__length1;
	GPtrArray* _tmp9_ = NULL;
	GPtrArray* _tmp10_;
	GPtrArray* _tmp11_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (time_range != NULL, NULL);
	g_return_val_if_fail (event_templates != NULL, NULL);
	_tmp0_ = time_range;
	_tmp1_ = event_templates;
	_tmp2_ = storage_state;
	_tmp3_ = max_events;
	_tmp4_ = result_type;
	_tmp6_ = zeitgeist_engine_find_event_ids (self, _tmp0_, _tmp1_, _tmp2_, _tmp3_, _tmp4_, NULL, &_tmp5_, &_inner_error_);
	_tmp7_ = _tmp6_;
	_tmp7__length1 = _tmp5_;
	__tmp7__size_ = _tmp7__length1;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp8_ = _tmp7_;
	_tmp8__length1 = _tmp7__length1;
	_tmp9_ = zeitgeist_engine_get_events (self, _tmp8_, _tmp7__length1, NULL, &_inner_error_);
	_tmp10_ = _tmp9_;
	_tmp8_ = (g_free (_tmp8_), NULL);
	_tmp11_ = _tmp10_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	result = _tmp11_;
	return result;
}


static void _zeitgeist_engine_related_uri_free0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (zeitgeist_engine_related_uri_free (var), NULL));
}


static gpointer _zeitgeist_engine_related_uri_dup0 (gpointer self) {
	return self ? zeitgeist_engine_related_uri_dup (self) : NULL;
}


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static gboolean _vala_uint32_array_contains (guint32* stack, int stack_length, guint32 needle) {
	int i;
	for (i = 0; i < stack_length; i++) {
		if (needle == stack[i]) {
			return TRUE;
		}
	}
	return FALSE;
}


static gint ___lambda5_ (ZeitgeistEngineRelatedUri* a, ZeitgeistEngineRelatedUri* b) {
	gint result = 0;
	ZeitgeistEngineRelatedUri* _tmp0_;
	gint32 _tmp1_;
	ZeitgeistEngineRelatedUri* _tmp2_;
	gint32 _tmp3_;
	_tmp0_ = a;
	_tmp1_ = (*_tmp0_).counter;
	_tmp2_ = b;
	_tmp3_ = (*_tmp2_).counter;
	result = (gint) (_tmp1_ - _tmp3_);
	return result;
}


static gint ____lambda5__gcompare_func (gconstpointer a, gconstpointer b) {
	gint result;
	result = ___lambda5_ (a, b);
	return result;
}


static gint ___lambda6_ (ZeitgeistEngineRelatedUri* a, ZeitgeistEngineRelatedUri* b) {
	gint result = 0;
	ZeitgeistEngineRelatedUri* _tmp0_;
	gint64 _tmp1_;
	ZeitgeistEngineRelatedUri* _tmp2_;
	gint64 _tmp3_;
	gint64 delta;
	gint64 _tmp4_;
	_tmp0_ = a;
	_tmp1_ = (*_tmp0_).timestamp;
	_tmp2_ = b;
	_tmp3_ = (*_tmp2_).timestamp;
	delta = _tmp1_ - _tmp3_;
	_tmp4_ = delta;
	if (_tmp4_ < ((gint64) 0)) {
		result = 1;
		return result;
	} else {
		gint64 _tmp5_;
		_tmp5_ = delta;
		if (_tmp5_ > ((gint64) 0)) {
			result = -1;
			return result;
		} else {
			result = 0;
			return result;
		}
	}
}


static gint ____lambda6__gcompare_func (gconstpointer a, gconstpointer b) {
	gint result;
	result = ___lambda6_ (a, b);
	return result;
}


static gint ____lambda7_ (ZeitgeistEngineRelatedUri* a, ZeitgeistEngineRelatedUri* b) {
	gint result = 0;
	ZeitgeistEngineRelatedUri* _tmp0_;
	gint64 _tmp1_;
	ZeitgeistEngineRelatedUri* _tmp2_;
	gint64 _tmp3_;
	gint64 delta;
	gint64 _tmp4_;
	_tmp0_ = a;
	_tmp1_ = (*_tmp0_).timestamp;
	_tmp2_ = b;
	_tmp3_ = (*_tmp2_).timestamp;
	delta = _tmp1_ - _tmp3_;
	_tmp4_ = delta;
	if (_tmp4_ < ((gint64) 0)) {
		result = 1;
		return result;
	} else {
		gint64 _tmp5_;
		_tmp5_ = delta;
		if (_tmp5_ > ((gint64) 0)) {
			result = -1;
			return result;
		} else {
			result = 0;
			return result;
		}
	}
}


static gint _____lambda7__gcompare_func (gconstpointer a, gconstpointer b) {
	gint result;
	result = ____lambda7_ (a, b);
	return result;
}


static void _g_list_free__zeitgeist_engine_related_uri_free0_ (GList* self) {
	g_list_foreach (self, (GFunc) _zeitgeist_engine_related_uri_free0_, NULL);
	g_list_free (self);
}


gchar** zeitgeist_engine_find_related_uris (ZeitgeistEngine* self, ZeitgeistTimeRange* time_range, GPtrArray* event_templates, GPtrArray* result_event_templates, guint storage_state, guint max_results, guint result_type, const char* sender, int* result_length1, GError** error) {
	gchar** result = NULL;
	gboolean _tmp0_ = FALSE;
	guint _tmp1_;
	gboolean _tmp3_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (time_range != NULL, NULL);
	g_return_val_if_fail (event_templates != NULL, NULL);
	g_return_val_if_fail (result_event_templates != NULL, NULL);
	_tmp1_ = result_type;
	if (_tmp1_ == ((guint) ZEITGEIST_RESULT_TYPE_MOST_RECENT_EVENTS)) {
		_tmp0_ = TRUE;
	} else {
		guint _tmp2_;
		_tmp2_ = result_type;
		_tmp0_ = _tmp2_ == ((guint) ZEITGEIST_RESULT_TYPE_LEAST_RECENT_EVENTS);
	}
	_tmp3_ = _tmp0_;
	if (_tmp3_) {
		ZeitgeistTimeRange* _tmp4_;
		GPtrArray* _tmp5_;
		guint _tmp6_;
		gint _tmp7_ = 0;
		guint32* _tmp8_ = NULL;
		guint32* ids;
		gint ids_length1;
		gint _ids_size_;
		gboolean _tmp9_ = FALSE;
		GPtrArray* _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		gboolean _tmp14_;
		guint32* result_ids = NULL;
		gint result_ids_length1 = 0;
		gint _result_ids_size_ = 0;
		ZeitgeistTimeRange* _tmp16_;
		GPtrArray* _tmp17_;
		guint _tmp18_;
		gint _tmp19_ = 0;
		guint32* _tmp20_ = NULL;
		guint32* _tmp21_;
		gint _tmp21__length1;
		gint __tmp21__size_;
		guint32* _tmp22_;
		gint _tmp22__length1;
		guint32* _tmp23_;
		gint _tmp23__length1;
		guint32* _tmp24_ = NULL;
		guint32* pot;
		gint pot_length1;
		gint _pot_size_;
		sqlite3_stmt* stmt = NULL;
		ZeitgeistSQLiteZeitgeistDatabase* _tmp49_;
		guint32* _tmp50_;
		gint _tmp50__length1;
		gchar* _tmp51_ = NULL;
		gchar* sql_event_ids;
		const gchar* _tmp52_;
		gchar* _tmp53_ = NULL;
		gchar* sql;
		sqlite3* _tmp54_;
		const gchar* _tmp55_;
		sqlite3_stmt* _tmp56_ = NULL;
		gint _tmp57_ = 0;
		gint rc;
		ZeitgeistSQLiteZeitgeistDatabase* _tmp58_;
		gint _tmp59_;
		GPtrArray* _tmp60_;
		GPtrArray* temp_related_uris;
		gint _tmp77_;
		GHashFunc _tmp85_;
		GEqualFunc _tmp86_;
		GHashTable* _tmp87_;
		GHashTable* uri_counter;
		GList* temp_ruris;
		GList* values;
		GHashTable* _tmp181_;
		GList* _tmp182_ = NULL;
		GList* _tmp185_;
		guint _tmp193_;
		GList* _tmp194_;
		guint _tmp195_ = 0U;
		gchar** _tmp196_ = NULL;
		gchar** results;
		gint results_length1;
		gint _results_size_;
		gint i;
		GList* _tmp197_;
		gchar** _tmp213_;
		gint _tmp213__length1;
		_tmp4_ = time_range;
		_tmp5_ = event_templates;
		_tmp6_ = storage_state;
		_tmp8_ = zeitgeist_engine_find_event_ids (self, _tmp4_, _tmp5_, _tmp6_, (guint) 0, (guint) ZEITGEIST_RESULT_TYPE_LEAST_RECENT_EVENTS, NULL, &_tmp7_, &_inner_error_);
		ids = _tmp8_;
		ids_length1 = _tmp7_;
		_ids_size_ = ids_length1;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
				g_propagate_error (error, _inner_error_);
				return NULL;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		_tmp10_ = event_templates;
		_tmp11_ = g_ptr_array_get_length (_tmp10_);
		_tmp12_ = _tmp11_;
		if (_tmp12_ > 0) {
			guint32* _tmp13_;
			gint _tmp13__length1;
			_tmp13_ = ids;
			_tmp13__length1 = ids_length1;
			_tmp9_ = _tmp13__length1 == 0;
		} else {
			_tmp9_ = FALSE;
		}
		_tmp14_ = _tmp9_;
		if (_tmp14_) {
			GError* _tmp15_;
			_tmp15_ = g_error_new_literal (ZEITGEIST_ENGINE_ERROR, ZEITGEIST_ENGINE_ERROR_INVALID_ARGUMENT, "No results found for the event_templates");
			_inner_error_ = _tmp15_;
			if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
				g_propagate_error (error, _inner_error_);
				ids = (g_free (ids), NULL);
				return NULL;
			} else {
				ids = (g_free (ids), NULL);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		_tmp16_ = time_range;
		_tmp17_ = result_event_templates;
		_tmp18_ = storage_state;
		_tmp20_ = zeitgeist_engine_find_event_ids (self, _tmp16_, _tmp17_, _tmp18_, (guint) 0, (guint) ZEITGEIST_RESULT_TYPE_LEAST_RECENT_EVENTS, NULL, &_tmp19_, &_inner_error_);
		_tmp21_ = _tmp20_;
		_tmp21__length1 = _tmp19_;
		__tmp21__size_ = _tmp21__length1;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
				g_propagate_error (error, _inner_error_);
				result_ids = (g_free (result_ids), NULL);
				ids = (g_free (ids), NULL);
				return NULL;
			} else {
				result_ids = (g_free (result_ids), NULL);
				ids = (g_free (ids), NULL);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		result_ids = (g_free (result_ids), NULL);
		result_ids = _tmp21_;
		result_ids_length1 = _tmp21__length1;
		_result_ids_size_ = result_ids_length1;
		_tmp22_ = ids;
		_tmp22__length1 = ids_length1;
		_tmp23_ = result_ids;
		_tmp23__length1 = result_ids_length1;
		_tmp24_ = g_new0 (guint32, _tmp22__length1 + _tmp23__length1);
		pot = _tmp24_;
		pot_length1 = _tmp22__length1 + _tmp23__length1;
		_pot_size_ = pot_length1;
		{
			guint32 i;
			i = (guint32) 0;
			{
				gboolean _tmp25_;
				_tmp25_ = TRUE;
				while (TRUE) {
					gboolean _tmp26_;
					guint32 _tmp28_;
					guint32* _tmp29_;
					gint _tmp29__length1;
					guint32* _tmp30_;
					gint _tmp30__length1;
					guint32 _tmp31_;
					guint32* _tmp32_;
					gint _tmp32__length1;
					guint32 _tmp33_;
					guint32 _tmp34_;
					guint32 _tmp35_;
					_tmp26_ = _tmp25_;
					if (!_tmp26_) {
						guint32 _tmp27_;
						_tmp27_ = i;
						i = _tmp27_ + 1;
					}
					_tmp25_ = FALSE;
					_tmp28_ = i;
					_tmp29_ = ids;
					_tmp29__length1 = ids_length1;
					if (!(_tmp28_ < ((guint32) _tmp29__length1))) {
						break;
					}
					_tmp30_ = pot;
					_tmp30__length1 = pot_length1;
					_tmp31_ = i;
					_tmp32_ = ids;
					_tmp32__length1 = ids_length1;
					_tmp33_ = i;
					_tmp34_ = _tmp32_[_tmp33_];
					_tmp30_[_tmp31_] = _tmp34_;
					_tmp35_ = _tmp30_[_tmp31_];
				}
			}
		}
		{
			guint32 i;
			i = (guint32) 0;
			{
				gboolean _tmp36_;
				_tmp36_ = TRUE;
				while (TRUE) {
					gboolean _tmp37_;
					guint32 _tmp39_;
					guint32* _tmp40_;
					gint _tmp40__length1;
					guint32* _tmp41_;
					gint _tmp41__length1;
					guint32* _tmp42_;
					gint _tmp42__length1;
					guint32 _tmp43_;
					guint32* _tmp44_;
					gint _tmp44__length1;
					guint32* _tmp45_;
					gint _tmp45__length1;
					guint32 _tmp46_;
					guint32 _tmp47_;
					guint32 _tmp48_;
					_tmp37_ = _tmp36_;
					if (!_tmp37_) {
						guint32 _tmp38_;
						_tmp38_ = i;
						i = _tmp38_ + 1;
					}
					_tmp36_ = FALSE;
					_tmp39_ = i;
					_tmp40_ = result_ids;
					_tmp40__length1 = result_ids_length1;
					if (!(_tmp39_ < ((guint32) _tmp40__length1))) {
						break;
					}
					_tmp41_ = pot;
					_tmp41__length1 = pot_length1;
					_tmp42_ = ids;
					_tmp42__length1 = ids_length1;
					_tmp43_ = i;
					_tmp44_ = result_ids;
					_tmp44__length1 = result_ids_length1;
					_tmp45_ = ids;
					_tmp45__length1 = ids_length1;
					_tmp46_ = i;
					_tmp47_ = _tmp44_[_tmp45__length1 + _tmp46_];
					_tmp41_[_tmp42__length1 + _tmp43_] = _tmp47_;
					_tmp48_ = _tmp41_[_tmp42__length1 + _tmp43_];
				}
			}
		}
		_tmp49_ = self->priv->_database;
		_tmp50_ = pot;
		_tmp50__length1 = pot_length1;
		_tmp51_ = zeitgeist_sq_lite_zeitgeist_database_get_sql_string_from_event_ids (_tmp49_, _tmp50_, _tmp50__length1);
		sql_event_ids = _tmp51_;
		_tmp52_ = sql_event_ids;
		_tmp53_ = g_strdup_printf ("\n" \
"               SELECT id, timestamp, subj_uri FROM event_view \n" \
"               WHERE id IN (%s) ORDER BY timestamp ASC\n" \
"               ", _tmp52_);
		sql = _tmp53_;
		_tmp54_ = self->priv->db;
		_tmp55_ = sql;
		_tmp57_ = sqlite3_prepare_v2 (_tmp54_, _tmp55_, -1, &_tmp56_, NULL);
		_sqlite3_finalize0 (stmt);
		stmt = _tmp56_;
		rc = _tmp57_;
		_tmp58_ = self->priv->_database;
		_tmp59_ = rc;
		zeitgeist_sq_lite_zeitgeist_database_assert_query_success (_tmp58_, _tmp59_, "SQL error", SQLITE_OK, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (sql);
				_g_free0 (sql_event_ids);
				_sqlite3_finalize0 (stmt);
				pot = (g_free (pot), NULL);
				result_ids = (g_free (result_ids), NULL);
				ids = (g_free (ids), NULL);
				return NULL;
			} else {
				_g_free0 (sql);
				_g_free0 (sql_event_ids);
				_sqlite3_finalize0 (stmt);
				pot = (g_free (pot), NULL);
				result_ids = (g_free (result_ids), NULL);
				ids = (g_free (ids), NULL);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		_tmp60_ = g_ptr_array_new_with_free_func (_zeitgeist_engine_related_uri_free0_);
		temp_related_uris = _tmp60_;
		while (TRUE) {
			sqlite3_stmt* _tmp61_;
			gint _tmp62_ = 0;
			gint _tmp63_;
			sqlite3_stmt* _tmp64_;
			const gchar* _tmp65_ = NULL;
			guint64 _tmp66_ = 0ULL;
			sqlite3_stmt* _tmp67_;
			gint64 _tmp68_ = 0LL;
			sqlite3_stmt* _tmp69_;
			const gchar* _tmp70_ = NULL;
			gchar* _tmp71_;
			ZeitgeistEngineRelatedUri _tmp72_ = {0};
			ZeitgeistEngineRelatedUri ruri;
			GPtrArray* _tmp73_;
			ZeitgeistEngineRelatedUri _tmp74_;
			ZeitgeistEngineRelatedUri _tmp75_;
			ZeitgeistEngineRelatedUri* _tmp76_;
			_tmp61_ = stmt;
			_tmp62_ = sqlite3_step (_tmp61_);
			rc = _tmp62_;
			_tmp63_ = rc;
			if (!(_tmp63_ == SQLITE_ROW)) {
				break;
			}
			_tmp64_ = stmt;
			_tmp65_ = sqlite3_column_text (_tmp64_, 0);
			_tmp66_ = uint64_parse (_tmp65_);
			_tmp67_ = stmt;
			_tmp68_ = sqlite3_column_int64 (_tmp67_, 1);
			_tmp69_ = stmt;
			_tmp70_ = sqlite3_column_text (_tmp69_, 2);
			_tmp71_ = g_strdup (_tmp70_);
			memset (&_tmp72_, 0, sizeof (ZeitgeistEngineRelatedUri));
			_tmp72_.id = (guint32) _tmp66_;
			_tmp72_.timestamp = _tmp68_;
			_g_free0 (_tmp72_.uri);
			_tmp72_.uri = _tmp71_;
			_tmp72_.counter = (gint32) 0;
			ruri = _tmp72_;
			_tmp73_ = temp_related_uris;
			_tmp74_ = ruri;
			_tmp75_ = _tmp74_;
			_tmp76_ = _zeitgeist_engine_related_uri_dup0 (&_tmp75_);
			g_ptr_array_add (_tmp73_, _tmp76_);
			zeitgeist_engine_related_uri_destroy (&ruri);
		}
		_tmp77_ = rc;
		if (_tmp77_ != SQLITE_DONE) {
			gint _tmp78_;
			sqlite3* _tmp79_;
			const gchar* _tmp80_ = NULL;
			gchar* _tmp81_ = NULL;
			gchar* error_message;
			const gchar* _tmp82_;
			const gchar* _tmp83_;
			GError* _tmp84_;
			_tmp78_ = rc;
			_tmp79_ = self->priv->db;
			_tmp80_ = sqlite3_errmsg (_tmp79_);
			_tmp81_ = g_strdup_printf ("Error in find_related_uris: %d, %s", _tmp78_, _tmp80_);
			error_message = _tmp81_;
			_tmp82_ = error_message;
			g_warning ("engine.vala:454: %s", _tmp82_);
			_tmp83_ = error_message;
			_tmp84_ = g_error_new_literal (ZEITGEIST_ENGINE_ERROR, ZEITGEIST_ENGINE_ERROR_DATABASE_ERROR, _tmp83_);
			_inner_error_ = _tmp84_;
			if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (error_message);
				_g_ptr_array_unref0 (temp_related_uris);
				_g_free0 (sql);
				_g_free0 (sql_event_ids);
				_sqlite3_finalize0 (stmt);
				pot = (g_free (pot), NULL);
				result_ids = (g_free (result_ids), NULL);
				ids = (g_free (ids), NULL);
				return NULL;
			} else {
				_g_free0 (error_message);
				_g_ptr_array_unref0 (temp_related_uris);
				_g_free0 (sql);
				_g_free0 (sql_event_ids);
				_sqlite3_finalize0 (stmt);
				pot = (g_free (pot), NULL);
				result_ids = (g_free (result_ids), NULL);
				ids = (g_free (ids), NULL);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
			_g_free0 (error_message);
		}
		_tmp85_ = g_str_hash;
		_tmp86_ = g_str_equal;
		_tmp87_ = g_hash_table_new_full (_tmp85_, _tmp86_, _g_free0_, _zeitgeist_engine_related_uri_free0_);
		uri_counter = _tmp87_;
		{
			gint i;
			i = 0;
			{
				gboolean _tmp88_;
				_tmp88_ = TRUE;
				while (TRUE) {
					gboolean _tmp89_;
					gint _tmp91_;
					GPtrArray* _tmp92_;
					gint _tmp93_;
					gint _tmp94_;
					GPtrArray* _tmp95_;
					GPtrArray* window;
					gboolean count_in_window;
					gboolean _tmp116_;
					_tmp89_ = _tmp88_;
					if (!_tmp89_) {
						gint _tmp90_;
						_tmp90_ = i;
						i = _tmp90_ + 1;
					}
					_tmp88_ = FALSE;
					_tmp91_ = i;
					_tmp92_ = temp_related_uris;
					_tmp93_ = g_ptr_array_get_length (_tmp92_);
					_tmp94_ = _tmp93_;
					if (!(_tmp91_ < _tmp94_)) {
						break;
					}
					_tmp95_ = g_ptr_array_new_with_free_func (NULL);
					window = _tmp95_;
					count_in_window = FALSE;
					{
						gint _tmp96_;
						gint _tmp97_ = 0;
						gint j;
						_tmp96_ = i;
						_tmp97_ = MAX (0, _tmp96_ - 5);
						j = _tmp97_;
						{
							gboolean _tmp98_;
							_tmp98_ = TRUE;
							while (TRUE) {
								gboolean _tmp99_;
								gint _tmp101_;
								gint _tmp102_;
								GPtrArray* _tmp103_;
								gint _tmp104_;
								gint _tmp105_;
								gint _tmp106_ = 0;
								GPtrArray* _tmp107_;
								GPtrArray* _tmp108_;
								gint _tmp109_;
								gconstpointer _tmp110_ = NULL;
								GPtrArray* _tmp111_;
								gint _tmp112_;
								gconstpointer _tmp113_ = NULL;
								guint32 _tmp114_;
								guint32* _tmp115_;
								gint _tmp115__length1;
								_tmp99_ = _tmp98_;
								if (!_tmp99_) {
									gint _tmp100_;
									_tmp100_ = j;
									j = _tmp100_ + 1;
								}
								_tmp98_ = FALSE;
								_tmp101_ = j;
								_tmp102_ = i;
								_tmp103_ = temp_related_uris;
								_tmp104_ = g_ptr_array_get_length (_tmp103_);
								_tmp105_ = _tmp104_;
								_tmp106_ = MIN (_tmp102_, _tmp105_);
								if (!(_tmp101_ < _tmp106_)) {
									break;
								}
								_tmp107_ = window;
								_tmp108_ = temp_related_uris;
								_tmp109_ = j;
								_tmp110_ = g_ptr_array_index (_tmp108_, (guint) _tmp109_);
								g_ptr_array_add (_tmp107_, (ZeitgeistEngineRelatedUri*) _tmp110_);
								_tmp111_ = temp_related_uris;
								_tmp112_ = j;
								_tmp113_ = g_ptr_array_index (_tmp111_, (guint) _tmp112_);
								_tmp114_ = (*((ZeitgeistEngineRelatedUri*) _tmp113_)).id;
								_tmp115_ = ids;
								_tmp115__length1 = ids_length1;
								if (_vala_uint32_array_contains (_tmp115_, _tmp115__length1, _tmp114_)) {
									count_in_window = TRUE;
								}
							}
						}
					}
					_tmp116_ = count_in_window;
					if (_tmp116_) {
						{
							gint j;
							j = 0;
							{
								gboolean _tmp117_;
								_tmp117_ = TRUE;
								while (TRUE) {
									gboolean _tmp118_;
									gint _tmp120_;
									GPtrArray* _tmp121_;
									gint _tmp122_;
									gint _tmp123_;
									GHashTable* _tmp124_;
									GPtrArray* _tmp125_;
									gint _tmp126_;
									gconstpointer _tmp127_ = NULL;
									const gchar* _tmp128_;
									gconstpointer _tmp129_ = NULL;
									GHashTable* _tmp153_;
									GPtrArray* _tmp154_;
									gint _tmp155_;
									gconstpointer _tmp156_ = NULL;
									const gchar* _tmp157_;
									gconstpointer _tmp158_ = NULL;
									gint32 _tmp159_;
									GHashTable* _tmp160_;
									GPtrArray* _tmp161_;
									gint _tmp162_;
									gconstpointer _tmp163_ = NULL;
									const gchar* _tmp164_;
									gconstpointer _tmp165_ = NULL;
									gint64 _tmp166_;
									GPtrArray* _tmp167_;
									gint _tmp168_;
									gconstpointer _tmp169_ = NULL;
									gint64 _tmp170_;
									_tmp118_ = _tmp117_;
									if (!_tmp118_) {
										gint _tmp119_;
										_tmp119_ = j;
										j = _tmp119_ + 1;
									}
									_tmp117_ = FALSE;
									_tmp120_ = j;
									_tmp121_ = window;
									_tmp122_ = g_ptr_array_get_length (_tmp121_);
									_tmp123_ = _tmp122_;
									if (!(_tmp120_ < _tmp123_)) {
										break;
									}
									_tmp124_ = uri_counter;
									_tmp125_ = window;
									_tmp126_ = j;
									_tmp127_ = g_ptr_array_index (_tmp125_, (guint) _tmp126_);
									_tmp128_ = (*((ZeitgeistEngineRelatedUri*) _tmp127_)).uri;
									_tmp129_ = g_hash_table_lookup (_tmp124_, _tmp128_);
									if (((ZeitgeistEngineRelatedUri*) _tmp129_) == NULL) {
										GPtrArray* _tmp130_;
										gint _tmp131_;
										gconstpointer _tmp132_ = NULL;
										guint32 _tmp133_;
										GPtrArray* _tmp134_;
										gint _tmp135_;
										gconstpointer _tmp136_ = NULL;
										gint64 _tmp137_;
										GPtrArray* _tmp138_;
										gint _tmp139_;
										gconstpointer _tmp140_ = NULL;
										const gchar* _tmp141_;
										gchar* _tmp142_;
										ZeitgeistEngineRelatedUri _tmp143_ = {0};
										ZeitgeistEngineRelatedUri ruri;
										GHashTable* _tmp144_;
										GPtrArray* _tmp145_;
										gint _tmp146_;
										gconstpointer _tmp147_ = NULL;
										const gchar* _tmp148_;
										gchar* _tmp149_;
										ZeitgeistEngineRelatedUri _tmp150_;
										ZeitgeistEngineRelatedUri _tmp151_;
										ZeitgeistEngineRelatedUri* _tmp152_;
										_tmp130_ = window;
										_tmp131_ = j;
										_tmp132_ = g_ptr_array_index (_tmp130_, (guint) _tmp131_);
										_tmp133_ = (*((ZeitgeistEngineRelatedUri*) _tmp132_)).id;
										_tmp134_ = window;
										_tmp135_ = j;
										_tmp136_ = g_ptr_array_index (_tmp134_, (guint) _tmp135_);
										_tmp137_ = (*((ZeitgeistEngineRelatedUri*) _tmp136_)).timestamp;
										_tmp138_ = window;
										_tmp139_ = j;
										_tmp140_ = g_ptr_array_index (_tmp138_, (guint) _tmp139_);
										_tmp141_ = (*((ZeitgeistEngineRelatedUri*) _tmp140_)).uri;
										_tmp142_ = g_strdup (_tmp141_);
										memset (&_tmp143_, 0, sizeof (ZeitgeistEngineRelatedUri));
										_tmp143_.id = _tmp133_;
										_tmp143_.timestamp = _tmp137_;
										_g_free0 (_tmp143_.uri);
										_tmp143_.uri = _tmp142_;
										_tmp143_.counter = (gint32) 0;
										ruri = _tmp143_;
										_tmp144_ = uri_counter;
										_tmp145_ = window;
										_tmp146_ = j;
										_tmp147_ = g_ptr_array_index (_tmp145_, (guint) _tmp146_);
										_tmp148_ = (*((ZeitgeistEngineRelatedUri*) _tmp147_)).uri;
										_tmp149_ = g_strdup (_tmp148_);
										_tmp150_ = ruri;
										_tmp151_ = _tmp150_;
										_tmp152_ = _zeitgeist_engine_related_uri_dup0 (&_tmp151_);
										g_hash_table_insert (_tmp144_, _tmp149_, _tmp152_);
										zeitgeist_engine_related_uri_destroy (&ruri);
									}
									_tmp153_ = uri_counter;
									_tmp154_ = window;
									_tmp155_ = j;
									_tmp156_ = g_ptr_array_index (_tmp154_, (guint) _tmp155_);
									_tmp157_ = (*((ZeitgeistEngineRelatedUri*) _tmp156_)).uri;
									_tmp158_ = g_hash_table_lookup (_tmp153_, _tmp157_);
									_tmp159_ = (*((ZeitgeistEngineRelatedUri*) _tmp158_)).counter;
									(*((ZeitgeistEngineRelatedUri*) _tmp158_)).counter = _tmp159_ + 1;
									_tmp160_ = uri_counter;
									_tmp161_ = window;
									_tmp162_ = j;
									_tmp163_ = g_ptr_array_index (_tmp161_, (guint) _tmp162_);
									_tmp164_ = (*((ZeitgeistEngineRelatedUri*) _tmp163_)).uri;
									_tmp165_ = g_hash_table_lookup (_tmp160_, _tmp164_);
									_tmp166_ = (*((ZeitgeistEngineRelatedUri*) _tmp165_)).timestamp;
									_tmp167_ = window;
									_tmp168_ = j;
									_tmp169_ = g_ptr_array_index (_tmp167_, (guint) _tmp168_);
									_tmp170_ = (*((ZeitgeistEngineRelatedUri*) _tmp169_)).timestamp;
									if (_tmp166_ < _tmp170_) {
										GHashTable* _tmp171_;
										GPtrArray* _tmp172_;
										gint _tmp173_;
										gconstpointer _tmp174_ = NULL;
										const gchar* _tmp175_;
										gconstpointer _tmp176_ = NULL;
										GPtrArray* _tmp177_;
										gint _tmp178_;
										gconstpointer _tmp179_ = NULL;
										gint64 _tmp180_;
										_tmp171_ = uri_counter;
										_tmp172_ = window;
										_tmp173_ = j;
										_tmp174_ = g_ptr_array_index (_tmp172_, (guint) _tmp173_);
										_tmp175_ = (*((ZeitgeistEngineRelatedUri*) _tmp174_)).uri;
										_tmp176_ = g_hash_table_lookup (_tmp171_, _tmp175_);
										_tmp177_ = window;
										_tmp178_ = j;
										_tmp179_ = g_ptr_array_index (_tmp177_, (guint) _tmp178_);
										_tmp180_ = (*((ZeitgeistEngineRelatedUri*) _tmp179_)).timestamp;
										(*((ZeitgeistEngineRelatedUri*) _tmp176_)).timestamp = _tmp180_;
									}
								}
							}
						}
					}
					_g_ptr_array_unref0 (window);
				}
			}
		}
		temp_ruris = NULL;
		values = NULL;
		_tmp181_ = uri_counter;
		_tmp182_ = g_hash_table_get_values (_tmp181_);
		{
			GList* uri_collection = NULL;
			GList* uri_it = NULL;
			uri_collection = _tmp182_;
			for (uri_it = uri_collection; uri_it != NULL; uri_it = uri_it->next) {
				ZeitgeistEngineRelatedUri* uri = NULL;
				uri = (ZeitgeistEngineRelatedUri*) uri_it->data;
				{
					ZeitgeistEngineRelatedUri* _tmp183_;
					ZeitgeistEngineRelatedUri* _tmp184_;
					_tmp183_ = uri;
					_tmp184_ = _zeitgeist_engine_related_uri_dup0 (_tmp183_);
					values = g_list_append (values, _tmp184_);
				}
			}
			_g_list_free0 (uri_collection);
		}
		values = g_list_sort (values, ____lambda5__gcompare_func);
		values = g_list_sort (values, ____lambda6__gcompare_func);
		_tmp185_ = values;
		{
			GList* ruri_collection = NULL;
			GList* ruri_it = NULL;
			ruri_collection = _tmp185_;
			for (ruri_it = ruri_collection; ruri_it != NULL; ruri_it = ruri_it->next) {
				ZeitgeistEngineRelatedUri _tmp186_ = {0};
				ZeitgeistEngineRelatedUri ruri = {0};
				zeitgeist_engine_related_uri_copy ((ZeitgeistEngineRelatedUri*) ruri_it->data, &_tmp186_);
				ruri = _tmp186_;
				{
					GList* _tmp187_;
					guint _tmp188_ = 0U;
					guint _tmp189_;
					_tmp187_ = temp_ruris;
					_tmp188_ = g_list_length (_tmp187_);
					_tmp189_ = max_results;
					if (_tmp188_ < _tmp189_) {
						ZeitgeistEngineRelatedUri _tmp190_;
						ZeitgeistEngineRelatedUri _tmp191_;
						ZeitgeistEngineRelatedUri* _tmp192_;
						_tmp190_ = ruri;
						_tmp191_ = _tmp190_;
						_tmp192_ = _zeitgeist_engine_related_uri_dup0 (&_tmp191_);
						temp_ruris = g_list_append (temp_ruris, _tmp192_);
					} else {
						zeitgeist_engine_related_uri_destroy (&ruri);
						break;
					}
					zeitgeist_engine_related_uri_destroy (&ruri);
				}
			}
		}
		_tmp193_ = result_type;
		if (_tmp193_ == ((guint) 1)) {
			temp_ruris = g_list_sort (temp_ruris, _____lambda7__gcompare_func);
		}
		_tmp194_ = temp_ruris;
		_tmp195_ = g_list_length (_tmp194_);
		_tmp196_ = g_new0 (gchar*, _tmp195_ + 1);
		results = _tmp196_;
		results_length1 = _tmp195_;
		_results_size_ = results_length1;
		i = 0;
		_tmp197_ = temp_ruris;
		{
			GList* uri_collection = NULL;
			GList* uri_it = NULL;
			uri_collection = _tmp197_;
			for (uri_it = uri_collection; uri_it != NULL; uri_it = uri_it->next) {
				ZeitgeistEngineRelatedUri* _tmp198_;
				ZeitgeistEngineRelatedUri* uri = NULL;
				_tmp198_ = _zeitgeist_engine_related_uri_dup0 ((ZeitgeistEngineRelatedUri*) uri_it->data);
				uri = _tmp198_;
				{
					gchar** _tmp199_;
					gint _tmp199__length1;
					gint _tmp200_;
					ZeitgeistEngineRelatedUri* _tmp201_;
					const gchar* _tmp202_;
					gchar* _tmp203_;
					gchar* _tmp204_;
					FILE* _tmp205_;
					ZeitgeistEngineRelatedUri* _tmp206_;
					gint32 _tmp207_;
					ZeitgeistEngineRelatedUri* _tmp208_;
					gint64 _tmp209_;
					ZeitgeistEngineRelatedUri* _tmp210_;
					const gchar* _tmp211_;
					gint _tmp212_;
					_tmp199_ = results;
					_tmp199__length1 = results_length1;
					_tmp200_ = i;
					_tmp201_ = uri;
					_tmp202_ = (*_tmp201_).uri;
					_tmp203_ = g_strdup (_tmp202_);
					_g_free0 (_tmp199_[_tmp200_]);
					_tmp199_[_tmp200_] = _tmp203_;
					_tmp204_ = _tmp199_[_tmp200_];
					_tmp205_ = stdout;
					_tmp206_ = uri;
					_tmp207_ = (*_tmp206_).counter;
					_tmp208_ = uri;
					_tmp209_ = (*_tmp208_).timestamp;
					_tmp210_ = uri;
					_tmp211_ = (*_tmp210_).uri;
					fprintf (_tmp205_, "%i %lld %s\n", (gint) _tmp207_, _tmp209_, _tmp211_);
					_tmp212_ = i;
					i = _tmp212_ + 1;
					_zeitgeist_engine_related_uri_free0 (uri);
				}
			}
		}
		_tmp213_ = results;
		_tmp213__length1 = results_length1;
		if (result_length1) {
			*result_length1 = _tmp213__length1;
		}
		result = _tmp213_;
		__g_list_free__zeitgeist_engine_related_uri_free0_0 (values);
		__g_list_free__zeitgeist_engine_related_uri_free0_0 (temp_ruris);
		_g_hash_table_unref0 (uri_counter);
		_g_ptr_array_unref0 (temp_related_uris);
		_g_free0 (sql);
		_g_free0 (sql_event_ids);
		_sqlite3_finalize0 (stmt);
		pot = (g_free (pot), NULL);
		result_ids = (g_free (result_ids), NULL);
		ids = (g_free (ids), NULL);
		return result;
	} else {
		GError* _tmp214_;
		_tmp214_ = g_error_new_literal (ZEITGEIST_ENGINE_ERROR, ZEITGEIST_ENGINE_ERROR_DATABASE_ERROR, "Unsupported ResultType.");
		_inner_error_ = _tmp214_;
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
}


guint32* zeitgeist_engine_insert_events (ZeitgeistEngine* self, GPtrArray* events, const char* sender, int* result_length1, GError** error) {
	guint32* result = NULL;
	ZeitgeistExtensionCollection* _tmp0_;
	GPtrArray* _tmp1_;
	const char* _tmp2_;
	GPtrArray* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	guint32* _tmp6_ = NULL;
	guint32* event_ids;
	gint event_ids_length1;
	gint _event_ids_size_;
	ZeitgeistSQLiteZeitgeistDatabase* _tmp7_;
	ZeitgeistSQLiteZeitgeistDatabase* _tmp27_;
	ZeitgeistExtensionCollection* _tmp28_;
	GPtrArray* _tmp29_;
	const char* _tmp30_;
	guint32* _tmp31_;
	gint _tmp31__length1;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (events != NULL, NULL);
	_tmp0_ = self->priv->extension_collection;
	_tmp1_ = events;
	_tmp2_ = sender;
	zeitgeist_extension_collection_call_pre_insert_events (_tmp0_, _tmp1_, _tmp2_);
	_tmp3_ = events;
	_tmp4_ = g_ptr_array_get_length (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_new0 (guint32, _tmp5_);
	event_ids = _tmp6_;
	event_ids_length1 = _tmp5_;
	_event_ids_size_ = event_ids_length1;
	_tmp7_ = self->priv->_database;
	zeitgeist_sq_lite_zeitgeist_database_begin_transaction (_tmp7_, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			event_ids = (g_free (event_ids), NULL);
			return NULL;
		} else {
			event_ids = (g_free (event_ids), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	{
		gint i;
		i = 0;
		{
			gboolean _tmp8_;
			_tmp8_ = TRUE;
			while (TRUE) {
				gboolean _tmp9_;
				gint _tmp11_;
				GPtrArray* _tmp12_;
				gint _tmp13_;
				gint _tmp14_;
				GPtrArray* _tmp15_;
				gint _tmp16_;
				gconstpointer _tmp17_ = NULL;
				_tmp9_ = _tmp8_;
				if (!_tmp9_) {
					gint _tmp10_;
					_tmp10_ = i;
					i = _tmp10_ + 1;
				}
				_tmp8_ = FALSE;
				_tmp11_ = i;
				_tmp12_ = events;
				_tmp13_ = g_ptr_array_get_length (_tmp12_);
				_tmp14_ = _tmp13_;
				if (!(_tmp11_ < _tmp14_)) {
					break;
				}
				_tmp15_ = events;
				_tmp16_ = i;
				_tmp17_ = g_ptr_array_index (_tmp15_, (guint) _tmp16_);
				if (((ZeitgeistEvent*) _tmp17_) != NULL) {
					GPtrArray* _tmp18_;
					gint _tmp19_;
					gconstpointer _tmp20_ = NULL;
					const char* _tmp21_;
					guint32 _tmp22_ = 0U;
					guint32 _tmp23_;
					guint32* _tmp24_;
					gint _tmp24__length1;
					gint _tmp25_;
					guint32 _tmp26_;
					_tmp18_ = events;
					_tmp19_ = i;
					_tmp20_ = g_ptr_array_index (_tmp18_, (guint) _tmp19_);
					_tmp21_ = sender;
					_tmp22_ = zeitgeist_engine_insert_event (self, (ZeitgeistEvent*) _tmp20_, _tmp21_, &_inner_error_);
					_tmp23_ = _tmp22_;
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
							g_propagate_error (error, _inner_error_);
							event_ids = (g_free (event_ids), NULL);
							return NULL;
						} else {
							event_ids = (g_free (event_ids), NULL);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return NULL;
						}
					}
					_tmp24_ = event_ids;
					_tmp24__length1 = event_ids_length1;
					_tmp25_ = i;
					_tmp24_[_tmp25_] = _tmp23_;
					_tmp26_ = _tmp24_[_tmp25_];
				}
			}
		}
	}
	_tmp27_ = self->priv->_database;
	zeitgeist_sq_lite_zeitgeist_database_end_transaction (_tmp27_, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			event_ids = (g_free (event_ids), NULL);
			return NULL;
		} else {
			event_ids = (g_free (event_ids), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp28_ = self->priv->extension_collection;
	_tmp29_ = events;
	_tmp30_ = sender;
	zeitgeist_extension_collection_call_post_insert_events (_tmp28_, _tmp29_, _tmp30_);
	_tmp31_ = event_ids;
	_tmp31__length1 = event_ids_length1;
	if (result_length1) {
		*result_length1 = _tmp31__length1;
	}
	result = _tmp31_;
	return result;
}


guint32 zeitgeist_engine_insert_event (ZeitgeistEngine* self, ZeitgeistEvent* event, const char* sender, GError** error) {
	guint32 result = 0U;
	ZeitgeistEvent* _tmp0_;
	guint32 _tmp1_;
	guint32 _tmp2_;
	ZeitgeistEvent* _tmp3_;
	gint _tmp4_ = 0;
	ZeitgeistEvent* _tmp5_;
	guint32 _tmp6_;
	guint32 _tmp7_;
	ZeitgeistEvent* _tmp119_;
	gint64 _tmp120_ = 0LL;
	gint64 payload_id;
	gint rc = 0;
	ZeitgeistSQLiteZeitgeistDatabase* _tmp121_;
	sqlite3_stmt* _tmp122_;
	sqlite3_stmt* insert_stmt;
	sqlite3_stmt* _tmp123_;
	sqlite3_stmt* _tmp124_;
	ZeitgeistEvent* _tmp125_;
	guint32 _tmp126_;
	guint32 _tmp127_;
	sqlite3_stmt* _tmp128_;
	ZeitgeistEvent* _tmp129_;
	gint64 _tmp130_;
	gint64 _tmp131_;
	sqlite3_stmt* _tmp132_;
	ZeitgeistSQLiteTableLookup* _tmp133_;
	ZeitgeistEvent* _tmp134_;
	const gchar* _tmp135_;
	const gchar* _tmp136_;
	gint _tmp137_ = 0;
	sqlite3_stmt* _tmp138_;
	ZeitgeistSQLiteTableLookup* _tmp139_;
	ZeitgeistEvent* _tmp140_;
	const gchar* _tmp141_;
	const gchar* _tmp142_;
	gint _tmp143_ = 0;
	sqlite3_stmt* _tmp144_;
	ZeitgeistSQLiteTableLookup* _tmp145_;
	ZeitgeistEvent* _tmp146_;
	const gchar* _tmp147_;
	const gchar* _tmp148_;
	gint _tmp149_ = 0;
	sqlite3_stmt* _tmp150_;
	ZeitgeistEvent* _tmp151_;
	const gchar* _tmp152_;
	const gchar* _tmp153_;
	gchar* _tmp154_;
	GDestroyNotify _tmp155_;
	sqlite3_stmt* _tmp156_;
	gint64 _tmp157_;
	ZeitgeistEvent* _tmp259_;
	const gchar* _tmp260_;
	const gchar* _tmp261_;
	ZeitgeistEvent* _tmp263_;
	guint32 _tmp264_;
	guint32 _tmp265_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0U);
	g_return_val_if_fail (event != NULL, 0U);
	_tmp0_ = event;
	_tmp1_ = zeitgeist_event_get_id (_tmp0_);
	_tmp2_ = _tmp1_;
	g_return_val_if_fail (_tmp2_ == ((guint32) 0), 0U);
	_tmp3_ = event;
	_tmp4_ = zeitgeist_event_num_subjects (_tmp3_);
	g_return_val_if_fail (_tmp4_ > 0, 0U);
	_tmp5_ = event;
	_tmp6_ = self->priv->last_id;
	self->priv->last_id = _tmp6_ + 1;
	_tmp7_ = self->priv->last_id;
	zeitgeist_event_set_id (_tmp5_, _tmp7_);
	{
		GPtrArray* _tmp8_;
		GPtrArray* uris;
		GPtrArray* _tmp9_;
		GPtrArray* texts;
		GPtrArray* _tmp10_;
		GPtrArray* storages;
		ZeitgeistEvent* _tmp11_;
		const gchar* _tmp12_;
		const gchar* _tmp13_;
		_tmp8_ = g_ptr_array_new_with_free_func (_g_free0_);
		uris = _tmp8_;
		_tmp9_ = g_ptr_array_new_with_free_func (_g_free0_);
		texts = _tmp9_;
		_tmp10_ = g_ptr_array_new_with_free_func (_g_free0_);
		storages = _tmp10_;
		_tmp11_ = event;
		_tmp12_ = zeitgeist_event_get_origin (_tmp11_);
		_tmp13_ = _tmp12_;
		if (g_strcmp0 (_tmp13_, "") != 0) {
			GPtrArray* _tmp14_;
			ZeitgeistEvent* _tmp15_;
			const gchar* _tmp16_;
			const gchar* _tmp17_;
			gchar* _tmp18_;
			_tmp14_ = uris;
			_tmp15_ = event;
			_tmp16_ = zeitgeist_event_get_origin (_tmp15_);
			_tmp17_ = _tmp16_;
			_tmp18_ = g_strdup (_tmp17_);
			g_ptr_array_add (_tmp14_, _tmp18_);
		}
		{
			gint i;
			i = 0;
			{
				gboolean _tmp19_;
				_tmp19_ = TRUE;
				while (TRUE) {
					gboolean _tmp20_;
					gint _tmp22_;
					ZeitgeistEvent* _tmp23_;
					gint _tmp24_ = 0;
					ZeitgeistEvent* _tmp25_;
					GPtrArray* _tmp26_;
					GPtrArray* _tmp27_;
					gint _tmp28_;
					gconstpointer _tmp29_ = NULL;
					ZeitgeistSubject* subject;
					GPtrArray* _tmp30_;
					ZeitgeistSubject* _tmp31_;
					const gchar* _tmp32_;
					const gchar* _tmp33_;
					gchar* _tmp34_;
					gboolean _tmp35_ = FALSE;
					ZeitgeistSubject* _tmp36_;
					const gchar* _tmp37_;
					const gchar* _tmp38_;
					gboolean _tmp42_;
					gboolean _tmp47_ = FALSE;
					ZeitgeistEvent* _tmp48_;
					const gchar* _tmp49_;
					const gchar* _tmp50_;
					gboolean _tmp57_;
					GPtrArray* _tmp71_;
					ZeitgeistSubject* _tmp72_;
					const gchar* _tmp73_;
					const gchar* _tmp74_;
					gchar* _tmp75_;
					ZeitgeistSubject* _tmp76_;
					const gchar* _tmp77_;
					const gchar* _tmp78_;
					ZeitgeistSubject* _tmp84_;
					const gchar* _tmp85_;
					const gchar* _tmp86_;
					ZeitgeistSubject* _tmp92_;
					const gchar* _tmp93_;
					const gchar* _tmp94_;
					_tmp20_ = _tmp19_;
					if (!_tmp20_) {
						gint _tmp21_;
						_tmp21_ = i;
						i = _tmp21_ + 1;
					}
					_tmp19_ = FALSE;
					_tmp22_ = i;
					_tmp23_ = event;
					_tmp24_ = zeitgeist_event_num_subjects (_tmp23_);
					if (!(_tmp22_ < _tmp24_)) {
						break;
					}
					_tmp25_ = event;
					_tmp26_ = zeitgeist_event_get_subjects (_tmp25_);
					_tmp27_ = _tmp26_;
					_tmp28_ = i;
					_tmp29_ = g_ptr_array_index (_tmp27_, (guint) _tmp28_);
					subject = (ZeitgeistSubject*) _tmp29_;
					_tmp30_ = uris;
					_tmp31_ = subject;
					_tmp32_ = zeitgeist_subject_get_uri (_tmp31_);
					_tmp33_ = _tmp32_;
					_tmp34_ = g_strdup (_tmp33_);
					g_ptr_array_add (_tmp30_, _tmp34_);
					_tmp36_ = subject;
					_tmp37_ = zeitgeist_subject_get_current_uri (_tmp36_);
					_tmp38_ = _tmp37_;
					if (g_strcmp0 (_tmp38_, "") == 0) {
						_tmp35_ = TRUE;
					} else {
						ZeitgeistSubject* _tmp39_;
						const gchar* _tmp40_;
						const gchar* _tmp41_;
						_tmp39_ = subject;
						_tmp40_ = zeitgeist_subject_get_current_uri (_tmp39_);
						_tmp41_ = _tmp40_;
						_tmp35_ = _tmp41_ == NULL;
					}
					_tmp42_ = _tmp35_;
					if (_tmp42_) {
						ZeitgeistSubject* _tmp43_;
						ZeitgeistSubject* _tmp44_;
						const gchar* _tmp45_;
						const gchar* _tmp46_;
						_tmp43_ = subject;
						_tmp44_ = subject;
						_tmp45_ = zeitgeist_subject_get_uri (_tmp44_);
						_tmp46_ = _tmp45_;
						zeitgeist_subject_set_current_uri (_tmp43_, _tmp46_);
					}
					_tmp48_ = event;
					_tmp49_ = zeitgeist_event_get_interpretation (_tmp48_);
					_tmp50_ = _tmp49_;
					if (g_strcmp0 (_tmp50_, ZEITGEIST_ZG_MOVE_EVENT) == 0) {
						ZeitgeistSubject* _tmp51_;
						const gchar* _tmp52_;
						const gchar* _tmp53_;
						ZeitgeistSubject* _tmp54_;
						const gchar* _tmp55_;
						const gchar* _tmp56_;
						_tmp51_ = subject;
						_tmp52_ = zeitgeist_subject_get_uri (_tmp51_);
						_tmp53_ = _tmp52_;
						_tmp54_ = subject;
						_tmp55_ = zeitgeist_subject_get_current_uri (_tmp54_);
						_tmp56_ = _tmp55_;
						_tmp47_ = g_strcmp0 (_tmp53_, _tmp56_) == 0;
					} else {
						_tmp47_ = FALSE;
					}
					_tmp57_ = _tmp47_;
					if (_tmp57_) {
						GError* _tmp58_;
						_tmp58_ = g_error_new_literal (ZEITGEIST_ENGINE_ERROR, ZEITGEIST_ENGINE_ERROR_INVALID_ARGUMENT, "Illegal event: unless event.interpretation is " "'MOVE_EVENT' then subject.uri and " "subject.current_uri have to be the same");
						_inner_error_ = _tmp58_;
						if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
							g_propagate_error (error, _inner_error_);
							_g_ptr_array_unref0 (storages);
							_g_ptr_array_unref0 (texts);
							_g_ptr_array_unref0 (uris);
							return 0U;
						} else {
							_g_ptr_array_unref0 (storages);
							_g_ptr_array_unref0 (texts);
							_g_ptr_array_unref0 (uris);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return 0U;
						}
					} else {
						gboolean _tmp59_ = FALSE;
						ZeitgeistEvent* _tmp60_;
						const gchar* _tmp61_;
						const gchar* _tmp62_;
						gboolean _tmp69_;
						_tmp60_ = event;
						_tmp61_ = zeitgeist_event_get_interpretation (_tmp60_);
						_tmp62_ = _tmp61_;
						if (g_strcmp0 (_tmp62_, ZEITGEIST_ZG_MOVE_EVENT) != 0) {
							ZeitgeistSubject* _tmp63_;
							const gchar* _tmp64_;
							const gchar* _tmp65_;
							ZeitgeistSubject* _tmp66_;
							const gchar* _tmp67_;
							const gchar* _tmp68_;
							_tmp63_ = subject;
							_tmp64_ = zeitgeist_subject_get_uri (_tmp63_);
							_tmp65_ = _tmp64_;
							_tmp66_ = subject;
							_tmp67_ = zeitgeist_subject_get_current_uri (_tmp66_);
							_tmp68_ = _tmp67_;
							_tmp59_ = g_strcmp0 (_tmp65_, _tmp68_) != 0;
						} else {
							_tmp59_ = FALSE;
						}
						_tmp69_ = _tmp59_;
						if (_tmp69_) {
							GError* _tmp70_;
							_tmp70_ = g_error_new_literal (ZEITGEIST_ENGINE_ERROR, ZEITGEIST_ENGINE_ERROR_INVALID_ARGUMENT, "Redundant event: event.interpretation indicates " "the uri has been moved yet the subject.uri and " "subject.current_uri are identical");
							_inner_error_ = _tmp70_;
							if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
								g_propagate_error (error, _inner_error_);
								_g_ptr_array_unref0 (storages);
								_g_ptr_array_unref0 (texts);
								_g_ptr_array_unref0 (uris);
								return 0U;
							} else {
								_g_ptr_array_unref0 (storages);
								_g_ptr_array_unref0 (texts);
								_g_ptr_array_unref0 (uris);
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return 0U;
							}
						}
					}
					_tmp71_ = uris;
					_tmp72_ = subject;
					_tmp73_ = zeitgeist_subject_get_current_uri (_tmp72_);
					_tmp74_ = _tmp73_;
					_tmp75_ = g_strdup (_tmp74_);
					g_ptr_array_add (_tmp71_, _tmp75_);
					_tmp76_ = subject;
					_tmp77_ = zeitgeist_subject_get_origin (_tmp76_);
					_tmp78_ = _tmp77_;
					if (g_strcmp0 (_tmp78_, "") != 0) {
						GPtrArray* _tmp79_;
						ZeitgeistSubject* _tmp80_;
						const gchar* _tmp81_;
						const gchar* _tmp82_;
						gchar* _tmp83_;
						_tmp79_ = uris;
						_tmp80_ = subject;
						_tmp81_ = zeitgeist_subject_get_origin (_tmp80_);
						_tmp82_ = _tmp81_;
						_tmp83_ = g_strdup (_tmp82_);
						g_ptr_array_add (_tmp79_, _tmp83_);
					}
					_tmp84_ = subject;
					_tmp85_ = zeitgeist_subject_get_text (_tmp84_);
					_tmp86_ = _tmp85_;
					if (g_strcmp0 (_tmp86_, "") != 0) {
						GPtrArray* _tmp87_;
						ZeitgeistSubject* _tmp88_;
						const gchar* _tmp89_;
						const gchar* _tmp90_;
						gchar* _tmp91_;
						_tmp87_ = texts;
						_tmp88_ = subject;
						_tmp89_ = zeitgeist_subject_get_text (_tmp88_);
						_tmp90_ = _tmp89_;
						_tmp91_ = g_strdup (_tmp90_);
						g_ptr_array_add (_tmp87_, _tmp91_);
					}
					_tmp92_ = subject;
					_tmp93_ = zeitgeist_subject_get_storage (_tmp92_);
					_tmp94_ = _tmp93_;
					if (g_strcmp0 (_tmp94_, "") != 0) {
						GPtrArray* _tmp95_;
						ZeitgeistSubject* _tmp96_;
						const gchar* _tmp97_;
						const gchar* _tmp98_;
						gchar* _tmp99_;
						_tmp95_ = storages;
						_tmp96_ = subject;
						_tmp97_ = zeitgeist_subject_get_storage (_tmp96_);
						_tmp98_ = _tmp97_;
						_tmp99_ = g_strdup (_tmp98_);
						g_ptr_array_add (_tmp95_, _tmp99_);
					}
				}
			}
		}
		{
			GPtrArray* _tmp100_;
			gint _tmp101_;
			gint _tmp102_;
			GPtrArray* _tmp105_;
			gint _tmp106_;
			gint _tmp107_;
			GPtrArray* _tmp110_;
			gint _tmp111_;
			gint _tmp112_;
			_tmp100_ = uris;
			_tmp101_ = g_ptr_array_get_length (_tmp100_);
			_tmp102_ = _tmp101_;
			if (_tmp102_ > 0) {
				ZeitgeistSQLiteZeitgeistDatabase* _tmp103_;
				GPtrArray* _tmp104_;
				_tmp103_ = self->priv->_database;
				_tmp104_ = uris;
				zeitgeist_sq_lite_zeitgeist_database_insert_or_ignore_into_table (_tmp103_, "uri", _tmp104_, &_inner_error_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
						goto __catch6_zeitgeist_engine_error;
					}
					_g_ptr_array_unref0 (storages);
					_g_ptr_array_unref0 (texts);
					_g_ptr_array_unref0 (uris);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0U;
				}
			}
			_tmp105_ = texts;
			_tmp106_ = g_ptr_array_get_length (_tmp105_);
			_tmp107_ = _tmp106_;
			if (_tmp107_ > 0) {
				ZeitgeistSQLiteZeitgeistDatabase* _tmp108_;
				GPtrArray* _tmp109_;
				_tmp108_ = self->priv->_database;
				_tmp109_ = texts;
				zeitgeist_sq_lite_zeitgeist_database_insert_or_ignore_into_table (_tmp108_, "text", _tmp109_, &_inner_error_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
						goto __catch6_zeitgeist_engine_error;
					}
					_g_ptr_array_unref0 (storages);
					_g_ptr_array_unref0 (texts);
					_g_ptr_array_unref0 (uris);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0U;
				}
			}
			_tmp110_ = storages;
			_tmp111_ = g_ptr_array_get_length (_tmp110_);
			_tmp112_ = _tmp111_;
			if (_tmp112_ > 0) {
				ZeitgeistSQLiteZeitgeistDatabase* _tmp113_;
				GPtrArray* _tmp114_;
				_tmp113_ = self->priv->_database;
				_tmp114_ = storages;
				zeitgeist_sq_lite_zeitgeist_database_insert_or_ignore_into_table (_tmp113_, "storage", _tmp114_, &_inner_error_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
						goto __catch6_zeitgeist_engine_error;
					}
					_g_ptr_array_unref0 (storages);
					_g_ptr_array_unref0 (texts);
					_g_ptr_array_unref0 (uris);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0U;
				}
			}
		}
		goto __finally6;
		__catch6_zeitgeist_engine_error:
		{
			GError* e = NULL;
			GError* _tmp115_;
			const gchar* _tmp116_;
			gchar* _tmp117_;
			gchar* _tmp118_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp115_ = e;
			_tmp116_ = _tmp115_->message;
			_tmp117_ = g_strconcat ("Can't insert data for event: ", _tmp116_, NULL);
			_tmp118_ = _tmp117_;
			g_warning ("engine.vala:632: %s", _tmp118_);
			_g_free0 (_tmp118_);
			result = (guint32) 0;
			_g_error_free0 (e);
			_g_ptr_array_unref0 (storages);
			_g_ptr_array_unref0 (texts);
			_g_ptr_array_unref0 (uris);
			return result;
		}
		__finally6:
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_ptr_array_unref0 (storages);
				_g_ptr_array_unref0 (texts);
				_g_ptr_array_unref0 (uris);
				return 0U;
			} else {
				_g_ptr_array_unref0 (storages);
				_g_ptr_array_unref0 (texts);
				_g_ptr_array_unref0 (uris);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return 0U;
			}
		}
		_g_ptr_array_unref0 (storages);
		_g_ptr_array_unref0 (texts);
		_g_ptr_array_unref0 (uris);
	}
	_tmp119_ = event;
	_tmp120_ = zeitgeist_engine_store_payload (self, _tmp119_);
	payload_id = _tmp120_;
	_tmp121_ = self->priv->_database;
	_tmp122_ = _tmp121_->event_insertion_stmt;
	insert_stmt = _tmp122_;
	_tmp123_ = insert_stmt;
	sqlite3_reset (_tmp123_);
	_tmp124_ = insert_stmt;
	_tmp125_ = event;
	_tmp126_ = zeitgeist_event_get_id (_tmp125_);
	_tmp127_ = _tmp126_;
	sqlite3_bind_int64 (_tmp124_, 1, (gint64) _tmp127_);
	_tmp128_ = insert_stmt;
	_tmp129_ = event;
	_tmp130_ = zeitgeist_event_get_timestamp (_tmp129_);
	_tmp131_ = _tmp130_;
	sqlite3_bind_int64 (_tmp128_, 2, _tmp131_);
	_tmp132_ = insert_stmt;
	_tmp133_ = self->interpretations_table;
	_tmp134_ = event;
	_tmp135_ = zeitgeist_event_get_interpretation (_tmp134_);
	_tmp136_ = _tmp135_;
	_tmp137_ = zeitgeist_sq_lite_table_lookup_get_id (_tmp133_, _tmp136_);
	sqlite3_bind_int64 (_tmp132_, 3, (gint64) _tmp137_);
	_tmp138_ = insert_stmt;
	_tmp139_ = self->manifestations_table;
	_tmp140_ = event;
	_tmp141_ = zeitgeist_event_get_manifestation (_tmp140_);
	_tmp142_ = _tmp141_;
	_tmp143_ = zeitgeist_sq_lite_table_lookup_get_id (_tmp139_, _tmp142_);
	sqlite3_bind_int64 (_tmp138_, 4, (gint64) _tmp143_);
	_tmp144_ = insert_stmt;
	_tmp145_ = self->actors_table;
	_tmp146_ = event;
	_tmp147_ = zeitgeist_event_get_actor (_tmp146_);
	_tmp148_ = _tmp147_;
	_tmp149_ = zeitgeist_sq_lite_table_lookup_get_id (_tmp145_, _tmp148_);
	sqlite3_bind_int64 (_tmp144_, 5, (gint64) _tmp149_);
	_tmp150_ = insert_stmt;
	_tmp151_ = event;
	_tmp152_ = zeitgeist_event_get_origin (_tmp151_);
	_tmp153_ = _tmp152_;
	_tmp154_ = g_strdup (_tmp153_);
	_tmp155_ = g_free;
	sqlite3_bind_text (_tmp150_, 6, _tmp154_, -1, _tmp155_);
	_tmp156_ = insert_stmt;
	_tmp157_ = payload_id;
	sqlite3_bind_int64 (_tmp156_, 7, _tmp157_);
	{
		gint i;
		i = 0;
		{
			gboolean _tmp158_;
			_tmp158_ = TRUE;
			while (TRUE) {
				gboolean _tmp159_;
				gint _tmp161_;
				ZeitgeistEvent* _tmp162_;
				gint _tmp163_ = 0;
				sqlite3_stmt* _tmp164_;
				ZeitgeistEvent* _tmp165_;
				GPtrArray* _tmp166_;
				GPtrArray* _tmp167_;
				gint _tmp168_;
				gconstpointer _tmp169_ = NULL;
				ZeitgeistSubject* subject;
				sqlite3_stmt* _tmp170_;
				ZeitgeistSubject* _tmp171_;
				const gchar* _tmp172_;
				const gchar* _tmp173_;
				gchar* _tmp174_;
				GDestroyNotify _tmp175_;
				sqlite3_stmt* _tmp176_;
				ZeitgeistSubject* _tmp177_;
				const gchar* _tmp178_;
				const gchar* _tmp179_;
				gchar* _tmp180_;
				GDestroyNotify _tmp181_;
				sqlite3_stmt* _tmp182_;
				ZeitgeistSQLiteTableLookup* _tmp183_;
				ZeitgeistSubject* _tmp184_;
				const gchar* _tmp185_;
				const gchar* _tmp186_;
				gint _tmp187_ = 0;
				sqlite3_stmt* _tmp188_;
				ZeitgeistSQLiteTableLookup* _tmp189_;
				ZeitgeistSubject* _tmp190_;
				const gchar* _tmp191_;
				const gchar* _tmp192_;
				gint _tmp193_ = 0;
				sqlite3_stmt* _tmp194_;
				ZeitgeistSubject* _tmp195_;
				const gchar* _tmp196_;
				const gchar* _tmp197_;
				gchar* _tmp198_;
				GDestroyNotify _tmp199_;
				sqlite3_stmt* _tmp200_;
				ZeitgeistSQLiteTableLookup* _tmp201_;
				ZeitgeistSubject* _tmp202_;
				const gchar* _tmp203_;
				const gchar* _tmp204_;
				gint _tmp205_ = 0;
				sqlite3_stmt* _tmp206_;
				ZeitgeistSubject* _tmp207_;
				const gchar* _tmp208_;
				const gchar* _tmp209_;
				gchar* _tmp210_;
				GDestroyNotify _tmp211_;
				sqlite3_stmt* _tmp212_;
				ZeitgeistSubject* _tmp213_;
				const gchar* _tmp214_;
				const gchar* _tmp215_;
				gchar* _tmp216_;
				GDestroyNotify _tmp217_;
				sqlite3_stmt* _tmp218_;
				gint _tmp219_ = 0;
				gint _tmp220_;
				_tmp159_ = _tmp158_;
				if (!_tmp159_) {
					gint _tmp160_;
					_tmp160_ = i;
					i = _tmp160_ + 1;
				}
				_tmp158_ = FALSE;
				_tmp161_ = i;
				_tmp162_ = event;
				_tmp163_ = zeitgeist_event_num_subjects (_tmp162_);
				if (!(_tmp161_ < _tmp163_)) {
					break;
				}
				_tmp164_ = insert_stmt;
				sqlite3_reset (_tmp164_);
				_tmp165_ = event;
				_tmp166_ = zeitgeist_event_get_subjects (_tmp165_);
				_tmp167_ = _tmp166_;
				_tmp168_ = i;
				_tmp169_ = g_ptr_array_index (_tmp167_, (guint) _tmp168_);
				subject = (ZeitgeistSubject*) _tmp169_;
				_tmp170_ = insert_stmt;
				_tmp171_ = subject;
				_tmp172_ = zeitgeist_subject_get_uri (_tmp171_);
				_tmp173_ = _tmp172_;
				_tmp174_ = g_strdup (_tmp173_);
				_tmp175_ = g_free;
				sqlite3_bind_text (_tmp170_, 8, _tmp174_, -1, _tmp175_);
				_tmp176_ = insert_stmt;
				_tmp177_ = subject;
				_tmp178_ = zeitgeist_subject_get_current_uri (_tmp177_);
				_tmp179_ = _tmp178_;
				_tmp180_ = g_strdup (_tmp179_);
				_tmp181_ = g_free;
				sqlite3_bind_text (_tmp176_, 9, _tmp180_, -1, _tmp181_);
				_tmp182_ = insert_stmt;
				_tmp183_ = self->interpretations_table;
				_tmp184_ = subject;
				_tmp185_ = zeitgeist_subject_get_interpretation (_tmp184_);
				_tmp186_ = _tmp185_;
				_tmp187_ = zeitgeist_sq_lite_table_lookup_get_id (_tmp183_, _tmp186_);
				sqlite3_bind_int64 (_tmp182_, 10, (gint64) _tmp187_);
				_tmp188_ = insert_stmt;
				_tmp189_ = self->manifestations_table;
				_tmp190_ = subject;
				_tmp191_ = zeitgeist_subject_get_manifestation (_tmp190_);
				_tmp192_ = _tmp191_;
				_tmp193_ = zeitgeist_sq_lite_table_lookup_get_id (_tmp189_, _tmp192_);
				sqlite3_bind_int64 (_tmp188_, 11, (gint64) _tmp193_);
				_tmp194_ = insert_stmt;
				_tmp195_ = subject;
				_tmp196_ = zeitgeist_subject_get_origin (_tmp195_);
				_tmp197_ = _tmp196_;
				_tmp198_ = g_strdup (_tmp197_);
				_tmp199_ = g_free;
				sqlite3_bind_text (_tmp194_, 12, _tmp198_, -1, _tmp199_);
				_tmp200_ = insert_stmt;
				_tmp201_ = self->mimetypes_table;
				_tmp202_ = subject;
				_tmp203_ = zeitgeist_subject_get_mimetype (_tmp202_);
				_tmp204_ = _tmp203_;
				_tmp205_ = zeitgeist_sq_lite_table_lookup_get_id (_tmp201_, _tmp204_);
				sqlite3_bind_int64 (_tmp200_, 13, (gint64) _tmp205_);
				_tmp206_ = insert_stmt;
				_tmp207_ = subject;
				_tmp208_ = zeitgeist_subject_get_text (_tmp207_);
				_tmp209_ = _tmp208_;
				_tmp210_ = g_strdup (_tmp209_);
				_tmp211_ = g_free;
				sqlite3_bind_text (_tmp206_, 14, _tmp210_, -1, _tmp211_);
				_tmp212_ = insert_stmt;
				_tmp213_ = subject;
				_tmp214_ = zeitgeist_subject_get_storage (_tmp213_);
				_tmp215_ = _tmp214_;
				_tmp216_ = g_strdup (_tmp215_);
				_tmp217_ = g_free;
				sqlite3_bind_text (_tmp212_, 15, _tmp216_, -1, _tmp217_);
				_tmp218_ = insert_stmt;
				_tmp219_ = sqlite3_step (_tmp218_);
				rc = _tmp219_;
				_tmp220_ = rc;
				if (_tmp220_ != SQLITE_DONE) {
					gint _tmp221_;
					guint32 _tmp225_;
					ZeitgeistSQLiteZeitgeistDatabase* _tmp226_;
					sqlite3_stmt* _tmp227_;
					sqlite3_stmt* retrieval_stmt;
					sqlite3_stmt* _tmp228_;
					sqlite3_stmt* _tmp229_;
					ZeitgeistEvent* _tmp230_;
					gint64 _tmp231_;
					gint64 _tmp232_;
					sqlite3_stmt* _tmp233_;
					ZeitgeistSQLiteTableLookup* _tmp234_;
					ZeitgeistEvent* _tmp235_;
					const gchar* _tmp236_;
					const gchar* _tmp237_;
					gint _tmp238_ = 0;
					sqlite3_stmt* _tmp239_;
					ZeitgeistSQLiteTableLookup* _tmp240_;
					ZeitgeistEvent* _tmp241_;
					const gchar* _tmp242_;
					const gchar* _tmp243_;
					gint _tmp244_ = 0;
					sqlite3_stmt* _tmp245_;
					ZeitgeistSQLiteTableLookup* _tmp246_;
					ZeitgeistEvent* _tmp247_;
					const gchar* _tmp248_;
					const gchar* _tmp249_;
					gint _tmp250_ = 0;
					sqlite3_stmt* _tmp251_;
					gint _tmp252_ = 0;
					gint _tmp253_;
					sqlite3_stmt* _tmp257_;
					gint _tmp258_ = 0;
					_tmp221_ = rc;
					if (_tmp221_ != SQLITE_CONSTRAINT) {
						gint _tmp222_;
						sqlite3* _tmp223_;
						const gchar* _tmp224_ = NULL;
						_tmp222_ = rc;
						_tmp223_ = self->priv->db;
						_tmp224_ = sqlite3_errmsg (_tmp223_);
						g_warning ("engine.vala:681: SQL error: %d, %s\n", _tmp222_, _tmp224_);
						result = (guint32) 0;
						return result;
					}
					_tmp225_ = self->priv->last_id;
					self->priv->last_id = _tmp225_ - 1;
					_tmp226_ = self->priv->_database;
					_tmp227_ = _tmp226_->id_retrieval_stmt;
					retrieval_stmt = _tmp227_;
					_tmp228_ = retrieval_stmt;
					sqlite3_reset (_tmp228_);
					_tmp229_ = retrieval_stmt;
					_tmp230_ = event;
					_tmp231_ = zeitgeist_event_get_timestamp (_tmp230_);
					_tmp232_ = _tmp231_;
					sqlite3_bind_int64 (_tmp229_, 1, _tmp232_);
					_tmp233_ = retrieval_stmt;
					_tmp234_ = self->interpretations_table;
					_tmp235_ = event;
					_tmp236_ = zeitgeist_event_get_interpretation (_tmp235_);
					_tmp237_ = _tmp236_;
					_tmp238_ = zeitgeist_sq_lite_table_lookup_get_id (_tmp234_, _tmp237_);
					sqlite3_bind_int64 (_tmp233_, 2, (gint64) _tmp238_);
					_tmp239_ = retrieval_stmt;
					_tmp240_ = self->manifestations_table;
					_tmp241_ = event;
					_tmp242_ = zeitgeist_event_get_manifestation (_tmp241_);
					_tmp243_ = _tmp242_;
					_tmp244_ = zeitgeist_sq_lite_table_lookup_get_id (_tmp240_, _tmp243_);
					sqlite3_bind_int64 (_tmp239_, 3, (gint64) _tmp244_);
					_tmp245_ = retrieval_stmt;
					_tmp246_ = self->actors_table;
					_tmp247_ = event;
					_tmp248_ = zeitgeist_event_get_actor (_tmp247_);
					_tmp249_ = _tmp248_;
					_tmp250_ = zeitgeist_sq_lite_table_lookup_get_id (_tmp246_, _tmp249_);
					sqlite3_bind_int64 (_tmp245_, 4, (gint64) _tmp250_);
					_tmp251_ = retrieval_stmt;
					_tmp252_ = sqlite3_step (_tmp251_);
					rc = _tmp252_;
					_tmp253_ = rc;
					if (_tmp253_ != SQLITE_ROW) {
						gint _tmp254_;
						sqlite3* _tmp255_;
						const gchar* _tmp256_ = NULL;
						_tmp254_ = rc;
						_tmp255_ = self->priv->db;
						_tmp256_ = sqlite3_errmsg (_tmp255_);
						g_warning ("engine.vala:701: SQL error: %d, %s\n", _tmp254_, _tmp256_);
						result = (guint32) 0;
						return result;
					}
					_tmp257_ = retrieval_stmt;
					_tmp258_ = sqlite3_column_int (_tmp257_, 0);
					result = (guint32) _tmp258_;
					return result;
				}
			}
		}
	}
	_tmp259_ = event;
	_tmp260_ = zeitgeist_event_get_interpretation (_tmp259_);
	_tmp261_ = _tmp260_;
	if (g_strcmp0 (_tmp261_, ZEITGEIST_ZG_MOVE_EVENT) == 0) {
		ZeitgeistEvent* _tmp262_;
		_tmp262_ = event;
		zeitgeist_engine_handle_move_event (self, _tmp262_);
	}
	_tmp263_ = event;
	_tmp264_ = zeitgeist_event_get_id (_tmp263_);
	_tmp265_ = _tmp264_;
	result = _tmp265_;
	return result;
}


static gint _sqlite3_exec (sqlite3* self, const gchar* sql, sqlite3_callback callback, void* callback_target, gchar** errmsg) {
	gchar* _vala_errmsg = NULL;
	gint result = 0;
	const gchar* sqlite_errmsg = NULL;
	const gchar* _tmp0_;
	sqlite3_callback _tmp1_;
	void* _tmp1__target;
	const gchar* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gint ec;
	const gchar* _tmp6_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (sql != NULL, 0);
	_tmp0_ = sql;
	_tmp1_ = callback;
	_tmp1__target = callback_target;
	_tmp3_ = sqlite3_exec (self, _tmp0_, _tmp1_, _tmp1__target, (char**) (&_tmp2_));
	sqlite_errmsg = _tmp2_;
	ec = _tmp3_;
	if ((&_vala_errmsg) != NULL) {
		const gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp4_ = sqlite_errmsg;
		_tmp5_ = g_strdup (_tmp4_);
		_g_free0 (_vala_errmsg);
		_vala_errmsg = _tmp5_;
	}
	_tmp6_ = sqlite_errmsg;
	sqlite3_free ((void*) _tmp6_);
	result = ec;
	if (errmsg) {
		*errmsg = _vala_errmsg;
	} else {
		_g_free0 (_vala_errmsg);
	}
	return result;
}


ZeitgeistTimeRange* zeitgeist_engine_delete_events (ZeitgeistEngine* self, guint32* event_ids, int event_ids_length1, const char* sender, GError** error) {
	ZeitgeistTimeRange* result = NULL;
	guint32* _tmp0_;
	gint _tmp0__length1;
	ZeitgeistExtensionCollection* _tmp1_;
	guint32* _tmp2_;
	gint _tmp2__length1;
	const char* _tmp3_;
	gint _tmp4_ = 0;
	guint32* _tmp5_ = NULL;
	ZeitgeistSQLiteZeitgeistDatabase* _tmp6_;
	guint32* _tmp7_;
	gint _tmp7__length1;
	ZeitgeistTimeRange* _tmp8_ = NULL;
	ZeitgeistTimeRange* time_range;
	ZeitgeistSQLiteZeitgeistDatabase* _tmp9_;
	guint32* _tmp10_;
	gint _tmp10__length1;
	gchar* _tmp11_ = NULL;
	gchar* sql_event_ids;
	ZeitgeistTimeRange* _tmp12_;
	sqlite3* _tmp16_;
	const gchar* _tmp17_;
	gchar* _tmp18_ = NULL;
	gchar* _tmp19_;
	gint _tmp20_ = 0;
	gint _tmp21_;
	gint rc;
	ZeitgeistSQLiteZeitgeistDatabase* _tmp22_;
	gint _tmp23_;
	sqlite3* _tmp24_;
	gint _tmp25_ = 0;
	guint32* _tmp26_;
	gint _tmp26__length1;
	gchar* _tmp27_ = NULL;
	gchar* _tmp28_;
	ZeitgeistExtensionCollection* _tmp29_;
	guint32* _tmp30_;
	gint _tmp30__length1;
	const char* _tmp31_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = event_ids;
	_tmp0__length1 = event_ids_length1;
	g_return_val_if_fail (_tmp0__length1 > 0, NULL);
	_tmp1_ = self->priv->extension_collection;
	_tmp2_ = event_ids;
	_tmp2__length1 = event_ids_length1;
	_tmp3_ = sender;
	_tmp5_ = zeitgeist_extension_collection_call_pre_delete_events (_tmp1_, _tmp2_, _tmp2__length1, _tmp3_, &_tmp4_);
	event_ids = _tmp5_;
	event_ids_length1 = _tmp4_;
	_tmp6_ = self->priv->_database;
	_tmp7_ = event_ids;
	_tmp7__length1 = event_ids_length1;
	_tmp8_ = zeitgeist_sq_lite_zeitgeist_database_get_time_range_for_event_ids (_tmp6_, _tmp7_, _tmp7__length1, &_inner_error_);
	time_range = _tmp8_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp9_ = self->priv->_database;
	_tmp10_ = event_ids;
	_tmp10__length1 = event_ids_length1;
	_tmp11_ = zeitgeist_sq_lite_zeitgeist_database_get_sql_string_from_event_ids (_tmp9_, _tmp10_, _tmp10__length1);
	sql_event_ids = _tmp11_;
	_tmp12_ = time_range;
	if (_tmp12_ == NULL) {
		const gchar* _tmp13_;
		gchar* _tmp14_ = NULL;
		gchar* _tmp15_;
		_tmp13_ = sql_event_ids;
		_tmp14_ = g_strdup_printf ("Tried to delete non-existing event(s): %s", _tmp13_);
		_tmp15_ = _tmp14_;
		g_warning ("engine.vala:732: %s", _tmp15_);
		_g_free0 (_tmp15_);
		result = NULL;
		_g_free0 (sql_event_ids);
		_g_object_unref0 (time_range);
		return result;
	}
	_tmp16_ = self->priv->db;
	_tmp17_ = sql_event_ids;
	_tmp18_ = g_strdup_printf ("DELETE FROM event WHERE id IN (%s)", _tmp17_);
	_tmp19_ = _tmp18_;
	_tmp20_ = _sqlite3_exec (_tmp16_, _tmp19_, NULL, NULL, NULL);
	_tmp21_ = _tmp20_;
	_g_free0 (_tmp19_);
	rc = _tmp21_;
	_tmp22_ = self->priv->_database;
	_tmp23_ = rc;
	zeitgeist_sq_lite_zeitgeist_database_assert_query_success (_tmp22_, _tmp23_, "SQL Error", SQLITE_OK, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (sql_event_ids);
			_g_object_unref0 (time_range);
			return NULL;
		} else {
			_g_free0 (sql_event_ids);
			_g_object_unref0 (time_range);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp24_ = self->priv->db;
	_tmp25_ = sqlite3_changes (_tmp24_);
	_tmp26_ = event_ids;
	_tmp26__length1 = event_ids_length1;
	_tmp27_ = g_strdup_printf ("Deleted %d (out of %d) events.", _tmp25_, _tmp26__length1);
	_tmp28_ = _tmp27_;
	g_message ("engine.vala:740: %s", _tmp28_);
	_g_free0 (_tmp28_);
	_tmp29_ = self->priv->extension_collection;
	_tmp30_ = event_ids;
	_tmp30__length1 = event_ids_length1;
	_tmp31_ = sender;
	zeitgeist_extension_collection_call_post_delete_events (_tmp29_, _tmp30_, _tmp30__length1, _tmp31_);
	result = time_range;
	_g_free0 (sql_event_ids);
	return result;
}


/**
     * Clear all resources Engine is using (close database connection,
     * unload extensions, etc.).
     *
     * After executing this method on an Engine instance, no other function
     * of said instance may be called.
     */
void zeitgeist_engine_close (ZeitgeistEngine* self) {
	ZeitgeistSQLiteZeitgeistDatabase* _tmp0_;
	g_return_if_fail (self != NULL);
	_g_object_unref0 (self->priv->extension_collection);
	self->priv->extension_collection = NULL;
	_tmp0_ = self->priv->_database;
	zeitgeist_sq_lite_zeitgeist_database_close (_tmp0_);
}


static gchar* zeitgeist_engine_group_and_sort (ZeitgeistEngine* self, const gchar* field, const gchar* where_sql, gboolean time_asc, gboolean* count_asc, const gchar* aggregation_type) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* time_sorting;
	gchar* _tmp4_;
	gchar* aggregation_sql;
	gchar* _tmp5_;
	gchar* order_sql;
	gboolean* _tmp6_;
	const gchar* _tmp13_;
	const gchar* _tmp14_;
	const gchar* _tmp15_;
	const gchar* _tmp16_;
	const gchar* _tmp17_;
	const gchar* _tmp18_;
	const gchar* _tmp19_;
	const gchar* _tmp20_;
	gchar* _tmp21_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (field != NULL, NULL);
	g_return_val_if_fail (where_sql != NULL, NULL);
	g_return_val_if_fail (aggregation_type != NULL, NULL);
	_tmp1_ = time_asc;
	if (_tmp1_) {
		_tmp0_ = "ASC";
	} else {
		_tmp0_ = "DESC";
	}
	_tmp2_ = _tmp0_;
	_tmp3_ = g_strdup (_tmp2_);
	time_sorting = _tmp3_;
	_tmp4_ = g_strdup ("");
	aggregation_sql = _tmp4_;
	_tmp5_ = g_strdup ("");
	order_sql = _tmp5_;
	_tmp6_ = count_asc;
	if (_tmp6_ != NULL) {
		const gchar* _tmp7_;
		gchar* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		gboolean* _tmp10_;
		const gchar* _tmp11_;
		gchar* _tmp12_ = NULL;
		_tmp7_ = field;
		_tmp8_ = g_strdup_printf (", COUNT(%s) AS num_events", _tmp7_);
		_g_free0 (aggregation_sql);
		aggregation_sql = _tmp8_;
		_tmp10_ = count_asc;
		if (*_tmp10_) {
			_tmp9_ = "ASC";
		} else {
			_tmp9_ = "DESC";
		}
		_tmp11_ = _tmp9_;
		_tmp12_ = g_strdup_printf ("num_events %s,", _tmp11_);
		_g_free0 (order_sql);
		order_sql = _tmp12_;
	}
	_tmp13_ = field;
	_tmp14_ = aggregation_type;
	_tmp15_ = aggregation_sql;
	_tmp16_ = where_sql;
	_tmp17_ = field;
	_tmp18_ = field;
	_tmp19_ = order_sql;
	_tmp20_ = time_sorting;
	_tmp21_ = g_strdup_printf ("\n" \
"            NATURAL JOIN (\n" \
"                SELECT %s,\n" \
"                %s(timestamp) AS timestamp\n" \
"                %s\n" \
"                FROM event_view %s\n" \
"                GROUP BY %s)\n" \
"            GROUP BY %s\n" \
"            ORDER BY %s timestamp %s\n" \
"            ", _tmp13_, _tmp14_, _tmp15_, _tmp16_, _tmp17_, _tmp18_, _tmp19_, _tmp20_);
	result = _tmp21_;
	_g_free0 (order_sql);
	_g_free0 (aggregation_sql);
	_g_free0 (time_sorting);
	return result;
}


static ZeitgeistWhereClause* zeitgeist_engine_get_where_clause_from_event_templates (ZeitgeistEngine* self, GPtrArray* templates, GError** error) {
	ZeitgeistWhereClause* result = NULL;
	ZeitgeistWhereClause* _tmp0_;
	ZeitgeistWhereClause* where;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (templates != NULL, NULL);
	_tmp0_ = zeitgeist_where_clause_new (ZEITGEIST_WHERE_CLAUSE_TYPE_OR, FALSE);
	where = _tmp0_;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp1_;
			_tmp1_ = TRUE;
			while (TRUE) {
				gboolean _tmp2_;
				gint _tmp4_;
				GPtrArray* _tmp5_;
				gint _tmp6_;
				gint _tmp7_;
				GPtrArray* _tmp8_;
				gint _tmp9_;
				gconstpointer _tmp10_ = NULL;
				ZeitgeistEvent* _tmp11_;
				ZeitgeistEvent* event_template;
				ZeitgeistEvent* _tmp12_;
				ZeitgeistWhereClause* _tmp13_ = NULL;
				ZeitgeistWhereClause* _tmp14_;
				ZeitgeistWhereClause* _tmp15_;
				ZeitgeistWhereClause* _tmp16_;
				_tmp2_ = _tmp1_;
				if (!_tmp2_) {
					gint _tmp3_;
					_tmp3_ = i;
					i = _tmp3_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp4_ = i;
				_tmp5_ = templates;
				_tmp6_ = g_ptr_array_get_length (_tmp5_);
				_tmp7_ = _tmp6_;
				if (!(_tmp4_ < _tmp7_)) {
					break;
				}
				_tmp8_ = templates;
				_tmp9_ = i;
				_tmp10_ = g_ptr_array_index (_tmp8_, (guint) _tmp9_);
				_tmp11_ = _g_object_ref0 ((ZeitgeistEvent*) _tmp10_);
				event_template = _tmp11_;
				_tmp12_ = event_template;
				_tmp13_ = zeitgeist_engine_get_where_clause_from_event_template (self, _tmp12_, &_inner_error_);
				_tmp14_ = _tmp13_;
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
						g_propagate_error (error, _inner_error_);
						_g_object_unref0 (event_template);
						_g_object_unref0 (where);
						return NULL;
					} else {
						_g_object_unref0 (event_template);
						_g_object_unref0 (where);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
				}
				_tmp15_ = where;
				_tmp16_ = _tmp14_;
				zeitgeist_where_clause_extend (_tmp15_, _tmp16_);
				_g_object_unref0 (_tmp16_);
				_g_object_unref0 (event_template);
			}
		}
	}
	result = where;
	return result;
}


static ZeitgeistWhereClause* zeitgeist_engine_get_where_clause_from_event_template (ZeitgeistEngine* self, ZeitgeistEvent* template, GError** error) {
	ZeitgeistWhereClause* result = NULL;
	ZeitgeistWhereClause* _tmp0_;
	ZeitgeistWhereClause* where;
	ZeitgeistEvent* _tmp1_;
	guint32 _tmp2_;
	guint32 _tmp3_;
	ZeitgeistEvent* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	ZeitgeistEvent* _tmp25_;
	const gchar* _tmp26_;
	const gchar* _tmp27_;
	ZeitgeistEvent* _tmp40_;
	const gchar* _tmp41_;
	const gchar* _tmp42_;
	ZeitgeistEvent* _tmp58_;
	const gchar* _tmp59_;
	const gchar* _tmp60_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (template != NULL, NULL);
	_tmp0_ = zeitgeist_where_clause_new (ZEITGEIST_WHERE_CLAUSE_TYPE_AND, FALSE);
	where = _tmp0_;
	_tmp1_ = template;
	_tmp2_ = zeitgeist_event_get_id (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ != ((guint32) 0)) {
		ZeitgeistWhereClause* _tmp4_;
		ZeitgeistEvent* _tmp5_;
		guint32 _tmp6_;
		guint32 _tmp7_;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_;
		_tmp4_ = where;
		_tmp5_ = template;
		_tmp6_ = zeitgeist_event_get_id (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = g_strdup_printf ("%u", _tmp7_);
		_tmp9_ = _tmp8_;
		zeitgeist_where_clause_add (_tmp4_, "id=?", _tmp9_);
		_g_free0 (_tmp9_);
	}
	_tmp10_ = template;
	_tmp11_ = zeitgeist_event_get_interpretation (_tmp10_);
	_tmp12_ = _tmp11_;
	if (g_strcmp0 (_tmp12_, "") != 0) {
		ZeitgeistEvent* _tmp13_;
		const gchar* _tmp14_;
		const gchar* _tmp15_;
		ZeitgeistEvent* _tmp16_;
		const gchar* _tmp17_;
		const gchar* _tmp18_;
		ZeitgeistSQLiteTableLookup* _tmp19_;
		ZeitgeistWhereClause* _tmp20_ = NULL;
		ZeitgeistWhereClause* subwhere;
		ZeitgeistWhereClause* _tmp21_;
		gboolean _tmp22_ = FALSE;
		_tmp13_ = template;
		_tmp14_ = zeitgeist_event_get_interpretation (_tmp13_);
		_tmp15_ = _tmp14_;
		zeitgeist_engine_assert_no_wildcard (self, "interpretation", _tmp15_, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (where);
				return NULL;
			} else {
				_g_object_unref0 (where);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		_tmp16_ = template;
		_tmp17_ = zeitgeist_event_get_interpretation (_tmp16_);
		_tmp18_ = _tmp17_;
		_tmp19_ = self->interpretations_table;
		_tmp20_ = zeitgeist_engine_get_where_clause_for_symbol (self, "interpretation", _tmp18_, _tmp19_, &_inner_error_);
		subwhere = _tmp20_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (where);
				return NULL;
			} else {
				_g_object_unref0 (where);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		_tmp21_ = subwhere;
		_tmp22_ = zeitgeist_where_clause_is_empty (_tmp21_);
		if (!_tmp22_) {
			ZeitgeistWhereClause* _tmp23_;
			ZeitgeistWhereClause* _tmp24_;
			_tmp23_ = where;
			_tmp24_ = subwhere;
			zeitgeist_where_clause_extend (_tmp23_, _tmp24_);
		}
		_g_object_unref0 (subwhere);
	}
	_tmp25_ = template;
	_tmp26_ = zeitgeist_event_get_manifestation (_tmp25_);
	_tmp27_ = _tmp26_;
	if (g_strcmp0 (_tmp27_, "") != 0) {
		ZeitgeistEvent* _tmp28_;
		const gchar* _tmp29_;
		const gchar* _tmp30_;
		ZeitgeistEvent* _tmp31_;
		const gchar* _tmp32_;
		const gchar* _tmp33_;
		ZeitgeistSQLiteTableLookup* _tmp34_;
		ZeitgeistWhereClause* _tmp35_ = NULL;
		ZeitgeistWhereClause* subwhere;
		ZeitgeistWhereClause* _tmp36_;
		gboolean _tmp37_ = FALSE;
		_tmp28_ = template;
		_tmp29_ = zeitgeist_event_get_interpretation (_tmp28_);
		_tmp30_ = _tmp29_;
		zeitgeist_engine_assert_no_wildcard (self, "manifestation", _tmp30_, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (where);
				return NULL;
			} else {
				_g_object_unref0 (where);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		_tmp31_ = template;
		_tmp32_ = zeitgeist_event_get_manifestation (_tmp31_);
		_tmp33_ = _tmp32_;
		_tmp34_ = self->manifestations_table;
		_tmp35_ = zeitgeist_engine_get_where_clause_for_symbol (self, "manifestation", _tmp33_, _tmp34_, &_inner_error_);
		subwhere = _tmp35_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (where);
				return NULL;
			} else {
				_g_object_unref0 (where);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		_tmp36_ = subwhere;
		_tmp37_ = zeitgeist_where_clause_is_empty (_tmp36_);
		if (!_tmp37_) {
			ZeitgeistWhereClause* _tmp38_;
			ZeitgeistWhereClause* _tmp39_;
			_tmp38_ = where;
			_tmp39_ = subwhere;
			zeitgeist_where_clause_extend (_tmp38_, _tmp39_);
		}
		_g_object_unref0 (subwhere);
	}
	_tmp40_ = template;
	_tmp41_ = zeitgeist_event_get_actor (_tmp40_);
	_tmp42_ = _tmp41_;
	if (g_strcmp0 (_tmp42_, "") != 0) {
		ZeitgeistEvent* _tmp43_;
		const gchar* _tmp44_;
		const gchar* _tmp45_;
		gchar* _tmp46_;
		gchar* val;
		gboolean _tmp47_ = FALSE;
		gboolean like;
		gboolean _tmp48_ = FALSE;
		gboolean negated;
		gboolean _tmp49_;
		_tmp43_ = template;
		_tmp44_ = zeitgeist_event_get_actor (_tmp43_);
		_tmp45_ = _tmp44_;
		_tmp46_ = g_strdup (_tmp45_);
		val = _tmp46_;
		_tmp47_ = zeitgeist_engine_parse_wildcard (&val);
		like = _tmp47_;
		_tmp48_ = zeitgeist_engine_parse_negation (&val);
		negated = _tmp48_;
		_tmp49_ = like;
		if (_tmp49_) {
			ZeitgeistWhereClause* _tmp50_;
			const gchar* _tmp51_;
			gboolean _tmp52_;
			_tmp50_ = where;
			_tmp51_ = val;
			_tmp52_ = negated;
			zeitgeist_where_clause_add_wildcard_condition (_tmp50_, "actor", _tmp51_, _tmp52_);
		} else {
			ZeitgeistWhereClause* _tmp53_;
			ZeitgeistSQLiteTableLookup* _tmp54_;
			const gchar* _tmp55_;
			gint _tmp56_ = 0;
			gboolean _tmp57_;
			_tmp53_ = where;
			_tmp54_ = self->actors_table;
			_tmp55_ = val;
			_tmp56_ = zeitgeist_sq_lite_table_lookup_get_id (_tmp54_, _tmp55_);
			_tmp57_ = negated;
			zeitgeist_where_clause_add_match_condition (_tmp53_, "actor", _tmp56_, _tmp57_);
		}
		_g_free0 (val);
	}
	_tmp58_ = template;
	_tmp59_ = zeitgeist_event_get_origin (_tmp58_);
	_tmp60_ = _tmp59_;
	if (g_strcmp0 (_tmp60_, "") != 0) {
		ZeitgeistEvent* _tmp61_;
		const gchar* _tmp62_;
		const gchar* _tmp63_;
		gchar* _tmp64_;
		gchar* val;
		gboolean _tmp65_ = FALSE;
		gboolean like;
		gboolean _tmp66_ = FALSE;
		gboolean negated;
		gboolean _tmp67_;
		_tmp61_ = template;
		_tmp62_ = zeitgeist_event_get_origin (_tmp61_);
		_tmp63_ = _tmp62_;
		_tmp64_ = g_strdup (_tmp63_);
		val = _tmp64_;
		_tmp65_ = zeitgeist_engine_parse_wildcard (&val);
		like = _tmp65_;
		_tmp66_ = zeitgeist_engine_parse_negation (&val);
		negated = _tmp66_;
		_tmp67_ = like;
		if (_tmp67_) {
			ZeitgeistWhereClause* _tmp68_;
			const gchar* _tmp69_;
			gboolean _tmp70_;
			_tmp68_ = where;
			_tmp69_ = val;
			_tmp70_ = negated;
			zeitgeist_where_clause_add_wildcard_condition (_tmp68_, "origin", _tmp69_, _tmp70_);
		} else {
			ZeitgeistWhereClause* _tmp71_;
			const gchar* _tmp72_;
			gboolean _tmp73_;
			_tmp71_ = where;
			_tmp72_ = val;
			_tmp73_ = negated;
			zeitgeist_where_clause_add_text_condition_subquery (_tmp71_, "origin", _tmp72_, _tmp73_);
		}
		_g_free0 (val);
	}
	{
		gint i;
		i = 0;
		{
			gboolean _tmp74_;
			_tmp74_ = TRUE;
			while (TRUE) {
				gboolean _tmp75_;
				gint _tmp77_;
				ZeitgeistEvent* _tmp78_;
				gint _tmp79_ = 0;
				ZeitgeistEvent* _tmp80_;
				GPtrArray* _tmp81_;
				GPtrArray* _tmp82_;
				gint _tmp83_;
				gconstpointer _tmp84_ = NULL;
				ZeitgeistSubject* _tmp85_;
				ZeitgeistSubject* subject_template;
				ZeitgeistSubject* _tmp86_;
				const gchar* _tmp87_;
				const gchar* _tmp88_;
				ZeitgeistSubject* _tmp101_;
				const gchar* _tmp102_;
				const gchar* _tmp103_;
				ZeitgeistSubject* _tmp116_;
				const gchar* _tmp117_;
				const gchar* _tmp118_;
				ZeitgeistSubject* _tmp134_;
				const gchar* _tmp135_;
				const gchar* _tmp136_;
				ZeitgeistSubject* _tmp150_;
				const gchar* _tmp151_;
				const gchar* _tmp152_;
				ZeitgeistSubject* _tmp166_;
				const gchar* _tmp167_;
				const gchar* _tmp168_;
				ZeitgeistSubject* _tmp173_;
				const gchar* _tmp174_;
				const gchar* _tmp175_;
				ZeitgeistSubject* _tmp189_;
				const gchar* _tmp190_;
				const gchar* _tmp191_;
				_tmp75_ = _tmp74_;
				if (!_tmp75_) {
					gint _tmp76_;
					_tmp76_ = i;
					i = _tmp76_ + 1;
				}
				_tmp74_ = FALSE;
				_tmp77_ = i;
				_tmp78_ = template;
				_tmp79_ = zeitgeist_event_num_subjects (_tmp78_);
				if (!(_tmp77_ < _tmp79_)) {
					break;
				}
				_tmp80_ = template;
				_tmp81_ = zeitgeist_event_get_subjects (_tmp80_);
				_tmp82_ = _tmp81_;
				_tmp83_ = i;
				_tmp84_ = g_ptr_array_index (_tmp82_, (guint) _tmp83_);
				_tmp85_ = _g_object_ref0 ((ZeitgeistSubject*) _tmp84_);
				subject_template = _tmp85_;
				_tmp86_ = subject_template;
				_tmp87_ = zeitgeist_subject_get_interpretation (_tmp86_);
				_tmp88_ = _tmp87_;
				if (g_strcmp0 (_tmp88_, "") != 0) {
					ZeitgeistEvent* _tmp89_;
					const gchar* _tmp90_;
					const gchar* _tmp91_;
					ZeitgeistSubject* _tmp92_;
					const gchar* _tmp93_;
					const gchar* _tmp94_;
					ZeitgeistSQLiteTableLookup* _tmp95_;
					ZeitgeistWhereClause* _tmp96_ = NULL;
					ZeitgeistWhereClause* subwhere;
					ZeitgeistWhereClause* _tmp97_;
					gboolean _tmp98_ = FALSE;
					_tmp89_ = template;
					_tmp90_ = zeitgeist_event_get_interpretation (_tmp89_);
					_tmp91_ = _tmp90_;
					zeitgeist_engine_assert_no_wildcard (self, "subject interpretation", _tmp91_, &_inner_error_);
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
							g_propagate_error (error, _inner_error_);
							_g_object_unref0 (subject_template);
							_g_object_unref0 (where);
							return NULL;
						} else {
							_g_object_unref0 (subject_template);
							_g_object_unref0 (where);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return NULL;
						}
					}
					_tmp92_ = subject_template;
					_tmp93_ = zeitgeist_subject_get_interpretation (_tmp92_);
					_tmp94_ = _tmp93_;
					_tmp95_ = self->interpretations_table;
					_tmp96_ = zeitgeist_engine_get_where_clause_for_symbol (self, "subj_interpretation", _tmp94_, _tmp95_, &_inner_error_);
					subwhere = _tmp96_;
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
							g_propagate_error (error, _inner_error_);
							_g_object_unref0 (subject_template);
							_g_object_unref0 (where);
							return NULL;
						} else {
							_g_object_unref0 (subject_template);
							_g_object_unref0 (where);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return NULL;
						}
					}
					_tmp97_ = subwhere;
					_tmp98_ = zeitgeist_where_clause_is_empty (_tmp97_);
					if (!_tmp98_) {
						ZeitgeistWhereClause* _tmp99_;
						ZeitgeistWhereClause* _tmp100_;
						_tmp99_ = where;
						_tmp100_ = subwhere;
						zeitgeist_where_clause_extend (_tmp99_, _tmp100_);
					}
					_g_object_unref0 (subwhere);
				}
				_tmp101_ = subject_template;
				_tmp102_ = zeitgeist_subject_get_manifestation (_tmp101_);
				_tmp103_ = _tmp102_;
				if (g_strcmp0 (_tmp103_, "") != 0) {
					ZeitgeistSubject* _tmp104_;
					const gchar* _tmp105_;
					const gchar* _tmp106_;
					ZeitgeistSubject* _tmp107_;
					const gchar* _tmp108_;
					const gchar* _tmp109_;
					ZeitgeistSQLiteTableLookup* _tmp110_;
					ZeitgeistWhereClause* _tmp111_ = NULL;
					ZeitgeistWhereClause* subwhere;
					ZeitgeistWhereClause* _tmp112_;
					gboolean _tmp113_ = FALSE;
					_tmp104_ = subject_template;
					_tmp105_ = zeitgeist_subject_get_manifestation (_tmp104_);
					_tmp106_ = _tmp105_;
					zeitgeist_engine_assert_no_wildcard (self, "subject manifestation", _tmp106_, &_inner_error_);
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
							g_propagate_error (error, _inner_error_);
							_g_object_unref0 (subject_template);
							_g_object_unref0 (where);
							return NULL;
						} else {
							_g_object_unref0 (subject_template);
							_g_object_unref0 (where);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return NULL;
						}
					}
					_tmp107_ = subject_template;
					_tmp108_ = zeitgeist_subject_get_manifestation (_tmp107_);
					_tmp109_ = _tmp108_;
					_tmp110_ = self->manifestations_table;
					_tmp111_ = zeitgeist_engine_get_where_clause_for_symbol (self, "subj_manifestation", _tmp109_, _tmp110_, &_inner_error_);
					subwhere = _tmp111_;
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
							g_propagate_error (error, _inner_error_);
							_g_object_unref0 (subject_template);
							_g_object_unref0 (where);
							return NULL;
						} else {
							_g_object_unref0 (subject_template);
							_g_object_unref0 (where);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return NULL;
						}
					}
					_tmp112_ = subwhere;
					_tmp113_ = zeitgeist_where_clause_is_empty (_tmp112_);
					if (!_tmp113_) {
						ZeitgeistWhereClause* _tmp114_;
						ZeitgeistWhereClause* _tmp115_;
						_tmp114_ = where;
						_tmp115_ = subwhere;
						zeitgeist_where_clause_extend (_tmp114_, _tmp115_);
					}
					_g_object_unref0 (subwhere);
				}
				_tmp116_ = subject_template;
				_tmp117_ = zeitgeist_subject_get_mimetype (_tmp116_);
				_tmp118_ = _tmp117_;
				if (g_strcmp0 (_tmp118_, "") != 0) {
					ZeitgeistSubject* _tmp119_;
					const gchar* _tmp120_;
					const gchar* _tmp121_;
					gchar* _tmp122_;
					gchar* val;
					gboolean _tmp123_ = FALSE;
					gboolean like;
					gboolean _tmp124_ = FALSE;
					gboolean negated;
					gboolean _tmp125_;
					_tmp119_ = subject_template;
					_tmp120_ = zeitgeist_subject_get_mimetype (_tmp119_);
					_tmp121_ = _tmp120_;
					_tmp122_ = g_strdup (_tmp121_);
					val = _tmp122_;
					_tmp123_ = zeitgeist_engine_parse_wildcard (&val);
					like = _tmp123_;
					_tmp124_ = zeitgeist_engine_parse_negation (&val);
					negated = _tmp124_;
					_tmp125_ = like;
					if (_tmp125_) {
						ZeitgeistWhereClause* _tmp126_;
						const gchar* _tmp127_;
						gboolean _tmp128_;
						_tmp126_ = where;
						_tmp127_ = val;
						_tmp128_ = negated;
						zeitgeist_where_clause_add_wildcard_condition (_tmp126_, "subj_mimetype", _tmp127_, _tmp128_);
					} else {
						ZeitgeistWhereClause* _tmp129_;
						ZeitgeistSQLiteTableLookup* _tmp130_;
						const gchar* _tmp131_;
						gint _tmp132_ = 0;
						gboolean _tmp133_;
						_tmp129_ = where;
						_tmp130_ = self->mimetypes_table;
						_tmp131_ = val;
						_tmp132_ = zeitgeist_sq_lite_table_lookup_get_id (_tmp130_, _tmp131_);
						_tmp133_ = negated;
						zeitgeist_where_clause_add_match_condition (_tmp129_, "subj_mimetype", _tmp132_, _tmp133_);
					}
					_g_free0 (val);
				}
				_tmp134_ = subject_template;
				_tmp135_ = zeitgeist_subject_get_uri (_tmp134_);
				_tmp136_ = _tmp135_;
				if (g_strcmp0 (_tmp136_, "") != 0) {
					ZeitgeistSubject* _tmp137_;
					const gchar* _tmp138_;
					const gchar* _tmp139_;
					gchar* _tmp140_;
					gchar* val;
					gboolean _tmp141_ = FALSE;
					gboolean like;
					gboolean _tmp142_ = FALSE;
					gboolean negated;
					gboolean _tmp143_;
					_tmp137_ = subject_template;
					_tmp138_ = zeitgeist_subject_get_uri (_tmp137_);
					_tmp139_ = _tmp138_;
					_tmp140_ = g_strdup (_tmp139_);
					val = _tmp140_;
					_tmp141_ = zeitgeist_engine_parse_wildcard (&val);
					like = _tmp141_;
					_tmp142_ = zeitgeist_engine_parse_negation (&val);
					negated = _tmp142_;
					_tmp143_ = like;
					if (_tmp143_) {
						ZeitgeistWhereClause* _tmp144_;
						const gchar* _tmp145_;
						gboolean _tmp146_;
						_tmp144_ = where;
						_tmp145_ = val;
						_tmp146_ = negated;
						zeitgeist_where_clause_add_wildcard_condition (_tmp144_, "subj_id", _tmp145_, _tmp146_);
					} else {
						ZeitgeistWhereClause* _tmp147_;
						const gchar* _tmp148_;
						gboolean _tmp149_;
						_tmp147_ = where;
						_tmp148_ = val;
						_tmp149_ = negated;
						zeitgeist_where_clause_add_text_condition_subquery (_tmp147_, "subj_id", _tmp148_, _tmp149_);
					}
					_g_free0 (val);
				}
				_tmp150_ = subject_template;
				_tmp151_ = zeitgeist_subject_get_origin (_tmp150_);
				_tmp152_ = _tmp151_;
				if (g_strcmp0 (_tmp152_, "") != 0) {
					ZeitgeistSubject* _tmp153_;
					const gchar* _tmp154_;
					const gchar* _tmp155_;
					gchar* _tmp156_;
					gchar* val;
					gboolean _tmp157_ = FALSE;
					gboolean like;
					gboolean _tmp158_ = FALSE;
					gboolean negated;
					gboolean _tmp159_;
					_tmp153_ = subject_template;
					_tmp154_ = zeitgeist_subject_get_origin (_tmp153_);
					_tmp155_ = _tmp154_;
					_tmp156_ = g_strdup (_tmp155_);
					val = _tmp156_;
					_tmp157_ = zeitgeist_engine_parse_wildcard (&val);
					like = _tmp157_;
					_tmp158_ = zeitgeist_engine_parse_negation (&val);
					negated = _tmp158_;
					_tmp159_ = like;
					if (_tmp159_) {
						ZeitgeistWhereClause* _tmp160_;
						const gchar* _tmp161_;
						gboolean _tmp162_;
						_tmp160_ = where;
						_tmp161_ = val;
						_tmp162_ = negated;
						zeitgeist_where_clause_add_wildcard_condition (_tmp160_, "subj_origin", _tmp161_, _tmp162_);
					} else {
						ZeitgeistWhereClause* _tmp163_;
						const gchar* _tmp164_;
						gboolean _tmp165_;
						_tmp163_ = where;
						_tmp164_ = val;
						_tmp165_ = negated;
						zeitgeist_where_clause_add_text_condition_subquery (_tmp163_, "subj_origin", _tmp164_, _tmp165_);
					}
					_g_free0 (val);
				}
				_tmp166_ = subject_template;
				_tmp167_ = zeitgeist_subject_get_text (_tmp166_);
				_tmp168_ = _tmp167_;
				if (g_strcmp0 (_tmp168_, "") != 0) {
					ZeitgeistWhereClause* _tmp169_;
					ZeitgeistSubject* _tmp170_;
					const gchar* _tmp171_;
					const gchar* _tmp172_;
					_tmp169_ = where;
					_tmp170_ = subject_template;
					_tmp171_ = zeitgeist_subject_get_text (_tmp170_);
					_tmp172_ = _tmp171_;
					zeitgeist_where_clause_add_text_condition_subquery (_tmp169_, "subj_text_id", _tmp172_, FALSE);
				}
				_tmp173_ = subject_template;
				_tmp174_ = zeitgeist_subject_get_current_uri (_tmp173_);
				_tmp175_ = _tmp174_;
				if (g_strcmp0 (_tmp175_, "") != 0) {
					ZeitgeistSubject* _tmp176_;
					const gchar* _tmp177_;
					const gchar* _tmp178_;
					gchar* _tmp179_;
					gchar* val;
					gboolean _tmp180_ = FALSE;
					gboolean like;
					gboolean _tmp181_ = FALSE;
					gboolean negated;
					gboolean _tmp182_;
					_tmp176_ = subject_template;
					_tmp177_ = zeitgeist_subject_get_current_uri (_tmp176_);
					_tmp178_ = _tmp177_;
					_tmp179_ = g_strdup (_tmp178_);
					val = _tmp179_;
					_tmp180_ = zeitgeist_engine_parse_wildcard (&val);
					like = _tmp180_;
					_tmp181_ = zeitgeist_engine_parse_negation (&val);
					negated = _tmp181_;
					_tmp182_ = like;
					if (_tmp182_) {
						ZeitgeistWhereClause* _tmp183_;
						const gchar* _tmp184_;
						gboolean _tmp185_;
						_tmp183_ = where;
						_tmp184_ = val;
						_tmp185_ = negated;
						zeitgeist_where_clause_add_wildcard_condition (_tmp183_, "subj_id_current", _tmp184_, _tmp185_);
					} else {
						ZeitgeistWhereClause* _tmp186_;
						const gchar* _tmp187_;
						gboolean _tmp188_;
						_tmp186_ = where;
						_tmp187_ = val;
						_tmp188_ = negated;
						zeitgeist_where_clause_add_text_condition_subquery (_tmp186_, "subj_id_current", _tmp187_, _tmp188_);
					}
					_g_free0 (val);
				}
				_tmp189_ = subject_template;
				_tmp190_ = zeitgeist_subject_get_storage (_tmp189_);
				_tmp191_ = _tmp190_;
				if (g_strcmp0 (_tmp191_, "") != 0) {
					ZeitgeistSubject* _tmp192_;
					const gchar* _tmp193_;
					const gchar* _tmp194_;
					gchar* _tmp195_;
					gchar* val;
					const gchar* _tmp196_;
					const gchar* _tmp197_;
					ZeitgeistWhereClause* _tmp198_;
					const gchar* _tmp199_;
					_tmp192_ = subject_template;
					_tmp193_ = zeitgeist_subject_get_storage (_tmp192_);
					_tmp194_ = _tmp193_;
					_tmp195_ = g_strdup (_tmp194_);
					val = _tmp195_;
					_tmp196_ = val;
					zeitgeist_engine_assert_no_negation (self, "subject storage", _tmp196_, &_inner_error_);
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
							g_propagate_error (error, _inner_error_);
							_g_free0 (val);
							_g_object_unref0 (subject_template);
							_g_object_unref0 (where);
							return NULL;
						} else {
							_g_free0 (val);
							_g_object_unref0 (subject_template);
							_g_object_unref0 (where);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return NULL;
						}
					}
					_tmp197_ = val;
					zeitgeist_engine_assert_no_wildcard (self, "subject storage", _tmp197_, &_inner_error_);
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
							g_propagate_error (error, _inner_error_);
							_g_free0 (val);
							_g_object_unref0 (subject_template);
							_g_object_unref0 (where);
							return NULL;
						} else {
							_g_free0 (val);
							_g_object_unref0 (subject_template);
							_g_object_unref0 (where);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return NULL;
						}
					}
					_tmp198_ = where;
					_tmp199_ = val;
					zeitgeist_where_clause_add_text_condition_subquery (_tmp198_, "subj_storage_id", _tmp199_, FALSE);
					_g_free0 (val);
				}
				_g_object_unref0 (subject_template);
			}
		}
	}
	result = where;
	return result;
}


/**
     * Check if the value starts with the negation operator. If it does,
     * remove the operator from the value and return true. Otherwise,
     * return false.
     */
static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* _tmp0_;
	glong _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* end;
	gchar* _tmp3_;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_;
	gboolean _tmp3_;
	glong _tmp9_;
	glong _tmp15_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	glong _tmp22_;
	gchar* _tmp23_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	_tmp3_ = _tmp0_;
	if (_tmp3_) {
		glong _tmp4_;
		glong _tmp5_;
		glong _tmp6_ = 0L;
		_tmp4_ = offset;
		_tmp5_ = len;
		_tmp6_ = string_strnlen ((gchar*) self, _tmp4_ + _tmp5_);
		string_length = _tmp6_;
	} else {
		gint _tmp7_;
		gint _tmp8_;
		_tmp7_ = strlen (self);
		_tmp8_ = _tmp7_;
		string_length = (glong) _tmp8_;
	}
	_tmp9_ = offset;
	if (_tmp9_ < ((glong) 0)) {
		glong _tmp10_;
		glong _tmp11_;
		glong _tmp12_;
		_tmp10_ = string_length;
		_tmp11_ = offset;
		offset = _tmp10_ + _tmp11_;
		_tmp12_ = offset;
		g_return_val_if_fail (_tmp12_ >= ((glong) 0), NULL);
	} else {
		glong _tmp13_;
		glong _tmp14_;
		_tmp13_ = offset;
		_tmp14_ = string_length;
		g_return_val_if_fail (_tmp13_ <= _tmp14_, NULL);
	}
	_tmp15_ = len;
	if (_tmp15_ < ((glong) 0)) {
		glong _tmp16_;
		glong _tmp17_;
		_tmp16_ = string_length;
		_tmp17_ = offset;
		len = _tmp16_ - _tmp17_;
	}
	_tmp18_ = offset;
	_tmp19_ = len;
	_tmp20_ = string_length;
	g_return_val_if_fail ((_tmp18_ + _tmp19_) <= _tmp20_, NULL);
	_tmp21_ = offset;
	_tmp22_ = len;
	_tmp23_ = g_strndup (((gchar*) self) + _tmp21_, (gsize) _tmp22_);
	result = _tmp23_;
	return result;
}


gboolean zeitgeist_engine_parse_negation (gchar** val) {
	gboolean result = FALSE;
	const gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp2_;
	gchar* _tmp3_ = NULL;
	g_return_val_if_fail (val != NULL, FALSE);
	_tmp0_ = *val;
	_tmp1_ = g_str_has_prefix (_tmp0_, "!");
	if (!_tmp1_) {
		result = FALSE;
		return result;
	}
	_tmp2_ = *val;
	_tmp3_ = string_substring (_tmp2_, (glong) 1, (glong) (-1));
	_g_free0 (*val);
	*val = _tmp3_;
	result = TRUE;
	return result;
}


/**
     * If the value starts with the negation operator, throw an
     * error.
     */
void zeitgeist_engine_assert_no_negation (ZeitgeistEngine* self, const gchar* field, const gchar* val, GError** error) {
	const gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* error_message;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	GError* _tmp6_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (field != NULL);
	g_return_if_fail (val != NULL);
	_tmp0_ = val;
	_tmp1_ = g_str_has_prefix (_tmp0_, "!");
	if (!_tmp1_) {
		return;
	}
	_tmp2_ = field;
	_tmp3_ = g_strdup_printf ("Field '%s' doesn't support negation", _tmp2_);
	error_message = _tmp3_;
	_tmp4_ = error_message;
	g_warning ("engine.vala:1008: %s", _tmp4_);
	_tmp5_ = error_message;
	_tmp6_ = g_error_new_literal (ZEITGEIST_ENGINE_ERROR, ZEITGEIST_ENGINE_ERROR_INVALID_ARGUMENT, _tmp5_);
	_inner_error_ = _tmp6_;
	if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (error_message);
		return;
	} else {
		_g_free0 (error_message);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_free0 (error_message);
}


/**
     * Check if the value ends with the wildcard character. If it does,
     * remove the wildcard character from the value and return true.
     * Otherwise, return false.
     */
static guint8* string_get_data (const gchar* self, int* result_length1) {
	guint8* result;
	guint8* res;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	guint8* _tmp3_;
	gint _tmp3__length1;
	guint8* _tmp4_;
	gint _tmp4__length1;
	g_return_val_if_fail (self != NULL, NULL);
	res = (guint8*) self;
	res_length1 = -1;
	_res_size_ = res_length1;
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	res_length1 = (gint) _tmp1_;
	_tmp2_ = res_length1;
	_tmp3_ = res;
	_tmp3__length1 = res_length1;
	_tmp4_ = _tmp3_;
	_tmp4__length1 = _tmp3__length1;
	if (result_length1) {
		*result_length1 = _tmp4__length1;
	}
	result = _tmp4_;
	return result;
}


gboolean zeitgeist_engine_parse_wildcard (gchar** val) {
	gboolean result = FALSE;
	const gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp2_;
	guint8* _tmp3_;
	gint _tmp3__length1;
	guint8* _tmp4_;
	gint _tmp4__length1;
	guint8* val_data;
	gint val_data_length1;
	gint _val_data_size_;
	guint8* _tmp5_;
	gint _tmp5__length1;
	guint8* _tmp6_;
	gint _tmp6__length1;
	guint8 _tmp7_;
	g_return_val_if_fail (val != NULL, FALSE);
	_tmp0_ = *val;
	_tmp1_ = g_str_has_suffix (_tmp0_, "*");
	if (!_tmp1_) {
		result = FALSE;
		return result;
	}
	_tmp2_ = *val;
	_tmp3_ = string_get_data (_tmp2_, &_tmp3__length1);
	_tmp4_ = _tmp3_;
	_tmp4__length1 = _tmp3__length1;
	val_data = _tmp4_;
	val_data_length1 = _tmp4__length1;
	_val_data_size_ = val_data_length1;
	_tmp5_ = val_data;
	_tmp5__length1 = val_data_length1;
	_tmp6_ = val_data;
	_tmp6__length1 = val_data_length1;
	_tmp5_[_tmp6__length1 - 1] = (guint8) '\0';
	_tmp7_ = _tmp5_[_tmp6__length1 - 1];
	result = TRUE;
	return result;
}


/**
     * If the value ends with the wildcard character, throw an error.
     */
void zeitgeist_engine_assert_no_wildcard (ZeitgeistEngine* self, const gchar* field, const gchar* val, GError** error) {
	const gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* error_message;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	GError* _tmp6_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (field != NULL);
	g_return_if_fail (val != NULL);
	_tmp0_ = val;
	_tmp1_ = g_str_has_suffix (_tmp0_, "*");
	if (!_tmp1_) {
		return;
	}
	_tmp2_ = field;
	_tmp3_ = g_strdup_printf ("Field '%s' doesn't support prefix search", _tmp2_);
	error_message = _tmp3_;
	_tmp4_ = error_message;
	g_warning ("engine.vala:1038: %s", _tmp4_);
	_tmp5_ = error_message;
	_tmp6_ = g_error_new_literal (ZEITGEIST_ENGINE_ERROR, ZEITGEIST_ENGINE_ERROR_INVALID_ARGUMENT, _tmp5_);
	_inner_error_ = _tmp6_;
	if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (error_message);
		return;
	} else {
		_g_free0 (error_message);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_free0 (error_message);
}


ZeitgeistWhereClause* zeitgeist_engine_get_where_clause_for_symbol (ZeitgeistEngine* self, const gchar* table_name, const gchar* symbol, ZeitgeistSQLiteTableLookup* lookup_table, GError** error) {
	ZeitgeistWhereClause* result = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _symbol;
	gboolean _tmp2_ = FALSE;
	gboolean negated;
	const gchar* _tmp3_;
	GList* _tmp4_ = NULL;
	GList* symbols;
	const gchar* _tmp5_;
	gboolean _tmp6_;
	ZeitgeistWhereClause* _tmp7_;
	ZeitgeistWhereClause* subwhere;
	GList* _tmp8_;
	guint _tmp9_ = 0U;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (table_name != NULL, NULL);
	g_return_val_if_fail (symbol != NULL, NULL);
	g_return_val_if_fail (lookup_table != NULL, NULL);
	_tmp0_ = symbol;
	_tmp1_ = g_strdup (_tmp0_);
	_symbol = _tmp1_;
	_tmp2_ = zeitgeist_engine_parse_negation (&_symbol);
	negated = _tmp2_;
	_tmp3_ = _symbol;
	_tmp4_ = zeitgeist_symbol_get_all_children (_tmp3_);
	symbols = _tmp4_;
	_tmp5_ = _symbol;
	symbols = g_list_prepend (symbols, _tmp5_);
	_tmp6_ = negated;
	_tmp7_ = zeitgeist_where_clause_new (ZEITGEIST_WHERE_CLAUSE_TYPE_OR, _tmp6_);
	subwhere = _tmp7_;
	_tmp8_ = symbols;
	_tmp9_ = g_list_length (_tmp8_);
	if (_tmp9_ == ((guint) 1)) {
		ZeitgeistWhereClause* _tmp10_;
		const gchar* _tmp11_;
		ZeitgeistSQLiteTableLookup* _tmp12_;
		const gchar* _tmp13_;
		gint _tmp14_ = 0;
		_tmp10_ = subwhere;
		_tmp11_ = table_name;
		_tmp12_ = lookup_table;
		_tmp13_ = _symbol;
		_tmp14_ = zeitgeist_sq_lite_table_lookup_get_id (_tmp12_, _tmp13_);
		zeitgeist_where_clause_add_match_condition (_tmp10_, _tmp11_, _tmp14_, FALSE);
	} else {
		GString* _tmp15_;
		GString* sb;
		GList* _tmp16_;
		GString* _tmp22_;
		GString* _tmp23_;
		gssize _tmp24_;
		const gchar* _tmp25_;
		GString* _tmp26_;
		const gchar* _tmp27_;
		gchar* _tmp28_ = NULL;
		gchar* sql;
		ZeitgeistWhereClause* _tmp29_;
		const gchar* _tmp30_;
		_tmp15_ = g_string_new ("");
		sb = _tmp15_;
		_tmp16_ = symbols;
		{
			GList* uri_collection = NULL;
			GList* uri_it = NULL;
			uri_collection = _tmp16_;
			for (uri_it = uri_collection; uri_it != NULL; uri_it = uri_it->next) {
				gchar* _tmp17_;
				gchar* uri = NULL;
				_tmp17_ = g_strdup ((const gchar*) uri_it->data);
				uri = _tmp17_;
				{
					GString* _tmp18_;
					ZeitgeistSQLiteTableLookup* _tmp19_;
					const gchar* _tmp20_;
					gint _tmp21_ = 0;
					_tmp18_ = sb;
					_tmp19_ = lookup_table;
					_tmp20_ = uri;
					_tmp21_ = zeitgeist_sq_lite_table_lookup_get_id (_tmp19_, _tmp20_);
					g_string_append_printf (_tmp18_, "%d,", _tmp21_);
					_g_free0 (uri);
				}
			}
		}
		_tmp22_ = sb;
		_tmp23_ = sb;
		_tmp24_ = _tmp23_->len;
		g_string_truncate (_tmp22_, (gsize) (_tmp24_ - 1));
		_tmp25_ = table_name;
		_tmp26_ = sb;
		_tmp27_ = _tmp26_->str;
		_tmp28_ = g_strdup_printf ("%s IN (%s)", _tmp25_, _tmp27_);
		sql = _tmp28_;
		_tmp29_ = subwhere;
		_tmp30_ = sql;
		zeitgeist_where_clause_add (_tmp29_, _tmp30_, NULL);
		_g_free0 (sql);
		_g_string_free0 (sb);
	}
	result = subwhere;
	_g_list_free0 (symbols);
	_g_free0 (_symbol);
	return result;
}


static void zeitgeist_engine_handle_move_event (ZeitgeistEngine* self, ZeitgeistEvent* event) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (event != NULL);
	{
		gint i;
		i = 0;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				gboolean _tmp1_;
				gint _tmp3_;
				ZeitgeistEvent* _tmp4_;
				GPtrArray* _tmp5_;
				GPtrArray* _tmp6_;
				gint _tmp7_;
				gint _tmp8_;
				ZeitgeistEvent* _tmp9_;
				GPtrArray* _tmp10_;
				GPtrArray* _tmp11_;
				gint _tmp12_;
				gconstpointer _tmp13_ = NULL;
				ZeitgeistSubject* _tmp14_;
				ZeitgeistSubject* subject;
				gint rc = 0;
				ZeitgeistSQLiteZeitgeistDatabase* _tmp15_;
				sqlite3_stmt* _tmp16_;
				sqlite3_stmt* move_stmt;
				sqlite3_stmt* _tmp17_;
				sqlite3_stmt* _tmp18_;
				ZeitgeistSubject* _tmp19_;
				const gchar* _tmp20_;
				const gchar* _tmp21_;
				gchar* _tmp22_;
				GDestroyNotify _tmp23_;
				sqlite3_stmt* _tmp24_;
				ZeitgeistSubject* _tmp25_;
				const gchar* _tmp26_;
				const gchar* _tmp27_;
				gchar* _tmp28_;
				GDestroyNotify _tmp29_;
				sqlite3_stmt* _tmp30_;
				ZeitgeistEvent* _tmp31_;
				const gchar* _tmp32_;
				const gchar* _tmp33_;
				gchar* _tmp34_;
				GDestroyNotify _tmp35_;
				sqlite3_stmt* _tmp36_;
				ZeitgeistEvent* _tmp37_;
				gint64 _tmp38_;
				gint64 _tmp39_;
				sqlite3_stmt* _tmp40_;
				gint _tmp41_ = 0;
				gint _tmp42_;
				_tmp1_ = _tmp0_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp3_ = i;
				_tmp4_ = event;
				_tmp5_ = zeitgeist_event_get_subjects (_tmp4_);
				_tmp6_ = _tmp5_;
				_tmp7_ = g_ptr_array_get_length (_tmp6_);
				_tmp8_ = _tmp7_;
				if (!(_tmp3_ < _tmp8_)) {
					break;
				}
				_tmp9_ = event;
				_tmp10_ = zeitgeist_event_get_subjects (_tmp9_);
				_tmp11_ = _tmp10_;
				_tmp12_ = i;
				_tmp13_ = g_ptr_array_index (_tmp11_, (guint) _tmp12_);
				_tmp14_ = _g_object_ref0 ((ZeitgeistSubject*) _tmp13_);
				subject = _tmp14_;
				_tmp15_ = self->priv->_database;
				_tmp16_ = _tmp15_->move_handling_stmt;
				move_stmt = _tmp16_;
				_tmp17_ = move_stmt;
				sqlite3_reset (_tmp17_);
				_tmp18_ = move_stmt;
				_tmp19_ = subject;
				_tmp20_ = zeitgeist_subject_get_current_uri (_tmp19_);
				_tmp21_ = _tmp20_;
				_tmp22_ = g_strdup (_tmp21_);
				_tmp23_ = g_free;
				sqlite3_bind_text (_tmp18_, 1, _tmp22_, -1, _tmp23_);
				_tmp24_ = move_stmt;
				_tmp25_ = subject;
				_tmp26_ = zeitgeist_subject_get_uri (_tmp25_);
				_tmp27_ = _tmp26_;
				_tmp28_ = g_strdup (_tmp27_);
				_tmp29_ = g_free;
				sqlite3_bind_text (_tmp24_, 2, _tmp28_, -1, _tmp29_);
				_tmp30_ = move_stmt;
				_tmp31_ = event;
				_tmp32_ = zeitgeist_event_get_interpretation (_tmp31_);
				_tmp33_ = _tmp32_;
				_tmp34_ = g_strdup (_tmp33_);
				_tmp35_ = g_free;
				sqlite3_bind_text (_tmp30_, 3, _tmp34_, -1, _tmp35_);
				_tmp36_ = move_stmt;
				_tmp37_ = event;
				_tmp38_ = zeitgeist_event_get_timestamp (_tmp37_);
				_tmp39_ = _tmp38_;
				sqlite3_bind_int64 (_tmp36_, 4, _tmp39_);
				_tmp40_ = move_stmt;
				_tmp41_ = sqlite3_step (_tmp40_);
				rc = _tmp41_;
				_tmp42_ = rc;
				if (_tmp42_ != SQLITE_DONE) {
					gint _tmp43_;
					_tmp43_ = rc;
					if (_tmp43_ != SQLITE_CONSTRAINT) {
						gint _tmp44_;
						sqlite3* _tmp45_;
						const gchar* _tmp46_ = NULL;
						_tmp44_ = rc;
						_tmp45_ = self->priv->db;
						_tmp46_ = sqlite3_errmsg (_tmp45_);
						g_warning ("engine.vala:1097: SQL error: %d, %s\n", _tmp44_, _tmp46_);
					}
				}
				_g_object_unref0 (subject);
			}
		}
	}
}


static gint64 zeitgeist_engine_store_payload (ZeitgeistEngine* self, ZeitgeistEvent* event) {
	gint64 result = 0LL;
	ZeitgeistEvent* _tmp0_;
	GByteArray* _tmp1_;
	GByteArray* _tmp2_;
	g_return_val_if_fail (self != NULL, 0LL);
	g_return_val_if_fail (event != NULL, 0LL);
	_tmp0_ = event;
	_tmp1_ = zeitgeist_event_get_payload (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ != NULL) {
		gint rc = 0;
		ZeitgeistSQLiteZeitgeistDatabase* _tmp3_;
		sqlite3_stmt* _tmp4_;
		sqlite3_stmt* payload_insertion_stmt;
		sqlite3_stmt* _tmp5_;
		sqlite3_stmt* _tmp6_;
		ZeitgeistEvent* _tmp7_;
		GByteArray* _tmp8_;
		GByteArray* _tmp9_;
		guint8* _tmp10_;
		gint _tmp10__length1;
		ZeitgeistEvent* _tmp11_;
		GByteArray* _tmp12_;
		GByteArray* _tmp13_;
		guint8* _tmp14_;
		gint _tmp14__length1;
		sqlite3_stmt* _tmp15_;
		gint _tmp16_ = 0;
		gint _tmp17_;
		ZeitgeistSQLiteZeitgeistDatabase* _tmp22_;
		sqlite3* _tmp23_;
		gint64 _tmp24_ = 0LL;
		_tmp3_ = self->priv->_database;
		_tmp4_ = _tmp3_->payload_insertion_stmt;
		payload_insertion_stmt = _tmp4_;
		_tmp5_ = payload_insertion_stmt;
		sqlite3_reset (_tmp5_);
		_tmp6_ = payload_insertion_stmt;
		_tmp7_ = event;
		_tmp8_ = zeitgeist_event_get_payload (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = _tmp9_->data;
		_tmp10__length1 = (gint) _tmp9_->len;
		_tmp11_ = event;
		_tmp12_ = zeitgeist_event_get_payload (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = _tmp13_->data;
		_tmp14__length1 = (gint) _tmp13_->len;
		sqlite3_bind_blob (_tmp6_, 1, _tmp10_, _tmp14__length1, NULL);
		_tmp15_ = payload_insertion_stmt;
		_tmp16_ = sqlite3_step (_tmp15_);
		rc = _tmp16_;
		_tmp17_ = rc;
		if (_tmp17_ != SQLITE_DONE) {
			gint _tmp18_;
			_tmp18_ = rc;
			if (_tmp18_ != SQLITE_CONSTRAINT) {
				gint _tmp19_;
				sqlite3* _tmp20_;
				const gchar* _tmp21_ = NULL;
				_tmp19_ = rc;
				_tmp20_ = self->priv->db;
				_tmp21_ = sqlite3_errmsg (_tmp20_);
				g_warning ("engine.vala:1121: SQL error: %d, %s\n", _tmp19_, _tmp21_);
			}
		}
		_tmp22_ = self->priv->_database;
		_tmp23_ = _tmp22_->database;
		_tmp24_ = sqlite3_last_insert_rowid (_tmp23_);
		result = _tmp24_;
		return result;
	}
	result = (gint64) 0;
	return result;
}


static void zeitgeist_engine_delete_from_cache (ZeitgeistEngine* self, const gchar* table, gint64 rowid) {
	ZeitgeistSQLiteTableLookup* table_lookup = NULL;
	const gchar* _tmp0_;
	ZeitgeistSQLiteTableLookup* _tmp12_;
	gint64 _tmp13_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (table != NULL);
	_tmp0_ = table;
	if (g_strcmp0 (_tmp0_, "interpretation") == 0) {
		ZeitgeistSQLiteTableLookup* _tmp1_;
		ZeitgeistSQLiteTableLookup* _tmp2_;
		_tmp1_ = self->interpretations_table;
		_tmp2_ = _g_object_ref0 (_tmp1_);
		_g_object_unref0 (table_lookup);
		table_lookup = _tmp2_;
	} else {
		const gchar* _tmp3_;
		_tmp3_ = table;
		if (g_strcmp0 (_tmp3_, "manifestation") == 0) {
			ZeitgeistSQLiteTableLookup* _tmp4_;
			ZeitgeistSQLiteTableLookup* _tmp5_;
			_tmp4_ = self->manifestations_table;
			_tmp5_ = _g_object_ref0 (_tmp4_);
			_g_object_unref0 (table_lookup);
			table_lookup = _tmp5_;
		} else {
			const gchar* _tmp6_;
			_tmp6_ = table;
			if (g_strcmp0 (_tmp6_, "mimetype") == 0) {
				ZeitgeistSQLiteTableLookup* _tmp7_;
				ZeitgeistSQLiteTableLookup* _tmp8_;
				_tmp7_ = self->mimetypes_table;
				_tmp8_ = _g_object_ref0 (_tmp7_);
				_g_object_unref0 (table_lookup);
				table_lookup = _tmp8_;
			} else {
				const gchar* _tmp9_;
				_tmp9_ = table;
				if (g_strcmp0 (_tmp9_, "actor") == 0) {
					ZeitgeistSQLiteTableLookup* _tmp10_;
					ZeitgeistSQLiteTableLookup* _tmp11_;
					_tmp10_ = self->actors_table;
					_tmp11_ = _g_object_ref0 (_tmp10_);
					_g_object_unref0 (table_lookup);
					table_lookup = _tmp11_;
				} else {
					_g_object_unref0 (table_lookup);
					return;
				}
			}
		}
	}
	_tmp12_ = table_lookup;
	_tmp13_ = rowid;
	zeitgeist_sq_lite_table_lookup_remove (_tmp12_, (gint) _tmp13_);
	_g_object_unref0 (table_lookup);
}


ZeitgeistSQLiteZeitgeistDatabase* zeitgeist_engine_get_database (ZeitgeistEngine* self) {
	ZeitgeistSQLiteZeitgeistDatabase* result;
	ZeitgeistSQLiteZeitgeistDatabase* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_database;
	result = _tmp0_;
	return result;
}


static void zeitgeist_engine_set_database (ZeitgeistEngine* self, ZeitgeistSQLiteZeitgeistDatabase* value) {
	ZeitgeistSQLiteZeitgeistDatabase* _tmp0_;
	ZeitgeistSQLiteZeitgeistDatabase* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_database);
	self->priv->_database = _tmp1_;
	g_object_notify ((GObject *) self, "database");
}


static void zeitgeist_engine_related_uri_copy (const ZeitgeistEngineRelatedUri* self, ZeitgeistEngineRelatedUri* dest) {
	guint32 _tmp0_;
	gint64 _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gint32 _tmp4_;
	_tmp0_ = (*self).id;
	(*dest).id = _tmp0_;
	_tmp1_ = (*self).timestamp;
	(*dest).timestamp = _tmp1_;
	_tmp2_ = (*self).uri;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 ((*dest).uri);
	(*dest).uri = _tmp3_;
	_tmp4_ = (*self).counter;
	(*dest).counter = _tmp4_;
}


static void zeitgeist_engine_related_uri_destroy (ZeitgeistEngineRelatedUri* self) {
	_g_free0 ((*self).uri);
}


static ZeitgeistEngineRelatedUri* zeitgeist_engine_related_uri_dup (const ZeitgeistEngineRelatedUri* self) {
	ZeitgeistEngineRelatedUri* dup;
	dup = g_new0 (ZeitgeistEngineRelatedUri, 1);
	zeitgeist_engine_related_uri_copy (self, dup);
	return dup;
}


static void zeitgeist_engine_related_uri_free (ZeitgeistEngineRelatedUri* self) {
	zeitgeist_engine_related_uri_destroy (self);
	g_free (self);
}


static GType zeitgeist_engine_related_uri_get_type (void) {
	static volatile gsize zeitgeist_engine_related_uri_type_id__volatile = 0;
	if (g_once_init_enter (&zeitgeist_engine_related_uri_type_id__volatile)) {
		GType zeitgeist_engine_related_uri_type_id;
		zeitgeist_engine_related_uri_type_id = g_boxed_type_register_static ("ZeitgeistEngineRelatedUri", (GBoxedCopyFunc) zeitgeist_engine_related_uri_dup, (GBoxedFreeFunc) zeitgeist_engine_related_uri_free);
		g_once_init_leave (&zeitgeist_engine_related_uri_type_id__volatile, zeitgeist_engine_related_uri_type_id);
	}
	return zeitgeist_engine_related_uri_type_id__volatile;
}


static void zeitgeist_engine_class_init (ZeitgeistEngineClass * klass) {
	zeitgeist_engine_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ZeitgeistEnginePrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_zeitgeist_engine_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_zeitgeist_engine_set_property;
	G_OBJECT_CLASS (klass)->finalize = zeitgeist_engine_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), ZEITGEIST_ENGINE_DATABASE, g_param_spec_object ("database", "database", "database", ZEITGEIST_SQ_LITE_TYPE_ZEITGEIST_DATABASE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void zeitgeist_engine_instance_init (ZeitgeistEngine * self) {
	self->priv = ZEITGEIST_ENGINE_GET_PRIVATE (self);
}


static void zeitgeist_engine_finalize (GObject* obj) {
	ZeitgeistEngine * self;
	self = ZEITGEIST_ENGINE (obj);
	_g_object_unref0 (self->priv->_database);
	_g_object_unref0 (self->extension_store);
	_g_object_unref0 (self->priv->extension_collection);
	_g_object_unref0 (self->interpretations_table);
	_g_object_unref0 (self->manifestations_table);
	_g_object_unref0 (self->mimetypes_table);
	_g_object_unref0 (self->actors_table);
	G_OBJECT_CLASS (zeitgeist_engine_parent_class)->finalize (obj);
}


GType zeitgeist_engine_get_type (void) {
	static volatile gsize zeitgeist_engine_type_id__volatile = 0;
	if (g_once_init_enter (&zeitgeist_engine_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ZeitgeistEngineClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) zeitgeist_engine_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ZeitgeistEngine), 0, (GInstanceInitFunc) zeitgeist_engine_instance_init, NULL };
		GType zeitgeist_engine_type_id;
		zeitgeist_engine_type_id = g_type_register_static (G_TYPE_OBJECT, "ZeitgeistEngine", &g_define_type_info, 0);
		g_once_init_leave (&zeitgeist_engine_type_id__volatile, zeitgeist_engine_type_id);
	}
	return zeitgeist_engine_type_id__volatile;
}


static void _vala_zeitgeist_engine_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ZeitgeistEngine * self;
	self = ZEITGEIST_ENGINE (object);
	switch (property_id) {
		case ZEITGEIST_ENGINE_DATABASE:
		g_value_set_object (value, zeitgeist_engine_get_database (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_zeitgeist_engine_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ZeitgeistEngine * self;
	self = ZEITGEIST_ENGINE (object);
	switch (property_id) {
		case ZEITGEIST_ENGINE_DATABASE:
		zeitgeist_engine_set_database (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



