/* desktop-launch-listener.c generated by valac 0.11.5.3-984e-dirty, the Vala compiler
 * generated from desktop-launch-listener.vala, do not modify */

/*
 * Zeitgeist
 *
 * Copyright (C) 2010 Michal Hruby <michal.mhr@gmail.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Michal Hruby <michal.mhr@gmail.com>
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <gio/gdesktopappinfo.h>
#include <zeitgeist.h>


#define TYPE_DATA_PROVIDER (data_provider_get_type ())
#define DATA_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_PROVIDER, DataProvider))
#define DATA_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_PROVIDER, DataProviderClass))
#define IS_DATA_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_PROVIDER))
#define IS_DATA_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_PROVIDER))
#define DATA_PROVIDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_PROVIDER, DataProviderClass))

typedef struct _DataProvider DataProvider;
typedef struct _DataProviderClass DataProviderClass;
typedef struct _DataProviderPrivate DataProviderPrivate;

#define TYPE_DATA_HUB (data_hub_get_type ())
#define DATA_HUB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_HUB, DataHub))
#define DATA_HUB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_HUB, DataHubClass))
#define IS_DATA_HUB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_HUB))
#define IS_DATA_HUB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_HUB))
#define DATA_HUB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_HUB, DataHubClass))

typedef struct _DataHub DataHub;
typedef struct _DataHubClass DataHubClass;

#define TYPE_DESKTOP_LAUNCH_LISTENER (desktop_launch_listener_get_type ())
#define DESKTOP_LAUNCH_LISTENER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DESKTOP_LAUNCH_LISTENER, DesktopLaunchListener))
#define DESKTOP_LAUNCH_LISTENER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DESKTOP_LAUNCH_LISTENER, DesktopLaunchListenerClass))
#define IS_DESKTOP_LAUNCH_LISTENER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DESKTOP_LAUNCH_LISTENER))
#define IS_DESKTOP_LAUNCH_LISTENER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DESKTOP_LAUNCH_LISTENER))
#define DESKTOP_LAUNCH_LISTENER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DESKTOP_LAUNCH_LISTENER, DesktopLaunchListenerClass))

typedef struct _DesktopLaunchListener DesktopLaunchListener;
typedef struct _DesktopLaunchListenerClass DesktopLaunchListenerClass;
typedef struct _DesktopLaunchListenerPrivate DesktopLaunchListenerPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_variant_iter_free0(var) ((var == NULL) ? NULL : (var = (g_variant_iter_free (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _DataProvider {
	GObject parent_instance;
	DataProviderPrivate * priv;
};

struct _DataProviderClass {
	GObjectClass parent_class;
	void (*start) (DataProvider* self);
	void (*stop) (DataProvider* self);
	const gchar* (*get_unique_id) (DataProvider* self);
	void (*set_unique_id) (DataProvider* self, const gchar* value);
	const gchar* (*get_name) (DataProvider* self);
	void (*set_name) (DataProvider* self, const gchar* value);
	const gchar* (*get_description) (DataProvider* self);
	void (*set_description) (DataProvider* self, const gchar* value);
	DataHub* (*get_datahub) (DataProvider* self);
	void (*set_datahub) (DataProvider* self, DataHub* value);
	gboolean (*get_enabled) (DataProvider* self);
	void (*set_enabled) (DataProvider* self, gboolean value);
	gboolean (*get_register) (DataProvider* self);
	void (*set_register) (DataProvider* self, gboolean value);
};

struct _DesktopLaunchListener {
	DataProvider parent_instance;
	DesktopLaunchListenerPrivate * priv;
};

struct _DesktopLaunchListenerClass {
	DataProviderClass parent_class;
};

struct _DesktopLaunchListenerPrivate {
	gchar* _unique_id;
	gchar* _name;
	gchar* _description;
	DataHub* _datahub;
	gboolean _enabled;
	gboolean _register;
	GDBusConnection* bus;
	guint launched_signal_id;
};


static gpointer desktop_launch_listener_parent_class = NULL;

GType data_provider_get_type (void) G_GNUC_CONST;
GType data_hub_get_type (void) G_GNUC_CONST;
GType desktop_launch_listener_get_type (void) G_GNUC_CONST;
#define DESKTOP_LAUNCH_LISTENER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_DESKTOP_LAUNCH_LISTENER, DesktopLaunchListenerPrivate))
enum  {
	DESKTOP_LAUNCH_LISTENER_DUMMY_PROPERTY,
	DESKTOP_LAUNCH_LISTENER_UNIQUE_ID,
	DESKTOP_LAUNCH_LISTENER_NAME,
	DESKTOP_LAUNCH_LISTENER_DESCRIPTION,
	DESKTOP_LAUNCH_LISTENER_DATAHUB,
	DESKTOP_LAUNCH_LISTENER_ENABLED,
	DESKTOP_LAUNCH_LISTENER_REGISTER
};
DesktopLaunchListener* desktop_launch_listener_new (DataHub* datahub);
DesktopLaunchListener* desktop_launch_listener_construct (GType object_type, DataHub* datahub);
static void desktop_launch_listener_real_start (DataProvider* base);
static void desktop_launch_listener_signal_received (DesktopLaunchListener* self, GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* signal_name, GVariant* parameters);
static void _desktop_launch_listener_signal_received_gd_bus_signal_callback (GDBusConnection* connection, const gchar* sender_name, const gchar* object_path, const gchar* interface_name, const gchar* signal_name, GVariant* parameters, gpointer self);
static GHashTable* _variant_get1 (GVariant* value);
static gchar* desktop_launch_listener_get_uri_for_desktop_file (DesktopLaunchListener* self, const gchar* desktop_file, GDesktopAppInfo** dai);
static void _g_object_unref0_ (gpointer var);
static void desktop_launch_listener_real_stop (DataProvider* base);
static GObject * desktop_launch_listener_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void desktop_launch_listener_finalize (GObject* obj);
const gchar* data_provider_get_unique_id (DataProvider* self);
const gchar* data_provider_get_name (DataProvider* self);
const gchar* data_provider_get_description (DataProvider* self);
DataHub* data_provider_get_datahub (DataProvider* self);
gboolean data_provider_get_enabled (DataProvider* self);
gboolean data_provider_get_register (DataProvider* self);
static void _vala_desktop_launch_listener_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
void data_provider_set_unique_id (DataProvider* self, const gchar* value);
void data_provider_set_name (DataProvider* self, const gchar* value);
void data_provider_set_description (DataProvider* self, const gchar* value);
void data_provider_set_datahub (DataProvider* self, DataHub* value);
void data_provider_set_enabled (DataProvider* self, gboolean value);
void data_provider_set_register (DataProvider* self, gboolean value);
static void _vala_desktop_launch_listener_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


DesktopLaunchListener* desktop_launch_listener_construct (GType object_type, DataHub* datahub) {
	DesktopLaunchListener * self = NULL;
	g_return_val_if_fail (datahub != NULL, NULL);
	self = (DesktopLaunchListener*) g_object_new (object_type, "unique-id", "com.zeitgeist-project,datahub,gio-launch-listener", "name", "Launched desktop files", "description", "Logs events about launched desktop files using GIO", "datahub", datahub, NULL);
	return self;
}


DesktopLaunchListener* desktop_launch_listener_new (DataHub* datahub) {
	return desktop_launch_listener_construct (TYPE_DESKTOP_LAUNCH_LISTENER, datahub);
}


static void _desktop_launch_listener_signal_received_gd_bus_signal_callback (GDBusConnection* connection, const gchar* sender_name, const gchar* object_path, const gchar* interface_name, const gchar* signal_name, GVariant* parameters, gpointer self) {
	desktop_launch_listener_signal_received (self, connection, sender_name, object_path, interface_name, signal_name, parameters);
}


static void desktop_launch_listener_real_start (DataProvider* base) {
	DesktopLaunchListener * self;
	guint _tmp0_;
	self = (DesktopLaunchListener*) base;
	if (self->priv->launched_signal_id != 0) {
		return;
	}
	_tmp0_ = g_dbus_connection_signal_subscribe (self->priv->bus, NULL, "org.gtk.gio.DesktopAppInfo", "Launched", "/org/gtk/gio/DesktopAppInfo", NULL, 0, _desktop_launch_listener_signal_received_gd_bus_signal_callback, g_object_ref (self), g_object_unref);
	self->priv->launched_signal_id = _tmp0_;
}


static GHashTable* _variant_get1 (GVariant* value) {
	GHashTable* _tmp3_;
	GVariantIter _tmp4_;
	GVariant* _tmp5_;
	GVariant* _tmp6_;
	_tmp3_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, NULL);
	g_variant_iter_init (&_tmp4_, value);
	while (g_variant_iter_loop (&_tmp4_, "{?*}", &_tmp5_, &_tmp6_)) {
		g_hash_table_insert (_tmp3_, g_variant_dup_string (_tmp5_, NULL), g_variant_get_variant (_tmp6_));
	}
	return _tmp3_;
}


static gpointer _g_hash_table_ref0 (gpointer self) {
	return self ? g_hash_table_ref (self) : NULL;
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void desktop_launch_listener_signal_received (DesktopLaunchListener* self, GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* signal_name, GVariant* parameters) {
	GVariant* desktop_variant = NULL;
	GVariantIter* uris = NULL;
	GVariant* dict = NULL;
	gint64 pid = 0LL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* desktop_file;
	gchar* uri = NULL;
	GHashTable* _tmp7_;
	GHashTable* extra_params;
	GDesktopAppInfo* dai = NULL;
	GDesktopAppInfo* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	gchar* launched_uri;
	gchar* launcher_uri;
	gconstpointer _tmp10_ = NULL;
	GVariant* origin_df;
	gboolean _tmp19_;
	ZeitgeistEvent* _tmp20_ = NULL;
	ZeitgeistEvent* event;
	ZeitgeistSubject* _tmp21_ = NULL;
	ZeitgeistSubject* subject;
	const gchar* _tmp22_ = NULL;
	GPtrArray* _tmp23_ = NULL;
	GPtrArray* arr;
	ZeitgeistEvent* _tmp24_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (connection != NULL);
	g_return_if_fail (sender != NULL);
	g_return_if_fail (object_path != NULL);
	g_return_if_fail (interface_name != NULL);
	g_return_if_fail (signal_name != NULL);
	g_return_if_fail (parameters != NULL);
	g_variant_get (parameters, "(@aysxas@a{sv})", &desktop_variant, NULL, &pid, &uris, &dict, NULL);
	_tmp0_ = g_variant_get_bytestring (desktop_variant);
	_tmp1_ = g_strdup (_tmp0_);
	desktop_file = _tmp1_;
	if (g_strcmp0 (desktop_file, "") == 0) {
		_g_free0 (desktop_file);
		_g_variant_unref0 (dict);
		_g_variant_iter_free0 (uris);
		_g_variant_unref0 (desktop_variant);
		return;
	}
	while (TRUE) {
		gboolean _tmp2_;
		_tmp2_ = g_variant_iter_next (uris, "s", &uri, NULL);
		if (!_tmp2_) {
			break;
		}
		g_debug ("desktop-launch-listener.vala:118: ran with uri: %s", uri);
	}
	_tmp7_ = _g_hash_table_ref0 (_variant_get1 (dict));
	extra_params = _tmp7_;
	_tmp9_ = desktop_launch_listener_get_uri_for_desktop_file (self, desktop_file, &_tmp8_);
	_g_object_unref0 (dai);
	dai = _tmp8_;
	launched_uri = _tmp9_;
	if (launched_uri == NULL) {
		g_warning ("desktop-launch-listener.vala:129: Unable to open desktop file '%s'", desktop_file);
		_g_free0 (launched_uri);
		_g_object_unref0 (dai);
		_g_hash_table_unref0 (extra_params);
		_g_free0 (uri);
		_g_free0 (desktop_file);
		_g_variant_unref0 (dict);
		_g_variant_iter_free0 (uris);
		_g_variant_unref0 (desktop_variant);
		return;
	}
	launcher_uri = NULL;
	_tmp10_ = g_hash_table_lookup (extra_params, "origin-desktop-file");
	origin_df = (GVariant*) _tmp10_;
	if (origin_df != NULL) {
		const gchar* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
		gchar* _tmp13_;
		_tmp11_ = g_variant_get_bytestring (origin_df);
		_tmp12_ = desktop_launch_listener_get_uri_for_desktop_file (self, _tmp11_, NULL);
		_tmp13_ = _tmp12_;
		_g_free0 (launcher_uri);
		launcher_uri = _tmp13_;
	} else {
		gconstpointer _tmp14_ = NULL;
		GVariant* origin_prgname;
		_tmp14_ = g_hash_table_lookup (extra_params, "origin-prgname");
		origin_prgname = (GVariant*) _tmp14_;
		if (origin_prgname != NULL) {
			const gchar* _tmp15_ = NULL;
			const gchar* prgname;
			gchar* origin_desktop_id;
			GDesktopAppInfo* _tmp16_ = NULL;
			GDesktopAppInfo* id_check;
			_tmp15_ = g_variant_get_bytestring (origin_prgname);
			prgname = _tmp15_;
			origin_desktop_id = g_strconcat (prgname, ".desktop", NULL);
			_tmp16_ = g_desktop_app_info_new (origin_desktop_id);
			id_check = _tmp16_;
			if (id_check != NULL) {
				gchar* _tmp17_ = NULL;
				gchar* _tmp18_;
				_tmp17_ = g_strdup_printf ("application://%s", origin_desktop_id);
				_tmp18_ = _tmp17_;
				_g_free0 (launcher_uri);
				launcher_uri = _tmp18_;
			}
			_g_object_unref0 (id_check);
			_g_free0 (origin_desktop_id);
		}
	}
	_tmp19_ = g_app_info_should_show ((GAppInfo*) dai);
	if (!_tmp19_) {
		_g_free0 (launcher_uri);
		_g_free0 (launched_uri);
		_g_object_unref0 (dai);
		_g_hash_table_unref0 (extra_params);
		_g_free0 (uri);
		_g_free0 (desktop_file);
		_g_variant_unref0 (dict);
		_g_variant_iter_free0 (uris);
		_g_variant_unref0 (desktop_variant);
		return;
	}
	_tmp20_ = zeitgeist_event_new ();
	event = g_object_ref_sink (_tmp20_);
	_tmp21_ = zeitgeist_subject_new ();
	subject = g_object_ref_sink (_tmp21_);
	zeitgeist_event_set_actor (event, launcher_uri);
	zeitgeist_event_set_interpretation (event, ZEITGEIST_ZG_ACCESS_EVENT);
	zeitgeist_event_set_manifestation (event, ZEITGEIST_ZG_USER_ACTIVITY);
	zeitgeist_event_add_subject (event, subject);
	zeitgeist_subject_set_uri (subject, launched_uri);
	zeitgeist_subject_set_interpretation (subject, ZEITGEIST_NFO_SOFTWARE);
	zeitgeist_subject_set_manifestation (subject, ZEITGEIST_NFO_SOFTWARE_ITEM);
	zeitgeist_subject_set_mimetype (subject, "application/x-desktop");
	_tmp22_ = g_app_info_get_display_name ((GAppInfo*) dai);
	zeitgeist_subject_set_text (subject, _tmp22_);
	_tmp23_ = g_ptr_array_new_with_free_func (_g_object_unref0_);
	arr = _tmp23_;
	_tmp24_ = _g_object_ref0 (event);
	g_ptr_array_add (arr, _tmp24_);
	g_signal_emit_by_name ((DataProvider*) self, "items-available", arr);
	_g_ptr_array_unref0 (arr);
	_g_object_unref0 (subject);
	_g_object_unref0 (event);
	_g_free0 (launcher_uri);
	_g_free0 (launched_uri);
	_g_object_unref0 (dai);
	_g_hash_table_unref0 (extra_params);
	_g_free0 (uri);
	_g_free0 (desktop_file);
	_g_variant_unref0 (dict);
	_g_variant_iter_free0 (uris);
	_g_variant_unref0 (desktop_variant);
}


static gchar* desktop_launch_listener_get_uri_for_desktop_file (DesktopLaunchListener* self, const gchar* desktop_file, GDesktopAppInfo** dai) {
	GDesktopAppInfo* _dai = NULL;
	gchar* result = NULL;
	gboolean _tmp0_;
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp11_;
	gchar* desktop_id;
	gchar* _tmp12_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (desktop_file != NULL, NULL);
	_tmp0_ = g_path_is_absolute (desktop_file);
	if (_tmp0_) {
		GDesktopAppInfo* _tmp1_ = NULL;
		GDesktopAppInfo* _tmp2_;
		_tmp1_ = g_desktop_app_info_new_from_filename (desktop_file);
		_tmp2_ = _tmp1_;
		_g_object_unref0 (_dai);
		_dai = _tmp2_;
	} else {
		GDesktopAppInfo* _tmp3_ = NULL;
		GDesktopAppInfo* _tmp4_;
		_tmp3_ = g_desktop_app_info_new (desktop_file);
		_tmp4_ = _tmp3_;
		_g_object_unref0 (_dai);
		_dai = _tmp4_;
	}
	if (_dai == NULL) {
		result = NULL;
		if (dai) {
			*dai = _dai;
		} else {
			_g_object_unref0 (_dai);
		}
		return result;
	}
	_tmp5_ = g_app_info_get_id ((GAppInfo*) _dai);
	_tmp6_ = g_strdup (_tmp5_);
	_tmp7_ = _tmp6_;
	if (_tmp7_ == NULL) {
		const gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		gchar* _tmp10_;
		_tmp8_ = g_desktop_app_info_get_filename (_dai);
		_tmp9_ = g_path_get_basename (_tmp8_);
		_tmp10_ = _tmp9_;
		_g_free0 (_tmp7_);
		_tmp7_ = _tmp10_;
	}
	_tmp11_ = g_strdup (_tmp7_);
	desktop_id = _tmp11_;
	_tmp12_ = g_strdup_printf ("application://%s", desktop_id);
	result = _tmp12_;
	_g_free0 (desktop_id);
	_g_free0 (_tmp7_);
	if (dai) {
		*dai = _dai;
	} else {
		_g_object_unref0 (_dai);
	}
	return result;
}


static void desktop_launch_listener_real_stop (DataProvider* base) {
	DesktopLaunchListener * self;
	self = (DesktopLaunchListener*) base;
	if (self->priv->launched_signal_id != 0) {
		g_dbus_connection_signal_unsubscribe (self->priv->bus, self->priv->launched_signal_id);
		self->priv->launched_signal_id = (guint) 0;
	}
}


static const gchar* desktop_launch_listener_real_get_unique_id (DataProvider* base) {
	const gchar* result;
	DesktopLaunchListener* self;
	self = (DesktopLaunchListener*) base;
	result = self->priv->_unique_id;
	return result;
}


static void desktop_launch_listener_real_set_unique_id (DataProvider* base, const gchar* value) {
	DesktopLaunchListener* self;
	gchar* _tmp0_;
	gchar* _tmp1_;
	self = (DesktopLaunchListener*) base;
	_tmp0_ = g_strdup (value);
	_tmp1_ = _tmp0_;
	_g_free0 (self->priv->_unique_id);
	self->priv->_unique_id = _tmp1_;
	g_object_notify ((GObject *) self, "unique-id");
}


static const gchar* desktop_launch_listener_real_get_name (DataProvider* base) {
	const gchar* result;
	DesktopLaunchListener* self;
	self = (DesktopLaunchListener*) base;
	result = self->priv->_name;
	return result;
}


static void desktop_launch_listener_real_set_name (DataProvider* base, const gchar* value) {
	DesktopLaunchListener* self;
	gchar* _tmp0_;
	gchar* _tmp1_;
	self = (DesktopLaunchListener*) base;
	_tmp0_ = g_strdup (value);
	_tmp1_ = _tmp0_;
	_g_free0 (self->priv->_name);
	self->priv->_name = _tmp1_;
	g_object_notify ((GObject *) self, "name");
}


static const gchar* desktop_launch_listener_real_get_description (DataProvider* base) {
	const gchar* result;
	DesktopLaunchListener* self;
	self = (DesktopLaunchListener*) base;
	result = self->priv->_description;
	return result;
}


static void desktop_launch_listener_real_set_description (DataProvider* base, const gchar* value) {
	DesktopLaunchListener* self;
	gchar* _tmp0_;
	gchar* _tmp1_;
	self = (DesktopLaunchListener*) base;
	_tmp0_ = g_strdup (value);
	_tmp1_ = _tmp0_;
	_g_free0 (self->priv->_description);
	self->priv->_description = _tmp1_;
	g_object_notify ((GObject *) self, "description");
}


static DataHub* desktop_launch_listener_real_get_datahub (DataProvider* base) {
	DataHub* result;
	DesktopLaunchListener* self;
	self = (DesktopLaunchListener*) base;
	result = self->priv->_datahub;
	return result;
}


static void desktop_launch_listener_real_set_datahub (DataProvider* base, DataHub* value) {
	DesktopLaunchListener* self;
	DataHub* _tmp0_;
	DataHub* _tmp1_;
	self = (DesktopLaunchListener*) base;
	_tmp0_ = _g_object_ref0 (value);
	_tmp1_ = _tmp0_;
	_g_object_unref0 (self->priv->_datahub);
	self->priv->_datahub = _tmp1_;
	g_object_notify ((GObject *) self, "datahub");
}


static gboolean desktop_launch_listener_real_get_enabled (DataProvider* base) {
	gboolean result;
	DesktopLaunchListener* self;
	self = (DesktopLaunchListener*) base;
	result = self->priv->_enabled;
	return result;
}


static void desktop_launch_listener_real_set_enabled (DataProvider* base, gboolean value) {
	DesktopLaunchListener* self;
	self = (DesktopLaunchListener*) base;
	self->priv->_enabled = value;
	g_object_notify ((GObject *) self, "enabled");
}


static gboolean desktop_launch_listener_real_get_register (DataProvider* base) {
	gboolean result;
	DesktopLaunchListener* self;
	self = (DesktopLaunchListener*) base;
	result = self->priv->_register;
	return result;
}


static void desktop_launch_listener_real_set_register (DataProvider* base, gboolean value) {
	DesktopLaunchListener* self;
	self = (DesktopLaunchListener*) base;
	self->priv->_register = value;
	g_object_notify ((GObject *) self, "register");
}


static GObject * desktop_launch_listener_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	DesktopLaunchListener * self;
	GDBusConnection* _tmp0_ = NULL;
	GDBusConnection* _tmp1_;
	GDBusConnection* _tmp2_;
	const gchar* _tmp3_ = NULL;
	const gchar* session_var;
	gchar* _tmp4_ = NULL;
	gchar* desktop_session;
	gboolean _tmp5_;
	GError * _inner_error_ = NULL;
	parent_class = G_OBJECT_CLASS (desktop_launch_listener_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = DESKTOP_LAUNCH_LISTENER (obj);
	_tmp0_ = g_bus_get_sync (G_BUS_TYPE_SESSION, NULL, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_IO_ERROR) {
			goto __catch0_g_io_error;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
	}
	_tmp2_ = _tmp1_;
	_g_object_unref0 (self->priv->bus);
	self->priv->bus = _tmp2_;
	goto __finally0;
	__catch0_g_io_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("desktop-launch-listener.vala:56: %s", err->message);
		_g_error_free0 (err);
	}
	__finally0:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
	}
	_tmp3_ = g_getenv ("DESKTOP_SESSION");
	session_var = _tmp3_;
	if (session_var == NULL) {
		g_desktop_app_info_set_desktop_env ("GNOME");
		return obj;
	}
	_tmp4_ = g_utf8_strup (session_var, (gssize) (-1));
	desktop_session = _tmp4_;
	_tmp5_ = g_str_has_prefix (desktop_session, "GNOME");
	if (_tmp5_) {
		g_desktop_app_info_set_desktop_env ("GNOME");
	} else {
		gboolean _tmp6_;
		_tmp6_ = g_str_has_prefix (desktop_session, "KDE");
		if (_tmp6_) {
			g_desktop_app_info_set_desktop_env ("KDE");
		} else {
			gboolean _tmp7_;
			_tmp7_ = g_str_has_prefix (desktop_session, "XFCE");
			if (_tmp7_) {
				g_desktop_app_info_set_desktop_env ("XFCE");
			}
		}
	}
	_g_free0 (desktop_session);
	return obj;
}


static void desktop_launch_listener_class_init (DesktopLaunchListenerClass * klass) {
	desktop_launch_listener_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DesktopLaunchListenerPrivate));
	DATA_PROVIDER_CLASS (klass)->start = desktop_launch_listener_real_start;
	DATA_PROVIDER_CLASS (klass)->stop = desktop_launch_listener_real_stop;
	DATA_PROVIDER_CLASS (klass)->get_unique_id = desktop_launch_listener_real_get_unique_id;
	DATA_PROVIDER_CLASS (klass)->set_unique_id = desktop_launch_listener_real_set_unique_id;
	DATA_PROVIDER_CLASS (klass)->get_name = desktop_launch_listener_real_get_name;
	DATA_PROVIDER_CLASS (klass)->set_name = desktop_launch_listener_real_set_name;
	DATA_PROVIDER_CLASS (klass)->get_description = desktop_launch_listener_real_get_description;
	DATA_PROVIDER_CLASS (klass)->set_description = desktop_launch_listener_real_set_description;
	DATA_PROVIDER_CLASS (klass)->get_datahub = desktop_launch_listener_real_get_datahub;
	DATA_PROVIDER_CLASS (klass)->set_datahub = desktop_launch_listener_real_set_datahub;
	DATA_PROVIDER_CLASS (klass)->get_enabled = desktop_launch_listener_real_get_enabled;
	DATA_PROVIDER_CLASS (klass)->set_enabled = desktop_launch_listener_real_set_enabled;
	DATA_PROVIDER_CLASS (klass)->get_register = desktop_launch_listener_real_get_register;
	DATA_PROVIDER_CLASS (klass)->set_register = desktop_launch_listener_real_set_register;
	G_OBJECT_CLASS (klass)->get_property = _vala_desktop_launch_listener_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_desktop_launch_listener_set_property;
	G_OBJECT_CLASS (klass)->constructor = desktop_launch_listener_constructor;
	G_OBJECT_CLASS (klass)->finalize = desktop_launch_listener_finalize;
	g_object_class_override_property (G_OBJECT_CLASS (klass), DESKTOP_LAUNCH_LISTENER_UNIQUE_ID, "unique-id");
	g_object_class_override_property (G_OBJECT_CLASS (klass), DESKTOP_LAUNCH_LISTENER_NAME, "name");
	g_object_class_override_property (G_OBJECT_CLASS (klass), DESKTOP_LAUNCH_LISTENER_DESCRIPTION, "description");
	g_object_class_override_property (G_OBJECT_CLASS (klass), DESKTOP_LAUNCH_LISTENER_DATAHUB, "datahub");
	g_object_class_override_property (G_OBJECT_CLASS (klass), DESKTOP_LAUNCH_LISTENER_ENABLED, "enabled");
	g_object_class_override_property (G_OBJECT_CLASS (klass), DESKTOP_LAUNCH_LISTENER_REGISTER, "register");
}


static void desktop_launch_listener_instance_init (DesktopLaunchListener * self) {
	self->priv = DESKTOP_LAUNCH_LISTENER_GET_PRIVATE (self);
	self->priv->_enabled = TRUE;
	self->priv->_register = TRUE;
	self->priv->launched_signal_id = (guint) 0;
}


static void desktop_launch_listener_finalize (GObject* obj) {
	DesktopLaunchListener * self;
	self = DESKTOP_LAUNCH_LISTENER (obj);
	_g_free0 (self->priv->_unique_id);
	_g_free0 (self->priv->_name);
	_g_free0 (self->priv->_description);
	_g_object_unref0 (self->priv->_datahub);
	_g_object_unref0 (self->priv->bus);
	G_OBJECT_CLASS (desktop_launch_listener_parent_class)->finalize (obj);
}


GType desktop_launch_listener_get_type (void) {
	static volatile gsize desktop_launch_listener_type_id__volatile = 0;
	if (g_once_init_enter (&desktop_launch_listener_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DesktopLaunchListenerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) desktop_launch_listener_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DesktopLaunchListener), 0, (GInstanceInitFunc) desktop_launch_listener_instance_init, NULL };
		GType desktop_launch_listener_type_id;
		desktop_launch_listener_type_id = g_type_register_static (TYPE_DATA_PROVIDER, "DesktopLaunchListener", &g_define_type_info, 0);
		g_once_init_leave (&desktop_launch_listener_type_id__volatile, desktop_launch_listener_type_id);
	}
	return desktop_launch_listener_type_id__volatile;
}


static void _vala_desktop_launch_listener_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DesktopLaunchListener * self;
	self = DESKTOP_LAUNCH_LISTENER (object);
	switch (property_id) {
		case DESKTOP_LAUNCH_LISTENER_UNIQUE_ID:
		g_value_set_string (value, data_provider_get_unique_id ((DataProvider*) self));
		break;
		case DESKTOP_LAUNCH_LISTENER_NAME:
		g_value_set_string (value, data_provider_get_name ((DataProvider*) self));
		break;
		case DESKTOP_LAUNCH_LISTENER_DESCRIPTION:
		g_value_set_string (value, data_provider_get_description ((DataProvider*) self));
		break;
		case DESKTOP_LAUNCH_LISTENER_DATAHUB:
		g_value_set_object (value, data_provider_get_datahub ((DataProvider*) self));
		break;
		case DESKTOP_LAUNCH_LISTENER_ENABLED:
		g_value_set_boolean (value, data_provider_get_enabled ((DataProvider*) self));
		break;
		case DESKTOP_LAUNCH_LISTENER_REGISTER:
		g_value_set_boolean (value, data_provider_get_register ((DataProvider*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_desktop_launch_listener_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	DesktopLaunchListener * self;
	self = DESKTOP_LAUNCH_LISTENER (object);
	switch (property_id) {
		case DESKTOP_LAUNCH_LISTENER_UNIQUE_ID:
		data_provider_set_unique_id ((DataProvider*) self, g_value_get_string (value));
		break;
		case DESKTOP_LAUNCH_LISTENER_NAME:
		data_provider_set_name ((DataProvider*) self, g_value_get_string (value));
		break;
		case DESKTOP_LAUNCH_LISTENER_DESCRIPTION:
		data_provider_set_description ((DataProvider*) self, g_value_get_string (value));
		break;
		case DESKTOP_LAUNCH_LISTENER_DATAHUB:
		data_provider_set_datahub ((DataProvider*) self, g_value_get_object (value));
		break;
		case DESKTOP_LAUNCH_LISTENER_ENABLED:
		data_provider_set_enabled ((DataProvider*) self, g_value_get_boolean (value));
		break;
		case DESKTOP_LAUNCH_LISTENER_REGISTER:
		data_provider_set_register ((DataProvider*) self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



