#ifndef file_option_h
#define file_option_h

#include "arg.h"

/* 
   This Options are located in an extra module
   cause they are depending on some CppDir functions.
*/

namespace Arg {

  enum FileType
    {
      FILE_ANY,
      FILE_DIR,
      FILE_LINK,
      FILE_REGULAR,
      FILE_LINK_TO_DIR,
      FILE_LINK_TO_REGULAR
    };


  class FileOptionRule : public AnyStringRule
    {
    protected:
      FileType type;

    public:
      FileOptionRule( FileType type = FILE_ANY );

      bool match( const std::string &value ) const;
    };

  class FileOption : public StringOption
    {
    public:
      FileOption( FileType type = FILE_ANY );
      FileOption( const std::string &name, FileType type = FILE_ANY );      
    };

  class EmptyFileOption : public EmptyStringOption
    {
    public:
      EmptyFileOption( FileType type = FILE_ANY );

    };
}

#endif
