/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "SidIdDialog.h"

#include <qvariant.h>
#include <qfiledialog.h>
#include <qpushbutton.h>
#include <qlabel.h>
#include <qlineedit.h>
#include <qframe.h>
#include <qlayout.h>
#include <qtooltip.h>
#include <qwhatsthis.h>
#include <qmessagebox.h> 

/*
 *  Constructs a SidIdDialogData as a child of 'parent', with the
 *  name 'name' and widget flags set to 'f'.
 *
 *  The dialog will by default be modeless, unless you set 'modal' to
 *  TRUE to construct a modal dialog.
 */
SidIdDialog::SidIdDialog( QWidget* parent, const char* name, bool modal, WFlags fl )
    : SidIdDialogData( parent, name, modal, fl )
{ 
  mySidId=NULL;
}

/*
 *  Destroys the object and frees any allocated resources
 */
SidIdDialog::~SidIdDialog()
{
  mySidId=NULL;
}

void SidIdDialog::setConfig(const SidIdConfig& inConfig)
{
    config = inConfig;
    backupConfig = inConfig;
    update();
}

const SidIdConfig& SidIdDialog::getConfig() const
{
    return config;
}

/**
 * Set the sidId to use
 *
 * @param sidId the SidId to use
 */
void SidIdDialog::setSidId(SidId* sidId) {
  mySidId=sidId;
  update();
}


void SidIdDialog::okButtonClicked()
{
   hide();
   backupConfig=config;
   update();
}

void SidIdDialog::cancelButtonClicked()
{
    hide();
    config = backupConfig;
    update();
}

void SidIdDialog::browseButtonClicked()
{
    QString fileName =
        QFileDialog::getOpenFileName("","SidId (*.cfg)", this,"Open File Dialog",
                                          "Select SidId config file");
    if ( !fileName.isEmpty() ) {
       config.sidIdFile.setFile(fileName); // insert name into config
       if (!mySidId->readConfig(fileName.ascii())) {
         QMessageBox error;
         error.setIcon(QMessageBox::Warning);
         error.setText("Invalid or damaged SidId cfg file!");
         error.adjustSize();
         error.exec();
       }
    }
    update();
}

void SidIdDialog::update() {
  // insert the file into the text field
  sidIdPathLineEdit->setText(config.sidIdFile.filePath());
  if (mySidId==NULL) return;   // avoid to manage empty reference

  nPlayerTextLabel->setNum((int)mySidId->getNumberOfPlayers());
  nPatternTextLabel->setNum((int)mySidId->getNumberOfPatterns());
}
