/*
 * Copyright (c) 2001-2008
 *     DecisionSoft Limited. All rights reserved.
 * Copyright (c) 2004-2008
 *     Oracle. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * $Id: XQDocumentConstructor.hpp 659 2008-10-06 00:11:22Z jpcs $
 */

#ifndef XQDOCUMENTCONSTRUCTOR_HPP
#define XQDOCUMENTCONSTRUCTOR_HPP

#include <xqilla/ast/XQDOMConstructor.hpp>
#include <xqilla/events/EventHandler.hpp>

class XQILLA_API XQDocumentConstructor : public XQDOMConstructor
{
public:
  XQDocumentConstructor(ASTNode *value, XPath2MemoryManager* expr);

  virtual EventGenerator::Ptr generateEvents(EventHandler *events, DynamicContext *context,
                              bool preserveNS, bool preserveType) const;
  virtual ASTNode *staticResolution(StaticContext *context);
  virtual ASTNode *staticTypingImpl(StaticContext *context);

  virtual const XMLCh* getNodeType() const;
  virtual ASTNode *getValue() const;

  virtual void setValue(ASTNode *value);

protected:
  ASTNode *m_value;
};

class DocConstructFilter : public EventFilter
{
public:
  DocConstructFilter(EventHandler *next, const LocationInfo *location);

  virtual void startElementEvent(const XMLCh *prefix, const XMLCh *uri, const XMLCh *localname);
  virtual void endElementEvent(const XMLCh *prefix, const XMLCh *uri, const XMLCh *localname,
                               const XMLCh *typeURI, const XMLCh *typeName);
  virtual void attributeEvent(const XMLCh *prefix, const XMLCh *uri, const XMLCh *localname, const XMLCh *value,
                              const XMLCh *typeURI, const XMLCh *typeName);
  virtual void namespaceEvent(const XMLCh *prefix, const XMLCh *uri);

private:
  const LocationInfo *location_;
  unsigned int level_;
};

#endif
