/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.latex;

import org.w3c.dom.Element;
import writer2latex.latex.ConverterHelper;
import writer2latex.latex.ConverterPalette;
import writer2latex.latex.LaTeXDocumentPortion;
import writer2latex.latex.TableFormatter;
import writer2latex.latex.util.BeforeAfter;
import writer2latex.latex.util.Context;
import writer2latex.office.OfficeReader;
import writer2latex.office.TableReader;
import writer2latex.util.Config;
import writer2latex.util.Misc;

public class TableConverter
extends ConverterHelper {
    private boolean bNeedLongtable = false;
    private boolean bNeedSupertabular = false;
    private boolean bNeedTabulary = false;
    private boolean bNeedColortbl = false;
    private boolean bContainsTables = false;

    public TableConverter(OfficeReader ofr, Config config, ConverterPalette palette) {
        super(ofr, config, palette);
    }

    public void appendDeclarations(LaTeXDocumentPortion pack, LaTeXDocumentPortion decl) {
        pack.append("\\usepackage{array}").nl();
        if (this.bNeedLongtable) {
            pack.append("\\usepackage{longtable}").nl();
        }
        if (this.bNeedSupertabular) {
            pack.append("\\usepackage{supertabular}").nl();
        }
        if (this.bNeedTabulary) {
            pack.append("\\usepackage{tabulary}").nl();
        }
        pack.append("\\usepackage{hhline}").nl();
        if (this.bNeedColortbl) {
            pack.append("\\usepackage{colortbl}").nl();
        }
        if (this.bContainsTables) {
            decl.append("\\setlength\\tabcolsep{1mm}").nl();
            decl.append("\\renewcommand\\arraystretch{1.3}").nl();
        }
    }

    public void handleCaption(Element node, LaTeXDocumentPortion ldp, Context oc) {
        ldp.append("\\captionof{table}");
        this.palette.getCaptionCv().handleCaptionBody(node, ldp, oc, true);
    }

    public void handleTable(Element node, Element caption, boolean bCaptionAbove, LaTeXDocumentPortion ldp, Context oc) {
        switch (this.config.tableContent()) {
            case 1: {
                new SingleTableConverter().handleTable(node, caption, bCaptionAbove, ldp, oc);
                this.bContainsTables = true;
                break;
            }
            case 0: {
                break;
            }
            case 2: {
                System.err.println("Warning: Tables are not allowed");
                break;
            }
            case 3: {
                ldp.append("% Error in document: A table was ignored");
            }
        }
    }

    private class SingleTableConverter {
        private TableReader table;
        private TableFormatter formatter;
        private Element caption;
        private boolean bCaptionAbove;
        private BeforeAfter baTable;
        private BeforeAfter baTableAlign;

        private SingleTableConverter() {
        }

        private void handleTable(Element node, Element caption, boolean bCaptionAbove, LaTeXDocumentPortion ldp, Context oc) {
            this.caption = caption;
            this.bCaptionAbove = bCaptionAbove;
            this.table = TableConverter.this.ofr.getTableReader(node);
            this.formatter = new TableFormatter(TableConverter.this.ofr, TableConverter.this.config, TableConverter.this.palette, this.table, !oc.isInMulticols(), oc.isInTable());
            TableConverter.this.bContainsTables = true;
            TableConverter.this.bNeedLongtable = (byte)(TableConverter.this.bNeedLongtable | (this.formatter.isLongtable() ? 1 : 0));
            TableConverter.this.bNeedSupertabular = (byte)(TableConverter.this.bNeedSupertabular | (this.formatter.isSupertabular() ? 1 : 0));
            TableConverter.this.bNeedTabulary = (byte)(TableConverter.this.bNeedTabulary | (this.formatter.isTabulary() ? 1 : 0));
            TableConverter.this.bNeedColortbl = (byte)(TableConverter.this.bNeedColortbl | (this.formatter.isColortbl() ? 1 : 0));
            Context ic = (Context)oc.clone();
            ic.setInTable(true);
            ic.setInSimpleTable(this.formatter.isSimple());
            ic.setNoFootnotes(true);
            this.baTable = new BeforeAfter();
            this.baTableAlign = new BeforeAfter();
            this.formatter.applyTableStyle(this.baTable, this.baTableAlign);
            if (this.formatter.isSupertabular()) {
                this.handleSupertabular(ldp, ic);
            } else if (this.formatter.isLongtable()) {
                this.handleLongtable(ldp, ic);
            } else if (TableConverter.this.config.floatTables() && !ic.isInFrame() && !this.table.isSubTable()) {
                this.handleTableFloat(ldp, ic);
            } else {
                this.handleTabular(ldp, ic);
            }
            TableConverter.this.palette.getNoteCv().flushFootnotes(ldp, oc);
        }

        private void handleSupertabular(LaTeXDocumentPortion ldp, Context oc) {
            ldp.append(this.baTableAlign.getBefore());
            if (this.caption != null) {
                this.handleCaption(this.bCaptionAbove ? "\\topcaption" : "\\bottomcaption", ldp, oc);
            }
            ldp.append("\\tablehead{");
            this.handleHeaderRows(ldp, oc);
            ldp.append("}");
            this.handleHyperTarget(ldp);
            ldp.append(this.baTable.getBefore()).nl();
            this.handleBodyRows(ldp, oc);
            ldp.append(this.baTable.getAfter()).nl();
            ldp.append(this.baTableAlign.getAfter());
        }

        private void handleLongtable(LaTeXDocumentPortion ldp, Context oc) {
            this.handleHyperTarget(ldp);
            ldp.append(this.baTable.getBefore()).nl();
            if (this.caption != null && this.bCaptionAbove) {
                this.handleCaption("\\caption", ldp, oc);
                ldp.append("\\\\").nl();
                this.handleHeaderRows(ldp, oc);
                ldp.nl().append("\\endfirsthead").nl();
            }
            if (this.table.getFirstBodyRow() > 0) {
                this.handleHeaderRows(ldp, oc);
                ldp.nl().append("\\endhead").nl();
            }
            if (this.caption != null && !this.bCaptionAbove) {
                this.handleCaption("\\caption", ldp, oc);
                ldp.append("\\endlastfoot").nl();
            }
            this.handleBodyRows(ldp, oc);
            ldp.append(this.baTable.getAfter()).nl();
        }

        private void handleTableFloat(LaTeXDocumentPortion ldp, Context oc) {
            ldp.append("\\begin{table}");
            if (TableConverter.this.config.getFloatOptions().length() > 0) {
                ldp.append("[").append(TableConverter.this.config.getFloatOptions()).append("]");
            }
            ldp.nl();
            ldp.append(this.baTableAlign.getBefore());
            if (this.caption != null && this.bCaptionAbove) {
                this.handleCaption("\\caption", ldp, oc);
            }
            this.handleHyperTarget(ldp);
            ldp.append(this.baTable.getBefore()).nl();
            this.handleHeaderRows(ldp, oc);
            ldp.nl();
            this.handleBodyRows(ldp, oc);
            ldp.append(this.baTable.getAfter()).nl();
            if (this.caption != null && !this.bCaptionAbove) {
                this.handleCaption("\\caption", ldp, oc);
            }
            ldp.append(this.baTableAlign.getAfter());
            ldp.append("\\end{table}").nl();
        }

        private void handleTabular(LaTeXDocumentPortion ldp, Context oc) {
            ldp.append(this.baTableAlign.getBefore());
            if (this.caption != null && this.bCaptionAbove) {
                TableConverter.this.handleCaption(this.caption, ldp, oc);
            }
            this.handleHyperTarget(ldp);
            ldp.append(this.baTable.getBefore()).nl();
            if (this.table.getFirstBodyRow() > 0) {
                this.handleHeaderRows(ldp, oc);
                ldp.nl();
            }
            this.handleBodyRows(ldp, oc);
            ldp.append(this.baTable.getAfter()).nl();
            if (this.caption != null && !this.bCaptionAbove) {
                TableConverter.this.handleCaption(this.caption, ldp, oc);
            }
            ldp.append(this.baTableAlign.getAfter());
        }

        private void handleCaption(String sCommand, LaTeXDocumentPortion ldp, Context oc) {
            ldp.append(sCommand);
            TableConverter.this.palette.getCaptionCv().handleCaptionBody(this.caption, ldp, oc, false);
        }

        private void handleHyperTarget(LaTeXDocumentPortion ldp) {
            if (!this.table.isSubTable()) {
                TableConverter.this.palette.getFieldCv().addTarget(this.table.getTableName(), "|table", ldp);
            }
        }

        private void handleHeaderRows(LaTeXDocumentPortion ldp, Context oc) {
            if (this.table.getFirstBodyRow() > 0) {
                String sInter = this.formatter.getInterrowMaterial(0);
                if (sInter.length() > 0) {
                    ldp.append(sInter).nl();
                }
                this.handleRows(0, this.table.getFirstBodyRow(), ldp, oc);
            }
        }

        private void handleBodyRows(LaTeXDocumentPortion ldp, Context oc) {
            String sInter;
            if (this.table.getFirstBodyRow() == 0 && (sInter = this.formatter.getInterrowMaterial(0)).length() > 0) {
                ldp.append(sInter).nl();
            }
            this.handleRows(this.table.getFirstBodyRow(), this.table.getRowCount(), ldp, oc);
            ldp.nl();
        }

        private void handleRows(int nStart, int nEnd, LaTeXDocumentPortion ldp, Context oc) {
            int nColCount = this.table.getColCount();
            int nRow = nStart;
            while (nRow < nEnd) {
                Context icRow = (Context)oc.clone();
                BeforeAfter baRow = new BeforeAfter();
                this.formatter.applyRowStyle(nRow, baRow, icRow);
                if (!baRow.isEmpty()) {
                    ldp.append(baRow.getBefore());
                    if (!this.formatter.isSimple()) {
                        ldp.nl();
                    }
                }
                int nCol = 0;
                while (nCol < nColCount) {
                    int nColSpan;
                    Element cell = (Element)this.table.getCell(nRow, nCol);
                    if ("table:table-cell".equals(cell.getNodeName())) {
                        Context icCell = (Context)icRow.clone();
                        BeforeAfter baCell = new BeforeAfter();
                        this.formatter.applyCellStyle(nRow, nCol, baCell, icCell);
                        ldp.append(baCell.getBefore());
                        if (nCol == nColCount - 1) {
                            icCell.setInLastTableColumn(true);
                        }
                        TableConverter.this.palette.getBlockCv().traverseBlockText(cell, ldp, icCell);
                        ldp.append(baCell.getAfter());
                    }
                    if (nCol + (nColSpan = Misc.getPosInteger(cell.getAttribute("table:number-columns-spanned"), 1)) < nColCount) {
                        if (this.formatter.isSimple()) {
                            ldp.append(" & ");
                        } else {
                            ldp.append(" &").nl();
                        }
                    }
                    nCol += nColSpan;
                }
                ldp.append("\\\\").append(this.formatter.getInterrowMaterial(nRow + 1));
                if (nRow < nEnd - 1) {
                    ldp.nl();
                }
                ++nRow;
            }
        }
    }
}

